/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.evaluation.value.Value;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.util.ArrayUtil;

public class ProgramMethodOptimizationInfo
extends MethodOptimizationInfo {
    private static final Value[] EMPTY_PARAMETERS = new Value[0];
    private volatile boolean hasSideEffects = false;
    private volatile boolean canBeMadePrivate = true;
    private volatile boolean catchesExceptions = false;
    private volatile boolean branchesBackward = false;
    private volatile boolean invokesSuperMethods = false;
    private volatile boolean invokesDynamically = false;
    private volatile boolean accessesPrivateCode = false;
    private volatile boolean accessesPackageCode = false;
    private volatile boolean accessesProtectedCode = false;
    private volatile boolean hasSynchronizedBlock = false;
    private volatile boolean assignsFinalField = false;
    private volatile boolean returnsWithNonEmptyStack = false;
    private volatile int invocationCount = 0;
    private volatile int parameterSize = 0;
    private volatile long usedParameters = 0L;
    private volatile long escapedParameters = 0L;
    private volatile long escapingParameters = 0L;
    private volatile long modifiedParameters = 0L;
    private volatile boolean modifiesAnything = false;
    private volatile Value[] parameters;
    private volatile long returnedParameters = 0L;
    private volatile boolean returnsNewInstances = false;
    private volatile boolean returnsExternalValues = false;

    public ProgramMethodOptimizationInfo(Clazz clazz, Method method) {
        int n = ClassUtil.internalMethodParameterCount(method.getDescriptor(clazz), method.getAccessFlags());
        this.parameters = n == 0 ? EMPTY_PARAMETERS : new Value[n];
    }

    @Override
    public boolean isKept() {
        return false;
    }

    public void setSideEffects() {
        this.hasSideEffects = true;
    }

    @Override
    public boolean hasSideEffects() {
        return !this.hasNoSideEffects && this.hasSideEffects;
    }

    public void setCanNotBeMadePrivate() {
        this.canBeMadePrivate = false;
    }

    @Override
    public boolean canBeMadePrivate() {
        return this.canBeMadePrivate;
    }

    public void setCatchesExceptions() {
        this.catchesExceptions = true;
    }

    @Override
    public boolean catchesExceptions() {
        return this.catchesExceptions;
    }

    public void setBranchesBackward() {
        this.branchesBackward = true;
    }

    @Override
    public boolean branchesBackward() {
        return this.branchesBackward;
    }

    public void setInvokesSuperMethods() {
        this.invokesSuperMethods = true;
    }

    @Override
    public boolean invokesSuperMethods() {
        return this.invokesSuperMethods;
    }

    public void setInvokesDynamically() {
        this.invokesDynamically = true;
    }

    @Override
    public boolean invokesDynamically() {
        return this.invokesDynamically;
    }

    public void setAccessesPrivateCode() {
        this.accessesPrivateCode = true;
    }

    @Override
    public boolean accessesPrivateCode() {
        return this.accessesPrivateCode;
    }

    public void setAccessesPackageCode() {
        this.accessesPackageCode = true;
    }

    @Override
    public boolean accessesPackageCode() {
        return this.accessesPackageCode;
    }

    public void setAccessesProtectedCode() {
        this.accessesProtectedCode = true;
    }

    @Override
    public boolean accessesProtectedCode() {
        return this.accessesProtectedCode;
    }

    public void setHasSynchronizedBlock() {
        this.hasSynchronizedBlock = true;
    }

    @Override
    public boolean hasSynchronizedBlock() {
        return this.hasSynchronizedBlock;
    }

    public void setAssignsFinalField() {
        this.assignsFinalField = true;
    }

    @Override
    public boolean assignsFinalField() {
        return this.assignsFinalField;
    }

    public void setReturnsWithNonEmptyStack() {
        this.returnsWithNonEmptyStack = true;
    }

    @Override
    public boolean returnsWithNonEmptyStack() {
        return this.returnsWithNonEmptyStack;
    }

    public void incrementInvocationCount() {
        ++this.invocationCount;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount;
    }

    public synchronized void setParameterSize(int n) {
        this.parameterSize = n;
    }

    @Override
    public int getParameterSize() {
        return this.parameterSize;
    }

    public synchronized void setParameterUsed(int n) {
        this.usedParameters = this.setBit(this.usedParameters, n);
    }

    public synchronized void updateUsedParameters(long l) {
        this.usedParameters |= l;
    }

    @Override
    public boolean hasUnusedParameters() {
        return this.parameterSize < 64 ? (this.usedParameters | -1L << this.parameterSize) != -1L : this.usedParameters != -1L;
    }

    @Override
    public boolean isParameterUsed(int n) {
        return this.isBitSet(this.usedParameters, n);
    }

    @Override
    public long getUsedParameters() {
        return this.usedParameters;
    }

    public synchronized void insertParameter(int n) {
        this.escapedParameters = this.insertBit(this.escapedParameters, n, 1L);
        this.escapingParameters = this.insertBit(this.escapingParameters, n, 1L);
        this.modifiedParameters = this.insertBit(this.modifiedParameters, n, 1L);
        this.returnedParameters = this.insertBit(this.returnedParameters, n, 1L);
        this.parameters = ArrayUtil.insert(this.parameters, this.parameters.length, n, null);
    }

    public synchronized void removeParameter(int n) {
        this.escapedParameters = this.removeBit(this.escapedParameters, n, 1L);
        this.escapingParameters = this.removeBit(this.escapingParameters, n, 1L);
        this.modifiedParameters = this.removeBit(this.modifiedParameters, n, 1L);
        this.returnedParameters = this.removeBit(this.returnedParameters, n, 1L);
        ArrayUtil.remove(this.parameters, this.parameters.length, n);
    }

    public synchronized void setParameterEscaped(int n) {
        this.escapedParameters = this.setBit(this.escapedParameters, n);
    }

    public synchronized void updateEscapedParameters(long l) {
        this.escapedParameters |= l;
    }

    @Override
    public boolean hasParameterEscaped(int n) {
        return this.isBitSet(this.escapedParameters, n);
    }

    @Override
    public long getEscapedParameters() {
        return this.escapedParameters;
    }

    public synchronized void setParameterEscaping(int n) {
        this.escapingParameters = this.setBit(this.escapingParameters, n);
    }

    public synchronized void updateEscapingParameters(long l) {
        this.escapingParameters |= l;
    }

    @Override
    public boolean isParameterEscaping(int n) {
        return !this.hasNoEscapingParameters && this.isBitSet(this.escapingParameters, n);
    }

    @Override
    public long getEscapingParameters() {
        return this.hasNoEscapingParameters ? 0L : this.escapingParameters;
    }

    public synchronized void setParameterModified(int n) {
        this.modifiedParameters = this.setBit(this.modifiedParameters, n);
    }

    public synchronized void updateModifiedParameters(long l) {
        this.modifiedParameters |= l;
    }

    @Override
    public boolean isParameterModified(int n) {
        return !this.hasNoSideEffects && (!this.hasNoExternalSideEffects || n == 0) && this.isBitSet(this.modifiesAnything ? this.modifiedParameters | this.escapedParameters : this.modifiedParameters, n);
    }

    @Override
    public long getModifiedParameters() {
        return this.hasNoSideEffects ? 0L : (this.hasNoExternalSideEffects ? this.modifiedParameters & 1L : this.modifiedParameters);
    }

    public void setModifiesAnything() {
        this.modifiesAnything = true;
    }

    @Override
    public boolean modifiesAnything() {
        return !this.hasNoExternalSideEffects && this.modifiesAnything;
    }

    public synchronized void generalizeParameterValue(int n, Value value) {
        this.parameters[n] = this.parameters[n] != null ? this.parameters[n].generalize(value) : value;
    }

    @Override
    public Value getParameterValue(int n) {
        return this.parameters != null ? this.parameters[n] : null;
    }

    public synchronized void setParameterReturned(int n) {
        this.returnedParameters = this.setBit(this.returnedParameters, n);
    }

    public synchronized void updateReturnedParameters(long l) {
        this.returnedParameters |= l;
    }

    @Override
    public boolean returnsParameter(int n) {
        return this.isBitSet(this.returnedParameters, n);
    }

    @Override
    public long getReturnedParameters() {
        return this.returnedParameters;
    }

    public void setReturnsNewInstances() {
        this.returnsNewInstances = true;
    }

    @Override
    public boolean returnsNewInstances() {
        return this.returnsNewInstances;
    }

    public void setReturnsExternalValues() {
        this.returnsExternalValues = true;
    }

    @Override
    public boolean returnsExternalValues() {
        return !this.hasNoExternalReturnValues && this.returnsExternalValues;
    }

    public synchronized void generalizeReturnValue(Value value) {
        this.returnValue = this.returnValue != null ? this.returnValue.generalize(value) : value;
    }

    public synchronized void merge(MethodOptimizationInfo methodOptimizationInfo) {
        this.catchesExceptions |= methodOptimizationInfo.catchesExceptions();
        this.branchesBackward |= methodOptimizationInfo.branchesBackward();
        this.invokesSuperMethods |= methodOptimizationInfo.invokesSuperMethods();
        this.invokesDynamically |= methodOptimizationInfo.invokesDynamically();
        this.accessesPrivateCode |= methodOptimizationInfo.accessesPrivateCode();
        this.accessesPackageCode |= methodOptimizationInfo.accessesPackageCode();
        this.accessesProtectedCode |= methodOptimizationInfo.accessesProtectedCode();
        this.hasSynchronizedBlock |= methodOptimizationInfo.hasSynchronizedBlock();
        this.assignsFinalField |= methodOptimizationInfo.assignsFinalField();
    }

    public static void setProgramMethodOptimizationInfo(Clazz clazz, Method method) {
        MethodLinker.lastMember(method).setVisitorInfo(new ProgramMethodOptimizationInfo(clazz, method));
    }

    public static ProgramMethodOptimizationInfo getProgramMethodOptimizationInfo(Method method) {
        return (ProgramMethodOptimizationInfo)MethodLinker.lastMember(method).getVisitorInfo();
    }

    private long setBit(long l, int n) {
        return n < 64 ? l | 1L << n : l;
    }

    private boolean isBitSet(long l, int n) {
        return n >= 64 || (l & 1L << n) != 0L;
    }

    private long insertBit(long l, int n, long l2) {
        long l3 = -1L << n;
        long l4 = l3 ^ 0xFFFFFFFFFFFFFFFFL;
        return (l & l3) << 1 | l & l4 | l2 << n;
    }

    private long removeBit(long l, int n, long l2) {
        long l3 = -1L << n;
        long l4 = l3 ^ 0xFFFFFFFFFFFFFFFFL;
        return (l & l3 << 1) >>> 1 | l & l4 | l2 << 63;
    }
}

