/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.util.ArrayUtil;

class TypeArgumentFinder
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor {
    private final ClassPool programClassPool;
    private final PartialEvaluator partialEvaluator;
    String[] typeArgumentClasses;

    TypeArgumentFinder(ClassPool classPool, PartialEvaluator partialEvaluator) {
        this.programClassPool = classPool;
        this.partialEvaluator = partialEvaluator;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        if (variableInstruction.canonicalOpcode() == 25) {
            LastStoreFinder lastStoreFinder = new LastStoreFinder(variableInstruction.variableIndex);
            codeAttribute.instructionsAccept(clazz, method, 0, n, lastStoreFinder);
            if (lastStoreFinder.lastStore != null) {
                TracedStack tracedStack = this.partialEvaluator.getStackBefore(lastStoreFinder.lastStoreOffset);
                InstructionOffsetValue instructionOffsetValue = tracedStack.getTopProducerValue(0).instructionOffsetValue();
                TypeTokenSignatureFinder typeTokenSignatureFinder = new TypeTokenSignatureFinder();
                for (int i = 0; i < instructionOffsetValue.instructionOffsetCount(); ++i) {
                    int n2 = instructionOffsetValue.instructionOffset(i);
                    codeAttribute.instructionAccept(clazz, method, n2, typeTokenSignatureFinder);
                }
                if (typeTokenSignatureFinder.typeTokenSignature != null) {
                    Clazz[] clazzArray;
                    this.typeArgumentClasses = new String[0];
                    for (Clazz clazz2 : clazzArray = ((TypeTokenSignatureFinder)typeTokenSignatureFinder).typeTokenSignature.referencedClasses) {
                        if (clazz2 == null || clazz2.getName().equals("com/google/gson/reflect/TypeToken")) continue;
                        this.typeArgumentClasses = ArrayUtil.add(this.typeArgumentClasses, this.typeArgumentClasses.length, clazz2.getName());
                    }
                }
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.typeArgumentClasses = new String[]{refConstant.getClassName(clazz)};
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.typeArgumentClasses = new String[]{classConstant.getName(clazz)};
    }

    private class TypeTokenSignatureFinder
    extends SimplifiedVisitor
    implements InstructionVisitor,
    ConstantVisitor,
    AttributeVisitor {
        private SignatureAttribute typeTokenSignature;

        private TypeTokenSignatureFinder() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
            if (methodrefConstant.referencedClass.getName().equals("com/google/gson/reflect/TypeToken") && methodrefConstant.getName(clazz).equals("getType")) {
                TypeArgumentFinder.this.programClassPool.classAccept(methodrefConstant.getClassName(clazz), new AllAttributeVisitor(this));
            }
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
            this.typeTokenSignature = signatureAttribute;
        }
    }

    private static class LastStoreFinder
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private final int variableIndex;
        private int lastStoreOffset;
        private VariableInstruction lastStore;

        public LastStoreFinder(int n) {
            this.variableIndex = n;
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
            if (variableInstruction.variableIndex == this.variableIndex && variableInstruction.canonicalOpcode() == 58) {
                this.lastStoreOffset = n;
                this.lastStore = variableInstruction;
            }
        }
    }
}

