/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.InlineDeserializer;

class InlineDeserializers {
    InlineDeserializers() {
    }

    static class InlineStringDeserializer
    implements InlineDeserializer {
        InlineStringDeserializer() {
        }

        @Override
        public boolean canDeserialize(GsonRuntimeSettings gsonRuntimeSettings) {
            return true;
        }

        @Override
        public void deserialize(ProgramClass programClass, ProgramField programField, CodeAttributeEditor codeAttributeEditor, InstructionSequenceBuilder instructionSequenceBuilder, GsonRuntimeSettings gsonRuntimeSettings) {
            CodeAttributeEditor.Label label = codeAttributeEditor.label();
            CodeAttributeEditor.Label label2 = codeAttributeEditor.label();
            instructionSequenceBuilder.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "peek", "()Lcom/google/gson/stream/JsonToken;").getstatic("com/google/gson/stream/JsonToken", "BOOLEAN", "Lcom/google/gson/stream/JsonToken;").ifacmpeq(label.offset());
            instructionSequenceBuilder.aload(0).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "nextString", "()Ljava/lang/String;").putfield(programClass, programField).goto_(label2.offset());
            instructionSequenceBuilder.label(label).aload(0).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "nextBoolean", "()Z").invokestatic("java/lang/Boolean", "toString", "(Z)Ljava/lang/String;").putfield(programClass, programField).label(label2);
        }
    }

    static class InlinePrimitiveIntegerDeserializer
    implements InlineDeserializer {
        private final Class targetType;

        public InlinePrimitiveIntegerDeserializer() {
            this(null);
        }

        public InlinePrimitiveIntegerDeserializer(Class clazz) {
            this.targetType = clazz;
        }

        @Override
        public boolean canDeserialize(GsonRuntimeSettings gsonRuntimeSettings) {
            return true;
        }

        @Override
        public void deserialize(ProgramClass programClass, ProgramField programField, CodeAttributeEditor codeAttributeEditor, InstructionSequenceBuilder instructionSequenceBuilder, GsonRuntimeSettings gsonRuntimeSettings) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            int n = constantPoolEditor.addClassConstant("java/lang/NumberFormatException", null);
            CodeAttributeEditor.Label label = codeAttributeEditor.label();
            CodeAttributeEditor.Label label2 = codeAttributeEditor.label();
            CodeAttributeEditor.Label label3 = codeAttributeEditor.catch_(label.offset(), label2.offset(), n);
            CodeAttributeEditor.Label label4 = codeAttributeEditor.label();
            instructionSequenceBuilder.label(label).aload(0).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "nextInt", "()I");
            if (this.targetType == Byte.TYPE) {
                instructionSequenceBuilder.i2b();
            } else if (this.targetType == Short.TYPE) {
                instructionSequenceBuilder.i2s();
            }
            instructionSequenceBuilder.putfield(programClass, programField).goto_(label4.offset()).label(label2);
            int n2 = 4;
            instructionSequenceBuilder.label(label3).astore(n2).new_("com/google/gson/JsonSyntaxException").dup().aload(n2).invokespecial("com/google/gson/JsonSyntaxException", "<init>", "(Ljava/lang/Throwable;)V").athrow().label(label4);
        }
    }
}

