/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.SimplifiedClassEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.gson.FieldSignatureCollector;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.InlineSerializer;
import proguard.optimize.gson.InlineSerializers;
import proguard.optimize.gson.OptimizedClassConstants;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.TypeTokenClassBuilder;
import proguard.optimize.info.ProgramMemberOptimizationInfoSetter;
import proguard.util.MultiValueMap;

public class GsonSerializationOptimizer
extends SimplifiedVisitor
implements MemberVisitor,
ClassVisitor,
ElementValueVisitor,
AttributeVisitor,
AnnotationVisitor {
    private static final boolean DEBUG = false;
    private static final Map<String, InlineSerializer> inlineSerializers = new HashMap<String, InlineSerializer>();
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final GsonRuntimeSettings gsonRuntimeSettings;
    private final CodeAttributeEditor codeAttributeEditor;
    private final OptimizedJsonInfo serializationInfo;
    private final boolean supportExposeAnnotation;
    private final MultiValueMap<String, String> injectedClassNameMap;
    private InstructionSequenceBuilder ____;

    public GsonSerializationOptimizer(ClassPool classPool, ClassPool classPool2, GsonRuntimeSettings gsonRuntimeSettings, CodeAttributeEditor codeAttributeEditor, OptimizedJsonInfo optimizedJsonInfo, MultiValueMap<String, String> multiValueMap) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.gsonRuntimeSettings = gsonRuntimeSettings;
        this.codeAttributeEditor = codeAttributeEditor;
        this.serializationInfo = optimizedJsonInfo;
        this.supportExposeAnnotation = gsonRuntimeSettings.excludeFieldsWithoutExposeAnnotation;
        this.injectedClassNameMap = multiValueMap;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2accessFlags &= 0xFFFFFFFD;
        programClass.u2accessFlags |= 1;
        SimplifiedClassEditor simplifiedClassEditor = new SimplifiedClassEditor(programClass);
        this.____ = new InstructionSequenceBuilder(programClass, this.programClassPool, this.libraryClassPool);
        Integer n = this.serializationInfo.classIndices.get(programClass.getName());
        String string = "toJson$" + n;
        String string2 = "toJsonBody$" + n;
        ProgramMethod programMethod = simplifiedClassEditor.addMethod(4097, string, OptimizedClassConstants.METHOD_TYPE_TO_JSON, this.____.return_().instructions());
        programMethod.accept(programClass, (MemberVisitor)new ProgramMemberOptimizationInfoSetter());
        this.codeAttributeEditor.reset(1);
        this.____.aload(2).invokevirtual("com/google/gson/stream/JsonWriter", "beginObject", "()Lcom/google/gson/stream/JsonWriter;");
        this.____.aload(0).aload(1).aload(2).aload(3).invokevirtual(programClass.getName(), string2, OptimizedClassConstants.METHOD_TYPE_TO_JSON_BODY);
        this.____.aload(2).invokevirtual("com/google/gson/stream/JsonWriter", "endObject", "()Lcom/google/gson/stream/JsonWriter;").return_();
        this.codeAttributeEditor.replaceInstruction(0, this.____.instructions());
        programMethod.attributesAccept(programClass, this.codeAttributeEditor);
        this.addToJsonBodyMethod(programClass, simplifiedClassEditor);
        programClass.accept(new MethodLinker());
        simplifiedClassEditor.finishEditing(this.programClassPool, this.libraryClassPool);
    }

    private void addToJsonBodyMethod(ProgramClass programClass, SimplifiedClassEditor simplifiedClassEditor) {
        Integer n = this.serializationInfo.classIndices.get(programClass.getName());
        String string = "toJsonBody$" + n;
        ProgramMethod programMethod = simplifiedClassEditor.addMethod(4100, string, OptimizedClassConstants.METHOD_TYPE_TO_JSON_BODY, this.____.return_().instructions());
        programMethod.accept(programClass, (MemberVisitor)new ProgramMemberOptimizationInfoSetter());
        programMethod.attributesAccept(programClass, new ToJsonCodeAttributeVisitor());
    }

    static {
        inlineSerializers.put("Z", new InlineSerializers.InlinePrimitiveBooleanSerializer());
        inlineSerializers.put("Ljava/lang/Boolean;", new InlineSerializers.InlineBooleanSerializer());
        inlineSerializers.put("B", new InlineSerializers.InlinePrimitiveIntegerSerializer());
        inlineSerializers.put("S", new InlineSerializers.InlinePrimitiveIntegerSerializer());
        inlineSerializers.put("I", new InlineSerializers.InlinePrimitiveIntegerSerializer());
        inlineSerializers.put("Ljava/lang/String;", new InlineSerializers.InlineStringSerializer());
    }

    private class ToJsonCodeAttributeVisitor
    extends SimplifiedVisitor
    implements AttributeVisitor,
    MemberVisitor {
        private int valueLocalIndex;

        private ToJsonCodeAttributeVisitor() {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            GsonSerializationOptimizer.this.codeAttributeEditor.reset(1);
            this.valueLocalIndex = codeAttribute.u2maxLocals;
            clazz.fieldsAccept(new MemberAccessFilter(0, 4104, this));
            if (!clazz.getSuperClass().getName().equals("java/lang/Object")) {
                Integer n = ((GsonSerializationOptimizer)GsonSerializationOptimizer.this).serializationInfo.classIndices.get(clazz.getSuperClass().getName());
                String string = "toJsonBody$" + n;
                GsonSerializationOptimizer.this.____.aload(0).aload(1).aload(2).aload(3).invokevirtual(clazz.getSuperClass().getName(), string, OptimizedClassConstants.METHOD_TYPE_TO_JSON_BODY);
            }
            GsonSerializationOptimizer.this.____.return_();
            GsonSerializationOptimizer.this.codeAttributeEditor.replaceInstruction(0, GsonSerializationOptimizer.this.____.instructions());
            GsonSerializationOptimizer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            OptimizedJsonInfo.ClassJsonInfo classJsonInfo = ((GsonSerializationOptimizer)GsonSerializationOptimizer.this).serializationInfo.classJsonInfos.get(programClass.getName());
            String[] stringArray = classJsonInfo.javaToJsonFieldNames.get(programField.getName(programClass));
            String string = programField.getName(programClass);
            if (stringArray != null) {
                Object object;
                String string2 = programField.getDescriptor(programClass);
                FieldSignatureCollector fieldSignatureCollector = new FieldSignatureCollector();
                programField.attributesAccept(programClass, fieldSignatureCollector);
                boolean bl = false;
                CodeAttributeEditor.Label label = GsonSerializationOptimizer.this.codeAttributeEditor.label();
                if (ClassUtil.isInternalClassType(string2)) {
                    object = GsonSerializationOptimizer.this.codeAttributeEditor.label();
                    GsonSerializationOptimizer.this.____.aload(0).aload(0).getfield(programClass, programField).ifacmpne(((CodeAttributeEditor.Label)object).offset()).goto_(label.offset()).label((Instruction)object);
                }
                if (GsonSerializationOptimizer.this.supportExposeAnnotation && !classJsonInfo.exposedJavaFieldNames.contains(string)) {
                    GsonSerializationOptimizer.this.____.aload(1).getfield("com/google/gson/Gson", "excluder", "Lcom/google/gson/internal/Excluder;").getfield("com/google/gson/internal/Excluder", "requireExpose", "Z").ifne(label.offset());
                }
                object = ((GsonSerializationOptimizer)GsonSerializationOptimizer.this).serializationInfo.jsonFieldIndices.get(stringArray[0]);
                GsonSerializationOptimizer.this.____.aload(3).aload(2).ldc((Integer)object).invokeinterface("proguard/optimize/gson/_OptimizedJsonWriter", "b", "(Lcom/google/gson/stream/JsonWriter;I)V");
                InlineSerializer inlineSerializer = (InlineSerializer)inlineSerializers.get(string2);
                if (inlineSerializer != null && inlineSerializer.canSerialize(GsonSerializationOptimizer.this.programClassPool, GsonSerializationOptimizer.this.gsonRuntimeSettings)) {
                    inlineSerializer.serialize(programClass, programField, GsonSerializationOptimizer.this.codeAttributeEditor, GsonSerializationOptimizer.this.____, GsonSerializationOptimizer.this.gsonRuntimeSettings);
                } else {
                    GsonSerializationOptimizer.this.____.aload(1);
                    block0 : switch (string2.charAt(0)) {
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'F': 
                        case 'I': 
                        case 'J': 
                        case 'S': 
                        case 'Z': {
                            String string3 = ClassUtil.internalNumericClassNameFromPrimitiveType(string2.charAt(0));
                            GsonSerializationOptimizer.this.____.getstatic(string3, "TYPE", "Ljava/lang/Class;");
                            break;
                        }
                        case 'L': {
                            if (fieldSignatureCollector.getFieldSignature() == null) {
                                String string4 = string2.substring(1, string2.length() - 1);
                                Clazz clazz = GsonSerializationOptimizer.this.programClassPool.getClass(string4);
                                if (clazz == null) {
                                    clazz = GsonSerializationOptimizer.this.libraryClassPool.getClass(string4);
                                }
                                GsonSerializationOptimizer.this.____.ldc(string4, clazz);
                                break;
                            }
                            ProgramClass programClass2 = new TypeTokenClassBuilder(programClass, programField, fieldSignatureCollector.getFieldSignature()).build(GsonSerializationOptimizer.this.programClassPool);
                            GsonSerializationOptimizer.this.programClassPool.addClass(programClass2);
                            programClass2.accept(new ClassReferenceInitializer(GsonSerializationOptimizer.this.programClassPool, GsonSerializationOptimizer.this.libraryClassPool));
                            GsonSerializationOptimizer.this.injectedClassNameMap.put(programClass.getName(), programClass2.getName());
                            GsonSerializationOptimizer.this.____.new_(programClass2.getName()).dup().invokespecial(programClass2.getName(), "<init>", "()V");
                            bl = true;
                            break;
                        }
                        case '[': {
                            int n = 1;
                            while (string2.charAt(n) == '[') {
                                ++n;
                            }
                            switch (string2.charAt(n)) {
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'F': 
                                case 'I': 
                                case 'J': 
                                case 'S': 
                                case 'Z': {
                                    String string5 = ClassUtil.internalNumericClassNameFromPrimitiveType(string2.charAt(0));
                                    Clazz clazz = GsonSerializationOptimizer.this.libraryClassPool.getClass(string5);
                                    GsonSerializationOptimizer.this.____.ldc(string2, clazz);
                                    break block0;
                                }
                                case 'L': {
                                    String string6 = string2.substring(2, string2.length() - 1);
                                    Clazz clazz = GsonSerializationOptimizer.this.programClassPool.getClass(string6);
                                    if (clazz == null) {
                                        clazz = GsonSerializationOptimizer.this.libraryClassPool.getClass(string6);
                                    }
                                    GsonSerializationOptimizer.this.____.ldc(string2, clazz);
                                    break block0;
                                }
                            }
                            break;
                        }
                    }
                    GsonSerializationOptimizer.this.____.aload(0).getfield(programClass, programField);
                    switch (string2.charAt(0)) {
                        case 'Z': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                            break;
                        }
                        case 'C': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                            break;
                        }
                        case 'B': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                            break;
                        }
                        case 'S': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                            break;
                        }
                        case 'I': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                            break;
                        }
                        case 'F': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                            break;
                        }
                        case 'J': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                            break;
                        }
                        case 'D': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                        }
                    }
                    GsonSerializationOptimizer.this.____.dup().astore(this.valueLocalIndex);
                    if (bl) {
                        GsonSerializationOptimizer.this.____.invokestatic("proguard/optimize/gson/_GsonUtil", "getTypeAdapter", "(Lcom/google/gson/Gson;Lcom/google/gson/reflect/TypeToken;Ljava/lang/Object;)Lcom/google/gson/TypeAdapter;");
                    } else {
                        GsonSerializationOptimizer.this.____.invokestatic("proguard/optimize/gson/_GsonUtil", "getTypeAdapter", "(Lcom/google/gson/Gson;Ljava/lang/Class;Ljava/lang/Object;)Lcom/google/gson/TypeAdapter;");
                    }
                    GsonSerializationOptimizer.this.____.aload(2).aload(this.valueLocalIndex).invokevirtual("com/google/gson/TypeAdapter", "write", "(Lcom/google/gson/stream/JsonWriter;Ljava/lang/Object;)V");
                }
                GsonSerializationOptimizer.this.____.label(label);
            }
        }
    }
}

