/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllClassVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.gson.GsonBuilderInvocationFinder;
import proguard.optimize.gson.GsonDeserializationInvocationFinder;
import proguard.optimize.gson.GsonDomainClassFinder;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.GsonSerializationInvocationFinder;

public class GsonContext {
    public ClassPool filteredClasses;
    public ClassPool gsonDomainClassPool;
    public ClassPool instanceCreatorClassPool;
    public ClassPool typeAdapterClassPool;
    public GsonRuntimeSettings gsonRuntimeSettings;

    public void setupFor(ClassPool classPool, WarningPrinter warningPrinter) {
        this.filteredClasses = new ClassPool();
        classPool.classesAccept(new ClassNameFilter("!com/google/gson/**", (ClassVisitor)new ClassPoolFiller(this.filteredClasses)));
        this.gsonRuntimeSettings = new GsonRuntimeSettings();
        this.instanceCreatorClassPool = new ClassPool();
        this.typeAdapterClassPool = new ClassPool();
        GsonBuilderInvocationFinder gsonBuilderInvocationFinder = new GsonBuilderInvocationFinder(classPool, this.gsonRuntimeSettings, new ClassPoolFiller(this.instanceCreatorClassPool), new ClassPoolFiller(this.typeAdapterClassPool));
        this.filteredClasses.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(gsonBuilderInvocationFinder))));
        this.gsonDomainClassPool = new ClassPool();
        GsonDomainClassFinder gsonDomainClassFinder = new GsonDomainClassFinder(this.typeAdapterClassPool, this.gsonDomainClassPool, warningPrinter);
        this.filteredClasses.accept(new AllClassVisitor(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new MultiInstructionVisitor(new GsonSerializationInvocationFinder(classPool, gsonDomainClassFinder, warningPrinter), new GsonDeserializationInvocationFinder(classPool, gsonDomainClassFinder, warningPrinter)))))));
    }
}

