/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ParameterUsageMarker;

public class MethodDescriptorShrinker
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor extraMemberVisitor;

    public MethodDescriptorShrinker() {
        this(null);
    }

    public MethodDescriptorShrinker(MemberVisitor memberVisitor) {
        this.extraMemberVisitor = memberVisitor;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string = programMethod.getDescriptor(programClass);
        String string2 = this.shrinkDescriptor(programMethod, string, 0);
        if (!string2.equals(string)) {
            String string3;
            programMethod.attributesAccept(programClass, this);
            String string4 = string3 = programMethod.getName(programClass);
            if (!string3.equals("<init>")) {
                string4 = string4 + '$' + Long.toHexString(Math.abs(string.hashCode()));
            }
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            if (!string4.equals(string3)) {
                programMethod.u2nameIndex = constantPoolEditor.addUtf8Constant(string4);
            }
            programMethod.referencedClasses = this.shrinkReferencedClasses(programMethod, string, 0, programMethod.referencedClasses);
            programMethod.u2descriptorIndex = constantPoolEditor.addUtf8Constant(string2);
            if (this.extraMemberVisitor != null) {
                this.extraMemberVisitor.visitProgramMethod(programClass, programMethod);
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        int n;
        String string = signatureAttribute.getSignature(clazz);
        String string2 = this.shrinkDescriptor(method, string, n = new InternalTypeEnumeration(method.getDescriptor(clazz)).typesSize() - new InternalTypeEnumeration(string).typesSize());
        if (!string2.equals(string)) {
            signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string2);
            signatureAttribute.referencedClasses = this.shrinkReferencedClasses(method, string, n, signatureAttribute.referencedClasses);
        }
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        int[] nArray = parameterAnnotationsAttribute.u2parameterAnnotationsCount;
        Annotation[][] annotationArray = parameterAnnotationsAttribute.parameterAnnotations;
        String string = method.getDescriptor(clazz);
        int n = new InternalTypeEnumeration(string).typeCount() - parameterAnnotationsAttribute.u1parametersCount;
        int n2 = ClassUtil.internalMethodVariableIndex(string, true, n);
        int n3 = n2 + ((method.getAccessFlags() & 8) != 0 ? 0 : 1);
        int n4 = 0;
        int n5 = 0;
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
        for (int i = 0; i < n; ++i) {
            internalTypeEnumeration.nextType();
        }
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string2 = internalTypeEnumeration.nextType();
            if (ParameterUsageMarker.isParameterUsed(method, n3)) {
                nArray[n5] = nArray[n4];
                annotationArray[n5++] = annotationArray[n4];
            }
            ++n4;
            n3 += ClassUtil.internalTypeSize(string2);
        }
        parameterAnnotationsAttribute.u1parametersCount = n5;
        while (n5 < n4) {
            nArray[n5] = 0;
            annotationArray[n5++] = null;
        }
    }

    private String shrinkDescriptor(Method method, String string, int n) {
        int n2 = n + ((method.getAccessFlags() & 8) != 0 ? 0 : 1);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(internalTypeEnumeration.formalTypeParameters());
        stringBuffer.append('(');
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string2 = internalTypeEnumeration.nextType();
            if (ParameterUsageMarker.isParameterUsed(method, n2)) {
                stringBuffer.append(string2);
            }
            n2 += ClassUtil.internalTypeSize(string2);
        }
        stringBuffer.append(')');
        stringBuffer.append(internalTypeEnumeration.returnType());
        return stringBuffer.toString();
    }

    private Clazz[] shrinkReferencedClasses(Method method, String string, int n, Clazz[] clazzArray) {
        if (clazzArray != null) {
            int n2;
            int n3 = n + ((method.getAccessFlags() & 8) != 0 ? 0 : 1);
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
            int n4 = 0;
            int n5 = 0;
            Clazz[] clazzArray2 = internalTypeEnumeration.formalTypeParameters();
            int n6 = new DescriptorClassEnumeration((String)clazzArray2).classCount();
            for (n2 = 0; n2 < n6; ++n2) {
                clazzArray[n5++] = clazzArray[n4++];
            }
            while (internalTypeEnumeration.hasMoreTypes()) {
                clazzArray2 = internalTypeEnumeration.nextType();
                n6 = new DescriptorClassEnumeration((String)clazzArray2).classCount();
                if (ParameterUsageMarker.isParameterUsed(method, n3)) {
                    for (n2 = 0; n2 < n6; ++n2) {
                        clazzArray[n5++] = clazzArray[n4++];
                    }
                } else {
                    n4 += n6;
                }
                n3 += ClassUtil.internalTypeSize((String)clazzArray2);
            }
            clazzArray2 = internalTypeEnumeration.returnType();
            n6 = new DescriptorClassEnumeration((String)clazzArray2).classCount();
            for (n2 = 0; n2 < n6; ++n2) {
                clazzArray[n5++] = clazzArray[n4++];
            }
            if (n5 == 0) {
                clazzArray = null;
            } else if (n5 < n4) {
                clazzArray2 = new Clazz[n5];
                System.arraycopy(clazzArray, 0, clazzArray2, 0, n5);
                clazzArray = clazzArray2;
            }
        }
        return clazzArray;
    }
}

