/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ImplementedClassFilter
implements ClassVisitor {
    private final Clazz implementedClass;
    private final boolean includeImplementedClass;
    private final ClassVisitor acceptedClassVisitor;
    private final ClassVisitor rejectedClassVisitor;

    public ImplementedClassFilter(Clazz clazz, boolean bl, ClassVisitor classVisitor, ClassVisitor classVisitor2) {
        this.implementedClass = clazz;
        this.includeImplementedClass = bl;
        this.acceptedClassVisitor = classVisitor;
        this.rejectedClassVisitor = classVisitor2;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor classVisitor = this.delegateVisitor(programClass);
        if (classVisitor != null) {
            classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        ClassVisitor classVisitor = this.delegateVisitor(libraryClass);
        if (classVisitor != null) {
            classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private ClassVisitor delegateVisitor(Clazz clazz) {
        return clazz.extendsOrImplements(this.implementedClass) && (clazz != this.implementedClass || this.includeImplementedClass) ? this.acceptedClassVisitor : this.rejectedClassVisitor;
    }
}

