/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io;

import java.io.DataInput;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMember;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.io.RuntimeDataInput;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class LibraryClassReader
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor {
    private static final LibraryField[] EMPTY_LIBRARY_FIELDS = new LibraryField[0];
    private static final LibraryMethod[] EMPTY_LIBRARY_METHODS = new LibraryMethod[0];
    private final RuntimeDataInput dataInput;
    private final boolean skipNonPublicClasses;
    private final boolean skipNonPublicClassMembers;
    private Constant[] constantPool;

    public LibraryClassReader(DataInput dataInput, boolean bl, boolean bl2) {
        this.dataInput = new RuntimeDataInput(dataInput);
        this.skipNonPublicClasses = bl;
        this.skipNonPublicClassMembers = bl2;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        LibraryMethod[] libraryMethodArray;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.dataInput.readInt();
        ClassUtil.checkMagicNumber(n5);
        int n6 = this.dataInput.readUnsignedShort();
        int n7 = this.dataInput.readUnsignedShort();
        int n8 = ClassUtil.internalClassVersion(n7, n6);
        ClassUtil.checkVersionNumbers(n8);
        int n9 = this.dataInput.readUnsignedShort();
        this.constantPool = new Constant[n9];
        for (n4 = 1; n4 < n9; ++n4) {
            Constant constant = this.createConstant();
            constant.accept(libraryClass, this);
            n3 = constant.getTag();
            if (n3 == 7 || n3 == 1) {
                this.constantPool[n4] = constant;
            }
            if (n3 != 5 && n3 != 6) continue;
            ++n4;
        }
        libraryClass.u2accessFlags = this.dataInput.readUnsignedShort();
        if (this.skipNonPublicClasses && AccessUtil.accessLevel(libraryClass.getAccessFlags()) < 3) {
            return;
        }
        n4 = this.dataInput.readUnsignedShort();
        int n10 = this.dataInput.readUnsignedShort();
        libraryClass.thisClassName = this.getClassName(n4);
        libraryClass.superClassName = n10 == 0 ? null : this.getClassName(n10);
        n3 = this.dataInput.readUnsignedShort();
        libraryClass.interfaceNames = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            int n11 = this.dataInput.readUnsignedShort();
            libraryClass.interfaceNames[n2] = this.getClassName(n11);
        }
        n2 = this.dataInput.readUnsignedShort();
        LibraryField[] libraryFieldArray = new LibraryField[n2];
        int n12 = 0;
        for (n = 0; n < n2; ++n) {
            libraryMethodArray = new LibraryField();
            this.visitLibraryMember(libraryClass, (LibraryMember)libraryMethodArray);
            if (AccessUtil.accessLevel(libraryMethodArray.getAccessFlags()) < (this.skipNonPublicClassMembers ? 2 : 1)) continue;
            libraryFieldArray[n12++] = libraryMethodArray;
        }
        if (n12 == 0) {
            libraryClass.fields = EMPTY_LIBRARY_FIELDS;
        } else {
            libraryClass.fields = new LibraryField[n12];
            System.arraycopy(libraryFieldArray, 0, libraryClass.fields, 0, n12);
        }
        n = this.dataInput.readUnsignedShort();
        libraryMethodArray = new LibraryMethod[n];
        int n13 = 0;
        for (int i = 0; i < n; ++i) {
            LibraryMethod libraryMethod = new LibraryMethod();
            this.visitLibraryMember(libraryClass, libraryMethod);
            if (AccessUtil.accessLevel(libraryMethod.getAccessFlags()) < (this.skipNonPublicClassMembers ? 2 : 1)) continue;
            libraryMethodArray[n13++] = libraryMethod;
        }
        if (n13 == 0) {
            libraryClass.methods = EMPTY_LIBRARY_METHODS;
        } else {
            libraryClass.methods = new LibraryMethod[n13];
            System.arraycopy(libraryMethodArray, 0, libraryClass.methods, 0, n13);
        }
        this.skipAttributes();
    }

    @Override
    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
    }

    @Override
    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        libraryMember.u2accessFlags = this.dataInput.readUnsignedShort();
        libraryMember.name = this.getString(this.dataInput.readUnsignedShort());
        libraryMember.descriptor = this.getString(this.dataInput.readUnsignedShort());
        this.skipAttributes();
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.dataInput.skipBytes(4);
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.dataInput.skipBytes(8);
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.dataInput.skipBytes(4);
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.dataInput.skipBytes(8);
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        char c = this.dataInput.readChar();
        int n = this.dataInput.readInt();
        this.dataInput.skipBytes(this.primitiveSize(c) * n);
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.dataInput.skipBytes(2);
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        int n = this.dataInput.readUnsignedShort();
        byte[] byArray = new byte[n];
        this.dataInput.readFully(byArray);
        utf8Constant.setBytes(byArray);
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        this.dataInput.skipBytes(4);
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.dataInput.skipBytes(4);
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        this.dataInput.skipBytes(3);
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.dataInput.skipBytes(4);
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.u2nameIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        this.dataInput.skipBytes(2);
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        this.dataInput.skipBytes(4);
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        this.dataInput.skipBytes(2);
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        this.dataInput.skipBytes(2);
    }

    private String getClassName(int n) {
        ClassConstant classConstant = (ClassConstant)this.constantPool[n];
        return this.getString(classConstant.u2nameIndex);
    }

    private String getString(int n) {
        return ((Utf8Constant)this.constantPool[n]).getString();
    }

    private Constant createConstant() {
        int n = this.dataInput.readUnsignedByte();
        switch (n) {
            case 3: {
                return new IntegerConstant();
            }
            case 4: {
                return new FloatConstant();
            }
            case 5: {
                return new LongConstant();
            }
            case 6: {
                return new DoubleConstant();
            }
            case 8: {
                return new StringConstant();
            }
            case 1: {
                return new Utf8Constant();
            }
            case 17: {
                return new DynamicConstant();
            }
            case 18: {
                return new InvokeDynamicConstant();
            }
            case 15: {
                return new MethodHandleConstant();
            }
            case 9: {
                return new FieldrefConstant();
            }
            case 10: {
                return new MethodrefConstant();
            }
            case 11: {
                return new InterfaceMethodrefConstant();
            }
            case 7: {
                return new ClassConstant();
            }
            case 16: {
                return new MethodTypeConstant();
            }
            case 12: {
                return new NameAndTypeConstant();
            }
            case 19: {
                return new ModuleConstant();
            }
            case 20: {
                return new PackageConstant();
            }
        }
        throw new RuntimeException("Unknown constant type [" + n + "] in constant pool");
    }

    private void skipAttributes() {
        int n = this.dataInput.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            this.skipAttribute();
        }
    }

    private void skipAttribute() {
        this.dataInput.skipBytes(2);
        int n = this.dataInput.readInt();
        this.dataInput.skipBytes(n);
    }

    private int primitiveSize(char c) {
        switch (c) {
            case 'B': 
            case 'Z': {
                return 1;
            }
            case 'C': 
            case 'S': {
                return 2;
            }
            case 'F': 
            case 'I': {
                return 4;
            }
            case 'D': 
            case 'J': {
                return 8;
            }
        }
        return 0;
    }
}

