/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.AttributeAdder;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.io.ProgramClassReader;
import proguard.classfile.io.ProgramClassWriter;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ArrayUtil;
import proguard.util.StringTransformer;

public class MemberAdder
extends SimplifiedVisitor
implements MemberVisitor {
    private static final boolean DEBUG = false;
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    private final ProgramClass targetClass;
    private final StringTransformer nameTransformer;
    private final MemberVisitor extraMemberVisitor;
    private final ClassEditor classEditor;
    private final ConstantPoolEditor constantPoolEditor;

    public MemberAdder(ProgramClass programClass) {
        this(programClass, null);
    }

    public MemberAdder(ProgramClass programClass, MemberVisitor memberVisitor) {
        this(programClass, null, memberVisitor);
    }

    public MemberAdder(ProgramClass programClass, StringTransformer stringTransformer, MemberVisitor memberVisitor) {
        this.targetClass = programClass;
        this.nameTransformer = stringTransformer;
        this.extraMemberVisitor = memberVisitor;
        this.classEditor = new ClassEditor(programClass);
        this.constantPoolEditor = new ConstantPoolEditor(programClass);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String string = programField.getName(programClass);
        String string2 = programField.getDescriptor(programClass);
        int n = programField.getAccessFlags();
        if (this.nameTransformer != null) {
            string = this.nameTransformer.transform(string);
        }
        ProgramField programField2 = new ProgramField(n, this.constantPoolEditor.addUtf8Constant(string), this.constantPoolEditor.addUtf8Constant(string2), 0, programField.u2attributesCount > 0 ? new Attribute[programField.u2attributesCount] : EMPTY_ATTRIBUTES, programField.referencedClass);
        programField2.setVisitorInfo(programField);
        programField.attributesAccept(programClass, new AttributeAdder(this.targetClass, programField2, false));
        this.classEditor.addField(programField2);
        if (this.extraMemberVisitor != null) {
            this.extraMemberVisitor.visitProgramField(this.targetClass, programField2);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        ProgramMethod programMethod2;
        String string = programMethod.getName(programClass);
        String string2 = programMethod.getDescriptor(programClass);
        int n = programMethod.getAccessFlags();
        if (this.nameTransformer != null) {
            string = this.nameTransformer.transform(string);
        }
        if ((programMethod2 = (ProgramMethod)this.targetClass.findMethod(string, string2)) != null) {
            if ((n & 0x400) != 0) {
                return;
            }
            int n2 = programMethod2.getAccessFlags();
            if ((n2 & 0x400) != 0) {
                programMethod2.u2accessFlags = n & 0xFFFFFFEF;
                programMethod.attributesAccept(programClass, new AttributeAdder(this.targetClass, programMethod2, true));
                return;
            }
        }
        ProgramMethod programMethod3 = new ProgramMethod(n & 0xFFFFFFEF, this.constantPoolEditor.addUtf8Constant(string), this.constantPoolEditor.addUtf8Constant(string2), 0, programMethod.u2attributesCount > 0 ? new Attribute[programMethod.u2attributesCount] : EMPTY_ATTRIBUTES, ArrayUtil.cloneOrNull(programMethod.referencedClasses));
        programMethod3.setVisitorInfo(programMethod);
        programMethod.attributesAccept(programClass, new AttributeAdder(this.targetClass, programMethod3, false));
        this.classEditor.addMethod(programMethod3);
        if (this.extraMemberVisitor != null) {
            this.extraMemberVisitor.visitProgramMethod(this.targetClass, programMethod3);
        }
    }

    private String newUniqueMemberName(String string, String string2) {
        return string.equals("<init>") ? "<init>" : string + '$' + Long.toHexString(Math.abs(string2.hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));){
            ProgramClass programClass = new ProgramClass();
            programClass.accept(new ProgramClassReader(dataInputStream));
            ProgramClass programClass2 = new ProgramClass(programClass.u4version, 1, new Constant[1], programClass.u2accessFlags, 0, 0);
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass2);
            programClass2.u2thisClass = constantPoolEditor.addClassConstant(programClass.getName() + "Copy", null);
            programClass2.u2superClass = constantPoolEditor.addClassConstant("java/lang/Object", null);
            MemberAdder memberAdder = new MemberAdder(programClass2);
            programClass.fieldsAccept(memberAdder);
            programClass.methodsAccept(memberAdder);
            try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string2));){
                programClass2.accept(new ProgramClassWriter(dataOutputStream));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

