/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import proguard.backport.LambdaExpression;
import proguard.backport.LambdaExpressionCollector;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.MemberRemover;
import proguard.classfile.editor.SimplifiedClassEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFlagSetter;
import proguard.classfile.visitor.MemberAccessSetter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.util.MultiValueMap;

public class LambdaExpressionConverter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
InstructionVisitor {
    private static final String LAMBDA_SINGLETON_FIELD_NAME = "INSTANCE";
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final MultiValueMap<String, String> injectedClassNameMap;
    private final ClassVisitor extraClassVisitor;
    private final Map<Integer, LambdaExpression> lambdaExpressionMap;
    private final CodeAttributeEditor codeAttributeEditor;
    private final MemberRemover memberRemover;
    private static final String METHOD_NAME_DESERIALIZE_LAMBDA = "$deserializeLambda$";
    private static final String METHOD_TYPE_DESERIALIZE_LAMBDA = "(Ljava/lang/invoke/SerializedLambda;)Ljava/lang/Object;";

    public LambdaExpressionConverter(ClassPool classPool, ClassPool classPool2, MultiValueMap<String, String> multiValueMap, ClassVisitor classVisitor) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.injectedClassNameMap = multiValueMap;
        this.extraClassVisitor = classVisitor;
        this.lambdaExpressionMap = new HashMap<Integer, LambdaExpression>();
        this.codeAttributeEditor = new CodeAttributeEditor(true, true);
        this.memberRemover = new MemberRemover();
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.lambdaExpressionMap.clear();
        programClass.accept(new LambdaExpressionCollector(this.lambdaExpressionMap));
        for (LambdaExpression lambdaExpression : this.lambdaExpressionMap.values()) {
            ProgramClass programClass2 = this.createLambdaClass(lambdaExpression);
            this.programClassPool.addClass(programClass2);
            this.injectedClassNameMap.put(programClass.getName(), programClass2.getName());
            if (this.extraClassVisitor == null) continue;
            this.extraClassVisitor.visitProgramClass(programClass2);
        }
        if (!this.lambdaExpressionMap.isEmpty()) {
            programClass.accept(new AllMethodVisitor(new AllAttributeVisitor(this)));
            for (LambdaExpression lambdaExpression : this.lambdaExpressionMap.values()) {
                lambdaExpression.lambdaClass.accept(new MultiClassVisitor(new ClassSuperHierarchyInitializer(this.programClassPool, this.libraryClassPool), new ClassSubHierarchyInitializer(), new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool)));
            }
            programClass.methodsAccept(this);
            this.memberRemover.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        if (this.codeAttributeEditor.isModified()) {
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        ProgramClass programClass;
        InvokeDynamicConstant invokeDynamicConstant;
        int n2;
        if (constantInstruction.opcode == -70 && this.lambdaExpressionMap.containsKey(n2 = (invokeDynamicConstant = (InvokeDynamicConstant)(programClass = (ProgramClass)clazz).getConstant(constantInstruction.constantIndex)).getBootstrapMethodAttributeIndex())) {
            LambdaExpression lambdaExpression = this.lambdaExpressionMap.get(n2);
            String string = lambdaExpression.getLambdaClassName();
            InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder(programClass);
            if (lambdaExpression.isStateless()) {
                instructionSequenceBuilder.getstatic(string, LAMBDA_SINGLETON_FIELD_NAME, ClassUtil.internalTypeFromClassName(string));
            } else {
                String string2;
                int n3 = codeAttribute.u2maxLocals;
                String string3 = lambdaExpression.getConstructorDescriptor();
                int n4 = ClassUtil.internalMethodParameterSize(string3);
                if (n4 == 1) {
                    // empty if block
                }
                InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string3);
                ArrayList<String> arrayList = new ArrayList<String>();
                while (internalTypeEnumeration.hasMoreTypes()) {
                    arrayList.add(internalTypeEnumeration.nextType());
                }
                int n5 = n3;
                ListIterator listIterator = arrayList.listIterator(arrayList.size());
                while (listIterator.hasPrevious()) {
                    string2 = (String)listIterator.previous();
                    instructionSequenceBuilder.store(n5, string2);
                    n5 += ClassUtil.internalTypeSize(string2);
                }
                instructionSequenceBuilder.new_(string);
                instructionSequenceBuilder.dup();
                listIterator = arrayList.listIterator();
                while (listIterator.hasNext()) {
                    string2 = (String)listIterator.next();
                    int n6 = ClassUtil.internalTypeSize(string2);
                    instructionSequenceBuilder.load(n5 -= n6, string2);
                }
                instructionSequenceBuilder.invokespecial(string, "<init>", string3);
            }
            this.codeAttributeEditor.replaceInstruction(n, instructionSequenceBuilder.instructions());
        }
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (LambdaExpressionConverter.isDeserializationHook(programClass, programMethod)) {
            this.memberRemover.visitProgramMethod(programClass, programMethod);
        }
    }

    private static boolean isDeserializationHook(Clazz clazz, Method method) {
        return method.getName(clazz).equals(METHOD_NAME_DESERIALIZE_LAMBDA) && method.getDescriptor(clazz).equals(METHOD_TYPE_DESERIALIZE_LAMBDA) && LambdaExpressionConverter.hasFlag(method, 4106);
    }

    private static boolean hasFlag(Member member, int n) {
        return (member.getAccessFlags() & n) == n;
    }

    private ProgramClass createLambdaClass(LambdaExpression lambdaExpression) {
        String[] stringArray;
        String string = lambdaExpression.getLambdaClassName();
        ProgramClass programClass = new ProgramClass(0x310000, 1, new Constant[10], 0, 0, 0);
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
        programClass.u2thisClass = constantPoolEditor.addClassConstant(string, programClass);
        programClass.u2superClass = constantPoolEditor.addClassConstant("java/lang/Object", null);
        ClassEditor classEditor = new ClassEditor(programClass);
        for (String string2 : stringArray = lambdaExpression.interfaces) {
            classEditor.addInterface(constantPoolEditor.addClassConstant(string2, null));
        }
        lambdaExpression.lambdaClass = programClass;
        if (lambdaExpression.referencesPrivateSyntheticInterfaceMethod()) {
            this.fixInterfaceLambdaMethod(lambdaExpression.referencedClass, (ProgramMethod)lambdaExpression.referencedInvokedMethod, lambdaExpression);
        } else if (lambdaExpression.referencesPrivateConstructor() || lambdaExpression.needsAccessorMethod()) {
            this.addAccessorMethod(lambdaExpression.referencedClass, lambdaExpression);
        }
        if (lambdaExpression.isStateless()) {
            this.completeStatelessLambdaClass(programClass, lambdaExpression);
        } else {
            this.completeCapturingLambdaClass(programClass, lambdaExpression);
        }
        if (lambdaExpression.bridgeMethodDescriptors.length > 0) {
            this.addBridgeMethods(programClass, lambdaExpression);
        }
        return programClass;
    }

    private void fixInterfaceLambdaMethod(ProgramClass programClass, ProgramMethod programMethod, LambdaExpression lambdaExpression) {
        programMethod.accept(programClass, (MemberVisitor)new MemberAccessSetter(0));
        if ((programMethod.getAccessFlags() & 8) == 0) {
            programMethod.accept(programClass, (MemberVisitor)new MemberAccessFlagSetter(8));
            String string = LambdaExpressionConverter.prependParameterToMethodDescriptor(lambdaExpression.invokedMethodDesc, ClassUtil.internalTypeFromClassType(programClass.getName()));
            programMethod.u2descriptorIndex = new ConstantPoolEditor(programClass).addUtf8Constant(string);
            lambdaExpression.invokedMethodDesc = string;
            lambdaExpression.invokedReferenceKind = 6;
        }
    }

    private void addAccessorMethod(ProgramClass programClass, LambdaExpression lambdaExpression) {
        Object object;
        SimplifiedClassEditor simplifiedClassEditor = new SimplifiedClassEditor(programClass);
        String string = programClass.getName();
        String string2 = ClassUtil.externalShortClassName(ClassUtil.externalClassName(string));
        String string3 = String.format("accessor$%s$lambda%d", string2, lambdaExpression.bootstrapMethodIndex);
        String string4 = lambdaExpression.invokedMethodDesc;
        int n = lambdaExpression.referencedInvokedMethod.getAccessFlags();
        if (lambdaExpression.invokedReferenceKind == 8) {
            object = new ArrayList();
            int n2 = ClassUtil.internalMethodParameterSize(string4);
            for (int i = 0; i < n2; ++i) {
                String string5 = ClassUtil.internalMethodParameterType(string4, i);
                object.add(string5);
            }
            String string6 = ClassUtil.internalTypeFromClassName(lambdaExpression.invokedClassName);
            string4 = ClassUtil.internalMethodDescriptorFromInternalTypes(string6, (List<String>)object);
        } else if ((n & 8) == 0) {
            string4 = LambdaExpressionConverter.prependParameterToMethodDescriptor(string4, ClassUtil.internalTypeFromClassType(string));
        }
        object = simplifiedClassEditor.addMethod(4104, string3, string4, 50);
        if (lambdaExpression.invokedReferenceKind == 8) {
            ((CompactCodeAttributeComposer)object).new_(lambdaExpression.invokedClassName).dup();
        }
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string4);
        this.completeInterfaceMethod(lambdaExpression, (CompactCodeAttributeComposer)object, 0, internalTypeEnumeration, null);
        simplifiedClassEditor.finishEditing();
        lambdaExpression.invokedClassName = programClass.getName();
        lambdaExpression.invokedMethodName = string3;
        lambdaExpression.invokedMethodDesc = string4;
        lambdaExpression.invokedReferenceKind = 6;
        lambdaExpression.referencedInvokedClass = programClass;
        lambdaExpression.referencedInvokedMethod = programClass.findMethod(string3, string4);
    }

    private void completeStatelessLambdaClass(ProgramClass programClass, LambdaExpression lambdaExpression) {
        String string = ClassUtil.internalTypeFromClassName(programClass.getName());
        SimplifiedClassEditor simplifiedClassEditor = new SimplifiedClassEditor(programClass);
        simplifiedClassEditor.addField(25, LAMBDA_SINGLETON_FIELD_NAME, string);
        CompactCodeAttributeComposer compactCodeAttributeComposer = simplifiedClassEditor.addMethod(1, "<init>", "()V", 10);
        compactCodeAttributeComposer.aload_0().invokespecial("java/lang/Object", "<init>", "()V").return_();
        compactCodeAttributeComposer = simplifiedClassEditor.addMethod(8, "<clinit>", "()V", 30);
        compactCodeAttributeComposer.new_(programClass.getName()).dup().invokespecial(programClass.getName(), "<init>", "()V").putstatic(programClass.getName(), LAMBDA_SINGLETON_FIELD_NAME, string).return_();
        if (lambdaExpression.isSerializable()) {
            compactCodeAttributeComposer = simplifiedClassEditor.addMethod(2, "readResolve", "()Ljava/lang/Object;", 10);
            compactCodeAttributeComposer.getstatic(programClass.getName(), LAMBDA_SINGLETON_FIELD_NAME, string).areturn();
        }
        compactCodeAttributeComposer = simplifiedClassEditor.addMethod(1, lambdaExpression.interfaceMethod, lambdaExpression.interfaceMethodDescriptor, 50);
        if (lambdaExpression.invokedReferenceKind == 8) {
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(lambdaExpression.interfaceMethodDescriptor);
            InternalTypeEnumeration internalTypeEnumeration2 = new InternalTypeEnumeration(lambdaExpression.invokedMethodDesc);
            compactCodeAttributeComposer.new_(lambdaExpression.invokedClassName).dup();
            this.completeInterfaceMethod(lambdaExpression, compactCodeAttributeComposer, 1, internalTypeEnumeration, internalTypeEnumeration2);
        } else {
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(lambdaExpression.interfaceMethodDescriptor);
            InternalTypeEnumeration internalTypeEnumeration3 = new InternalTypeEnumeration(lambdaExpression.invokedMethodDesc);
            boolean bl = lambdaExpression.invokedReferenceKind == 5 || lambdaExpression.invokedReferenceKind == 9;
            int n = 1;
            if (bl) {
                String string2 = internalTypeEnumeration.nextType();
                String string3 = ClassUtil.internalTypeFromClassName(lambdaExpression.invokedClassName);
                compactCodeAttributeComposer.load(n, string2);
                n += ClassUtil.internalTypeSize(string2);
                LambdaExpressionConverter.convertToTargetType(string2, string3, compactCodeAttributeComposer);
            }
            this.completeInterfaceMethod(lambdaExpression, compactCodeAttributeComposer, n, internalTypeEnumeration, internalTypeEnumeration3);
        }
        simplifiedClassEditor.finishEditing();
    }

    private void completeCapturingLambdaClass(ProgramClass programClass, LambdaExpression lambdaExpression) {
        Object object;
        SimplifiedClassEditor simplifiedClassEditor = new SimplifiedClassEditor(programClass);
        String string = lambdaExpression.getConstructorDescriptor();
        CompactCodeAttributeComposer compactCodeAttributeComposer = simplifiedClassEditor.addMethod(1, "<init>", string, 50);
        compactCodeAttributeComposer.aload_0().invokespecial("java/lang/Object", "<init>", "()V");
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
        int n = 0;
        int n2 = 1;
        while (internalTypeEnumeration.hasMoreTypes()) {
            object = internalTypeEnumeration.nextType();
            String string2 = "arg$" + n++;
            simplifiedClassEditor.addField(18, string2, (String)object);
            compactCodeAttributeComposer.aload_0();
            compactCodeAttributeComposer.load(n2, (String)object);
            compactCodeAttributeComposer.putfield(programClass.getName(), string2, (String)object);
            n2 += ClassUtil.internalTypeSize((String)object);
        }
        compactCodeAttributeComposer.return_();
        compactCodeAttributeComposer = simplifiedClassEditor.addMethod(1, lambdaExpression.interfaceMethod, lambdaExpression.interfaceMethodDescriptor, 50);
        internalTypeEnumeration = new InternalTypeEnumeration(string);
        object = new InternalTypeEnumeration(lambdaExpression.invokedMethodDesc);
        boolean bl = lambdaExpression.invokedReferenceKind == 5 || lambdaExpression.invokedReferenceKind == 9;
        n = 0;
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string3 = internalTypeEnumeration.nextType();
            String string4 = bl && n == 0 ? null : ((InternalTypeEnumeration)object).nextType();
            String string5 = "arg$" + n++;
            compactCodeAttributeComposer.aload_0().getfield(programClass.getName(), string5, string3);
            if (string4 == null) continue;
            LambdaExpressionConverter.convertToTargetType(string3, string4, compactCodeAttributeComposer);
        }
        internalTypeEnumeration = new InternalTypeEnumeration(lambdaExpression.interfaceMethodDescriptor);
        this.completeInterfaceMethod(lambdaExpression, compactCodeAttributeComposer, 1, internalTypeEnumeration, (InternalTypeEnumeration)object);
        simplifiedClassEditor.finishEditing();
    }

    private void completeInterfaceMethod(LambdaExpression lambdaExpression, CompactCodeAttributeComposer compactCodeAttributeComposer, int n, InternalTypeEnumeration internalTypeEnumeration, InternalTypeEnumeration internalTypeEnumeration2) {
        String string;
        while (internalTypeEnumeration.hasMoreTypes()) {
            string = internalTypeEnumeration.nextType();
            String string2 = internalTypeEnumeration2 != null ? internalTypeEnumeration2.nextType() : null;
            compactCodeAttributeComposer.load(n, string);
            n += ClassUtil.internalTypeSize(string);
            if (string2 == null) continue;
            LambdaExpressionConverter.convertToTargetType(string, string2, compactCodeAttributeComposer);
        }
        switch (lambdaExpression.invokedReferenceKind) {
            case 6: {
                if (lambdaExpression.invokesStaticInterfaceMethod()) {
                    compactCodeAttributeComposer.invokestaticinterface(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                    break;
                }
                compactCodeAttributeComposer.invokestatic(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                break;
            }
            case 5: {
                compactCodeAttributeComposer.invokevirtual(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                break;
            }
            case 9: {
                compactCodeAttributeComposer.invokeinterface(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                break;
            }
            case 7: 
            case 8: {
                compactCodeAttributeComposer.invokespecial(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
            }
        }
        string = internalTypeEnumeration.returnType();
        if (internalTypeEnumeration2 != null) {
            LambdaExpressionConverter.convertToTargetType(internalTypeEnumeration2.returnType(), string, compactCodeAttributeComposer);
        }
        compactCodeAttributeComposer.return_(string);
    }

    private void addBridgeMethods(ProgramClass programClass, LambdaExpression lambdaExpression) {
        SimplifiedClassEditor simplifiedClassEditor = new SimplifiedClassEditor(programClass);
        String string = lambdaExpression.interfaceMethod;
        for (String string2 : lambdaExpression.bridgeMethodDescriptors) {
            String string3;
            Method method = programClass.findMethod(string, string2);
            if (method != null) continue;
            CompactCodeAttributeComposer compactCodeAttributeComposer = simplifiedClassEditor.addMethod(4161, string, string2, 50);
            compactCodeAttributeComposer.aload_0();
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(lambdaExpression.interfaceMethodDescriptor);
            InternalTypeEnumeration internalTypeEnumeration2 = new InternalTypeEnumeration(string2);
            int n = 1;
            while (internalTypeEnumeration2.hasMoreTypes()) {
                string3 = internalTypeEnumeration2.nextType();
                String string4 = internalTypeEnumeration.nextType();
                compactCodeAttributeComposer.load(n, string3);
                n += ClassUtil.internalTypeSize(string3);
                LambdaExpressionConverter.convertToTargetType(string3, string4, compactCodeAttributeComposer);
            }
            compactCodeAttributeComposer.invokevirtual(programClass.getName(), lambdaExpression.interfaceMethod, lambdaExpression.interfaceMethodDescriptor);
            string3 = internalTypeEnumeration2.returnType();
            LambdaExpressionConverter.convertToTargetType(internalTypeEnumeration.returnType(), string3, compactCodeAttributeComposer);
            compactCodeAttributeComposer.return_(string3);
        }
        simplifiedClassEditor.finishEditing();
    }

    private static String prependParameterToMethodDescriptor(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(string2);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
        while (internalTypeEnumeration.hasMoreTypes()) {
            stringBuilder.append(internalTypeEnumeration.nextType());
        }
        stringBuilder.append(')');
        stringBuilder.append(internalTypeEnumeration.returnType());
        return stringBuilder.toString();
    }

    private static void convertToTargetType(String string, String string2, CompactCodeAttributeComposer compactCodeAttributeComposer) {
        if (ClassUtil.isInternalPrimitiveType(string) && !ClassUtil.isInternalPrimitiveType(string2)) {
            switch (string.charAt(0)) {
                case 'I': {
                    compactCodeAttributeComposer.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                    break;
                }
                case 'B': {
                    compactCodeAttributeComposer.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                    break;
                }
                case 'C': {
                    compactCodeAttributeComposer.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                    break;
                }
                case 'S': {
                    compactCodeAttributeComposer.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                    break;
                }
                case 'Z': {
                    compactCodeAttributeComposer.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                    break;
                }
                case 'J': {
                    compactCodeAttributeComposer.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                    break;
                }
                case 'F': {
                    compactCodeAttributeComposer.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                    break;
                }
                case 'D': {
                    compactCodeAttributeComposer.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                }
            }
        } else if (!ClassUtil.isInternalPrimitiveType(string) && ClassUtil.isInternalPrimitiveType(string2)) {
            boolean bl = string.equals("Ljava/lang/Object;");
            switch (string2.charAt(0)) {
                case 'I': {
                    if (bl) {
                        compactCodeAttributeComposer.checkcast("java/lang/Number");
                    }
                    compactCodeAttributeComposer.invokevirtual("java/lang/Number", "intValue", "()I");
                    break;
                }
                case 'B': {
                    if (bl) {
                        compactCodeAttributeComposer.checkcast("java/lang/Byte");
                    }
                    compactCodeAttributeComposer.invokevirtual("java/lang/Byte", "byteValue", "()B");
                    break;
                }
                case 'C': {
                    if (bl) {
                        compactCodeAttributeComposer.checkcast("java/lang/Character");
                    }
                    compactCodeAttributeComposer.invokevirtual("java/lang/Character", "charValue", "()C");
                    break;
                }
                case 'S': {
                    if (bl) {
                        compactCodeAttributeComposer.checkcast("java/lang/Short");
                    }
                    compactCodeAttributeComposer.invokevirtual("java/lang/Short", "shortValue", "()S");
                    break;
                }
                case 'Z': {
                    if (bl) {
                        compactCodeAttributeComposer.checkcast("java/lang/Boolean");
                    }
                    compactCodeAttributeComposer.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
                    break;
                }
                case 'J': {
                    if (bl) {
                        compactCodeAttributeComposer.checkcast("java/lang/Number");
                    }
                    compactCodeAttributeComposer.invokevirtual("java/lang/Number", "longValue", "()J");
                    break;
                }
                case 'F': {
                    if (bl) {
                        compactCodeAttributeComposer.checkcast("java/lang/Number");
                    }
                    compactCodeAttributeComposer.invokevirtual("java/lang/Number", "floatValue", "()F");
                    break;
                }
                case 'D': {
                    if (bl) {
                        compactCodeAttributeComposer.checkcast("java/lang/Number");
                    }
                    compactCodeAttributeComposer.invokevirtual("java/lang/Number", "doubleValue", "()D");
                }
            }
        } else if (ClassUtil.isInternalClassType(string) && (ClassUtil.isInternalClassType(string2) || ClassUtil.isInternalArrayType(string2)) && !string.equals(string2) && !"Ljava/lang/Object;".equals(string2)) {
            compactCodeAttributeComposer.checkcast(ClassUtil.internalClassTypeFromType(string2));
        }
    }
}

