/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.editor.NamedAttributeDeleter;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCollector;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberAccessFlagSetter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.util.StringTransformer;

public class DefaultInterfaceMethodConverter
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor {
    private final ClassVisitor modifiedClassVisitor;
    private final MemberVisitor extraMemberVisitor;
    private final Set<Clazz> implClasses = new LinkedHashSet<Clazz>();
    private boolean hasDefaultMethods;

    public DefaultInterfaceMethodConverter(ClassVisitor classVisitor, MemberVisitor memberVisitor) {
        this.modifiedClassVisitor = classVisitor;
        this.extraMemberVisitor = memberVisitor;
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.hasDefaultMethods = false;
        this.implClasses.clear();
        programClass.hierarchyAccept(false, false, false, true, new ProgramClassFilter(new ClassAccessFilter(0, 512, new ClassCollector(this.implClasses))));
        programClass.accept(new AllMethodVisitor(new MemberAccessFilter(0, 8, new AllAttributeVisitor(this))));
        if (this.hasDefaultMethods) {
            programClass.accept(new ConstantPoolShrinker());
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.hasDefaultMethods = true;
        ProgramClass programClass = (ProgramClass)clazz;
        ProgramMethod programMethod = (ProgramMethod)method;
        for (Clazz clazz2 : this.implClasses) {
            ProgramClass programClass2 = (ProgramClass)clazz2;
            if (!this.hasInheritedMethod(programClass2, programMethod.getName(programClass), programMethod.getDescriptor(programClass))) {
                programMethod.accept(programClass, (MemberVisitor)new MemberAdder(programClass2));
                programClass2.accept(this.modifiedClassVisitor);
            }
            if (!this.callsDefaultMethodUsingSuper(programClass2, programClass, programMethod)) continue;
            this.replaceDefaultMethodInvocation(programClass2, programClass, programMethod);
            programClass2.accept(this.modifiedClassVisitor);
        }
        programMethod.accept(programClass, (MemberVisitor)new MultiMemberVisitor(new NamedAttributeDeleter("Code"), new MemberAccessFlagSetter(1024)));
        if (this.extraMemberVisitor != null) {
            programMethod.accept(programClass, this.extraMemberVisitor);
        }
    }

    private boolean hasInheritedMethod(Clazz clazz, String string, String string2) {
        MemberCounter memberCounter = new MemberCounter();
        clazz.hierarchyAccept(true, true, false, false, new NamedMethodVisitor(string, string2, memberCounter));
        return memberCounter.getCount() > 0;
    }

    private boolean callsDefaultMethodUsingSuper(Clazz clazz, Clazz clazz2, Method method) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        clazz.accept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new SuperInvocationInstructionMatcher(clazz2, method){

            @Override
            public void superInvocation(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, CodeAttributeEditor codeAttributeEditor) {
                atomicBoolean.set(true);
            }
        }))));
        return atomicBoolean.get();
    }

    private void replaceDefaultMethodInvocation(ProgramClass programClass, ProgramClass programClass2, ProgramMethod programMethod) {
        StringTransformer stringTransformer = new StringTransformer(){

            @Override
            public String transform(String string) {
                return "default$" + string;
            }
        };
        programMethod.accept(programClass2, (MemberVisitor)new MemberAdder(programClass, stringTransformer, null));
        String string = stringTransformer.transform(programMethod.getName(programClass2));
        String string2 = programMethod.getDescriptor(programClass2);
        Method method = programClass.findMethod(string, string2);
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
        final int n = constantPoolEditor.addMethodrefConstant(programClass, method);
        programClass.accept(new AllMethodVisitor(new AllAttributeVisitor(new SuperInvocationInstructionMatcher(programClass2, programMethod){

            @Override
            public void superInvocation(Clazz clazz, Method method, CodeAttribute codeAttribute, int n2, CodeAttributeEditor codeAttributeEditor) {
                ConstantInstruction constantInstruction = new ConstantInstruction(-74, n);
                codeAttributeEditor.replaceInstruction(n2, constantInstruction);
            }
        })));
    }

    private static class SuperInvocationInstructionMatcher
    extends SimplifiedVisitor
    implements AttributeVisitor,
    InstructionVisitor,
    ConstantVisitor {
        private final Clazz referencedClass;
        private final Method referencedMethod;
        private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        private boolean matchingInvocation;

        public SuperInvocationInstructionMatcher(Clazz clazz, Method method) {
            this.referencedClass = clazz;
            this.referencedMethod = method;
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
            codeAttribute.instructionsAccept(clazz, method, this);
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -73: {
                    this.matchingInvocation = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                    if (!this.matchingInvocation) break;
                    this.superInvocation(clazz, method, codeAttribute, n, this.codeAttributeEditor);
                }
            }
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
            if (interfaceMethodrefConstant.referencedClass == this.referencedClass && interfaceMethodrefConstant.referencedMember == this.referencedMethod) {
                this.matchingInvocation = true;
            }
        }

        public void superInvocation(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, CodeAttributeEditor codeAttributeEditor) {
        }
    }
}

