/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.io.PrintWriter;
import proguard.Configuration;
import proguard.backport.DefaultInterfaceMethodConverter;
import proguard.backport.JSR310Converter;
import proguard.backport.LambdaExpressionConverter;
import proguard.backport.StaticInterfaceMethodConverter;
import proguard.backport.StreamSupportConverter;
import proguard.backport.StringConcatenationConverter;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeToClassVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.BootstrapMethodsAttributeShrinker;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionCounter;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVersionSetter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.optimize.peephole.InstructionSequencesReplacer;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.util.MultiValueMap;

public class Backporter {
    private final Configuration configuration;

    public Backporter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2, MultiValueMap<String, String> multiValueMap) {
        int n;
        ClassPoolFiller classPoolFiller;
        Object object;
        Object object2;
        Instruction[][][] instructionArray;
        Object object3;
        int n2 = this.configuration.targetClassVersion;
        if (this.configuration.verbose) {
            System.out.println("Backporting class files...");
        }
        PrintWriter printWriter = new PrintWriter(System.err, true);
        classPool.classesAccept(new ClassCleaner());
        classPool2.classesAccept(new ClassCleaner());
        InstructionCounter instructionCounter = new InstructionCounter();
        ClassCounter classCounter = new ClassCounter();
        MemberCounter memberCounter = new MemberCounter();
        MemberCounter memberCounter2 = new MemberCounter();
        InstructionCounter instructionCounter2 = new InstructionCounter();
        InstructionCounter instructionCounter3 = new InstructionCounter();
        InstructionCounter instructionCounter4 = new InstructionCounter();
        if (n2 < 0x350000) {
            object3 = new CodeAttributeEditor(true, true);
            classPool.classesAccept(new ClassVersionFilter(0x350000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AttributeToClassVisitor(new MultiClassVisitor(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer((CodeAttributeEditor)object3, new StringConcatenationConverter(instructionCounter, (CodeAttributeEditor)object3)))), new BootstrapMethodsAttributeShrinker(), new ClassReferenceInitializer(classPool, classPool2)))))));
        }
        if (n2 < 0x340000) {
            object3 = new ClassPool();
            classPool.classesAccept(new ClassVersionFilter(0x340000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AttributeToClassVisitor(new ClassPoolFiller((ClassPool)object3))))));
            ((ClassPool)object3).classesAccept(new MultiClassVisitor(new LambdaExpressionConverter(classPool, classPool2, multiValueMap, classCounter), new BootstrapMethodsAttributeShrinker(), new ClassReferenceInitializer(classPool, classPool2)));
            instructionArray = new ClassPool();
            classPool.classesAccept(new ClassVersionFilter(0x340000, new ClassAccessFilter(512, 0, new ClassPoolFiller((ClassPool)instructionArray))));
            object2 = new ClassPool();
            object = new ClassPoolFiller((ClassPool)object2);
            instructionArray.classesAccept(new MultiClassVisitor(new StaticInterfaceMethodConverter(classPool, classPool2, multiValueMap, (ClassVisitor)object, memberCounter), new DefaultInterfaceMethodConverter((ClassVisitor)object, memberCounter2)));
            ((ClassPool)object2).classesAccept(new ClassReferenceInitializer(classPool, classPool2));
        }
        if (n2 < 0x330000) {
            object3 = new InstructionSequenceBuilder(classPool, classPool2);
            instructionArray = new Instruction[][][]{{((InstructionSequenceBuilder)object3).invokestatic("java/util/Objects", "requireNonNull", "(Ljava/lang/Object;)Ljava/lang/Object;").__(), ((InstructionSequenceBuilder)object3).dup().invokevirtual("java/lang/Object", "getClass", "()Ljava/lang/Class;").pop().__()}, {((InstructionSequenceBuilder)object3).invokevirtual("java/util/Throwable", "addSuppressed", "(Ljava/lang/Throwable;)V").__(), ((InstructionSequenceBuilder)object3).pop().pop().__()}};
            object2 = ((InstructionSequenceBuilder)object3).constants();
            object = new CodeAttributeEditor();
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer(null, (CodeAttributeEditor)object, new InstructionSequencesReplacer((Constant[])object2, instructionArray, null, (CodeAttributeEditor)object, (InstructionVisitor)instructionCounter2)))));
        }
        if (n2 < 0x340000) {
            object3 = new ClassCounter();
            instructionArray = new ClassNameFilter("java8/**", (ClassVisitor)object3);
            classPool.classesAccept((ClassVisitor)instructionArray);
            classPool2.classesAccept((ClassVisitor)instructionArray);
            if (((ClassCounter)object3).getCount() > 0) {
                object2 = new WarningPrinter(printWriter, this.configuration.warn);
                object = new ClassPool();
                classPoolFiller = new ClassPoolFiller((ClassPool)object);
                classPool.classesAccept(new ClassNameFilter("!java8/**", (ClassVisitor)new StreamSupportConverter(classPool, classPool2, (WarningPrinter)object2, classPoolFiller, instructionCounter3)));
                ((ClassPool)object).classesAccept(new ClassReferenceInitializer(classPool, classPool2));
                n = ((WarningPrinter)object2).getWarningCount();
                if (n > 0) {
                    printWriter.println("Warning: there were " + n + " Java 8 stream API method calls that could not be backported.");
                    printWriter.println("      You should check if a your project setup is correct (compileSdkVersion, streamsupport dependency).");
                    printWriter.println("      For more information, consult the section 'Integration->Gradle Plugin->Java 8 stream API support' in our manual");
                }
            }
        }
        if (n2 < 0x340000) {
            object3 = new ClassCounter();
            instructionArray = new ClassNameFilter("org/threeten/bp/**", (ClassVisitor)object3);
            classPool.classesAccept((ClassVisitor)instructionArray);
            classPool2.classesAccept((ClassVisitor)instructionArray);
            if (((ClassCounter)object3).getCount() > 0) {
                object2 = new WarningPrinter(printWriter, this.configuration.warn);
                object = new ClassPool();
                classPoolFiller = new ClassPoolFiller((ClassPool)object);
                classPool.classesAccept(new ClassNameFilter("!org/threeten/bp/**", (ClassVisitor)new JSR310Converter(classPool, classPool2, (WarningPrinter)object2, classPoolFiller, instructionCounter4)));
                ((ClassPool)object).classesAccept(new ClassReferenceInitializer(classPool, classPool2));
                n = ((WarningPrinter)object2).getWarningCount();
                if (n > 0) {
                    printWriter.println("Warning: there were " + n + " Java 8 time API method calls that could not be backported.");
                    printWriter.println("      You should check if a your project setup is correct (compileSdkVersion, threetenbp dependency).");
                    printWriter.println("      For more information, consult the section 'Integration->Gradle Plugin->Java 8 time API support' in our manual");
                }
            }
        }
        if (n2 != 0) {
            classPool.classesAccept(new ClassVersionSetter(n2));
        }
        if (this.configuration.verbose) {
            System.out.println("  Number of converted string concatenations:     " + instructionCounter.getCount());
            System.out.println("  Number of converted lambda expressions:        " + classCounter.getCount());
            System.out.println("  Number of converted static interface methods:  " + memberCounter.getCount());
            System.out.println("  Number of converted default interface methods: " + memberCounter2.getCount());
            System.out.println("  Number of replaced Java 7+ method calls:       " + instructionCounter2.getCount());
            System.out.println("  Number of replaced Java 8 stream method calls: " + instructionCounter3.getCount());
            System.out.println("  Number of replaced Java 8 time method calls:   " + instructionCounter4.getCount());
        }
    }
}

