/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import proguard.ArgumentWordReader;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationConstants;
import proguard.FileWordReader;
import proguard.KeepClassSpecification;
import proguard.LineWordReader;
import proguard.MemberSpecification;
import proguard.MemberValueSpecification;
import proguard.ParseException;
import proguard.WordReader;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class ConfigurationParser {
    private final WordReader reader;
    private final Properties properties;
    private String nextWord;
    private String lastComments;

    public ConfigurationParser(String[] stringArray, Properties properties) throws IOException {
        this(stringArray, null, properties);
    }

    public ConfigurationParser(String[] stringArray, File file, Properties properties) throws IOException {
        this(new ArgumentWordReader(stringArray, file), properties);
    }

    public ConfigurationParser(String string, String string2, File file, Properties properties) throws IOException {
        this(new LineWordReader(new LineNumberReader(new StringReader(string)), string2, file), properties);
    }

    public ConfigurationParser(File file) throws IOException {
        this(file, System.getProperties());
    }

    public ConfigurationParser(File file, Properties properties) throws IOException {
        this(new FileWordReader(file), properties);
    }

    public ConfigurationParser(URL uRL, Properties properties) throws IOException {
        this(new FileWordReader(uRL), properties);
    }

    public ConfigurationParser(WordReader wordReader, Properties properties) throws IOException {
        this.reader = wordReader;
        this.properties = properties;
        this.readNextWord();
    }

    public void parse(Configuration configuration) throws ParseException, IOException {
        while (this.nextWord != null) {
            this.lastComments = this.reader.lastComments();
            if ("@".startsWith(this.nextWord) || "-include".startsWith(this.nextWord)) {
                configuration.lastModified = this.parseIncludeArgument(configuration.lastModified);
                continue;
            }
            if ("-basedirectory".startsWith(this.nextWord)) {
                this.parseBaseDirectoryArgument();
                continue;
            }
            if ("-injars".startsWith(this.nextWord)) {
                configuration.programJars = this.parseClassPathArgument(configuration.programJars, false);
                continue;
            }
            if ("-outjars".startsWith(this.nextWord)) {
                configuration.programJars = this.parseClassPathArgument(configuration.programJars, true);
                continue;
            }
            if ("-libraryjars".startsWith(this.nextWord)) {
                configuration.libraryJars = this.parseClassPathArgument(configuration.libraryJars, false);
                continue;
            }
            if ("-resourcejars".startsWith(this.nextWord)) {
                throw new ParseException("The '-resourcejars' option is no longer supported. Please use the '-injars' option for all input");
            }
            if ("-skipnonpubliclibraryclasses".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClasses = this.parseNoArgument(true);
                continue;
            }
            if ("-dontskipnonpubliclibraryclasses".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClasses = this.parseNoArgument(false);
                continue;
            }
            if ("-dontskipnonpubliclibraryclassmembers".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClassMembers = this.parseNoArgument(false);
                continue;
            }
            if ("-target".startsWith(this.nextWord)) {
                configuration.targetClassVersion = this.parseClassVersion();
                continue;
            }
            if ("-forceprocessing".startsWith(this.nextWord)) {
                configuration.lastModified = this.parseNoArgument(Long.MAX_VALUE);
                continue;
            }
            if ("-if".startsWith(this.nextWord)) {
                configuration.keep = this.parseIfCondition(configuration.keep);
                continue;
            }
            if ("-keep".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, true, false, false, null);
                continue;
            }
            if ("-keepclassmembers".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, false, false, null);
                continue;
            }
            if ("-keepclasseswithmembers".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, true, false, null);
                continue;
            }
            if ("-keepnames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, true, false, true, null);
                continue;
            }
            if ("-keepclassmembernames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, false, true, null);
                continue;
            }
            if ("-keepclasseswithmembernames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, true, true, null);
                continue;
            }
            if ("-printseeds".startsWith(this.nextWord)) {
                configuration.printSeeds = this.parseOptionalFile();
                continue;
            }
            if ("-keepdirectories".startsWith(this.nextWord)) {
                configuration.keepDirectories = this.parseCommaSeparatedList("directory name", true, true, false, true, false, true, true, false, false, configuration.keepDirectories);
                continue;
            }
            if ("-dontshrink".startsWith(this.nextWord)) {
                configuration.shrink = this.parseNoArgument(false);
                continue;
            }
            if ("-printusage".startsWith(this.nextWord)) {
                configuration.printUsage = this.parseOptionalFile();
                continue;
            }
            if ("-whyareyoukeeping".startsWith(this.nextWord)) {
                configuration.whyAreYouKeeping = this.parseKeepClassSpecificationArguments(configuration.whyAreYouKeeping, false, false, false, null);
                continue;
            }
            if ("-dontoptimize".startsWith(this.nextWord)) {
                configuration.optimize = this.parseNoArgument(false);
                continue;
            }
            if ("-optimizationpasses".startsWith(this.nextWord)) {
                configuration.optimizationPasses = this.parseIntegerArgument();
                continue;
            }
            if ("-optimizations".startsWith(this.nextWord)) {
                configuration.optimizations = this.parseCommaSeparatedList("optimization name", true, false, false, false, false, true, false, false, false, configuration.optimizations);
                continue;
            }
            if ("-assumenosideeffects".startsWith(this.nextWord)) {
                configuration.assumeNoSideEffects = this.parseAssumeClassSpecificationArguments(configuration.assumeNoSideEffects);
                continue;
            }
            if ("-assumenoexternalsideeffects".startsWith(this.nextWord)) {
                configuration.assumeNoExternalSideEffects = this.parseAssumeClassSpecificationArguments(configuration.assumeNoExternalSideEffects);
                continue;
            }
            if ("-assumenoescapingparameters".startsWith(this.nextWord)) {
                configuration.assumeNoEscapingParameters = this.parseAssumeClassSpecificationArguments(configuration.assumeNoEscapingParameters);
                continue;
            }
            if ("-assumenoexternalreturnvalues".startsWith(this.nextWord)) {
                configuration.assumeNoExternalReturnValues = this.parseAssumeClassSpecificationArguments(configuration.assumeNoExternalReturnValues);
                continue;
            }
            if ("-assumevalues".startsWith(this.nextWord)) {
                configuration.assumeValues = this.parseAssumeClassSpecificationArguments(configuration.assumeValues);
                continue;
            }
            if ("-allowaccessmodification".startsWith(this.nextWord)) {
                configuration.allowAccessModification = this.parseNoArgument(true);
                continue;
            }
            if ("-mergeinterfacesaggressively".startsWith(this.nextWord)) {
                configuration.mergeInterfacesAggressively = this.parseNoArgument(true);
                continue;
            }
            if ("-dontobfuscate".startsWith(this.nextWord)) {
                configuration.obfuscate = this.parseNoArgument(false);
                continue;
            }
            if ("-printmapping".startsWith(this.nextWord)) {
                configuration.printMapping = this.parseOptionalFile();
                continue;
            }
            if ("-applymapping".startsWith(this.nextWord)) {
                configuration.applyMapping = this.parseFile();
                continue;
            }
            if ("-obfuscationdictionary".startsWith(this.nextWord)) {
                configuration.obfuscationDictionary = this.parseURL();
                continue;
            }
            if ("-classobfuscationdictionary".startsWith(this.nextWord)) {
                configuration.classObfuscationDictionary = this.parseURL();
                continue;
            }
            if ("-packageobfuscationdictionary".startsWith(this.nextWord)) {
                configuration.packageObfuscationDictionary = this.parseURL();
                continue;
            }
            if ("-overloadaggressively".startsWith(this.nextWord)) {
                configuration.overloadAggressively = this.parseNoArgument(true);
                continue;
            }
            if ("-useuniqueclassmembernames".startsWith(this.nextWord)) {
                configuration.useUniqueClassMemberNames = this.parseNoArgument(true);
                continue;
            }
            if ("-dontusemixedcaseclassnames".startsWith(this.nextWord)) {
                configuration.useMixedCaseClassNames = this.parseNoArgument(false);
                continue;
            }
            if ("-keeppackagenames".startsWith(this.nextWord)) {
                configuration.keepPackageNames = this.parseCommaSeparatedList("package name", true, true, false, false, true, false, false, true, false, configuration.keepPackageNames);
                continue;
            }
            if ("-flattenpackagehierarchy".startsWith(this.nextWord)) {
                configuration.flattenPackageHierarchy = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-repackageclasses".startsWith(this.nextWord)) {
                configuration.repackageClasses = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-defaultpackage".startsWith(this.nextWord)) {
                configuration.repackageClasses = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-keepattributes".startsWith(this.nextWord)) {
                configuration.keepAttributes = this.parseCommaSeparatedList("attribute name", true, true, false, false, true, false, false, false, false, configuration.keepAttributes);
                continue;
            }
            if ("-keepparameternames".startsWith(this.nextWord)) {
                configuration.keepParameterNames = this.parseNoArgument(true);
                continue;
            }
            if ("-renamesourcefileattribute".startsWith(this.nextWord)) {
                configuration.newSourceFileAttribute = this.parseOptionalArgument();
                continue;
            }
            if ("-adaptclassstrings".startsWith(this.nextWord)) {
                configuration.adaptClassStrings = this.parseCommaSeparatedList("class name", true, true, false, false, true, false, false, true, false, configuration.adaptClassStrings);
                continue;
            }
            if ("-adaptresourcefilenames".startsWith(this.nextWord)) {
                configuration.adaptResourceFileNames = this.parseCommaSeparatedList("resource file name", true, true, false, true, false, true, false, false, false, configuration.adaptResourceFileNames);
                continue;
            }
            if ("-adaptresourcefilecontents".startsWith(this.nextWord)) {
                configuration.adaptResourceFileContents = this.parseCommaSeparatedList("resource file name", true, true, false, true, false, true, false, false, false, configuration.adaptResourceFileContents);
                continue;
            }
            if ("-dontpreverify".startsWith(this.nextWord)) {
                configuration.preverify = this.parseNoArgument(false);
                continue;
            }
            if ("-microedition".startsWith(this.nextWord)) {
                configuration.microEdition = this.parseNoArgument(true);
                continue;
            }
            if ("-android".startsWith(this.nextWord)) {
                configuration.android = this.parseNoArgument(true);
                continue;
            }
            if ("-verbose".startsWith(this.nextWord)) {
                configuration.verbose = this.parseNoArgument(true);
                continue;
            }
            if ("-dontnote".startsWith(this.nextWord)) {
                configuration.note = this.parseCommaSeparatedList("class name", true, true, false, false, true, false, false, true, false, configuration.note);
                continue;
            }
            if ("-dontwarn".startsWith(this.nextWord)) {
                configuration.warn = this.parseCommaSeparatedList("class name", true, true, false, false, true, false, false, true, false, configuration.warn);
                continue;
            }
            if ("-ignorewarnings".startsWith(this.nextWord)) {
                configuration.ignoreWarnings = this.parseNoArgument(true);
                continue;
            }
            if ("-printconfiguration".startsWith(this.nextWord)) {
                configuration.printConfiguration = this.parseOptionalFile();
                continue;
            }
            if ("-dump".startsWith(this.nextWord)) {
                configuration.dump = this.parseOptionalFile();
                continue;
            }
            if ("-addconfigurationdebugging".startsWith(this.nextWord)) {
                configuration.addConfigurationDebugging = this.parseNoArgument(true);
                continue;
            }
            throw new ParseException("Unknown option " + this.reader.locationDescription());
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private long parseIncludeArgument(long l) throws ParseException, IOException {
        this.readNextWord("configuration file name", true, true, false);
        URL uRL = this.reader.getBaseURL();
        URL uRL2 = null;
        try {
            uRL2 = new URL(this.nextWord);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL2 != null) {
            this.reader.includeWordReader(new FileWordReader(uRL2));
        } else if (uRL != null) {
            uRL2 = new URL(uRL, this.nextWord);
            this.reader.includeWordReader(new FileWordReader(uRL2));
        } else {
            uRL2 = ConfigurationParser.class.getResource(this.nextWord);
            if (uRL2 != null) {
                this.reader.includeWordReader(new FileWordReader(uRL2));
            } else {
                File file = this.file(this.nextWord);
                this.reader.includeWordReader(new FileWordReader(file));
                long l2 = file.lastModified();
                if (l2 > l) {
                    l = l2;
                }
            }
        }
        this.readNextWord();
        return l;
    }

    private void parseBaseDirectoryArgument() throws ParseException, IOException {
        this.readNextWord("base directory name", true, true, false);
        this.reader.setBaseDir(this.file(this.nextWord));
        this.readNextWord();
    }

    private ClassPath parseClassPathArgument(ClassPath classPath, boolean bl) throws ParseException, IOException {
        if (classPath == null) {
            classPath = new ClassPath();
        }
        do {
            this.readNextWord("jar or directory name", true, false, false);
            ClassPathEntry classPathEntry = new ClassPathEntry(this.file(this.nextWord), bl);
            this.readNextWord();
            if (!this.configurationEnd() && "(".equals(this.nextWord)) {
                List[] listArray = new List[7];
                int n = 0;
                do {
                    listArray[n++] = this.parseCommaSeparatedList("filter", true, true, true, true, false, true, true, false, false, null);
                } while (n < listArray.length && ";".equals(this.nextWord));
                if (!")".equals(this.nextWord)) {
                    throw new ParseException("Expecting separating ',' or ';', or closing ')' before " + this.reader.locationDescription());
                }
                classPathEntry.setFilter(listArray[--n]);
                if (n > 0) {
                    classPathEntry.setJarFilter(listArray[--n]);
                    if (n > 0) {
                        classPathEntry.setWarFilter(listArray[--n]);
                        if (n > 0) {
                            classPathEntry.setEarFilter(listArray[--n]);
                            if (n > 0) {
                                classPathEntry.setJmodFilter(listArray[--n]);
                                if (n > 0) {
                                    classPathEntry.setZipFilter(listArray[--n]);
                                    if (n > 0) {
                                        classPathEntry.setApkFilter(listArray[--n]);
                                        if (n > 0) {
                                            classPathEntry.setAarFilter(listArray[--n]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                this.readNextWord();
            }
            classPath.add(classPathEntry);
            if (!this.configurationEnd()) continue;
            return classPath;
        } while (this.nextWord.equals(ConfigurationConstants.JAR_SEPARATOR_KEYWORD));
        throw new ParseException("Expecting class path separator '" + ConfigurationConstants.JAR_SEPARATOR_KEYWORD + "' before " + this.reader.locationDescription());
    }

    private int parseClassVersion() throws ParseException, IOException {
        this.readNextWord("java version");
        int n = ClassUtil.internalClassVersion(this.nextWord);
        if (n == 0) {
            throw new ParseException("Unsupported java version " + this.reader.locationDescription());
        }
        this.readNextWord();
        return n;
    }

    private int parseIntegerArgument() throws ParseException, IOException {
        try {
            this.readNextWord("integer");
            int n = Integer.parseInt(this.nextWord);
            if (n <= 0) {
                throw new ParseException("Expecting value larger than 0, instead of '" + this.nextWord + "' before " + this.reader.locationDescription());
            }
            this.readNextWord();
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Expecting integer argument instead of '" + this.nextWord + "' before " + this.reader.locationDescription());
        }
    }

    private URL parseURL() throws ParseException, IOException {
        this.readNextWord("file name", true, true, false);
        URL uRL = this.url(this.nextWord);
        this.readNextWord();
        return uRL;
    }

    private File parseFile() throws ParseException, IOException {
        this.readNextWord("file name", true, true, false);
        File file = this.file(this.nextWord);
        this.readNextWord();
        return file;
    }

    private File parseOptionalFile() throws ParseException, IOException {
        this.readNextWord(true, true);
        if (this.configurationEnd()) {
            return Configuration.STD_OUT;
        }
        File file = this.file(this.nextWord);
        this.readNextWord();
        return file;
    }

    private String parseOptionalArgument() throws IOException {
        this.readNextWord();
        if (this.configurationEnd()) {
            return "";
        }
        String string = this.nextWord;
        this.readNextWord();
        return string;
    }

    private boolean parseNoArgument(boolean bl) throws IOException {
        this.readNextWord();
        return bl;
    }

    private long parseNoArgument(long l) throws IOException {
        this.readNextWord();
        return l;
    }

    private List parseIfCondition(List list) throws ParseException, IOException {
        this.readNextWord("keyword 'class', 'interface', or 'enum'", false, false, true);
        ClassSpecification classSpecification = this.parseClassSpecificationArguments(false);
        if (this.nextWord == null) {
            throw new ParseException("Expecting '-keep' option after '-if' option, before " + this.reader.locationDescription());
        }
        if ("-keep".startsWith(this.nextWord)) {
            list = this.parseKeepClassSpecificationArguments(list, true, false, false, classSpecification);
        } else if ("-keepclassmembers".startsWith(this.nextWord)) {
            list = this.parseKeepClassSpecificationArguments(list, false, false, false, classSpecification);
        } else if ("-keepclasseswithmembers".startsWith(this.nextWord)) {
            list = this.parseKeepClassSpecificationArguments(list, false, true, false, classSpecification);
        } else if ("-keepnames".startsWith(this.nextWord)) {
            list = this.parseKeepClassSpecificationArguments(list, true, false, true, classSpecification);
        } else if ("-keepclassmembernames".startsWith(this.nextWord)) {
            list = this.parseKeepClassSpecificationArguments(list, false, false, true, classSpecification);
        } else if ("-keepclasseswithmembernames".startsWith(this.nextWord)) {
            list = this.parseKeepClassSpecificationArguments(list, false, true, true, classSpecification);
        } else {
            throw new ParseException("Expecting '-keep' option after '-if' option, before " + this.reader.locationDescription());
        }
        return list;
    }

    private List parseKeepClassSpecificationArguments(List arrayList, boolean bl, boolean bl2, boolean bl3, ClassSpecification classSpecification) throws ParseException, IOException {
        if (arrayList == null) {
            arrayList = new ArrayList<KeepClassSpecification>();
        }
        arrayList.add(this.parseKeepClassSpecificationArguments(bl, bl2, bl3, classSpecification));
        return arrayList;
    }

    private KeepClassSpecification parseKeepClassSpecificationArguments(boolean bl, boolean bl2, boolean bl3, ClassSpecification classSpecification) throws ParseException, IOException {
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        block5: {
            bl7 = false;
            bl6 = false;
            bl5 = false;
            bl4 = false;
            while (true) {
                this.readNextWord("keyword 'class', 'interface', or 'enum'", false, false, true);
                if (!",".equals(this.nextWord)) break block5;
                this.readNextWord("keyword 'allowshrinking', 'allowoptimization', or 'allowobfuscation'");
                if ("includedescriptorclasses".startsWith(this.nextWord)) {
                    bl7 = true;
                    continue;
                }
                if ("includecode".startsWith(this.nextWord)) {
                    bl6 = true;
                    continue;
                }
                if ("allowshrinking".startsWith(this.nextWord)) {
                    bl3 = true;
                    continue;
                }
                if ("allowoptimization".startsWith(this.nextWord)) {
                    bl5 = true;
                    continue;
                }
                if (!"allowobfuscation".startsWith(this.nextWord)) break;
                bl4 = true;
            }
            throw new ParseException("Expecting keyword 'includedescriptorclasses', 'includecode', 'allowshrinking', 'allowoptimization', or 'allowobfuscation' before " + this.reader.locationDescription());
        }
        ClassSpecification classSpecification2 = this.parseClassSpecificationArguments(false);
        return new KeepClassSpecification(bl, bl2, bl7, bl6, bl3, bl5, bl4, classSpecification, classSpecification2);
    }

    private List parseAssumeClassSpecificationArguments(List arrayList) throws ParseException, IOException {
        if (arrayList == null) {
            arrayList = new ArrayList<ClassSpecification>();
        }
        this.readNextWord("keyword 'class', 'interface', or 'enum'", false, false, true);
        arrayList.add(this.parseClassSpecificationArguments(true));
        return arrayList;
    }

    public ClassSpecification parseClassSpecificationArguments() throws ParseException, IOException {
        return this.parseClassSpecificationArguments(false);
    }

    public ClassSpecification parseClassSpecificationArguments(boolean bl) throws ParseException, IOException {
        Object object;
        String string;
        String string2;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while (!"class".equals(this.nextWord)) {
            int n3;
            boolean bl2 = this.nextWord.startsWith("!");
            String string4 = string2 = bl2 ? this.nextWord.substring(1) : this.nextWord;
            int n4 = string2.equals("public") ? 1 : (string2.equals("final") ? 16 : (string2.equals("interface") ? 512 : (string2.equals("abstract") ? 1024 : (string2.equals("synthetic") ? 4096 : (string2.equals("@") ? 8192 : (n3 = string2.equals("enum") ? 16384 : this.unknownAccessFlag()))))));
            if (n3 == 8192) {
                this.readNextWord("annotation type or keyword 'interface'", false, false, false);
                if (!(this.nextWord.equals("interface") || this.nextWord.equals("enum") || this.nextWord.equals("class"))) {
                    string3 = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", false, false, false, false, true, false, false, false, true, null), false);
                    continue;
                }
            }
            if (!bl2) {
                n |= n3;
            } else {
                n2 |= n3;
            }
            if ((n & n2) != 0) {
                throw new ParseException("Conflicting class access modifiers for '" + string2 + "' before " + this.reader.locationDescription());
            }
            if (string2.equals("interface") || string2.equals("enum") || string2.equals("class")) break;
            if (n3 == 8192) continue;
            this.readNextWord("keyword 'class', 'interface', or 'enum'", false, false, true);
        }
        string2 = "*".equals(string = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("class name or interface name", true, false, false, false, true, false, false, false, false, null), false)) ? null : ClassUtil.internalClassName(string);
        String string5 = null;
        String string6 = null;
        if (!this.configurationEnd() && ("implements".equals(this.nextWord) || "extends".equals(this.nextWord))) {
            this.readNextWord("class name or interface name", false, false, true);
            if ("@".equals(this.nextWord)) {
                string5 = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", true, false, false, false, true, false, false, false, true, null), false);
            }
            string6 = "*".equals(object = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("class name or interface name", false, false, false, false, true, false, false, false, false, null), false)) ? null : ClassUtil.internalClassName((String)object);
        }
        object = new ClassSpecification(this.lastComments, n, n2, string3, string2, string5, string6);
        if (!this.configurationEnd()) {
            if (!"{".equals(this.nextWord)) {
                throw new ParseException("Expecting opening '{' at " + this.reader.locationDescription());
            }
            while (true) {
                this.readNextWord("class member description or closing '}'", false, false, true);
                if (this.nextWord.equals("}")) {
                    this.readNextWord();
                    break;
                }
                this.parseMemberSpecificationArguments(string, bl, (ClassSpecification)object);
            }
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseMemberSpecificationArguments(String string, boolean bl, ClassSpecification classSpecification) throws ParseException, IOException {
        String string2;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while (!this.configurationEnd(true)) {
            int n3;
            if ("@".equals(this.nextWord)) {
                string3 = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", true, false, false, false, true, false, false, false, true, null), false);
                continue;
            }
            String string4 = string2 = this.nextWord.startsWith("!") ? this.nextWord.substring(1) : this.nextWord;
            int n4 = string2.equals("public") ? 1 : (string2.equals("private") ? 2 : (string2.equals("protected") ? 4 : (string2.equals("static") ? 8 : (string2.equals("final") ? 16 : (string2.equals("synchronized") ? 32 : (string2.equals("volatile") ? 64 : (string2.equals("transient") ? 128 : (string2.equals("bridge") ? 64 : (string2.equals("varargs") ? 128 : (string2.equals("native") ? 256 : (string2.equals("abstract") ? 1024 : (string2.equals("strictfp") ? 2048 : (n3 = string2.equals("synthetic") ? 4096 : 0)))))))))))));
            if (n3 == 0) break;
            if (string2.equals(this.nextWord)) {
                n |= n3;
            } else {
                n2 |= n3;
            }
            if ((n & n2) != 0) {
                throw new ParseException("Conflicting class member access modifiers for " + this.reader.locationDescription());
            }
            this.readNextWord("class member description");
        }
        if ("*".equals(this.nextWord) || "<fields>".equals(this.nextWord) || "<methods>".equals(this.nextWord)) {
            if ("*".equals(this.nextWord)) {
                this.checkFieldAccessFlags(n, n2);
                this.checkMethodAccessFlags(n, n2);
                classSpecification.addField(new MemberSpecification(n, n2, string3, null, null));
                classSpecification.addMethod(new MemberSpecification(n, n2, string3, null, null));
            } else if ("<fields>".equals(this.nextWord)) {
                this.checkFieldAccessFlags(n, n2);
                classSpecification.addField(new MemberSpecification(n, n2, string3, null, null));
            } else if ("<methods>".equals(this.nextWord)) {
                this.checkMethodAccessFlags(n, n2);
                classSpecification.addMethod(new MemberSpecification(n, n2, string3, null, null));
            }
            this.readNextWord("separator ';'");
            if (";".equals(this.nextWord)) return;
            throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
        }
        this.checkJavaIdentifier("java type");
        string2 = this.nextWord;
        this.readNextWord("class member name");
        String string5 = this.nextWord;
        if ("(".equals(string5)) {
            if (!(string2.equals("<init>") || string2.equals(string) || string2.equals(ClassUtil.externalShortClassName(string)))) {
                throw new ParseException("Expecting type and name instead of just '" + string2 + "' before " + this.reader.locationDescription());
            }
            string2 = "void";
            string5 = "<init>";
        } else {
            this.checkJavaIdentifier("class member name");
            this.readNextWord("opening '(' or separator ';'");
        }
        if (";".equals(this.nextWord)) {
            this.checkFieldAccessFlags(n, n2);
            String string6 = ClassUtil.internalType(string2);
            classSpecification.addField(new MemberSpecification(n, n2, string3, string5, string6));
            return;
        } else if (bl && ("=".equals(this.nextWord) || "return".equals(this.nextWord))) {
            this.checkFieldAccessFlags(n, n2);
            String string7 = ClassUtil.internalType(string2);
            Number[] numberArray = this.parseValues(string2, string7);
            this.readNextWord("separator ';'");
            if (!";".equals(this.nextWord)) {
                throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
            }
            classSpecification.addField(new MemberValueSpecification(n, n2, string3, string5, string7, numberArray));
            return;
        } else {
            if (!"(".equals(this.nextWord)) throw new ParseException("Expecting opening '(' or separator ';' before " + this.reader.locationDescription());
            this.checkMethodAccessFlags(n, n2);
            String string8 = ClassUtil.internalMethodDescriptor(string2, this.parseCommaSeparatedList("argument", true, true, true, false, true, false, false, false, false, null));
            if (!")".equals(this.nextWord)) {
                throw new ParseException("Expecting separating ',' or closing ')' before " + this.reader.locationDescription());
            }
            this.readNextWord("separator ';'");
            if (";".equals(this.nextWord)) {
                classSpecification.addMethod(new MemberSpecification(n, n2, string3, string5, string8));
                return;
            } else {
                if (!bl || !"=".equals(this.nextWord) && !"return".equals(this.nextWord)) throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
                this.checkFieldAccessFlags(n, n2);
                Number[] numberArray = this.parseValues(string2, ClassUtil.internalType(string2));
                this.readNextWord("separator ';'");
                if (!";".equals(this.nextWord)) {
                    throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
                }
                classSpecification.addMethod(new MemberValueSpecification(n, n2, string3, string5, string8, numberArray));
            }
        }
    }

    private Number[] parseValues(String string, String string2) throws ParseException, IOException {
        Number[] numberArray;
        this.readNextWord(string + " constant");
        int n = this.nextWord.indexOf("..");
        if (n >= 0) {
            Number[] numberArray2 = new Number[2];
            numberArray2[0] = this.parseValue(string, string2, this.nextWord.substring(0, n));
            numberArray = numberArray2;
            numberArray2[1] = this.parseValue(string, string2, this.nextWord.substring(n + "..".length()));
        } else {
            Number[] numberArray3 = new Number[1];
            numberArray = numberArray3;
            numberArray3[0] = this.parseValue(string, string2, this.nextWord);
        }
        return numberArray;
    }

    private Number parseValue(String string, String string2, String string3) throws ParseException {
        try {
            string3 = this.replaceSystemProperties(string3);
            switch (string2.charAt(0)) {
                case 'Z': {
                    return this.parseBoolean(string3);
                }
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': {
                    return Integer.decode(string3);
                }
            }
            throw new ParseException("Can't handle '" + string + "' constant " + this.reader.locationDescription());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Can't parse " + string + " constant " + this.reader.locationDescription());
        }
    }

    private Integer parseBoolean(String string) throws ParseException {
        if ("false".equals(this.nextWord)) {
            return 0;
        }
        if ("true".equals(this.nextWord)) {
            return 1;
        }
        throw new ParseException("Unknown boolean constant " + this.reader.locationDescription());
    }

    private List parseCommaSeparatedLists(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, List arrayList) throws ParseException, IOException {
        if (arrayList == null) {
            arrayList = new ArrayList<List>();
        }
        arrayList.add(this.parseCommaSeparatedList(string, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, null));
        return arrayList;
    }

    private List parseCommaSeparatedList(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, List arrayList) throws ParseException, IOException {
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        if (bl) {
            if (!bl2) {
                this.readNextWord(string, bl4, true, false);
            } else if (bl3) {
                this.readNextWord(string, bl4, true, false);
                if (this.nextWord.length() == 0) {
                    this.readNextWord("closing ')'");
                    return arrayList;
                }
                if (this.nextWord.equals(")")) {
                    return arrayList;
                }
            } else {
                this.readNextWord(bl4, true);
                if (this.configurationEnd()) {
                    return arrayList;
                }
            }
        }
        while (true) {
            if (bl5) {
                this.checkJavaIdentifier("java type", bl6);
            }
            if (bl7) {
                this.nextWord = this.replaceSystemProperties(this.nextWord);
            }
            if (bl8) {
                this.nextWord = ClassUtil.internalClassName(this.nextWord);
            }
            if (bl9) {
                this.nextWord = ClassUtil.internalType(this.nextWord);
            }
            arrayList.add(this.nextWord);
            if (bl3) {
                this.readNextWord("separating ',' or closing ')'");
            } else {
                this.readNextWord();
            }
            if (!",".equals(this.nextWord)) {
                return arrayList;
            }
            this.readNextWord(string, bl4, true, false);
        }
    }

    private int unknownAccessFlag() throws ParseException {
        throw new ParseException("Unexpected keyword " + this.reader.locationDescription());
    }

    private URL url(String string) throws ParseException, MalformedURLException {
        String string2 = this.replaceSystemProperties(string);
        try {
            URL uRL = new URL(string2);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            URL uRL;
            URL uRL2 = this.reader.getBaseURL();
            if (uRL2 != null) {
                uRL = new URL(uRL2, string2);
            } else {
                uRL = ConfigurationParser.class.getResource(string2);
                if (uRL == null) {
                    File file = new File(string2);
                    if (!file.isAbsolute()) {
                        file = new File(this.reader.getBaseDir(), string2);
                    }
                    uRL = file.toURI().toURL();
                }
            }
            return uRL;
        }
    }

    private File file(String string) throws ParseException {
        String string2 = this.replaceSystemProperties(string);
        File file = new File(string2);
        if (!file.isAbsolute()) {
            file = new File(this.reader.getBaseDir(), string2);
        }
        return file;
    }

    private String replaceSystemProperties(String string) throws ParseException {
        int n;
        int n2 = 0;
        while ((n2 = string.indexOf(60, n2)) >= 0 && (n = string.indexOf(62, n2 + 1)) >= 0) {
            String string2 = string.substring(n2 + 1, n);
            String string3 = this.properties.getProperty(string2);
            if (string3 == null) {
                throw new ParseException("Value of system property '" + string2 + "' is undefined in " + this.reader.locationDescription());
            }
            string = string.substring(0, n2) + string3 + string.substring(n + 1);
            n2 += string3.length();
        }
        return string;
    }

    private void readNextWord(String string) throws ParseException, IOException {
        this.readNextWord(string, false, false, false);
    }

    private void readNextWord(String string, boolean bl, boolean bl2, boolean bl3) throws ParseException, IOException {
        this.readNextWord(bl, bl2);
        if (this.configurationEnd(bl3)) {
            throw new ParseException("Expecting " + string + " before " + this.reader.locationDescription());
        }
    }

    private void readNextWord() throws IOException {
        this.readNextWord(false, false);
    }

    private void readNextWord(boolean bl, boolean bl2) throws IOException {
        this.nextWord = this.reader.nextWord(bl, bl2);
    }

    private boolean configurationEnd() {
        return this.configurationEnd(false);
    }

    private boolean configurationEnd(boolean bl) {
        return this.nextWord == null || this.nextWord.startsWith("-") || !bl && this.nextWord.equals("@");
    }

    private void checkJavaIdentifier(String string) throws ParseException {
        this.checkJavaIdentifier(string, true);
    }

    private void checkJavaIdentifier(String string, boolean bl) throws ParseException {
        if (!this.isJavaIdentifier(this.nextWord)) {
            throw new ParseException("Expecting " + string + " before " + this.reader.locationDescription());
        }
        if (!bl && this.containsGenerics(this.nextWord)) {
            throw new ParseException("Generics are not allowed (erased) in " + string + " " + this.reader.locationDescription());
        }
    }

    private boolean isJavaIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '[' || c == ']' || c == '<' || c == '>' || c == '-' || c == '!' || c == '*' || c == '?' || c == '%') continue;
            return false;
        }
        return true;
    }

    private boolean containsGenerics(String string) {
        int n = 0;
        int n2;
        while ((n2 = string.indexOf(60, n)) >= 0) {
            int n3 = string.indexOf(62, n2 + 1);
            if (n3 < 0) {
                return false;
            }
            try {
                Integer.parseInt(string.substring(n2 + 1, n3));
            }
            catch (NumberFormatException numberFormatException) {
                return true;
            }
            n = n3 + 1;
        }
        return false;
    }

    private void checkFieldAccessFlags(int n, int n2) throws ParseException {
        if (((n | n2) & 0xFFFFAF20) != 0) {
            throw new ParseException("Invalid method access modifier for field before " + this.reader.locationDescription());
        }
    }

    private void checkMethodAccessFlags(int n, int n2) throws ParseException {
        if (((n | n2) & 0xFFFFE200) != 0) {
            throw new ParseException("Invalid field access modifier for method before " + this.reader.locationDescription());
        }
    }

    public static void main(String[] stringArray) {
        try (ConfigurationParser configurationParser = new ConfigurationParser(stringArray, System.getProperties());){
            configurationParser.parse(new Configuration());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

