/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.TypeAnnotation;
import proguard.classfile.attribute.annotation.TypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.annotation.visitor.TypeAnnotationVisitor;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.LessZeroFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.SameZeroFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ClassCleaner
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
BootstrapMethodInfoVisitor,
ExceptionInfoVisitor,
InnerClassesInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
AnnotationVisitor,
TypeAnnotationVisitor,
ElementValueVisitor {
    public void visitProgramClass(ProgramClass programClass) {
        this.clean(programClass);
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.clean(libraryClass);
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.clean(constant);
    }

    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        this.clean(programMember);
        programMember.attributesAccept(programClass, this);
    }

    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        this.clean(libraryMember);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        this.clean(attribute);
    }

    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        this.clean(bootstrapMethodsAttribute);
        bootstrapMethodsAttribute.bootstrapMethodEntriesAccept(clazz, this);
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        this.clean(innerClassesAttribute);
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        this.clean(exceptionsAttribute);
        exceptionsAttribute.exceptionEntriesAccept((ProgramClass)clazz, this);
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.clean(codeAttribute);
        codeAttribute.exceptionsAccept(clazz, method, this);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.clean(stackMapAttribute);
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.clean(stackMapTableAttribute);
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        this.clean(annotationsAttribute);
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        this.clean(parameterAnnotationsAttribute);
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    public void visitAnyTypeAnnotationsAttribute(Clazz clazz, TypeAnnotationsAttribute typeAnnotationsAttribute) {
        this.clean(typeAnnotationsAttribute);
        typeAnnotationsAttribute.typeAnnotationsAccept(clazz, this);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        this.clean(annotationDefaultAttribute);
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        this.clean(bootstrapMethodInfo);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        this.clean(innerClassesInfo);
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        this.clean(exceptionInfo);
    }

    public void visitSameZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameZeroFrame sameZeroFrame) {
        this.clean(sameZeroFrame);
    }

    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
        this.clean(sameOneFrame);
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitLessZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LessZeroFrame lessZeroFrame) {
        this.clean(lessZeroFrame);
    }

    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
        this.clean(moreZeroFrame);
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
        this.clean(fullFrame);
        fullFrame.variablesAccept(clazz, method, codeAttribute, n, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, n, this);
    }

    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
        this.clean(verificationType);
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.clean(annotation);
        annotation.elementValuesAccept(clazz, this);
    }

    public void visitTypeAnnotation(Clazz clazz, TypeAnnotation typeAnnotation) {
        this.clean(typeAnnotation);
        typeAnnotation.elementValuesAccept(clazz, this);
    }

    public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        this.clean(elementValue);
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.clean(annotationElementValue);
        annotationElementValue.annotationAccept(clazz, this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.clean(arrayElementValue);
    }

    private void clean(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(null);
    }
}

