/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassVisitor;

public class FullyQualifiedClassNameChecker
extends SimplifiedVisitor
implements ClassVisitor {
    private static final String INVALID_CLASS_EXTENSION = ClassUtil.internalClassName(".class");
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;

    public FullyQualifiedClassNameChecker(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.notePrinter = warningPrinter;
    }

    public void checkClassSpecifications(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ClassSpecification classSpecification = (ClassSpecification)list.get(i);
                this.checkType(classSpecification.annotationType);
                this.checkClassName(classSpecification.className);
                this.checkType(classSpecification.extendsAnnotationType);
                this.checkClassName(classSpecification.extendsClassName);
                this.checkMemberSpecifications(classSpecification.fieldSpecifications, true);
                this.checkMemberSpecifications(classSpecification.methodSpecifications, false);
            }
        }
    }

    private void checkMemberSpecifications(List list, boolean bl) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                MemberSpecification memberSpecification = (MemberSpecification)list.get(i);
                this.checkType(memberSpecification.annotationType);
                if (bl) {
                    this.checkType(memberSpecification.descriptor);
                    continue;
                }
                this.checkDescriptor(memberSpecification.descriptor);
            }
        }
    }

    private void checkDescriptor(String string) {
        if (string != null) {
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
            this.checkType(internalTypeEnumeration.returnType());
            while (internalTypeEnumeration.hasMoreTypes()) {
                this.checkType(internalTypeEnumeration.nextType());
            }
        }
    }

    private void checkType(String string) {
        if (string != null) {
            this.checkClassName(ClassUtil.internalClassNameFromType(string));
        }
    }

    private void checkClassName(String string) {
        if (string != null && !FullyQualifiedClassNameChecker.containsWildCards(string) && this.programClassPool.getClass(string) == null && this.libraryClassPool.getClass(string) == null && this.notePrinter.accepts(string)) {
            this.notePrinter.print(string, "Note: the configuration refers to the unknown class '" + ClassUtil.externalClassName(string) + "'");
            int n = string.lastIndexOf(47);
            String string2 = string.endsWith(INVALID_CLASS_EXTENSION) ? string.substring(0, n) : "**/" + string.substring(n + 1);
            ClassNameFilter classNameFilter = new ClassNameFilter(string2, (ClassVisitor)this);
            this.programClassPool.classesAccept(classNameFilter);
            this.libraryClassPool.classesAccept(classNameFilter);
        }
    }

    private static boolean containsWildCards(String string) {
        return string != null && (string.indexOf(33) >= 0 || string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(44) >= 0 || string.indexOf("///") >= 0);
    }

    public void visitAnyClass(Clazz clazz) {
        System.out.println("      Maybe you meant the fully qualified name '" + ClassUtil.externalClassName(clazz.getName()) + "'?");
    }
}

