/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import proguard.classfile.util.ClassUtil;
import proguard.retrace.FrameInfo;

public class FramePattern {
    private static final String REGEX_CLASS = "(?:[^\\s\":./()]+\\.)*[^\\s\":./()]+";
    private static final String REGEX_CLASS_SLASH = "(?:[^\\s\":./()]+/)*[^\\s\":./()]+";
    private static final String REGEX_SOURCE_FILE = "(?:[^:()\\d][^:()]*)?";
    private static final String REGEX_LINE_NUMBER = "-?\\b\\d+\\b";
    private static final String REGEX_TYPE = "(?:[^\\s\":./()]+\\.)*[^\\s\":./()]+(?:\\[\\])*";
    private static final String REGEX_MEMBER = "<?[^\\s\":./()]+>?";
    private static final String REGEX_ARGUMENTS = "(?:(?:[^\\s\":./()]+\\.)*[^\\s\":./()]+(?:\\[\\])*(?:\\s*,\\s*(?:[^\\s\":./()]+\\.)*[^\\s\":./()]+(?:\\[\\])*)*)?";
    private final char[] expressionTypes = new char[32];
    private final int expressionTypeCount;
    private final Pattern pattern;
    private final boolean verbose;

    public FramePattern(String regularExpression, boolean verbose) {
        int nextIndex;
        StringBuffer expressionBuffer = new StringBuffer(regularExpression.length() + 32);
        int expressionTypeCount = 0;
        int index = 0;
        while ((nextIndex = regularExpression.indexOf(37, index)) >= 0 && nextIndex != regularExpression.length() - 1 && expressionTypeCount != this.expressionTypes.length) {
            expressionBuffer.append(regularExpression.substring(index, nextIndex));
            expressionBuffer.append('(');
            char expressionType = regularExpression.charAt(nextIndex + 1);
            switch (expressionType) {
                case 'c': {
                    expressionBuffer.append(REGEX_CLASS);
                    break;
                }
                case 'C': {
                    expressionBuffer.append(REGEX_CLASS_SLASH);
                    break;
                }
                case 's': {
                    expressionBuffer.append(REGEX_SOURCE_FILE);
                    break;
                }
                case 'l': {
                    expressionBuffer.append(REGEX_LINE_NUMBER);
                    break;
                }
                case 't': {
                    expressionBuffer.append(REGEX_TYPE);
                    break;
                }
                case 'f': {
                    expressionBuffer.append(REGEX_MEMBER);
                    break;
                }
                case 'm': {
                    expressionBuffer.append(REGEX_MEMBER);
                    break;
                }
                case 'a': {
                    expressionBuffer.append(REGEX_ARGUMENTS);
                }
            }
            expressionBuffer.append(')');
            this.expressionTypes[expressionTypeCount++] = expressionType;
            index = nextIndex + 2;
        }
        expressionBuffer.append(regularExpression.substring(index));
        this.expressionTypeCount = expressionTypeCount;
        this.pattern = Pattern.compile(expressionBuffer.toString());
        this.verbose = verbose;
    }

    public FrameInfo parse(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        String className = null;
        String sourceFile = null;
        int lineNumber = 0;
        String type = null;
        String fieldName = null;
        String methodName = null;
        String arguments = null;
        block10: for (int expressionTypeIndex = 0; expressionTypeIndex < this.expressionTypeCount; ++expressionTypeIndex) {
            int startIndex = matcher.start(expressionTypeIndex + 1);
            if (startIndex < 0) continue;
            String match = matcher.group(expressionTypeIndex + 1);
            char expressionType = this.expressionTypes[expressionTypeIndex];
            switch (expressionType) {
                case 'c': {
                    className = match;
                    continue block10;
                }
                case 'C': {
                    className = ClassUtil.externalClassName(match);
                    continue block10;
                }
                case 's': {
                    sourceFile = match;
                    continue block10;
                }
                case 'l': {
                    lineNumber = Integer.parseInt(match);
                    continue block10;
                }
                case 't': {
                    type = match;
                    continue block10;
                }
                case 'f': {
                    fieldName = match;
                    continue block10;
                }
                case 'm': {
                    methodName = match;
                    continue block10;
                }
                case 'a': {
                    arguments = match;
                }
            }
        }
        return new FrameInfo(className, sourceFile, lineNumber, type, fieldName, methodName, arguments);
    }

    public String format(String line, FrameInfo frameInfo) {
        Matcher matcher = this.pattern.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        StringBuffer formattedBuffer = new StringBuffer();
        int lineIndex = 0;
        for (int expressionTypeIndex = 0; expressionTypeIndex < this.expressionTypeCount; ++expressionTypeIndex) {
            int startIndex = matcher.start(expressionTypeIndex + 1);
            if (startIndex < 0) continue;
            int endIndex = matcher.end(expressionTypeIndex + 1);
            String match = matcher.group(expressionTypeIndex + 1);
            formattedBuffer.append(line.substring(lineIndex, startIndex));
            char expressionType = this.expressionTypes[expressionTypeIndex];
            switch (expressionType) {
                case 'c': {
                    formattedBuffer.append(frameInfo.getClassName());
                    break;
                }
                case 'C': {
                    formattedBuffer.append(ClassUtil.internalClassName(frameInfo.getClassName()));
                    break;
                }
                case 's': {
                    formattedBuffer.append(frameInfo.getSourceFile());
                    break;
                }
                case 'l': {
                    if (formattedBuffer.charAt(formattedBuffer.length() - 1) != ':') {
                        formattedBuffer.append(':');
                    }
                    formattedBuffer.append(frameInfo.getLineNumber());
                    break;
                }
                case 't': {
                    formattedBuffer.append(frameInfo.getType());
                    break;
                }
                case 'f': {
                    if (this.verbose) {
                        formattedBuffer.append(frameInfo.getType()).append(' ');
                    }
                    formattedBuffer.append(frameInfo.getFieldName());
                    break;
                }
                case 'm': {
                    if (this.verbose) {
                        formattedBuffer.append(frameInfo.getType()).append(' ');
                    }
                    formattedBuffer.append(frameInfo.getMethodName());
                    if (!this.verbose) break;
                    formattedBuffer.append('(').append(frameInfo.getArguments()).append(')');
                    break;
                }
                case 'a': {
                    formattedBuffer.append(frameInfo.getArguments());
                }
            }
            lineIndex = endIndex;
        }
        formattedBuffer.append(line.substring(lineIndex));
        return formattedBuffer.toString();
    }
}

