/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate.kotlin;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.visitor.KotlinClassToDefaultImplsClassVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class KotlinSyntheticClassFixer
implements KotlinMetadataVisitor {
    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        if (kotlinClassKindMetadata.referencedDefaultImplsClass != null) {
            String className = ClassObfuscator.newClassName(kotlinClassKindMetadata.referencedClass);
            String defaultImplsClassName = className.endsWith("$DefaultImpls") ? className : className + "$DefaultImpls";
            kotlinClassKindMetadata.accept(clazz, new KotlinClassToDefaultImplsClassVisitor(new ProgramClassFilter(_clazz -> ClassObfuscator.setNewClassName(_clazz, defaultImplsClassName))));
        }
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        if (kotlinSyntheticClassKindMetadata.flavor == KotlinSyntheticClassKindMetadata.Flavor.WHEN_MAPPINGS) {
            String originalName = ClassObfuscator.newClassName(clazz);
            if (!originalName.endsWith("$WhenMappings")) {
                ClassObfuscator.setNewClassName(clazz, originalName + "$WhenMappings");
            }
        } else if (kotlinSyntheticClassKindMetadata.flavor == KotlinSyntheticClassKindMetadata.Flavor.LAMBDA) {
            clazz.accept(new AllFieldVisitor(new MemberNameFilter("$*", new MemberVisitor(){

                @Override
                public void visitProgramField(ProgramClass programClass, ProgramField programField) {
                    MemberObfuscator.setNewMemberName(programField, "$" + MemberObfuscator.newMemberName(programField));
                }

                @Override
                public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
                }

                @Override
                public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
                }

                @Override
                public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
                }
            })));
        }
    }
}

