/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import proguard.ClassPathEntry;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryReader;
import proguard.io.FilteredDataEntryReader;
import proguard.io.JarReader;
import proguard.io.PrefixStrippingDataEntryReader;
import proguard.io.RenamedDataEntryReader;
import proguard.util.AndMatcher;
import proguard.util.ExtensionMatcher;
import proguard.util.FileNameParser;
import proguard.util.ListFunctionParser;
import proguard.util.ListParser;
import proguard.util.NotMatcher;
import proguard.util.SingleFunctionParser;
import proguard.util.StringFunction;
import proguard.util.StringMatcher;
import proguard.util.WildcardManager;

public class DataEntryReaderFactory {
    private static final String VERSIONS_PATTERN = "META-INF/versions";
    private static final String VERSIONS_EXCLUDE = "!META-INF/versions/**";
    private static final String JMOD_CLASS_FILE_PREFIX = "classes/";
    private final boolean android;

    public DataEntryReaderFactory(boolean android) {
        this.android = android;
    }

    public DataEntryReader createDataEntryReader(ClassPathEntry classPathEntry, DataEntryReader reader) {
        boolean isApk = classPathEntry.isApk();
        boolean isAab = classPathEntry.isAab();
        boolean isJar = classPathEntry.isJar();
        boolean isAar = classPathEntry.isAar();
        boolean isWar = classPathEntry.isWar();
        boolean isEar = classPathEntry.isEar();
        boolean isJmod = classPathEntry.isJmod();
        boolean isZip = classPathEntry.isZip();
        List<String> filter = DataEntryReaderFactory.getFilterExcludingVersionedClasses(classPathEntry);
        List<String> apkFilter = classPathEntry.getApkFilter();
        List<String> aabFilter = classPathEntry.getAabFilter();
        List<String> jarFilter = classPathEntry.getJarFilter();
        List<String> aarFilter = classPathEntry.getAarFilter();
        List<String> warFilter = classPathEntry.getWarFilter();
        List<String> earFilter = classPathEntry.getEarFilter();
        List<String> jmodFilter = classPathEntry.getJmodFilter();
        List<String> zipFilter = classPathEntry.getZipFilter();
        if (filter != null) {
            WildcardManager wildcardManager = new WildcardManager();
            StringFunction nameFunction = new ListFunctionParser(new SingleFunctionParser(new FileNameParser(wildcardManager), wildcardManager)).parse(filter);
            reader = new RenamedDataEntryReader(nameFunction, reader);
        }
        reader = this.wrapInJarReader(reader, false, false, isApk, apkFilter, ".apk");
        if (!isApk) {
            reader = this.wrapInJarReader(reader, false, false, isAab, aabFilter, ".aab");
            if (!isAab) {
                reader = this.wrapInJarReader(reader, false, false, isJar, jarFilter, ".jar");
                if (!isJar) {
                    reader = this.wrapInJarReader(reader, false, false, isAar, aarFilter, ".aar");
                    if (!isAar) {
                        reader = this.wrapInJarReader(reader, true, false, isWar, warFilter, ".war");
                        if (!isWar) {
                            reader = this.wrapInJarReader(reader, false, false, isEar, earFilter, ".ear");
                            if (!isEar) {
                                reader = this.wrapInJarReader(reader, true, true, isJmod, jmodFilter, ".jmod");
                                if (!isJmod) {
                                    reader = this.wrapInJarReader(reader, false, false, isZip, zipFilter, ".zip");
                                }
                            }
                        }
                    }
                }
            }
        }
        return reader;
    }

    private DataEntryReader wrapInJarReader(DataEntryReader reader, boolean stripClassesPrefix, boolean stripJmodHeader, boolean isJar, List<String> jarFilter, String jarExtension) {
        if (stripClassesPrefix) {
            reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".class")), new PrefixStrippingDataEntryReader(JMOD_CLASS_FILE_PREFIX, reader), reader);
        }
        DataEntryReader jarReader = new JarReader(stripJmodHeader, reader);
        if (isJar) {
            return jarReader;
        }
        if (jarFilter != null) {
            jarReader = new FilteredDataEntryReader(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(jarFilter)), jarReader);
        }
        StringMatcher jarMatcher = new ExtensionMatcher(jarExtension);
        if (this.android) {
            jarMatcher = new AndMatcher(new AndMatcher(new NotMatcher(new ListParser(new FileNameParser()).parse("assets/**,*/assets/**")), new NotMatcher(new ListParser(new FileNameParser()).parse("res/**,*/res/**"))), jarMatcher);
        }
        return new FilteredDataEntryReader(new DataEntryNameFilter(jarMatcher), jarReader, reader);
    }

    public static List<String> getFilterExcludingVersionedClasses(ClassPathEntry classPathEntry) {
        List<String> originalFilter = classPathEntry.getFilter();
        if (originalFilter == null) {
            return Collections.singletonList(VERSIONS_EXCLUDE);
        }
        for (String element : originalFilter) {
            if (!element.contains(VERSIONS_PATTERN)) continue;
            return originalFilter;
        }
        ArrayList<String> filter = new ArrayList<String>();
        filter.add(VERSIONS_EXCLUDE);
        filter.addAll(originalFilter);
        return filter;
    }
}

