/*
 * Decompiled with CFR 0.152.
 */
package proguard.fixer.kotlin;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.SimpleUsageMarker;

public class KotlinAnnotationCounter
implements MemberVisitor,
AttributeVisitor,
AnnotationVisitor {
    private int count = 0;
    private int[] parameterAnnotationCount = null;
    private SimpleUsageMarker usageMarker;

    public KotlinAnnotationCounter(SimpleUsageMarker javaUsageMarker) {
        this.usageMarker = javaUsageMarker;
    }

    public KotlinAnnotationCounter() {
    }

    public int getCount() {
        return this.count;
    }

    public int getParameterAnnotationCount(int index) {
        return this.parameterAnnotationCount != null && this.parameterAnnotationCount.length > 0 && index < this.parameterAnnotationCount.length ? this.parameterAnnotationCount[index] : -1;
    }

    public KotlinAnnotationCounter reset() {
        this.count = 0;
        this.parameterAnnotationCount = null;
        return this;
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
        member.accept(clazz, new AllAttributeVisitor(this));
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, new AnnotationTypeFilter("!Lkotlin/Metadata;", (AnnotationVisitor)this));
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        this.parameterAnnotationCount = new int[parameterAnnotationsAttribute.u1parametersCount];
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, new AnnotationTypeFilter("!Lkotlin/Metadata;", (AnnotationVisitor)this));
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        if (this.usageMarker == null || this.usageMarker.isUsed(annotation)) {
            ++this.count;
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, int parameterIndex, Annotation annotation) {
        if (this.usageMarker == null || this.usageMarker.isUsed(annotation)) {
            int n = parameterIndex;
            this.parameterAnnotationCount[n] = this.parameterAnnotationCount[n] + 1;
        }
    }
}

