/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.exception.ArrayIndexOutOfBounds;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IdentifiedArrayReferenceValue;
import proguard.evaluation.value.InitialValueFactory;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.util.ArrayUtil;

public class DetailedArrayReferenceValue
extends IdentifiedArrayReferenceValue {
    private static final int MAXIMUM_STORED_ARRAY_LENGTH = 64;
    private Value[] values;

    public DetailedArrayReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, IntegerValue arrayLength, ValueFactory valuefactory, int id) {
        super(type, referencedClass, mayBeExtension, arrayLength, valuefactory, id);
        if (arrayLength.isParticular() && arrayLength.value() >= 0 && arrayLength.value() <= 64) {
            InitialValueFactory initialValueFactory = new InitialValueFactory(valuefactory);
            String elementType = ClassUtil.isInternalArrayType(type) ? type.substring(1) : type;
            this.values = new Value[arrayLength.value()];
            for (int index = 0; index < this.values.length; ++index) {
                this.values[index] = initialValueFactory.createValue(elementType);
            }
        } else {
            this.values = null;
        }
    }

    @Override
    public Object value() {
        return this.values;
    }

    @Override
    public IntegerValue integerArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(indexValue, valueFactory);
        return value != null ? value.integerValue() : super.integerArrayLoad(indexValue, valueFactory);
    }

    @Override
    public LongValue longArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(indexValue, valueFactory);
        return value != null ? value.longValue() : super.longArrayLoad(indexValue, valueFactory);
    }

    @Override
    public FloatValue floatArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(indexValue, valueFactory);
        return value != null ? value.floatValue() : super.floatArrayLoad(indexValue, valueFactory);
    }

    @Override
    public DoubleValue doubleArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(indexValue, valueFactory);
        return value != null ? value.doubleValue() : super.doubleArrayLoad(indexValue, valueFactory);
    }

    @Override
    public ReferenceValue referenceArrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        Value value = this.arrayLoad(indexValue, valueFactory);
        return value != null ? value.referenceValue() : super.referenceArrayLoad(indexValue, valueFactory);
    }

    private Value arrayLoad(IntegerValue indexValue, ValueFactory valueFactory) {
        if (this.values != null && indexValue.isParticular()) {
            int index = indexValue.value();
            if (PartialEvaluator.ENABLE_NEW_EXCEPTIONS && index < 0 || index >= this.values.length) {
                throw new ArrayIndexOutOfBounds(index, this.values.length);
            }
            return this.values[index];
        }
        return null;
    }

    @Override
    public void arrayStore(IntegerValue indexValue, Value value) {
        super.arrayStore(indexValue, value);
        if (this.values != null) {
            if (indexValue.isParticular()) {
                int index = indexValue.value();
                if (PartialEvaluator.ENABLE_NEW_EXCEPTIONS && index < 0 || index >= this.values.length) {
                    throw new ArrayIndexOutOfBounds(index, this.values.length);
                }
                this.values[index] = value;
            } else {
                for (int index = 0; index < this.values.length; ++index) {
                    this.values[index].generalize(value);
                }
            }
        }
    }

    @Override
    public ReferenceValue generalize(ReferenceValue other) {
        return other.generalize(this);
    }

    @Override
    public int equal(ReferenceValue other) {
        return other.equal(this);
    }

    @Override
    public boolean isParticular() {
        if (this.values == null) {
            return false;
        }
        for (int index = 0; index < this.values.length; ++index) {
            if (this.values[index].isParticular()) continue;
            return false;
        }
        return true;
    }

    @Override
    public DetailedArrayReferenceValue copyIfMutable() {
        DetailedArrayReferenceValue copy = new DetailedArrayReferenceValue(this.type, this.referencedClass, this.mayBeExtension, this.arrayLength, this.valuefactory, this.id);
        if (this.values != null) {
            copy.values = new Value[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                copy.values[i] = this.values[i].copyIfMutable();
            }
        }
        return copy;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        DetailedArrayReferenceValue other = (DetailedArrayReferenceValue)object;
        return ArrayUtil.equalOrNull(this.values, other.values);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ArrayUtil.hashCodeOrNull(this.values);
    }

    @Override
    public String toString() {
        if (this.values == null) {
            return super.toString();
        }
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('{');
        for (int index = 0; index < this.values.length; ++index) {
            buffer.append(this.values[index]);
            buffer.append(index < this.values.length - 1 ? (char)',' : '}');
        }
        return buffer.toString();
    }
}

