/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryMember;
import proguard.classfile.Member;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionConstantVisitor;
import proguard.classfile.instruction.visitor.InstructionOpCodeFilter;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.Processable;

public class MethodLinker
implements ClassVisitor,
MemberVisitor {
    private final Map<String, Member> memberMap = new HashMap<String, Member>();

    @Override
    public void visitAnyClass(Clazz clazz) {
        clazz.hierarchyAccept(true, true, true, false, new AllMethodVisitor(new MemberAccessFilter(0, 10, this)));
        clazz.kotlinMetadataAccept(new KotlinMultiFileFacadeMethodLinker());
        this.memberMap.clear();
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
        String name = member.getName(clazz);
        String descriptor = member.getDescriptor(clazz);
        if (ClassUtil.isInitializer(name)) {
            return;
        }
        String key = name + ' ' + descriptor;
        Member otherMember = this.memberMap.get(key);
        if (otherMember == null) {
            Member thisLastMember = MethodLinker.lastMember(member);
            this.memberMap.put(key, thisLastMember);
        } else if ((member.getAccessFlags() & 0x10) == 0) {
            MethodLinker.link(member, otherMember);
        }
    }

    private static void link(Member member1, Member member2) {
        Member lastMember2;
        Member lastMember1 = MethodLinker.lastMember(member1);
        if (!lastMember1.equals(lastMember2 = MethodLinker.lastMember(member2))) {
            if (lastMember2 instanceof LibraryMember) {
                lastMember1.setProcessingInfo(lastMember2);
            } else {
                lastMember2.setProcessingInfo(lastMember1);
            }
        }
    }

    public static Member lastMember(Member member) {
        Member lastMember = member;
        while (lastMember.getProcessingInfo() != null && lastMember.getProcessingInfo() instanceof Member) {
            lastMember = (Member)lastMember.getProcessingInfo();
        }
        return lastMember;
    }

    public static Processable lastProcessable(Processable processable) {
        Processable lastProcessable = processable;
        while (lastProcessable.getProcessingInfo() != null && lastProcessable.getProcessingInfo() instanceof Processable) {
            lastProcessable = (Processable)lastProcessable.getProcessingInfo();
        }
        return lastProcessable;
    }

    private static class KotlinMultiFileFacadeMethodLinker
    implements KotlinMetadataVisitor,
    MemberVisitor,
    ConstantVisitor {
        private Member multiFileFacadeMember;

        private KotlinMultiFileFacadeMethodLinker() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
            clazz.methodsAccept(this);
        }

        @Override
        public void visitAnyMember(Clazz clazz, Member member) {
            this.multiFileFacadeMember = member;
            this.multiFileFacadeMember.accept(clazz, new AllAttributeVisitor(new AllInstructionVisitor(new InstructionOpCodeFilter(new int[]{-72}, new InstructionConstantVisitor(this)))));
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
            if (this.multiFileFacadeMember.getName(clazz).equals(anyMethodrefConstant.getName(clazz)) && this.multiFileFacadeMember.getDescriptor(clazz).equals(anyMethodrefConstant.getType(clazz)) && anyMethodrefConstant.referencedMethod != null) {
                MethodLinker.link(this.multiFileFacadeMember, anyMethodrefConstant.referencedMethod);
            }
        }
    }
}

