/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.defaults;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.CfaEdge;
import proguard.analysis.cpa.interfaces.CfaNode;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.classfile.Signature;

public final class ProgramLocationDependentReachedSet<CfaNodeT extends CfaNode<CfaEdgeT, SignatureT>, CfaEdgeT extends CfaEdge<CfaNodeT>, AbstractStateT extends AbstractState & ProgramLocationDependent<CfaNodeT, CfaEdgeT, SignatureT>, SignatureT extends Signature>
implements ReachedSet {
    private Map<CfaNodeT, Set<AbstractStateT>> locationToStates = new HashMap<CfaNodeT, Set<AbstractStateT>>();

    @Override
    public boolean add(AbstractState abstractState) {
        AbstractState state = abstractState;
        return this.locationToStates.computeIfAbsent(((ProgramLocationDependent)((Object)state)).getProgramLocation(), x -> new HashSet()).add(state);
    }

    @Override
    public boolean addAll(Collection<? extends AbstractState> abstractStates) {
        boolean result = false;
        for (AbstractState abstractState : abstractStates) {
            result |= this.add(abstractState);
        }
        return result;
    }

    @Override
    public boolean remove(AbstractState abstractState) {
        AbstractState state = abstractState;
        Object location = ((ProgramLocationDependent)((Object)state)).getProgramLocation();
        return this.locationToStates.containsKey(location) && this.locationToStates.get(location).remove(state);
    }

    @Override
    public boolean removeAll(Collection<?> abstractStates) {
        boolean result = false;
        for (Object state : abstractStates) {
            result |= this.remove((AbstractState)state);
        }
        return result;
    }

    public Collection<AbstractStateT> asCollection() {
        int initialSize = this.locationToStates.values().size();
        return this.locationToStates.values().stream().reduce(new HashSet(initialSize), (x, y) -> {
            x.addAll(y);
            return x;
        });
    }

    @Override
    public Collection<? extends AbstractState> getReached(AbstractState abstractState) {
        return this.getReached(((ProgramLocationDependent)((Object)abstractState)).getProgramLocation());
    }

    public Collection<? extends AbstractState> getReached(CfaNodeT location) {
        return this.locationToStates.getOrDefault(location, Collections.emptySet());
    }
}

