/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.kotlinmodule.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.BiConsumer;
import kotlinx.metadata.jvm.KmModule;
import kotlinx.metadata.jvm.KmPackageParts;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import kotlinx.metadata.jvm.KotlinModuleMetadata;
import proguard.classfile.util.ClassUtil;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;

public class KotlinModuleWriter
implements ResourceFileVisitor {
    private final OutputStream outputStream;
    private final BiConsumer<KotlinModule, String> errorHandler;

    public KotlinModuleWriter(OutputStream outputStream) {
        this(null, outputStream);
    }

    public KotlinModuleWriter(BiConsumer<KotlinModule, String> errorHandler, OutputStream outputStream) {
        this.errorHandler = errorHandler;
        this.outputStream = outputStream;
    }

    @Override
    public void visitKotlinModule(KotlinModule kotlinModule) {
        try {
            KmModule kmModule = new KmModule();
            kotlinModule.modulePackagesAccept((module, modulePackage) -> kmModule.getPackageParts().put(ClassUtil.externalClassName(modulePackage.fqName), new KmPackageParts(modulePackage.fileFacadeNames, modulePackage.multiFileClassParts)));
            byte[] transformedBytes = KotlinModuleMetadata.Companion.write(kmModule, kotlinModule.version.canBeWritten() ? kotlinModule.version.toArray() : KotlinClassMetadata.COMPATIBLE_METADATA_VERSION).getBytes();
            this.outputStream.write(transformedBytes);
        }
        catch (IOException e) {
            if (this.errorHandler != null) {
                this.errorHandler.accept(kotlinModule, e.getMessage());
            }
            throw new RuntimeException("Error while writing module file", e);
        }
    }
}

