/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.visitor.ClassCollector;
import proguard.optimize.info.NoSideEffectClassMarker;
import proguard.optimize.info.SideEffectClassFilter;

public class SideEffectClassChecker {
    public static boolean mayHaveSideEffects(Clazz referencingClass, Clazz referencedClass, Member referencedMember) {
        return ((referencedMember.getAccessFlags() & 8) != 0 || referencedMember.getName(referencedClass).equals("<init>")) && SideEffectClassChecker.mayHaveSideEffects(referencingClass, referencedClass);
    }

    public static boolean mayHaveSideEffects(Clazz referencingClass, Clazz referencedClass) {
        return !NoSideEffectClassMarker.hasNoSideEffects(referencedClass) && !referencingClass.extendsOrImplements(referencedClass) && !SideEffectClassChecker.sideEffectSuperClasses(referencingClass).containsAll(SideEffectClassChecker.sideEffectSuperClasses(referencedClass));
    }

    private static Set sideEffectSuperClasses(Clazz clazz) {
        HashSet<Clazz> set = new HashSet<Clazz>();
        clazz.hierarchyAccept(true, true, true, false, new SideEffectClassFilter(new ClassCollector(set)));
        return set;
    }
}

