/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import proguard.analysis.datastructure.callgraph.ConcreteCall;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ReturnClassExtractor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.Stack;
import proguard.evaluation.Variables;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.ReflectiveMethodCallUtil;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class ExecutingInvocationUnit
extends BasicInvocationUnit {
    public static boolean DEBUG = System.getProperty("eiu") != null;
    private static final Logger log = LogManager.getLogger(ExecutingInvocationUnit.class);
    @Nullable
    private Value[] parameters;
    private final Map<String, Set<String>> alwaysReturnsNewInstance;
    private final Map<String, Set<String>> alwaysModifiesInstance;
    private final boolean enableSameInstanceIdApproximation;

    protected ExecutingInvocationUnit(ValueFactory valueFactory, Map<String, Set<String>> alwaysReturnsNewInstance, Map<String, Set<String>> alwaysModifiesInstance, boolean enableSameInstanceIdApproximation) {
        super(valueFactory);
        this.enableSameInstanceIdApproximation = enableSameInstanceIdApproximation;
        this.alwaysReturnsNewInstance = alwaysReturnsNewInstance;
        this.alwaysModifiesInstance = alwaysModifiesInstance;
    }

    @Deprecated
    public ExecutingInvocationUnit(ValueFactory valueFactory) {
        this(valueFactory, Builder.alwaysReturnsNewInstanceDefault(), Collections.emptyMap(), false);
    }

    @Override
    public void setMethodParameterValue(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, int parameterIndex, Value value) {
        if (this.parameters == null) {
            String type = anyMethodrefConstant.getType(clazz);
            int parameterCount = ClassUtil.internalMethodParameterCount(type, this.isStatic);
            this.parameters = new Value[parameterCount];
        }
        this.parameters[parameterIndex] = value;
    }

    @Override
    public boolean methodMayHaveSideEffects(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, String returnType) {
        return this.parameters != null && this.parameters.length > 0;
    }

    @Override
    public Value getMethodReturnValue(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, String returnType) {
        String baseClassName = anyMethodrefConstant.getClassName(clazz);
        Clazz referencedClass = this.getReferencedClass(anyMethodrefConstant, false);
        if (!this.isSupportedMethodCall(baseClassName, anyMethodrefConstant.getName(clazz))) {
            if (this.enableSameInstanceIdApproximation && anyMethodrefConstant.referencedMethod != null && !ClassUtil.isInternalPrimitiveType(returnType) && this.parameters != null && this.parameters.length > 0 && this.parameters[0] instanceof IdentifiedReferenceValue && this.returnsOwnInstance(baseClassName, anyMethodrefConstant.getName(clazz), anyMethodrefConstant.referencedMethod.getDescriptor(anyMethodrefConstant.referencedClass), (anyMethodrefConstant.referencedMethod.getAccessFlags() & 8) != 0, returnType)) {
                return this.valueFactory.createReferenceValueForId(returnType, referencedClass, ClassUtil.isNullOrFinal(referencedClass), true, ((IdentifiedReferenceValue)this.parameters[0]).id);
            }
            return this.valueFactory.createValue(returnType, referencedClass, ClassUtil.isNullOrFinal(referencedClass), true);
        }
        Value reflectedReturnValue = this.executeMethod(null, null, 0, anyMethodrefConstant.referencedClass, anyMethodrefConstant.referencedMethod, this.parameters);
        this.updateStackAndVariables(clazz, anyMethodrefConstant, returnType, reflectedReturnValue);
        return returnType.charAt(0) == 'V' ? null : reflectedReturnValue;
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        try {
            super.visitAnyMethodrefConstant(clazz, anyMethodrefConstant);
        }
        finally {
            this.parameters = null;
        }
    }

    @Override
    public Value getFieldValue(Clazz clazz, FieldrefConstant fieldrefConstant, String type) {
        FieldValueGetterVisitor constantVisitor = new FieldValueGetterVisitor();
        fieldrefConstant.referencedFieldAccept(new MemberAccessFilter(24, 0, constantVisitor));
        return constantVisitor.value == null ? super.getFieldValue(clazz, fieldrefConstant, type) : constantVisitor.value;
    }

    public boolean isSupportedMethodCall(String internalClassName, String methodName) {
        return this.isSupportedClass(internalClassName);
    }

    public boolean isSupportedClass(String internalClassName) {
        switch (internalClassName) {
            case "java/lang/StringBuilder": 
            case "java/lang/StringBuffer": 
            case "java/lang/String": {
                return true;
            }
        }
        return false;
    }

    public Value executeMethod(ConcreteCall call, Value ... parameters) {
        return this.executeMethod(call.caller.clazz, (Method)call.caller.member, call.caller.offset, call.getTargetClass(), call.getTargetMethod(), parameters);
    }

    public Value executeMethod(Clazz callingClass, Method callingMethod, int callingOffset, Clazz clazz, Method method, Value ... parameters) {
        Object methodResult;
        CharSequence callingInstance;
        boolean resultMayBeExtension;
        boolean resultMayBeNull;
        Object objectId2;
        ReferenceValue instance2;
        Clazz returnClazz;
        String returnType;
        String methodName;
        String baseClassName;
        boolean isStatic;
        block26: {
            int paramOffset;
            if (clazz == null || method == null) {
                return BasicValueFactory.UNKNOWN_VALUE;
            }
            isStatic = (method.getAccessFlags() & 8) != 0;
            baseClassName = clazz.getName();
            methodName = method.getName(clazz);
            String descriptor = method.getDescriptor(clazz);
            returnType = ClassUtil.internalMethodReturnType(descriptor);
            returnClazz = this.getReferencedClass(clazz, method, methodName.equals("<init>"));
            String finalReturnType = returnType;
            BiFunction<ReferenceValue, Object, Value> errorHandler = (instance, objectId) -> {
                if (objectId != null && this.returnsOwnInstance(finalReturnType, methodName, descriptor, isStatic, instance == null ? null : instance.internalType())) {
                    return this.valueFactory.createReferenceValueForId(finalReturnType, returnClazz, ClassUtil.isNullOrFinal(returnClazz), true, objectId);
                }
                if (ClassUtil.isInternalPrimitiveType(finalReturnType)) {
                    return this.createPrimitiveValue(finalReturnType);
                }
                return this.valueFactory.createValue(finalReturnType, returnClazz, ClassUtil.isNullOrFinal(returnClazz), true);
            };
            instance2 = !isStatic && parameters[0] instanceof ReferenceValue ? parameters[0].referenceValue() : null;
            Object object = objectId2 = instance2 instanceof IdentifiedReferenceValue ? ((IdentifiedReferenceValue)instance2).id : null;
            if (!this.isSupportedMethodCall(baseClassName, methodName)) {
                return errorHandler.apply(instance2, objectId2);
            }
            if (!(isStatic || instance2 != null && instance2.isSpecific())) {
                return errorHandler.apply(instance2, objectId2);
            }
            for (int i = paramOffset = isStatic ? 0 : 1; i < parameters.length; ++i) {
                if (parameters[i].isParticular()) continue;
                return errorHandler.apply(instance2, objectId2);
            }
            resultMayBeNull = true;
            resultMayBeExtension = true;
            callingInstance = null;
            try {
                Class<?>[] parameterClasses = ReflectiveMethodCallUtil.stringtypesToClasses(descriptor);
                Object[] parameterObjects = new Object[parameters.length - paramOffset];
                for (int i = paramOffset; i < parameters.length; ++i) {
                    parameterObjects[i - paramOffset] = ReflectiveMethodCallUtil.getObjectForValue(parameters[i], parameterClasses[i - paramOffset]);
                }
                if (methodName.equals("<init>")) {
                    methodResult = ReflectiveMethodCallUtil.callConstructor(ClassUtil.externalClassName(baseClassName), parameterClasses, parameterObjects);
                    resultMayBeNull = false;
                    resultMayBeExtension = false;
                    break block26;
                }
                if (instance2 != null && instance2.isParticular()) {
                    switch (baseClassName) {
                        case "java/lang/StringBuilder": {
                            callingInstance = new StringBuilder((StringBuilder)instance2.value());
                            break;
                        }
                        case "java/lang/StringBuffer": {
                            callingInstance = new StringBuffer((StringBuffer)instance2.value());
                            break;
                        }
                        case "java/lang/String": {
                            callingInstance = (String)instance2.value();
                        }
                    }
                }
                if (isStatic || callingInstance != null) {
                    methodResult = ReflectiveMethodCallUtil.callMethod(ClassUtil.externalClassName(baseClassName), methodName, callingInstance, parameterClasses, parameterObjects);
                    break block26;
                }
                return errorHandler.apply(instance2, objectId2);
            }
            catch (NullPointerException | InvocationTargetException e) {
                if (DEBUG) {
                    System.err.println("Invocation exception during method execution: " + e.getClass().getSimpleName() + ": - " + e.getMessage());
                }
                return errorHandler.apply(instance2, objectId2);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException e) {
                if (DEBUG) {
                    System.err.println("Error reflectively calling " + baseClassName + "." + methodName + descriptor + ": " + e.getClass().getSimpleName() + " - " + e.getMessage());
                }
                return errorHandler.apply(instance2, objectId2);
            }
        }
        if (returnType.length() == 1 && ClassUtil.isInternalPrimitiveType(returnType)) {
            return this.createPrimitiveValue(methodResult, returnType);
        }
        if (!isStatic && returnType.equals("V")) {
            returnType = instance2.referenceValue().getType();
        }
        if (objectId2 != null && (this.alwaysModifiesInstance(baseClassName, methodName) || callingInstance == methodResult)) {
            return this.valueFactory.createReferenceValueForId(returnType, ClassUtil.isInternalPrimitiveType(ClassUtil.internalTypeFromArrayType(returnType)) ? null : returnClazz, resultMayBeExtension, resultMayBeNull, objectId2, methodResult);
        }
        return this.valueFactory.createReferenceValue(returnType, ClassUtil.isInternalPrimitiveType(ClassUtil.internalTypeFromArrayType(returnType)) ? null : returnClazz, resultMayBeExtension, resultMayBeNull, callingClass, callingMethod, callingOffset, methodResult);
    }

    private Value createPrimitiveValue(String type) {
        switch (type.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.valueFactory.createIntegerValue();
            }
            case 'F': {
                return this.valueFactory.createFloatValue();
            }
            case 'D': {
                return this.valueFactory.createDoubleValue();
            }
            case 'J': {
                return this.valueFactory.createLongValue();
            }
        }
        return null;
    }

    private Value createPrimitiveValue(Object obj, String type) {
        switch (type.charAt(0)) {
            case 'Z': {
                return this.valueFactory.createIntegerValue((Boolean)obj != false ? 1 : 0);
            }
            case 'C': {
                return this.valueFactory.createIntegerValue(((Character)obj).charValue());
            }
            case 'B': {
                return this.valueFactory.createIntegerValue(((Byte)obj).byteValue());
            }
            case 'S': {
                return this.valueFactory.createIntegerValue(((Short)obj).shortValue());
            }
            case 'I': {
                return this.valueFactory.createIntegerValue((Integer)obj);
            }
            case 'F': {
                return this.valueFactory.createFloatValue(((Float)obj).floatValue());
            }
            case 'D': {
                return this.valueFactory.createDoubleValue((Double)obj);
            }
            case 'J': {
                return this.valueFactory.createLongValue((Long)obj);
            }
        }
        return null;
    }

    private void replaceReferenceInVariables(Value newValue, Value oldValue, Variables variables) {
        if (oldValue.isSpecific() && variables != null) {
            for (int i = 0; i < variables.size(); ++i) {
                Value value = variables.getValue(i);
                if (Objects.equals(value, oldValue)) {
                    variables.store(i, newValue);
                }
                if (value == null || !value.isCategory2()) continue;
                ++i;
            }
        }
    }

    private void replaceReferenceOnStack(Value newValue, Value oldValue, Stack stack) {
        if (oldValue.isSpecific()) {
            for (int i = 0; i < stack.size(); ++i) {
                Value top = stack.getTop(i);
                if (!Objects.equals(top, oldValue)) continue;
                stack.setTop(i, newValue);
            }
        }
    }

    public boolean alwaysReturnsNewInstance(String internalClassName, String methodName) {
        return ((Set)this.alwaysReturnsNewInstance.getOrDefault(internalClassName, new HashSet())).contains(methodName);
    }

    private boolean alwaysModifiesInstance(String internalClassName, String methodName) {
        return methodName.equals("<init>") || ((Set)this.alwaysModifiesInstance.getOrDefault(internalClassName, new HashSet())).contains(methodName);
    }

    public boolean returnsOwnInstance(Clazz clazz, Method method, Value instance) {
        if (!(instance instanceof ReferenceValue)) {
            return false;
        }
        String instanceType = instance.internalType();
        String internalClassName = clazz.getName();
        String methodName = method.getName(clazz);
        boolean isStatic = (method.getAccessFlags() & 8) != 0;
        return this.returnsOwnInstance(internalClassName, methodName, method.getDescriptor(clazz), isStatic, instanceType);
    }

    private boolean returnsOwnInstance(String internalClassName, String methodName, String methodDescriptor, boolean isStatic, String instanceType) {
        String returnType = ClassUtil.internalMethodReturnType(methodDescriptor);
        if (ClassUtil.isInternalPrimitiveType(returnType)) {
            return false;
        }
        if (isStatic) {
            return false;
        }
        if (this.alwaysReturnsNewInstance(internalClassName, methodName)) {
            return false;
        }
        return this.alwaysModifiesInstance(internalClassName, methodName) || Objects.equals(returnType, instanceType);
    }

    private void updateStackAndVariables(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, String returnType, Value reflectedReturnValue) {
        String baseClassName = anyMethodrefConstant.getClassName(clazz);
        String methodName = anyMethodrefConstant.getName(clazz);
        if (this.returnsOwnInstance(clazz, anyMethodrefConstant.referencedMethod, this.parameters.length > 0 ? this.parameters[0] : null)) {
            Value updateValue = reflectedReturnValue;
            if (updateValue == null) {
                updateValue = this.valueFactory.createValue(returnType.charAt(0) == 'V' ? ClassUtil.internalTypeFromClassName(baseClassName) : returnType, this.getReferencedClass(anyMethodrefConstant, methodName.equals("<init>")), true, true);
            }
            this.replaceReferenceInVariables(updateValue, this.parameters[0], this.variables);
            this.replaceReferenceOnStack(updateValue, this.parameters[0], this.stack);
        }
    }

    private Clazz getReferencedClass(Clazz clazz, Method method, boolean isCtor) {
        if (isCtor) {
            return clazz;
        }
        ReturnClassExtractor returnClassExtractor = new ReturnClassExtractor();
        method.accept(clazz, returnClassExtractor);
        return returnClassExtractor.returnClass;
    }

    private Clazz getReferencedClass(AnyMethodrefConstant anyMethodrefConstant, boolean isCtor) {
        if (isCtor) {
            return anyMethodrefConstant.referencedClass;
        }
        ReturnClassExtractor returnClassExtractor = new ReturnClassExtractor();
        anyMethodrefConstant.referencedMethodAccept(returnClassExtractor);
        return returnClassExtractor.returnClass;
    }

    private class FieldValueGetterVisitor
    implements MemberVisitor,
    AttributeVisitor,
    ConstantVisitor {
        Value value = null;
        private ProgramField currentField;

        private FieldValueGetterVisitor() {
        }

        @Override
        public void visitAnyMember(Clazz clazz, Member member) {
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            this.currentField = programField;
            programField.attributesAccept(programClass, this);
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
            clazz.constantPoolEntryAccept(constantValueAttribute.u2constantValueIndex, this);
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
            this.value = ExecutingInvocationUnit.this.valueFactory.createIntegerValue(integerConstant.getValue());
        }

        @Override
        public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
            this.value = ExecutingInvocationUnit.this.valueFactory.createFloatValue(floatConstant.getValue());
        }

        @Override
        public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
            this.value = ExecutingInvocationUnit.this.valueFactory.createDoubleValue(doubleConstant.getValue());
        }

        @Override
        public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
            this.value = ExecutingInvocationUnit.this.valueFactory.createLongValue(longConstant.getValue());
        }

        @Override
        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            this.value = ExecutingInvocationUnit.this.valueFactory.createReferenceValue("Ljava/lang/String;", this.currentField.referencedClass, ClassUtil.isNullOrFinal(this.currentField.referencedClass), false, stringConstant.getString(clazz));
        }
    }

    public static class Builder {
        protected Map<String, Set<String>> alwaysReturnsNewInstance = Builder.alwaysReturnsNewInstanceDefault();
        protected Map<String, Set<String>> alwaysModifiesInstance = Collections.emptyMap();
        protected boolean enableSameInstanceIdApproximation = false;

        public ExecutingInvocationUnit build(ValueFactory valueFactory) {
            return new ExecutingInvocationUnit(valueFactory, this.alwaysReturnsNewInstance, this.alwaysModifiesInstance, this.enableSameInstanceIdApproximation);
        }

        public Builder setAlwaysReturnsNewInstance(Map<String, Set<String>> alwaysReturnsNewInstance) {
            this.alwaysReturnsNewInstance = alwaysReturnsNewInstance;
            return this;
        }

        public Builder setAlwaysModifiesInstance(Map<String, Set<String>> alwaysModifiesInstance) {
            this.alwaysModifiesInstance = alwaysModifiesInstance;
            return this;
        }

        public Builder setEnableSameInstanceIdApproximation(boolean enableSameInstanceIdApproximation) {
            this.enableSameInstanceIdApproximation = enableSameInstanceIdApproximation;
            return this;
        }

        private static Map<String, Set<String>> alwaysReturnsNewInstanceDefault() {
            return new HashMap<String, Set<String>>(){
                {
                    this.put("java/lang/StringBuilder", Collections.singleton("toString"));
                    this.put("java/lang/StringBuffer", Collections.singleton("toString"));
                    this.put("java/lang/String", Stream.of("toString", "valueOf").collect(Collectors.toSet()));
                }
            };
        }
    }
}

