/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintAbstractState;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTreeHeapFollowerAbstractState;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.transfer.JvmTransferRelation;
import proguard.analysis.cpa.jvm.util.HeapUtil;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.Signature;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.util.ClassUtil;

public class JvmTaintTransferRelation
extends JvmTransferRelation<SetAbstractState<JvmTaintSource>> {
    private final Map<Signature, Set<JvmTaintSource>> taintSources;

    public JvmTaintTransferRelation(Map<Signature, Set<JvmTaintSource>> taintSources) {
        this.taintSources = taintSources;
    }

    @Override
    public void invokeMethod(JvmAbstractState<SetAbstractState<JvmTaintSource>> state, Call call, List<SetAbstractState<JvmTaintSource>> operands) {
        MethodSignature target = call.getTarget();
        List detectedSources = this.taintSources.getOrDefault(target, Collections.emptySet()).stream().filter(s -> s.callMatcher.map(m -> m.test(call)).orElse(true)).collect(Collectors.toList());
        int pushCount = ClassUtil.internalTypeSize(target.descriptor.returnType == null ? "?" : target.descriptor.returnType);
        AbstractState answerContent = (SetAbstractState)operands.stream().reduce(this.getAbstractDefault(), SetAbstractState::join);
        List detectedReturnSources = detectedSources.stream().filter(s -> s.taintsReturn).collect(Collectors.toList());
        if (!detectedReturnSources.isEmpty() && !((AbstractCollection)((Object)answerContent)).containsAll(detectedReturnSources)) {
            answerContent = ((SetAbstractState)answerContent).copy();
            ((AbstractCollection)((Object)answerContent)).addAll(detectedReturnSources);
        }
        for (int i = 1; i < pushCount; ++i) {
            state.push((SetAbstractState<JvmTaintSource>)this.getAbstractDefault());
        }
        if (pushCount > 0) {
            state.push((SetAbstractState<JvmTaintSource>)answerContent);
        }
        if (detectedSources.isEmpty()) {
            return;
        }
        HashMap<String, SetAbstractState> fqnToValue = new HashMap<String, SetAbstractState>();
        detectedSources.stream().filter(s -> !s.taintsGlobals.isEmpty()).forEach(s -> {
            SetAbstractState<JvmTaintSource> newValue = new SetAbstractState<JvmTaintSource>(s);
            s.taintsGlobals.forEach(fqn -> fqnToValue.merge((String)fqn, newValue, SetAbstractState::join));
        });
        fqnToValue.forEach((fqn, value) -> state.setStatic((String)fqn, (SetAbstractState<JvmTaintSource>)value, (SetAbstractState<JvmTaintSource>)this.getAbstractDefault()));
        if (!(state.getHeap() instanceof JvmTaintTreeHeapFollowerAbstractState)) {
            return;
        }
        JvmTaintAbstractState taintAbstractState = (JvmTaintAbstractState)state;
        JvmTaintTreeHeapFollowerAbstractState treeHeap = (JvmTaintTreeHeapFollowerAbstractState)taintAbstractState.getHeap();
        fqnToValue.forEach((key, value) -> taintAbstractState.setObjectTaint(treeHeap.getReferenceAbstractState(new JvmStaticFieldLocation((String)key)), (SetAbstractState<JvmTaintSource>)value));
        String descriptor = call.getTarget().descriptor.toString();
        int parameterSize = call.getJvmArgumentSize();
        HashMap<Integer, SetAbstractState> argToValue = new HashMap<Integer, SetAbstractState>();
        detectedSources.stream().filter(s -> !s.taintsArgs.isEmpty()).forEach(s -> {
            SetAbstractState<JvmTaintSource> newValue = new SetAbstractState<JvmTaintSource>(s);
            s.taintsArgs.forEach(a -> argToValue.merge((Integer)a, newValue, SetAbstractState::join));
        });
        argToValue.forEach((a, value) -> taintAbstractState.setObjectTaint(HeapUtil.getArgumentReference(treeHeap, parameterSize, descriptor, call.isStatic(), a - 1), (SetAbstractState<JvmTaintSource>)value));
        List sourcesTaintingThis = detectedSources.stream().filter(s -> s.taintsThis).collect(Collectors.toList());
        if (!sourcesTaintingThis.isEmpty()) {
            taintAbstractState.setObjectTaint(treeHeap.getReferenceAbstractState(new JvmStackLocation(parameterSize - 1)), new SetAbstractState<JvmTaintSource>(sourcesTaintingThis));
        }
    }

    @Override
    public SetAbstractState<JvmTaintSource> getAbstractDefault() {
        return SetAbstractState.bottom;
    }

    @Override
    protected JvmAbstractState<SetAbstractState<JvmTaintSource>> getAbstractSuccessorForInstruction(JvmAbstractState<SetAbstractState<JvmTaintSource>> abstractState, Instruction instruction, Clazz clazz, Precision precision) {
        instruction.accept(clazz, null, null, 0, new InstructionAbstractInterpreter(abstractState));
        return abstractState;
    }

    protected class InstructionAbstractInterpreter
    extends JvmTransferRelation.InstructionAbstractInterpreter {
        public InstructionAbstractInterpreter(JvmAbstractState<SetAbstractState<JvmTaintSource>> abstractState) {
            super(JvmTaintTransferRelation.this, abstractState);
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 46: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    SetAbstractState index = (SetAbstractState)this.abstractState.pop();
                    this.abstractState.push(this.abstractState.getArrayElementOrDefault(new JvmStackLocation(simpleInstruction.stackPopCount(clazz) - 1), index, this.abstractState.pop()));
                    break;
                }
                case 47: 
                case 49: {
                    SetAbstractState index = (SetAbstractState)this.abstractState.pop();
                    this.abstractState.push(JvmTaintTransferRelation.this.getAbstractDefault());
                    this.abstractState.push(this.abstractState.getArrayElementOrDefault(new JvmStackLocation(simpleInstruction.stackPopCount(clazz) - 1), index, this.abstractState.pop()));
                    break;
                }
                case 79: 
                case 81: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    SetAbstractState value = (SetAbstractState)this.abstractState.pop();
                    SetAbstractState index = (SetAbstractState)this.abstractState.pop();
                    this.abstractState.pop();
                    this.abstractState.setArrayElement(new JvmStackLocation(simpleInstruction.stackPopCount(clazz) - 1), index, value);
                    break;
                }
                case 80: 
                case 82: {
                    SetAbstractState value = (SetAbstractState)this.abstractState.pop();
                    this.abstractState.pop();
                    SetAbstractState index = (SetAbstractState)this.abstractState.pop();
                    this.abstractState.pop();
                    this.abstractState.setArrayElement(new JvmStackLocation(simpleInstruction.stackPopCount(clazz) - 1), index, value);
                    break;
                }
                default: {
                    super.visitSimpleInstruction(clazz, method, codeAttribute, offset, simpleInstruction);
                }
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            this.constantLookupVisitor.resetResult();
            switch (constantInstruction.opcode) {
                case -76: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    SetAbstractState result = (SetAbstractState)this.abstractState.getFieldOrDefault(new JvmStackLocation(constantInstruction.stackPopCount(clazz) - 1), this.constantLookupVisitor.result, this.abstractState.pop());
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.push(JvmTaintTransferRelation.this.getAbstractDefault());
                    }
                    this.abstractState.push(result);
                    break;
                }
                case -75: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    SetAbstractState value = (SetAbstractState)this.abstractState.pop();
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.pop();
                    }
                    this.abstractState.pop();
                    this.abstractState.setField(new JvmStackLocation(constantInstruction.stackPopCount(clazz) - 1), this.constantLookupVisitor.result, value);
                    break;
                }
                default: {
                    super.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                }
            }
        }
    }
}

