/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AssumeNoSideEffectsChecker;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.KeepClassMemberChecker;
import proguard.classfile.util.WarningLogger;
import proguard.classfile.util.WarningPrinter;

public class ConfigurationVerifier {
    private static final Logger logger = LogManager.getLogger(ConfigurationVerifier.class);
    private final Configuration configuration;

    public ConfigurationVerifier(Configuration configuration) {
        this.configuration = configuration;
    }

    public void check() throws IOException {
        ClassPath programJars = this.configuration.programJars;
        ClassPath libraryJars = this.configuration.libraryJars;
        if (programJars == null) {
            throw new IOException("The input is empty. You have to specify one or more '-injars' options.");
        }
        this.checkInputJarFirst(programJars);
        this.checkOutputJarFilter(programJars);
        this.checkConflicts(programJars, programJars);
        this.checkConflicts(programJars, libraryJars);
        this.checkConflicts(libraryJars, libraryJars);
        this.printNotes(this.configuration, programJars, logger);
    }

    private void checkInputJarFirst(ClassPath programJars) throws IOException {
        ClassPathEntry firstEntry = programJars.get(0);
        if (firstEntry.isOutput()) {
            throw new IOException("The output jar [" + firstEntry.getName() + "] must be specified after an input jar, or it will be empty.");
        }
    }

    private void checkOutputJarFilter(ClassPath programJars) throws IOException {
        for (int index = 0; index < programJars.size() - 1; ++index) {
            ClassPathEntry entry = programJars.get(index);
            if (!entry.isOutput() || entry.isFiltered() || !programJars.get(index + 1).isOutput()) continue;
            throw new IOException("The output jar [" + entry.getName() + "] must have a filter, or all subsequent output jars will be empty.");
        }
    }

    private void checkConflicts(ClassPath classPath1, ClassPath classPath2) throws IOException {
        if (classPath1 == null || classPath2 == null) {
            return;
        }
        for (int index1 = 0; index1 < classPath1.size(); ++index1) {
            ClassPathEntry entry1 = classPath1.get(index1);
            for (int index2 = 0; index2 < classPath2.size(); ++index2) {
                ClassPathEntry entry2;
                if (classPath1 == classPath2 && index1 == index2 || !(entry2 = classPath2.get(index2)).getName().equals(entry1.getName())) continue;
                if (entry1.isOutput()) {
                    if (entry2.isOutput()) {
                        throw new IOException("The same output jar [" + entry1.getName() + "] is specified twice.");
                    }
                    throw new IOException("Input jars and output jars must be different [" + entry1.getName() + "].");
                }
                if (entry2.isOutput()) {
                    throw new IOException("Input jars and output jars must be different [" + entry1.getName() + "].");
                }
                if (entry1.isFiltered() && entry2.isFiltered()) continue;
                throw new IOException("The same input jar [" + entry1.getName() + "] is specified twice.");
            }
        }
    }

    private void printNotes(Configuration configuration, ClassPath programJars, Logger logger) throws IOException {
        if (configuration.note == null || !configuration.note.isEmpty()) {
            int assumeNoSideEffectsNoteCount;
            String os;
            if (configuration.obfuscate && configuration.useMixedCaseClassNames && configuration.classObfuscationDictionary == null && ((os = System.getProperty("os.name").toLowerCase()).startsWith("windows") || os.startsWith("mac os"))) {
                for (int index = 0; index < programJars.size(); ++index) {
                    ClassPathEntry entry = programJars.get(index);
                    if (!entry.isOutput() || entry.isApk() || entry.isJar() || entry.isAar() || entry.isWar() || entry.isEar() || entry.isJmod() || entry.isZip()) continue;
                    logger.info("Note: you're writing the processed class files to a directory [{}].", (Object)entry.getName());
                    logger.info("      This will likely cause problems with obfuscated mixed-case class names.");
                    logger.info("      You should consider writing the output to a jar file, or otherwise");
                    logger.info("      specify '-dontusemixedcaseclassnames'.");
                    break;
                }
            }
            if (configuration.adaptResourceFileContents != null && (configuration.adaptResourceFileContents.isEmpty() || configuration.adaptResourceFileContents.get(0).equals("**"))) {
                logger.info("Note: you're specifying '-adaptresourcefilecontents' for all resource files.");
                logger.info("      This will most likely cause problems with binary files.");
            }
            WarningLogger keepClassMemberNotePrinter = new WarningLogger(logger, configuration.note);
            new KeepClassMemberChecker(keepClassMemberNotePrinter).checkClassSpecifications(configuration.keep);
            WarningLogger assumeNoSideEffectsNotePrinter = new WarningLogger(logger, configuration.note);
            new AssumeNoSideEffectsChecker(assumeNoSideEffectsNotePrinter).checkClassSpecifications(configuration.assumeNoSideEffects);
            int keepClassMemberNoteCount = ((WarningPrinter)keepClassMemberNotePrinter).getWarningCount();
            if (keepClassMemberNoteCount > 0) {
                logger.info("Note: there were {} '-keepclassmembers' options that didn't specify class", (Object)keepClassMemberNoteCount);
                logger.info("      members. You should specify at least some class members or consider");
                logger.info("      if you just need '-keep'.");
                logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#classmembers)");
            }
            if ((assumeNoSideEffectsNoteCount = ((WarningPrinter)assumeNoSideEffectsNotePrinter).getWarningCount()) > 0) {
                logger.info("Note: there were {} '-assumenosideeffects' options that try to match all", (Object)assumeNoSideEffectsNoteCount);
                logger.info("      methods with wildcards. This will likely cause problems with methods like");
                logger.info("      'wait()' and 'notify()'. You should specify the methods more precisely.");
                logger.info("      (https://www.guardsquare.com/proguard/manual/troubleshooting#nosideeffects)");
            }
        }
    }
}

