/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.kotlinmodule.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlinx.metadata.jvm.KmModule;
import kotlinx.metadata.jvm.KmModuleVisitor;
import kotlinx.metadata.jvm.KotlinModuleMetadata;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.KotlinModulePackage;

public class KotlinModuleReader
implements ResourceFileVisitor {
    private final InputStream inputStream;

    public KotlinModuleReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void visitKotlinModule(final KotlinModule kotlinModule) {
        try {
            int count;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((count = this.inputStream.read(buffer)) >= 0) {
                byteStream.write(buffer, 0, count);
            }
            byte[] bytes = byteStream.toByteArray();
            KotlinModuleMetadata kotlinModuleMetadata = KotlinModuleMetadata.read(bytes);
            KmModule kmModule = Objects.requireNonNull(kotlinModuleMetadata).toKmModule();
            kmModule.accept(new KmModuleVisitor(){

                @Override
                public void visitPackageParts(String fqName, List<String> fileFacades, Map<String, String> multiFileClassParts) {
                    kotlinModule.modulePackages.add(new KotlinModulePackage(fqName.replace('.', '/'), fileFacades, multiFileClassParts));
                }
            });
        }
        catch (IOException | NullPointerException e) {
            throw new RuntimeException("Error while reading Kotlin module file", e);
        }
    }
}

