/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.VariableEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.VariableUsageMarker;

public class VariableShrinker
implements AttributeVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor extraVariableMemberVisitor;
    private final VariableUsageMarker variableUsageMarker = new VariableUsageMarker();
    private final VariableEditor variableEditor = new VariableEditor();

    public VariableShrinker() {
        this(null);
    }

    public VariableShrinker(MemberVisitor extraVariableMemberVisitor) {
        this.extraVariableMemberVisitor = extraVariableMemberVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if ((method.getAccessFlags() & 0x400) == 0) {
            int parameterSize = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
            int maxLocals = codeAttribute.u2maxLocals;
            this.variableUsageMarker.visitCodeAttribute(clazz, method, codeAttribute);
            this.variableEditor.reset(maxLocals);
            for (int variableIndex = parameterSize; variableIndex < maxLocals; ++variableIndex) {
                if (this.variableUsageMarker.isVariableUsed(variableIndex)) continue;
                this.variableEditor.deleteVariable(variableIndex);
                if (this.extraVariableMemberVisitor == null) continue;
                method.accept(clazz, this.extraVariableMemberVisitor);
            }
            this.variableEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }
}

