/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.optimize.peephole.ReachableCodeMarker;

public class UnreachableCodeRemover
implements AttributeVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraInstructionVisitor;
    private final ReachableCodeMarker reachableCodeMarker = new ReachableCodeMarker();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();

    public UnreachableCodeRemover() {
        this(null);
    }

    public UnreachableCodeRemover(InstructionVisitor extraInstructionVisitor) {
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while removing unreachable code:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            throw ex;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.reachableCodeMarker.visitCodeAttribute(clazz, method, codeAttribute);
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        if (!this.reachableCodeMarker.isReachable(offset)) {
            this.codeAttributeEditor.deleteInstruction(offset);
            if (this.extraInstructionVisitor != null) {
                instruction.accept(clazz, method, codeAttribute, offset, this.extraInstructionVisitor);
            }
        }
    }
}

