/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.InlineSerializer;

class InlineSerializers {
    InlineSerializers() {
    }

    static class InlineStringSerializer
    implements InlineSerializer {
        InlineStringSerializer() {
        }

        @Override
        public boolean canSerialize(ClassPool programClassPool, GsonRuntimeSettings gsonRuntimeSettings) {
            return true;
        }

        @Override
        public void serialize(ProgramClass programClass, ProgramField programField, CompactCodeAttributeComposer ____, GsonRuntimeSettings gsonRuntimeSettings) {
            ____.aload(2).aload(0).getfield(programClass, programField).invokevirtual("com/google/gson/stream/JsonWriter", "value", "(Ljava/lang/String;)Lcom/google/gson/stream/JsonWriter;").pop();
        }
    }

    static class InlinePrimitiveIntegerSerializer
    implements InlineSerializer {
        InlinePrimitiveIntegerSerializer() {
        }

        @Override
        public boolean canSerialize(ClassPool programClassPool, GsonRuntimeSettings gsonRuntimeSettings) {
            return true;
        }

        @Override
        public void serialize(ProgramClass programClass, ProgramField programField, CompactCodeAttributeComposer ____, GsonRuntimeSettings gsonRuntimeSettings) {
            ____.aload(2).aload(0).getfield(programClass, programField).invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;").invokevirtual("com/google/gson/stream/JsonWriter", "value", "(Ljava/lang/Number;)Lcom/google/gson/stream/JsonWriter;").pop();
        }
    }

    static class InlineBooleanSerializer
    implements InlineSerializer {
        InlineBooleanSerializer() {
        }

        @Override
        public boolean canSerialize(ClassPool programClassPool, GsonRuntimeSettings gsonRuntimeSettings) {
            Clazz jsonWriterClass = programClassPool.getClass("com/google/gson/stream/JsonWriter");
            Method valueBooleanMethod = jsonWriterClass.findMethod("value", "(Ljava/lang/Boolean;)Lcom/google/gson/stream/JsonWriter;");
            return valueBooleanMethod != null;
        }

        @Override
        public void serialize(ProgramClass programClass, ProgramField programField, CompactCodeAttributeComposer ____, GsonRuntimeSettings gsonRuntimeSettings) {
            ____.aload(2).aload(0).getfield(programClass, programField).invokevirtual("com/google/gson/stream/JsonWriter", "value", "(Ljava/lang/Boolean;)Lcom/google/gson/stream/JsonWriter;").pop();
        }
    }

    static class InlinePrimitiveBooleanSerializer
    implements InlineSerializer {
        InlinePrimitiveBooleanSerializer() {
        }

        @Override
        public boolean canSerialize(ClassPool programClassPool, GsonRuntimeSettings gsonRuntimeSettings) {
            return true;
        }

        @Override
        public void serialize(ProgramClass programClass, ProgramField programField, CompactCodeAttributeComposer ____, GsonRuntimeSettings gsonRuntimeSettings) {
            ____.aload(2).aload(0).getfield(programClass, programField).invokevirtual("com/google/gson/stream/JsonWriter", "value", "(Z)Lcom/google/gson/stream/JsonWriter;").pop();
        }
    }
}

