/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.util.Processable;

public class AttributeShrinker
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2attributesCount = AttributeShrinker.shrinkArray(programClass.attributes, programClass.u2attributesCount);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    @Override
    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.u2attributesCount = AttributeShrinker.shrinkArray(programMember.attributes, programMember.u2attributesCount);
        programMember.attributesAccept(programClass, this);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.u2attributesCount = AttributeShrinker.shrinkArray(codeAttribute.attributes, codeAttribute.u2attributesCount);
    }

    private static int shrinkArray(Processable[] array, int length) {
        int counter = 0;
        for (int index = 0; index < length; ++index) {
            if (!AttributeUsageMarker.isUsed(array[index])) continue;
            array[counter++] = array[index];
        }
        Arrays.fill(array, counter, length, null);
        return counter;
    }
}

