/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.io.ProgramClassWriter;
import proguard.classfile.visitor.MemberVisitor;

public class ClassBuilder {
    private final ProgramClass programClass;
    private final ClassEditor classEditor;
    private final ConstantPoolEditor constantPoolEditor;

    public ClassBuilder(int u4version, int u2accessFlags, String className, String superclassName) {
        this(u4version, u2accessFlags, className, superclassName, null, 0, null);
    }

    public ClassBuilder(int u4version, int u2accessFlags, String className, String superclassName, String featureName, int processingFlags, Object processingInfo) {
        this(new ProgramClass(u4version, 1, new Constant[256], u2accessFlags, 0, 0, featureName, processingFlags, processingInfo));
        this.programClass.u2thisClass = this.constantPoolEditor.addClassConstant(className, this.programClass);
        if (superclassName != null) {
            this.programClass.u2superClass = this.constantPoolEditor.addClassConstant(superclassName, null);
        }
    }

    public ClassBuilder(ProgramClass programClass) {
        this(programClass, null, null);
    }

    public ClassBuilder(ProgramClass programClass, ClassPool programClassPool, ClassPool libraryClassPool) {
        this.programClass = programClass;
        this.classEditor = new ClassEditor(programClass);
        this.constantPoolEditor = new ConstantPoolEditor(programClass, programClassPool, libraryClassPool);
    }

    public ProgramClass getProgramClass() {
        return this.programClass;
    }

    public ClassBuilder addInterface(Clazz interfaceClass) {
        return this.addInterface(interfaceClass.getName(), interfaceClass);
    }

    public ClassBuilder addInterface(String interfaceName) {
        return this.addInterface(interfaceName, null);
    }

    public ClassBuilder addInterface(String interfaceName, Clazz referencedInterface) {
        this.classEditor.addInterface(this.constantPoolEditor.addClassConstant(interfaceName, referencedInterface));
        return this;
    }

    public ClassBuilder addField(int u2accessFlags, String fieldName, String fieldDescriptor) {
        return this.addField(u2accessFlags, fieldName, fieldDescriptor, null);
    }

    public ClassBuilder addField(int u2accessFlags, String fieldName, String fieldDescriptor, MemberVisitor extraMemberVisitor) {
        ProgramField programField = this.addAndReturnField(u2accessFlags, fieldName, fieldDescriptor);
        if (extraMemberVisitor != null) {
            extraMemberVisitor.visitProgramField(this.programClass, programField);
        }
        return this;
    }

    public ProgramField addAndReturnField(int u2accessFlags, String fieldName, String fieldDescriptor) {
        ProgramField programField = new ProgramField(u2accessFlags, this.constantPoolEditor.addUtf8Constant(fieldName), this.constantPoolEditor.addUtf8Constant(fieldDescriptor), null);
        this.classEditor.addField(programField);
        return programField;
    }

    public ClassBuilder addMethod(int u2accessFlags, String methodName, String methodDescriptor) {
        return this.addMethod(u2accessFlags, methodName, methodDescriptor, null);
    }

    public ClassBuilder addMethod(int u2accessFlags, String methodName, String methodDescriptor, MemberVisitor extraMemberVisitor) {
        ProgramMethod programMethod = this.addAndReturnMethod(u2accessFlags, methodName, methodDescriptor);
        if (extraMemberVisitor != null) {
            extraMemberVisitor.visitProgramMethod(this.programClass, programMethod);
        }
        return this;
    }

    public ProgramMethod addAndReturnMethod(int u2accessFlags, String methodName, String methodDescriptor) {
        return this.addAndReturnMethod(u2accessFlags, methodName, methodDescriptor, 0, null);
    }

    public ClassBuilder addMethod(int u2accessFlags, String methodName, String methodDescriptor, int maxCodeFragmentLength, CodeBuilder codeBuilder) {
        return this.addMethod(u2accessFlags, methodName, methodDescriptor, maxCodeFragmentLength, codeBuilder, null);
    }

    public ClassBuilder addMethod(int u2accessFlags, String methodName, String methodDescriptor, int maxCodeFragmentLength, CodeBuilder codeBuilder, MemberVisitor extraMemberVisitor) {
        ProgramMethod programMethod = this.addAndReturnMethod(u2accessFlags, methodName, methodDescriptor, maxCodeFragmentLength, codeBuilder);
        if (extraMemberVisitor != null) {
            extraMemberVisitor.visitProgramMethod(this.programClass, programMethod);
        }
        return this;
    }

    public ProgramMethod addAndReturnMethod(int u2accessFlags, String methodName, String methodDescriptor, int maxCodeFragmentLength, CodeBuilder codeBuilder) {
        ProgramMethod programMethod = new ProgramMethod(u2accessFlags, this.constantPoolEditor.addUtf8Constant(methodName), this.constantPoolEditor.addUtf8Constant(methodDescriptor), null);
        if (codeBuilder != null) {
            CodeAttribute codeAttribute = new CodeAttribute(this.constantPoolEditor.addUtf8Constant("Code"));
            CompactCodeAttributeComposer compactCodeAttributeComposer = new CompactCodeAttributeComposer(this.programClass);
            compactCodeAttributeComposer.beginCodeFragment(maxCodeFragmentLength);
            codeBuilder.compose(compactCodeAttributeComposer);
            compactCodeAttributeComposer.endCodeFragment();
            compactCodeAttributeComposer.visitCodeAttribute(this.programClass, programMethod, codeAttribute);
            new AttributesEditor(this.programClass, programMethod, false).addAttribute(codeAttribute);
        }
        this.classEditor.addMethod(programMethod);
        return programMethod;
    }

    public static void main(String[] args) {
        ProgramClass programClass = new ClassBuilder(0x340000, 1, "com/example/Test", "java/lang/Object").addMethod(9, "main", "([Ljava/lang/String;)V", 50, code -> code.getstatic("java/lang/System", "out", "Ljava/io/PrintStream;").ldc("Hello, world!").invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V").return_()).getProgramClass();
        try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream("Test.class"));){
            programClass.accept(new ProgramClassWriter(dataOutputStream));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static interface CodeBuilder {
        public void compose(CompactCodeAttributeComposer var1);
    }
}

