/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.StoringInvocationUnit;

public class LoadingInvocationUnit
extends BasicInvocationUnit {
    private final boolean loadFieldValues;
    private final boolean loadMethodParameterValues;
    private final boolean loadMethodReturnValues;

    public LoadingInvocationUnit(ValueFactory valueFactory) {
        this(valueFactory, true, true, true);
    }

    public LoadingInvocationUnit(ValueFactory valueFactory, boolean loadFieldValues, boolean loadMethodParameterValues, boolean loadMethodReturnValues) {
        super(valueFactory);
        this.loadFieldValues = loadFieldValues;
        this.loadMethodParameterValues = loadMethodParameterValues;
        this.loadMethodReturnValues = loadMethodReturnValues;
    }

    @Override
    public Value getFieldClassValue(Clazz clazz, FieldrefConstant fieldrefConstant, String type) {
        ReferenceValue value;
        Field referencedField;
        if (this.loadFieldValues && (referencedField = fieldrefConstant.referencedField) != null && (value = StoringInvocationUnit.getFieldClassValue(referencedField)) != null) {
            return value;
        }
        return super.getFieldClassValue(clazz, fieldrefConstant, type);
    }

    @Override
    public Value getFieldValue(Clazz clazz, FieldrefConstant fieldrefConstant, String type) {
        Value value;
        Field referencedField;
        if (this.loadFieldValues && (referencedField = fieldrefConstant.referencedField) != null && (value = StoringInvocationUnit.getFieldValue(referencedField)) != null) {
            return value;
        }
        return super.getFieldValue(clazz, fieldrefConstant, type);
    }

    @Override
    public Value getMethodParameterValue(Clazz clazz, Method method, int parameterIndex, String type, Clazz referencedClass) {
        Value value;
        if (this.loadMethodParameterValues && (value = StoringInvocationUnit.getMethodParameterValue(method, parameterIndex)) != null) {
            return value;
        }
        return super.getMethodParameterValue(clazz, method, parameterIndex, type, referencedClass);
    }

    @Override
    public Value getMethodReturnValue(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, String type) {
        Value value;
        Method referencedMethod;
        if (this.loadMethodReturnValues && (referencedMethod = anyMethodrefConstant.referencedMethod) != null && (value = StoringInvocationUnit.getMethodReturnValue(referencedMethod)) != null) {
            return value;
        }
        return super.getMethodReturnValue(clazz, anyMethodrefConstant, type);
    }
}

