/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.DummyDataEntry;
import proguard.io.ExtraDataEntryNameMap;

public class ExtraDataEntryWriter
implements DataEntryWriter {
    private final ExtraDataEntryNameMap extraEntryNameMap;
    private final DataEntryWriter dataEntryWriter;
    private final DataEntryWriter extraDataEntryWriter;
    private final Set<String> extraEntryNamesWritten = new HashSet<String>();

    public ExtraDataEntryWriter(String extraEntryName, DataEntryWriter dataEntryWriter) {
        this(extraEntryName, dataEntryWriter, dataEntryWriter);
    }

    public ExtraDataEntryWriter(String extraEntryName, DataEntryWriter dataEntryWriter, DataEntryWriter extraDataEntryWriter) {
        this(new ExtraDataEntryNameMap(), dataEntryWriter, extraDataEntryWriter);
        this.extraEntryNameMap.addExtraDataEntry(extraEntryName);
    }

    public ExtraDataEntryWriter(ExtraDataEntryNameMap extraEntryNameMap, DataEntryWriter dataEntryWriter, DataEntryWriter extraDataEntryWriter) {
        this.extraEntryNameMap = extraEntryNameMap;
        this.dataEntryWriter = dataEntryWriter;
        this.extraDataEntryWriter = extraDataEntryWriter;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(dataEntry);
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry1, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        DataEntry parentEntry = dataEntry.getParent();
        this.writeExtraEntries(parentEntry, this.extraEntryNameMap.getDefaultExtraDataEntryNames());
        this.writeExtraEntries(parentEntry, this.extraEntryNameMap.getExtraDataEntryNames(dataEntry.getName()));
        return this.dataEntryWriter.createOutputStream(dataEntry);
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "ExtraDataEntryWriter");
        this.dataEntryWriter.println(pw, prefix + "  ");
    }

    private void writeExtraEntries(DataEntry parentEntry, Set<String> extraEntryNames) throws IOException {
        if (extraEntryNames != null) {
            for (String extraEntryName : extraEntryNames) {
                if (this.extraEntryNamesWritten.contains(extraEntryName)) continue;
                this.extraEntryNamesWritten.add(extraEntryName);
                DummyDataEntry extraEntry = new DummyDataEntry(parentEntry, extraEntryName, 0L, false);
                this.extraDataEntryWriter.createOutputStream(extraEntry);
                this.writeExtraEntries(parentEntry, this.extraEntryNameMap.getExtraDataEntryNames(extraEntryName));
            }
        }
    }
}

