/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryWriterFactory;
import proguard.InputReader;
import proguard.classfile.ClassPool;
import proguard.classfile.io.visitor.ProcessingFlagDataEntryFilter;
import proguard.classfile.util.ClassUtil;
import proguard.io.ClassFilter;
import proguard.io.ClassMapDataEntryWriter;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryRewriter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryFilter;
import proguard.io.ExtraDataEntryNameMap;
import proguard.io.ExtraDataEntryReader;
import proguard.io.ExtraDataEntryWriter;
import proguard.io.FilteredDataEntryWriter;
import proguard.io.IdleRewriter;
import proguard.io.ManifestRewriter;
import proguard.io.NameFilteredDataEntryReader;
import proguard.io.NameFilteredDataEntryWriter;
import proguard.io.RenamedDataEntryReader;
import proguard.io.RenamedDataEntryWriter;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.util.ResourceFilePoolNameFunction;
import proguard.resources.kotlinmodule.io.KotlinModuleDataEntryWriter;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.MapStringFunction;
import proguard.util.StringMatcher;

public class OutputWriter {
    private final Configuration configuration;

    public OutputWriter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool, ResourceFilePool resourceFilePool, ExtraDataEntryNameMap extraDataEntryNameMap) throws IOException {
        ClassPath programJars = this.configuration.programJars;
        StringMatcher uncompressedFilter = this.configuration.dontCompress == null ? null : new ListParser(new FileNameParser()).parse(this.configuration.dontCompress);
        KeyStore.PrivateKeyEntry[] privateKeyEntries = this.retrievePrivateKeys(this.configuration);
        Date currentDate = new Date();
        int modificationTime = currentDate.getYear() - 80 << 25 | currentDate.getMonth() + 1 << 21 | currentDate.getDate() << 16 | currentDate.getHours() << 11 | currentDate.getMinutes() << 5 | currentDate.getSeconds() >> 1;
        DataEntryWriterFactory dataEntryWriterFactory = new DataEntryWriterFactory(programClassPool, resourceFilePool, modificationTime, uncompressedFilter, this.configuration.zipAlign, this.configuration.android, this.configuration.obfuscate, privateKeyEntries);
        int firstInputIndex = 0;
        int lastInputIndex = 0;
        for (int index = 0; index < programJars.size(); ++index) {
            ClassPathEntry entry = programJars.get(index);
            if (!entry.isOutput()) {
                lastInputIndex = index;
                continue;
            }
            int nextIndex = index + 1;
            if (nextIndex != programJars.size() && programJars.get(nextIndex).isOutput()) continue;
            this.writeOutput(dataEntryWriterFactory, programClassPool, resourceFilePool, extraDataEntryNameMap, programJars, firstInputIndex, lastInputIndex + 1, nextIndex);
            firstInputIndex = nextIndex;
        }
    }

    private KeyStore.PrivateKeyEntry[] retrievePrivateKeys(Configuration configuration) throws IOException {
        List<File> keyStoreFiles = configuration.keyStores;
        List<String> keyStorePasswords = configuration.keyStorePasswords;
        List<String> keyAliases = configuration.keyAliases;
        List<String> keyPasswords = configuration.keyPasswords;
        if (keyStoreFiles == null || keyStorePasswords == null || keyAliases == null || keyPasswords == null) {
            if (!(keyStoreFiles == null && keyStorePasswords == null && keyAliases == null && keyPasswords == null || configuration.note != null && configuration.note.isEmpty())) {
                StringBuffer missing = new StringBuffer();
                StringBuffer specified = new StringBuffer();
                (keyStoreFiles == null ? missing : specified).append("a key store file, ");
                (keyStorePasswords == null ? missing : specified).append("a key store password, ");
                (keyAliases == null ? missing : specified).append("a key alias, ");
                (keyPasswords == null ? missing : specified).append("a key password, ");
                System.out.println("Note: you've specified " + specified.toString());
                System.out.println("      but not " + missing.substring(0, missing.length() - 2) + ".");
                System.out.println("      You should specify the missing parameters to sign the output jars.");
            }
            return null;
        }
        try {
            int keyCount = Math.max(keyStoreFiles.size(), keyAliases.size());
            KeyStore.PrivateKeyEntry[] privateKeys = new KeyStore.PrivateKeyEntry[keyCount];
            HashMap<X509Certificate, Integer> certificates = new HashMap<X509Certificate, Integer>(keyCount);
            for (int index = 0; index < keyCount; ++index) {
                String keyPassword;
                String keyAlias;
                String keyStorePassword;
                File keyStoreFile = keyStoreFiles.get(Math.min(index, keyStoreFiles.size() - 1));
                KeyStore.PrivateKeyEntry privateKeyEntry = this.retrievePrivateKey(keyStoreFile, keyStorePassword = keyStorePasswords.get(Math.min(index, keyStorePasswords.size() - 1)), keyAlias = keyAliases.get(Math.min(index, keyAliases.size() - 1)), keyPassword = keyPasswords.get(Math.min(index, keyPasswords.size() - 1)));
                X509Certificate certificate = (X509Certificate)privateKeyEntry.getCertificate();
                Integer duplicateIndex = certificates.put(certificate, index);
                if (duplicateIndex != null) {
                    throw new IllegalArgumentException("Duplicate specified signing certificates #" + (duplicateIndex + 1) + " and #" + (index + 1) + " out of " + keyCount + " [" + certificate.getSubjectDN().getName() + "]");
                }
                privateKeys[index] = privateKeyEntry;
            }
            return privateKeys;
        }
        catch (Exception e) {
            throw new IOException("Can't sign jar (" + e.getMessage() + ")", e);
        }
    }

    private KeyStore.PrivateKeyEntry retrievePrivateKey(File keyStoreFile, String keyStorePassword, String keyAlias, String keyPassword) throws IOException, GeneralSecurityException {
        FileInputStream keyStoreInputStream = new FileInputStream(keyStoreFile);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(keyStoreInputStream, keyStorePassword.toCharArray());
        keyStoreInputStream.close();
        KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(keyPassword.toCharArray());
        KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, protectionParameter);
        if (entry == null) {
            throw new GeneralSecurityException("Can't find key alias '" + keyAlias + "' in key store [" + keyStoreFile.getPath() + "]");
        }
        return entry;
    }

    private void writeOutput(DataEntryWriterFactory dataEntryWriterFactory, ClassPool programClassPool, ResourceFilePool resourceFilePool, ExtraDataEntryNameMap extraDataEntryNameMap, ClassPath classPath, int fromInputIndex, int fromOutputIndex, int toOutputIndex) throws IOException {
        try {
            DataEntryCopier resourceCopier;
            DataEntryWriter writer = dataEntryWriterFactory.createDataEntryWriter(classPath, fromOutputIndex, toOutputIndex, null);
            if (this.configuration.addConfigurationDebugging) {
                writer = new ExtraDataEntryWriter("classmap.txt", writer, (DataEntryWriter)new ClassMapDataEntryWriter(programClassPool, writer));
                System.err.println("Warning: -addconfigurationdebugging is enabled; the resulting build will contain obfuscation information.");
                System.err.println("It should only be used for debugging purposes.");
            }
            DataEntryWriter resourceWriter = writer;
            if (this.configuration.obfuscate && this.configuration.adaptResourceFileNames != null) {
                resourceWriter = this.renameResourceFiles(resourceFilePool, resourceWriter);
            }
            if (this.configuration.keepKotlinMetadata && (this.configuration.shrink || this.configuration.obfuscate)) {
                resourceWriter = new NameFilteredDataEntryWriter("META-INF/*.kotlin_module", (DataEntryWriter)new FilteredDataEntryWriter(new ProcessingFlagDataEntryFilter(resourceFilePool, 0, 8192), new KotlinModuleDataEntryWriter(resourceFilePool, resourceWriter)), resourceWriter);
            }
            DataEntryReader resourceRewriter = resourceCopier = new DataEntryCopier(resourceWriter);
            if ((this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate) && this.configuration.adaptResourceFileContents != null) {
                DataEntryReader adaptingContentWriter = resourceRewriter;
                if (this.configuration.obfuscate) {
                    adaptingContentWriter = this.adaptResourceFiles(programClassPool, resourceWriter);
                }
                resourceRewriter = new NameFilteredDataEntryReader(this.configuration.adaptResourceFileContents, adaptingContentWriter, resourceRewriter);
            }
            DataEntryReader reader = this.writeDirectories(programClassPool, resourceCopier, resourceRewriter);
            reader = new ClassFilter(new IdleRewriter(writer), reader);
            reader = new ExtraDataEntryReader(extraDataEntryNameMap, reader);
            new InputReader(this.configuration).readInput("  Copying resources from program ", classPath, fromInputIndex, fromOutputIndex, reader);
            writer.close();
        }
        catch (IOException ex) {
            throw (IOException)new IOException("Can't write [" + classPath.get(fromOutputIndex).getName() + "] (" + ex.getMessage() + ")").initCause(ex);
        }
    }

    private DataEntryWriter renameResourceFiles(ResourceFilePool resourceFilePool, DataEntryWriter dataEntryWriter) {
        return new RenamedDataEntryWriter(new ResourceFilePoolNameFunction(resourceFilePool), dataEntryWriter);
    }

    private DataEntryReader adaptResourceFiles(ClassPool programClassPool, DataEntryWriter writer) {
        Charset charset = this.configuration.android ? Charset.forName("UTF-8") : Charset.defaultCharset();
        return new NameFilteredDataEntryReader("META-INF/MANIFEST.MF,META-INF/*.SF", (DataEntryReader)new ManifestRewriter(programClassPool, charset, writer), (DataEntryReader)new DataEntryRewriter(programClassPool, charset, writer));
    }

    private DirectoryFilter writeDirectories(ClassPool programClassPool, DataEntryReader directoryCopier, DataEntryReader fileCopier) {
        NameFilteredDataEntryReader directoryRewriter = null;
        if (this.configuration.keepDirectories != null) {
            MapStringFunction packagePrefixFunction = new MapStringFunction(OutputWriter.createPackagePrefixMap(programClassPool));
            directoryRewriter = new NameFilteredDataEntryReader(this.configuration.keepDirectories, (DataEntryReader)new RenamedDataEntryReader(packagePrefixFunction, directoryCopier, directoryCopier));
        }
        return new DirectoryFilter(directoryRewriter, fileCopier);
    }

    private static Map createPackagePrefixMap(ClassPool classPool) {
        HashMap<String, String> packagePrefixMap = new HashMap<String, String>();
        Iterator<String> iterator2 = classPool.classNames();
        while (iterator2.hasNext()) {
            String className = iterator2.next();
            String packagePrefix = ClassUtil.internalPackagePrefix(className);
            String mappedNewPackagePrefix = (String)packagePrefixMap.get(packagePrefix);
            if (mappedNewPackagePrefix != null && mappedNewPackagePrefix.equals(packagePrefix)) continue;
            String newClassName = classPool.getClass(className).getName();
            String newPackagePrefix = ClassUtil.internalPackagePrefix(newClassName);
            packagePrefixMap.put(packagePrefix, newPackagePrefix);
        }
        return packagePrefixMap;
    }
}

