/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.appbundler;

import java.io.File;
import org.apache.tools.ant.BuildException;

public class BundleDocument {
    private String name = "editor";
    private String role = "";
    private File icon = null;
    private String[] extensions;
    private boolean isPackage = false;

    private static String capitalizeFirst(String string) {
        char[] stringArray = string.toCharArray();
        stringArray[0] = Character.toUpperCase(stringArray[0]);
        return new String(stringArray);
    }

    public void setExtensions(String extensionsList) {
        if (extensionsList == null) {
            throw new BuildException("Extensions can't be null");
        }
        this.extensions = extensionsList.split(",");
        for (int i = 0; i < this.extensions.length; ++i) {
            this.extensions[i] = this.extensions[i].trim().toLowerCase();
        }
    }

    public void setIcon(File icon) {
        this.icon = icon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRole(String role) {
        this.role = BundleDocument.capitalizeFirst(role);
    }

    public void setIsPackage(String isPackageString) {
        this.isPackage = isPackageString.trim().equalsIgnoreCase("true");
    }

    public String getIconName() {
        return this.icon.getName();
    }

    public File getIconFile() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getRole() {
        return this.role;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public boolean hasIcon() {
        return this.icon != null;
    }

    public boolean isPackage() {
        return this.isPackage;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getName());
        s.append(" ").append(this.getRole()).append(" ").append(this.getIconName()).append(" ");
        for (String extension : this.extensions) {
            s.append(extension).append(" ");
        }
        return s.toString();
    }
}

