/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.appbundler;

import com.oracle.appbundler.Architecture;
import com.oracle.appbundler.Argument;
import com.oracle.appbundler.BundleDocument;
import com.oracle.appbundler.Option;
import com.oracle.appbundler.PropertyLister;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.resources.FileResource;

public class AppBundlerTask
extends Task {
    private File outputDirectory = null;
    private String name = null;
    private String displayName = null;
    private String identifier = null;
    private File iconFile = null;
    private String executableName = "JavaAppLauncher";
    private String shortVersion = null;
    private String version = null;
    private String signature = "????";
    private String copyright = null;
    private String getInfo = null;
    private String privileged = null;
    private String workingDirectory = null;
    private String applicationCategory = null;
    private boolean highResolutionCapable = true;
    private String minimumSystem = "10.8.3";
    private boolean javafx = false;
    private String mainClassName = null;
    private FileSet runtime = null;
    private ArrayList<FileSet> classPath = new ArrayList();
    private ArrayList<FileSet> libraryPath = new ArrayList();
    private ArrayList<String> options = new ArrayList();
    private ArrayList<String> arguments = new ArrayList();
    private ArrayList<String> architectures = new ArrayList();
    private ArrayList<BundleDocument> bundleDocuments = new ArrayList();
    private Reference classPathRef;
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    private static final String DEFAULT_ICON_NAME = "GenericApp.icns";
    private static final String OS_TYPE_CODE = "APPL";
    private static final int BUFFER_SIZE = 2048;

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setIcon(File icon) {
        this.iconFile = icon;
    }

    public void setExecutableName(String executable) {
        this.executableName = executable;
    }

    public void setShortVersion(String shortVersion) {
        this.shortVersion = shortVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setGetInfo(String getInfo) {
        this.getInfo = getInfo;
    }

    public void setPrivileged(String privileged) {
        this.privileged = privileged;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setApplicationCategory(String applicationCategory) {
        this.applicationCategory = applicationCategory;
    }

    public void setMinimumSystem(String minimumSystem) {
        this.minimumSystem = minimumSystem;
    }

    public void setHighResolutionCapable(boolean highResolutionCapable) {
        this.highResolutionCapable = highResolutionCapable;
    }

    public void setJavaFX(boolean javafx) {
        this.javafx = javafx;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public void addConfiguredRuntime(FileSet runtime) throws BuildException {
        if (this.runtime != null) {
            throw new BuildException("Runtime already specified.");
        }
        this.runtime = runtime;
        runtime.appendIncludes(new String[]{"jre/"});
        runtime.appendExcludes(new String[]{"bin/", "jre/bin/orbd", "jre/bin/pack200", "jre/bin/policytool", "jre/bin/rmid", "jre/bin/rmiregistry", "jre/bin/servertool", "jre/bin/tnameserv", "jre/bin/unpack200", "jre/lib/deploy/", "jre/lib/deploy.jar", "jre/lib/javaws.jar", "jre/lib/libdeploy.dylib", "jre/lib/libnpjp2.dylib", "jre/lib/plugin.jar", "jre/lib/security/javaws.policy"});
        if (!this.javafx) {
            runtime.appendExcludes(new String[]{"jre/THIRDPARTYLICENSEREADME-JAVAFX.txt", "jre/lib/javafx.properties", "jre/lib/jfxrt.jar", "jre/lib/security/javafx.policy", "jre/lib/fxplugins.dylib", "jre/lib/libdecora-sse.dylib", "jre/lib/libglass.dylib", "jre/lib/libglib-2.0.0.dylib", "jre/lib/libgstplugins-lite.dylib", "jre/lib/libgstreamer-lite.dylib", "jre/lib/libjavafx-font.dylib", "jre/lib/libjavafx-iio.dylib", "jre/lib/libjfxmedia.dylib", "jre/lib/libjfxwebkit.dylib", "jre/lib/libprism-es2.dylib"});
        }
    }

    public void setClasspathRef(Reference ref) {
        this.classPathRef = ref;
    }

    public void addConfiguredClassPath(FileSet classPath) {
        this.classPath.add(classPath);
    }

    public void addConfiguredLibraryPath(FileSet libraryPath) {
        this.libraryPath.add(libraryPath);
    }

    public void addConfiguredBundleDocument(BundleDocument document) {
        this.bundleDocuments.add(document);
    }

    public void addConfiguredOption(Option option) throws BuildException {
        String value = option.getValue();
        if (value == null) {
            throw new BuildException("Value is required.");
        }
        this.options.add(value);
    }

    public void addConfiguredArgument(Argument argument) throws BuildException {
        String value = argument.getValue();
        if (value == null) {
            throw new BuildException("Value is required.");
        }
        this.arguments.add(value);
    }

    public void addConfiguredArch(Architecture architecture) throws BuildException {
        String name = architecture.getName();
        if (name == null) {
            throw new BuildException("Name is required.");
        }
        this.architectures.add(name);
    }

    public void execute() throws BuildException {
        if (this.outputDirectory == null) {
            throw new IllegalStateException("Output directory is required.");
        }
        if (!this.outputDirectory.exists()) {
            throw new IllegalStateException("Output directory does not exist.");
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new IllegalStateException("Invalid output directory.");
        }
        if (this.name == null) {
            throw new IllegalStateException("Name is required.");
        }
        if (this.displayName == null) {
            throw new IllegalStateException("Display name is required.");
        }
        if (this.identifier == null) {
            throw new IllegalStateException("Identifier is required.");
        }
        if (this.iconFile != null) {
            if (!this.iconFile.exists()) {
                throw new IllegalStateException("Icon does not exist.");
            }
            if (this.iconFile.isDirectory()) {
                throw new IllegalStateException("Invalid icon.");
            }
        }
        if (this.shortVersion == null) {
            throw new IllegalStateException("Short version is required.");
        }
        if (this.signature == null) {
            throw new IllegalStateException("Signature is required.");
        }
        if (this.signature.length() != 4) {
            throw new IllegalStateException("Invalid signature.");
        }
        if (this.copyright == null) {
            throw new IllegalStateException("Copyright is required.");
        }
        if (this.mainClassName == null) {
            throw new IllegalStateException("Main class name is required.");
        }
        try {
            System.out.println("Creating app bundle: " + this.name);
            File rootDirectory = new File(this.outputDirectory, this.name + ".app");
            AppBundlerTask.delete(rootDirectory);
            rootDirectory.mkdir();
            File contentsDirectory = new File(rootDirectory, "Contents");
            contentsDirectory.mkdir();
            File macOSDirectory = new File(contentsDirectory, "MacOS");
            macOSDirectory.mkdir();
            File javaDirectory = new File(contentsDirectory, "Java");
            javaDirectory.mkdir();
            File plugInsDirectory = new File(contentsDirectory, "PlugIns");
            plugInsDirectory.mkdir();
            File resourcesDirectory = new File(contentsDirectory, "Resources");
            resourcesDirectory.mkdir();
            File infoPlistFile = new File(contentsDirectory, "Info.plist");
            infoPlistFile.createNewFile();
            this.writeInfoPlist(infoPlistFile);
            File pkgInfoFile = new File(contentsDirectory, "PkgInfo");
            pkgInfoFile.createNewFile();
            this.writePkgInfo(pkgInfoFile);
            File executableFile = new File(macOSDirectory, this.executableName);
            AppBundlerTask.copy(((Object)((Object)this)).getClass().getResource(EXECUTABLE_NAME), executableFile);
            executableFile.setExecutable(true, false);
            this.copyResources(resourcesDirectory);
            this.copyRuntime(plugInsDirectory);
            this.copyClassPathEntries(javaDirectory);
            this.copyClassPathRefEntries(javaDirectory);
            this.copyLibraryPathEntries(macOSDirectory);
            this.copyIcon(resourcesDirectory);
            this.copyBundleIcons(resourcesDirectory);
        }
        catch (IOException exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResources(File resourcesDirectory) throws IOException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("res.zip");
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                File file = new File(resourcesDirectory, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file.mkdir();
                } else {
                    try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file), 2048);){
                        int b = zipInputStream.read();
                        while (b != -1) {
                            ((OutputStream)outputStream).write(b);
                            b = zipInputStream.read();
                        }
                        ((OutputStream)outputStream).flush();
                    }
                    file.setLastModified(zipEntry.getTime());
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
    }

    private void copyRuntime(File plugInsDirectory) throws IOException {
        if (this.runtime != null) {
            String[] includedFiles;
            File runtimeHomeDirectory = this.runtime.getDir();
            File runtimeContentsDirectory = runtimeHomeDirectory.getParentFile();
            File runtimeDirectory = runtimeContentsDirectory.getParentFile();
            File pluginDirectory = new File(plugInsDirectory, runtimeDirectory.getName());
            pluginDirectory.mkdir();
            File pluginContentsDirectory = new File(pluginDirectory, runtimeContentsDirectory.getName());
            pluginContentsDirectory.mkdir();
            File runtimeMacOSDirectory = new File(runtimeContentsDirectory, "MacOS");
            AppBundlerTask.copy(runtimeMacOSDirectory, new File(pluginContentsDirectory, runtimeMacOSDirectory.getName()));
            File runtimeInfoPlistFile = new File(runtimeContentsDirectory, "Info.plist");
            AppBundlerTask.copy(runtimeInfoPlistFile, new File(pluginContentsDirectory, runtimeInfoPlistFile.getName()));
            File pluginHomeDirectory = new File(pluginContentsDirectory, runtimeHomeDirectory.getName());
            DirectoryScanner directoryScanner = this.runtime.getDirectoryScanner(this.getProject());
            for (String includedFile : includedFiles = directoryScanner.getIncludedFiles()) {
                File source = new File(runtimeHomeDirectory, includedFile);
                File destination = new File(pluginHomeDirectory, includedFile);
                AppBundlerTask.copy(source, destination);
            }
        }
    }

    private void copyClassPathRefEntries(File javaDirectory) throws IOException {
        if (this.classPathRef != null) {
            Path classpath = (Path)this.classPathRef.getReferencedObject(this.getProject());
            for (FileResource resource : classpath) {
                File source = resource.getFile();
                File destination = new File(javaDirectory, source.getName());
                AppBundlerTask.copy(source, destination);
            }
        }
    }

    private void copyClassPathEntries(File javaDirectory) throws IOException {
        for (FileSet fileSet : this.classPath) {
            String[] includedFiles;
            File classPathDirectory = fileSet.getDir();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            for (String includedFile : includedFiles = directoryScanner.getIncludedFiles()) {
                File source = new File(classPathDirectory, includedFile);
                File destination = new File(javaDirectory, new File(includedFile).getName());
                AppBundlerTask.copy(source, destination);
            }
        }
    }

    private void copyLibraryPathEntries(File macOSDirectory) throws IOException {
        for (FileSet fileSet : this.libraryPath) {
            String[] includedFiles;
            File libraryPathDirectory = fileSet.getDir();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            for (String includedFile : includedFiles = directoryScanner.getIncludedFiles()) {
                File source = new File(libraryPathDirectory, includedFile);
                File destination = new File(macOSDirectory, new File(includedFile).getName());
                AppBundlerTask.copy(source, destination);
            }
        }
    }

    private void copyIcon(File resourcesDirectory) throws IOException {
        if (this.iconFile == null) {
            AppBundlerTask.copy(((Object)((Object)this)).getClass().getResource(DEFAULT_ICON_NAME), new File(resourcesDirectory, DEFAULT_ICON_NAME));
        } else {
            AppBundlerTask.copy(this.iconFile, new File(resourcesDirectory, this.iconFile.getName()));
        }
    }

    private void copyBundleIcons(File resourcesDirectory) throws IOException {
        for (BundleDocument bundleDocument : this.bundleDocuments) {
            if (!bundleDocument.hasIcon()) continue;
            File iconFile = bundleDocument.getIconFile();
            AppBundlerTask.copy(iconFile, new File(resourcesDirectory, iconFile.getName()));
        }
    }

    private void writeInfoPlist(File file) throws IOException {
        FileOutputStream output = new FileOutputStream(file);
        PropertyLister plist = new PropertyLister(output);
        plist.writeStartDocument();
        plist.writeStartDictElement();
        plist.writeProperty("CFBundleDevelopmentRegion", "English");
        plist.writeProperty("CFBundleExecutable", this.executableName);
        plist.writeProperty("CFBundleIconFile", this.iconFile == null ? DEFAULT_ICON_NAME : this.iconFile.getName());
        plist.writeProperty("CFBundleIdentifier", this.identifier);
        plist.writeProperty("CFBundleDisplayName", this.displayName);
        plist.writeProperty("CFBundleInfoDictionaryVersion", "6.0");
        plist.writeProperty("CFBundleName", this.name);
        plist.writeProperty("CFBundlePackageType", OS_TYPE_CODE);
        plist.writeProperty("CFBundleShortVersionString", this.shortVersion);
        plist.writeProperty("CFBundleVersion", this.version);
        plist.writeProperty("CFBundleSignature", this.signature);
        plist.writeProperty("NSHumanReadableCopyright", this.copyright);
        if (this.getInfo != null) {
            plist.writeProperty("CFBundleGetInfoString", this.getInfo);
        }
        if (this.applicationCategory != null) {
            plist.writeProperty("LSApplicationCategoryType", this.applicationCategory);
        }
        if (this.minimumSystem != null) {
            plist.writeProperty("LSMinimumSystemVersion", this.minimumSystem);
        }
        if (this.highResolutionCapable) {
            plist.writeKey("NSHighResolutionCapable");
            plist.writeBoolean(true);
        }
        if (this.runtime != null) {
            plist.writeProperty("JVMRuntime", this.runtime.getDir().getParentFile().getParentFile().getName());
        }
        if (this.privileged != null) {
            plist.writeProperty("JVMRunPrivileged", this.privileged);
        }
        if (this.workingDirectory != null) {
            plist.writeProperty("WorkingDirectory", this.workingDirectory);
        }
        plist.writeProperty("JVMMainClassName", this.mainClassName);
        plist.writeKey("CFBundleDocumentTypes");
        plist.writeStartArrayElement();
        for (BundleDocument bundleDocument : this.bundleDocuments) {
            plist.writeStartDictElement();
            plist.writeKey("CFBundleTypeExtensions");
            plist.writeStartArrayElement();
            for (String extension : bundleDocument.getExtensions()) {
                plist.writeString(extension);
            }
            plist.writeEndElement();
            if (bundleDocument.hasIcon()) {
                plist.writeKey("CFBundleTypeIconFile");
                plist.writeString(bundleDocument.getIconName());
            }
            plist.writeKey("CFBundleTypeName");
            plist.writeString(bundleDocument.getName());
            plist.writeKey("CFBundleTypeRole");
            plist.writeString(bundleDocument.getRole());
            plist.writeKey("LSTypeIsPackage");
            plist.writeBoolean(bundleDocument.isPackage());
            plist.writeEndElement();
        }
        plist.writeEndElement();
        plist.writeKey("LSArchitecturePriority");
        plist.writeStartArrayElement();
        for (String architecture : this.architectures) {
            plist.writeString(architecture);
        }
        plist.writeEndElement();
        plist.writeKey("LSEnvironment");
        plist.writeStartDictElement();
        plist.writeKey("LC_CTYPE");
        plist.writeString("UTF-8");
        plist.writeEndElement();
        plist.writeKey("JVMOptions");
        plist.writeStartArrayElement();
        for (String option : this.options) {
            plist.writeString(option);
        }
        plist.writeEndElement();
        plist.writeKey("JVMArguments");
        plist.writeStartArrayElement();
        for (String argument : this.arguments) {
            plist.writeString(argument);
        }
        plist.writeEndElement();
        plist.writeEndElement();
        plist.writeEndDocument();
    }

    private void writePkgInfo(File file) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            out.write(OS_TYPE_CODE + this.signature);
            ((Writer)out).flush();
        }
    }

    private static void delete(File file) throws IOException {
        java.nio.file.Path filePath = file.toPath();
        if (Files.exists(filePath, LinkOption.NOFOLLOW_LINKS)) {
            if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    AppBundlerTask.delete(files[i]);
                }
            }
            Files.delete(filePath);
        }
    }

    private static void copy(URL location, File file) throws IOException {
        try (InputStream in = location.openStream();){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void copy(File source, File destination) throws IOException {
        java.nio.file.Path sourcePath = source.toPath();
        java.nio.file.Path destinationPath = destination.toPath();
        destination.getParentFile().mkdirs();
        Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
        if (Files.isDirectory(sourcePath, LinkOption.NOFOLLOW_LINKS)) {
            String[] files;
            for (String file : files = source.list()) {
                AppBundlerTask.copy(new File(source, file), new File(destination, file));
            }
        }
    }
}

