/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Clipping {
    public static final int LEFT = 1;
    public static final int H_CENTER = 2;
    public static final int RIGHT = 4;
    public static final int BELOW = 16;
    public static final int V_CENTER = 32;
    public static final int ABOVE = 64;
    public static final int INSIDE = 34;
    public static final int OUTSIDE = 85;

    public static void drawLine(Graphics g, Point p1, Point p2, Rectangle rect) {
        Clipping.drawLine(g, p1.x, p1.y, p2.x, p2.y, rect);
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2, Rectangle rect) {
        Clipping.drawLine(g, x1, y1, x2, y2, rect.x, rect.x + rect.width, rect.y, rect.y + rect.height);
    }

    public static void drawLine(Graphics g, Point p1, Point p2, int xmin, int xmax, int ymin, int ymax) {
        Clipping.drawLine(g, p1.x, p1.y, p2.x, p2.y, xmin, xmax, ymin, ymax);
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2, int xmin, int xmax, int ymin, int ymax) {
        int mask1 = 0;
        int mask2 = 0;
        mask1 = x1 < xmin ? (mask1 |= 1) : (x1 >= xmax ? (mask1 |= 4) : (mask1 |= 2));
        mask1 = y1 < ymin ? (mask1 |= 0x10) : (y1 >= ymax ? (mask1 |= 0x40) : (mask1 |= 0x20));
        mask2 = x2 < xmin ? (mask2 |= 1) : (x2 >= xmax ? (mask2 |= 4) : (mask2 |= 2));
        mask2 = y2 < ymin ? (mask2 |= 0x10) : (y2 >= ymax ? (mask2 |= 0x40) : (mask2 |= 0x20));
        Clipping.drawLine(g, x1, y1, mask1, x2, y2, mask2, xmin, xmax, ymin, ymax);
    }

    protected static void drawLine(Graphics g, int x1, int y1, int mask1, int x2, int y2, int mask2, int xmin, int xmax, int ymin, int ymax) {
        Point[] p;
        int mask = mask1 | mask2;
        if ((mask & 0x55) == 0) {
            g.drawLine(x1, y1, x2, y2);
        } else if ((mask & 3) != 0 && (mask & 6) != 0 && (mask & 0x30) != 0 && (mask & 0x60) != 0 && (p = Clipping.getClipped(x1, y1, mask1, x2, y2, mask2, xmin, xmax, ymin, ymax)) != null) {
            g.drawLine(p[0].x, p[0].y, p[1].x, p[1].y);
        }
    }

    public static void drawPolyline(Graphics g, int[] x, int[] y, int nPoints, Rectangle rect) {
        Clipping.drawPolyline(g, x, y, nPoints, rect.x, rect.x + rect.width, rect.y, rect.y + rect.height);
    }

    public static void drawPolyline(Graphics g, int[] x, int[] y, int nPoints, int xmin, int xmax, int ymin, int ymax) {
        if (nPoints <= 0) {
            return;
        }
        int[] masks = new int[nPoints];
        int mask = 0;
        int p = 0;
        while (p < nPoints) {
            if (x[p] < xmin) {
                int n = p;
                masks[n] = masks[n] | 1;
            } else if (x[p] >= xmax) {
                int n = p;
                masks[n] = masks[n] | 4;
            } else {
                int n = p;
                masks[n] = masks[n] | 2;
            }
            if (y[p] < ymin) {
                int n = p;
                masks[n] = masks[n] | 0x10;
            } else if (y[p] >= ymax) {
                int n = p;
                masks[n] = masks[n] | 0x40;
            } else {
                int n = p;
                masks[n] = masks[n] | 0x20;
            }
            mask |= masks[p];
            ++p;
        }
        if (nPoints == 1 && mask == 34) {
            g.drawLine(x[0], y[0], x[0], y[0]);
        } else {
            int p2 = 1;
            while (p2 < nPoints) {
                Clipping.drawLine(g, x[p2 - 1], y[p2 - 1], masks[p2 - 1], x[p2], y[p2], masks[p2], xmin, xmax, ymin, ymax);
                ++p2;
            }
        }
    }

    public static Point[] getClipped(int x1, int y1, int x2, int y2, int xmin, int xmax, int ymin, int ymax) {
        int mask1 = 0;
        int mask2 = 0;
        mask1 = x1 < xmin ? (mask1 |= 1) : (x1 >= xmax ? (mask1 |= 4) : (mask1 |= 2));
        mask1 = y1 < ymin ? (mask1 |= 0x10) : (y1 >= ymax ? (mask1 |= 0x40) : (mask1 |= 0x20));
        mask2 = x2 < xmin ? (mask2 |= 1) : (x2 >= xmax ? (mask2 |= 4) : (mask2 |= 2));
        mask2 = y2 < ymin ? (mask2 |= 0x10) : (y2 >= ymax ? (mask2 |= 0x40) : (mask2 |= 0x20));
        int mask = mask1 | mask2;
        if ((mask & 0x55) == 0) {
            Point[] ret = new Point[]{new Point(x1, y1), new Point(x2, y2)};
            return ret;
        }
        if ((mask & 3) == 0 || (mask & 6) == 0 || (mask & 0x30) == 0 || (mask & 0x60) == 0) {
            return null;
        }
        return Clipping.getClipped(x1, y1, mask1, x2, y2, mask2, xmin, xmax, ymin, ymax);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static Point[] getClipped(double x1, double y1, int mask1, double x2, double y2, int mask2, double xmin, double xmax, double ymin, double ymax) {
        Point p;
        int mask = mask1 ^ mask2;
        Point p1 = null;
        if (mask1 == 34) {
            p1 = new Point((int)(x1 + 0.5), (int)(y1 + 0.5));
            if (mask == 0) {
                Point[] ret = new Point[]{p1, new Point((int)(x2 + 0.5), (int)(y2 + 0.5))};
                return ret;
            }
        } else if (mask2 == 34) {
            p1 = new Point((int)(x2 + 0.5), (int)(y2 + 0.5));
        }
        if ((mask & 1) != 0 && (p = Clipping.intersect(x1, y1, x2, y2, xmin, ymin, xmin, ymax)) != null) {
            if (p1 != null) {
                Point[] ret = new Point[]{p1, p};
                return ret;
            }
            p1 = p;
        }
        if ((mask & 4) != 0 && (p = Clipping.intersect(x1, y1, x2, y2, xmax, ymin, xmax, ymax)) != null) {
            if (p1 != null) {
                Point[] ret = new Point[]{p1, p};
                return ret;
            }
            p1 = p;
        }
        if (mask1 == 17 || mask1 == 20) {
            if ((mask & 0x40) != 0 && (p = Clipping.intersect(x1, y1, x2, y2, xmin, ymax, xmax, ymax)) != null) {
                if (p1 != null) {
                    Point[] ret = new Point[]{p1, p};
                    return ret;
                }
                p1 = p;
            }
            if ((mask & 0x10) == 0) return null;
            p = Clipping.intersect(x1, y1, x2, y2, xmin, ymin, xmax, ymin);
            if (p == null) return null;
            if (p1 == null) {
                p1 = p;
                return null;
            }
            Point[] ret = new Point[]{p1, p};
            return ret;
        }
        if ((mask & 0x10) != 0 && (p = Clipping.intersect(x1, y1, x2, y2, xmin, ymin, xmax, ymin)) != null) {
            if (p1 != null) {
                Point[] ret = new Point[]{p1, p};
                return ret;
            }
            p1 = p;
        }
        if ((mask & 0x40) == 0) return null;
        p = Clipping.intersect(x1, y1, x2, y2, xmin, ymax, xmax, ymax);
        if (p == null) return null;
        if (p1 == null) {
            p1 = p;
            return null;
        }
        Point[] ret = new Point[]{p1, p};
        return ret;
    }

    private static Point intersect(double x11, double y11, double x12, double y12, double x21, double y21, double x22, double y22) {
        double mu;
        double dx2 = x22 - x21;
        double dy1 = y12 - y11;
        double dy2 = y22 - y21;
        double dx1 = x12 - x11;
        double det = dx2 * dy1 - dy2 * dx1;
        if (det != 0.0 && (mu = ((x11 - x21) * dy1 - (y11 - y21) * dx1) / det) >= 0.0 && mu <= 1.0) {
            Point p = new Point((int)(x21 + mu * dx2 + 0.5), (int)(y21 + mu * dy2 + 0.5));
            return p;
        }
        return null;
    }
}

