/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.RenderingHints;
import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.TransferFunction;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class ComponentTransferRed
extends AbstractRed {
    LookupOp operation;

    public ComponentTransferRed(CachableRed cachableRed, TransferFunction[] transferFunctionArray, RenderingHints renderingHints) {
        super(cachableRed, cachableRed.getBounds(), GraphicsUtil.coerceColorModel(cachableRed.getColorModel(), false), cachableRed.getSampleModel(), null);
        byte[][] byArrayArray = new byte[][]{transferFunctionArray[1].getLookupTable(), transferFunctionArray[2].getLookupTable(), transferFunctionArray[3].getLookupTable(), transferFunctionArray[0].getLookupTable()};
        this.operation = new LookupOp(new ByteLookupTable(0, byArrayArray), renderingHints){};
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        writableRaster = cachableRed.copyData(writableRaster);
        GraphicsUtil.coerceData(writableRaster, cachableRed.getColorModel(), false);
        WritableRaster writableRaster2 = writableRaster.createWritableTranslatedChild(0, 0);
        this.operation.filter(writableRaster2, writableRaster2);
        return writableRaster;
    }
}

