/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.Screen;
import java.util.List;

public abstract class MonitorDevice {
    protected final Screen screen;
    protected final int nativeId;
    protected final DimensionImmutable sizeMM;
    protected final MonitorMode originalMode;
    protected final ArrayHashSet<MonitorMode> supportedModes;
    protected final float[] pixelScale;
    protected final Rectangle viewportPU;
    protected final Rectangle viewportWU;
    protected boolean isClone;
    protected boolean isPrimary;
    protected MonitorMode currentMode;
    protected boolean modeChanged;

    protected MonitorDevice(Screen screen, int n, boolean bl, boolean bl2, DimensionImmutable dimensionImmutable, MonitorMode monitorMode, float[] fArray, Rectangle rectangle, Rectangle rectangle2, ArrayHashSet<MonitorMode> arrayHashSet) {
        float[] fArray2;
        this.screen = screen;
        this.nativeId = n;
        this.sizeMM = dimensionImmutable;
        this.originalMode = monitorMode;
        this.supportedModes = arrayHashSet;
        if (null != fArray) {
            fArray2 = fArray;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = 1.0f;
            fArray2 = fArray3;
            fArray3[1] = 1.0f;
        }
        this.pixelScale = fArray2;
        this.viewportPU = rectangle;
        this.viewportWU = rectangle2;
        this.isClone = bl;
        this.isPrimary = bl2;
        this.currentMode = monitorMode;
        this.modeChanged = false;
    }

    public final Screen getScreen() {
        return this.screen;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MonitorDevice) {
            MonitorDevice monitorDevice = (MonitorDevice)object;
            return monitorDevice.nativeId == this.nativeId;
        }
        return false;
    }

    public final int hashCode() {
        return this.nativeId;
    }

    public final int getId() {
        return this.nativeId;
    }

    public final boolean isClone() {
        return this.isClone;
    }

    public final boolean isPrimary() {
        return this.isPrimary;
    }

    public final DimensionImmutable getSizeMM() {
        return this.sizeMM;
    }

    public final float[] getPixelsPerMM(float[] fArray) {
        return this.getPixelsPerMM(this.getCurrentMode(), fArray);
    }

    public final float[] getPixelsPerMM(MonitorMode monitorMode, float[] fArray) {
        DimensionImmutable dimensionImmutable = this.getSizeMM();
        DimensionImmutable dimensionImmutable2 = monitorMode.getSurfaceSize().getResolution();
        fArray[0] = (float)dimensionImmutable2.getWidth() / (float)dimensionImmutable.getWidth();
        fArray[1] = (float)dimensionImmutable2.getHeight() / (float)dimensionImmutable.getHeight();
        return fArray;
    }

    public final MonitorMode getOriginalMode() {
        return this.originalMode;
    }

    public final List<MonitorMode> getSupportedModes() {
        return this.supportedModes.getData();
    }

    public final RectangleImmutable getViewport() {
        return this.viewportPU;
    }

    public final RectangleImmutable getViewportInWindowUnits() {
        return this.viewportWU;
    }

    public float[] getPixelScale(float[] fArray) {
        System.arraycopy(this.pixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    public final boolean contains(int n, int n2) {
        return n >= this.viewportPU.getX() && n < this.viewportPU.getX() + this.viewportPU.getWidth() && n2 >= this.viewportPU.getY() && n2 < this.viewportPU.getY() + this.viewportPU.getHeight();
    }

    public static void unionOfViewports(Rectangle rectangle, Rectangle rectangle2, List<MonitorDevice> list) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MIN_VALUE;
        for (int i = list.size() - 1; i >= 0; --i) {
            RectangleImmutable rectangleImmutable;
            if (null != rectangle) {
                rectangleImmutable = list.get(i).getViewport();
                n = Math.min(n, rectangleImmutable.getX());
                n3 = Math.max(n3, rectangleImmutable.getX() + rectangleImmutable.getWidth());
                n2 = Math.min(n2, rectangleImmutable.getY());
                n4 = Math.max(n4, rectangleImmutable.getY() + rectangleImmutable.getHeight());
            }
            if (null == rectangle2) continue;
            rectangleImmutable = list.get(i).getViewportInWindowUnits();
            n5 = Math.min(n5, rectangleImmutable.getX());
            n7 = Math.max(n7, rectangleImmutable.getX() + rectangleImmutable.getWidth());
            n6 = Math.min(n6, rectangleImmutable.getY());
            n8 = Math.max(n8, rectangleImmutable.getY() + rectangleImmutable.getHeight());
        }
        if (null != rectangle) {
            rectangle.set(n, n2, n3 - n, n4 - n2);
        }
        if (null != rectangle2) {
            rectangle2.set(n5, n6, n7 - n5, n8 - n6);
        }
    }

    public final boolean isOriginalMode() {
        return this.currentMode.hashCode() == this.originalMode.hashCode();
    }

    public final boolean isModeChangedByUs() {
        return this.modeChanged && !this.isOriginalMode();
    }

    public final MonitorMode getCurrentMode() {
        return this.currentMode;
    }

    public abstract MonitorMode queryCurrentMode() throws IllegalStateException;

    public abstract boolean setCurrentMode(MonitorMode var1) throws IllegalStateException;

    public String toString() {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Monitor[Id ").append(Display.toHexString(this.nativeId)).append(" [");
        if (this.isClone()) {
            stringBuilder.append("clone");
            bl = true;
        }
        if (this.isPrimary()) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("primary");
        }
        bl = false;
        stringBuilder.append("], ").append(this.sizeMM).append(" mm, pixelScale [").append(this.pixelScale[0]).append(", ").append(this.pixelScale[1]).append("], viewport ").append(this.viewportPU).append(" [pixels], ").append(this.viewportWU).append(" [window], orig ").append(this.originalMode).append(", curr ").append(this.currentMode).append(", modeChanged ").append(this.modeChanged).append(", modeCount ").append(this.supportedModes.size()).append("]");
        return stringBuilder.toString();
    }
}

