/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.security.AccessControlException;

public class JVM {
    private ReflectionProvider reflectionProvider;
    private static final float majorJavaVersion = JVM.getMajorJavaVersion(System.getProperty("java.version"));
    static final float DEFAULT_JAVA_VERSION = 1.3f;

    static final float getMajorJavaVersion(String javaVersion) {
        try {
            return Float.parseFloat(javaVersion.substring(0, 3));
        }
        catch (NumberFormatException e) {
            return 1.3f;
        }
    }

    public static boolean is14() {
        return majorJavaVersion >= 1.4f;
    }

    public static boolean is15() {
        return majorJavaVersion >= 1.5f;
    }

    private static boolean isSun() {
        return System.getProperty("java.vm.vendor").indexOf("Sun") != -1;
    }

    private static boolean isApple() {
        return System.getProperty("java.vm.vendor").indexOf("Apple") != -1;
    }

    private static boolean isHPUX() {
        return System.getProperty("java.vm.vendor").indexOf("Hewlett-Packard Company") != -1;
    }

    private static boolean isIBM() {
        return System.getProperty("java.vm.vendor").indexOf("IBM") != -1;
    }

    private static boolean isBlackdown() {
        return System.getProperty("java.vm.vendor").indexOf("Blackdown") != -1;
    }

    private static boolean isBEA() {
        return System.getProperty("java.vm.vendor").indexOf("BEA") != -1;
    }

    public Class loadClass(String name) {
        try {
            return Class.forName(name, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public synchronized ReflectionProvider bestReflectionProvider() {
        if (this.reflectionProvider == null) {
            try {
                if (this.canUseSun14ReflectionProvider()) {
                    String cls = "com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider";
                    this.reflectionProvider = (ReflectionProvider)this.loadClass(cls).newInstance();
                } else {
                    this.reflectionProvider = new PureJavaReflectionProvider();
                }
            }
            catch (InstantiationException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (IllegalAccessException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (AccessControlException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
        }
        return this.reflectionProvider;
    }

    private boolean canUseSun14ReflectionProvider() {
        return (JVM.isSun() || JVM.isApple() || JVM.isHPUX() || JVM.isIBM() || JVM.isBlackdown()) && JVM.is14() && this.loadClass("sun.misc.Unsafe") != null;
    }
}

