.\" $Header: /home/jcb/piva/ppmtomd/RCS/ppmtomd.man,v 1.47 2006/08/06 19:08:53 jcb Exp $
.\" Copyright (c) 2001-2003 J. C. Bradfield
.de TQ
.br
.ns
.TP \\$1
..
.de GO
.br
.TP
\fB\\$1\fP (\fB\\$2\fP) \\$3
..
.TH PPMTOMD 1 "ppmtomd" "J.C.Bradfield"
.SH NAME
ppmtomd \- convert PPM files to the Alps MicroDry printer format
.SH SYNOPSIS
.TP
\fBppmtomd\fP [ \fIoptions\fP ] [ \fIPPM-file\fP ]

.SH DESCRIPTION
A program to convert images from PPM format into the control language
for the Alps Micro-Dry printers, at various times sold by Citizen,
Alps and Okidata.
.PP
The input image is printed as one page. However, \fBppmtomd\fP will
correctly handle concatenated PPM files by printing each file on a
separate page, allowing it to be used as a filter for GhostScript with
PPM output.
.PP
If no input file is given, \fBppmtomd\fP reads from standard input.
It does not spool its input to disk; however, it does store several
intermediate files, and for a typical A4 photo image printed in
standard mode, at least 20MB should be available in the temporary
directory (/tmp, or the environment variable TMPDIR), or 80MB
in the dye-sub and vphoto modes.
.PP
The formatted output is sent to standard output. \fBppmtomd\fP does
not at present try to read any information from the printer, so the
output can be sent to a spooler or anywhere else as desired.

.SH OPTIONS
For both option names and values that are options, any unambiguous
(case-insensitive) prefix may be used. For example, the \fB\-transfermode\fP
option takes arguments including \fBBlack, Colour, Cassette\fP, but
it is enough to give \fBb,co,ca\fP.

.SS
.B \-autoshift
This option shifts the image appropriately to take account of the
unprintable areas on the paper, assuming that the input image occupies
the full area of the paper. Thus if a PPM image is generated by
giving the \fB-sPAPERSIZE=a4\fP option to GhostScript, ppmtomd should
be given the options \fB-papersize A4 -autoshift\fP.

.SS
.B \-black
This option sets black monochrome printing. It is equivalent to
\fB-monochrome -transfermode Black\fP.

.SS
.BI \-colourcorrection " mode"
This option specifies what colour correction is to be applied. The
possible values are:
.TP
.B None
No colour correction at all is done; in colour printing modes, the RGB
input data will be converted to CMY with no black.
.TP
.B Plain
The RGB input will be converted to CMYK with full black generation and
undercolour removal. This is the default when no dithering is done.
.TP
.B Photo
In this mode, monochrome data will be subject to gamma correction (see
\fB-gamma\fP), and colour data will be corrected by a lookup table
derived from the Alps Windows drivers. It can be adjusted by the
\fB-gamma\fP (see below) and \fB-keepblack\fP options.
This is the default when dithering is specified when using ordinary
inks.
.TP
.B DyeSub
This does colour correction suitable for printing photographs on
Dye Sublimation paper; the colour correction is done by a lookup table
which matches the Alps Windows drivers. In addition, the \fB-gamma\fP
option may be used to give a gamma factor which is first applied
directly to the CMY values of the image; use this to brighten photos.
(Gamma values greater than 1.0 or between 0 and -1.0 will brighten;
the default is -0.9, which happens to give good results with my
digital camera.)

.SS
.BI \-colours " colour-spec"
This option specifies which components of the image are printed,
and what colours are used to print them.
In monochrome modes, there is only one component, called \fBK\fP, and
in colour modes there are four, called \fBK\fP, \fBC\fP, \fBM\fP, \fBY\fP,
corresponding to the black, cyan, magenta and yellow components of the
output images. These components are generated according to the colour
mode and colour correction options; however, they need not all be
printed. The \fIcolour-spec\fP is a comma-separated list of components
to be printed. For example, \fB-colours c,y\fP will print only the
cyan and yellow planes of the image.
These components are always printed in the order C,M,Y,K, except when
using dye sublimation inks, in which case they are printed in the
order Y,M,C (there is no K).
.br
If no CMYK colours are to be printed, give \fB\-\fP or \fBnone\fP as
the \fIcolour-spec\fP.
.PP
\fBNOTE:\fP the following functionality is available but not
recommended (use the \fB-spotcolours\fP option instead).
Each component may be optionally followed by
\fB=\fP\fIcolour\fP, where \fIcolour\fP is a cassette supported by the
printer. This causes the given colour to be printed for the component.
For example, \fB-colours c=MetallicSilver,y=MetallicGold\fP will 
print an image in silver and gold, the silver parts being represented
by cyan in the input, and the gold parts by yellow. Colours may be
given with full names or with abbreviations. The currently supported
list of colours is given under the \fB\-spotcolours\fP option; however,
note that the foil colours require special processing that will not
happen if they are used here.

.SS
.BI \-datamode " mode"
This was the name of the \fB-tranfermode\fP option (q.v.) in versions 1.2 and
earlier. It remains supported for backwards compatibility.

.SS
.BI \-dither " dithering-mode"
This option specifies what dithering should be applied to the input.
The possible modes are:
.TP
.B None
The default for non-dyesub: no dithering is done, and the output pixels are
calculated in CMYK and then rounded to on or off. Use this mode if the
dithering is to be done by another program such as ghostscript.
.TP
.B FloydSteinberg
(also \fBfs\fP for short) uses a standard Floyd-Steinberg error
diffusion algorithm. In principle, this is not a good technique for
normal MicroDry printing technology; however, it can give good results in
some circumstances.
This is the default for dye sublimation printing.
.TP
.B Halftone
(also \fBht\fP for short) uses a clustered dot ordered dither with
customized halftone screen angles, and a line screen. This is the
dithering recommended for general use. N.B. The default is no
dithering, except in dye sublimation mode.
.TP
.B CoarseHalftone
(also \fBcht\fP for short) is the same, but uses a coarser, dot rather
than line, screen, giving an impression more like normal print.
.TP
.B Square
This is a somewhat experimental technique that is only suitable for
use in the RasterColour data mode. Not recommended; see the technical
section for further information.

.SS
.B \-draft
This option sets printing with the re-usable EconoBlack ribbon
(MD-5000 and later models only). It is equivalent to \fB-monochrome
-transfermode EconoBlack\fP.

.SS
.B \-econoblack
A synonym for \fB\-draft\fP.

.SS
.B \-firstpass
This is a specialist option. It tells the driver that it is only
handling the first of several passes, and that on exit the printer
should be left in data transfer mode and the paper backfed to top of
form. 

.SS
.B \-forcecurlcorrection
This option forces a paper curl correction pass even in overlay mode.

.SS
.B \-glossy
This option tells the printer to put the glossy finish overcoat on
the image. This uses the printer's built-in facility for this: the
glossy finish will be applied to the smallest rectangle bounding
the printed area. Finer control can be achieved by using Finish
as a spot colour. This option is set by default in dye sublimation
printing; it can be cancelled with the \fB-noglossy\fP option.

.SS
.B \-halftone
This is a compatibility option, equivalent to \fB-dither Halftone\fP.

.SS
.BI \-informat " input_type"
This option specifies how to treat the input. The possible values are
.TP
.B Colour
The default mode: the input is a standard colour image, and (unless
prevented by other options) undergoes colour correction and possibly
dithering to generate four colour output.
.TP
.B Monochrome
The input is converted to a grey file, gamma correction is applied and
possibly dithering, and then all selected output colours are printed
at the resulting level. Note that this mode should usually only be
used if just one output colour is being printed: if you use this
option on its own, the result will be an image printed four times
over, in each colour! This mode is automatically set by appropriate
user-level options such as \fB\-black\fP.
.TP
.B Diag
The input is in a special diagnostic format which codes the value of a
four colour pixel into an RGB pixel. This format is described in the
technical section (***).

.SS
.BI \-gamma " g"
This option sets the initial gamma correction that is applied to input
data. At present, in monochrome modes this is applied directly to the
darkness k as k -> k**g; in colour modes, it is applied to the CMY
components by c -> c**g. The default value depends on the type of printing.

.SS
.BI \-inresolution " res"
This integer valued option sets the resolution of the input file if it
is different from the printing resolution. Currently this is only
supported for 600 dpi input and 1200 dpi output.

.SS
.B \-keepblack
If this option is given, pure black in the input will be printed as
pure black in the output, overriding the normal colour corrected
value. This option is appropriate for mixes of black text and
images. However, for images without text, it is probably better not to
give this option; without it, the solid blacks will blend better with
the surrounding colours.

.SS
.B \-lastpass
This is a specialist option. It is like \fB\-midpass\fP, except that
no further pass follows, so that curl correction should be performed,
the paper ejected, and the printer reset as normal.

.SS
.BI \-lfadjust " adjustment"
This option specifies the line feed adjustment, changing the amount by
which the printhead advances between passes. If thin white stripes
appear between bands, a negative lfadj can be used to remove
them. May be useful with very heavy paper or very light paper;
the neutral setting seems correct for normal paper on my printer,
but reports vary.
\fIadjustment\fP is in units of 1/9th of a (600dpi) pixel, and has
possible values from -128 to +127.

.SS
.BI \-media " mediatype"
This option specifies the printing media type. It affects several
other options. For completeness, we list here all possible media
types, though some have never been available on the printers so far
sold.
.TP
.B PlainPaper
The default medium, meaning standard photocopy paper.
.TP
.B FinePlainPaper
This is not actually a different medium; rather it is plain paper, but
everything is printed twice, giving a richer colour. The term "Fine"
is historical Alps; it's misleading, since this is intended for paper
that is rougher than usual and so needs double printing.
.TP
.B LaserPaper
This appears to be the same as PlainPaper, but smoother, which may
affect some firmware fine-tuning of the printing.
.TP
.B DyeSubPaper
Dye sublimation paper. Setting this medium implies the use of the dye
sublimation ink cartridges. Currently, no other inks may be used (so
no spot colours), although there seems no reason in principle why the
other inks should not be usable as overcolours.
.TP
.B DyeSubLabel
This variant on dye sublimation paper is probably a product (sold only
in Japan) for id-cards and the like.
.TP
.B VPhotoFilm
This is a plastic film for variable-dots printing. If this medium is
selected, ppmtomd will do variable-dots printing. (VPhoto printing on
plain paper or with VPhoto primer is not yet supported.)
.TP
.B VPhotoCard
Postcard sized VPhoto film, I think. This also implies variable-dots
printing.
.TP 
.B OHP
Overhead transparencies (normal ones, not the special ink ones).
.TP
.B FineOHP
Overhead transparencies with double printing.
.TP
.B Cardboard
It is not entirely clear what this is for; it is probably for business
cards (card printing sheets are sold in Japan for the MD series).
.TP
.B PostCard
This is a heavy paper or light card sold in Japan for printing
postcards.
.TP
.B IronSheet
This is sheets for iron-on transfers.
.TP
.B SpecialIron
This is for iron-on sheets using the special OHP inks; not usable.
.TP
.B BackPrint
Backprint film is used for mugs and the like; it is not easily
available outside Japan, and is to be withdrawn in September 2004.
With this medium, the image is automatically mirrored left-to-right.
.TP
.B FineBackPrint
Backprint film with double printing.
.TP
.B GlossyPaper
also sold as photo-realistic paper is a very smooth paper intended for
1200dpi printing with the earlier (pre-MD5000) printers.
.TP
.B GlossyLabel
This variant on photo-realistic paper is probably a product (sold only
in Japan) for id-cards and the like.
.TP
.B SpecialOHP
This medium is not usable with modern MD printers. Alps originally
marketed (in Japan only) a set of inks specially designed for
transparencies. This medium indicates transparencies to be printed
with the special inks. The transparencies and inks work only with the
MD-2000 (and presumably also the Printiva 600). The inks were
withdrawn in 2000.
.TP
.B FineSpecialOHP
is to SpecialOHP as FinePlainPaper is to PlainPaper; it is not usable.
.TP
.B LabecaSheet
This medium was sold in Japan only, and is now withdrawn. It appears to
be labels for videotapes etc.
.TP
.B ThermalPaper
This is thermal paper that will be directly activated by the print
head - i.e. no ribbon is used. It is not known whether this is safe to
do on the retail MD series; certainly no such paper is sold by Alps.
.TP
.B CDMaster
Another medium not available on the current printers. It appears to
be for printing stick-on labels for CDs - or possibly even directly on
to CDs.

.SS
.B \-midpass
This is a specialist option. It tells the driver that the printer has
already been set up with appropriate values, and left in data transfer
mode, so the driver should simply print the specified components.
Unless the \fB\-lastpass\fP option is also given, the printer will be
left in data transfer mode.

.SS
.BI \-model " modelname"
This option tells the driver which model of printer it is driving.
Possible values are:  Printiva-600 (the Citizen Printiva 600C),
Printiva-600U (the same, upgraded to recognize metallic silver),
Printiva-700, Printiva-1700 (later Citizen models),
MD-2000, MD-2010, MD-4000, MD-2300, MD-1000, MD-1300, MD-1500,
MD-5000,  MD-5500 (Alps models),
DP-5000 (Oki models).
The default is DP-5000 (can be changed at compile time) for \fBppmtomd\fP, 
or Printiva-600U if called as \fBppmtocpva\fP (for compatibility). The main
difference is between models before the MD-5000, and the 5000 onwards 
models; however, the driver tries to ensure that unsupported commands
are not issued to the printer.

.SS
.B \-monochrome
This is a compatability option, and is equivalent to
\fB\-informat Monochrome\fP.

.SS
.B \-nocurlcorrection
This option suppresses the curl correction that the printer normally
performs on the last print pass. Note that the printer only performs
curl correction on paper media, and that curl correction is
automatically disabled in overlay mode.

.SS
.B \-nopack
This is a debugging option only; it disables the use of compression in
the output.

.SS
.B \-noreset
This is a specialist option. Normally, the driver will issue a printer
reset at the end of processing; this option prevents it.

.SS
.BI \-outformat " output_format"
This option specifies what form of output the program generates.
The values are:
.TP
.B RGL
The default: output for driving the printer.
.TP
.B packetRGL
Output encapsulated in the packetized format used for bidirectional
drivers. Warning: this output must not be sent directly to the
printer; it must be handled by a suitable spooler.
.TP
.B PPM
The output is a PPM file with each pixel being cyan, magenta, yellow,
black or white as it would appear on the printer.
.TP
.B Diag
The output is a PPM file in a diagnostic format which codes a CMYK
pixel into an RGB pixel.
.TP
.B ColourDiag
The output is the PPM file resulting from applying the colour
correction routines to the input, but without any other processing.

.SS
.B \-overlay
If this option is given, at the end of printing the paper will
be returned to top of form so that further data can be overlaid
on the same page.
(Technical note: the printer will be left in the idle mode.)

.SS
.B "-pageC -pageM -pageY -pageK"
These options are deprecated compatibility options. They specify which
components should be printed; use the \fB-colours\fP option instead.

.SS
.BI \-pagelength " length"
This option sets the length of the page, from top printing position to
bottom printing position. \fIlength\fP may be given in the usual units
of measurement; if no unit is given, a unit of 1/600 inch is assumed
(regardless of the resolution setting). This option is usually set
automatically from the paper size.

.SS
.BI \-pagewidth " width"
This option sets the printing width of the page. \fIwidth\fP may be
given in the usual units of measurement; if no unit is given, a unit
of 1/600 inch is assumed (regardless of the resolution setting). This
option is usually set automatically from the paper size.

.SS
.BI \-papersize " size"
This option sets the size of the paper being used. Possible values
are Custom (the length and width should be given by options),
Executive, Letter, Legal, A4, B5, PostCard, DyeSubLabel. For the
exact dimensions of these sizes, see the note *** in the technical
section. NOTE: the default size is explicitly set to A4 by the driver,
although the printers' built-in default varies with country.

.SS
.BI \-phadjust " adjustment"
This option varies the intensity of the print head drive signal,
making the image lighter or darker than normal. \fIadjustment\fP may
take values between -50 and +50; negative values make the image
darker. It is not known whether this option may increase wear on the heads.

.SS
.B \-ppmout
This is a compatibility option, equivalent to \fB\-outformat PPM\fP.

.SS
.B \-primer
This option lays a coat of VPhoto Primer over the whole area of the
image before printing. It should be used together with \fB-printmode
VPhoto\fP. (To be precise, this option is equivalent to setting the
first unused undercolour component to Primer=always.)

.SS
.BI \-printmode " mode"
This option is used to print with VPhoto (variable dot, misleadingly
called 2400dpi) printing on plain paper - or standard printing on
VPhoto paper, should it be desired. It is available only with the 5000
series printers. The possible values of \fImode\fP are as follows:
Default - the mode is determined by the media, being DyeSub printing
on DyeSub media, VPhoto printing on VPhoto media, and standard
printing on all other media; Standard - 1 bit per pixel standard
printing; VPhoto - 4 bits per pixel variable dot printing; DyeSub - 4
bits per pixel printing with dye sublimation inks. (The last option has
no known use, since dye sub printing only works on dye sub media.)
Note that this option applies only to the CMYK components;
undercolours and spot colours are always printed in Standard mode,
whatever the media.

.SS
.BI \-resolution " res"
This option sets the printing resolution. \fIres\fP is an integer,
with values 600 (default) for 600x600 dpi, 300 for 300x300 dpi,
or 1200 for 1200x600 dpi.

.SS
.BI \-satgamma " sg"
This option is not used in version 1.2.

.SS
.B \-solidblack
This is a compatibility option, equivalent to \fB-keepblack\fP.

.SS
.BI \-spotcolours " colourspecs"
This option gives the spot colours to be printed after the CMYK
colours. Up to four spot colours may be given. \fIcolourspecs\fP is a
comma-separated list of colour specification, each of the form
\fIn\fP\fB=\fP\fIcol\fP\fB=\fP\fIinspec\fP.
.PP
\fIn\fP is an integer between 1 and 4; the spot colours are printed in
order.
.PP
\fIcol\fP is the ribbon colour for this component: possible values
(abbreviations) are Black (k), Cyan (c), Magenta (m), Yellow (y),
MetallicGold (mg), MetallicMagenta (mm), MetallicCyan (mc),
MetallicSilver (ms), White (w), GoldFoil (gf), SilverFoil (sf), Primer
(p), Finish (f), Overcoat (oc). Note that the Foil ribbons also
require the CMYK ribbons to be installed, and that the Finish and
Overcoat ribbons will normally be used via other options. (The Primer
ribbon is of course normally used as an undercolour rather than a spot
colour). 
.PP
For use in complex overlays, four pseudo-colours are also possible
values. NullSpot (ns) and NullFoil (nf) cause nothing to be printed,
but otherwise behave like non-foil and foil spots: NullSpot blanks out
anything underneath, and NullFoil causes a CMYK undercoat to be
printed. The colours RawGoldFoil (rgf) and RawSilverFoil (rsf) print
the foil cartridges without an undercoat, assuming this has already
been done in a previous overlay.
.PP
\fIinspec\fP specifies how the spot colour is given in the input file.
The following values are possible: 
.br
\fBc\fP (respectively \fBm,y,k\P means that the spot colour is given
by the C (respectively M,Y,K) value
of the input. NOTE: for this calculation, the RGB input is converted
to CMYK with full black generation and undercolour removal, regardless
of any options affecting colour correction for the normal inks.
.br
\fIR-range\fP\fB:\fP\fIG-range\fP\fB:\fP\fIB-range\fP specifies a
range of RGB colours in the input that give the spot colour. Each
range is of the form \fIm\fP[\fB-\fP\fIn\fP] where \fIm\fP and \fIn\fP
are integers from 0 to 255 expressed in decimal. Hexadecimal values
may be given by prefixing them with \fB0x\fP, but octal values are not
recognized. The spot colour is printed if each of the RGB components
lies within the specified ranges.
.br
\fBnotwhite\fP or \fBn\fP means that the spot colour is printed if the
input pixel is not white (useful with the glossy finish ribbon).
.br
\fBalways\fP or \fBa\fP means that the spot colour is printed over the
entire image. (Useful for glossy finish or undercoats.)
.br
See also the \fB\-spotfile\fP for specifying the spot colours.

.PP
Note that no colour correction or halftoning is applied to spot
colours; they are either on or off. Note also that spot colours
are printed in addition to CMYK colours; if no CMYK colours are
needed, use the \fB\-colours none\fP option.
.PP
For pixels where a solid spot colour such as the Metallics is printed,
the CMYK colours are not printed. For the Foil colours, an undercoat
of CMYK is printed.
.PP
\fBNOTE:\fP The driver will not handle more than seven colours
(including Glossy Finish if requested) in total. If you are using a
5000 series printer, load the required seven cartridges into the
printer. If you are using a pre-5000 series printer, then if
(a) you are using four or fewer colours, then load those cartridges, or
(b) if you are using more than four colours, load the CMYK cartridges;
then when the printer flashes its error light, open the printer,
remove the cartridges in the holders and replace them with the
remaining spot cartridges (I advise leaving the empty holder free).
If you need to handle more than seven colours, you must use the
\fB\-overlay\fP option to print in several passes.

.SS
.BI \-spotfile " file"
This option specifies a file containing the input data for the spot
colours and under colours, instead of the main input file. This file
must have the same dimensions and format as the main input file.

.SS
.BI -transfermode " mode"
This option specifies how the different colours are sent to the
printer. Generally this option need not be given, as the driver will
choose appropriate modes depending on other options; indeed, it should
not be given by the user unless they have a full understanding of the
internals of both the printer and the driver. For a full description
of modes, see the note (***) in the technical section of this man
page. In versions 1.2 and earlier, this option was called
\fB-datamode\fP.
The possible values for the option are:
.TP
.B Colour
The default mode, in which the four colours are sent a page at a time,
in the order cyan, magenta, yellow, black.
.TP
.B Black
The mode for monochrome data, printing in black only.
.TP
.B EconoBlack
Like Black, but uses the re-usable economy black ribbon. Available
only with the 5000 and later printers.
.TP
.B Cassette
This mode is like Colour, but the colours black, cyan, magenta, yellow
are instead printed with whatever cassettes are in holders 1, 2, 3, 4
respectively. In this mode, the printing order is 1, 2, 3, 4. ***
Available only on the pre-5000 models. See the technical section for
caveats. (***)
.TP
.B RasterColour
In this mode, each line of the image is sent in all four colours, then
the next line, and so on. The printer prints one band in the four
colours, then the next band, and so on. This mode is required for the
multi-colour YMC ribbon available for the pre-5000 models; its use in any
other case is not advised (see technical section ***). Available on
the pre-5000 models only.
.TP
.B RasterCassette
This is the Cassette analogue of the RasterColour mode: data is
transmitted a line at a time, and the colours black, cyan, magenta,
yellow are interpreted as the cassettes in holders 1, 2, 3, 4. Use of
this mode is not advised in any case. Available on pre-5000 models
only.
.TP
.B NColour
This mode is an extension of Colour mode allowing more than four
components. Available on the 5000 models only. (Previous versions used
the confusing term MultiColour, which is accepted for backwards
compatibility.)

.SS
.BI \-undercolours " colourspecs"
This option is the same as \fB\-spotcolours\fP, except that the
colours are printed before the CMYK colours, and have no effect on
what other colours are printed. The main use is with white ink to
undercoat on dark paper. (Note that if an RGB \fIinspec\fP is used
to specify an undercolour, the given colour is also printed as normal
on top of the undercoat. This is probably not the intended effect! If
you wish to do special effects with undercolours, you should use an
overlay or spotfile.) See also the \fB\-spotfile\fP option.

.SS
.B \-usemulticolourribbon
This option is available on the pre-5000 series printers, and
instructs the driver that the CMY multi-colour ribbon is to be
used. This will result in the CMYK colours being printed in two
passes instead of four: the first pass will be CMY, the second K.

.SS
.B \-version
This option prints the version number and exits.

.SS
.BI \-xshift " xoffset"
This option shifts the image in the x-direction. \fIxoffset\fP may be
given in the usual units of measurement; if no unit is given, a unit
of 1/600 inch is assumed (regardless of the resolution setting).
See also \fB-autoshift\fP. A positive offset shifts the image right.

.SS
.BI \-yshift " yoffset"
This option shifts the image in the y-direction. \fIxoffset\fP may be
given in the usual units of measurement; if no unit is given, a unit
of 1/600 inch is assumed (regardless of the resolution setting).
See also \fB-autoshift\fP. A positive offset shifts the image down.

.SH USAGE NOTES

To print a image from a PPM file with halftoning for photos, it
suffices to do 
.br
\fBppmtomd -dither ht\fP \fIfile\fP \fB>/dev/printer\fP
.br
assuming that the printer is on /dev/printer.
.PP
Suppose that text.ps is a PostScript file (possibly containing several
pages). To print it in black only on A4 paper, the following
combination of GhostScript and \fBpptomd\fP can be used:
.na
  \fBgs -q -dNOPAUSE -dBATCH -sDEVICE=pgmraw -r600
.br
    -sOutputFile='|ppmtomd -autoshift
.br
                           -black >/dev/printer'
.br
    page.ps\fP
.ad
.PP
To print at the highest resolution, do:
.na
  \fBgs -q -dNOPAUSE -dBATCH -sDEVICE=pgmraw -r1200x600
.br
    -sOutputFile='|ppmtomd -autoshift -resolution 1200
.br
                           -inresolution 1200
.br
                           -black >/dev/printer'
.br
    page.ps\fP
.br
.ad
Note that using the pbmraw format for GhostScript is not recommended.
Many versions of GhostScript have bugs in this format, and there is
no efficiency saving, since \fBppmtomd\fP will convert its input to
PPM.
.PP
To print a photograph in an image file photo.ppm, load the dye
sublimation inks and paper and do
.na
  \fBppmtomd -media DyeSubPaper photo.ppm >/dev/printer\fP
.ad
.PP
To print a photo in the variable dots mode on VPhoto film, with glossy
finish, do
.na
  \fBppmtomd -media VPhotoFilm -glossy -dither ht photo.ppm >/dev/printer\fP
.ad
.PP
To print the same on plain paper:
.na
  \fBppmtomd -printmode VPhoto -glossy -dither ht photo.ppm >/dev/printer\fP
.ad

.SH ACKNOWLEDGMENTS

The writing of this driver is greatly assisted by the manufacturers.
Citizen originally supplied me with the command language spec for the
Printiva printers; Alps supplied me with the spec for their models;
and Oki Systems (UK) supplied me with a DP-5000 printer for testing.

.SH TECHNICAL NOTES

This section is not yet written.
