#line 2 "pgc.c"
/*-------------------------------------------------------------------------
 *
 * pgc.l
 *	  lexical scanner for ecpg
 *
 * This is a modified version of src/backend/parser/scan.l
 *
 * The ecpg scanner is not backup-free, so the fail rules are
 * only here to simplify syncing this file with scan.l.
 *
 *
 * Portions Copyright (c) 1996-2020, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/interfaces/ecpg/preproc/pgc.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres_fe.h"

#include <ctype.h>
#include <limits.h>

#include "common/string.h"

#include "preproc_extern.h"
#include "preproc.h"

#line 32 "pgc.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer base_yy_create_buffer
#define yy_delete_buffer base_yy_delete_buffer
#define yy_scan_buffer base_yy_scan_buffer
#define yy_scan_string base_yy_scan_string
#define yy_scan_bytes base_yy_scan_bytes
#define yy_init_buffer base_yy_init_buffer
#define yy_flush_buffer base_yy_flush_buffer
#define yy_load_buffer_state base_yy_load_buffer_state
#define yy_switch_to_buffer base_yy_switch_to_buffer
#define yypush_buffer_state base_yypush_buffer_state
#define yypop_buffer_state base_yypop_buffer_state
#define yyensure_buffer_stack base_yyensure_buffer_stack
#define yy_flex_debug base_yy_flex_debug
#define yyin base_yyin
#define yyleng base_yyleng
#define yylex base_yylex
#define yylineno base_yylineno
#define yyout base_yyout
#define yyrestart base_yyrestart
#define yytext base_yytext
#define yywrap base_yywrap
#define yyalloc base_yyalloc
#define yyrealloc base_yyrealloc
#define yyfree base_yyfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define base_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer base_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define base_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer base_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define base_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer base_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define base_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string base_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define base_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes base_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define base_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer base_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define base_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer base_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define base_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state base_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define base_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer base_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define base_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state base_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define base_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state base_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define base_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack base_yyensure_buffer_stack
#endif

#ifdef yylex
#define base_yylex_ALREADY_DEFINED
#else
#define yylex base_yylex
#endif

#ifdef yyrestart
#define base_yyrestart_ALREADY_DEFINED
#else
#define yyrestart base_yyrestart
#endif

#ifdef yylex_init
#define base_yylex_init_ALREADY_DEFINED
#else
#define yylex_init base_yylex_init
#endif

#ifdef yylex_init_extra
#define base_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra base_yylex_init_extra
#endif

#ifdef yylex_destroy
#define base_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy base_yylex_destroy
#endif

#ifdef yyget_debug
#define base_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug base_yyget_debug
#endif

#ifdef yyset_debug
#define base_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug base_yyset_debug
#endif

#ifdef yyget_extra
#define base_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra base_yyget_extra
#endif

#ifdef yyset_extra
#define base_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra base_yyset_extra
#endif

#ifdef yyget_in
#define base_yyget_in_ALREADY_DEFINED
#else
#define yyget_in base_yyget_in
#endif

#ifdef yyset_in
#define base_yyset_in_ALREADY_DEFINED
#else
#define yyset_in base_yyset_in
#endif

#ifdef yyget_out
#define base_yyget_out_ALREADY_DEFINED
#else
#define yyget_out base_yyget_out
#endif

#ifdef yyset_out
#define base_yyset_out_ALREADY_DEFINED
#else
#define yyset_out base_yyset_out
#endif

#ifdef yyget_leng
#define base_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng base_yyget_leng
#endif

#ifdef yyget_text
#define base_yyget_text_ALREADY_DEFINED
#else
#define yyget_text base_yyget_text
#endif

#ifdef yyget_lineno
#define base_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno base_yyget_lineno
#endif

#ifdef yyset_lineno
#define base_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno base_yyset_lineno
#endif

#ifdef yywrap
#define base_yywrap_ALREADY_DEFINED
#else
#define yywrap base_yywrap
#endif

#ifdef yyalloc
#define base_yyalloc_ALREADY_DEFINED
#else
#define yyalloc base_yyalloc
#endif

#ifdef yyrealloc
#define base_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc base_yyrealloc
#endif

#ifdef yyfree
#define base_yyfree_ALREADY_DEFINED
#else
#define yyfree base_yyfree
#endif

#ifdef yytext
#define base_yytext_ALREADY_DEFINED
#else
#define yytext base_yytext
#endif

#ifdef yyleng
#define base_yyleng_ALREADY_DEFINED
#else
#define yyleng base_yyleng
#endif

#ifdef yyin
#define base_yyin_ALREADY_DEFINED
#else
#define yyin base_yyin
#endif

#ifdef yyout
#define base_yyout_ALREADY_DEFINED
#else
#define yyout base_yyout
#endif

#ifdef yy_flex_debug
#define base_yy_flex_debug_ALREADY_DEFINED
#else
#define yy_flex_debug base_yy_flex_debug
#endif

#ifdef yylineno
#define base_yylineno_ALREADY_DEFINED
#else
#define yylineno base_yylineno
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define base_yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 139
#define YY_END_OF_BUFFER 140
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[566] =
    {   0,
        0,    0,   10,   10,    0,    0,    0,    0,    0,    0,
        9,    9,    0,    0,    0,    0,   19,   19,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  140,  138,   10,   17,    5,    5,
        6,    6,   42,   38,   44,   39,   44,    9,   23,   17,
       20,   19,   19,   19,   19,   24,   24,   17,   29,   23,
       33,   33,   35,   40,  129,  129,  127,   86,   86,  127,
      127,  108,   86,   86,  108,   43,  108,   68,   80,  108,
       12,   84,   85,   79,   82,   78,   83,  108,   81,   58,

       58,   76,   77,  108,   91,  108,   74,   74,   89,   90,
       87,  108,   88,   66,    1,    1,   55,   36,   55,   53,
       54,   55,   14,   54,   54,   54,   54,   58,   54,   54,
       54,   54,   65,   65,   65,   65,   65,   65,  137,  137,
      137,  137,  133,  133,  132,  131,  130,  114,  114,   10,
        5,    7,    4,    3,   42,   41,   44,    9,   23,   21,
       19,   19,   19,   19,   18,   19,   19,   24,   26,   27,
       26,   26,   26,   22,   33,   32,   34,    0,    0,  128,
        0,    0,    0,    0,    0,  100,    0,    0,    0,    0,
        0,    0,  105,   96,    0,   75,  103,   97,  101,   98,

      102,   92,  107,   59,    2,    0,  104,   59,   58,   62,
       70,   94,   99,   93,   74,   74,   95,    1,    0,   55,
       52,   55,    0,    0,   30,   56,   31,    1,   46,    2,
       59,   58,   45,   47,   64,   49,   51,   48,   50,   65,
        8,   15,   13,    0,   11,    0,  136,    0,    0,    0,
      132,  130,    0,    0,  113,    3,   19,   19,   19,   19,
       27,    0,    0,   28,   34,    0,    0,    0,    0,    0,
       73,   73,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  106,    2,    0,   69,   60,   59,
       63,   61,   70,   74,   55,   55,   31,    1,    1,    2,

       59,   58,   64,    0,    0,    0,   37,   16,  135,  134,
       19,   19,   18,   19,   19,   27,    0,    0,   28,    0,
        0,    0,    0,    0,    0,    0,    0,   73,   73,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       74,   55,    0,   59,   64,    0,    0,    0,   64,  135,
      135,  134,  134,   19,    0,    0,  122,    0,    0,    0,
        0,    0,    0,    0,   73,   73,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       74,   55,   55,    0,   59,   64,    0,    0,    0,    0,
        0,   25,  122,    0,  124,    0,  118,    0,    0,    0,

        0,    0,    0,   73,   73,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  112,    0,   74,   55,    0,
        0,    0,    0,    0,    0,   64,   64,    0,    0,  126,
      118,  120,    0,    0,    0,    0,  110,    0,  112,    0,
       67,   57,    0,    0,    0,    0,    0,   64,    0,  120,
        0,    0,    0,   71,   71,  110,  116,   67,   67,   74,
       74,   74,   74,   57,   64,    0,    0,    0,    0,   71,
       71,   71,    0,   71,    0,  116,    0,    0,    0,   74,
       74,   74,   74,   74,   74,   57,   64,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   74,   74,   74,

       74,   74,   74,   74,   74,  121,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   74,   74,   74,   74,   74,
       74,   74,   74,  121,    0,  123,    0,  117,    0,    0,
        0,    0,    0,    0,   74,   74,   74,   74,   74,   74,
        0,  125,  117,  119,   72,   72,    0,    0,  111,   74,
       74,   74,  111,  119,   72,   72,   72,   72,  109,    0,
      109,   74,  115,  115,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   21,
       21,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,   28,   28,   29,   30,   31,   32,   33,   34,
       35,   35,   36,   35,   35,   37,   38,   39,   40,   41,
       42,   43,   44,   45,   46,   35,   35,   47,   35,   35,
       48,   49,   50,   51,   52,   28,   29,   30,   31,   32,

       33,   34,   35,   35,   53,   35,   35,   37,   38,   39,
       40,   41,   42,   43,   44,   45,   54,   35,   35,   55,
       35,   35,   56,   57,   58,   28,    1,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,

       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59
    } ;

static const YY_CHAR yy_meta[60] =
    {   0,
        1,    2,    3,    3,    4,    5,    4,    6,    7,    4,
        8,    9,    9,   10,    7,    1,   11,   12,   13,   14,
       14,   14,   15,   16,   17,   18,   19,    4,   20,   20,
       20,   20,   20,   20,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,    9,
        4,   21,   21,   21,   21,    1,    4,    1,   21
    } ;

static const flex_int16_t yy_base[631] =
    {   0,
        0,    0, 2149, 2148,    0,   53, 2152, 2151,    0,    5,
     2145, 2144, 2140, 2138, 2137, 2133,   18,   27,    1,   34,
        7,   12,    0,   30, 2137, 2136, 2130, 2129,  110,    0,
       38,  168,  201,    0,  260,    0,   28,   60,   71,  171,
      319,    0,  378,    0, 2138, 2578,    0, 2578,    0,    0,
       29, 2123,    0, 2130, 2578, 2578,   10,    0,    0, 2124,
     2578,   86,   89,  175, 2117,    0,    0, 2122,  418, 2121,
        0,    0, 2119, 2120, 2578,  438, 2578, 2578, 2578,  147,
       22, 2578,   94,  186, 2099, 2578,   11,  412, 2097, 2110,
     2578, 2578, 2578,  168,   50, 2578,   82,  177,  433,  435,

      456, 2578, 2578, 2094, 2091, 2089,    0,   39, 2578, 2578,
     2578, 2055, 2578, 2578,  447,  477, 2085, 2578,  486,  477,
        0,    0, 2578, 2578, 2093,  449, 2095,  486,   13,  158,
     2081, 2080,    0, 2094, 2093, 2092, 2092, 2090, 2076,    0,
     2578,    0, 2578,  514, 2578, 2578,    0, 2578,  521,    0,
        0,   88, 2578,    0,    0, 2578, 2578,    0,    0, 2578,
      524,  529, 2057,  545, 2578, 2056,  548,    0, 2578,  440,
        0,    0,    0, 2578,    0, 2578, 2064,  551,  555, 2578,
      449, 2036, 2035,  564,  410, 2578,  579,  496,  535, 2034,
      453, 2027, 2578, 2578,  496, 2578, 2578, 2578, 2578, 2578,

     2578, 2051, 2578,  619,    0, 2061, 2578,  624,  629,  638,
        0, 2578, 2578, 2578,    0, 2030, 2578,  661,  508,    0,
        0,  664,  526,  538, 2578,  655, 2054,  717, 2578,    0,
      664,  678, 2578, 2578,  670,    0,    0,    0,    0,    0,
     2578, 2578, 2578,  637, 2578, 2036, 2578, 2053, 2013,  699,
     2578,    0,  704,  735, 2578,    0,  744,  747,  750,  754,
      500,    0,    0,    0, 1991,  676, 1945,  470, 1924,  746,
     2578,    0, 1916,    0,  691,  497, 1875, 1882,  531, 1848,
     1503, 1499, 1501, 1499, 2578,    0, 1527, 2578, 2578,  774,
      782,  788,    0, 1498,  806, 1513, 1518,    0,  859,    0,

      806,  820,  687, 1498,    0,  833, 2578, 2578,  841,  856,
      844,  886,  889,  909,  892, 2578,    0,    0, 2578, 1490,
     1490,  677, 1489, 1489,  915,  911,  815,  868,  919, 1487,
     1487, 1477, 1479, 1480, 1480, 1471, 1473,  680, 1472, 1475,
      925,  967,  911,  916,  692,  937,  940,  948,  997,  943,
     2578,  959, 2578, 1000,    0,    0,  976, 1003, 1473, 1472,
     1472, 1006, 1462, 1009, 1489, 1016,  642, 1029, 1468, 1449,
     1437,  429, 1445, 1426, 1401,  626, 1402,  671, 1392, 1035,
     1352,    0,  700, 1031, 1039,  834, 1079, 1060, 1136, 1038,
        0, 2578, 1064, 1067, 2578, 1090, 1071, 1359, 1347, 1366,

      746, 1365, 1097, 1190, 1194,    0, 1325, 1313, 1324,    0,
     1312, 1286, 1294, 1278, 1276, 1115, 1256, 1254, 1276, 1100,
     1105, 1243,    0,    0, 1265,  887, 1300,    0, 1197, 2578,
     1129, 1139, 1222, 1232,    0, 1230, 1157, 1219, 1203, 1186,
     1349, 1190, 1204, 1203,  745, 1375,    0, 1433,    0, 1212,
     1228,  775, 1169, 1225, 1231, 1215, 1234, 1482,    0, 1169,
      817,  828, 1148, 1220, 1536,    0,  920, 1153,  731, 1270,
     1276, 1282, 1125, 1285, 1123, 1293, 1119,  868, 1108, 1100,
      922, 1092,  734, 1077, 1074, 2578,    0, 1063, 1043,  769,
     1023, 1022, 1011, 1003,  991,  991,  989,  845,  957,  922,

      932,  920,  916,  887,  875, 1303, 1318,  867,  865,  846,
      751,  941,  993,  840,  842,  810, 1321, 1330,  796,  795,
      764,  943,  735, 1326, 1333, 2578, 1336, 1341,  707,  625,
      622,  627,  980,  620,  509, 1359, 1362,  460,  411, 1365,
     1368, 2578, 1371, 1374, 1384, 1387,  163,  149, 1394, 1397,
     1421,   72, 1429, 1436, 1451, 1454, 1459, 1462, 1465,   49,
     1468, 1471, 1474, 1485, 2578, 1595, 1617, 1639, 1661, 1683,
     1705, 1727, 1749, 1771, 1793, 1815, 1837, 1859, 1881, 1903,
     1925, 1947, 1969, 1991, 2012, 2034, 1092, 2055, 2076, 2093,
     2111, 2125, 2132, 2148, 2169, 2191, 2213, 2230, 2250, 2268,

     2287, 1095, 1237, 1242, 2304, 2322, 2341, 1256, 2358, 2379,
     2398, 2412, 2433, 1296, 1327, 1335,  557, 2454, 1429, 1476,
     2475, 2492, 1477, 1478, 2513, 2535, 1479, 2556, 1480, 1481
    } ;

static const flex_int16_t yy_def[631] =
    {   0,
      566,  566,  567,  567,  568,  568,  569,  569,  570,  570,
      571,  571,  572,  572,  572,  572,  573,  573,  574,  574,
      572,  572,  575,  575,  569,  569,  572,  572,  565,   29,
      576,  576,  565,   33,  565,   35,  577,  577,  578,  578,
      565,   41,  565,   43,  565,  565,  579,  565,  580,  580,
      565,  565,  581,  565,  565,  565,  565,  582,  583,  565,
      565,  565,  565,  565,  565,  584,  584,  565,  585,  583,
      586,  586,  587,  565,  565,  588,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  589,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,

      565,  565,  565,  565,  565,  565,  590,  590,  565,  565,
      565,  565,  565,  565,  565,  565,  591,  565,  589,  592,
      591,  591,  565,  565,  591,  565,  591,  565,  593,  591,
      591,  591,  594,  594,  594,  594,  594,  594,  595,  596,
      565,  597,  565,  565,  565,  565,  598,  565,  599,  579,
      580,  565,  565,  600,  581,  565,  565,  582,  583,  565,
      565,  565,  565,  565,  565,  565,  601,  584,  565,  565,
      602,  603,  604,  565,  586,  565,  605,  565,  588,  565,
      565,  565,  565,  565,  589,  565,  565,  187,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,

      565,  565,  565,  565,  606,  607,  565,  565,  565,  565,
      608,  565,  565,  565,  590,  590,  565,  565,  589,  591,
      591,  187,  187,  565,  565,  565,  609,  610,  565,  611,
      565,  565,  565,  565,  612,  591,  591,  591,  591,  594,
      565,  565,  565,  565,  565,  595,  565,  596,  597,  565,
      565,  598,  565,  599,  565,  600,  613,  601,  601,  601,
      565,  614,  615,  616,  605,  565,  565,  565,  565,  187,
      565,  270,  270,  187,  270,  187,  187,  187,  270,  565,
      565,  565,  565,  565,  565,  606,  607,  565,  565,  565,
      565,  565,  608,  590,  270,  295,  609,  610,  610,  611,

      565,  565,  612,  565,  617,  618,  565,  565,  565,  565,
      613,  613,  613,  613,  601,  565,  619,  620,  565,  565,
      565,  565,  565,  565,  565,  621,  270,  270,  270,  187,
      187,  187,  187,  270,  270,  565,  565,  565,  565,  565,
      590,  621,  565,  565,  622,  618,  618,  618,  618,  565,
      565,  565,  565,  613,  623,  624,  565,  565,  565,  565,
      565,  565,  565,  621,  625,  621,  270,  621,  187,  187,
      187,  187,  270,  270,  565,  565,  565,  565,  565,  565,
      590,  342,  295,  565,  565,  622,  626,  618,  565,  618,
      627,  565,  565,  565,  565,  565,  565,  565,  565,  625,

      565,  270,  621,  621,  621,  187,  187,  187,  187,  270,
      270,  565,  565,  565,  565,  565,  565,  590,  295,  565,
      565,  626,  422,  422,  422,  422,  628,  629,  565,  565,
      565,  565,  565,  187,  270,  565,  565,  565,  565,  565,
      590,  565,  565,  422,  422,  422,  422,  628,  630,  565,
      565,  565,  565,  187,  565,  565,  565,  565,  458,  590,
      590,  590,  590,  565,  565,  624,  565,  565,  565,  270,
      565,  270,  270,  565,  565,  565,  565,  565,  565,  590,
      590,  590,  590,  590,  590,  565,  465,  565,  565,  565,
      565,  565,  270,  565,  565,  565,  565,  590,  590,  590,

      590,  590,  590,  590,  590,  565,  565,  565,  565,  565,
      270,  565,  565,  565,  565,  590,  590,  590,  590,  590,
      590,  590,  590,  565,  565,  565,  565,  565,  565,  270,
      565,  565,  565,  565,  590,  590,  590,  590,  590,  590,
      565,  565,  565,  565,  270,  565,  565,  565,  565,  590,
      590,  590,  565,  565,  270,  565,  270,  565,  565,  565,
      565,  590,  565,  565,    0,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,

      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565
    } ;

static const flex_int16_t yy_nxt[2638] =
    {   0,
      565,  565,   72,   67,   50,   56,   50,   73,   50,   50,
       56,   68,  565,   51,   50,  157,   50,   48,   52,   62,
       63,   64,   48,  565,   50,   50,   50,   50,   62,   63,
       64,  565,   72,  140,   65,  233,   67,   73,  234,   78,
       79,   78,  152,   65,   68,   80,  188,  153,   57,   69,
       50,  141,  142,   57,  141,   70,   50,   50,  157,   50,
       70,   50,   50,  189,  198,  140,   51,   50,  183,   50,
       81,   52,  144,  144,  144,  199,  183,   50,   50,   50,
       50,  563,   69,  141,  142,  216,  141,  161,  162,  162,
      164,  164,  164,  216,  145,  184,  184,  184,  200,  165,

      185,  152,  163,   50,  562,  166,  153,  201,  202,   50,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   75,   75,   75,
       75,   76,   76,   76,   76,   75,   75,   75,   76,   78,
       79,   78,  144,  144,  144,   80,  164,  164,  164,  181,
      560,  195,  182,  236,  237,  165,  196,  184,  184,  184,
      203,  166,  185,  197,  145,  559,  204,  204,  204,  182,

       81,   82,   83,   84,   83,   85,   86,   87,   88,   89,
       90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
      100,  101,  101,  102,  103,  104,  105,  106,   82,  107,
      107,  107,  107,  108,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  109,   82,
      110,   82,  107,  107,  107,  107,  111,  112,  113,  107,
      114,  115,  116,  115,  117,  118,  119,  120,  121,  122,
      123,  124,  124,  121,  121,  124,  125,  126,  127,  128,
      128,  128,  129,  124,  130,  131,  132,  122,  133,  134,
      133,  133,  135,  133,  133,  133,  133,  133,  136,  133,

      133,  133,  133,  133,  133,  137,  138,  124,  114,  124,
      121,  133,  133,  137,  138,  114,  122,  114,  133,  146,
      146,  146,  146,  146,  146,  146,  146,  146,  146,  146,
      146,  146,  146,  146,  146,  146,  146,  146,  146,  146,
      146,  146,  146,  146,  146,  146,  146,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  146,  146,  146,  146,
      147,  147,  147,  147,  146,  146,  146,  147,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,

      148,  148,  148,  148,  148,  148,  149,  149,  149,  149,
      149,  149,  149,  149,  149,  149,  149,  149,  149,  149,
      149,  149,  149,  149,  149,  148,  148,  148,  148,  149,
      149,  149,  149,  148,  148,  148,  149,  170,  170,  178,
      178,  178,  552,  190,  181,  188,  205,  191,  218,  218,
      218,  206,  208,  219,  209,  209,  209,  192,  207,  261,
      261,  180,  189,  171,  191,  192,  229,  210,  204,  204,
      204,  172,  173,  208,  409,  209,  209,  209,  218,  218,
      218,  211,  409,  219,  225,  266,  268,  267,  210,  211,
      222,  283,  222,  551,  222,  222,  226,  226,  226,  222,

      222,  323,  222,  231,  222,  232,  232,  232,  324,  195,
      222,  222,  222,  222,  196,  250,  250,  250,  210,  316,
      316,  223,  253,  253,  253,  161,  162,  162,  330,  276,
      164,  164,  164,  277,  278,  331,  222,  251,  224,  165,
      163,  550,  222,  223,  255,  166,  164,  164,  164,  259,
      162,  162,  178,  178,  178,  165,  178,  178,  178,  276,
      224,  166,  334,  277,  260,  184,  184,  184,  279,  335,
      185,  279,  280,  281,  180,  280,  345,  345,  180,  270,
      270,  271,  272,  270,  270,  270,  270,  270,  270,  270,
      270,  270,  270,  270,  270,  270,  270,  273,  270,  270,

      270,  270,  270,  270,  270,  270,  270,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  274,  274,  274,  274,
      274,  274,  274,  274,  274,  274,  270,  275,  270,  270,
      270,  274,  274,  274,  270,  270,  270,  270,  204,  204,
      204,  289,  307,  290,  290,  290,  208,  308,  209,  209,
      209,  210,  291,  549,  291,  367,  210,  292,  292,  292,
      402,  210,  218,  218,  218,  547,  546,  219,  295,  545,
      295,  413,  295,  295,  226,  226,  226,  295,  295,  413,
      295,  289,  296,  301,  301,  301,  304,  305,  295,  295,
      295,  295,  327,  328,  329,  231,  210,  302,  302,  302,

      250,  250,  250,  304,  305,  253,  253,  253,  304,  305,
      210,  320,  359,  383,  295,  377,  415,  306,  419,  321,
      295,  299,  251,  299,  415,  299,  299,  255,  320,  359,
      299,  299,  377,  299,  306,  299,  253,  253,  253,  306,
      544,  299,  299,  299,  299,  312,  164,  164,  259,  162,
      162,  259,  162,  162,  313,  259,  162,  162,  255,  401,
      314,  425,  491,  260,  270,  502,  260,  299,  540,  492,
      315,  446,  503,  299,  270,  270,  270,  270,  270,  270,
      270,  270,  270,  270,  270,  270,  270,  270,  270,  270,
      270,  270,  270,  290,  290,  290,  538,  530,  270,  270,

      270,  292,  292,  292,  508,  530,  210,  292,  292,  292,
      295,  467,  295,  468,  295,  295,  327,  328,  329,  295,
      295,  508,  295,  343,  296,  344,  344,  344,  537,  536,
      295,  295,  295,  295,  346,  346,  346,  231,  210,  209,
      209,  209,  350,  350,  350,  312,  164,  164,  535,  348,
      304,  305,  210,  481,  313,  482,  295,  352,  352,  352,
      314,  483,  295,  299,  351,  299,  484,  299,  299,  327,
      328,  329,  299,  299,  534,  299,  533,  299,  529,  353,
      516,  306,  349,  299,  299,  299,  299,  312,  164,  164,
      312,  164,  164,  259,  162,  162,  313,  516,  528,  313,

      527,  469,  314,  445,  446,  314,  496,  523,  315,  299,
      312,  164,  164,  365,  366,  299,  362,  362,  362,  313,
      327,  328,  329,  522,  367,  354,  380,  380,  380,  273,
      384,  384,  384,  343,  447,  385,  385,  385,  346,  346,
      346,  346,  346,  346,  350,  350,  350,  521,  210,  346,
      346,  346,  520,  348,  518,  488,  348,  499,  363,  368,
      352,  352,  352,  489,  387,  500,  351,  519,  381,  365,
      366,  382,  488,  382,  499,  382,  382,  393,  393,  393,
      383,  382,  353,  382,  519,  296,  349,  531,  539,  349,
      517,  382,  382,  382,  382,  531,  539,  349,  346,  346,

      346,  312,  164,  164,  394,  394,  394,  362,  362,  362,
      313,  365,  366,  388,  389,  368,  354,  382,  365,  366,
      515,  514,  367,  382,  513,  548,  395,  273,  532,  367,
      403,  404,  405,  548,  273,  512,  380,  380,  380,  346,
      346,  346,  367,  511,  390,  532,  349,  273,  420,  363,
      421,  421,  421,  510,  348,  509,  343,  368,  290,  290,
      290,  346,  346,  346,  368,  393,  393,  393,  394,  394,
      394,  210,  431,  431,  431,  507,  387,  368,  417,  422,
      423,  346,  346,  422,  422,  422,  389,  349,  422,  422,
      395,  429,  429,  429,  422,  425,  506,  177,  403,  404,

      405,  422,  422,  422,  422,  505,  422,  504,  262,  349,
      367,  177,  177,  430,  262,  273,  439,  439,  439,  442,
      442,  442,  420,  501,  443,  443,  443,  422,  426,  422,
      431,  431,  431,  498,  422,  422,  422,  346,  346,  346,
      450,  450,  450,  347,  347,  368,  497,  347,  347,  347,
      347,  495,  348,  347,  347,  347,  347,  347,  456,  456,
      456,  494,  347,  493,  427,  427,  427,  427,  427,  427,
      427,  427,  427,  427,  427,  427,  427,  427,  427,  427,
      427,  427,  427,  347,  490,  349,  485,  427,  427,  427,
      427,  403,  404,  405,  427,  403,  404,  405,  429,  429,

      429,  480,  469,  367,  439,  439,  439,  367,  273,  464,
      464,  464,  273,  450,  450,  450,  456,  456,  456,  425,
      430,  420,  458,  451,  451,  451,  470,  471,  472,  451,
      451,  451,  474,  474,  474,  476,  476,  476,  368,  486,
      486,  486,  368,  422,  423,  346,  346,  422,  422,  422,
      263,  457,  422,  422,  452,  264,  263,  453,  422,  444,
      452,  264,  455,  453,  454,  422,  422,  422,  422,  293,
      422,  470,  471,  472,  453,  293,  473,  474,  474,  474,
      453,  425,  475,  470,  471,  472,  474,  474,  474,  342,
      441,  422,  426,  422,  476,  476,  476,  440,  422,  422,

      422,  346,  346,  346,  524,  524,  524,  438,  347,  317,
      437,  347,  347,  347,  347,  317,  388,  389,  347,  525,
      525,  525,  524,  524,  524,  436,  347,  524,  524,  524,
      435,  525,  525,  525,  525,  525,  525,  541,  541,  541,
      318,  526,  543,  543,  543,  410,  318,  390,  319,  349,
      459,  459,  459,  526,  319,  434,  526,  406,  406,  542,
      541,  541,  541,  543,  543,  543,  553,  553,  553,  541,
      541,  541,  543,  543,  543,  554,  554,  554,  326,  401,
      460,  461,  542,  433,  462,  555,  556,  557,  558,  558,
      558,  542,  432,  418,  463,  553,  553,  553,  561,  561,

      561,  462,  463,  465,  465,  465,  465,  465,  465,  465,
      465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
      465,  465,  554,  554,  554,  416,  465,  465,  465,  465,
      553,  553,  553,  465,  346,  346,  346,  554,  554,  554,
      414,  347,  355,  412,  347,  347,  347,  347,  355,  388,
      389,  347,  555,  556,  557,  558,  558,  558,  411,  347,
      555,  556,  557,  558,  558,  558,  561,  561,  561,  561,
      561,  561,  564,  564,  564,  564,  564,  564,  410,  408,
      390,  407,  349,  459,  459,  459,  564,  564,  564,  356,
      391,  392,  428,  449,  466,  356,  391,  392,  428,  449,

      466,  406,  401,  399,  398,  397,  396,  379,  378,  376,
      375,  374,  373,  477,  452,  372,  371,  478,  370,  369,
      361,  360,  358,  357,  305,  225,  342,  479,  341,  288,
      340,  339,  338,  337,  478,  479,  422,  423,  346,  346,
      422,  422,  422,  487,  424,  422,  422,  424,  424,  424,
      424,  422,  445,  446,  424,  487,  487,  487,  422,  422,
      422,  422,  424,  422,  487,  487,  487,  487,  487,  487,
      487,  487,  487,  487,  487,  487,  487,  487,  487,  487,
      487,  487,  487,  447,  422,  426,  422,  487,  487,  487,
      487,  422,  422,  422,  487,   46,   46,   46,   46,   46,

       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   47,   47,   47,
       47,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   47,   47,   47,   47,   47,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,

       55,   55,   55,   55,   55,   58,   58,   58,   58,   58,
       58,   58,   58,   58,   58,   58,   58,   58,   58,   58,
       58,   58,   58,   58,   58,   58,   58,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   66,   66,   66,   66,   66,   66,   66,   66,   66,
       66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
       66,   66,   66,   71,   71,   71,   71,   71,   71,   71,

       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   77,   77,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   77,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  143,
      143,  143,  143,  143,  143,  143,  143,  143,  143,  143,
      143,  143,  143,  143,  143,  143,  143,  143,  143,  143,
      143,  150,  150,  150,  150,  150,  150,  150,  336,  150,
      150,  150,  150,  150,  150,  150,  150,  150,  150,  150,

      150,  150,  150,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  333,  151,  151,  332,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  155,  155,  155,  155,  326,
      155,  155,  155,  155,  155,  155,  155,  155,  155,  155,
      155,  155,  155,  155,  155,  155,  155,  158,  158,  158,
      158,  158,  158,  158,  325,  158,  158,  158,  158,  158,
      158,  158,  158,  158,  158,  158,  158,  158,  158,  159,
      159,  159,  159,  159,  159,  159,  322,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  168,  168,  168,  168,  168,  168,  168,  176,  168,

      168,  168,  168,  168,  168,  168,  168,  168,  168,  168,
      168,  168,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,
      169,  169,  169,  169,  175,  175,  175,  175,  175,  310,
      175,  175,  175,  175,  175,  175,  175,  175,  175,  175,
      175,  175,  175,  175,  175,  175,  179,  179,  309,  247,
      179,  225,  294,  288,  285,  284,  282,  269,  179,  268,
      179,  176,  257,  167,  179,  179,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  215,  247,

      245,  244,  243,  242,  241,  239,  215,  238,  230,  228,
      221,  217,  215,  215,  220,  214,  213,  220,  212,  194,
      220,  220,  193,  220,  186,  156,  176,  220,  220,  220,
      227,  174,  160,  167,  160,  156,  154,  565,  227,   60,
       60,   74,   74,   60,  227,  227,  235,   60,   60,  235,
       60,  235,  235,  240,   48,   48,   54,   54,   48,   48,
      565,  240,  565,  565,  565,  565,  565,  240,  240,  246,
      246,  246,  246,  565,  246,  246,  246,  246,  246,  246,
      246,  246,  246,  246,  246,  565,  246,  565,  246,  246,
      246,  248,  248,  248,  248,  565,  248,  248,  248,  248,

      248,  248,  248,  248,  248,  248,  248,  248,  248,  248,
      248,  248,  248,  249,  249,  249,  249,  249,  249,  249,
      249,  249,  249,  249,  249,  249,  249,  249,  249,  249,
      249,  565,  249,  249,  249,  252,  565,  565,  565,  565,
      565,  565,  565,  252,  565,  565,  565,  565,  565,  252,
      252,  254,  254,  565,  565,  254,  565,  565,  565,  565,
      565,  565,  565,  254,  565,  254,  565,  565,  565,  254,
      254,  256,  565,  565,  256,  565,  565,  256,  256,  565,
      256,  565,  565,  565,  256,  256,  256,  258,  258,  258,
      258,  258,  258,  258,  258,  258,  258,  258,  258,  258,

      258,  258,  258,  258,  258,  258,  258,  258,  258,  265,
      565,  565,  565,  565,  565,  565,  565,  265,  565,  565,
      565,  565,  565,  265,  265,  286,  565,  565,  286,  565,
      565,  286,  286,  565,  286,  565,  565,  565,  286,  286,
      286,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  297,  565,  565,  565,  565,  565,  565,
      565,  297,  565,  565,  565,  565,  565,  297,  297,  298,
      298,  565,  298,  298,  298,  298,  298,  298,  298,  298,
      298,  298,  298,  298,  298,  298,  298,  298,  298,  298,

      298,  300,  565,  565,  300,  565,  565,  300,  300,  565,
      300,  565,  565,  565,  300,  300,  300,  303,  565,  565,
      565,  565,  303,  303,  565,  303,  565,  565,  565,  565,
      565,  303,  303,  311,  311,  311,  311,  311,  311,  311,
      311,  311,  311,  311,  311,  311,  311,  311,  311,  311,
      311,  311,  311,  311,  311,  347,  347,  565,  565,  347,
      347,  565,  347,  347,  347,  347,  347,  347,  565,  565,
      565,  565,  347,  347,  347,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
      364,  364,  364,  364,  364,  364,  364,  386,  565,  565,

      565,  565,  386,  386,  565,  386,  565,  565,  565,  565,
      565,  386,  386,  400,  400,  400,  400,  400,  400,  400,
      400,  400,  400,  400,  400,  565,  400,  400,  400,  400,
      400,  400,  400,  400,  400,  424,  424,  424,  424,  424,
      424,  424,  424,  424,  424,  424,  424,  424,  424,  424,
      424,  424,  424,  424,  424,  424,  424,  448,  448,  565,
      565,  448,  448,  565,  448,  448,  448,  448,  448,  448,
      565,  565,  565,  565,  448,  448,  448,   45,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,

      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565
    } ;

static const flex_int16_t yy_chk[2638] =
    {   0,
        0,    0,   23,   19,    5,    9,    5,   23,    5,    5,
       10,   19,    0,    5,    5,   57,    5,   21,    5,   17,
       17,   17,   22,    0,    5,    5,    5,    5,   18,   18,
       18,    0,   24,   37,   17,  129,   20,   24,  129,   31,
       31,   31,   51,   18,   20,   31,   87,   51,    9,   19,
        5,   37,   37,   10,   37,   21,    5,    6,   57,    6,
       22,    6,    6,   87,   95,   38,    6,    6,   81,    6,
       31,    6,   39,   39,   39,   95,   81,    6,    6,    6,
        6,  560,   20,   38,   38,  108,   38,   62,   62,   62,
       63,   63,   63,  108,   39,   83,   83,   83,   97,   63,

       83,  152,   62,    6,  552,   63,  152,   97,   97,    6,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   32,
       32,   32,   40,   40,   40,   32,   64,   64,   64,   80,
      548,   94,   80,  130,  130,   64,   94,   84,   84,   84,
       98,   64,   84,   94,   40,  547,   98,   98,   98,   80,

       32,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,

       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,

       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   69,   69,   76,
       76,   76,  539,   88,   88,  185,   99,   88,  115,  115,
      115,   99,  100,  115,  100,  100,  100,   88,   99,  170,
      170,   76,  185,   69,   88,   88,  126,  100,  126,  126,
      126,   69,   69,  101,  372,  101,  101,  101,  116,  116,
      116,  100,  372,  116,  120,  181,  191,  181,  101,  100,
      119,  191,  119,  538,  119,  119,  120,  120,  120,  119,

      119,  268,  119,  128,  119,  128,  128,  128,  268,  195,
      119,  119,  119,  119,  195,  144,  144,  144,  128,  261,
      261,  119,  149,  149,  149,  161,  161,  161,  276,  188,
      162,  162,  162,  188,  188,  276,  119,  144,  119,  162,
      161,  535,  119,  219,  149,  162,  164,  164,  164,  167,
      167,  167,  178,  178,  178,  164,  179,  179,  179,  223,
      219,  164,  279,  223,  167,  184,  184,  184,  189,  279,
      184,  224,  189,  189,  178,  224,  617,  617,  179,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,

      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  187,  204,  204,
      204,  208,  244,  208,  208,  208,  209,  244,  209,  209,
      209,  204,  210,  534,  210,  367,  208,  210,  210,  210,
      367,  209,  218,  218,  218,  532,  531,  218,  222,  530,
      222,  376,  222,  222,  226,  226,  226,  222,  222,  376,
      222,  231,  222,  231,  231,  231,  235,  235,  222,  222,
      222,  222,  275,  275,  275,  232,  231,  232,  232,  232,

      250,  250,  250,  303,  303,  253,  253,  253,  345,  345,
      232,  266,  322,  383,  222,  338,  378,  235,  383,  266,
      222,  228,  250,  228,  378,  228,  228,  253,  266,  322,
      228,  228,  338,  228,  303,  228,  254,  254,  254,  345,
      529,  228,  228,  228,  228,  257,  257,  257,  258,  258,
      258,  259,  259,  259,  257,  260,  260,  260,  254,  401,
      257,  445,  469,  258,  401,  483,  259,  228,  523,  469,
      260,  445,  483,  228,  270,  270,  270,  270,  270,  270,
      270,  270,  270,  270,  270,  270,  270,  270,  270,  270,
      270,  270,  270,  290,  290,  290,  521,  511,  270,  270,

      270,  291,  291,  291,  490,  511,  290,  292,  292,  292,
      295,  452,  295,  452,  295,  295,  327,  327,  327,  295,
      295,  490,  295,  301,  295,  301,  301,  301,  520,  519,
      295,  295,  295,  295,  306,  306,  306,  302,  301,  302,
      302,  302,  309,  309,  309,  311,  311,  311,  516,  306,
      386,  386,  302,  461,  311,  461,  295,  310,  310,  310,
      311,  462,  295,  299,  309,  299,  462,  299,  299,  328,
      328,  328,  299,  299,  515,  299,  514,  299,  510,  310,
      498,  386,  306,  299,  299,  299,  299,  312,  312,  312,
      313,  313,  313,  315,  315,  315,  312,  498,  509,  313,

      508,  478,  312,  426,  426,  313,  478,  505,  315,  299,
      314,  314,  314,  326,  326,  299,  325,  325,  325,  314,
      329,  329,  329,  504,  326,  314,  341,  341,  341,  326,
      343,  343,  343,  344,  426,  344,  344,  344,  346,  346,
      346,  347,  347,  347,  350,  350,  350,  503,  344,  348,
      348,  348,  502,  346,  500,  467,  347,  481,  325,  326,
      352,  352,  352,  467,  348,  481,  350,  501,  341,  342,
      342,  342,  467,  342,  481,  342,  342,  357,  357,  357,
      342,  342,  352,  342,  501,  342,  346,  512,  522,  347,
      499,  342,  342,  342,  342,  512,  522,  348,  349,  349,

      349,  354,  354,  354,  358,  358,  358,  362,  362,  362,
      354,  364,  364,  349,  349,  342,  354,  342,  366,  366,
      497,  496,  364,  342,  495,  533,  358,  364,  513,  366,
      368,  368,  368,  533,  366,  494,  380,  380,  380,  390,
      390,  390,  368,  493,  349,  513,  349,  368,  384,  362,
      384,  384,  384,  492,  390,  491,  385,  364,  385,  385,
      385,  388,  388,  388,  366,  393,  393,  393,  394,  394,
      394,  385,  397,  397,  397,  489,  388,  368,  380,  387,
      387,  387,  387,  387,  387,  387,  388,  390,  387,  387,
      394,  396,  396,  396,  387,  387,  488,  587,  403,  403,

      403,  387,  387,  387,  387,  485,  387,  484,  602,  388,
      403,  587,  587,  396,  602,  403,  416,  416,  416,  420,
      420,  420,  421,  482,  421,  421,  421,  387,  387,  387,
      431,  431,  431,  480,  387,  387,  387,  389,  389,  389,
      432,  432,  432,  389,  389,  403,  479,  389,  389,  389,
      389,  477,  389,  389,  389,  389,  389,  389,  437,  437,
      437,  475,  389,  473,  389,  389,  389,  389,  389,  389,
      389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
      389,  389,  389,  389,  468,  389,  463,  389,  389,  389,
      389,  404,  404,  404,  389,  405,  405,  405,  429,  429,

      429,  460,  453,  404,  439,  439,  439,  405,  404,  442,
      442,  442,  405,  450,  450,  450,  456,  456,  456,  444,
      429,  443,  440,  433,  433,  433,  454,  454,  454,  451,
      451,  451,  455,  455,  455,  457,  457,  457,  404,  464,
      464,  464,  405,  422,  422,  422,  422,  422,  422,  422,
      603,  438,  422,  422,  433,  604,  603,  433,  422,  422,
      451,  604,  436,  451,  434,  422,  422,  422,  422,  608,
      422,  470,  470,  470,  433,  608,  454,  471,  471,  471,
      451,  425,  455,  472,  472,  472,  474,  474,  474,  419,
      418,  422,  422,  422,  476,  476,  476,  417,  422,  422,

      422,  427,  427,  427,  506,  506,  506,  415,  427,  614,
      414,  427,  427,  427,  427,  614,  427,  427,  427,  507,
      507,  507,  517,  517,  517,  413,  427,  524,  524,  524,
      412,  518,  518,  518,  525,  525,  525,  527,  527,  527,
      615,  507,  528,  528,  528,  411,  615,  427,  616,  427,
      441,  441,  441,  518,  616,  409,  525,  408,  407,  527,
      536,  536,  536,  537,  537,  537,  540,  540,  540,  541,
      541,  541,  543,  543,  543,  544,  544,  544,  402,  400,
      441,  441,  536,  399,  441,  545,  545,  545,  546,  546,
      546,  541,  398,  381,  441,  549,  549,  549,  550,  550,

      550,  441,  441,  446,  446,  446,  446,  446,  446,  446,
      446,  446,  446,  446,  446,  446,  446,  446,  446,  446,
      446,  446,  551,  551,  551,  379,  446,  446,  446,  446,
      553,  553,  553,  446,  448,  448,  448,  554,  554,  554,
      377,  448,  619,  375,  448,  448,  448,  448,  619,  448,
      448,  448,  555,  555,  555,  556,  556,  556,  374,  448,
      557,  557,  557,  558,  558,  558,  559,  559,  559,  561,
      561,  561,  562,  562,  562,  563,  563,  563,  373,  371,
      448,  370,  448,  458,  458,  458,  564,  564,  564,  620,
      623,  624,  627,  629,  630,  620,  623,  624,  627,  629,

      630,  369,  365,  363,  361,  360,  359,  340,  339,  337,
      336,  335,  334,  458,  458,  333,  332,  458,  331,  330,
      324,  323,  321,  320,  304,  297,  296,  458,  294,  287,
      284,  283,  282,  281,  458,  458,  465,  465,  465,  465,
      465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
      465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
      465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
      465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
      465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
      465,  465,  465,  465,  465,  566,  566,  566,  566,  566,

      566,  566,  566,  566,  566,  566,  566,  566,  566,  566,
      566,  566,  566,  566,  566,  566,  566,  567,  567,  567,
      567,  567,  567,  567,  567,  567,  567,  567,  567,  567,
      567,  567,  567,  567,  567,  567,  567,  567,  567,  568,
      568,  568,  568,  568,  568,  568,  568,  568,  568,  568,
      568,  568,  568,  568,  568,  568,  568,  568,  568,  568,
      568,  569,  569,  569,  569,  569,  569,  569,  569,  569,
      569,  569,  569,  569,  569,  569,  569,  569,  569,  569,
      569,  569,  569,  570,  570,  570,  570,  570,  570,  570,
      570,  570,  570,  570,  570,  570,  570,  570,  570,  570,

      570,  570,  570,  570,  570,  571,  571,  571,  571,  571,
      571,  571,  571,  571,  571,  571,  571,  571,  571,  571,
      571,  571,  571,  571,  571,  571,  571,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  572,
      572,  572,  572,  572,  572,  572,  572,  572,  572,  573,
      573,  573,  573,  573,  573,  573,  573,  573,  573,  573,
      573,  573,  573,  573,  573,  573,  573,  573,  573,  573,
      573,  574,  574,  574,  574,  574,  574,  574,  574,  574,
      574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
      574,  574,  574,  575,  575,  575,  575,  575,  575,  575,

      575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
      575,  575,  575,  575,  575,  576,  576,  576,  576,  576,
      576,  576,  576,  576,  576,  576,  576,  576,  576,  576,
      576,  576,  576,  576,  576,  576,  576,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  577,  578,
      578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
      578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
      578,  579,  579,  579,  579,  579,  579,  579,  280,  579,
      579,  579,  579,  579,  579,  579,  579,  579,  579,  579,

      579,  579,  579,  580,  580,  580,  580,  580,  580,  580,
      580,  580,  278,  580,  580,  277,  580,  580,  580,  580,
      580,  580,  580,  580,  580,  581,  581,  581,  581,  273,
      581,  581,  581,  581,  581,  581,  581,  581,  581,  581,
      581,  581,  581,  581,  581,  581,  581,  582,  582,  582,
      582,  582,  582,  582,  269,  582,  582,  582,  582,  582,
      582,  582,  582,  582,  582,  582,  582,  582,  582,  583,
      583,  583,  583,  583,  583,  583,  267,  583,  583,  583,
      583,  583,  583,  583,  583,  583,  583,  583,  583,  583,
      583,  584,  584,  584,  584,  584,  584,  584,  265,  584,

      584,  584,  584,  584,  584,  584,  584,  584,  584,  584,
      584,  584,  585,  585,  585,  585,  585,  585,  585,  585,
      585,  585,  585,  585,  585,  585,  585,  585,  585,  585,
      585,  585,  585,  585,  586,  586,  586,  586,  586,  249,
      586,  586,  586,  586,  586,  586,  586,  586,  586,  586,
      586,  586,  586,  586,  586,  586,  588,  588,  248,  246,
      588,  227,  216,  206,  202,  192,  190,  183,  588,  182,
      588,  177,  166,  163,  588,  588,  589,  589,  589,  589,
      589,  589,  589,  589,  589,  589,  589,  589,  589,  589,
      589,  589,  589,  589,  589,  589,  589,  589,  590,  139,

      138,  137,  136,  135,  134,  132,  590,  131,  127,  125,
      117,  112,  590,  590,  591,  106,  105,  591,  104,   90,
      591,  591,   89,  591,   85,   74,   73,  591,  591,  591,
      592,   70,   68,   65,   60,   54,   52,   45,  592,   28,
       27,   26,   25,   16,  592,  592,  593,   15,   14,  593,
       13,  593,  593,  594,   12,   11,    8,    7,    4,    3,
        0,  594,    0,    0,    0,    0,    0,  594,  594,  595,
      595,  595,  595,    0,  595,  595,  595,  595,  595,  595,
      595,  595,  595,  595,  595,    0,  595,    0,  595,  595,
      595,  596,  596,  596,  596,    0,  596,  596,  596,  596,

      596,  596,  596,  596,  596,  596,  596,  596,  596,  596,
      596,  596,  596,  597,  597,  597,  597,  597,  597,  597,
      597,  597,  597,  597,  597,  597,  597,  597,  597,  597,
      597,    0,  597,  597,  597,  598,    0,    0,    0,    0,
        0,    0,    0,  598,    0,    0,    0,    0,    0,  598,
      598,  599,  599,    0,    0,  599,    0,    0,    0,    0,
        0,    0,    0,  599,    0,  599,    0,    0,    0,  599,
      599,  600,    0,    0,  600,    0,    0,  600,  600,    0,
      600,    0,    0,    0,  600,  600,  600,  601,  601,  601,
      601,  601,  601,  601,  601,  601,  601,  601,  601,  601,

      601,  601,  601,  601,  601,  601,  601,  601,  601,  605,
        0,    0,    0,    0,    0,    0,    0,  605,    0,    0,
        0,    0,    0,  605,  605,  606,    0,    0,  606,    0,
        0,  606,  606,    0,  606,    0,    0,    0,  606,  606,
      606,  607,  607,  607,  607,  607,  607,  607,  607,  607,
      607,  607,  607,  607,  607,  607,  607,  607,  607,  607,
      607,  607,  607,  609,    0,    0,    0,    0,    0,    0,
        0,  609,    0,    0,    0,    0,    0,  609,  609,  610,
      610,    0,  610,  610,  610,  610,  610,  610,  610,  610,
      610,  610,  610,  610,  610,  610,  610,  610,  610,  610,

      610,  611,    0,    0,  611,    0,    0,  611,  611,    0,
      611,    0,    0,    0,  611,  611,  611,  612,    0,    0,
        0,    0,  612,  612,    0,  612,    0,    0,    0,    0,
        0,  612,  612,  613,  613,  613,  613,  613,  613,  613,
      613,  613,  613,  613,  613,  613,  613,  613,  613,  613,
      613,  613,  613,  613,  613,  618,  618,    0,    0,  618,
      618,    0,  618,  618,  618,  618,  618,  618,    0,    0,
        0,    0,  618,  618,  618,  621,  621,  621,  621,  621,
      621,  621,  621,  621,  621,  621,  621,  621,  621,  621,
      621,  621,  621,  621,  621,  621,  621,  622,    0,    0,

        0,    0,  622,  622,    0,  622,    0,    0,    0,    0,
        0,  622,  622,  625,  625,  625,  625,  625,  625,  625,
      625,  625,  625,  625,  625,    0,  625,  625,  625,  625,
      625,  625,  625,  625,  625,  626,  626,  626,  626,  626,
      626,  626,  626,  626,  626,  626,  626,  626,  626,  626,
      626,  626,  626,  626,  626,  626,  626,  628,  628,    0,
        0,  628,  628,    0,  628,  628,  628,  628,  628,  628,
        0,    0,    0,    0,  628,  628,  628,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,

      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
      565,  565,  565,  565,  565,  565,  565
    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[140] =
    {   0,
1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
    1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
    0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
        };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "pgc.l"

#line 33 "pgc.l"

/* LCOV_EXCL_START */

extern YYSTYPE base_yylval;

static int		xcdepth = 0;	/* depth of nesting in slash-star comments */
static char	   *dolqstart = NULL;	/* current $foo$ quote start string */

/*
 * literalbuf is used to accumulate literal values when multiple rules
 * are needed to parse a single literal.  Call startlit to reset buffer
 * to empty, addlit to add text.  Note that the buffer is permanently
 * malloc'd to the largest size needed so far in the current run.
 */
static char	   *literalbuf = NULL;		/* expandable buffer */
static int		literallen;				/* actual current length */
static int		literalalloc;			/* current allocated buffer size */

/* Used for detecting global state together with braces_open */
static int		parenths_open;

/* Used to tell parse_include() whether the command was #include or #include_next */
static bool		include_next;

#define startlit()	(literalbuf[0] = '\0', literallen = 0)
static void addlit(char *ytext, int yleng);
static void addlitchar(unsigned char);
static int	process_integer_literal(const char *token, YYSTYPE *lval);
static void parse_include(void);
static bool ecpg_isspace(char ch);
static bool isdefine(void);
static bool isinformixdefine(void);

char *token_start;

/* vars to keep track of start conditions when scanning literals */
static int state_before_str_start;
static int state_before_str_stop;

struct _yy_buffer
{
	YY_BUFFER_STATE		buffer;
	long				lineno;
	char			   *filename;
	struct _yy_buffer  *next;
} *yy_buffer = NULL;

static char *old;

#define MAX_NESTED_IF 128
static short preproc_tos;
static short ifcond;
static struct _if_value
{
	short condition;
	short else_branch;
} stacked_if_value[MAX_NESTED_IF];

#line 1603 "pgc.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xdc> double-quoted strings in C
 *  <xh> hexadecimal numeric string
 *  <xn> national character quoted strings
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xqc> single-quoted strings in C
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xcond> condition of an EXEC SQL IFDEF construct
 *  <xskip> skipping the inactive part of an EXEC SQL IFDEF construct
 *
 * Note: we intentionally don't mimic the backend's <xeu> state; we have
 * no need to distinguish it from <xe> state.
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/* Additional exclusive states that are specific to ECPG */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  SQL-style comments, which start with -- and extend to the
 * next newline, are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix ecpg_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 */
/* Hexadecimal number */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* special stuff for C strings */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/* we no longer allow unary minus in numbers.
 * instead we pass it separately to parser. there it gets
 * coerced via doNegate() -- Leon aug 20 1999
 *
 * {decimalfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail1} and {realfail2} are added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/* special characters for other dbms */
/* we have to react differently in compat mode */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
/* some stuff needed for ecpg */
/* C version of hex number */
/* we might want to parse all cpp include files */
/* take care of cpp lines, they may also be continued */
/* first a general line for all commands not starting with "i" */
/* and then the other commands starting with "i", we have to add these
 * separately because the cppline production would match on "include" too
 */
#line 1763 "pgc.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xdc 4
#define xh 5
#define xn 6
#define xq 7
#define xqs 8
#define xe 9
#define xqc 10
#define xdolq 11
#define xui 12
#define xus 13
#define xcond 14
#define xskip 15
#define C 16
#define SQL 17
#define incl 18
#define def 19
#define def_ident 20
#define undef 21

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 409 "pgc.l"



#line 413 "pgc.l"
		/* code to execute during start of each call of yylex() */
		token_start = NULL;


#line 2010 "pgc.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 566 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 565 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 418 "pgc.l"
{
					/* ignore */
				}
	YY_BREAK
/* <SQL> */

case 2:
YY_RULE_SETUP
#line 424 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
					fputs("/*", yyout);
				}
	YY_BREAK
/* <C,SQL> */

case 3:
YY_RULE_SETUP
#line 436 "pgc.l"
{
					if (state_before_str_start == SQL)
					{
						xcdepth++;
						/* Put back any characters past slash-star; see above */
						yyless(2);
						fputs("/_*", yyout);
					}
					else if (state_before_str_start == C)
					{
						ECHO;
					}
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 450 "pgc.l"
{
					if (state_before_str_start == SQL)
					{
						if (xcdepth <= 0)
						{
							ECHO;
							BEGIN(SQL);
							token_start = NULL;
						}
						else
						{
							xcdepth--;
							fputs("*_/", yyout);
						}
					}
					else if (state_before_str_start == C)
					{
						ECHO;
						BEGIN(C);
						token_start = NULL;
					}
				}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 473 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 477 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 481 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 485 "pgc.l"
{
					mmfatal(PARSE_ERROR, "unterminated /* comment");
				}
	YY_BREAK
/* <xc> */

case 8:
YY_RULE_SETUP
#line 491 "pgc.l"
{
					token_start = yytext;
					BEGIN(xb);
					startlit();
					addlitchar('b');
				}
	YY_BREAK
/* <SQL> */
case 9:
/* rule 9 can match eol */
#line 500 "pgc.l"
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 500 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 503 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated bit string literal"); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 505 "pgc.l"
{
					token_start = yytext;
					BEGIN(xh);
					startlit();
					addlitchar('x');
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 511 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated hexadecimal string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 513 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xqc);
					startlit();
				}
	YY_BREAK

case 13:
YY_RULE_SETUP
#line 521 "pgc.l"
{
					/* National character.
					 * Transfer it as-is to the backend.
					 */
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xn);
					startlit();
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 531 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xq);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 537 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 543 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 17:
YY_RULE_SETUP
#line 551 "pgc.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 563 "pgc.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(state_before_str_stop);
				}
	YY_BREAK
case 19:
/* rule 19 can match eol */
#line 572 "pgc.l"
case 20:
/* rule 20 can match eol */
#line 573 "pgc.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 573 "pgc.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(state_before_str_start);

					switch (state_before_str_stop)
					{
						case xb:
							if (literalbuf[strspn(literalbuf, "01") + 1] != '\0')
								mmerror(PARSE_ERROR, ET_ERROR, "invalid bit string literal");
							base_yylval.str = mm_strdup(literalbuf);
							return BCONST;
						case xh:
							base_yylval.str = mm_strdup(literalbuf);
							return XCONST;
						case xq:
							/* fallthrough */
						case xqc:
							base_yylval.str = psprintf("'%s'", literalbuf);
							return SCONST;
						case xe:
							base_yylval.str = psprintf("E'%s'", literalbuf);
							return SCONST;
						case xn:
							base_yylval.str = psprintf("N'%s'", literalbuf);
							return SCONST;
						case xus:
							base_yylval.str = psprintf("U&'%s'", literalbuf);
							return USCONST;
						default:
							mmfatal(PARSE_ERROR, "unhandled previous state in xqs\n");
					}
				}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 611 "pgc.l"
{ addlitchar('\''); }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 612 "pgc.l"
{
					addlitchar('\\');
					addlitchar('\'');
				}
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 616 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 617 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 620 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 26:
/* rule 26 can match eol */
YY_RULE_SETUP
#line 623 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 626 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 629 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 632 "pgc.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0]);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xqc):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xn):
case YY_STATE_EOF(xus):
#line 636 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK

case 30:
YY_RULE_SETUP
#line 639 "pgc.l"
{
					token_start = yytext;
					if (dolqstart)
						free(dolqstart);
					dolqstart = mm_strdup(yytext);
					BEGIN(xdolq);
					startlit();
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 648 "pgc.l"
{
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
/* <SQL> */
case 32:
YY_RULE_SETUP
#line 656 "pgc.l"
{
					if (strcmp(yytext, dolqstart) == 0)
					{
						addlit(yytext, yyleng);
						free(dolqstart);
						dolqstart = NULL;
						BEGIN(SQL);
						base_yylval.str = mm_strdup(literalbuf);
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 33:
/* rule 33 can match eol */
YY_RULE_SETUP
#line 677 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 680 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 683 "pgc.l"
{
					/* single quote or dollar sign */
					addlitchar(yytext[0]);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 687 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated dollar-quoted string"); }
	YY_BREAK

case 36:
YY_RULE_SETUP
#line 690 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 695 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 38:
YY_RULE_SETUP
#line 702 "pgc.l"
{
					BEGIN(state_before_str_start);
					if (literallen == 0)
						mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
					/* The backend will truncate the identifier here. We do not as it does not change the result. */
					base_yylval.str = mm_strdup(literalbuf);
					return CSTRING;
				}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 710 "pgc.l"
{
					BEGIN(state_before_str_start);
					base_yylval.str = mm_strdup(literalbuf);
					return CSTRING;
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 715 "pgc.l"
{
					BEGIN(state_before_str_start);
					if (literallen == 2) /* "U&" */
						mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
					/* The backend will truncate the identifier here. We do not as it does not change the result. */
					base_yylval.str = psprintf("U&\"%s\"", literalbuf);
					return UIDENT;
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 723 "pgc.l"
{
					addlitchar('"');
				}
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 726 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 729 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted identifier"); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 730 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xdc);
					startlit();
				}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 735 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xdc):
#line 738 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK

case 45:
YY_RULE_SETUP
#line 741 "pgc.l"
{
					return TYPECAST;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 745 "pgc.l"
{
					return DOT_DOT;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 749 "pgc.l"
{
					return COLON_EQUALS;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 753 "pgc.l"
{
					return EQUALS_GREATER;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 757 "pgc.l"
{
					return LESS_EQUALS;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 761 "pgc.l"
{
					return GREATER_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 765 "pgc.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					return NOT_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 770 "pgc.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 775 "pgc.l"
{
			  /* are we simulating Informix? */
				if (INFORMIX_MODE)
				{
					unput(':');
				}
				else
					return yytext[0];
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 785 "pgc.l"
{
					/*
					 * We may find a ';' inside a structure
					 * definition in a TYPE or VAR statement.
					 * This is not an EOL marker.
					 */
					if (yytext[0] == ';' && struct_level == 0)
						BEGIN(C);
					return yytext[0];
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 796 "pgc.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					base_yylval.str = mm_strdup(yytext);
					return Op;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 893 "pgc.l"
{
					base_yylval.ival = atol(yytext+1);
					return PARAM;
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 898 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return IP;
				}
	YY_BREAK
/* <SQL> */

case 58:
YY_RULE_SETUP
#line 905 "pgc.l"
{
					return process_integer_literal(yytext, &base_yylval);
				}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 908 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 912 "pgc.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					return process_integer_literal(yytext, &base_yylval);
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 917 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 921 "pgc.l"
{
					/*
					 * throw back the [Ee], and figure out whether what
					 * remains is an {integer} or {decimal}.
					 */
					yyless(yyleng - 1);
					return process_integer_literal(yytext, &base_yylval);
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 929 "pgc.l"
{
					/* throw back the [Ee][+-], and proceed as above */
					yyless(yyleng - 2);
					return process_integer_literal(yytext, &base_yylval);
				}
	YY_BREAK
/* <C,SQL> */

case 64:
/* rule 64 can match eol */
YY_RULE_SETUP
#line 937 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext+1);
					return CVARIABLE;
				}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 942 "pgc.l"
{
					if (!isdefine())
					{
						int		kwvalue;

						/* Is it an SQL/ECPG keyword? */
						kwvalue = ScanECPGKeywordLookup(yytext);
						if (kwvalue >= 0)
							return kwvalue;

						/* Is it a C keyword? */
						kwvalue = ScanCKeywordLookup(yytext);
						if (kwvalue >= 0)
							return kwvalue;

						/*
						 * None of the above.  Return it as an identifier.
						 *
						 * The backend will attempt to truncate and case-fold
						 * the identifier, but I see no good reason for ecpg
						 * to do so; that's just another way that ecpg could get
						 * out of step with the backend.
						 */
						base_yylval.str = mm_strdup(yytext);
						return IDENT;
					}
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 970 "pgc.l"
{
					return yytext[0];
				}
	YY_BREAK
/* <SQL> */
/*
	 * Begin ECPG-specific rules
	 */
case 67:
/* rule 67 can match eol */
YY_RULE_SETUP
#line 979 "pgc.l"
{ BEGIN(SQL); return SQL_START; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 980 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(SQL);
							return SQL_START;
						}
						else
							return S_ANYTHING;
					 }
	YY_BREAK
case 69:
/* rule 69 can match eol */
YY_RULE_SETUP
#line 990 "pgc.l"
{ ECHO; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 991 "pgc.l"
{
						char* endptr;

						errno = 0;
						base_yylval.ival = strtoul((char *)yytext,&endptr,16);
						if (*endptr != '\0' || errno == ERANGE)
						{
							errno = 0;
							base_yylval.str = mm_strdup(yytext);
							return SCONST;
						}
						return ICONST;
					}
	YY_BREAK
case 71:
/* rule 71 can match eol */
YY_RULE_SETUP
#line 1004 "pgc.l"
{
						if (system_includes)
						{
							include_next = false;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(yytext);
							return CPP_LINE;
						}
					}
	YY_BREAK
case 72:
/* rule 72 can match eol */
YY_RULE_SETUP
#line 1016 "pgc.l"
{
						if (system_includes)
						{
							include_next = true;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(yytext);
							return CPP_LINE;
						}
					}
	YY_BREAK
case 73:
/* rule 73 can match eol */
YY_RULE_SETUP
#line 1028 "pgc.l"
{
						base_yylval.str = mm_strdup(yytext);
						return CPP_LINE;
					}
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 1032 "pgc.l"
{
						/*
						 * Try to detect a function name:
						 * look for identifiers at the global scope
						 * keep the last identifier before the first '(' and '{'
						 */
						if (braces_open == 0 && parenths_open == 0)
						{
							if (current_function)
								free(current_function);
							current_function = mm_strdup(yytext);
						}
						/* Informix uses SQL defines only in SQL space */
						/* however, some defines have to be taken care of for compatibility */
						if ((!INFORMIX_MODE || !isinformixdefine()) && !isdefine())
						{
							int		kwvalue;

							kwvalue = ScanCKeywordLookup(yytext);
							if (kwvalue >= 0)
								return kwvalue;
							else
							{
								base_yylval.str = mm_strdup(yytext);
								return IDENT;
							}
						}
					}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 1060 "pgc.l"
{ mmerror(PARSE_ERROR, ET_ERROR, "nested /* ... */ comments"); }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 1061 "pgc.l"
{ return ':'; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 1062 "pgc.l"
{ return ';'; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 1063 "pgc.l"
{ return ','; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 1064 "pgc.l"
{ return '*'; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 1065 "pgc.l"
{ return '%'; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 1066 "pgc.l"
{ return '/'; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 1067 "pgc.l"
{ return '+'; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 1068 "pgc.l"
{ return '-'; }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 1069 "pgc.l"
{ parenths_open++; return '('; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 1070 "pgc.l"
{ parenths_open--; return ')'; }
	YY_BREAK
case 86:
/* rule 86 can match eol */
YY_RULE_SETUP
#line 1071 "pgc.l"
{ ECHO; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 1072 "pgc.l"
{ return '{'; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 1073 "pgc.l"
{ return '}'; }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 1074 "pgc.l"
{ return '['; }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 1075 "pgc.l"
{ return ']'; }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 1076 "pgc.l"
{ return '='; }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 1077 "pgc.l"
{ return S_MEMBER; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 1078 "pgc.l"
{ return S_RSHIFT; }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 1079 "pgc.l"
{ return S_LSHIFT; }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 1080 "pgc.l"
{ return S_OR; }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 1081 "pgc.l"
{ return S_AND; }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 1082 "pgc.l"
{ return S_INC; }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 1083 "pgc.l"
{ return S_DEC; }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 1084 "pgc.l"
{ return S_EQUAL; }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 1085 "pgc.l"
{ return S_NEQUAL; }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 1086 "pgc.l"
{ return S_ADD; }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 1087 "pgc.l"
{ return S_SUB; }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 1088 "pgc.l"
{ return S_MUL; }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 1089 "pgc.l"
{ return S_DIV; }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 1090 "pgc.l"
{ return S_MOD; }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 1091 "pgc.l"
{ return S_MEMPOINT; }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 1092 "pgc.l"
{ return S_DOTPOINT; }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 1093 "pgc.l"
{ return S_ANYTHING; }
	YY_BREAK
case 109:
/* rule 109 can match eol */
YY_RULE_SETUP
#line 1094 "pgc.l"
{ BEGIN(def_ident); }
	YY_BREAK
case 110:
/* rule 110 can match eol */
YY_RULE_SETUP
#line 1095 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(def_ident);
						}
						else
						{
							yyless(1);
							return S_ANYTHING;
						}
					}
	YY_BREAK
case 111:
/* rule 111 can match eol */
YY_RULE_SETUP
#line 1107 "pgc.l"
{ BEGIN(undef); }
	YY_BREAK
case 112:
/* rule 112 can match eol */
YY_RULE_SETUP
#line 1108 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(undef);
						}
						else
						{
							yyless(1);
							return S_ANYTHING;
						}
					}
	YY_BREAK
case 113:
/* rule 113 can match eol */
YY_RULE_SETUP
#line 1120 "pgc.l"
{
					struct _defines *ptr, *ptr2 = NULL;
					int i;

					/*
					 *	Skip the ";" and trailing whitespace. Note that yytext
					 *	contains at least one non-space character plus the ";"
					 */
					for (i = strlen(yytext)-2;
						 i > 0 && ecpg_isspace(yytext[i]);
						 i-- )
						;
					yytext[i+1] = '\0';


					for (ptr = defines; ptr != NULL; ptr2 = ptr, ptr = ptr->next)
					{
						if (strcmp(yytext, ptr->olddef) == 0)
						{
							if (ptr2 == NULL)
								defines = ptr->next;
							else
								ptr2->next = ptr->next;
							free(ptr->newdef);
							free(ptr->olddef);
							free(ptr);
							break;
						}
					}

					BEGIN(C);
				}
	YY_BREAK
case 114:
/* rule 114 can match eol */
YY_RULE_SETUP
#line 1152 "pgc.l"
{
						mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL UNDEF command");
						yyterminate();
				}
	YY_BREAK
case 115:
/* rule 115 can match eol */
YY_RULE_SETUP
#line 1156 "pgc.l"
{ BEGIN(incl); }
	YY_BREAK
case 116:
/* rule 116 can match eol */
YY_RULE_SETUP
#line 1157 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  BEGIN(incl);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 117:
/* rule 117 can match eol */
YY_RULE_SETUP
#line 1169 "pgc.l"
{ ifcond = true; BEGIN(xcond); }
	YY_BREAK
case 118:
/* rule 118 can match eol */
YY_RULE_SETUP
#line 1170 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  ifcond = true;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 119:
/* rule 119 can match eol */
YY_RULE_SETUP
#line 1183 "pgc.l"
{ ifcond = false; BEGIN(xcond); }
	YY_BREAK
case 120:
/* rule 120 can match eol */
YY_RULE_SETUP
#line 1184 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  ifcond = false;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 121:
/* rule 121 can match eol */
YY_RULE_SETUP
#line 1197 "pgc.l"
{	/* pop stack */
						if ( preproc_tos == 0 ) {
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						}
						else if ( stacked_if_value[preproc_tos].else_branch )
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						else
							preproc_tos--;

						ifcond = true; BEGIN(xcond);
					}
	YY_BREAK
case 122:
/* rule 122 can match eol */
YY_RULE_SETUP
#line 1208 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						else if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						else
							preproc_tos--;

						ifcond = true;
						BEGIN(xcond);
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 123:
/* rule 123 can match eol */
YY_RULE_SETUP
#line 1229 "pgc.l"
{	/* only exec sql endif pops the stack, so take care of duplicated 'else' */
					if (stacked_if_value[preproc_tos].else_branch)
						mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
					else
					{
						stacked_if_value[preproc_tos].else_branch = true;
						stacked_if_value[preproc_tos].condition =
							(stacked_if_value[preproc_tos-1].condition &&
							 !stacked_if_value[preproc_tos].condition);

						if (stacked_if_value[preproc_tos].condition)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
				}
	YY_BREAK
case 124:
/* rule 124 can match eol */
YY_RULE_SETUP
#line 1245 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
						else
						{
							stacked_if_value[preproc_tos].else_branch = true;
							stacked_if_value[preproc_tos].condition =
							(stacked_if_value[preproc_tos-1].condition &&
							 !stacked_if_value[preproc_tos].condition);

							if (stacked_if_value[preproc_tos].condition)
								BEGIN(C);
							else
								BEGIN(xskip);
						}
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 125:
/* rule 125 can match eol */
YY_RULE_SETUP
#line 1270 "pgc.l"
{
					if (preproc_tos == 0)
						mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
					else
						preproc_tos--;

					if (stacked_if_value[preproc_tos].condition)
					   BEGIN(C);
					else
					   BEGIN(xskip);
				}
	YY_BREAK
case 126:
/* rule 126 can match eol */
YY_RULE_SETUP
#line 1281 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
						else
							preproc_tos--;

						if (stacked_if_value[preproc_tos].condition)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 127:
YY_RULE_SETUP
#line 1302 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case 128:
/* rule 128 can match eol */
YY_RULE_SETUP
#line 1304 "pgc.l"
{
					if (preproc_tos >= MAX_NESTED_IF-1)
						mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
					else
					{
						struct _defines *defptr;
						unsigned int i;

						/*
						 *	Skip the ";" and trailing whitespace. Note that yytext
						 *	contains at least one non-space character plus the ";"
						 */
						for (i = strlen(yytext)-2;
							 i > 0 && ecpg_isspace(yytext[i]);
							 i-- )
							;
						yytext[i+1] = '\0';

						for (defptr = defines;
							 defptr != NULL &&
							 strcmp(yytext, defptr->olddef) != 0;
							 defptr = defptr->next)
							/* skip */ ;

						preproc_tos++;
						stacked_if_value[preproc_tos].else_branch = false;
						stacked_if_value[preproc_tos].condition =
						(defptr ? ifcond : !ifcond) && stacked_if_value[preproc_tos-1].condition;
					}

					if (stacked_if_value[preproc_tos].condition)
						BEGIN(C);
					else
						BEGIN(xskip);
				}
	YY_BREAK
case 129:
/* rule 129 can match eol */
YY_RULE_SETUP
#line 1340 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL IFDEF command");
				yyterminate();
			}
	YY_BREAK
case 130:
YY_RULE_SETUP
#line 1344 "pgc.l"
{
				old = mm_strdup(yytext);
				BEGIN(def);
				startlit();
			}
	YY_BREAK
case 131:
/* rule 131 can match eol */
YY_RULE_SETUP
#line 1349 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL DEFINE command");
				yyterminate();
			}
	YY_BREAK
case 132:
/* rule 132 can match eol */
YY_RULE_SETUP
#line 1353 "pgc.l"
{
						struct _defines *ptr, *this;

						for (ptr = defines; ptr != NULL; ptr = ptr->next)
						{
							 if (strcmp(old, ptr->olddef) == 0)
							 {
								free(ptr->newdef);
								ptr->newdef = mm_strdup(literalbuf);
							 }
						}
						if (ptr == NULL)
						{
							this = (struct _defines *) mm_alloc(sizeof(struct _defines));

							/* initial definition */
							this->olddef = old;
							this->newdef = mm_strdup(literalbuf);
							this->next = defines;
							this->used = NULL;
							defines = this;
						}

						BEGIN(C);
					}
	YY_BREAK
case 133:
/* rule 133 can match eol */
YY_RULE_SETUP
#line 1378 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 134:
/* rule 134 can match eol */
YY_RULE_SETUP
#line 1379 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 135:
/* rule 135 can match eol */
YY_RULE_SETUP
#line 1380 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 136:
/* rule 136 can match eol */
YY_RULE_SETUP
#line 1381 "pgc.l"
{ parse_include(); }
	YY_BREAK
case 137:
/* rule 137 can match eol */
YY_RULE_SETUP
#line 1382 "pgc.l"
{
					mmfatal(PARSE_ERROR, "syntax error in EXEC SQL INCLUDE command");
					yyterminate();
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(xcond):
case YY_STATE_EOF(xskip):
case YY_STATE_EOF(C):
case YY_STATE_EOF(SQL):
case YY_STATE_EOF(incl):
case YY_STATE_EOF(def):
case YY_STATE_EOF(def_ident):
case YY_STATE_EOF(undef):
#line 1387 "pgc.l"
{
					if (yy_buffer == NULL)
					{
						if ( preproc_tos > 0 )
						{
							preproc_tos = 0;
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						}
						yyterminate();
					}
					else
					{
						struct _yy_buffer *yb = yy_buffer;
						int i;
						struct _defines *ptr;

						for (ptr = defines; ptr; ptr = ptr->next)
							if (ptr->used == yy_buffer)
							{
								ptr->used = NULL;
								break;
							}

						if (yyin != NULL)
							fclose(yyin);

						yy_delete_buffer( YY_CURRENT_BUFFER );
						yy_switch_to_buffer(yy_buffer->buffer);

						yylineno = yy_buffer->lineno;

						/* We have to output the filename only if we change files here */
						i = strcmp(input_filename, yy_buffer->filename);

						free(input_filename);
						input_filename = yy_buffer->filename;

						yy_buffer = yy_buffer->next;
						free(yb);

						if (i != 0)
							output_line_number();

					}
				}
	YY_BREAK
case 138:
/* rule 138 can match eol */
YY_RULE_SETUP
#line 1433 "pgc.l"
{ mmfatal(PARSE_ERROR, "internal error: unreachable state; please report this to <%s>", PACKAGE_BUGREPORT); }
	YY_BREAK
case 139:
YY_RULE_SETUP
#line 1435 "pgc.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 3682 "pgc.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 566 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 566 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 565);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 1435 "pgc.l"


/* LCOV_EXCL_STOP */

void
lex_init(void)
{
	braces_open = 0;
	parenths_open = 0;
	current_function = NULL;

	preproc_tos = 0;
	yylineno = 1;
	ifcond = true;
	stacked_if_value[preproc_tos].condition = ifcond;
	stacked_if_value[preproc_tos].else_branch = false;

	/* initialize literal buffer to a reasonable but expansible size */
	if (literalbuf == NULL)
	{
		literalalloc = 1024;
		literalbuf = (char *) mm_alloc(literalalloc);
	}
	startlit();

	BEGIN(C);
}

static void
addlit(char *ytext, int yleng)
{
	/* enlarge buffer if needed */
	if ((literallen+yleng) >= literalalloc)
	{
		do
			literalalloc *= 2;
		while ((literallen+yleng) >= literalalloc);
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	memcpy(literalbuf+literallen, ytext, yleng);
	literallen += yleng;
	literalbuf[literallen] = '\0';
}

static void
addlitchar(unsigned char ychar)
{
	/* enlarge buffer if needed */
	if ((literallen+1) >= literalalloc)
	{
		literalalloc *= 2;
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	literalbuf[literallen] = ychar;
	literallen += 1;
	literalbuf[literallen] = '\0';
}

/*
 * Process {integer}.  Note this will also do the right thing with {decimal},
 * ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval)
{
	int			val;
	char	   *endptr;

	errno = 0;
	val = strtoint(token, &endptr, 10);
	if (*endptr != '\0' || errno == ERANGE)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = mm_strdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
parse_include(void)
{
	/* got the include file name */
	struct _yy_buffer *yb;
	struct _include_path *ip;
	char inc_file[MAXPGPATH];
	unsigned int i;

	yb = mm_alloc(sizeof(struct _yy_buffer));

	yb->buffer =	YY_CURRENT_BUFFER;
	yb->lineno = yylineno;
	yb->filename = input_filename;
	yb->next = yy_buffer;

	yy_buffer = yb;

	/*
	 * skip the ";" if there is one and trailing whitespace. Note that
	 * yytext contains at least one non-space character plus the ";"
	 */
	for (i = strlen(yytext)-2;
		 i > 0 && ecpg_isspace(yytext[i]);
		 i--)
		;

	if (yytext[i] == ';')
		i--;

	yytext[i+1] = '\0';

	yyin = NULL;

	/* If file name is enclosed in '"' remove these and look only in '.' */
	/* Informix does look into all include paths though, except filename starts with '/' */
	if (yytext[0] == '"' && yytext[i] == '"' &&
		((compat != ECPG_COMPAT_INFORMIX && compat != ECPG_COMPAT_INFORMIX_SE) || yytext[1] == '/'))
	{
		yytext[i] = '\0';
		memmove(yytext, yytext+1, strlen(yytext));

		strlcpy(inc_file, yytext, sizeof(inc_file));
		yyin = fopen(inc_file, "r");
		if (!yyin)
		{
			if (strlen(inc_file) <= 2 || strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
			{
				strcat(inc_file, ".h");
				yyin = fopen(inc_file, "r");
			}
		}

	}
	else
	{
		if ((yytext[0] == '"' && yytext[i] == '"') || (yytext[0] == '<' && yytext[i] == '>'))
		{
			yytext[i] = '\0';
			memmove(yytext, yytext+1, strlen(yytext));
		}

		for (ip = include_paths; yyin == NULL && ip != NULL; ip = ip->next)
		{
			if (strlen(ip->path) + strlen(yytext) + 4 > MAXPGPATH)
			{
				fprintf(stderr, _("Error: include path \"%s/%s\" is too long on line %d, skipping\n"), ip->path, yytext, yylineno);
				continue;
			}
			snprintf (inc_file, sizeof(inc_file), "%s/%s", ip->path, yytext);
			yyin = fopen(inc_file, "r");
			if (!yyin)
			{
				if (strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
				{
					strcat(inc_file, ".h");
					yyin = fopen( inc_file, "r" );
				}
			}
			/* if the command was "include_next" we have to disregard the first hit */
			if (yyin && include_next)
			{
				fclose (yyin);
				yyin = NULL;
				include_next = false;
			}
		}
	}
	if (!yyin)
		mmfatal(NO_INCLUDE_FILE, "could not open include file \"%s\" on line %d", yytext, yylineno);

	input_filename = mm_strdup(inc_file);
	yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE ));
	yylineno = 1;
	output_line_number();

	BEGIN(C);
}

/*
 * ecpg_isspace() --- return true if flex scanner considers char whitespace
 */
static bool
ecpg_isspace(char ch)
{
	if (ch == ' ' ||
		ch == '\t' ||
		ch == '\n' ||
		ch == '\r' ||
		ch == '\f')
		return true;
	return false;
}

static bool isdefine(void)
{
	struct _defines *ptr;

	/* is it a define? */
	for (ptr = defines; ptr; ptr = ptr->next)
	{
		if (strcmp(yytext, ptr->olddef) == 0 && ptr->used == NULL)
		{
			struct _yy_buffer *yb;

			yb = mm_alloc(sizeof(struct _yy_buffer));

			yb->buffer =  YY_CURRENT_BUFFER;
			yb->lineno = yylineno;
			yb->filename = mm_strdup(input_filename);
			yb->next = yy_buffer;

			ptr->used = yy_buffer = yb;

			yy_scan_string(ptr->newdef);
			return true;
		}
	}

	return false;
}

static bool isinformixdefine(void)
{
	const char *new = NULL;

	if (strcmp(yytext, "dec_t") == 0)
		new = "decimal";
	else if (strcmp(yytext, "intrvl_t") == 0)
		new = "interval";
	else if (strcmp(yytext, "dtime_t") == 0)
		new = "timestamp";

	if (new)
	{
		struct _yy_buffer *yb;

		yb = mm_alloc(sizeof(struct _yy_buffer));

		yb->buffer =  YY_CURRENT_BUFFER;
		yb->lineno = yylineno;
		yb->filename = mm_strdup(input_filename);
		yb->next = yy_buffer;
		yy_buffer = yb;

		yy_scan_string(new);
		return true;
	}

	return false;
}

