CREATE TABLE test_data (
    id integer,
    wkt text,
    wkb_xdr text,
    wkb_ndr text
);

INSERT INTO test_data VALUES
(1, 'MULTIPOINT(1 2)', '00000000040000000100000000013FF00000000000004000000000000000', '0104000000010000000101000000000000000000F03F0000000000000040'),
(-5, 'LINESTRING(1 2,3 4)', '0000000002000000023FF0000000000000400000000000000040080000000000004010000000000000', '010200000002000000000000000000F03F000000000000004000000000000008400000000000001040'),
(-4, 'LINESTRING(1 2 3,4 5 6)', '0080000002000000023FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000', '010200008002000000000000000000F03F00000000000000400000000000000840000000000000104000000000000014400000000000001840'),
(110, 'GEOMETRYCOLLECTION(LINESTRING(1 2,3 4))', '0000000007000000010000000002000000023FF0000000000000400000000000000040080000000000004010000000000000', '010700000001000000010200000002000000000000000000F03F000000000000004000000000000008400000000000001040'),
(114, 'GEOMETRYCOLLECTION(LINESTRING(1 2,3 4),LINESTRING(5 6,7 8))', '0000000007000000020000000002000000023FF000000000000040000000000000004008000000000000401000000000000000000000020000000240140000000000004018000000000000401C0000000000004020000000000000', '010700000002000000010200000002000000000000000000F03F000000000000004000000000000008400000000000001040010200000002000000000000000000144000000000000018400000000000001C400000000000002040'),
(14, 'MULTILINESTRING((1 2,3 4),(5 6,7 8))', '0000000005000000020000000002000000023FF000000000000040000000000000004008000000000000401000000000000000000000020000000240140000000000004018000000000000401C0000000000004020000000000000', '010500000002000000010200000002000000000000000000F03F000000000000004000000000000008400000000000001040010200000002000000000000000000144000000000000018400000000000001C400000000000002040'),
(0, 'POINT(1 2)', '00000000013FF00000000000004000000000000000', '0101000000000000000000F03F0000000000000040'),
(101, 'GEOMETRYCOLLECTION(POINT(1 2))', '00000000070000000100000000013FF00000000000004000000000000000', '0107000000010000000101000000000000000000F03F0000000000000040'),
(-1, 'POINT(1 2 3)', '00800000013FF000000000000040000000000000004008000000000000', '0101000080000000000000F03F00000000000000400000000000000840'),
(118, 'GEOMETRYCOLLECTION(LINESTRING(1 2 -1,3 4 -2,5 6 -3),LINESTRING(7 8 -1,9 10 -2,11 12 -3))', '0080000007000000020080000002000000033FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000040140000000000004018000000000000C008000000000000008000000200000003401C0000000000004020000000000000BFF000000000000040220000000000004024000000000000C00000000000000040260000000000004028000000000000C008000000000000', '010700008002000000010200008003000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C00000000000001440000000000000184000000000000008C00102000080030000000000000000001C400000000000002040000000000000F0BF0000000000002240000000000000244000000000000000C00000000000002640000000000000284000000000000008C0'),
(-8, 'LINESTRING(1 2,3 4,5 6,7 8,9 10)', '0000000002000000053FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000401C000000000000402000000000000040220000000000004024000000000000', '010200000005000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400000000000001C40000000000000204000000000000022400000000000002440'),
(115, 'GEOMETRYCOLLECTION(LINESTRING(1 2,3 4,5 6),LINESTRING(7 8,9 10))', '0000000007000000020000000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000000000000200000002401C000000000000402000000000000040220000000000004024000000000000', '010700000002000000010200000003000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400102000000020000000000000000001C40000000000000204000000000000022400000000000002440'),
(117, 'GEOMETRYCOLLECTION(LINESTRING(5 6 -55,7 8 -22),LINESTRING(1 2 -1,3 4 -2))', '00800000070000000200800000020000000240140000000000004018000000000000C04B800000000000401C0000000000004020000000000000C0360000000000000080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C000000000000000', '010700008002000000010200008002000000000000000000144000000000000018400000000000804BC00000000000001C40000000000000204000000000000036C0010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0'),
(-7, 'LINESTRING(1 2,3 4,5 6,7 8)', '0000000002000000043FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000401C0000000000004020000000000000', '010200000004000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400000000000001C400000000000002040'),
(105, 'GEOMETRYCOLLECTION(POINT(1 2 -1))', '00800000070000000100800000013FF00000000000004000000000000000BFF0000000000000', '0107000080010000000101000080000000000000F03F0000000000000040000000000000F0BF'),
(112, 'GEOMETRYCOLLECTION(LINESTRING(1 2 -1,3 4 -2))', '0080000007000000010080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C000000000000000', '010700008001000000010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0'),
(-6, 'LINESTRING(1 2,3 4,5 6)', '0000000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000', '010200000003000000000000000000F03F00000000000000400000000000000840000000000000104000000000000014400000000000001840'),
(111, 'GEOMETRYCOLLECTION(LINESTRING(1 2,3 4,5 6))', '0000000007000000010000000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000', '010700000001000000010200000003000000000000000000F03F00000000000000400000000000000840000000000000104000000000000014400000000000001840'),
(18, 'MULTILINESTRING((1 2 -1,3 4 -2,5 6 -3),(7 8 -1,9 10 -2,11 12 -3))', '0080000005000000020080000002000000033FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000040140000000000004018000000000000C008000000000000008000000200000003401C0000000000004020000000000000BFF000000000000040220000000000004024000000000000C00000000000000040260000000000004028000000000000C008000000000000', '010500008002000000010200008003000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C00000000000001440000000000000184000000000000008C00102000080030000000000000000001C400000000000002040000000000000F0BF0000000000002240000000000000244000000000000000C00000000000002640000000000000284000000000000008C0'),
(127, 'GEOMETRYCOLLECTION(POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)),POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1),(2 2,2 3,3 3,3 2,2 2)))', '0000000007000000020000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A0000000003000000020000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A000000054000000000000000400000000000000040000000000000004008000000000000400800000000000040080000000000004008000000000000400000000000000040000000000000004000000000000000', '0107000000020000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F0103000000020000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F050000000000000000000040000000000000004000000000000000400000000000000840000000000000084000000000000008400000000000000840000000000000004000000000000000400000000000000040'),
(120, 'GEOMETRYCOLLECTION(POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)))', '0000000007000000010000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A', '0107000000010000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F'),
(100, 'GEOMETRYCOLLECTION(POINT(1 2),POINT(3 4))', '00000000070000000200000000013FF00000000000004000000000000000000000000140080000000000004010000000000000', '0107000000020000000101000000000000000000F03F0000000000000040010100000000000000000008400000000000001040'),
(122, 'GEOMETRYCOLLECTION(POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1),(2 2,2 3,3 3,3 2,2 2)))', '0000000007000000010000000003000000020000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A000000054000000000000000400000000000000040000000000000004008000000000000400800000000000040080000000000004008000000000000400000000000000040000000000000004000000000000000', '0107000000010000000103000000020000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F050000000000000000000040000000000000004000000000000000400000000000000840000000000000084000000000000008400000000000000840000000000000004000000000000000400000000000000040'),
(27, 'MULTIPOLYGON(((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)),((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1),(2 2,2 3,3 3,3 2,2 2)))', '0000000006000000020000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A0000000003000000020000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A000000054000000000000000400000000000000040000000000000004008000000000000400800000000000040080000000000004008000000000000400000000000000040000000000000004000000000000000', '0106000000020000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F0103000000020000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F050000000000000000000040000000000000004000000000000000400000000000000840000000000000084000000000000008400000000000000840000000000000004000000000000000400000000000000040'),
(106, 'GEOMETRYCOLLECTION(POINT(1 2 -2),POINT(3 4 -2),POINT(5 6 -3))', '00800000070000000300800000013FF00000000000004000000000000000C000000000000000008000000140080000000000004010000000000000C000000000000000008000000140140000000000004018000000000000C008000000000000', '0107000080030000000101000080000000000000F03F000000000000004000000000000000C001010000800000000000000840000000000000104000000000000000C001010000800000000000001440000000000000184000000000000008C0'),
(11, 'MULTILINESTRING((1 2,3 4,5 6))', '0000000005000000010000000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000', '010500000001000000010200000003000000000000000000F03F00000000000000400000000000000840000000000000104000000000000014400000000000001840'),
(12, 'MULTILINESTRING((1 2 -1,3 4 -2))', '0080000005000000010080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C000000000000000', '010500008001000000010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0'),
(13, 'MULTILINESTRING((1 2 -1,3 4 -2,5 6 -3))', '0080000005000000010080000002000000033FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000040140000000000004018000000000000C008000000000000', '010500008001000000010200008003000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C00000000000001440000000000000184000000000000008C0'),
(102, 'GEOMETRYCOLLECTION(POINT(1 2),POINT(3 4),POINT(5 6))', '00000000070000000300000000013FF00000000000004000000000000000000000000140080000000000004010000000000000000000000140140000000000004018000000000000', '0107000000030000000101000000000000000000F03F0000000000000040010100000000000000000008400000000000001040010100000000000000000014400000000000001840'),
(104, 'GEOMETRYCOLLECTION(POINT(1 2 -1),POINT(3 4 -2))', '00800000070000000200800000013FF00000000000004000000000000000BFF0000000000000008000000140080000000000004010000000000000C000000000000000', '0107000080020000000101000080000000000000F03F0000000000000040000000000000F0BF01010000800000000000000840000000000000104000000000000000C0'),
(17, 'MULTILINESTRING((5 6 -55,7 8 -22),(1 2 -1,3 4 -2))', '00800000050000000200800000020000000240140000000000004018000000000000C04B800000000000401C0000000000004020000000000000C0360000000000000080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C000000000000000', '010500008002000000010200008002000000000000000000144000000000000018400000000000804BC00000000000001C40000000000000204000000000000036C0010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0'),
(113, 'GEOMETRYCOLLECTION(LINESTRING(1 2 -1,3 4 -2,5 6 -3))', '0080000007000000010080000002000000033FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000040140000000000004018000000000000C008000000000000', '010700008001000000010200008003000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C00000000000001440000000000000184000000000000008C0'),
(-3, 'LINESTRING(1 2 3,4 5 6,7 8 9)', '0080000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000401C00000000000040200000000000004022000000000000', '010200008003000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400000000000001C4000000000000020400000000000002240'),
(21, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000006000000010080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0106000080010000000103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF'),
(116, 'GEOMETRYCOLLECTION(LINESTRING(1 2 -1,3 4 -2),LINESTRING(5 6 -55,7 8 -22))', '0080000007000000020080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000000800000020000000240140000000000004018000000000000C04B800000000000401C0000000000004020000000000000C036000000000000', '010700008002000000010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0010200008002000000000000000000144000000000000018400000000000804BC00000000000001C40000000000000204000000000000036C0'),
(-2, 'LINESTRING(1 2 3,4 5 6,7 8 9,10 11 12)', '0080000002000000043FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000401C00000000000040200000000000004022000000000000402400000000000040260000000000004028000000000000', '010200008004000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400000000000001C4000000000000020400000000000002240000000000000244000000000000026400000000000002840'),
(2, 'MULTIPOINT(1 2,3 4)', '00000000040000000200000000013FF00000000000004000000000000000000000000140080000000000004010000000000000', '0104000000020000000101000000000000000000F03F0000000000000040010100000000000000000008400000000000001040'),
(3, 'MULTIPOINT(1 2 3,4 5 6)', '00800000040000000200800000013FF0000000000000400000000000000040080000000000000080000001401000000000000040140000000000004018000000000000', '0104000080020000000101000080000000000000F03F000000000000004000000000000008400101000080000000000000104000000000000014400000000000001840'),
(4, 'MULTIPOINT(1 2 3,4 5 6,7 8 9)', '00800000040000000300800000013FF00000000000004000000000000000400800000000000000800000014010000000000000401400000000000040180000000000000080000001401C00000000000040200000000000004022000000000000', '0104000080030000000101000080000000000000F03F00000000000000400000000000000840010100008000000000000010400000000000001440000000000000184001010000800000000000001C4000000000000020400000000000002240'),
(5, 'MULTIPOINT(1 2,4 5,7 8)', '00000000040000000300000000013FF000000000000040000000000000000000000001401000000000000040140000000000000000000001401C0000000000004020000000000000', '0104000000030000000101000000000000000000F03F000000000000004001010000000000000000001040000000000000144001010000000000000000001C400000000000002040'),
(10, 'MULTILINESTRING((1 2,3 4))', '0000000005000000010000000002000000023FF0000000000000400000000000000040080000000000004010000000000000', '010500000001000000010200000002000000000000000000F03F000000000000004000000000000008400000000000001040'),
(121, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000007000000010080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0107000080010000000103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF'),
(123, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000007000000010080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0107000080010000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF'),
(125, 'GEOMETRYCOLLECTION(POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)),POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)))', '0000000007000000020000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A0000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A', '0107000000020000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F0103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F'),
(15, 'MULTILINESTRING((1 2,3 4,5 6),(7 8,9 10))', '0000000005000000020000000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000000000000200000002401C000000000000402000000000000040220000000000004024000000000000', '010500000002000000010200000003000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400102000000020000000000000000001C40000000000000204000000000000022400000000000002440'),
(16, 'MULTILINESTRING((1 2 -1,3 4 -2),(5 6 -55,7 8 -22))', '0080000005000000020080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000000800000020000000240140000000000004018000000000000C04B800000000000401C0000000000004020000000000000C036000000000000', '010500008002000000010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0010200008002000000000000000000144000000000000018400000000000804BC00000000000001C40000000000000204000000000000036C0'),
(20, 'MULTIPOLYGON(((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)))', '0000000006000000010000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A', '0106000000010000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F'),
(22, 'MULTIPOLYGON(((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1),(2 2,2 3,3 3,3 2,2 2)))', '0000000006000000010000000003000000020000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A000000054000000000000000400000000000000040000000000000004008000000000000400800000000000040080000000000004008000000000000400000000000000040000000000000004000000000000000', '0106000000010000000103000000020000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F050000000000000000000040000000000000004000000000000000400000000000000840000000000000084000000000000008400000000000000840000000000000004000000000000000400000000000000040'),
(23, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000006000000010080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0106000080010000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF'),
(24, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000006000000010080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0106000080010000000103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000'),
(25, 'MULTIPOLYGON(((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)),((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)))', '0000000006000000020000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A0000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A', '0106000000020000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F0103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F'),
(26, 'MULTIPOLYGON(((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000006000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0106000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF'),
(28, 'MULTIPOLYGON(((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000006000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0106000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF'),
(29, 'MULTIPOLYGON(((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000006000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0106000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000'),
(30, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A0000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F0000000000000000'),
(31, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF'),
(32, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0),(2 2 0,2 3 0,3 3 0,3 2 0,2 2 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000020000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A000000000000000000000005400000000000000040000000000000000000000000000000400000000000000040080000000000000000000000000000400800000000000040080000000000000000000000000000400800000000000040000000000000000000000000000000400000000000000040000000000000000000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080020000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F000000000000000005000000000000000000004000000000000000400000000000000000000000000000004000000000000008400000000000000000000000000000084000000000000008400000000000000000000000000000084000000000000000400000000000000000000000000000004000000000000000400000000000000000'),
(33, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF'),
(34, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000'),
(124, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000007000000010080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0107000080010000000103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000'),
(126, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000007000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0107000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF'),
(128, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000007000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0107000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF'),
(129, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000007000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0107000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000'),
(130, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A0000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F0000000000000000'),
(131, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF'),
(132, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0),(2 2 0,2 3 0,3 3 0,3 2 0,2 2 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000020000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A000000000000000000000005400000000000000040000000000000000000000000000000400000000000000040080000000000000000000000000000400800000000000040080000000000000000000000000000400800000000000040000000000000000000000000000000400000000000000040000000000000000000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080020000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F000000000000000005000000000000000000004000000000000000400000000000000000000000000000004000000000000008400000000000000000000000000000084000000000000008400000000000000000000000000000084000000000000000400000000000000000000000000000004000000000000000400000000000000000'),
(133, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF'),
(134, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000'),
(-9, 'POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1))', '0000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A', '0103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F'),
(-10, 'POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01))', '0080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF'),
(-11, 'POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1),(2 2,2 3,3 3,3 2,2 2))', '0000000003000000020000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A000000054000000000000000400000000000000040000000000000004008000000000000400800000000000040080000000000004008000000000000400000000000000040000000000000004000000000000000', '0103000000020000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F050000000000000000000040000000000000004000000000000000400000000000000840000000000000084000000000000008400000000000000840000000000000004000000000000000400000000000000040'),
(-12, 'POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01))', '0080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF'),
(-13, 'POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0))', '0080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000');

--
SELECT id,wkt FROM test_data WHERE
       ST_asEWKT(geometry(wkt)) != wkt  OR
       ST_asEWKT(geometry(wkb_xdr)) != wkt OR
       ST_asEWKT(geometry(wkb_ndr)) != wkt OR
       ST_asBinary(geometry(wkb_ndr)) != ST_asBinary(geometry(wkb_xdr)) OR
       ST_asBinary(geometry(wkt)) != ST_asBinary(geometry(wkb_xdr));

SELECT ST_extent(geometry(wkb_ndr)) from test_data;
SELECT ST_3DExtent(geometry(wkb_ndr)) from test_data WHERE ST_NDims(wkb_ndr) > 2;
SELECT ST_MemSize(ST_collect(ST_Force2d(geometry(wkb_ndr)))) from test_data;
SELECT ST_MemSize(ST_collect(ST_Force3dz(geometry(wkb_ndr)))) from test_data;
SELECT ST_MemSize(ST_collect(ST_Force4d(ST_force2d(geometry(wkb_ndr))))) from test_data;
SELECT ST_MemSize(ST_collect(ST_Force3dm(geometry(wkb_ndr)))) from test_data;
SELECT ST_MemSize(ST_collect(ST_Force2d(ST_force4d(ST_force3dm(ST_force3dz(ST_force2d(geometry(wkb_ndr)))))))) from test_data;

DROP TABLE test_data;

SELECT '#3069', ST_Summary(PostGIS_Noop('SRID=4326;POINT(1 1)'::geometry));
SELECT '#3069', ST_Summary(PostGIS_Noop('SRID=4326;LINESTRING(1 1,0 0)'::geometry));
SELECT '#3069', replace(ST_Summary(PostGIS_Noop('SRID=4326;MULTIPOINT(1 1)'::geometry)),E'\n',' ');
SELECT '#3069', replace(ST_Summary(PostGIS_Noop('SRID=4326;MULTILINESTRING((1 1,0 0))'::geometry)),E'\n',' ');
SELECT '#3069', replace(ST_Summary(PostGIS_Noop('SRID=4326;POLYGON((0 0, 0 1, 1 1 ,1 0,0 0))'::geometry)),E'\n',' ');

SELECT '#3069',  postgis_getbbox('SRID=0;POINT(1 1)'::geometry);
SELECT '#3069',  postgis_getbbox('SRID=0;LINESTRING(0 0, 1 1)'::geometry);
SELECT '#3069',  postgis_getbbox('SRID=0;MULTILINESTRING((0 0, 1 1))'::geometry);
SELECT '#3069',  postgis_getbbox('SRID=0;MULTIPOINT(1 1)'::geometry);
SELECT '#3069',  postgis_getbbox('SRID=0;MULTILINESTRING((0 0,1 1))'::geometry);

-- ST_BoundingDiagonal

SELECT 'BoundingDiagonal1', ST_AsEwkt(ST_BoundingDiagonal(postgis_addbbox(
    'SRID=4326;POINT(1e+15 1e+15)'::geometry
)));
SELECT 'BoundingDiagonal2', ST_AsEwkt(ST_BoundingDiagonal(postgis_addbbox(
    'SRID=4326;POINT(1e+15 1e+15)'::geometry
), true));
SELECT 'BoundingDiagonal3', ST_AsEwkt(ST_BoundingDiagonal(postgis_addbbox(
    'SRID=4326;POINT(1e+15 1e+15)'::geometry
), false));
SELECT 'BoundingDiagonal4', ST_AsEwkt(ST_BoundingDiagonal(
    'SRID=3857;LINESTRING(1 2 3 4, 0 1 -8 2, -1 -2 -3 9)'::geometry
));
SELECT 'BoundingDiagonal5', ST_AsEwkt(ST_BoundingDiagonal(
    'SRID=3857;LINESTRING M (5 4 0,4 4 1)'::geometry
));
SELECT 'BoundingDiagonal6', ST_AsEwkt(ST_BoundingDiagonal(
    'SRID=3857;POLYGON M EMPTY'::geometry
));

--- ST_Azimuth
SELECT 'ST_Azimuth_regular' , round(ST_Azimuth(geom1,geom2)::numeric,4)
FROM CAST('POINT(0 1)' AS geometry) AS geom1, CAST('POINT(1 0)' AS geometry) AS geom2 ;
SELECT 'ST_Azimuth_same_point' , ST_Azimuth(geom1,geom1)
FROM CAST('POINT(0 1)' AS geometry) AS geom1 ;
SELECT 'ST_Azimuth_mixed_srid' , ST_Azimuth(geom1,geom2)
FROM CAST('POINT(0 1)' AS geometry) AS geom1, ST_GeomFromText('POINT(1 0)',4326) AS geom2;
SELECT 'ST_Azimuth_not_point' , ST_Azimuth(geom1,geom2)
FROM CAST('POINT(0 1)' AS geometry) AS geom1, ST_GeomFromText('LINESTRING(1 0 ,2 0)',4326) AS geom2;
SELECT 'ST_Azimuth_null_geom' , ST_Azimuth(geom1,geom2)
FROM CAST('POINT(0 1)' AS geometry) AS geom1, ST_GeomFromText('EMPTY') AS geom2;

--- ST_Angle(points)
SELECT 'ST_Angle_4_pts', St_Angle(p1,p2,p3,p4)
	FROM ST_GeomFromtext('POINT(0 1)') AS p1, ST_GeomFromtext('POINT(0 0)') AS p2
	, ST_GeomFromtext('POINT(1 0)') AS p3, ST_GeomFromtext('POINT(2 0)') AS p4;
SELECT 'ST_Angle_4_pts', St_Angle(p1,p2,p3,p4)
	FROM ST_GeomFromtext('POINT(2 0)') AS p1, ST_GeomFromtext('POINT(1 0)') AS p2
	, ST_GeomFromtext('POINT(1 -1)') AS p3, ST_GeomFromtext('POINT(0 0)') AS p4;
SELECT 'ST_Angle_3_pts', St_Angle(p1,p2,p3)
	FROM ST_GeomFromtext('POINT(0 1)') AS p1, ST_GeomFromtext('POINT(0 0)') AS p2
	, ST_GeomFromtext('POINT(1 0)') AS p3, ST_GeomFromtext('POINT(2 0)') AS p4;
SELECT 'ST_Angle_mixed_srid', St_Angle(p1,p2,p3,p4)
	FROM ST_GeomFromtext('POINT(0 1)') AS p1, ST_GeomFromtext('POINT(0 0)') AS p2
	, ST_GeomFromtext('POINT(1 0)',4326) AS p3, ST_GeomFromtext('POINT(2 0)') AS p4;
SELECT 'ST_Angle_empty' , St_Angle(p1,p2,p3,p4)
	FROM ST_GeomFromtext('POINT EMPTY') AS p1, ST_GeomFromtext('POINT(0 0)') AS p2
	, ST_GeomFromtext('POINT(1 0)',4326) AS p3, ST_GeomFromtext('POINT(2 0)') AS p4;
--- ST_Angle(lines)
SELECT 'ST_Angle_2_lines', St_Angle(l1,l2)
	FROM ST_GeomFromtext('LINESTRING(0 1,0 0)') AS l1
	, ST_GeomFromtext('LINESTRING(1 0, 2 0)') AS l2;

--- ST_ClusterKMeans

-- check we have not less than k clusters
select
    '#3965',
    count(distinct cid),
    count(*)
from (
         with points as (
             select ST_MakePoint(x, y) geom
             from generate_series(1, 5) x,
                  generate_series(1, 5) y
         )
         select
             ST_ClusterKMeans(geom, 25)
             over () as cid,
             geom
         from points) z;

-- check that grid gets clustered to clusters of similar size
select '#3971', count(*) between 16 and 25 -- in perfect match it's 25, better kmeans init can improve
from (
         with
                 points as (
                 select ST_MakePoint(x, y) geom
                 from generate_series(1, 45) x, generate_series(1, 45) y
             )
         select
             ST_ClusterKMeans(geom, 81)
             over () as cid,
             geom
         from points
     ) z
group by cid
order by count(*)
limit 1;

-- check that null and empty is handled in the clustering
select '#4071', count(distinct a), count(distinct b), count(distinct c)  from
(select
	ST_ClusterKMeans(geom, 1) over () a,
	ST_ClusterKMeans(geom, 2) over () b,
	ST_ClusterKMeans(geom, 3) over () c
from (values (null::geometry), ('POINT(1 1)'), ('POINT EMPTY'), ('POINT(0 0)'), ('POINT(4 4)')) as g (geom)) z;

-- typmod checks
select 'typmod_point_4326', geometry_typmod_out(geometry_typmod_in('{Point,4326}'));
select 'typmod_point_0', geometry_typmod_out(geometry_typmod_in('{Point,0}'));
select 'typmod_point_-1', geometry_typmod_out(geometry_typmod_in('{Point,-1}'));
select 'typmod_pointzm_0', geometry_typmod_out(geometry_typmod_in('{PointZM,0}'));
select 'typmod_geometry_0', geometry_typmod_out(geometry_typmod_in('{Geometry,0}'));
select 'typmod_geometry_4326', geometry_typmod_out(geometry_typmod_in('{Geometry,4326}'));
select 'typmod_geography_0', geometry_typmod_out(geometry_typmod_in('{Geogrpahy,0}'));
