/**********************************************************************
 * $Id: cu_geodetic_data.h 13134 2014-12-01 08:47:21Z strk $
 *
 * PostGIS - Spatial Types for PostgreSQL
 * http://postgis.net
 * Copyright 2008 Paul Ramsey <pramsey@cleverelephant.ca>
 *
 * This is free software; you can redistribute and/or modify it under
 * the terms of the GNU General Public Licence. See the COPYING file.
 *
 **********************************************************************/

int gbox_data_length = 55;
char gbox_data[][512] =
{
	"LINESTRING(-0 40,0 -30)",
	"LINESTRING(-180 90,180 -80)",
	"LINESTRING(-0 90,0 -89)",
	"LINESTRING(0 90,80 -89)",
	"LINESTRING(0 -5,0 -5)",
	"LINESTRING(180 -35,180 45)",
	"LINESTRING(158 -85,-57 86)",
	"LINESTRING(-3.083333333333333333333333333333333 9.83333333333333333333333333333333,15.5 -5.25)",
	"LINESTRING(-35.0 52.5,50.0 60.0)",
	"LINESTRING(-122.5 56.25,-123.5 69.166666)",
	"LINESTRING(-121.75 42.55,-122.35 43.25)",
	"LINESTRING(-3.083333333333333333333333333333333 9.83333333333333333333333333333333,15.5 -5.25)",
	"LINESTRING(86.85 9.85,105.5 -5.25)",
	"LINESTRING(-120.0 62.55,-120.0 62.55)",
	"LINESTRING(-135.0 40.0,45.0 -39.0)",
	"LINESTRING(-120.0 62.55,60.0 73.25)",
	"LINESTRING(-120.0 -62.55,60.0 -73.25)",
	"LINESTRING(-120.0 20.0,-120.5 20.0)",
	"LINESTRING(-120.0 45.0,-120.5 45.0)",
	"LINESTRING(-120.0 75.0,-120.5 75.0)",
	"LINESTRING(-120.0 -20.0,-120.5 -20.0)",
	"LINESTRING(-120.0 -45.0,-120.5 -45.0)",
	"LINESTRING(-120.0 -75.0,-120.5 -75.0)",
	"LINESTRING(0.0 60.0,0.0 7.0)",
	"LINESTRING(0.0 -60.0,0.0 -70.0)",
	"LINESTRING(180.0 60.0,180.0 70.0)",
	"LINESTRING(4.0 45.0,-4.0 45.0)",
	"LINESTRING(-176.0 45.0,176.0 45.0)",
	"LINESTRING(176.0 45.0,-176.0 45.0)",
	"LINESTRING(-4.0 45.0,4.0 45.0)",
	"LINESTRING(-45.0 60.0,135.0 72.0)",
	"LINESTRING(-45.0 -60.0,135.0 -72.0)",
	"LINESTRING(-15.0 3.5,15.0 -3.5)",
	"LINESTRING(75.0 3.5,105.0 -3.5)",
	"LINESTRING(-75.0 3.5,-105.0 -3.5)",
	"LINESTRING(-153.11560 24.70504,-9.15580 24.18317)",
	"LINESTRING(-178.0 45.0,165.0 45.0)",
	"LINESTRING(10.0 45.0,110.0 45.0)",
	"LINESTRING(10.0 -45.0,110.0 -45.0)",
	"LINESTRING(-10.0 45.0,-110.0 45.0)",
	"LINESTRING(160.0 25.0,-160.0 25.0)",
	"LINESTRING(170.0 35.0,-160.0 35.0)",
	"LINESTRING(-10.0 35.0,10.0 -35.0)",
	"LINESTRING(-80.0 25.0,-60.0 -25.0)",
	"LINESTRING(-80.0 25.0,-60.0 -45.0)",
	"LINESTRING(-120.0 70.0,60.0 70.0)",
	"LINESTRING(-120.0 -70.0,60.0 -70.0)",
	"LINESTRING(-112.0 45.0,-112.00166666666666666666666666667 45.0)",
	"LINESTRING(-120.0 -5.0,60.0 80.0)",
	"LINESTRING(165.0 10.0,-172.0 -5.0)",
	"LINESTRING(97.87714324162704 46.6879465040995,155.49353589912155 -68.93911854796522)",
	"LINESTRING(-77.90029319006709 -20.61989357708765,-29.776541043747443 88.24497900223159)",
	"LINESTRING(12.21419896647646 -2.2758177391540926,149.7713684095024 13.210117902931728)",
	"LINESTRING(-49.891199414628915 66.72545480471234,-39.418865490450656 -89.97504625275525)",
	"POLYGON((-40.0 52.0, 102.0 -6.0, -67.0 -29.0, -40.0 52.0))"
};


/* Iowa Polygon for use in test case */
char *iowa_data = "POLYGON((-94.015492 40.573914,-94.016088 40.5739,-94.016968 40.57388,-94.018058 40.573856,-94.02663 40.57371,-94.034211 40.573585,-94.038853 40.573525,-94.043491 40.573466,-94.046656 40.573426,-94.060375 40.573209,-94.069402 40.573067,-94.07214 40.573026,-94.079332 40.573147,-94.080122 40.57316,-94.080249 40.573147,-94.080315 40.57314,-94.080401 40.573143,-94.080409 40.573145,-94.080481 40.57314,-94.081532 40.57306,-94.081625 40.573059,-94.081866 40.573056,-94.083211 40.573037,-94.083542 40.573033,-94.083802 40.57303,-94.089019 40.572976,-94.089168 40.572956,-94.090421 40.572936,-94.090962 40.572941,-94.091084 40.572951,-94.091111 40.572956,-94.091169 40.572968,-94.095698 40.572951,-94.095709 40.572951,-94.10931 40.572902,-94.110406 40.572901,-94.118548 40.572903,-94.119918 40.572904,-94.119946 40.572904,-94.120008 40.572903,-94.120097 40.572901,-94.125259 40.57279,-94.128286 40.572768,-94.128303 40.572768,-94.130131 40.572754,-94.137859 40.572698,-94.146244 40.572638,-94.155089 40.572574,-94.163567 40.572508,-94.167509 40.572477,-94.167902 40.572474,-94.175618 40.572406,-94.199871 40.572168,-94.20377 40.572137,-94.213262 40.572061,-94.23224 40.571901,-94.234023 40.57189,-94.237434 40.571873,-94.24315 40.571845,-94.248117 40.571818,-94.248902 40.571814,-94.249265 40.571807,-94.24927 40.571807,-94.250172 40.571789,-94.250708 40.571779,-94.250798 40.571777,-94.25509 40.571693,-94.259163 40.571671,-94.263235 40.571642,-94.266531 40.57162,-94.269827 40.571597,-94.269901 40.571597,-94.270456 40.571531,-94.282994 40.571469,-94.283158 40.571476,-94.287344 40.571656,-94.28745 40.571661,-94.287529 40.571661,-94.287641 40.57166,-94.28809 40.571659,-94.288522 40.571657,-94.288608 40.571657,-94.288944 40.571634,-94.289214 40.571653,-94.289321 40.57166,-94.290732 40.571676,-94.29417 40.571656,-94.294288 40.571632,-94.294671 40.571428,-94.294813 40.571428,-94.294921 40.571428,-94.295172 40.571428,-94.304389 40.571421,-94.304554 40.571422,-94.305829 40.57156,-94.306066 40.571575,-94.306071 40.571575,-94.306569 40.571602,-94.307489 40.571594,-94.30811 40.571617,-94.30853 40.571648,-94.310423 40.57163,-94.311602 40.571647,-94.312491 40.571632,-94.313067 40.571601,-94.313952 40.571595,-94.314865 40.571608,-94.316439 40.571592,-94.31707 40.571589,-94.317923 40.571586,-94.319277 40.57157,-94.319883 40.571575,-94.320623 40.571565,-94.322007 40.571541,-94.324711 40.571542,-94.324765 40.571542,-94.325494 40.57154,-94.326363 40.571559,-94.327626 40.571552,-94.32847 40.571555,-94.334317 40.571548,-94.334461 40.571549,-94.335677 40.571554,-94.33598 40.571555,-94.33652 40.571538,-94.336763 40.57153,-94.33691 40.571528,-94.34602 40.571412,-94.346197 40.571411,-94.353988 40.571377,-94.355216 40.571373,-94.35739 40.571371,-94.358082 40.571371,-94.358236 40.571371,-94.358391 40.571371,-94.360623 40.571356,-94.372032 40.571252,-94.374625 40.57123,-94.374621 40.571316,-94.374651 40.571353,-94.374695 40.571379,-94.374793 40.571391,-94.375009 40.571396,-94.375868 40.571383,-94.376699 40.57138,-94.376782 40.571385,-94.377053 40.571368,-94.384005 40.571279,-94.38401 40.571279,-94.387546 40.571399,-94.389203 40.571453,-94.389206 40.571453,-94.38944 40.571425,-94.389871 40.571402,-94.391457 40.571364,-94.391917 40.571336,-94.392408 40.571326,-94.393203 40.571343,-94.393905 40.571339,-94.394146 40.571341,-94.395375 40.571353,-94.395829 40.571346,-94.396745 40.571331,-94.398112 40.571309,-94.39924 40.571309,-94.399755 40.571316,-94.400829 40.571312,-94.40179 40.57128,-94.402263 40.571295,-94.402582 40.571323,-94.402817 40.571334,-94.403314 40.571339,-94.403388 40.571318,-94.403432 40.571295,-94.403481 40.571312,-94.403549 40.57132,-94.403993 40.571309,-94.405541 40.571294,-94.405543 40.571294,-94.405815 40.571291,-94.40613 40.571286,-94.407294 40.571292,-94.40799 40.57129,-94.409646 40.571286,-94.409938 40.571282,-94.409963 40.571282,-94.412328 40.57125,-94.413798 40.571255,-94.414069 40.571269,-94.417054 40.571279,-94.418513 40.571298,-94.419029 40.571289,-94.419398 40.571273,-94.420664 40.571275,-94.420962 40.571285,-94.421524 40.571304,-94.421591 40.571305,-94.422342 40.571317,-94.423261 40.571306,-94.424308 40.571276,-94.425231 40.571264,-94.426098 40.571265,-94.426758 40.571288,-94.427368 40.571278,-94.427956 40.571256,-94.428728 40.571253,-94.429668 40.571236,-94.432654 40.571029,-94.435031 40.571018,-94.445015 40.570976,-94.456895 40.570934,-94.456954 40.570933,-94.457166 40.570931,-94.457441 40.570928,-94.457486 40.570928,-94.457866 40.570924,-94.458068 40.570938,-94.46047 40.571101,-94.460662 40.571098,-94.462174 40.571078,-94.466122 40.571064,-94.469396 40.571053,-94.469781 40.571049,-94.470406 40.571042,-94.470445 40.571045,-94.470541 40.571022,-94.471213 40.570825,-94.472549 40.570814,-94.473295 40.570808,-94.473459 40.570807,-94.474848 40.570795,-94.482828 40.570729,-94.482994 40.570728,-94.489109 40.570706,-94.489122 40.570857,-94.489131 40.57097,-94.489216 40.570989,-94.48932 40.57099,-94.489634 40.570982,-94.489869 40.570984,-94.490152 40.570969,-94.490223 40.570975,-94.490435 40.571005,-94.490746 40.570994,-94.490997 40.570986,-94.492014 40.570978,-94.49528 40.570977,-94.496069 40.570966,-94.49783 40.570957,-94.501191 40.570969,-94.50196 40.570958,-94.504516 40.570953,-94.504942 40.570948,-94.505838 40.570951,-94.509322 40.570931,-94.50943 40.57093,-94.510163 40.570926,-94.513507 40.570906,-94.51472 40.570895,-94.517605 40.570881,-94.517883 40.570876,-94.518352 40.570888,-94.519045 40.570893,-94.523188 40.570879,-94.524904 40.570868,-94.525489 40.570861,-94.525527 40.570866,-94.525761 40.570866,-94.525862 40.570866,-94.528929 40.57086,-94.52905 40.57086,-94.529166 40.57086,-94.530773 40.570856,-94.532379 40.570852,-94.532834 40.570851,-94.533289 40.57085,-94.533463 40.57085,-94.533925 40.570843,-94.536494 40.570818,-94.536699 40.570819,-94.537194 40.570822,-94.537486 40.57083,-94.537848 40.570836,-94.538315 40.570844,-94.538405 40.570844,-94.539193 40.570845,-94.53965 40.570846,-94.540087 40.570859,-94.540272 40.570854,-94.540766 40.570839,-94.541014 40.570828,-94.541648 40.570825,-94.541828 40.570819,-94.542154 40.570809,-94.544189 40.570816,-94.546014 40.570815,-94.547405 40.57082,-94.552281 40.57084,-94.566853 40.570881,-94.577568 40.570917,-94.577727 40.570918,-94.579041 40.570922,-94.585766 40.57094,-94.586048 40.570941,-94.594196 40.57096,-94.594293 40.571007,-94.594391 40.57103,-94.594951 40.571038,-94.596435 40.57106,-94.603368 40.571089,-94.604207 40.571096,-94.604633 40.571116,-94.604701 40.571113,-94.60497 40.571106,-94.606379 40.571133,-94.606615 40.571138,-94.607238 40.571145,-94.607836 40.57116,-94.608262 40.571152,-94.608944 40.571155,-94.609674 40.571153,-94.610334 40.571156,-94.610694 40.571164,-94.611289 40.571191,-94.61294 40.571187,-94.61377 40.571198,-94.61451 40.5712,-94.615343 40.571213,-94.616156 40.57122,-94.617231 40.571217,-94.61852 40.571224,-94.622442 40.571278,-94.622849 40.57128,-94.622963 40.571289,-94.62771 40.571317,-94.63203 40.571367,-94.63216 40.57137,-94.632954 40.571376,-94.635112 40.571385,-94.637042 40.571415,-94.638869 40.571432,-94.639967 40.571434,-94.640897 40.571429,-94.641472 40.571426,-94.642601 40.571437,-94.642899 40.57144,-94.643706 40.571468,-94.644536 40.571478,-94.645303 40.571476,-94.647342 40.571495,-94.649735 40.571535,-94.65097 40.571545,-94.651276 40.571547,-94.654257 40.571567,-94.654275 40.571568,-94.655334 40.571577,-94.657773 40.571616,-94.659154 40.57163,-94.659156 40.571631,-94.659526 40.571635,-94.65996 40.571629,-94.660619 40.57165,-94.661678 40.571652,-94.662644 40.571643,-94.66463 40.571658,-94.665838 40.571672,-94.667316 40.571711,-94.668784 40.571714,-94.668787 40.571715,-94.669073 40.571716,-94.670127 40.57174,-94.671078 40.571762,-94.671711 40.571769,-94.674848 40.571803,-94.677096 40.571849,-94.679507 40.57188,-94.682589 40.57193,-94.682595 40.57193,-94.682758 40.571933,-94.683078 40.571933,-94.683601 40.571934,-94.686827 40.571965,-94.687087 40.571968,-94.687292 40.57197,-94.688308 40.571995,-94.688331 40.571996,-94.688353 40.571996,-94.688398 40.571998,-94.688759 40.572006,-94.690936 40.572015,-94.692535 40.572046,-94.697806 40.572105,-94.699914 40.572132,-94.701815 40.572166,-94.703362 40.572189,-94.705568 40.57221,-94.706043 40.572218,-94.708066 40.57225,-94.708314 40.572254,-94.70927 40.57227,-94.710707 40.57227,-94.712971 40.572315,-94.71416 40.572318,-94.714512 40.572325,-94.71632 40.572363,-94.716323 40.572363,-94.716535 40.572343,-94.717318 40.572365,-94.717624 40.572366,-94.717629 40.572367,-94.717859 40.572367,-94.717863 40.572368,-94.719147 40.572375,-94.719977 40.572392,-94.720912 40.572399,-94.72212 40.572419,-94.723173 40.572431,-94.72432 40.572456,-94.725211 40.572476,-94.72751 40.572495,-94.728787 40.572514,-94.729918 40.572526,-94.731693 40.572537,-94.733256 40.572564,-94.733616 40.57257,-94.734522 40.572594,-94.736227 40.572618,-94.736881 40.572612,-94.736882 40.572612,-94.738155 40.572635,-94.739925 40.57265,-94.740662 40.572668,-94.742055 40.572685,-94.742677 40.572683,-94.743299 40.572691,-94.74424 40.57271,-94.744818 40.572717,-94.745519 40.572726,-94.747527 40.572752,-94.74844 40.572771,-94.748931 40.572772,-94.749568 40.572782,-94.750042 40.572795,-94.750371 40.572807,-94.751263 40.57284,-94.751841 40.572844,-94.75273 40.572858,-94.752732 40.572859,-94.753375 40.57287,-94.753746 40.572881,-94.754503 40.572861,-94.754644 40.572822,-94.754694 40.572792,-94.754738 40.572793,-94.756165 40.572827,-94.757436 40.572848,-94.75825 40.572862,-94.759063 40.57287,-94.760815 40.572897,-94.762927 40.57294,-94.765223 40.572992,-94.767007 40.57304,-94.767014 40.573039,-94.767014 40.573038,-94.767014 40.573037,-94.767014 40.573036,-94.767014 40.573035,-94.767014 40.573034,-94.767014 40.573033,-94.767014 40.573032,-94.767216 40.573032,-94.768193 40.573071,-94.768627 40.573075,-94.768628 40.573076,-94.769149 40.573082,-94.769487 40.57308,-94.769822 40.573078,-94.769826 40.573077,-94.769966 40.573077,-94.771211 40.573096,-94.77229 40.573096,-94.773895 40.573105,-94.774935 40.573115,-94.78122 40.573174,-94.78203 40.573181,-94.78446 40.573204,-94.78527 40.573212,-94.787684 40.573234,-94.794928 40.573302,-94.797343 40.573325,-94.797358 40.573325,-94.797403 40.573325,-94.797419 40.573326,-94.797423 40.573326,-94.797438 40.573326,-94.797443 40.573326,-94.797461 40.573326,-94.797515 40.573326,-94.797533 40.573327,-94.797631 40.573328,-94.797928 40.573333,-94.798027 40.573335,-94.79957 40.573358,-94.799887 40.573363,-94.801475 40.573387,-94.801484 40.573387,-94.806417 40.573488,-94.811008 40.573581,-94.811085 40.573583,-94.81112 40.573607,-94.811251 40.573629,-94.812439 40.573636,-94.814992 40.573679,-94.815863 40.573683,-94.815993 40.573684,-94.816003 40.573684,-94.818721 40.573724,-94.819756 40.573729,-94.81995 40.573756,-94.821813 40.573768,-94.822887 40.573785,-94.823381 40.573792,-94.823382 40.573792,-94.823453 40.573793,-94.824283 40.573804,-94.826773 40.573837,-94.827604 40.573849,-94.829913 40.57388,-94.836841 40.573973,-94.839151 40.574004,-94.839222 40.574001,-94.839437 40.573995,-94.83951 40.573994,-94.841214 40.574023,-94.846329 40.57411,-94.848034 40.57414,-94.848045 40.57414,-94.848078 40.57414,-94.84809 40.574141,-94.848099 40.574141,-94.848126 40.574141,-94.848135 40.574142,-94.853273 40.57422,-94.858557 40.5743,-94.858567 40.574301,-94.875248 40.574519,-94.878201 40.574563,-94.88578 40.574674,-94.886885 40.574689,-94.887084 40.574694,-94.888998 40.574702,-94.894773 40.574728,-94.896595 40.574737,-94.896699 40.574737,-94.896773 40.574737,-94.896774 40.57474,-94.896819 40.574761,-94.89971 40.5748,-94.90055 40.574815,-94.900572 40.574816,-94.900885 40.574822,-94.901101 40.574859,-94.901107 40.574863,-94.914781 40.575066,-94.914896 40.575068,-94.921114 40.57516,-94.921225 40.575161,-94.933987 40.575352,-94.936634 40.575392,-94.936911 40.575396,-94.948199 40.575567,-94.953271 40.575641,-94.95392 40.575651,-94.955058 40.575668,-94.955134 40.575669,-94.966279 40.575836,-94.966491 40.575839,-94.971223 40.575688,-94.972045 40.575687,-94.991333 40.575692,-94.99166 40.575692,-95.000265 40.575936,-95.000555 40.575939,-95.010169 40.576039,-95.021797 40.57618,-95.021836 40.576181,-95.022769 40.576189,-95.023063 40.576192,-95.030676 40.576263,-95.036265 40.576354,-95.036362 40.576355,-95.038232 40.576341,-95.039152 40.576348,-95.039613 40.576355,-95.040027 40.576362,-95.040328 40.576368,-95.048786 40.57652,-95.048797 40.57652,-95.059337 40.57671,-95.062875 40.576772,-95.062997 40.576774,-95.06872 40.576878,-95.073022 40.576916,-95.073404 40.576919,-95.076369 40.576872,-95.077591 40.576907,-95.077992 40.576889,-95.078377 40.576897,-95.079666 40.576912,-95.084503 40.577032,-95.084525 40.577033,-95.087726 40.577118,-95.097266 40.577161,-95.107098 40.577269,-95.107207 40.577252,-95.107421 40.57724,-95.107973 40.577251,-95.108608 40.577244,-95.109632 40.577244,-95.109949 40.577244,-95.11012 40.577254,-95.110243 40.577281,-95.11041 40.577337,-95.110468 40.577363,-95.112109 40.577318,-95.112135 40.577313,-95.112224 40.577308,-95.112549 40.577306,-95.11398 40.577339,-95.115481 40.577341,-95.116419 40.577361,-95.1207 40.577427,-95.120705 40.577425,-95.120705 40.577424,-95.120825 40.577426,-95.120898 40.577415,-95.120986 40.577417,-95.122047 40.577423,-95.124405 40.577436,-95.125295 40.577443,-95.131592 40.577503,-95.1316 40.577503,-95.135489 40.577561,-95.144886 40.577704,-95.145089 40.577707,-95.145115 40.577707,-95.15441 40.577861,-95.157467 40.577908,-95.157712 40.577912,-95.164008 40.578016,-95.166331 40.578057,-95.167655 40.578066,-95.17062 40.578128,-95.174887 40.578174,-95.176189 40.578175,-95.179176 40.578236,-95.180197 40.57823,-95.183136 40.578265,-95.183459 40.578269,-95.184035 40.578267,-95.18501 40.578265,-95.187398 40.578305,-95.188453 40.57831,-95.188976 40.57833,-95.189023 40.578331,-95.189116 40.578334,-95.189843 40.578336,-95.190467 40.578345,-95.191484 40.578342,-95.193247 40.578374,-95.194188 40.578381,-95.194695 40.578391,-95.195415 40.578404,-95.198186 40.578434,-95.19882 40.578446,-95.199422 40.578451,-95.199854 40.578442,-95.200396 40.57844,-95.200955 40.578467,-95.201447 40.57847,-95.202265 40.578488,-95.203948 40.578517,-95.203983 40.578518,-95.205344 40.578533,-95.206587 40.578556,-95.207125 40.578558,-95.208043 40.578561,-95.209379 40.578594,-95.210074 40.578593,-95.211407 40.578617,-95.21154 40.578619,-95.21159 40.578624,-95.211754 40.57864,-95.211831 40.57866,-95.213318 40.578689,-95.216016 40.578734,-95.217363 40.578758,-95.218692 40.578779,-95.220047 40.578802,-95.221335 40.578824,-95.222796 40.579079,-95.224561 40.57888,-95.224733 40.578883,-95.225308 40.578894,-95.230674 40.578964,-95.232787 40.57899,-95.23279 40.57899,-95.233055 40.578995,-95.249191 40.579206,-95.250258 40.579189,-95.259008 40.579149,-95.25901 40.57915,-95.276644 40.579316,-95.278096 40.579322,-95.278116 40.579322,-95.297183 40.57951,-95.302554 40.57956,-95.308312 40.579614,-95.316264 40.57969,-95.316288 40.57969,-95.335483 40.580018,-95.335485 40.580018,-95.336474 40.580019,-95.337369 40.58003,-95.338082 40.580046,-95.339985 40.58006,-95.340264 40.580064,-95.340607 40.580067,-95.340844 40.580071,-95.341006 40.580073,-95.341176 40.580075,-95.342572 40.580092,-95.343737 40.580106,-95.346438 40.580138,-95.347476 40.580153,-95.349234 40.580171,-95.350431 40.580186,-95.353323 40.580234,-95.354508 40.580245,-95.357022 40.580254,-95.360839 40.580175,-95.364446 40.580263,-95.364651 40.580268,-95.368262 40.580356,-95.370491 40.580414,-95.373923 40.580503,-95.373951 40.580503,-95.375311 40.580626,-95.389268 40.580759,-95.392922 40.580793,-95.392926 40.580793,-95.411932 40.580979,-95.411985 40.58098,-95.412011 40.58098,-95.413824 40.580998,-95.415406 40.581014,-95.429239 40.581148,-95.431075 40.581167,-95.431095 40.581167,-95.44058 40.581259,-95.449753 40.581349,-95.45019 40.581353,-95.450206 40.581353,-95.460657 40.581455,-95.460812 40.581457,-95.469213 40.581548,-95.469255 40.581548,-95.469634 40.581548,-95.470332 40.581558,-95.471381 40.581579,-95.472055 40.581586,-95.473033 40.581583,-95.474974 40.581625,-95.475882 40.581639,-95.476481 40.58167,-95.47695 40.581667,-95.477582 40.581679,-95.480115 40.581665,-95.481354 40.581682,-95.483869 40.581697,-95.483914 40.581698,-95.484021 40.581702,-95.484298 40.581708,-95.485319 40.581724,-95.486088 40.581731,-95.486539 40.581722,-95.488144 40.581733,-95.488196 40.581733,-95.488514 40.581735,-95.490631 40.581777,-95.491616 40.581776,-95.492009 40.581781,-95.493391 40.581803,-95.494819 40.581833,-95.496945 40.581857,-95.498021 40.581881,-95.499155 40.581899,-95.499169 40.5819,-95.500967 40.581927,-95.501912 40.581928,-95.503033 40.581947,-95.503859 40.581952,-95.507142 40.581993,-95.507477 40.582004,-95.509146 40.582035,-95.509764 40.582051,-95.511071 40.582073,-95.512743 40.582083,-95.514244 40.5821,-95.51487 40.582101,-95.517384 40.582146,-95.519145 40.582165,-95.520514 40.582189,-95.521393 40.582198,-95.522252 40.582215,-95.523654 40.582224,-95.523906 40.582233,-95.525098 40.582243,-95.525201 40.582244,-95.525703 40.582232,-95.525873 40.582235,-95.525873 40.582234,-95.526498 40.582234,-95.52653 40.582235,-95.527504 40.582257,-95.528431 40.58227,-95.528858 40.582271,-95.530009 40.582301,-95.530346 40.582305,-95.531491 40.582338,-95.532626 40.582356,-95.533024 40.582358,-95.533115 40.582358,-95.533437 40.582356,-95.534335 40.582371,-95.53528 40.582377,-95.536445 40.582398,-95.538891 40.582449,-95.539424 40.582455,-95.540881 40.582441,-95.541593 40.58245,-95.542548 40.582453,-95.543436 40.582468,-95.54449 40.582469,-95.544932 40.582487,-95.545306 40.5825,-95.545306 40.582517,-95.545737 40.582529,-95.546468 40.58253,-95.547057 40.582543,-95.548209 40.582546,-95.548258 40.582547,-95.548306 40.582547,-95.548915 40.582565,-95.549636 40.582562,-95.550197 40.582573,-95.550914 40.582582,-95.55293 40.582635,-95.554391 40.582649,-95.554826 40.582656,-95.554875 40.582657,-95.556719 40.582677,-95.557384 40.582695,-95.558314 40.582699,-95.559952 40.582724,-95.562275 40.582759,-95.563865 40.582789,-95.565264 40.582814,-95.565364 40.582816,-95.566571 40.582841,-95.570387 40.582889,-95.571762 40.582919,-95.57208 40.582919,-95.572717 40.582939,-95.573954 40.582946,-95.573967 40.582946,-95.58496 40.583113,-95.585048 40.583114,-95.591526 40.583203,-95.593194 40.583228,-95.593195 40.583228,-95.59325 40.583228,-95.593317 40.583231,-95.601397 40.58335,-95.601441 40.583349,-95.602355 40.583365,-95.606904 40.583433,-95.607046 40.583435,-95.610881 40.583491,-95.610928 40.583492,-95.625269 40.583792,-95.630619 40.583901,-95.631692 40.583954,-95.631732 40.583955,-95.632106 40.583974,-95.632177 40.583977,-95.637722 40.584123,-95.637817 40.584127,-95.638063 40.584133,-95.638208 40.584137,-95.638459 40.584142,-95.641662 40.584229,-95.641695 40.584229,-95.647973 40.584398,-95.648534 40.584396,-95.652198 40.584389,-95.652303 40.584389,-95.652775 40.584388,-95.656646 40.584381,-95.657169 40.58438,-95.658705 40.584378,-95.658764 40.584378,-95.658797 40.584377,-95.673127 40.58435,-95.673257 40.58435,-95.685421 40.584327,-95.68631 40.584328,-95.687253 40.58437,-95.687374 40.584375,-95.687432 40.584378,-95.68748 40.584312,-95.687573 40.584295,-95.687694 40.584273,-95.69046 40.584354,-95.694246 40.584425,-95.701831 40.584537,-95.703792 40.584556,-95.705476 40.584575,-95.709173 40.584627,-95.712851 40.584646,-95.716233 40.584686,-95.716291 40.584686,-95.717391 40.584715,-95.720576 40.584753,-95.725782 40.584835,-95.731026 40.584893,-95.734317 40.584919,-95.735283 40.584911,-95.735429 40.584905,-95.735514 40.5849,-95.735606 40.584896,-95.735828 40.584912,-95.737565 40.584927,-95.742848 40.584997,-95.743969 40.585022,-95.744892 40.585029,-95.744937 40.585029,-95.745452 40.585013,-95.745543 40.585001,-95.745769 40.584972,-95.746 40.584959,-95.746165 40.584963,-95.746384 40.585012,-95.746647 40.585039,-95.747247 40.58505,-95.748016 40.585057,-95.749457 40.585014,-95.749776 40.585014,-95.750079 40.585066,-95.750481 40.585073,-95.751872 40.585076,-95.752307 40.585092,-95.752826 40.585079,-95.754648 40.585088,-95.763855 40.585207,-95.764549 40.585208,-95.765645 40.585208,-95.76463 40.585883,-95.758895 40.588973,-95.75524 40.591469,-95.753148 40.59284,-95.751195 40.595253,-95.750274 40.596317,-95.750053 40.597052,-95.749344 40.598803,-95.748858 40.599965,-95.748572 40.601265,-95.748626 40.603355,-95.749028 40.605333,-95.749685 40.606842,-95.750274 40.6076,-95.751271 40.609057,-95.752793 40.6102,-95.753545 40.610764,-95.75534 40.612056,-95.755583 40.612231,-95.758045 40.613759,-95.761683 40.615353,-95.764412 40.61709,-95.766823 40.61878,-95.768926 40.621264,-95.769759 40.622884,-95.770083 40.624425,-95.769671 40.625001,-95.769783 40.625463,-95.769904 40.626044,-95.770082 40.627504,-95.770189 40.628512,-95.770236 40.629117,-95.770293 40.629811,-95.770339 40.631486,-95.770442 40.635285,-95.770559 40.63635,-95.770834 40.63756,-95.771069 40.638456,-95.771296 40.639151,-95.771325 40.639393,-95.77147 40.639788,-95.772832 40.642496,-95.774143 40.644472,-95.774268 40.64466,-95.774598 40.645157,-95.776251 40.647463,-95.778276 40.64961,-95.77975 40.651131,-95.780239 40.651635,-95.781909 40.653272,-95.783822 40.654974,-95.785957 40.656734,-95.786568 40.657253,-95.787474 40.657919,-95.789485 40.659388,-95.793061 40.661227,-95.795489 40.662384,-95.797729 40.663209,-95.798669 40.663536,-95.801472 40.664283,-95.804307 40.664886,-95.805313 40.66502,-95.805641 40.665061,-95.808724 40.66527,-95.811151 40.665418,-95.812762 40.665507,-95.81415 40.66557,-95.815707 40.665779,-95.816491 40.665879,-95.817338 40.66598,-95.818354 40.666106,-95.820047 40.666468,-95.821412 40.666838,-95.822226 40.667083,-95.822913 40.66724,-95.824393 40.667784,-95.824891 40.667969,-95.826199 40.668498,-95.828372 40.669453,-95.82997 40.670224,-95.83074 40.670571,-95.830834 40.670613,-95.830845 40.670618,-95.832397 40.671309,-95.834419 40.672444,-95.836056 40.67343,-95.836365 40.673614,-95.837137 40.674067,-95.837399 40.674205,-95.837788 40.674413,-95.839395 40.675272,-95.840966 40.676295,-95.842316 40.677171,-95.842801 40.677496,-95.843841 40.678589,-95.844481 40.679382,-95.844827 40.679867,-95.844986 40.68012,-95.845172 40.680417,-95.845443 40.681046,-95.845765 40.681806,-95.846034 40.682605,-95.846239 40.68346,-95.846465 40.684324,-95.846712 40.685171,-95.846858 40.686206,-95.846883 40.686381,-95.846949 40.687252,-95.847015 40.688244,-95.84705 40.689211,-95.847116 40.690179,-95.847241 40.691086,-95.847266 40.69126,-95.847428 40.692163,-95.847581 40.692954,-95.847756 40.693583,-95.847931 40.694197,-95.84868 40.695973,-95.849166 40.696893,-95.849828 40.698147,-95.850582 40.699383,-95.851336 40.700523,-95.852615 40.702262,-95.854456 40.704164,-95.856362 40.705769,-95.857901 40.70713,-95.857984 40.707182,-95.859378 40.708055,-95.859875 40.708275,-95.860773 40.708738,-95.861798 40.709242,-95.863034 40.709715,-95.865954 40.710832,-95.868196 40.71164,-95.86954 40.712137,-95.870481 40.71248,-95.871836 40.712832,-95.872937 40.713127,-95.87528 40.71412,-95.877015 40.714287,-95.880993 40.716428,-95.883178 40.717579,-95.885349 40.721093,-95.886573 40.724637,-95.886592 40.724691,-95.887154 40.726317,-95.888907 40.731855,-95.888842 40.733226,-95.888697 40.736292,-95.88669 40.742101,-95.883643 40.747831,-95.881921 40.750001,-95.881529 40.750611,-95.879027 40.753081,-95.876896 40.754913,-95.875281 40.756011,-95.874492 40.756714,-95.873335 40.757616,-95.872281 40.758349,-95.871173 40.758896,-95.869982 40.759645,-95.868618 40.760177,-95.867224 40.76079,-95.865765 40.761299,-95.864349 40.76188,-95.862868 40.76234,-95.861695 40.762871,-95.860202 40.763291,-95.858426 40.76389,-95.856668 40.764319,-95.855051 40.764893,-95.852776 40.765631,-95.851572 40.766179,-95.850144 40.766663,-95.849005 40.767331,-95.847801 40.767943,-95.84662 40.768619,-95.844964 40.769693,-95.84372 40.770467,-95.842824 40.771093,-95.84154 40.772158,-95.840173 40.773392,-95.838879 40.774545,-95.837923 40.775511,-95.837289 40.776111,-95.836903 40.776477,-95.836162 40.777709,-95.835232 40.779151,-95.835178 40.779313,-95.834881 40.78021,-95.834462 40.781811,-95.834156 40.783016,-95.83412 40.783783,-95.834104 40.78413,-95.834065 40.785592,-95.834214 40.786665,-95.834523 40.787778,-95.835207 40.789309,-95.835815 40.79063,-95.83683 40.792288,-95.838578 40.794976,-95.84007 40.797471,-95.841527 40.799821,-95.842317 40.801247,-95.842738 40.801866,-95.843225 40.802816,-95.843745 40.803783,-95.843961 40.805178,-95.844408 40.806274,-95.844704 40.807209,-95.844994 40.808508,-95.845097 40.809108,-95.84522 40.809831,-95.845342 40.811324,-95.845251 40.812818,-95.844968 40.814217,-95.844922 40.814646,-95.844852 40.815307,-95.844397 40.816553,-95.843921 40.817686,-95.842948 40.819217,-95.842081 40.820569,-95.841581 40.821533,-95.841157 40.82204,-95.840437 40.822903,-95.839894 40.823786,-95.839269 40.825057,-95.838601 40.826175,-95.838351 40.826963,-95.8382 40.827437,-95.837665 40.829216,-95.837303 40.831164,-95.837266 40.832755,-95.837146 40.833474,-95.837122 40.834257,-95.837186 40.835347,-95.83757 40.836524,-95.838224 40.838079,-95.838688 40.839804,-95.839201 40.841094,-95.840014 40.842599,-95.840506 40.843953,-95.841309 40.845604,-95.841893 40.846603,-95.842681 40.847713,-95.843523 40.848976,-95.84434 40.849949,-95.845074 40.851035,-95.846076 40.85237,-95.847084 40.854174,-95.8475 40.855407,-95.847972 40.856809,-95.848112 40.857295,-95.84849 40.858607,-95.848565 40.859665,-95.848571 40.860016,-95.848587 40.860888,-95.84859 40.861061,-95.848242 40.862315,-95.847785 40.864328,-95.847397 40.864871,-95.846938 40.865745,-95.845974 40.867034,-95.844913 40.868202,-95.844073 40.869248,-95.842521 40.870266,-95.840788 40.871236,-95.840483 40.871377,-95.838735 40.872191,-95.836996 40.872644,-95.835054 40.872985,-95.833484 40.87326,-95.832103 40.873412,-95.830735 40.873702,-95.827787 40.874444,-95.824989 40.875,-95.824588 40.875158,-95.82328 40.875694,-95.821193 40.876682,-95.81959 40.877439,-95.817897 40.878448,-95.815933 40.879846,-95.81402 40.881808,-95.812083 40.884239,-95.810709 40.886681,-95.809994 40.889149,-95.809474 40.891228,-95.809379 40.893279,-95.809775 40.895447,-95.810886 40.897907,-95.812757 40.900642,-95.813465 40.901693,-95.814302 40.902936,-95.81618 40.904791,-95.818709 40.906818,-95.822081 40.909079,-95.822951 40.909639,-95.824959 40.910933,-95.827905 40.913069,-95.830699 40.915004,-95.833041 40.917243,-95.834906 40.919574,-95.836438 40.921642,-95.837774 40.924712,-95.838417 40.927408,-95.838446 40.927531,-95.83913 40.930341,-95.839743 40.93278,-95.840139 40.93548,-95.840207 40.937021,-95.840253 40.937909,-95.840277 40.938715,-95.840275 40.939942,-95.839979 40.941309,-95.839364 40.944059,-95.838877 40.946105,-95.838446 40.948385,-95.837951 40.950618,-95.836558 40.953205,-95.835095 40.955471,-95.833499 40.957988,-95.833015 40.958724,-95.832004 40.960269,-95.830801 40.962105,-95.829829 40.963857,-95.829507 40.965652,-95.829354 40.96738,-95.828991 40.969248,-95.828665 40.970793,-95.828329 40.972378,-95.828545 40.973901,-95.829074 40.975688,-95.829792 40.977344,-95.830297 40.978332,-95.831118 40.979777,-95.832055 40.98114,-95.833537 40.98266,-95.835434 40.984184,-95.837681 40.985599,-95.838908 40.986484,-95.840144 40.987243,-95.841186 40.987883,-95.842754 40.988812,-95.844351 40.989524,-95.84732 40.990214,-95.849232 40.990688,-95.851413 40.991362,-95.852547 40.991738,-95.854453 40.992479,-95.856071 40.993206,-95.857305 40.99384,-95.858668 40.994521,-95.860116 40.995242,-95.860445 40.995425,-95.8612 40.995845,-95.86248 40.996607,-95.863492 40.99734,-95.864391 40.998284,-95.865096 40.999076,-95.86601 40.999999,-95.86615 41.000015,-95.866423 41.000383,-95.866695 41.000734,-95.866786 41.000899,-95.8669 41.001026,-95.866951 41.001085,-95.867303 41.001645,-95.867305 41.001649,-95.867318 41.001673,-95.867327 41.001689,-95.867662 41.002304,-95.868037 41.003214,-95.86838 41.003753,-95.8687 41.004395,-95.868915 41.005133,-95.869216 41.005988,-95.869495 41.00709,-95.869567 41.007745,-95.869623 41.008432,-95.869526 41.009162,-95.869502 41.009429,-95.869301 41.009868,-95.868924 41.010954,-95.868643 41.011969,-95.868387 41.012727,-95.868002 41.013566,-95.867521 41.01442,-95.866872 41.01537,-95.866287 41.016349,-95.865886 41.017418,-95.865349 41.018164,-95.8647 41.018922,-95.864011 41.019753,-95.863265 41.020607,-95.862329 41.021808,-95.861616 41.022714,-95.860959 41.02362,-95.860786 41.023999,-95.860744 41.024058,-95.860294 41.024691,-95.859918 41.025403,-95.859622 41.026423,-95.859398 41.027787,-95.85919 41.028931,-95.859142 41.030323,-95.859102 41.031599,-95.85919 41.032591,-95.859278 41.033379,-95.859494 41.034467,-95.859654 41.035695,-95.86007 41.037011,-95.860386 41.037699,-95.860462 41.037887,-95.860862 41.038547,-95.861782 41.039427,-95.862686 41.040151,-95.863686 41.040971,-95.865158 41.042215,-95.866454 41.043103,-95.867246 41.043671,-95.86823 41.044271,-95.86923 41.044847,-95.869807 41.045199,-95.869863 41.045251,-95.870903 41.045823,-95.871783 41.046383,-95.872375 41.046955,-95.872903 41.047471,-95.873399 41.048031,-95.874247 41.048879,-95.874711 41.049323,-95.874998 41.049972,-95.875072 41.05014,-95.875147 41.050308,-95.875187 41.050399,-95.875287 41.050599,-95.875498 41.050743,-95.877258 41.051946,-95.877569 41.052135,-95.879462 41.053277,-95.879487 41.053299,-95.879488 41.053313,-95.879497 41.053448,-95.879724 41.053549,-95.879927 41.053639,-95.88082 41.054036,-95.881586 41.054376,-95.881588 41.054378,-95.881173 41.055938,-95.881387 41.056471,-95.881809 41.057521,-95.881939 41.057909,-95.882101 41.058359,-95.882342 41.059419,-95.882394 41.060412,-95.882476 41.06136,-95.882225 41.063539,-95.881768 41.064561,-95.881478 41.065359,-95.881011 41.066303,-95.880234 41.067457,-95.879367 41.068532,-95.877441 41.070357,-95.874998 41.072266,-95.873967 41.073071,-95.873877 41.073136,-95.873762 41.073218,-95.873761 41.073219,-95.87376 41.07322,-95.873757 41.073222,-95.873754 41.073224,-95.873743 41.073232,-95.873733 41.073239,-95.87257 41.07407,-95.871594 41.07495,-95.871464 41.075022,-95.870323 41.075809,-95.866912 41.078855,-95.865835 41.080079,-95.864782 41.081611,-95.864551 41.08216,-95.863843 41.083456,-95.86332 41.084915,-95.862937 41.086178,-95.862427 41.089687,-95.862517 41.090583,-95.862514 41.091123,-95.862587 41.091876,-95.862783 41.09258,-95.863044 41.093195,-95.863097 41.09366,-95.863113 41.093693,-95.863114 41.093695,-95.863115 41.093697,-95.863121 41.093711,-95.863131 41.093733,-95.863304 41.0941,-95.863279 41.094495,-95.863632 41.095392,-95.864396 41.097124,-95.864833 41.098487,-95.865076 41.09899,-95.865273 41.099913,-95.865726 41.1012,-95.86574 41.101263,-95.865862 41.101833,-95.865921 41.102108,-95.866172 41.10328,-95.866173 41.103287,-95.866213 41.103471,-95.866661 41.104975,-95.867072 41.108379,-95.866976 41.108714,-95.867102 41.109116,-95.867099 41.109511,-95.866818 41.110935,-95.8668 41.111074,-95.866397 41.114376,-95.866304 41.115116,-95.866415 41.117416,-95.866425 41.117812,-95.866641 41.119278,-95.867086 41.120603,-95.867228 41.121493,-95.867566 41.122086,-95.868382 41.123886,-95.868546 41.124103,-95.868689 41.124667,-95.868961 41.125166,-95.869092 41.125548,-95.869493 41.126034,-95.869624 41.126234,-95.870021 41.126839,-95.870087 41.127084,-95.870122 41.127135,-95.870716 41.128004,-95.871168 41.128795,-95.872053 41.129731,-95.872412 41.129966,-95.872679 41.130219,-95.872913 41.130571,-95.873121 41.130766,-95.87347 41.131397,-95.873902 41.131731,-95.874549 41.132486,-95.874757 41.132809,-95.874949 41.133025,-95.875633 41.133793,-95.875864 41.134021,-95.876048 41.134132,-95.876386 41.134649,-95.877042 41.135399,-95.877375 41.13586,-95.877476 41.136,-95.877699 41.136176,-95.87802 41.136658,-95.878302 41.136947,-95.878673 41.137685,-95.879316 41.138584,-95.879318 41.138586,-95.87933 41.138603,-95.879686 41.138938,-95.880044 41.139563,-95.880171 41.139947,-95.880609 41.140625,-95.880865 41.140883,-95.881222 41.141665,-95.881313 41.142127,-95.882032 41.143534,-95.882136 41.143994,-95.882138 41.144005,-95.882304 41.144738,-95.882591 41.145722,-95.882755 41.146021,-95.882875 41.146446,-95.882883 41.146657,-95.882776 41.146898,-95.882803 41.147221,-95.882961 41.147821,-95.883129 41.148196,-95.883172 41.148806,-95.883095 41.149342,-95.883346 41.151056,-95.883271 41.151484,-95.88309 41.151855,-95.883203 41.152652,-95.883144 41.153259,-95.882991 41.153674,-95.882944 41.154572,-95.882718 41.154937,-95.882643 41.155061,-95.882626 41.155193,-95.882625 41.155201,-95.88254 41.155881,-95.882392 41.156185,-95.882152 41.156495,-95.881958 41.156935,-95.881477 41.158361,-95.881062 41.158841,-95.880521 41.159874,-95.879959 41.160947,-95.879654 41.161267,-95.879171 41.161968,-95.877368 41.163914,-95.875798 41.165268,-95.875397 41.16552,-95.874398 41.166216,-95.873692 41.166642,-95.87271 41.167003,-95.872066 41.16731,-95.87111 41.167635,-95.870574 41.167784,-95.869178 41.168013,-95.867309 41.168153,-95.865929 41.168129,-95.864852 41.167939,-95.864399 41.167859,-95.863261 41.167495,-95.862345 41.167297,-95.86091 41.166911,-95.860316 41.166685,-95.859258 41.166535,-95.857637 41.166113,-95.856813 41.165935,-95.856296 41.165877,-95.853451 41.165518,-95.850882 41.165674,-95.849855 41.165833,-95.849363 41.165967,-95.848892 41.166018,-95.847938 41.166239,-95.846957 41.166604,-95.845451 41.167423,-95.844378 41.168241,-95.843883 41.168768,-95.843443 41.169096,-95.842731 41.170031,-95.842623 41.170345,-95.842039 41.171367,-95.842015 41.171654,-95.841789 41.172314,-95.841655 41.17317,-95.841611 41.173925,-95.841673 41.17486,-95.841616 41.175469,-95.84171 41.175858,-95.841816 41.175977,-95.841929 41.176256,-95.841956 41.176321,-95.842051 41.176772,-95.842188 41.177421,-95.84241 41.177778,-95.842746 41.178127,-95.843351 41.179677,-95.843657 41.180041,-95.844175 41.180411,-95.844535 41.180791,-95.844842 41.181155,-95.845121 41.181612,-95.845433 41.18193,-95.846295 41.182546,-95.847241 41.183351,-95.848798 41.184296,-95.849358 41.184545,-95.849861 41.18477,-95.850374 41.18509,-95.850757 41.185234,-95.851169 41.185321,-95.851268 41.185365,-95.852314 41.185833,-95.853094 41.185988,-95.854142 41.186411,-95.854836 41.186529,-95.855286 41.186697,-95.856125 41.186949,-95.85688 41.186995,-95.858032 41.18733,-95.858728 41.187375,-95.859224 41.187501,-95.86044 41.187666,-95.86097 41.187826,-95.861659 41.187965,-95.862084 41.188007,-95.862558 41.187993,-95.863797 41.188245,-95.864554 41.188205,-95.865782 41.188296,-95.866304 41.188277,-95.867624 41.188416,-95.868373 41.188324,-95.869538 41.188342,-95.870101 41.188272,-95.871288 41.188324,-95.872031 41.188209,-95.873608 41.188223,-95.873877 41.188153,-95.874537 41.188089,-95.875726 41.188048,-95.876582 41.188067,-95.877133 41.187961,-95.878133 41.187941,-95.878636 41.187836,-95.879586 41.187787,-95.880089 41.187681,-95.880658 41.187663,-95.885516 41.186773,-95.886131 41.186582,-95.886739 41.186496,-95.88784 41.186239,-95.888923 41.186128,-95.889651 41.185962,-95.891187 41.185721,-95.894134 41.185336,-95.898155 41.184775,-95.898962 41.184794,-95.8998 41.184655,-95.90051 41.184609,-95.90089 41.184626,-95.901348 41.184718,-95.901818 41.18466,-95.904169 41.184554,-95.904735 41.184499,-95.905591 41.184528,-95.90758 41.184368,-95.908668 41.184454,-95.910236 41.184403,-95.910787 41.184481,-95.911365 41.184642,-95.911984 41.18467,-95.912506 41.184638,-95.913168 41.184691,-95.913668 41.184809,-95.9142 41.18504,-95.914668 41.185111,-95.915428 41.185145,-95.916119 41.185279,-95.916699 41.185525,-95.9172 41.185907,-95.91891 41.18654,-95.919561 41.186901,-95.919916 41.187239,-95.920178 41.18766,-95.920783 41.188071,-95.92127 41.188401,-95.921454 41.188525,-95.922182 41.189092,-95.922358 41.189305,-95.922531 41.189678,-95.923205 41.190282,-95.923394 41.190532,-95.923548 41.19085,-95.924152 41.191474,-95.924454 41.192078,-95.925086 41.192796,-95.925235 41.19306,-95.925322 41.193376,-95.925901 41.194119,-95.926029 41.194683,-95.926334 41.195211,-95.926694 41.195633,-95.926771 41.196148,-95.92725 41.197086,-95.927296 41.197408,-95.927263 41.197802,-95.927663 41.199025,-95.927738 41.199453,-95.927908 41.199749,-95.927975 41.200069,-95.927932 41.200426,-95.927748 41.200833,-95.927733 41.200866,-95.927739 41.201082,-95.927752 41.201126,-95.927935 41.20175,-95.927985 41.202056,-95.928011 41.202211,-95.928071 41.202569,-95.928047 41.202892,-95.927934 41.20324,-95.928019 41.204895,-95.927988 41.205398,-95.927846 41.205888,-95.927528 41.206327,-95.927523 41.206369,-95.927459 41.206905,-95.927454 41.206947,-95.927453 41.206956,-95.927445 41.207023,-95.927262 41.208554,-95.927183 41.208971,-95.926912 41.20943,-95.926865 41.209585,-95.926838 41.209675,-95.92683 41.209998,-95.926765 41.210218,-95.926736 41.210314,-95.926572 41.210613,-95.92634 41.210885,-95.92628 41.211082,-95.926275 41.211098,-95.926117 41.211619,-95.925932 41.211911,-95.925678 41.212171,-95.92563 41.212284,-95.925461 41.212686,-95.925084 41.213269,-95.924683 41.213555,-95.924618 41.213601,-95.924538 41.213658,-95.924524 41.213668,-95.924522 41.21367,-95.924463 41.213712,-95.924189 41.214119,-95.924179 41.214134,-95.923686 41.214866,-95.923426 41.215369,-95.923045 41.215824,-95.922764 41.216069,-95.922488 41.216231,-95.922426 41.216267,-95.922319 41.216394,-95.922284 41.216436,-95.92228 41.216441,-95.922279 41.216442,-95.922278 41.216443,-95.922277 41.216445,-95.922273 41.21645,-95.922257 41.216469,-95.922225 41.216507,-95.922143 41.216605,-95.921865 41.216936,-95.92096 41.217676,-95.920512 41.218037,-95.920026 41.218428,-95.919342 41.218979,-95.919221 41.219076,-95.919037 41.219224,-95.919026 41.219233,-95.918502 41.219667,-95.91849 41.219677,-95.9173 41.220617,-95.917005 41.221027,-95.915814 41.222105,-95.915556 41.222506,-95.915523 41.222557,-95.914272 41.223858,-95.913843 41.22458,-95.913661 41.224988,-95.912977 41.225895,-95.912763 41.226294,-95.912711 41.226528,-95.912669 41.226719,-95.912374 41.227328,-95.911801 41.228316,-95.911734 41.228457,-95.911496 41.228962,-95.911363 41.22978,-95.91106 41.230461,-95.911053 41.230892,-95.910918 41.231531,-95.910912 41.231546,-95.910879 41.231631,-95.910676 41.23215,-95.910712 41.232685,-95.910666 41.233223,-95.910735 41.233615,-95.910724 41.233993,-95.910724 41.234002,-95.910716 41.234299,-95.910629 41.234579,-95.910712 41.235043,-95.910703 41.23623,-95.910955 41.237769,-95.910955 41.238032,-95.91113 41.23848,-95.911296 41.239442,-95.91164 41.239994,-95.91186 41.241023,-95.912225 41.241566,-95.912472 41.242295,-95.912932 41.242924,-95.913015 41.243098,-95.913109 41.243296,-95.913175 41.243542,-95.913265 41.24365,-95.91329 41.24368,-95.913305 41.243698,-95.913306 41.2437,-95.913308 41.243702,-95.913309 41.243703,-95.913338 41.243738,-95.913508 41.243942,-95.913961 41.244485,-95.914168 41.245,-95.914408 41.245352,-95.915113 41.246075,-95.915389 41.246647,-95.915408 41.246663,-95.915434 41.246685,-95.915793 41.246999,-95.91602 41.247274,-95.916211 41.247755,-95.91642 41.248012,-95.916469 41.248073,-95.916573 41.248201,-95.916732 41.248398,-95.916899 41.248831,-95.917399 41.249685,-95.917438 41.24976,-95.917443 41.249769,-95.917447 41.249778,-95.91745 41.249784,-95.917455 41.249792,-95.917459 41.249801,-95.91747 41.249821,-95.917472 41.249826,-95.917475 41.249832,-95.91748 41.249842,-95.917646 41.250164,-95.918352 41.251532,-95.918526 41.251805,-95.918534 41.251818,-95.918535 41.251819,-95.918587 41.2519,-95.919093 41.252698,-95.919532 41.253724,-95.919564 41.253876,-95.919567 41.253895,-95.919577 41.253943,-95.919582 41.253968,-95.919616 41.254123,-95.920225 41.255296,-95.920265 41.255374,-95.920445 41.255722,-95.920719 41.256712,-95.92134 41.258129,-95.921345 41.258139,-95.921364 41.258181,-95.921427 41.258456,-95.921429 41.258464,-95.92143 41.258469,-95.921432 41.258482,-95.921606 41.259279,-95.921627 41.259412,-95.921629 41.259426,-95.921631 41.25944,-95.921632 41.259444,-95.921633 41.259448,-95.921634 41.259455,-95.921645 41.259527,-95.92166 41.259626,-95.921669 41.259688,-95.92168 41.259763,-95.921692 41.259838,-95.921776 41.260387,-95.922104 41.261399,-95.922113 41.261722,-95.922042 41.262033,-95.922304 41.26302,-95.922308 41.263848,-95.922423 41.264635,-95.922395 41.26546,-95.921704 41.26687,-95.921643 41.267262,-95.921497 41.267604,-95.92056 41.26851,-95.920119 41.269085,-95.920034 41.269143,-95.919867 41.269255,-95.919701 41.269367,-95.918732 41.269824,-95.917927 41.270553,-95.917755 41.270709,-95.917646 41.270782,-95.91747 41.2709,-95.916662 41.271201,-95.916343 41.271468,-95.915741 41.271821,-95.915316 41.271985,-95.915181 41.272014,-95.915121 41.272027,-95.915097 41.272032,-95.914813 41.272092,-95.914671 41.272158,-95.914091 41.272428,-95.914909 41.272559,-95.91573 41.272691,-95.915832 41.272707,-95.915937 41.272725,-95.916045 41.272802,-95.916772 41.273322,-95.917872 41.274085,-95.917914 41.274115,-95.918041 41.274208,-95.918187 41.2743,-95.918585 41.274567,-95.91887 41.274758,-95.924811 41.278741,-95.924835 41.278759,-95.925884 41.27953,-95.925948 41.27957,-95.926036 41.279627,-95.927075 41.280306,-95.927076 41.280307,-95.927102 41.280324,-95.927332 41.280474,-95.927407 41.280523,-95.927453 41.280553,-95.927477 41.280569,-95.927496 41.280581,-95.927497 41.280582,-95.927503 41.280585,-95.927504 41.280586,-95.927526 41.2806,-95.927783 41.280768,-95.928646 41.281332,-95.929619 41.285077,-95.929602 41.290449,-95.929607 41.290629,-95.929651 41.292262,-95.929219 41.29359,-95.929066 41.29406,-95.928968 41.294361,-95.92896 41.294386,-95.928958 41.294392,-95.928957 41.294395,-95.928957 41.294397,-95.928952 41.294413,-95.928936 41.294462,-95.928925 41.294495,-95.92881 41.294849,-95.928341 41.296291,-95.928309 41.29639,-95.928295 41.296432,-95.928294 41.296435,-95.92828 41.296477,-95.928258 41.296545,-95.928128 41.296945,-95.928043 41.297206,-95.92797 41.297431,-95.927965 41.297446,-95.927959 41.297466,-95.927958 41.297469,-95.92795 41.297494,-95.927905 41.297632,-95.927642 41.29844,-95.926393 41.298887,-95.924691 41.299597,-95.92236 41.300392,-95.920247 41.301191,-95.913781 41.301377,-95.913576 41.301383,-95.912055 41.301258,-95.911712 41.301243,-95.911413 41.30123,-95.911305 41.301225,-95.911262 41.301223,-95.911251 41.301223,-95.911248 41.301223,-95.910806 41.301204,-95.910791 41.301203,-95.910788 41.301203,-95.909997 41.301168,-95.90972 41.301157,-95.909566 41.30115,-95.909545 41.301149,-95.909541 41.301149,-95.909539 41.301149,-95.909538 41.301148,-95.909535 41.301148,-95.909514 41.301147,-95.909491 41.301146,-95.909462 41.301145,-95.90944 41.301144,-95.909435 41.301144,-95.909431 41.301144,-95.909424 41.301144,-95.909422 41.301143,-95.90942 41.301143,-95.909418 41.301143,-95.909416 41.301143,-95.90935 41.30114,-95.909302 41.301138,-95.908971 41.301124,-95.908506 41.301103,-95.908387 41.3011,-95.908245 41.301096,-95.908198 41.301095,-95.908137 41.301094,-95.908111 41.301093,-95.908008 41.30109,-95.907557 41.301079,-95.907407 41.301075,-95.907307 41.301073,-95.907302 41.301073,-95.907256 41.301072,-95.907129 41.301069,-95.906079 41.301043,-95.905969 41.30104,-95.90596 41.30104,-95.905958 41.301039,-95.905956 41.301039,-95.905952 41.301039,-95.905939 41.301039,-95.905932 41.301039,-95.905899 41.301038,-95.904865 41.299787,-95.904683 41.299408,-95.904659 41.299359,-95.904518 41.299065,-95.904481 41.298987,-95.90441 41.298839,-95.904393 41.298804,-95.904356 41.298543,-95.904318 41.298275,-95.904241 41.297729,-95.904222 41.297591,-95.904229 41.297497,-95.904235 41.297424,-95.904242 41.297341,-95.904262 41.297102,-95.904262 41.297098,-95.904263 41.29709,-95.904379 41.295672,-95.904383 41.295613,-95.904384 41.295604,-95.90439 41.295536,-95.904392 41.295506,-95.904404 41.295358,-95.90441 41.29528,-95.904421 41.295149,-95.904427 41.295079,-95.904444 41.294873,-95.904444 41.29487,-95.904444 41.294868,-95.904445 41.294867,-95.904445 41.294865,-95.904445 41.294863,-95.904449 41.294821,-95.904457 41.29472,-95.904478 41.294457,-95.904505 41.294127,-95.904514 41.294016,-95.904514 41.294014,-95.904515 41.293999,-95.904518 41.293965,-95.904554 41.293519,-95.904576 41.293255,-95.904825 41.293255,-95.905146 41.293346,-95.905411 41.293176,-95.90539 41.293076,-95.904786 41.292959,-95.90471 41.292883,-95.904766 41.292586,-95.905216 41.291616,-95.905123 41.291341,-95.905322 41.291242,-95.905357 41.291224,-95.905482 41.29123,-95.905952 41.288572,-95.905961 41.288521,-95.905965 41.288502,-95.905965 41.2885,-95.905966 41.288497,-95.905966 41.288494,-95.905967 41.288488,-95.905969 41.288476,-95.905974 41.28845,-95.906144 41.287488,-95.906192 41.287369,-95.906666 41.286195,-95.906668 41.286139,-95.906682 41.286105,-95.906769 41.2859,-95.906814 41.285795,-95.906901 41.285589,-95.906906 41.285577,-95.906912 41.285563,-95.90693 41.285521,-95.907117 41.28508,-95.907118 41.285077,-95.907119 41.285074,-95.907122 41.285067,-95.907131 41.285046,-95.90716 41.284977,-95.907177 41.284938,-95.9074 41.284734,-95.907604 41.284528,-95.907705 41.28442,-95.907751 41.284366,-95.907793 41.284316,-95.908038 41.284069,-95.9082 41.283906,-95.909059 41.283051,-95.909558 41.282551,-95.910543 41.281564,-95.910791 41.281317,-95.910974 41.281134,-95.912581 41.279527,-95.912576 41.279524,-95.909856 41.277913,-95.90866 41.277198,-95.908151 41.276893,-95.90794 41.276767,-95.907121 41.276279,-95.906905 41.276141,-95.906891 41.276132,-95.906837 41.276097,-95.906707 41.276014,-95.906701 41.27601,-95.906695 41.276006,-95.906661 41.275984,-95.906651 41.275978,-95.906562 41.275921,-95.906551 41.275914,-95.906418 41.275829,-95.905998 41.275561,-95.905976 41.275547,-95.905907 41.275503,-95.905724 41.275386,-95.905178 41.275037,-95.90505 41.275,-95.90493 41.274967,-95.904921 41.274964,-95.904719 41.274907,-95.90388 41.274669,-95.9029 41.274391,-95.90284 41.274374,-95.902812 41.274378,-95.902793 41.274381,-95.902709 41.274393,-95.90266 41.2744,-95.902633 41.274404,-95.902618 41.274406,-95.902615 41.274406,-95.902599 41.274408,-95.902538 41.274417,-95.902468 41.274427,-95.902262 41.274456,-95.901985 41.274496,-95.901523 41.274683,-95.899846 41.2752,-95.898441 41.275537,-95.898031 41.27572,-95.897634 41.275977,-95.896875 41.276191,-95.896114 41.276322,-95.89611 41.276324,-95.896067 41.276342,-95.896058 41.276346,-95.896043 41.276352,-95.896026 41.276359,-95.896018 41.276362,-95.896 41.27637,-95.895432 41.276611,-95.893148 41.277348,-95.892506 41.277555,-95.892481 41.277563,-95.892478 41.277564,-95.892476 41.277564,-95.892474 41.277565,-95.892468 41.277567,-95.892446 41.277574,-95.892439 41.277576,-95.892438 41.277577,-95.892435 41.277578,-95.89238 41.277596,-95.891895 41.277752,-95.891849 41.277767,-95.891845 41.277768,-95.891841 41.277769,-95.891828 41.277773,-95.891823 41.277775,-95.89145 41.277895,-95.891214 41.277971,-95.891212 41.277972,-95.891209 41.277973,-95.891201 41.277976,-95.891191 41.277979,-95.891171 41.277985,-95.891155 41.27799,-95.891137 41.277996,-95.891115 41.278003,-95.89109 41.278011,-95.891078 41.278015,-95.891066 41.278019,-95.891 41.27804,-95.887615 41.279366,-95.884495 41.280689,-95.883316 41.281301,-95.881448 41.282171,-95.880659 41.28264,-95.880512 41.282727,-95.880496 41.282736,-95.879619 41.283238,-95.878881 41.283661,-95.878408 41.284016,-95.877481 41.284583,-95.877432 41.284623,-95.877191 41.284818,-95.877137 41.284861,-95.87681 41.285125,-95.876051 41.285739,-95.875593 41.286199,-95.875309 41.286615,-95.874716 41.287032,-95.874324 41.287394,-95.874139 41.287646,-95.874004 41.287953,-95.873723 41.288259,-95.873652 41.288337,-95.873378 41.28886,-95.873317 41.288951,-95.873231 41.289079,-95.872937 41.289517,-95.872917 41.289546,-95.872894 41.289581,-95.872892 41.289584,-95.872872 41.289614,-95.872817 41.289696,-95.872816 41.289698,-95.872814 41.2897,-95.872813 41.289701,-95.872807 41.28971,-95.872806 41.289712,-95.872667 41.289919,-95.872634 41.290019,-95.872631 41.290028,-95.872539 41.290302,-95.872128 41.291145,-95.871809 41.292378,-95.871589 41.292735,-95.871442 41.293408,-95.871483 41.294018,-95.871382 41.294295,-95.871368 41.295054,-95.871367 41.295083,-95.871192 41.296044,-95.871141 41.29669,-95.871304 41.297286,-95.871277 41.298077,-95.871391 41.298572,-95.871395 41.299482,-95.87161 41.300069,-95.871679 41.300967,-95.871819 41.301348,-95.871871 41.301813,-95.872269 41.30307,-95.87247 41.303435,-95.872705 41.30428,-95.873049 41.304871,-95.873404 41.305879,-95.873643 41.306287,-95.874071 41.307466,-95.874184 41.307924,-95.87435 41.308183,-95.874578 41.308414,-95.875109 41.309453,-95.875503 41.309857,-95.875725 41.310293,-95.876461 41.311087,-95.87676 41.311537,-95.877399 41.312071,-95.878292 41.313081,-95.878634 41.313331,-95.879163 41.313571,-95.879868 41.314381,-95.88022 41.314624,-95.880649 41.314825,-95.881868 41.315687,-95.882257 41.316179,-95.882916 41.316647,-95.883313 41.316847,-95.883793 41.317006,-95.884576 41.317417,-95.885554 41.318097,-95.88635 41.318422,-95.886941 41.318567,-95.887214 41.318604,-95.887316 41.318618,-95.887802 41.318833,-95.887808 41.318836,-95.888109 41.318969,-95.888236 41.319025,-95.888244 41.319029,-95.888414 41.319104,-95.888442 41.319116,-95.888481 41.319133,-95.888633 41.3192,-95.888926 41.31933,-95.889251 41.319474,-95.889914 41.319677,-95.890921 41.319902,-95.891506 41.320211,-95.892035 41.320374,-95.893449 41.320536,-95.893817 41.320612,-95.894405 41.320848,-95.894818 41.320937,-95.895244 41.320974,-95.896006 41.320945,-95.896839 41.321103,-95.897284 41.321234,-95.89879 41.321249,-95.899943 41.321481,-95.900878 41.321341,-95.901736 41.321474,-95.902577 41.321347,-95.904145 41.321238,-95.905181 41.321108,-95.907631 41.320656,-95.907696 41.320644,-95.907705 41.320643,-95.907918 41.320604,-95.908814 41.320498,-95.909734 41.320304,-95.910541 41.320286,-95.911457 41.320191,-95.912337 41.320079,-95.912371 41.320075,-95.912736 41.320075,-95.914116 41.320077,-95.914618 41.319962,-95.915091 41.319918,-95.915566 41.319948,-95.916495 41.320113,-95.917705 41.320136,-95.918174 41.320074,-95.918651 41.320079,-95.921378 41.320434,-95.922744 41.320861,-95.925185 41.321355,-95.925835 41.32158,-95.927206 41.322267,-95.927444 41.322386,-95.92779 41.322559,-95.929383 41.32313,-95.931008 41.324236,-95.931717 41.324602,-95.932144 41.324771,-95.932146 41.324772,-95.932859 41.325054,-95.934463 41.32596,-95.934972 41.326173,-95.93573 41.326473,-95.936383 41.326997,-95.93786 41.327853,-95.939024 41.328416,-95.939386 41.32851,-95.939578 41.328597,-95.939605 41.328609,-95.940121 41.328843,-95.940672 41.329337,-95.941778 41.330025,-95.941789 41.330032,-95.942955 41.330756,-95.94365 41.331243,-95.943654 41.331246,-95.944087 41.33155,-95.944843 41.33208,-95.946532 41.333139,-95.947626 41.334084,-95.947645 41.334101,-95.948258 41.334631,-95.950198 41.336221,-95.951208 41.337179,-95.951657 41.337502,-95.952646 41.338692,-95.953418 41.33947,-95.955294 41.341896,-95.955764 41.342633,-95.956038 41.343063,-95.956693 41.344721,-95.956994 41.345521,-95.957008 41.345558,-95.957052 41.345676,-95.957097 41.345794,-95.957137 41.345902,-95.957301 41.347369,-95.957249 41.348879,-95.95713 41.349593,-95.956635 41.350716,-95.956294 41.351062,-95.955671 41.351994,-95.954883 41.352808,-95.954271 41.353508,-95.954171 41.353592,-95.953953 41.353776,-95.953443 41.354042,-95.952317 41.354871,-95.950965 41.355479,-95.950402 41.355677,-95.949894 41.355777,-95.949341 41.355986,-95.948597 41.356115,-95.948268 41.35626,-95.946914 41.356609,-95.945699 41.356801,-95.945121 41.356865,-95.943337 41.357063,-95.943017 41.357135,-95.941359 41.35769,-95.940811 41.357813,-95.940586 41.357904,-95.940055 41.358119,-95.939718 41.358206,-95.939062 41.358375,-95.938294 41.35874,-95.936923 41.359247,-95.936555 41.359475,-95.936258 41.359756,-95.935468 41.360135,-95.935042 41.360521,-95.933642 41.361551,-95.933347 41.361834,-95.933128 41.362153,-95.932184 41.36296,-95.931711 41.363626,-95.931421 41.364035,-95.93135 41.364108,-95.931015 41.364454,-95.930965 41.364495,-95.930767 41.365008,-95.930296 41.365803,-95.930245 41.365889,-95.929681 41.367058,-95.928774 41.37008,-95.928824 41.370545,-95.928768 41.37166,-95.928951 41.372441,-95.929008 41.37316,-95.929173 41.373857,-95.929294 41.374365,-95.929457 41.375182,-95.929486 41.375326,-95.929714 41.375875,-95.929799 41.376228,-95.930281 41.376995,-95.930388 41.377345,-95.930575 41.377676,-95.932246 41.379815,-95.932485 41.379997,-95.93314 41.380875,-95.933878 41.381714,-95.934896 41.383136,-95.935286 41.383811,-95.935407 41.384021,-95.936073 41.385252,-95.936411 41.385876,-95.936644 41.386573,-95.936721 41.38729,-95.93699 41.387834,-95.937237 41.388334,-95.937418 41.389516,-95.937791 41.390752,-95.937666 41.391568,-95.937771 41.392255,-95.937806 41.393201,-95.937676 41.393834,-95.937726 41.394232,-95.937694 41.39477,-95.937272 41.396131,-95.937168 41.396735,-95.936871 41.397342,-95.936752 41.397873,-95.935793 41.399632,-95.935426 41.400135,-95.935062 41.400489,-95.934881 41.400836,-95.93421 41.401834,-95.933153 41.403155,-95.932439 41.404,-95.931587 41.405638,-95.930891 41.407205,-95.930214 41.409021,-95.930141 41.409219,-95.929932 41.410323,-95.929677 41.411071,-95.92961 41.412723,-95.929525 41.41344,-95.929596 41.414157,-95.929549 41.41473,-95.929472 41.415042,-95.929478 41.415329,-95.929875 41.416772,-95.93 41.417557,-95.930473 41.418894,-95.930479 41.418912,-95.930625 41.41924,-95.931224 41.420583,-95.93154 41.421066,-95.931731 41.421549,-95.931788 41.421869,-95.932254 41.423072,-95.932255 41.423073,-95.932519 41.423459,-95.932479 41.424212,-95.932767 41.425159,-95.932994 41.426186,-95.932972 41.42658,-95.933099 41.427219,-95.933135 41.428188,-95.933097 41.428941,-95.932885 41.429603,-95.932882 41.430107,-95.932778 41.430815,-95.932647 41.430946,-95.932525 41.431181,-95.932447 41.431608,-95.932311 41.432071,-95.931942 41.432571,-95.931724 41.433085,-95.931228 41.433613,-95.930921 41.434178,-95.930423 41.434747,-95.930101 41.43496,-95.929514 41.435659,-95.929108 41.435962,-95.928638 41.436501,-95.927326 41.437447,-95.926926 41.43785,-95.925961 41.438439,-95.925571 41.438802,-95.925268 41.438957,-95.924596 41.439519,-95.923285 41.440503,-95.922546 41.44134,-95.922106 41.441665,-95.921971 41.441837,-95.92174 41.44213,-95.921402 41.442838,-95.920857 41.443428,-95.920846 41.443449,-95.920618 41.443937,-95.920279 41.444978,-95.919905 41.445869,-95.91974 41.447373,-95.919537 41.448186,-95.919606 41.448975,-95.919566 41.450015,-95.919801 41.450747,-95.919779 41.451286,-95.919859 41.451494,-95.919989 41.452604,-95.920215 41.452795,-95.920498 41.45324,-95.920678 41.453627,-95.92096 41.454673,-95.921192 41.455138,-95.921655 41.455602,-95.922246 41.456358,-95.922786 41.457306,-95.923867 41.458236,-95.92451 41.458914,-95.924818 41.459127,-95.925384 41.459398,-95.925924 41.459901,-95.926464 41.46025,-95.927081 41.460811,-95.927442 41.461044,-95.927827 41.461257,-95.928419 41.461683,-95.929216 41.461993,-95.930425 41.462748,-95.933537 41.464277,-95.935054 41.464839,-95.935414 41.464936,-95.935903 41.465168,-95.93634 41.465304,-95.937137 41.465381,-95.937626 41.465536,-95.938706 41.465827,-95.939478 41.465982,-95.940481 41.466078,-95.941767 41.466349,-95.94349 41.466388,-95.944544 41.466485,-95.945007 41.466485,-95.946319 41.466272,-95.947142 41.46602,-95.947626 41.465946,-95.948016 41.465827,-95.949589 41.465538,-95.950717 41.46511,-95.952491 41.46451,-95.953829 41.464123,-95.95604 41.4636,-95.957764 41.463367,-95.95791 41.463331,-95.958372 41.463218,-95.95941 41.463154,-95.961363 41.46316,-95.962702 41.463077,-95.965042 41.463212,-95.966688 41.463425,-95.967511 41.463638,-95.968334 41.46389,-95.968745 41.464142,-95.969697 41.464491,-95.970906 41.465071,-95.97124 41.465323,-95.971574 41.465497,-95.972901 41.466082,-95.974223 41.467027,-95.975869 41.467899,-95.976435 41.468286,-95.97785 41.468809,-95.978776 41.469293,-95.979804 41.469719,-95.980499 41.469854,-95.98181 41.4703,-95.984279 41.470939,-95.986465 41.471326,-95.987327 41.471392,-95.987931 41.471481,-95.988497 41.471578,-95.990606 41.471675,-95.991086 41.471789,-95.991661 41.471849,-95.992561 41.47181,-95.993692 41.471675,-95.994207 41.471733,-95.99575 41.471578,-95.996316 41.471597,-95.997482 41.471505,-95.998052 41.47146,-95.998665 41.471528,-95.999668 41.471524,-96.00029 41.471605,-96.000468 41.471629,-96.001612 41.471695,-96.002053 41.471769,-96.004047 41.472146,-96.004936 41.472413,-96.006609 41.473038,-96.007264 41.473435,-96.007354 41.47349,-96.007683 41.473611,-96.00804 41.473742,-96.008519 41.474039,-96.009016 41.47452,-96.009457 41.474795,-96.010588 41.475721,-96.01125 41.476186,-96.011513 41.476443,-96.01176 41.476791,-96.012073 41.477075,-96.013585 41.478469,-96.014116 41.479151,-96.015 41.480048,-96.015386 41.480704,-96.016608 41.481918,-96.017836 41.483584,-96.018563 41.484991,-96.018767 41.485619,-96.019343 41.486926,-96.019532 41.488325,-96.0195 41.490451,-96.019543 41.491592,-96.019054 41.491684,-96.018591 41.491772,-96.017918 41.491976,-96.01738 41.492139,-96.01282 41.494904,-96.000649 41.50254,-96.000319 41.502857,-95.997022 41.506046,-95.996194 41.50696,-95.99328 41.512314,-95.992777 41.514596,-95.993651 41.520178,-95.994308 41.523743,-95.994751 41.524954,-95.995904 41.528152,-95.997233 41.53172,-95.998871 41.536599,-95.999537 41.538283,-95.999966 41.53948,-96.001392 41.540586,-96.003181 41.541825,-96.005112 41.54325,-96.013876 41.545315,-96.01915 41.54514,-96.022811 41.543721,-96.02349 41.543438,-96.024096 41.542833,-96.026657 41.540366,-96.027103 41.538662,-96.027747 41.534663,-96.028381 41.532125,-96.029053 41.529996,-96.02931 41.527981,-96.029915 41.526372,-96.030554 41.524564,-96.031127 41.523004,-96.031705 41.522181,-96.034441 41.521051,-96.033854 41.519935,-96.033675 41.517119,-96.034397 41.514446,-96.03429 41.513036,-96.034353 41.512761,-96.03465 41.512215,-96.034877 41.511704,-96.035076 41.511375,-96.035326 41.510962,-96.035575 41.510549,-96.035881 41.510137,-96.036603 41.509047,-96.037882 41.507899,-96.039046 41.507463,-96.039807 41.507061,-96.040613 41.506893,-96.042895 41.506927,-96.044686 41.506893,-96.046745 41.507061,-96.048311 41.507262,-96.05037 41.507732,-96.052765 41.508436,-96.055048 41.509508,-96.057331 41.511051,-96.060867 41.514101,-96.061717 41.514688,-96.06306 41.515694,-96.063796 41.51623,-96.064267 41.516727,-96.064444 41.516924,-96.064555 41.516934,-96.066842 41.517746,-96.067491 41.518292,-96.068633 41.519113,-96.069067 41.519579,-96.069386 41.519973,-96.069639 41.520284,-96.069893 41.520581,-96.069973 41.520674,-96.070543 41.521246,-96.070636 41.52134,-96.070994 41.521624,-96.071141 41.521741,-96.071384 41.52195,-96.071487 41.522031,-96.071637 41.522149,-96.072478 41.522957,-96.072651 41.523088,-96.073019 41.523299,-96.073389 41.523529,-96.073665 41.52368,-96.074156 41.523947,-96.07457 41.524157,-96.075152 41.52442,-96.075666 41.524633,-96.076761 41.525051,-96.077283 41.525233,-96.077898 41.525432,-96.078343 41.525563,-96.078802 41.52565,-96.079359 41.525781,-96.079922 41.525902,-96.080198 41.525955,-96.081431 41.525966,-96.082253 41.525973,-96.082654 41.525974,-96.084031 41.526875,-96.088305 41.530244,-96.090118 41.531702,-96.090837 41.532644,-96.091908 41.534049,-96.09343 41.537268,-96.094437 41.539463,-96.095109 41.541089,-96.095472 41.542308,-96.095758 41.543269,-96.096586 41.545397,-96.096596 41.545475,-96.096617 41.545626,-96.096359 41.549663,-96.096314 41.550948,-96.096313 41.550979,-96.096313 41.550987,-96.096313 41.550989,-96.095985 41.55164,-96.09587 41.551868,-96.095042 41.554768,-96.094706 41.555556,-96.093654 41.558288,-96.092222 41.560886,-96.091259 41.562244,-96.088842 41.56444,-96.088135 41.565047,-96.087428 41.565654,-96.084859 41.567859,-96.082486 41.571145,-96.081613 41.573274,-96.081188 41.574296,-96.081278 41.577045,-96.08139 41.5779,-96.082285 41.580683,-96.08327 41.582627,-96.083672 41.583197,-96.083963 41.583683,-96.084568 41.584337,-96.085396 41.585092,-96.087186 41.58655,-96.088898 41.58748,-96.089066 41.587572,-96.093453 41.589098,-96.093492 41.589108,-96.094591 41.589379,-96.094638 41.589391,-96.098869 41.590439,-96.101331 41.591411,-96.105296 41.593318,-96.105829 41.593574,-96.107709 41.59525,-96.109455 41.596775,-96.112386 41.600279,-96.11364 41.601955,-96.114647 41.603681,-96.11466 41.603703,-96.115811 41.605659,-96.116795 41.608073,-96.117584 41.610441,-96.118233 41.613291,-96.118277 41.614967,-96.118241 41.615278,-96.118079 41.6167,-96.118009 41.617314,-96.117718 41.618555,-96.116755 41.620901,-96.115995 41.622024,-96.114159 41.623969,-96.113107 41.62536,-96.111339 41.627137,-96.109437 41.62883,-96.108094 41.629568,-96.106796 41.630372,-96.105498 41.631495,-96.104692 41.632065,-96.103864 41.63287,-96.102163 41.634379,-96.100709 41.635451,-96.099411 41.637413,-96.097777 41.639625,-96.095937 41.644616,-96.095534 41.645856,-96.095131 41.647767,-96.095221 41.650114,-96.095254 41.650276,-96.096116 41.654472,-96.09621 41.654669,-96.097683 41.657758,-96.100055 41.661077,-96.103994 41.663223,-96.107186 41.665595,-96.107407 41.665586,-96.108918 41.666039,-96.111156 41.667547,-96.112454 41.668486,-96.114065 41.669961,-96.11505 41.670799,-96.116527 41.67204,-96.117959 41.673314,-96.118631 41.674185,-96.119347 41.674722,-96.120152 41.675694,-96.121048 41.677002,-96.121459 41.678104,-96.120865 41.678227,-96.121309 41.679552,-96.121832 41.681001,-96.122346 41.682489,-96.122578 41.683059,-96.122604 41.68304,-96.121853 41.689205,-96.121636 41.689579,-96.119861 41.692649,-96.118731 41.693781,-96.116161 41.695886,-96.115974 41.696016,-96.114222 41.697234,-96.113461 41.697569,-96.108559 41.699279,-96.107902 41.699274,-96.107695 41.699273,-96.107487 41.699271,-96.107155 41.699268,-96.106408 41.699263,-96.106405 41.699263,-96.105478 41.699345,-96.104887 41.699379,-96.104227 41.6994,-96.103814 41.699403,-96.10328 41.699398,-96.103239 41.699397,-96.102993 41.699391,-96.102981 41.699391,-96.102677 41.699379,-96.102425 41.699365,-96.102423 41.699365,-96.10242 41.699365,-96.102417 41.699365,-96.102416 41.699364,-96.102414 41.699364,-96.102302 41.699358,-96.102164 41.699348,-96.101685 41.699313,-96.101537 41.699298,-96.101052 41.699249,-96.10062 41.699194,-96.100565 41.699187,-96.100563 41.699187,-96.10056 41.699187,-96.100551 41.699186,-96.100546 41.699185,-96.100474 41.699176,-96.100421 41.699169,-96.10038 41.699163,-96.100276 41.699147,-96.100238 41.699141,-96.100236 41.69914,-96.100229 41.699139,-96.100221 41.699138,-96.100195 41.699134,-96.099669 41.699051,-96.099663 41.69905,-96.0996 41.69904,-96.099518 41.699025,-96.0995 41.699022,-96.099396 41.699002,-96.098866 41.698898,-96.098559 41.698831,-96.098172 41.69878,-96.098165 41.698779,-96.098164 41.698778,-96.098162 41.698778,-96.098155 41.698777,-96.098141 41.698775,-96.098047 41.698761,-96.097887 41.698738,-96.097845 41.698732,-96.097595 41.698697,-96.097588 41.698696,-96.097567 41.698693,-96.097505 41.698683,-96.097431 41.698671,-96.097042 41.698609,-96.097025 41.698606,-96.097008 41.698603,-96.096387 41.698495,-96.096374 41.698493,-96.096367 41.698492,-96.096357 41.69849,-96.095984 41.698425,-96.095591 41.698344,-96.095541 41.698333,-96.095539 41.698333,-96.095538 41.698332,-96.095451 41.698313,-96.09515 41.698252,-96.094857 41.698189,-96.094707 41.698156,-96.094705 41.698156,-96.0947 41.698155,-96.094697 41.698154,-96.094688 41.698152,-96.093691 41.697934,-96.093333 41.697845,-96.093013 41.697781,-96.092888 41.697761,-96.092758 41.697737,-96.092731 41.697732,-96.092729 41.697731,-96.092723 41.69773,-96.092721 41.69773,-96.092628 41.697712,-96.092534 41.697697,-96.09251 41.697693,-96.092504 41.697692,-96.092502 41.697692,-96.092495 41.697691,-96.092445 41.697683,-96.092116 41.697633,-96.091997 41.697617,-96.091995 41.697617,-96.091994 41.697616,-96.091992 41.697616,-96.091711 41.697578,-96.0916 41.697564,-96.091569 41.69756,-96.091553 41.697558,-96.091551 41.697558,-96.09149 41.697551,-96.091183 41.697516,-96.091024 41.697503,-96.090991 41.6975,-96.090529 41.697456,-96.090072 41.697425,-96.089913 41.697415,-96.089908 41.697415,-96.089906 41.697414,-96.089904 41.697414,-96.089901 41.697414,-96.089851 41.697412,-96.089819 41.697411,-96.089817 41.697411,-96.089813 41.697411,-96.089781 41.69741,-96.089547 41.697401,-96.089271 41.69739,-96.088831 41.697382,-96.088773 41.697382,-96.088684 41.697382,-96.088682 41.697382,-96.088681 41.697383,-96.088678 41.697383,-96.088672 41.697383,-96.088661 41.697383,-96.088643 41.697383,-96.088619 41.697383,-96.088592 41.697383,-96.088545 41.697383,-96.088529 41.697383,-96.088513 41.697383,-96.088328 41.697383,-96.088247 41.697385,-96.087496 41.697409,-96.087491 41.697409,-96.087483 41.697409,-96.087139 41.69742,-96.086596 41.697467,-96.086576 41.697469,-96.086556 41.697471,-96.086317 41.697492,-96.086307 41.697493,-96.086301 41.697493,-96.086269 41.697496,-96.086123 41.697512,-96.086118 41.697513,-96.085643 41.697565,-96.085628 41.697567,-96.085625 41.697567,-96.085358 41.697596,-96.08486 41.697674,-96.084816 41.697681,-96.08464 41.697709,-96.084391 41.697755,-96.084083 41.697812,-96.084078 41.697813,-96.084076 41.697813,-96.083822 41.69786,-96.083719 41.697884,-96.083717 41.697885,-96.082618 41.698143,-96.082614 41.698144,-96.082612 41.698144,-96.082608 41.698145,-96.082353 41.698205,-96.081315 41.698513,-96.081049 41.698612,-96.081047 41.698613,-96.081046 41.698614,-96.081043 41.698615,-96.081037 41.698617,-96.079875 41.69905,-96.079764 41.699095,-96.079553 41.699185,-96.079257 41.699312,-96.079053 41.699398,-96.078707 41.699544,-96.078302 41.699727,-96.078207 41.699774,-96.077712 41.700022,-96.077331 41.700232,-96.07695 41.700457,-96.076598 41.70068,-96.076248 41.700918,-96.075909 41.701165,-96.075582 41.701421,-96.075267 41.701686,-96.074964 41.701958,-96.074675 41.702238,-96.074398 41.702526,-96.074135 41.70282,-96.073886 41.703122,-96.073651 41.703429,-96.073431 41.703743,-96.073225 41.704062,-96.073128 41.704472,-96.073075 41.704731,-96.072986 41.705251,-96.072922 41.705773,-96.072883 41.706296,-96.072876 41.706517,-96.072867 41.70682,-96.072877 41.707344,-96.0729 41.707736,-96.072936 41.708129,-96.073006 41.70865,-96.073034 41.708817,-96.07305 41.70891,-96.0731 41.709169,-96.073219 41.709686,-96.073287 41.709943,-96.073361 41.710199,-96.073441 41.710454,-96.073527 41.710708,-96.073717 41.711212,-96.07393 41.711711,-96.074046 41.711959,-96.074293 41.712449,-96.074568 41.712938,-96.074707 41.713171,-96.075011 41.713643,-96.075171 41.713876,-96.075508 41.714335,-96.075865 41.714785,-96.075922 41.714853,-96.076052 41.715007,-96.07644 41.715443,-96.076642 41.715657,-96.077061 41.716077,-96.077498 41.716485,-96.077955 41.716882,-96.07819 41.717076,-96.078674 41.717455,-96.078922 41.717639,-96.079432 41.717998,-96.079693 41.718173,-96.079958 41.718344,-96.080226 41.718511,-96.080776 41.718836,-96.081313 41.719171,-96.081849 41.719495,-96.081919 41.719536,-96.081989 41.719577,-96.082135 41.719662,-96.082408 41.719821,-96.082767 41.720023,-96.082967 41.720135,-96.083533 41.720441,-96.084219 41.720798,-96.084564 41.720969,-96.084584 41.720979,-96.084594 41.720984,-96.0846 41.720987,-96.084603 41.720988,-96.084609 41.720991,-96.084685 41.721029,-96.085272 41.721313,-96.085543 41.721439,-96.085653 41.72149,-96.085865 41.721589,-96.08647 41.72186,-96.087287 41.722207,-96.087691 41.722373,-96.088303 41.722615,-96.088656 41.722748,-96.089023 41.722887,-96.089435 41.723036,-96.089524 41.723068,-96.08954 41.723074,-96.089551 41.723078,-96.089554 41.723079,-96.09018 41.723295,-96.090821 41.723508,-96.091481 41.723717,-96.091947 41.723857,-96.091967 41.723863,-96.091993 41.723871,-96.092779 41.724098,-96.093113 41.724186,-96.093205 41.724211,-96.093579 41.72431,-96.093836 41.72438,-96.09463 41.724565,-96.09468 41.724577,-96.09472 41.724586,-96.094814 41.724608,-96.094909 41.72463,-96.094986 41.724648,-96.095062 41.724666,-96.095215 41.724707,-96.095667 41.724826,-96.096118 41.72495,-96.096564 41.725083,-96.097007 41.725219,-96.097711 41.725451,-96.097972 41.725541,-96.099057 41.725935,-96.099441 41.726086,-96.099818 41.726248,-96.100187 41.726419,-96.100547 41.726601,-96.100899 41.72679,-96.101241 41.72699,-96.101576 41.727199,-96.101899 41.727415,-96.101992 41.727482,-96.102212 41.727641,-96.102515 41.727875,-96.102807 41.728116,-96.103087 41.728365,-96.103356 41.728621,-96.103402 41.728668,-96.103407 41.728673,-96.103459 41.728726,-96.103511 41.72878,-96.103512 41.728781,-96.103514 41.728783,-96.103516 41.728785,-96.103519 41.728788,-96.10352 41.72879,-96.103522 41.728792,-96.103562 41.728837,-96.103614 41.728894,-96.103856 41.729154,-96.104088 41.72943,-96.104306 41.729711,-96.104511 41.729998,-96.104702 41.730291,-96.10488 41.730588,-96.105044 41.73089,-96.105194 41.731195,-96.105329 41.731505,-96.10545 41.731818,-96.105556 41.732133,-96.10563 41.73239,-96.105648 41.732452,-96.105688 41.732612,-96.105807 41.732963,-96.105893 41.73324,-96.105973 41.733518,-96.106113 41.734078,-96.106173 41.734358,-96.106273 41.734922,-96.106314 41.735205,-96.106375 41.735772,-96.106409 41.73634,-96.106417 41.736909,-96.106399 41.737478,-96.10638 41.737762,-96.106354 41.738046,-96.106282 41.738612,-96.106237 41.738894,-96.106185 41.739176,-96.106126 41.739457,-96.106061 41.739737,-96.105911 41.740295,-96.105826 41.740572,-96.105735 41.740848,-96.105651 41.741118,-96.105471 41.741546,-96.105469 41.741634,-96.105451 41.74168,-96.105334 41.74195,-96.105211 41.742219,-96.105082 41.742487,-96.104946 41.742753,-96.104805 41.743016,-96.104657 41.743278,-96.104494 41.743552,-96.104338 41.743805,-96.104006 41.744306,-96.103828 41.744557,-96.103443 41.745069,-96.10326 41.745297,-96.102853 41.745777,-96.102396 41.746236,-96.102173 41.746466,-96.101773 41.746857,-96.101583 41.747035,-96.101462 41.747149,-96.101242 41.747346,-96.101057 41.747506,-96.101042 41.747519,-96.101025 41.747534,-96.101012 41.747545,-96.100981 41.747572,-96.100685 41.747752,-96.100313 41.747964,-96.100268 41.747989,-96.099992 41.748134,-96.099973 41.748144,-96.099969 41.748146,-96.099968 41.748147,-96.099811 41.748229,-96.099612 41.748328,-96.099609 41.74833,-96.099606 41.748331,-96.099399 41.748434,-96.099386 41.74844,-96.099384 41.748441,-96.099381 41.748442,-96.098911 41.748657,-96.098866 41.748677,-96.098536 41.748815,-96.098007 41.749023,-96.097702 41.749105,-96.097603 41.749129,-96.097597 41.749131,-96.097595 41.749132,-96.097593 41.749132,-96.097437 41.749181,-96.097331 41.74922,-96.096187 41.749605,-96.096166 41.74961,-96.096158 41.749612,-96.096125 41.74962,-96.095962 41.749659,-96.095954 41.749661,-96.095378 41.749799,-96.09513 41.749853,-96.09507 41.749866,-96.094937 41.749888,-96.09486 41.7499,-96.094782 41.749913,-96.094653 41.749934,-96.094477 41.749977,-96.094465 41.74998,-96.09427 41.750013,-96.093731 41.750093,-96.093375 41.750161,-96.092966 41.750249,-96.092706 41.750305,-96.092375 41.750383,-96.092045 41.750466,-96.091392 41.750644,-96.091293 41.75067,-96.091193 41.750701,-96.091182 41.750704,-96.091069 41.750739,-96.090972 41.750769,-96.090874 41.750798,-96.090828 41.750814,-96.090819 41.750817,-96.090673 41.750869,-96.089803 41.75118,-96.089801 41.751181,-96.089797 41.751182,-96.089794 41.751183,-96.089772 41.751191,-96.089708 41.751214,-96.089285 41.751367,-96.089105 41.751431,-96.088807 41.751546,-96.088219 41.751786,-96.08793 41.751912,-96.087644 41.752042,-96.087361 41.752176,-96.086805 41.752456,-96.086531 41.752601,-96.086261 41.75275,-96.085996 41.752903,-96.085734 41.753059,-96.085221 41.753383,-96.084969 41.753549,-96.08448 41.753893,-96.084008 41.75425,-96.083552 41.754621,-96.083114 41.755002,-96.082903 41.755198,-96.082493 41.755597,-96.082102 41.756008,-96.08173 41.75643,-96.081379 41.756861,-96.081211 41.757081,-96.08089 41.757526,-96.080738 41.757752,-96.080591 41.757981,-96.080313 41.758442,-96.080182 41.758677,-96.080057 41.758912,-96.079823 41.75939,-96.079714 41.75963,-96.079514 41.760117,-96.079337 41.760609,-96.079257 41.760856,-96.079183 41.761105,-96.078772 41.761734,-96.078696 41.761851,-96.078637 41.761939,-96.078635 41.761945,-96.07863 41.761961,-96.078629 41.761963,-96.078497 41.762632,-96.078466 41.76306,-96.078444 41.763488,-96.078432 41.763918,-96.078431 41.764346,-96.07844 41.764775,-96.078466 41.765327,-96.07858 41.766557,-96.078629 41.766914,-96.078697 41.76734,-96.078775 41.767776,-96.078889 41.768938,-96.078929 41.769438,-96.078958 41.769711,-96.07896 41.769838,-96.078964 41.7699,-96.078996 41.770205,-96.079028 41.770593,-96.079039 41.770817,-96.07905 41.771124,-96.07905 41.771455,-96.07905 41.771676,-96.07905 41.771711,-96.07905 41.771737,-96.079039 41.772044,-96.079021 41.77235,-96.078996 41.772654,-96.078979 41.772818,-96.078973 41.772879,-96.078964 41.772962,-96.078925 41.773267,-96.078878 41.773572,-96.078825 41.773876,-96.078764 41.77418,-96.078697 41.774482,-96.078622 41.774784,-96.078452 41.775384,-96.078356 41.775682,-96.078253 41.775979,-96.078144 41.776275,-96.078028 41.776569,-96.077904 41.776861,-96.077564 41.776861,-96.077077 41.776861,-96.077065 41.776901,-96.077223 41.777165,-96.077375 41.7773,-96.077462 41.777377,-96.077546 41.777456,-96.077546 41.777822,-96.077252 41.778171,-96.077026 41.778439,-96.076824 41.778579,-96.076534 41.77908,-96.076469 41.779168,-96.0764 41.779261,-96.075932 41.779904,-96.075091 41.780896,-96.074229 41.781911,-96.073197 41.783008,-96.071871 41.784186,-96.070687 41.78517,-96.069772 41.785953,-96.068319 41.787162,-96.06723 41.788097,-96.067089 41.788272,-96.06703 41.788378,-96.066984 41.78846,-96.06697 41.788485,-96.066849 41.788478,-96.066754 41.788507,-96.066677 41.788601,-96.066409 41.788941,-96.066377 41.788981,-96.066111 41.789491,-96.065243 41.790934,-96.065049 41.791347,-96.064897 41.791673,-96.064863 41.791889,-96.064801 41.792447,-96.064765 41.793006,-96.064757 41.793286,-96.064761 41.793846,-96.064772 41.794126,-96.06479 41.794406,-96.064846 41.794964,-96.064883 41.795243,-96.064978 41.795798,-96.065035 41.796075,-96.065098 41.796351,-96.065168 41.796626,-96.065327 41.797173,-96.065416 41.797445,-96.065613 41.797985,-96.065721 41.798253,-96.065881 41.798623,-96.066138 41.799027,-96.066404 41.799428,-96.066679 41.799824,-96.066964 41.800218,-96.067257 41.800607,-96.06756 41.800993,-96.067872 41.801375,-96.068192 41.801752,-96.068522 41.802125,-96.06886 41.802494,-96.069269 41.802922,-96.069561 41.803218,-96.069924 41.803573,-96.070296 41.803924,-96.070676 41.804269,-96.071063 41.80461,-96.071459 41.804945,-96.071862 41.805275,-96.072273 41.8056,-96.072691 41.805919,-96.073117 41.806233,-96.07355 41.806541,-96.073991 41.806844,-96.074438 41.80714,-96.074892 41.807431,-96.075353 41.807716,-96.07582 41.807995,-96.076294 41.808268,-96.076774 41.808534,-96.07726 41.808794,-96.077753 41.809048,-96.078685 41.80948,-96.079463 41.80974,-96.080072 41.809987,-96.080073 41.809988,-96.080077 41.809989,-96.080161 41.810023,-96.080348 41.810065,-96.081192 41.810254,-96.082219 41.810563,-96.083322 41.810811,-96.085906 41.811237,-96.086438 41.811357,-96.08644 41.811357,-96.086442 41.811358,-96.086643 41.811403,-96.087161 41.811469,-96.087164 41.811469,-96.087169 41.81147,-96.087175 41.811471,-96.087447 41.811506,-96.087519 41.811524,-96.087523 41.811525,-96.088044 41.811659,-96.089136 41.811792,-96.090845 41.812159,-96.091911 41.812311,-96.091932 41.812314,-96.091975 41.812324,-96.092851 41.812521,-96.093006 41.812588,-96.093008 41.812589,-96.093431 41.812773,-96.093924 41.812918,-96.095273 41.813182,-96.096031 41.813493,-96.097038 41.813788,-96.097042 41.813789,-96.09748 41.813917,-96.097696 41.814042,-96.097698 41.814043,-96.097935 41.814181,-96.098639 41.814422,-96.098642 41.814423,-96.098644 41.814424,-96.098722 41.814451,-96.100885 41.815389,-96.101272 41.815603,-96.101538 41.81581,-96.102332 41.816215,-96.103566 41.817072,-96.104224 41.817663,-96.105336 41.81846,-96.106565 41.819613,-96.108714 41.822099,-96.109384 41.823135,-96.109746 41.823992,-96.11056 41.826548,-96.110831 41.827914,-96.110962 41.828827,-96.111005 41.829519,-96.11101 41.829606,-96.111017 41.829726,-96.111029 41.831022,-96.110967 41.831596,-96.110797 41.832157,-96.110155 41.833605,-96.109954 41.834144,-96.10969 41.834853,-96.109514 41.835193,-96.109378 41.835457,-96.10911 41.836043,-96.108969 41.83635,-96.108963 41.83636,-96.108272 41.837698,-96.108271 41.837699,-96.108269 41.837704,-96.108267 41.837709,-96.108265 41.837714,-96.108263 41.837719,-96.108262 41.837721,-96.108171 41.837898,-96.108106 41.838109,-96.108105 41.838112,-96.10794 41.838644,-96.107939 41.838646,-96.10778 41.83916,-96.107617 41.8404,-96.107669 41.841421,-96.107669 41.841423,-96.107669 41.841425,-96.107669 41.841427,-96.107669 41.84143,-96.107669 41.841436,-96.107681 41.841678,-96.107681 41.841682,-96.107685 41.841766,-96.107754 41.842175,-96.107757 41.842194,-96.107894 41.843014,-96.107894 41.843016,-96.107936 41.843266,-96.108287 41.844535,-96.108501 41.845126,-96.108502 41.845127,-96.108503 41.845131,-96.108504 41.845134,-96.108704 41.845687,-96.109312 41.847128,-96.110548 41.849199,-96.111252 41.850229,-96.111631 41.850688,-96.112464 41.851571,-96.11451 41.853572,-96.115498 41.854348,-96.116597 41.855103,-96.120152 41.857188,-96.122354 41.858001,-96.124984 41.858892,-96.125366 41.859095,-96.125367 41.859096,-96.125369 41.859097,-96.125688 41.859266,-96.1312 41.861426,-96.132615 41.862053,-96.13496 41.863252,-96.136525 41.864151,-96.138381 41.865683,-96.138939 41.866212,-96.139008 41.866277,-96.13948 41.8668,-96.140417 41.86784,-96.140982 41.868279,-96.141539 41.868712,-96.141908 41.868999,-96.142694 41.869851,-96.143133 41.870328,-96.144359 41.871971,-96.145026 41.873433,-96.145312 41.873935,-96.145974 41.875093,-96.14605 41.875377,-96.146554 41.877244,-96.14666 41.877636,-96.146763 41.878634,-96.146755 41.880276,-96.146801 41.881998,-96.146927 41.883019,-96.146956 41.883254,-96.147292 41.884896,-96.1473 41.884917,-96.147319 41.884967,-96.147349 41.885043,-96.147379 41.885118,-96.147399 41.885169,-96.147491 41.885405,-96.14777 41.886114,-96.147772 41.88612,-96.147864 41.886351,-96.147919 41.886492,-96.148004 41.886706,-96.148087 41.886918,-96.148144 41.88706,-96.148186 41.887166,-96.148286 41.88734,-96.148757 41.888161,-96.148783 41.888205,-96.148942 41.888417,-96.149641 41.889351,-96.149874 41.889662,-96.150986 41.890934,-96.151979 41.891956,-96.152153 41.892135,-96.152881 41.892694,-96.153049 41.892823,-96.153556 41.893211,-96.1536 41.893245,-96.15372 41.893348,-96.153776 41.893396,-96.153862 41.893469,-96.153947 41.893541,-96.154004 41.89359,-96.154918 41.894368,-96.155198 41.894607,-96.156719 41.895806,-96.157668 41.89669,-96.158198 41.897184,-96.158521 41.897535,-96.158757 41.897791,-96.158926 41.897974,-96.159333 41.898411,-96.159451 41.898536,-96.159471 41.898559,-96.159643 41.898754,-96.1597 41.898823,-96.1602 41.89944,-96.161101 41.900551,-96.161538 41.901398,-96.161756 41.90182,-96.161835 41.902131,-96.162024 41.902881,-96.162067 41.903047,-96.16209 41.904022,-96.162011 41.905194,-96.161988 41.905553,-96.161841 41.90594,-96.161737 41.906214,-96.161501 41.906839,-96.16139 41.90702,-96.161238 41.907271,-96.161193 41.907344,-96.161058 41.907564,-96.161014 41.907638,-96.160943 41.907753,-96.160767 41.908044,-96.160728 41.908098,-96.160649 41.908208,-96.160013 41.909095,-96.159098 41.910057,-96.158617 41.910377,-96.15784 41.910896,-96.156302 41.91166,-96.154301 41.912421,-96.152582 41.912894,-96.150213 41.913361,-96.149332 41.913536,-96.14726 41.913862,-96.147193 41.91388,-96.147094 41.913908,-96.146994 41.913935,-96.146928 41.913954,-96.14669 41.91402,-96.146334 41.914119,-96.145976 41.914217,-96.145739 41.914283,-96.145702 41.914293,-96.145648 41.91431,-96.145592 41.914324,-96.145556 41.914334,-96.14459 41.914603,-96.144364 41.914678,-96.142265 41.915379,-96.140946 41.916115,-96.139863 41.91672,-96.139653 41.916838,-96.139275 41.917238,-96.1383 41.918273,-96.13776 41.919054,-96.137359 41.919637,-96.137321 41.919711,-96.136848 41.920622,-96.136743 41.920826,-96.136133 41.92353,-96.136134 41.923608,-96.136155 41.924635,-96.136158 41.92477,-96.136167 41.925175,-96.13617 41.925311,-96.136246 41.925631,-96.136362 41.926114,-96.136476 41.926594,-96.136553 41.926916,-96.136571 41.926993,-96.136613 41.927167,-96.136641 41.92722,-96.13668 41.92729,-96.137299 41.92842,-96.137672 41.9291,-96.1395 41.931529,-96.139526 41.931572,-96.140192 41.932676,-96.140278 41.932819,-96.140486 41.933163,-96.140549 41.933244,-96.140654 41.933376,-96.141869 41.93492,-96.142034 41.935173,-96.142718 41.936222,-96.143493 41.937387,-96.144041 41.93868,-96.14448 41.940013,-96.14457 41.941351,-96.144583 41.941544,-96.144368 41.942478,-96.143975 41.943522,-96.14366 41.944358,-96.143603 41.944512,-96.142597 41.945908,-96.141965 41.946393,-96.14164 41.946644,-96.141243 41.946918,-96.140988 41.947093,-96.140413 41.947491,-96.140223 41.947614,-96.139964 41.947782,-96.139745 41.947923,-96.139414 41.948138,-96.139173 41.948437,-96.139011 41.94864,-96.138803 41.948899,-96.138781 41.948926,-96.1381 41.949791,-96.137873 41.95008,-96.137743 41.950247,-96.137242 41.950641,-96.137076 41.950773,-96.137027 41.950798,-96.13695 41.95084,-96.136881 41.950876,-96.136833 41.950903,-96.136699 41.950968,-96.136658 41.951003,-96.136227 41.951383,-96.136203 41.951409,-96.136067 41.95156,-96.135876 41.951746,-96.135393 41.952223,-96.135334 41.952328,-96.135205 41.952562,-96.134997 41.952938,-96.134979 41.952966,-96.134241 41.954126,-96.134233 41.954138,-96.134 41.954539,-96.133476 41.955454,-96.133318 41.955732,-96.132293 41.958382,-96.131913 41.959366,-96.131742 41.959808,-96.131578 41.960234,-96.131368 41.960741,-96.131088 41.961053,-96.131034 41.961114,-96.130772 41.961407,-96.13064 41.961603,-96.130442 41.9619,-96.13025 41.962198,-96.130123 41.962398,-96.129978 41.962642,-96.129727 41.96343,-96.129186 41.965136,-96.12908 41.965973,-96.129037 41.96667,-96.128975 41.967689,-96.128971 41.967779,-96.128969 41.967797,-96.128967 41.967852,-96.128967 41.967871,-96.128933 41.968656,-96.128925 41.968883,-96.128902 41.96965,-96.1289 41.969727,-96.129254 41.97093,-96.129505 41.971673,-96.129877 41.972199,-96.130355 41.972863,-96.1312 41.97361,-96.131702 41.974,-96.132077 41.974292,-96.132537 41.974625,-96.133203 41.974944,-96.133321 41.97499,-96.133675 41.975128,-96.133794 41.975174,-96.135151 41.975701,-96.139223 41.977285,-96.140338 41.977719,-96.140581 41.977813,-96.140685 41.977852,-96.140842 41.977913,-96.140998 41.977971,-96.141103 41.978011,-96.141229 41.978063,-96.142715 41.978491,-96.144068 41.978645,-96.144439 41.978688,-96.147035 41.97905,-96.149977 41.979414,-96.15209 41.979661,-96.153136 41.979734,-96.154355 41.979819,-96.15616 41.980082,-96.156559 41.980141,-96.157212 41.980199,-96.158049 41.980275,-96.160382 41.980133,-96.160683 41.980115,-96.161437 41.980037,-96.161999 41.979978,-96.163338 41.979839,-96.16368 41.979769,-96.164234 41.979658,-96.165492 41.979404,-96.165716 41.97936,-96.168074 41.978996,-96.169285 41.978738,-96.170542 41.978472,-96.171888 41.977837,-96.173315 41.977189,-96.174154 41.976864,-96.174827 41.97671,-96.177204 41.976308,-96.177777 41.976298,-96.179567 41.976284,-96.18105 41.976365,-96.181945 41.976412,-96.182224 41.976436,-96.183179 41.976571,-96.183537 41.976663,-96.183909 41.976719,-96.184164 41.976793,-96.187219 41.977946,-96.188746 41.979027,-96.189052 41.979264,-96.189099 41.979301,-96.18925 41.979417,-96.189413 41.979542,-96.189546 41.97965,-96.189724 41.979831,-96.189781 41.979889,-96.190049 41.98016,-96.190476 41.980593,-96.190608 41.980729,-96.190802 41.980998,-96.191029 41.981312,-96.191326 41.981724,-96.191549 41.982032,-96.192141 41.984461,-96.191971 41.985347,-96.191567 41.986061,-96.191146 41.986745,-96.19037 41.987964,-96.190245 41.98816,-96.19006 41.988454,-96.189871 41.988751,-96.189747 41.988948,-96.18963 41.989134,-96.189517 41.989315,-96.189238 41.989664,-96.189102 41.989836,-96.188786 41.990238,-96.188389 41.990757,-96.187605 41.991786,-96.186427 41.993076,-96.186156 41.993441,-96.185573 41.994232,-96.185474 41.994385,-96.185407 41.994487,-96.18521 41.994795,-96.185144 41.994898,-96.184784 41.99546,-96.184255 41.996634,-96.183801 41.99776,-96.183627 41.99904,-96.183608 41.99999,-96.184188 42.001606,-96.184318 42.001831,-96.184327 42.001853,-96.184361 42.001938,-96.184465 42.002193,-96.1845 42.002279,-96.18422 42.002543,-96.184002 42.003063,-96.184258 42.003686,-96.184378 42.003978,-96.18462 42.004578,-96.184711 42.004972,-96.185249 42.005467,-96.185919 42.005914,-96.186823 42.00633,-96.187522 42.006626,-96.18773 42.006656,-96.189336 42.00689,-96.189553 42.006987,-96.189766 42.007082,-96.190207 42.007278,-96.190425 42.007376,-96.190819 42.007552,-96.190913 42.007579,-96.192436 42.008032,-96.192944 42.008183,-96.193002 42.0082,-96.193178 42.008252,-96.193237 42.00827,-96.193313 42.008292,-96.193544 42.008361,-96.193621 42.008384,-96.193714 42.008411,-96.193993 42.008495,-96.194086 42.008523,-96.194556 42.008662,-96.194838 42.008671,-96.200816 42.009196,-96.201487 42.009343,-96.203615 42.009304,-96.204042 42.009309,-96.205032 42.009289,-96.206083 42.009267,-96.207051 42.009064,-96.208486 42.008762,-96.210057 42.008432,-96.212703 42.007533,-96.213317 42.007325,-96.214095 42.007071,-96.215225 42.006701,-96.216496 42.005302,-96.216557 42.005236,-96.217637 42.003862,-96.219867 41.999987,-96.220503 41.999115,-96.22119 41.998152,-96.22161 41.997631,-96.221812 41.997382,-96.222641 41.996451,-96.223369 41.995931,-96.223827 41.995517,-96.223895 41.995457,-96.223964 41.995424,-96.224419 41.995215,-96.224571 41.995145,-96.224812 41.995033,-96.225463 41.994734,-96.225543 41.994715,-96.225802 41.994654,-96.226094 41.994584,-96.226973 41.994378,-96.227172 41.994332,-96.227269 41.994326,-96.227335 41.994321,-96.227436 41.994316,-96.227536 41.994309,-96.227603 41.994305,-96.227706 41.994298,-96.228015 41.994278,-96.228119 41.994272,-96.228197 41.994266,-96.228349 41.994257,-96.228431 41.994266,-96.22851 41.994275,-96.228646 41.99429,-96.229055 41.994335,-96.229192 41.99435,-96.229404 41.994373,-96.229739 41.99441,-96.230037 41.994465,-96.230247 41.994504,-96.230416 41.994535,-96.230671 41.994584,-96.230925 41.994631,-96.231095 41.994663,-96.231215 41.994687,-96.231395 41.994725,-96.231575 41.994761,-96.231696 41.994786,-96.231751 41.994801,-96.23325 41.995178,-96.233878 41.995384,-96.234952 41.995736,-96.236488 41.996429,-96.238183 41.99755,-96.239748 41.998605,-96.239795 41.998641,-96.240713 41.999351,-96.241372 41.999987,-96.241482 42.00014,-96.242035 42.000911,-96.242142 42.001315,-96.242323 42.001996,-96.24238 42.002898,-96.242351 42.004106,-96.242189 42.005382,-96.242162 42.005602,-96.241972 42.006732,-96.24192 42.006963,-96.24144 42.008015,-96.240832 42.009315,-96.239748 42.010889,-96.239303 42.011603,-96.23886 42.012315,-96.238382 42.012602,-96.23818 42.012722,-96.237576 42.013086,-96.237375 42.013207,-96.237365 42.013212,-96.237338 42.013229,-96.237329 42.013235,-96.23711 42.013366,-96.236702 42.013612,-96.236452 42.013755,-96.236232 42.013883,-96.236081 42.013969,-96.23563 42.014231,-96.23548 42.014318,-96.23433 42.014983,-96.232317 42.016148,-96.23087 42.016961,-96.229713 42.017613,-96.22872 42.018171,-96.227867 42.018651,-96.22603 42.020255,-96.225173 42.021005,-96.225007 42.021187,-96.224511 42.021737,-96.224346 42.02192,-96.224198 42.022066,-96.223758 42.022505,-96.223611 42.022652,-96.223101 42.023404,-96.222823 42.023817,-96.221895 42.025844,-96.22173 42.026205,-96.221747 42.026717,-96.22183 42.028262,-96.221901 42.029558,-96.222436 42.030946,-96.223364 42.032554,-96.223822 42.033346,-96.224266 42.033798,-96.224958 42.034505,-96.225656 42.035217,-96.227296 42.036315,-96.227561 42.036493,-96.22816 42.036798,-96.228258 42.036848,-96.228554 42.036999,-96.228653 42.03705,-96.228933 42.037193,-96.22907 42.037288,-96.230143 42.03803,-96.230267 42.038097,-96.230691 42.038328,-96.230973 42.038489,-96.231398 42.038732,-96.231821 42.038974,-96.232104 42.039137,-96.232356 42.039242,-96.232728 42.039398,-96.233112 42.039559,-96.233365 42.039665,-96.233447 42.039688,-96.233571 42.039723,-96.233693 42.039757,-96.233776 42.039781,-96.234027 42.039852,-96.234405 42.039959,-96.234782 42.040065,-96.235034 42.040137,-96.234747 42.040072,-96.23463 42.04004,-96.234021 42.039874,-96.233836 42.039834,-96.233764 42.039823,-96.233504 42.03978,-96.233418 42.039756,-96.233369 42.039743,-96.233151 42.039668,-96.233027 42.039618,-96.232911 42.039571,-96.232852 42.039548,-96.232568 42.03942,-96.232454 42.03937,-96.232256 42.039485,-96.232113 42.039457,-96.23194 42.039404,-96.231699 42.039296,-96.231577 42.039192,-96.231406 42.03914,-96.230775 42.039013,-96.230329 42.038923,-96.230156 42.038871,-96.229993 42.038801,-96.229844 42.038717,-96.229438 42.038429,-96.229005 42.038162,-96.228576 42.037893,-96.228183 42.037596,-96.228001 42.03743,-96.227877 42.037342,-96.227868 42.037328,-96.227871 42.037319,-96.227887 42.037311,-96.22785 42.037291,-96.227808 42.037278,-96.227761 42.037273,-96.227612 42.037273,-96.22742 42.037249,-96.227324 42.037249,-96.227229 42.037264,-96.227185 42.037278,-96.227064 42.037339,-96.227018 42.037349,-96.226977 42.037353,-96.228261 42.038302,-96.229426 42.038866,-96.230253 42.039433,-96.231294 42.039815,-96.233812 42.040553,-96.233954 42.040594,-96.234356 42.040712,-96.234969 42.040778,-96.238392 42.041088,-96.238822 42.041123,-96.24287 42.041455,-96.243104 42.041474,-96.246832 42.041616,-96.248411 42.041207,-96.248764 42.041116,-96.249754 42.040859,-96.250299 42.040718,-96.250662 42.040697,-96.251707 42.040446,-96.252696 42.040039,-96.253019 42.039907,-96.253635 42.039631,-96.254057 42.03952,-96.254489 42.039408,-96.25522 42.038945,-96.25559 42.038712,-96.255711 42.038625,-96.255719 42.038618,-96.256082 42.038305,-96.256203 42.038201,-96.256575 42.03822,-96.257068 42.038247,-96.257694 42.038263,-96.258067 42.038274,-96.258356 42.038338,-96.259223 42.038532,-96.259512 42.038597,-96.259915 42.038687,-96.260358 42.038786,-96.261116 42.038989,-96.261516 42.039097,-96.261663 42.039136,-96.262106 42.039255,-96.262254 42.039295,-96.263448 42.039616,-96.264247 42.039891,-96.265332 42.040266,-96.267195 42.04119,-96.268063 42.041705,-96.269684 42.042893,-96.269785 42.042967,-96.271146 42.044373,-96.271576 42.044904,-96.271969 42.04539,-96.272545 42.046202,-96.272767 42.046571,-96.27312 42.047158,-96.273139 42.04728,-96.273798 42.048283,-96.274393 42.049244,-96.274856 42.050118,-96.274908 42.050215,-96.276213 42.053215,-96.277202 42.056025,-96.277732 42.05753,-96.277907 42.058025,-96.278043 42.058412,-96.278646 42.06117,-96.278838 42.062049,-96.279211 42.064155,-96.279379 42.065495,-96.279536 42.068554,-96.27948 42.070804,-96.279479 42.07088,-96.279201 42.073544,-96.279086 42.07401,-96.278494 42.076404,-96.278484 42.076448,-96.277732 42.079097,-96.276753 42.081696,-96.275982 42.083346,-96.275798 42.083743,-96.274608 42.085386,-96.274559 42.085454,-96.274296 42.085779,-96.273688 42.086534,-96.273341 42.086941,-96.273333 42.086952,-96.273117 42.08739,-96.273045 42.087657,-96.272962 42.087777,-96.272246 42.088825,-96.272168 42.08894,-96.271998 42.089167,-96.271656 42.089621,-96.271492 42.089837,-96.270798 42.090761,-96.270652 42.090998,-96.270355 42.091483,-96.270181 42.091765,-96.26977 42.092437,-96.269677 42.092622,-96.26953 42.09292,-96.269129 42.093728,-96.26838 42.09524,-96.268039 42.096203,-96.267739 42.097055,-96.267439 42.098407,-96.267303 42.099027,-96.266898 42.102178,-96.266893 42.102522,-96.266875 42.103798,-96.26688 42.103907,-96.266972 42.105846,-96.266988 42.106172,-96.267313 42.10889,-96.267486 42.10978,-96.268126 42.111519,-96.26815 42.111585,-96.268618 42.112622,-96.268921 42.113291,-96.269156 42.113695,-96.269459 42.114216,-96.269909 42.114879,-96.270173 42.115267,-96.270376 42.115567,-96.270877 42.116304,-96.270995 42.116461,-96.271213 42.116752,-96.271467 42.117089,-96.272005 42.117695,-96.273001 42.118818,-96.273411 42.11928,-96.27458 42.120334,-96.274584 42.120337,-96.275575 42.121071,-96.276217 42.121547,-96.2764 42.121682,-96.277927 42.122623,-96.278265 42.122795,-96.278978 42.123159,-96.279348 42.123348,-96.2802 42.123783,-96.28047 42.123894,-96.280855 42.124054,-96.281242 42.124214,-96.282218 42.124619,-96.282398 42.124713,-96.28277 42.124909,-96.283002 42.125031,-96.283064 42.125044,-96.283604 42.125164,-96.28401 42.125296,-96.284321 42.125397,-96.285004 42.125618,-96.285952 42.125926,-96.286647 42.126,-96.287106 42.125992,-96.287564 42.125986,-96.287824 42.126007,-96.28791 42.126013,-96.288044 42.126024,-96.288165 42.126054,-96.28825 42.126075,-96.288959 42.126251,-96.289301 42.126292,-96.289532 42.126321,-96.290322 42.126497,-96.290998 42.126485,-96.292148 42.126598,-96.292501 42.126617,-96.293576 42.126675,-96.293861 42.12669,-96.294608 42.12673,-96.294714 42.126759,-96.29499 42.126835,-96.295331 42.126928,-96.295437 42.126988,-96.296035 42.127324,-96.296774 42.127387,-96.297249 42.127429,-96.29807 42.127499,-96.298245 42.127515,-96.299307 42.127552,-96.300154 42.127696,-96.300515 42.127806,-96.300959 42.127941,-96.301299 42.128065,-96.301304 42.128066,-96.30132 42.128072,-96.301326 42.128074,-96.301567 42.128162,-96.302292 42.128426,-96.302534 42.128514,-96.303309 42.128796,-96.303435 42.128842,-96.303989 42.12897,-96.305012 42.129295,-96.305658 42.12956,-96.305731 42.12959,-96.306384 42.129952,-96.308103 42.131058,-96.308681 42.131467,-96.309119 42.131778,-96.309758 42.132101,-96.310355 42.132572,-96.310695 42.132963,-96.311187 42.133308,-96.311612 42.133699,-96.311857 42.134009,-96.312624 42.134655,-96.312909 42.13503,-96.313062 42.135427,-96.314046 42.136449,-96.314488 42.137157,-96.31482 42.137688,-96.315173 42.13851,-96.315585 42.139672,-96.315728 42.140075,-96.315783 42.140282,-96.315925 42.140816,-96.316157 42.141211,-96.316384 42.141947,-96.316465 42.14207,-96.316821 42.142606,-96.316896 42.142784,-96.317121 42.14332,-96.317196 42.143499,-96.317252 42.143633,-96.317282 42.143702,-96.317493 42.143997,-96.317509 42.144019,-96.317597 42.1441,-96.317746 42.144238,-96.317812 42.1443,-96.318058 42.144758,-96.318155 42.144938,-96.318233 42.145084,-96.318333 42.145268,-96.318525 42.145483,-96.318574 42.145537,-96.318648 42.145595,-96.318797 42.145712,-96.318874 42.145772,-96.319144 42.146161,-96.319253 42.146318,-96.319406 42.146539,-96.31956 42.146761,-96.319991 42.147084,-96.320207 42.147246,-96.32074 42.147928,-96.320972 42.148114,-96.321069 42.148192,-96.321596 42.148507,-96.322349 42.149299,-96.322668 42.149519,-96.323148 42.149758,-96.323688 42.150259,-96.323993 42.150542,-96.324672 42.150855,-96.325302 42.151309,-96.325506 42.151456,-96.326415 42.151992,-96.326855 42.152324,-96.32731 42.152447,-96.32806 42.15265,-96.328388 42.152738,-96.328763 42.15284,-96.329333 42.153109,-96.329641 42.153255,-96.329818 42.153339,-96.330381 42.153444,-96.331017 42.153621,-96.331286 42.153697,-96.331773 42.153931,-96.332213 42.154279,-96.333303 42.154567,-96.334899 42.155311,-96.334918 42.155314,-96.33546 42.155419,-96.3363 42.155674,-96.336816 42.155997,-96.337202 42.156452,-96.338025 42.156796,-96.338755 42.157101,-96.339062 42.157331,-96.339305 42.157599,-96.340228 42.158057,-96.340709 42.158505,-96.341571 42.15908,-96.341904 42.159432,-96.342146 42.159938,-96.342666 42.1602,-96.342997 42.160438,-96.343013 42.16045,-96.343614 42.161012,-96.343901 42.161504,-96.344248 42.161754,-96.344431 42.161937,-96.344537 42.162043,-96.344905 42.162376,-96.345177 42.162874,-96.345666 42.163318,-96.346019 42.163789,-96.346203 42.164195,-96.346275 42.164268,-96.346688 42.164686,-96.347084 42.165302,-96.347215 42.165758,-96.347863 42.16664,-96.348015 42.167164,-96.348303 42.167496,-96.348602 42.168027,-96.348712 42.168486,-96.349168 42.169317,-96.349243 42.169815,-96.349688 42.170702,-96.349717 42.171526,-96.350043 42.172267,-96.350063 42.172312,-96.350145 42.17263,-96.350167 42.173205,-96.350101 42.173671,-96.350422 42.175227,-96.35039 42.175469,-96.350312 42.176076,-96.350319 42.176197,-96.350334 42.176442,-96.350343 42.176605,-96.350361 42.176903,-96.350343 42.177095,-96.350329 42.177259,-96.350321 42.177338,-96.350301 42.177575,-96.350294 42.177654,-96.350268 42.177943,-96.350242 42.178029,-96.349922 42.179102,-96.349911 42.179123,-96.349746 42.179466,-96.349676 42.179609,-96.349537 42.179899,-96.349521 42.180055,-96.349506 42.180214,-96.349469 42.180579,-96.349277 42.180908,-96.349206 42.181176,-96.349156 42.181366,-96.348742 42.18221,-96.348626 42.182633,-96.348261 42.183099,-96.348095 42.183398,-96.347936 42.183942,-96.347911 42.18403,-96.34786 42.184496,-96.347598 42.184881,-96.347493 42.185172,-96.347278 42.185774,-96.347251 42.186063,-96.347245 42.186132,-96.347279 42.186371,-96.347306 42.18656,-96.347307 42.186562,-96.347169 42.187119,-96.347123 42.187306,-96.346929 42.188089,-96.346914 42.18815,-96.346944 42.188545,-96.347083 42.189035,-96.346909 42.189996,-96.346927 42.190472,-96.346934 42.190643,-96.347043 42.191066,-96.347149 42.191235,-96.347206 42.191328,-96.347287 42.191457,-96.347278 42.191774,-96.347265 42.192324,-96.347374 42.193075,-96.347543 42.19347,-96.347565 42.193519,-96.347929 42.193899,-96.348097 42.194074,-96.348151 42.194195,-96.34818 42.194258,-96.348347 42.194821,-96.348374 42.19529,-96.348397 42.195665,-96.348406 42.195827,-96.348426 42.195925,-96.348474 42.196146,-96.348764 42.196627,-96.348829 42.196735,-96.348933 42.196824,-96.349057 42.196931,-96.349208 42.19706,-96.349288 42.197344,-96.349334 42.197503,-96.349411 42.197774,-96.349428 42.197834,-96.349567 42.198141,-96.349829 42.198484,-96.349841 42.198493,-96.350062 42.19867,-96.350191 42.198773,-96.350217 42.198809,-96.350583 42.199322,-96.350623 42.199377,-96.350693 42.199501,-96.35076 42.199619,-96.350961 42.199973,-96.351028 42.200092,-96.351109 42.200235,-96.351203 42.200401,-96.351427 42.200606,-96.351549 42.200718,-96.351656 42.200816,-96.351659 42.200818,-96.351935 42.201153,-96.352028 42.201266,-96.352259 42.201489,-96.352953 42.202161,-96.353119 42.202322,-96.353177 42.202393,-96.353394 42.20266,-96.35396 42.203053,-96.354025 42.203118,-96.354505 42.203603,-96.355075 42.20399,-96.355621 42.204494,-96.355919 42.204944,-96.356354 42.20523,-96.356506 42.205363,-96.357041 42.205832,-96.357249 42.206191,-96.357331 42.206333,-96.357639 42.206662,-96.357938 42.206982,-96.358182 42.207334,-96.358301 42.207608,-96.358723 42.208142,-96.358741 42.208165,-96.359029 42.208676,-96.359078 42.208762,-96.359155 42.209029,-96.359159 42.209043,-96.359551 42.209579,-96.359678 42.210016,-96.359714 42.21014,-96.359776 42.210249,-96.359837 42.210357,-96.35987 42.210553,-96.359813 42.21074,-96.35967 42.211213,-96.359345 42.21182,-96.35916 42.212168,-96.358888 42.212682,-96.358146 42.214086,-96.358007 42.21416,-96.357495 42.214436,-96.357469 42.214456,-96.357394 42.214519,-96.357369 42.21454,-96.35735 42.214551,-96.357296 42.214586,-96.357278 42.214598,-96.357264 42.214603,-96.357226 42.214621,-96.357213 42.214627,-96.357213 42.21464,-96.357213 42.21468,-96.357213 42.214694,-96.357171 42.214726,-96.357046 42.214825,-96.357005 42.214859,-96.356963 42.214872,-96.356839 42.214912,-96.356798 42.214926,-96.35675 42.21494,-96.356607 42.214986,-96.35656 42.215002,-96.356591 42.215182,-96.35558 42.215466,-96.35419 42.215714,-96.35326 42.215806,-96.352934 42.215837,-96.352606 42.215868,-96.352324 42.215895,-96.351697 42.215967,-96.351413 42.216014,-96.35062 42.216117,-96.350476 42.216153,-96.350338 42.216187,-96.3502 42.216221,-96.350155 42.216232,-96.350079 42.216251,-96.349143 42.216481,-96.345033 42.217495,-96.337025 42.217463,-96.336998 42.217466,-96.336767 42.217632,-96.336744 42.217674,-96.336598 42.217754,-96.33614 42.218084,-96.335766 42.218354,-96.335528 42.218517,-96.335355 42.21864,-96.335197 42.218737,-96.335043 42.218764,-96.334869 42.218862,-96.334402 42.21927,-96.334361 42.219339,-96.334307 42.219587,-96.334179 42.219872,-96.334052 42.21995,-96.333871 42.220102,-96.333118 42.220781,-96.332648 42.221101,-96.332511 42.221215,-96.332339 42.221318,-96.331149 42.222527,-96.330151 42.223361,-96.330041 42.223485,-96.329456 42.224256,-96.329269 42.224503,-96.329095 42.224733,-96.329003 42.224852,-96.32891 42.224959,-96.328802 42.224926,-96.328521 42.225378,-96.328308 42.225722,-96.328182 42.225795,-96.327368 42.226712,-96.327329 42.22676,-96.327251 42.226843,-96.327051 42.227082,-96.327013 42.227154,-96.326562 42.227862,-96.326256 42.228357,-96.326164 42.228448,-96.325949 42.228661,-96.324924 42.229057,-96.324792 42.229107,-96.32474 42.229128,-96.324546 42.229272,-96.323746 42.22987,-96.323723 42.229887,-96.323531 42.230246,-96.32344 42.230389,-96.323432 42.230436,-96.323368 42.230666,-96.323248 42.230666,-96.322904 42.231296,-96.322902 42.2313,-96.322827 42.231461,-96.32289 42.231655,-96.323054 42.232132,-96.322977 42.232245,-96.322793 42.232522,-96.322761 42.232564,-96.322794 42.23289,-96.322868 42.233637,-96.323032 42.23379,-96.323694 42.234409,-96.323926 42.23495,-96.324572 42.235342,-96.326423 42.236556,-96.326753 42.236949,-96.327016 42.237228,-96.3271 42.237318,-96.327387 42.237628,-96.327893 42.23816,-96.329243 42.23926,-96.329529 42.239461,-96.329545 42.239443,-96.32987 42.239748,-96.330006 42.240225,-96.329763 42.240625,-96.329693 42.241011,-96.329189 42.24158,-96.328958 42.241885,-96.328729 42.242996,-96.32861 42.243456,-96.328364 42.244453,-96.328093 42.245736,-96.328009 42.247082,-96.327982 42.248537,-96.327928 42.248818,-96.327817 42.249405,-96.327706 42.249992,-96.328897 42.254723,-96.331312 42.259408,-96.331991 42.26019,-96.332012 42.260214,-96.335964 42.264777,-96.33829 42.266615,-96.338336 42.266651,-96.339045 42.267212,-96.339801 42.26781,-96.339851 42.26785,-96.341387 42.269087,-96.342912 42.269787,-96.342977 42.269818,-96.342981 42.26982,-96.34905 42.272609,-96.349642 42.27292,-96.349708 42.272955,-96.349723 42.272963,-96.352923 42.274652,-96.355694 42.276115,-96.356023 42.276304,-96.356056 42.276326,-96.35626 42.276448,-96.356366 42.27648,-96.356395 42.276494,-96.356501 42.276562,-96.35655 42.276594,-96.360502 42.27961,-96.360732 42.279786,-96.361015 42.280089,-96.363009 42.282218,-96.365751 42.285814,-96.367453 42.28941,-96.367977 42.290681,-96.368005 42.290779,-96.368026 42.29085,-96.368467 42.292619,-96.36849 42.292822,-96.368514 42.293044,-96.368517 42.2931,-96.368721 42.296599,-96.368723 42.29662,-96.368585 42.301104,-96.368507 42.303622,-96.368675 42.304748,-96.369212 42.308344,-96.369402 42.308983,-96.369969 42.310878,-96.37179 42.314172,-96.373563 42.316189,-96.375307 42.318339,-96.379484 42.322197,-96.384169 42.325874,-96.385717 42.326511,-96.387274 42.327152,-96.390197 42.328354,-96.391863 42.329041,-96.396269 42.330857,-96.40255 42.333955,-96.402957 42.334156,-96.405124 42.335554,-96.40576 42.335964,-96.407979 42.337396,-96.407998 42.337408,-96.411867 42.341335,-96.411956 42.341425,-96.413895 42.343393,-96.415214 42.345936,-96.415251 42.346007,-96.415631 42.34674,-96.415738 42.346947,-96.416194 42.347826,-96.416344 42.348115,-96.417786 42.351449,-96.418168 42.354678,-96.417918 42.3587,-96.417093 42.361443,-96.416858 42.361784,-96.415073 42.364369,-96.413994 42.365932,-96.413887 42.366114,-96.41377 42.366312,-96.411451 42.370249,-96.40959 42.373967,-96.409396 42.374198,-96.40873 42.374993,-96.408436 42.376092,-96.408428 42.37779,-96.408519 42.378551,-96.408532 42.379078,-96.408687 42.379757,-96.409153 42.381491,-96.409539 42.382428,-96.40981 42.383084,-96.410328 42.384258,-96.410663 42.385018,-96.411124 42.38606,-96.411277 42.386305,-96.411752 42.387068,-96.412504 42.388521,-96.413257 42.389927,-96.414074 42.391193,-96.414606 42.392247,-96.41498 42.393442,-96.415348 42.395784,-96.415393 42.396276,-96.415483 42.397294,-96.415554 42.398899,-96.415509 42.400294,-96.415186 42.404203,-96.413609 42.407894,-96.411194 42.411485,-96.411262 42.411563,-96.410307 42.412965,-96.407383 42.415945,-96.403238 42.419181,-96.398808 42.422494,-96.397905 42.4233,-96.396967 42.424138,-96.396814 42.424274,-96.387608 42.432494,-96.384307 42.437294,-96.380705 42.446393,-96.380662 42.446749,-96.38066 42.446768,-96.380656 42.4468,-96.380648 42.446871,-96.380648 42.446873,-96.380629 42.447035,-96.380398 42.448999,-96.380105 42.451494,-96.380574 42.455994,-96.380905 42.459195,-96.381305 42.461695,-96.385407 42.473094,-96.385979 42.474441,-96.386003 42.474496,-96.386013 42.474506,-96.387298 42.475722,-96.392491 42.481243,-96.392648 42.48141,-96.395983 42.484241,-96.396124 42.484361,-96.401962 42.48644,-96.407217 42.487018,-96.407789 42.487168,-96.408361 42.487319,-96.409408 42.487595,-96.411641 42.487792,-96.412225 42.487844,-96.412808 42.487895,-96.41303 42.487916,-96.413217 42.487935,-96.413435 42.487953,-96.413583 42.487966,-96.413722 42.487979,-96.416773 42.488279,-96.417994 42.4884,-96.421678 42.488763,-96.422957 42.488888,-96.423892 42.48898,-96.426592 42.489057,-96.427908 42.489095,-96.428504 42.489126,-96.433808 42.489395,-96.434912 42.489429,-96.440308 42.489595,-96.441385 42.489811,-96.442462 42.490026,-96.443972 42.490328,-96.444908 42.490515,-96.445483 42.49063,-96.445508 42.49063,-96.44555 42.49064,-96.445589 42.490669,-96.445629 42.490691,-96.445819 42.490678,-96.446346 42.490625,-96.447675 42.49047,-96.447918 42.490442,-96.44794 42.490439,-96.447988 42.490439,-96.448128 42.490463,-96.448501 42.490545,-96.448963 42.490661,-96.449282 42.490752,-96.44955 42.490843,-96.449707 42.490896,-96.449728 42.490903,-96.449907 42.490953,-96.449952 42.490962,-96.449999 42.490952,-96.450046 42.490933,-96.450092 42.490925,-96.450182 42.490944,-96.45045 42.491038,-96.450729 42.491108,-96.451141 42.491212,-96.451411 42.491294,-96.452335 42.491617,-96.452595 42.491696,-96.452654 42.491714,-96.452695 42.491726,-96.453288 42.491887,-96.454482 42.492197,-96.454708 42.492263,-96.454969 42.492361,-96.455424 42.492498,-96.455609 42.492542,-96.45575 42.492564,-96.455941 42.492577,-96.456185 42.492576,-96.456291 42.492569,-96.45635 42.492565,-96.456479 42.492556,-96.456735 42.492529,-96.456852 42.492517,-96.456914 42.492511,-96.457204 42.492471,-96.457441 42.492428,-96.45767 42.492371,-96.4578 42.492326,-96.457964 42.492249,-96.458245 42.492101,-96.458371 42.492047,-96.458593 42.491975,-96.459421 42.49176,-96.460149 42.491556,-96.460461 42.491456,-96.460764 42.491341,-96.461481 42.491034,-96.461853 42.490862,-96.462025 42.490796,-96.462251 42.49073,-96.462531 42.490667,-96.462861 42.490604,-96.463243 42.490548,-96.463337 42.490528,-96.463472 42.490474,-96.463512 42.490464,-96.463535 42.490488,-96.463558 42.490524,-96.463629 42.490577,-96.463669 42.490595,-96.463714 42.490604,-96.463765 42.490606,-96.463814 42.490602,-96.463861 42.490593,-96.46418 42.490496,-96.464226 42.490488,-96.464322 42.490485,-96.464466 42.490491,-96.464951 42.49054,-96.465389 42.490572,-96.46558 42.490594,-96.465721 42.490618,-96.465904 42.490665,-96.466352 42.490809,-96.466719 42.490905,-96.467322 42.491046,-96.467698 42.491121,-96.468269 42.491213,-96.468796 42.491283,-96.468984 42.491317,-96.46926 42.49139,-96.469394 42.491437,-96.469474 42.491411,-96.469573 42.491406,-96.469619 42.491396,-96.469663 42.491377,-96.469696 42.491351,-96.469707 42.491318,-96.469708 42.49128,-96.469767 42.491067,-96.469823 42.49093,-96.469854 42.490901,-96.469893 42.49088,-96.469947 42.490886,-96.469969 42.490864,-96.469999 42.490573,-96.469991 42.490501,-96.469939 42.490323,-96.469941 42.490253,-96.469966 42.490184,-96.470047 42.490051,-96.47033 42.489712,-96.470389 42.489655,-96.470458 42.489606,-96.470576 42.489544,-96.470749 42.489473,-96.470926 42.489413,-96.471158 42.489357,-96.471299 42.489331,-96.471348 42.489334,-96.471397 42.489332,-96.471445 42.489323,-96.471505 42.489268,-96.471599 42.489262,-96.471748 42.489265,-96.472622 42.48922,-96.472962 42.48922,-96.473254 42.489234,-96.473496 42.489253,-96.473689 42.48928,-96.473827 42.489312,-96.473914 42.48935,-96.474038 42.489411,-96.474078 42.489423,-96.474114 42.489407,-96.474149 42.489376,-96.474194 42.489369,-96.474294 42.489371,-96.474436 42.489395,-96.475031 42.489533,-96.475413 42.489621,-96.475591 42.489677,-96.475852 42.489775,-96.476104 42.489887,-96.476262 42.489969,-96.476369 42.490043,-96.476461 42.490128,-96.476542 42.490218,-96.476609 42.490355,-96.476632 42.490386,-96.476663 42.490413,-96.476778 42.490482,-96.476812 42.490507,-96.47697 42.49069,-96.47711 42.490881,-96.477186 42.491011,-96.477185 42.491046,-96.477151 42.491155,-96.477121 42.491226,-96.477122 42.491261,-96.477159 42.49135,-96.477164 42.491362,-96.477313 42.49163,-96.477447 42.491901,-96.477614 42.492278,-96.477711 42.492556,-96.477775 42.492805,-96.47782 42.493054,-96.477814 42.493125,-96.477785 42.493233,-96.477785 42.49334,-96.477901 42.494346,-96.477914 42.494597,-96.477908 42.494668,-96.477873 42.494774,-96.477827 42.494877,-96.477782 42.494942,-96.477753 42.494971,-96.477574 42.495096,-96.477545 42.495124,-96.477522 42.495154,-96.477498 42.495213,-96.477489 42.495246,-96.477444 42.49547,-96.477445 42.495503,-96.477445 42.495511,-96.477456 42.495545,-96.47753 42.495659,-96.477541 42.495676,-96.477574 42.495782,-96.477577 42.495801,-96.477584 42.495854,-96.477577 42.495924,-96.477526 42.496084,-96.477498 42.496171,-96.477417 42.496468,-96.477297 42.496912,-96.477207 42.497192,-96.476975 42.497742,-96.476913 42.497879,-96.476744 42.498138,-96.476719 42.498183,-96.47653 42.498542,-96.476467 42.498638,-96.476439 42.498667,-96.476361 42.498711,-96.47632 42.498734,-96.476289 42.498761,-96.476252 42.498825,-96.476168 42.499072,-96.476094 42.499205,-96.475916 42.499467,-96.475634 42.499885,-96.475572 42.499978,-96.475523 42.499992,-96.475301 42.500266,-96.475287 42.500287,-96.474745 42.501095,-96.474712 42.501159,-96.474636 42.501305,-96.474367 42.501825,-96.47424 42.502261,-96.474168 42.502511,-96.47414 42.503179,-96.474138 42.50323,-96.474136 42.503288,-96.473334 42.503536,-96.476048 42.507783,-96.477468 42.509613,-96.478203 42.51021,-96.478784 42.510659,-96.478945 42.510783,-96.479023 42.510843,-96.479088 42.510834,-96.479231 42.510814,-96.479344 42.510799,-96.479517 42.510775,-96.479695 42.510751,-96.479917 42.510721,-96.480145 42.51069,-96.480494 42.510643,-96.480873 42.510591,-96.48263 42.510351,-96.483504 42.51028,-96.484213 42.510306,-96.484379 42.510312,-96.485269 42.510483,-96.4866 42.510739,-96.487669 42.511082,-96.488082 42.511251,-96.488163 42.511284,-96.48875 42.511621,-96.488885 42.511699,-96.488894 42.511704,-96.488971 42.511761,-96.489193 42.511925,-96.489383 42.512065,-96.489466 42.512126,-96.489741 42.512329,-96.490241 42.512697,-96.490306 42.512745,-96.490502 42.512889,-96.490752 42.513073,-96.491431 42.513465,-96.492444 42.514183,-96.493068 42.514821,-96.49357 42.515626,-96.493691 42.516309,-96.493714 42.516629,-96.493722 42.516742,-96.493617 42.517325,-96.493449 42.518259,-96.493188 42.51864,-96.493085 42.518791,-96.492869 42.51906,-96.492687 42.519191,-96.492085 42.519625,-96.492044 42.519649,-96.491557 42.519936,-96.49138 42.520018,-96.491216 42.520094,-96.491119 42.520139,-96.491042 42.520175,-96.490777 42.520239,-96.490646 42.52027,-96.490598 42.520404,-96.487687 42.521436,-96.484691 42.522499,-96.479949 42.524246,-96.479007 42.526394,-96.479041 42.526515,-96.479813 42.529601,-96.477707 42.535596,-96.477409 42.539888,-96.476866 42.544433,-96.476733 42.545383,-96.476834 42.546322,-96.476581 42.546467,-96.476838 42.546626,-96.476952 42.546696,-96.47697 42.549169,-96.476965 42.550348,-96.476948 42.554731,-96.47696 42.555972,-96.477358 42.5561,-96.478541 42.556378,-96.481281 42.556744,-96.486326 42.556961,-96.490128 42.556755,-96.491035 42.556593,-96.493098 42.556354,-96.49554 42.55644,-96.497265 42.556981,-96.498544 42.558116,-96.498835 42.55878,-96.498997 42.560832,-96.487075 42.572245,-96.48661 42.57269,-96.486288 42.573008,-96.486146 42.573149,-96.485742 42.57407,-96.485742 42.57422,-96.485742 42.574673,-96.485751 42.574732,-96.485761 42.574795,-96.485797 42.57502,-96.485863 42.575147,-96.485887 42.575192,-96.485921 42.575257,-96.486198 42.575784,-96.486669 42.576059,-96.487748 42.576365,-96.489903 42.576657,-96.491373 42.577067,-96.491748 42.577243,-96.492455 42.577575,-96.492995 42.577828,-96.493535 42.578082,-96.494107 42.578351,-96.494283 42.57845,-96.495002 42.578853,-96.495654 42.579541,-96.496026 42.580382,-96.495969 42.58175,-96.49597 42.581774,-96.495499 42.582792,-96.494909 42.583536,-96.49369 42.584555,-96.492359 42.585411,-96.491492 42.586103,-96.491336 42.586535,-96.491271 42.586806,-96.491476 42.587251,-96.49152 42.587346,-96.492338 42.587814,-96.493599 42.588141,-96.494289 42.588234,-96.494881 42.588314,-96.495474 42.588394,-96.495712 42.588425,-96.495892 42.588427,-96.497054 42.588444,-96.497851 42.588377,-96.499086 42.588425,-96.500167 42.588638,-96.500514 42.588802,-96.500995 42.589233,-96.501082 42.589311,-96.501127 42.58941,-96.501296 42.589786,-96.501466 42.590161,-96.50148 42.590187,-96.501477 42.590248,-96.501474 42.590327,-96.501477 42.590411,-96.501451 42.590519,-96.501446 42.590541,-96.501438 42.59061,-96.501358 42.59075,-96.501277 42.59089,-96.501146 42.591124,-96.501015 42.591358,-96.50072 42.591884,-96.50043 42.592396,-96.500234 42.59273,-96.500239 42.592841,-96.500216 42.593368,-96.500192 42.593896,-96.500183 42.594104,-96.500284 42.594351,-96.500554 42.595009,-96.500607 42.59514,-96.500824 42.595666,-96.500912 42.595882,-96.501001 42.596097,-96.501194 42.59657,-96.501386 42.597042,-96.503784 42.602876,-96.504624 42.604928,-96.504653 42.604998,-96.504689 42.605054,-96.504833 42.605287,-96.504978 42.60552,-96.506624 42.608166,-96.506842 42.608517,-96.50827 42.610811,-96.508499 42.611178,-96.509323 42.612497,-96.509453 42.612704,-96.510015 42.613211,-96.511842 42.614406,-96.513557 42.615469,-96.515024 42.616183,-96.51658 42.616598,-96.517582 42.616643,-96.517663 42.616647,-96.517712 42.616638,-96.518183 42.616552,-96.51834 42.616522,-96.518654 42.616465,-96.518747 42.616448,-96.518881 42.616398,-96.519169 42.616286,-96.519457 42.616174,-96.519694 42.616083,-96.51983 42.615966,-96.520371 42.615502,-96.521257 42.61457,-96.521318 42.614506,-96.521339 42.614462,-96.52204 42.612995,-96.522361 42.612641,-96.522807 42.612148,-96.523755 42.611252,-96.523876 42.611129,-96.524635 42.610355,-96.525718 42.609276,-96.525739 42.609271,-96.52653 42.60901,-96.527009 42.608946,-96.527026 42.608944,-96.527542 42.608955,-96.527816 42.608961,-96.528121 42.609095,-96.528493 42.609259,-96.528876 42.609425,-96.529169 42.609641,-96.529327 42.609757,-96.529937 42.610471,-96.530177 42.611086,-96.530456 42.611799,-96.530884 42.612795,-96.531023 42.613056,-96.531335 42.613642,-96.53147 42.614472,-96.531483 42.614539,-96.53155 42.614896,-96.531615 42.615318,-96.53147 42.615966,-96.53132 42.616624,-96.531312 42.616647,-96.531281 42.616677,-96.530929 42.617012,-96.53073 42.617266,-96.53059 42.617444,-96.529914 42.617859,-96.529034 42.61824,-96.528726 42.618308,-96.528131 42.61844,-96.527455 42.61834,-96.526844 42.618125,-96.526259 42.617925,-96.525176 42.617776,-96.524001 42.617624,-96.523754 42.617592,-96.522747 42.617578,-96.522581 42.617576,-96.521453 42.617676,-96.521073 42.617854,-96.520709 42.618024,-96.519039 42.618986,-96.518273 42.619673,-96.518114 42.619816,-96.518089 42.619855,-96.517324 42.621028,-96.516828 42.621891,-96.516426 42.622789,-96.516381 42.622941,-96.516245 42.623398,-96.516201 42.623551,-96.51607 42.623837,-96.515681 42.624696,-96.515551 42.624983,-96.5155 42.625261,-96.5155 42.625265,-96.515473 42.625515,-96.515469 42.625906,-96.515463 42.626013,-96.515448 42.626108,-96.515405 42.626388,-96.515368 42.626625,-96.515353 42.626723,-96.515226 42.627333,-96.515178 42.627569,-96.51514 42.628228,-96.515158 42.62837,-96.515335 42.629,-96.515359 42.629069,-96.515607 42.629611,-96.515661 42.629711,-96.515749 42.629838,-96.516084 42.630275,-96.516513 42.630709,-96.51684 42.630975,-96.51788 42.631727,-96.518305 42.632021,-96.518582 42.632273,-96.519159 42.632658,-96.519428 42.632858,-96.51957 42.632964,-96.51967 42.633043,-96.519824 42.633181,-96.520414 42.63375,-96.520796 42.634076,-96.520854 42.634134,-96.521158 42.634413,-96.521532 42.634832,-96.521601 42.634883,-96.521732 42.63493,-96.521779 42.634942,-96.52211 42.635003,-96.522403 42.63502,-96.522542 42.635001,-96.522681 42.634966,-96.523665 42.634649,-96.523801 42.634608,-96.523986 42.634562,-96.524271 42.634511,-96.524466 42.634498,-96.524612 42.634508,-96.524754 42.634534,-96.524799 42.634549,-96.525079 42.634692,-96.525143 42.634746,-96.525167 42.634777,-96.525377 42.635139,-96.525414 42.635242,-96.525422 42.635277,-96.525453 42.635555,-96.525458 42.635598,-96.525448 42.635919,-96.525412 42.636204,-96.525372 42.63638,-96.525248 42.636872,-96.525205 42.63737,-96.52523 42.637869,-96.525337 42.638289,-96.525573 42.639164,-96.525692 42.639474,-96.525802 42.63971,-96.525886 42.639878,-96.525945 42.640014,-96.525977 42.640118,-96.525993 42.640189,-96.526043 42.640363,-96.526188 42.640704,-96.526227 42.640807,-96.526414 42.641213,-96.526456 42.641277,-96.52663 42.64145,-96.527011 42.641675,-96.52708 42.641703,-96.527533 42.64184,-96.527671 42.641875,-96.528915 42.64208,-96.529492 42.64216,-96.529637 42.642176,-96.530267 42.642232,-96.531067 42.642398,-96.531665 42.642557,-96.53211 42.642706,-96.532453 42.642844,-96.532787 42.642994,-96.533272 42.643236,-96.533822 42.643535,-96.534007 42.643641,-96.535361 42.644419,-96.536301 42.644993,-96.536433 42.645098,-96.537075 42.645588,-96.537173 42.645668,-96.537391 42.645861,-96.537472 42.645951,-96.537708 42.646304,-96.537851 42.64657,-96.537917 42.646742,-96.538002 42.646909,-96.538073 42.647154,-96.538164 42.647686,-96.53817 42.6479,-96.538145 42.6484,-96.538116 42.648613,-96.538069 42.648788,-96.538066 42.648824,-96.538063 42.648837,-96.538035 42.648983,-96.538026 42.649032,-96.537989 42.649224,-96.537878 42.649803,-96.537842 42.649996,-96.537803 42.650203,-96.53757 42.651071,-96.537456 42.651501,-96.537413 42.651713,-96.53727 42.652781,-96.537299 42.653138,-96.537344 42.65335,-96.537361 42.653743,-96.537368 42.653815,-96.537495 42.65435,-96.537502 42.654378,-96.537579 42.654584,-96.537767 42.655425,-96.537818 42.6556,-96.537929 42.655874,-96.537976 42.655976,-96.538295 42.656458,-96.538493 42.656694,-96.538525 42.656732,-96.538595 42.656826,-96.538898 42.657193,-96.539248 42.657538,-96.539802 42.658211,-96.540167 42.65859,-96.54036 42.658797,-96.540757 42.659288,-96.540873 42.659485,-96.541012 42.659674,-96.541219 42.659916,-96.541363 42.660059,-96.541393 42.660089,-96.541455 42.660144,-96.541524 42.660194,-96.541754 42.660378,-96.541824 42.660428,-96.542237 42.660827,-96.542365 42.660934,-96.542488 42.661011,-96.542623 42.661097,-96.542858 42.661227,-96.542986 42.661279,-96.543389 42.66141,-96.543482 42.661433,-96.543913 42.661502,-96.544058 42.66152,-96.544349 42.661547,-96.545229 42.661591,-96.545816 42.661579,-96.546302 42.661534,-96.546588 42.661485,-96.547008 42.661387,-96.54712 42.661353,-96.54746 42.661251,-96.54779 42.661182,-96.547834 42.661166,-96.547999 42.661089,-96.548796 42.660816,-96.549386 42.660646,-96.549608 42.660571,-96.550022 42.66038,-96.550325 42.660264,-96.551901 42.659545,-96.5523 42.65934,-96.552591 42.659148,-96.552904 42.658977,-96.553581 42.658689,-96.554316 42.658407,-96.554446 42.658365,-96.554765 42.658274,-96.555483 42.658045,-96.55608 42.657885,-96.556542 42.657768,-96.556778 42.657725,-96.557547 42.657613,-96.557743 42.657605,-96.55833 42.657597,-96.558575 42.6576,-96.558672 42.657608,-96.558909 42.657653,-96.558999 42.657679,-96.559266 42.657769,-96.559388 42.657829,-96.559605 42.657974,-96.559751 42.658117,-96.559868 42.658352,-96.559918 42.658563,-96.559944 42.658848,-96.55994 42.658875,-96.559919 42.659025,-96.559677 42.659797,-96.55946 42.660454,-96.55943 42.660558,-96.559408 42.660664,-96.559401 42.660842,-96.559431 42.661018,-96.55955 42.661401,-96.559609 42.661537,-96.559745 42.661879,-96.559776 42.661946,-96.559797 42.662016,-96.559857 42.66255,-96.559823 42.662834,-96.559808 42.662868,-96.559674 42.663098,-96.559553 42.663254,-96.559454 42.663357,-96.559051 42.663541,-96.558869 42.663595,-96.558822 42.663605,-96.558145 42.66369,-96.557755 42.663715,-96.557021 42.663741,-96.556581 42.663724,-96.556192 42.66375,-96.556096 42.663764,-96.55605 42.663778,-96.555965 42.663812,-96.555808 42.663897,-96.555776 42.663924,-96.555761 42.663958,-96.555747 42.664029,-96.555749 42.664101,-96.55577 42.664207,-96.555867 42.664409,-96.556012 42.664596,-96.556073 42.664651,-96.556305 42.664836,-96.557292 42.665582,-96.557752 42.666045,-96.557907 42.666183,-96.558045 42.666321,-96.558339 42.666616,-96.558486 42.666802,-96.55853 42.666866,-96.558609 42.667219,-96.558672 42.667391,-96.558757 42.66752,-96.558812 42.667579,-96.558959 42.667843,-96.55931 42.668311,-96.559823 42.668834,-96.560019 42.668992,-96.56013 42.669061,-96.560164 42.669086,-96.560278 42.669152,-96.560795 42.669423,-96.561131 42.669567,-96.561306 42.669632,-96.561395 42.669661,-96.561943 42.669817,-96.562334 42.669966,-96.562651 42.670133,-96.562863 42.670276,-96.56326 42.670485,-96.563583 42.670703,-96.563687 42.670778,-96.564297 42.671244,-96.564389 42.671328,-96.564613 42.671604,-96.564741 42.671797,-96.564766 42.671828,-96.56509 42.672142,-96.565262 42.672358,-96.565301 42.672424,-96.565485 42.672676,-96.565504 42.672709,-96.565598 42.672987,-96.56563 42.673054,-96.565867 42.673447,-96.565905 42.673624,-96.565968 42.673796,-96.566003 42.673937,-96.566092 42.674791,-96.566184 42.675287,-96.566332 42.675665,-96.566463 42.675934,-96.566483 42.675967,-96.566532 42.676029,-96.566964 42.676417,-96.567001 42.67644,-96.567044 42.676458,-96.567091 42.676467,-96.567237 42.676477,-96.567384 42.676479,-96.567529 42.676464,-96.567575 42.676453,-96.56801 42.676289,-96.568049 42.676267,-96.568285 42.676086,-96.568508 42.675947,-96.56879 42.675804,-96.568904 42.675736,-96.56907 42.675605,-96.569707 42.67497,-96.569776 42.674875,-96.569895 42.674679,-96.570017 42.674334,-96.570124 42.673803,-96.570293 42.672632,-96.570424 42.672105,-96.570493 42.67201,-96.570575 42.671804,-96.570639 42.671707,-96.570939 42.67134,-96.571055 42.671218,-96.571079 42.671194,-96.571112 42.671167,-96.57122 42.671094,-96.571567 42.670896,-96.571653 42.670863,-96.572067 42.670753,-96.572304 42.670707,-96.572401 42.670697,-96.57279 42.670673,-96.573085 42.670667,-96.573134 42.670669,-96.57357 42.670721,-96.574587 42.670979,-96.57467 42.671018,-96.574716 42.671031,-96.574953 42.671077,-96.576817 42.671375,-96.577395 42.671443,-96.577852 42.671569,-96.578024 42.671636,-96.578365 42.671814,-96.578399 42.67184,-96.578428 42.671869,-96.578474 42.671932,-96.578513 42.671997,-96.578576 42.672207,-96.578574 42.672242,-96.578551 42.672312,-96.578517 42.672379,-96.578471 42.672442,-96.578441 42.67247,-96.578274 42.6726,-96.578236 42.672623,-96.577978 42.672724,-96.577344 42.672916,-96.57647 42.673003,-96.575655 42.673121,-96.575467 42.673163,-96.575336 42.673211,-96.574589 42.67355,-96.574429 42.673631,-96.574354 42.673677,-96.574257 42.673757,-96.573926 42.674017,-96.573863 42.674072,-96.573722 42.674218,-96.573338 42.674674,-96.573173 42.674893,-96.573061 42.675091,-96.572881 42.675223,-96.572745 42.675372,-96.572614 42.675564,-96.572142 42.676463,-96.572111 42.676531,-96.572053 42.676704,-96.571962 42.677055,-96.571944 42.677161,-96.571927 42.677482,-96.571962 42.67791,-96.572008 42.678157,-96.572029 42.678226,-96.57212 42.678429,-96.572141 42.678461,-96.572192 42.678522,-96.572301 42.67872,-96.572416 42.678836,-96.572448 42.678863,-96.572488 42.678884,-96.572623 42.678926,-96.572765 42.678951,-96.572861 42.678963,-96.57291 42.678965,-96.573008 42.678961,-96.57325 42.678931,-96.57353 42.678867,-96.573845 42.67877,-96.573975 42.67872,-96.574679 42.678332,-96.574981 42.67815,-96.575341 42.677964,-96.575428 42.677931,-96.57598 42.677783,-96.576263 42.677726,-96.577041 42.677651,-96.577676 42.67762,-96.577921 42.677632,-96.578016 42.67765,-96.578154 42.677685,-96.578289 42.677727,-96.578455 42.677803,-96.578492 42.677827,-96.578648 42.677964,-96.578722 42.678057,-96.578757 42.678123,-96.578768 42.678158,-96.578803 42.67837,-96.578781 42.678467,-96.578727 42.678567,-96.578704 42.678598,-96.578508 42.678757,-96.578439 42.678807,-96.578211 42.678943,-96.577848 42.679126,-96.577018 42.679432,-96.576932 42.679467,-96.576338 42.679782,-96.576119 42.679862,-96.575992 42.679914,-96.575953 42.679937,-96.575669 42.680133,-96.57523 42.68047,-96.575091 42.68061,-96.574972 42.68073,-96.574907 42.680826,-96.57467 42.681295,-96.574597 42.681502,-96.57458 42.681609,-96.574568 42.681966,-96.574573 42.682002,-96.574594 42.682071,-96.574702 42.682309,-96.574877 42.682524,-96.574906 42.682552,-96.57518 42.682757,-96.575295 42.682823,-96.575693 42.682962,-96.575784 42.682989,-96.576108 42.68307,-96.576252 42.683092,-96.576496 42.68311,-96.576692 42.683109,-96.577913 42.683035,-96.578254 42.683014,-96.578495 42.682982,-96.578691 42.682969,-96.578984 42.682981,-96.579131 42.682974,-96.580049 42.682864,-96.580292 42.682848,-96.580683 42.682872,-96.581365 42.682905,-96.582341 42.68294,-96.582684 42.68294,-96.583024 42.68291,-96.583903 42.682928,-96.584244 42.682959,-96.584635 42.682972,-96.584732 42.682982,-96.584828 42.682997,-96.585153 42.683065,-96.5852 42.683075,-96.585296 42.683088,-96.585443 42.683089,-96.585833 42.683059,-96.585881 42.683065,-96.585928 42.683076,-96.586186 42.683177,-96.586307 42.683289,-96.586332 42.68332,-96.586371 42.683385,-96.586382 42.68342,-96.58643 42.683668,-96.586431 42.683775,-96.586425 42.68381,-96.586307 42.68412,-96.58624 42.684254,-96.586015 42.684649,-96.585895 42.684844,-96.585752 42.685147,-96.585462 42.685829,-96.585451 42.685864,-96.585415 42.686076,-96.585402 42.68629,-96.585428 42.68661,-96.585493 42.687001,-96.58553 42.687141,-96.58566 42.687411,-96.58573 42.687544,-96.58587 42.687772,-96.586132 42.688115,-96.586295 42.688413,-96.586303 42.688448,-96.586252 42.689375,-96.586259 42.689589,-96.586268 42.689624,-96.586342 42.689794,-96.586383 42.689859,-96.586485 42.689981,-96.586516 42.690008,-96.586757 42.690131,-96.586801 42.690147,-96.586848 42.690158,-96.587188 42.690188,-96.587873 42.690174,-96.58797 42.690175,-96.588165 42.690168,-96.588262 42.690177,-96.588592 42.69024,-96.588636 42.690254,-96.588843 42.690348,-96.589185 42.690549,-96.589274 42.690635,-96.589428 42.690816,-96.589491 42.69087,-96.589595 42.690946,-96.589635 42.690966,-96.589721 42.691,-96.589842 42.691041,-96.590133 42.691075,-96.590427 42.691076,-96.590864 42.691039,-96.59105 42.690996,-96.591352 42.690879,-96.591592 42.690759,-96.591768 42.690634,-96.591852 42.690546,-96.591888 42.69048,-96.592014 42.690209,-96.59203 42.690139,-96.592032 42.690032,-96.592026 42.689996,-96.591922 42.689647,-96.59158 42.689055,-96.591547 42.688988,-96.591505 42.688885,-96.591418 42.688498,-96.591422 42.688356,-96.59143 42.688285,-96.591487 42.688111,-96.591656 42.687737,-96.591676 42.687705,-96.591969 42.687375,-96.592001 42.687348,-96.592295 42.68716,-96.592932 42.686893,-96.593062 42.686843,-96.593488 42.68676,-96.593827 42.686722,-96.594022 42.68671,-96.594609 42.686705,-96.595733 42.686736,-96.59666 42.686809,-96.596709 42.68681,-96.597289 42.686745,-96.597826 42.686742,-96.598884 42.686667,-96.598933 42.686672,-96.599315 42.686736,-96.599449 42.686781,-96.599639 42.686893,-96.599927 42.687137,-96.599954 42.687167,-96.599975 42.687199,-96.600042 42.687333,-96.600066 42.687365,-96.600133 42.687499,-96.60015 42.687605,-96.600177 42.687926,-96.600177 42.687997,-96.600172 42.688033,-96.60015 42.688102,-96.600098 42.688203,-96.600003 42.688367,-96.599773 42.688641,-96.599655 42.688754,-96.599621 42.688781,-96.599381 42.688904,-96.599161 42.688982,-96.599022 42.689015,-96.598974 42.689023,-96.598877 42.689031,-96.598637 42.688996,-96.598227 42.688877,-96.598184 42.68886,-96.597883 42.688678,-96.597318 42.688394,-96.596851 42.688287,-96.596754 42.688276,-96.596559 42.688288,-96.596324 42.688337,-96.59628 42.688354,-96.596074 42.688449,-96.595927 42.688544,-96.595614 42.688712,-96.595437 42.688773,-96.595251 42.688818,-96.595203 42.688824,-96.595154 42.688825,-96.594912 42.688844,-96.594828 42.688881,-96.594782 42.688895,-96.594494 42.688936,-96.594208 42.688986,-96.594119 42.689016,-96.594039 42.689057,-96.593936 42.689133,-96.593829 42.689253,-96.593735 42.689378,-96.593715 42.689411,-96.593614 42.689723,-96.593613 42.689794,-96.593663 42.690005,-96.593769 42.690205,-96.593907 42.690394,-96.594056 42.690536,-96.594157 42.690614,-96.594378 42.690755,-96.594499 42.690816,-96.594542 42.690834,-96.594851 42.690941,-96.594943 42.690966,-96.595904 42.691092,-96.596087 42.691145,-96.596125 42.691167,-96.5963 42.691291,-96.596387 42.691377,-96.596453 42.691472,-96.596466 42.691507,-96.596502 42.691647,-96.596539 42.691932,-96.596528 42.692003,-96.596429 42.692242,-96.596408 42.692275,-96.596051 42.692701,-96.596021 42.692729,-96.595922 42.6928,-96.595676 42.692917,-96.595503 42.692984,-96.594969 42.693237,-96.594418 42.693467,-96.594336 42.693505,-96.594292 42.69352,-96.594167 42.693576,-96.593906 42.693788,-96.59388 42.693818,-96.593822 42.693916,-96.593804 42.693986,-96.593829 42.694164,-96.593928 42.694327,-96.593952 42.694358,-96.593986 42.694384,-96.594252 42.694541,-96.594336 42.694579,-96.59452 42.694627,-96.594662 42.694656,-96.595338 42.694738,-96.59553 42.694767,-96.59572 42.694802,-96.595954 42.694854,-96.596635 42.695057,-96.597081 42.695278,-96.597307 42.695415,-96.597624 42.695637,-96.597746 42.695749,-96.597997 42.695968,-96.598234 42.696149,-96.598612 42.696565,-96.599028 42.696963,-96.599142 42.697121,-96.599154 42.697156,-96.59917 42.697439,-96.599115 42.69783,-96.599116 42.697866,-96.599138 42.697971,-96.599162 42.698041,-96.599168 42.698076,-96.599219 42.698214,-96.599263 42.698316,-96.599307 42.698379,-96.599505 42.698705,-96.59955 42.698769,-96.599603 42.698829,-96.599637 42.698854,-96.599858 42.698996,-96.599941 42.699032,-96.599987 42.699045,-96.600604 42.699158,-96.600653 42.699162,-96.600946 42.699159,-96.600994 42.699154,-96.601041 42.699144,-96.60113 42.699114,-96.601342 42.699024,-96.601381 42.699003,-96.601447 42.69895,-96.601494 42.698849,-96.601532 42.698708,-96.601549 42.698422,-96.601534 42.697851,-96.601537 42.697744,-96.601577 42.697641,-96.601651 42.697527,-96.601809 42.69739,-96.60189 42.697301,-96.601993 42.697224,-96.602241 42.697053,-96.602281 42.697033,-96.602555 42.696954,-96.6027 42.696938,-96.602847 42.696932,-96.603285 42.69697,-96.603857 42.697062,-96.603906 42.697065,-96.604003 42.697055,-96.604027 42.697048,-96.604186 42.697003,-96.604312 42.696948,-96.604346 42.696923,-96.604375 42.696894,-96.604523 42.696708,-96.604574 42.696533,-96.604572 42.696426,-96.60456 42.696355,-96.60456 42.69632,-96.604418 42.695903,-96.60442 42.695618,-96.604436 42.695584,-96.604526 42.695457,-96.60468 42.695275,-96.604769 42.695189,-96.604924 42.695051,-96.605265 42.694848,-96.605643 42.694683,-96.605875 42.694624,-96.605923 42.694615,-96.606116 42.694591,-96.60636 42.694572,-96.606801 42.694565,-96.607486 42.694607,-96.607873 42.694653,-96.608018 42.694667,-96.608654 42.694705,-96.608801 42.694706,-96.609143 42.69468,-96.609721 42.694598,-96.610159 42.69456,-96.610208 42.69456,-96.610687 42.694634,-96.610782 42.694652,-96.610922 42.694685,-96.611275 42.694809,-96.61158 42.694988,-96.611622 42.695006,-96.611698 42.69505,-96.611769 42.695099,-96.611795 42.69513,-96.612056 42.695512,-96.612086 42.69558,-96.612109 42.695649,-96.612181 42.695931,-96.612206 42.696108,-96.612199 42.696215,-96.612121 42.696495,-96.612045 42.696623,-96.61179 42.696885,-96.611167 42.697389,-96.611043 42.6975,-96.610583 42.69787,-96.610369 42.698017,-96.61018 42.698131,-96.609624 42.698425,-96.60958 42.698442,-96.609339 42.698473,-96.609192 42.698472,-96.609048 42.698449,-96.608922 42.698394,-96.608429 42.698101,-96.60835 42.69806,-96.608023 42.697906,-96.607896 42.697852,-96.60767 42.697785,-96.607622 42.69778,-96.60748 42.697755,-96.607432 42.69775,-96.606893 42.697733,-96.606358 42.697781,-96.605692 42.697897,-96.605602 42.697924,-96.605515 42.697956,-96.605381 42.697999,-96.605335 42.69801,-96.605247 42.698041,-96.605039 42.698136,-96.604963 42.698181,-96.604726 42.698361,-96.604603 42.698473,-96.604528 42.698565,-96.604419 42.698765,-96.604348 42.699009,-96.604331 42.699152,-96.604328 42.699295,-96.604349 42.699509,-96.604466 42.700038,-96.604683 42.700661,-96.6048 42.701189,-96.604825 42.701258,-96.604912 42.701463,-96.604946 42.70153,-96.605088 42.701694,-96.605147 42.701748,-96.605352 42.701901,-96.605469 42.701966,-96.605596 42.70202,-96.606423 42.702237,-96.60685 42.702317,-96.60787 42.702401,-96.608065 42.702414,-96.608505 42.702432,-96.60913 42.702424,-96.609436 42.702421,-96.609485 42.702416,-96.609577 42.702393,-96.609666 42.702364,-96.609713 42.702353,-96.609801 42.702324,-96.609993 42.702212,-96.610284 42.702082,-96.610426 42.701984,-96.610456 42.701956,-96.610619 42.701825,-96.610648 42.701796,-96.610791 42.70161,-96.610867 42.701519,-96.611134 42.701219,-96.611698 42.700152,-96.611767 42.700058,-96.611851 42.699969,-96.612392 42.699508,-96.612638 42.699333,-96.612956 42.699168,-96.613748 42.698978,-96.614013 42.698887,-96.614504 42.69865,-96.614687 42.698532,-96.614728 42.698513,-96.615002 42.698435,-96.61505 42.698429,-96.615148 42.698433,-96.615241 42.698457,-96.615409 42.69853,-96.615444 42.698554,-96.615508 42.698608,-96.615627 42.698765,-96.615644 42.698798,-96.615639 42.698869,-96.615627 42.698904,-96.615613 42.698975,-96.615617 42.69901,-96.61565 42.699151,-96.615649 42.699187,-96.615516 42.699713,-96.615516 42.699855,-96.615562 42.699994,-96.615722 42.700254,-96.615751 42.700283,-96.615825 42.70033,-96.615945 42.700391,-96.616053 42.700428,-96.616078 42.700437,-96.616169 42.700463,-96.616504 42.700515,-96.616601 42.700523,-96.616846 42.70051,-96.61694 42.700492,-96.616986 42.700479,-96.617294 42.700369,-96.617375 42.700329,-96.617492 42.700264,-96.617676 42.700147,-96.618278 42.69982,-96.618424 42.699742,-96.61847 42.699729,-96.618807 42.699684,-96.618905 42.699682,-96.618995 42.699711,-96.619122 42.699764,-96.619162 42.699786,-96.619194 42.699812,-96.619273 42.699903,-96.619415 42.700091,-96.619545 42.700322,-96.619604 42.700458,-96.619684 42.700663,-96.619723 42.700803,-96.619749 42.700871,-96.619776 42.700976,-96.619767 42.701011,-96.619764 42.701081,-96.619732 42.701329,-96.619726 42.701436,-96.619748 42.701721,-96.619761 42.701827,-96.619815 42.701964,-96.619964 42.702149,-96.619996 42.702176,-96.62045 42.702448,-96.620515 42.702501,-96.620822 42.702731,-96.620902 42.70282,-96.620941 42.702886,-96.620961 42.702943,-96.620991 42.703024,-96.62111 42.703589,-96.621243 42.703934,-96.62129 42.704109,-96.621408 42.704456,-96.621552 42.704768,-96.621642 42.704963,-96.621933 42.705275,-96.622 42.705347,-96.622217 42.705668,-96.622563 42.705971,-96.622666 42.706103,-96.622684 42.706126,-96.622967 42.706541,-96.623038 42.706635,-96.623358 42.70695,-96.623413 42.707009,-96.623881 42.707555,-96.623916 42.707579,-96.623957 42.7076,-96.624216 42.7077,-96.624263 42.707711,-96.624361 42.707717,-96.624497 42.70768,-96.62475 42.707571,-96.624981 42.707439,-96.6251 42.707326,-96.62517 42.707278,-96.625208 42.707253,-96.625287 42.707163,-96.625305 42.707129,-96.625392 42.706814,-96.625395 42.706493,-96.62535 42.706234,-96.625346 42.706209,-96.625275 42.705892,-96.625189 42.705686,-96.625102 42.70552,-96.624955 42.705105,-96.624916 42.704893,-96.624916 42.704822,-96.624991 42.704579,-96.62505 42.704481,-96.625077 42.704451,-96.625208 42.704345,-96.625246 42.704322,-96.625486 42.704198,-96.625529 42.704181,-96.62598 42.704042,-96.626108 42.704024,-96.626365 42.70399,-96.626414 42.703988,-96.626512 42.703995,-96.62675 42.704036,-96.626843 42.704058,-96.626978 42.7041,-96.62702 42.704119,-96.627214 42.704228,-96.627325 42.704297,-96.627406 42.704337,-96.62784 42.704677,-96.62791 42.704727,-96.628095 42.704843,-96.628384 42.704978,-96.628428 42.704995,-96.628521 42.705015,-96.629325 42.705017,-96.629372 42.705025,-96.629511 42.70506,-96.62992 42.705255,-96.630154 42.705438,-96.630207 42.705498,-96.630353 42.705684,-96.630413 42.705857,-96.630443 42.706569,-96.630467 42.706747,-96.630441 42.706888,-96.630299 42.707268,-96.630092 42.707592,-96.629832 42.707936,-96.629749 42.708065,-96.62944 42.708816,-96.629392 42.708918,-96.629333 42.709015,-96.629307 42.709046,-96.629276 42.709074,-96.62917 42.709148,-96.628962 42.709242,-96.62882 42.70927,-96.628706 42.709273,-96.628282 42.709289,-96.62814 42.709315,-96.627858 42.709374,-96.627631 42.709441,-96.627498 42.709486,-96.626888 42.7099,-96.626855 42.709926,-96.626779 42.710018,-96.626539 42.710329,-96.626345 42.710657,-96.626265 42.710747,-96.626043 42.710968,-96.625977 42.711063,-96.625951 42.711132,-96.625936 42.71118,-96.625833 42.711515,-96.625636 42.711881,-96.625448 42.712171,-96.625422 42.71224,-96.625238 42.712645,-96.625222 42.712671,-96.625144 42.712811,-96.625027 42.712924,-96.624904 42.713119,-96.62468 42.713475,-96.624559 42.713707,-96.62442 42.713977,-96.624406 42.714011,-96.624284 42.714468,-96.62426 42.714717,-96.62427 42.714895,-96.624315 42.71518,-96.624373 42.715316,-96.62453 42.715617,-96.624545 42.715643,-96.624568 42.715682,-96.624745 42.715896,-96.624799 42.715955,-96.624834 42.71598,-96.625042 42.716095,-96.625139 42.716148,-96.625186 42.716175,-96.625323 42.716277,-96.625418 42.716329,-96.62544 42.716341,-96.62551 42.716392,-96.625748 42.716771,-96.625773 42.716802,-96.625948 42.716926,-96.626146 42.717032,-96.626278 42.71708,-96.626629 42.717166,-96.626743 42.717194,-96.627141 42.717333,-96.627368 42.7174,-96.627636 42.717488,-96.627719 42.717527,-96.627936 42.717671,-96.627969 42.717697,-96.627992 42.717729,-96.628006 42.717763,-96.628011 42.717798,-96.628001 42.717833,-96.627923 42.718003,-96.627882 42.718068,-96.627826 42.718126,-96.627762 42.71818,-96.627488 42.718382,-96.627258 42.718516,-96.627019 42.718641,-96.626798 42.718718,-96.626593 42.718816,-96.626453 42.718916,-96.626389 42.71897,-96.626092 42.719251,-96.62589 42.719409,-96.625625 42.719617,-96.625498 42.719726,-96.625352 42.719821,-96.624967 42.720276,-96.624882 42.720405,-96.624545 42.720944,-96.624465 42.721113,-96.624402 42.721503,-96.624395 42.721574,-96.624413 42.721967,-96.624434 42.722073,-96.624455 42.722143,-96.624596 42.722485,-96.624745 42.72267,-96.625003 42.722929,-96.625247 42.723104,-96.625332 42.723191,-96.625393 42.723327,-96.625452 42.723609,-96.625454 42.723645,-96.625437 42.723823,-96.625428 42.723858,-96.625309 42.724168,-96.625227 42.724297,-96.624792 42.724729,-96.624755 42.724753,-96.624658 42.724832,-96.624535 42.724944,-96.624466 42.725039,-96.624447 42.725072,-96.624434 42.725106,-96.624414 42.725212,-96.624446 42.725317,-96.624464 42.72535,-96.624691 42.725626,-96.624723 42.725652,-96.624764 42.725673,-96.624937 42.72574,-96.625218 42.725803,-96.625555 42.725861,-96.6256 42.725869,-96.626039 42.725898,-96.627019 42.725934,-96.627503 42.725878,-96.628058 42.725737,-96.628626 42.725629,-96.628918 42.725599,-96.629348 42.725528,-96.629939 42.725351,-96.630466 42.725162,-96.630628 42.725081,-96.630672 42.725067,-96.631406 42.725033,-96.631598 42.725004,-96.631883 42.724951,-96.632164 42.724888,-96.632209 42.724874,-96.632425 42.72479,-96.632931 42.724507,-96.633236 42.724327,-96.63352 42.724188,-96.633703 42.724137,-96.633752 42.724135,-96.633801 42.724138,-96.633896 42.724156,-96.634118 42.724257,-96.634189 42.724306,-96.634278 42.724391,-96.634304 42.724421,-96.634509 42.724706,-96.634642 42.725011,-96.634665 42.725042,-96.6347 42.725108,-96.634812 42.725598,-96.634814 42.725741,-96.634806 42.725847,-96.634769 42.725988,-96.634743 42.726057,-96.634704 42.726122,-96.634363 42.726379,-96.634321 42.726397,-96.633781 42.726567,-96.633378 42.726699,-96.633287 42.726725,-96.633239 42.726733,-96.6331 42.726766,-96.632925 42.726831,-96.632807 42.726895,-96.632771 42.726919,-96.632572 42.727077,-96.632517 42.727136,-96.632476 42.727239,-96.632467 42.727274,-96.632462 42.727381,-96.632465 42.727453,-96.632522 42.728022,-96.632507 42.728129,-96.632376 42.728436,-96.632357 42.728469,-96.632243 42.728586,-96.632178 42.728639,-96.632056 42.728751,-96.632021 42.728776,-96.631897 42.728833,-96.631685 42.728922,-96.631186 42.729073,-96.630978 42.729167,-96.630677 42.72935,-96.630647 42.729378,-96.630623 42.72941,-96.630501 42.729605,-96.630484 42.729639,-96.630434 42.729777,-96.630426 42.729812,-96.630432 42.729919,-96.630522 42.730234,-96.630908 42.730772,-96.630985 42.730863,-96.631321 42.73117,-96.631801 42.731527,-96.632186 42.731851,-96.632289 42.731927,-96.632405 42.732042,-96.632467 42.732097,-96.632493 42.732127,-96.632587 42.732209,-96.632628 42.732228,-96.63302 42.732376,-96.633225 42.73243,-96.633343 42.732462,-96.633392 42.732466,-96.633578 42.732462,-96.634166 42.732492,-96.634509 42.732485,-96.634705 42.732491,-96.635187 42.732557,-96.635467 42.732622,-96.635643 42.732685,-96.635857 42.732773,-96.636077 42.732851,-96.63631 42.732983,-96.636398 42.733014,-96.636438 42.733034,-96.636511 42.733082,-96.636648 42.733183,-96.63672 42.733231,-96.636816 42.733312,-96.637575 42.734013,-96.637641 42.734066,-96.637988 42.734316,-96.638089 42.734394,-96.638325 42.734622,-96.638348 42.734654,-96.638947 42.735764,-96.638959 42.735786,-96.639097 42.736001,-96.639333 42.736367,-96.639364 42.736435,-96.639451 42.736758,-96.639468 42.736821,-96.639485 42.736928,-96.639484 42.736963,-96.639467 42.737034,-96.63941 42.73717,-96.639302 42.73729,-96.63927 42.737317,-96.639155 42.737383,-96.638984 42.737453,-96.638846 42.737491,-96.638749 42.737501,-96.638358 42.737476,-96.638262 42.737464,-96.638025 42.737419,-96.637551 42.737269,-96.636181 42.736838,-96.635159 42.736585,-96.635024 42.736543,-96.634545 42.736294,-96.63436 42.736177,-96.634109 42.735933,-96.634076 42.735907,-96.633715 42.735721,-96.63355 42.735644,-96.633353 42.735537,-96.633095 42.735434,-96.632964 42.735386,-96.632829 42.735343,-96.632365 42.735229,-96.632225 42.735198,-96.632034 42.735166,-96.631987 42.735155,-96.631943 42.735139,-96.631898 42.735128,-96.631751 42.735127,-96.631655 42.735113,-96.631602 42.735107,-96.631462 42.735092,-96.631367 42.735076,-96.631172 42.735078,-96.630886 42.735111,-96.630839 42.735122,-96.630684 42.735207,-96.630622 42.735261,-96.630586 42.735286,-96.630525 42.735341,-96.630436 42.735468,-96.630404 42.735536,-96.630393 42.73557,-96.630366 42.735748,-96.630383 42.735962,-96.630448 42.736171,-96.630489 42.736265,-96.630537 42.736375,-96.630728 42.736665,-96.631073 42.737054,-96.631108 42.73708,-96.631295 42.737195,-96.631808 42.737404,-96.632037 42.737468,-96.632078 42.737488,-96.632152 42.737535,-96.632247 42.737617,-96.632335 42.737703,-96.632643 42.737981,-96.633123 42.738479,-96.633326 42.738764,-96.633443 42.738878,-96.63351 42.738931,-96.633723 42.739079,-96.633876 42.739169,-96.63398 42.739245,-96.634067 42.739331,-96.634242 42.739456,-96.634442 42.73956,-96.634583 42.739659,-96.634809 42.739847,-96.634891 42.739936,-96.635148 42.74024,-96.635466 42.740683,-96.635561 42.740847,-96.635697 42.741299,-96.635728 42.741513,-96.635719 42.741555,-96.635679 42.74176,-96.635668 42.741795,-96.635612 42.741894,-96.635511 42.742017,-96.635456 42.742075,-96.63542 42.7421,-96.635079 42.742303,-96.634833 42.742421,-96.63431 42.74262,-96.633967 42.742759,-96.633875 42.742784,-96.633543 42.742845,-96.632761 42.742894,-96.632664 42.742891,-96.632371 42.742868,-96.632175 42.742868,-96.631592 42.742928,-96.631449 42.742954,-96.631356 42.742976,-96.629712 42.743452,-96.629586 42.743506,-96.629509 42.743551,-96.629479 42.743579,-96.629429 42.743641,-96.629381 42.743742,-96.629353 42.743847,-96.629351 42.743882,-96.629376 42.744024,-96.629387 42.744059,-96.62942 42.744126,-96.629496 42.744218,-96.629531 42.744243,-96.629611 42.744285,-96.629656 42.7443,-96.630407 42.744464,-96.630553 42.744475,-96.630992 42.744497,-96.631041 42.744496,-96.631378 42.744541,-96.631424 42.744554,-96.631727 42.744671,-96.631911 42.744789,-96.631944 42.744815,-96.632026 42.744904,-96.632107 42.745035,-96.632121 42.745069,-96.632155 42.74521,-96.632154 42.745281,-96.632137 42.745459,-96.632096 42.745599,-96.63198 42.745834,-96.631855 42.746028,-96.631701 42.746329,-96.631618 42.746417,-96.631549 42.746468,-96.631369 42.746589,-96.631203 42.746666,-96.631067 42.746706,-96.630408 42.746848,-96.630236 42.746916,-96.630199 42.746939,-96.630133 42.746992,-96.630022 42.747109,-96.630003 42.747142,-96.62987 42.747486,-96.62985 42.747555,-96.629819 42.747804,-96.629835 42.748018,-96.629937 42.74822,-96.629961 42.748251,-96.630294 42.74856,-96.630349 42.748619,-96.630392 42.748683,-96.630539 42.749023,-96.630559 42.749093,-96.630564 42.749129,-96.630559 42.749342,-96.630521 42.749519,-96.630412 42.749793,-96.630405 42.749865,-96.630364 42.750004,-96.630412 42.750136,-96.63042 42.750207,-96.630406 42.750241,-96.630384 42.750273,-96.630082 42.750641,-96.630019 42.750696,-96.629983 42.75072,-96.629856 42.750774,-96.629762 42.750794,-96.629618 42.750815,-96.629521 42.750823,-96.629474 42.750814,-96.629291 42.75076,-96.629024 42.75067,-96.628858 42.750594,-96.628723 42.750552,-96.628675 42.750544,-96.628384 42.750516,-96.628188 42.750518,-96.627994 42.750541,-96.627576 42.750642,-96.627532 42.750657,-96.627313 42.7508,-96.627151 42.750881,-96.627077 42.750928,-96.627046 42.750956,-96.626964 42.751086,-96.62695 42.75112,-96.62689 42.751582,-96.626895 42.751867,-96.62682 42.75211,-96.626634 42.752361,-96.626607 42.75239,-96.62648 42.7525,-96.626438 42.752515,-96.626343 42.752531,-96.626297 42.752544,-96.626255 42.752562,-96.626011 42.752699,-96.625908 42.752758,-96.625785 42.752816,-96.625748 42.752839,-96.625661 42.752926,-96.625626 42.752951,-96.625579 42.752953,-96.625436 42.752927,-96.62525 42.752882,-96.625007 42.752903,-96.624615 42.752901,-96.62408 42.752849,-96.623344 42.752852,-96.623198 42.752868,-96.622914 42.752925,-96.622552 42.753035,-96.622301 42.753147,-96.622072 42.753283,-96.621968 42.753359,-96.62193 42.753381,-96.621764 42.753459,-96.621719 42.753471,-96.621671 42.753477,-96.620887 42.75343,-96.62074 42.753438,-96.620306 42.753499,-96.620213 42.753521,-96.620126 42.753554,-96.6198 42.753713,-96.619695 42.753788,-96.619545 42.75393,-96.619491 42.753989,-96.619471 42.754022,-96.619278 42.754502,-96.619262 42.754609,-96.619269 42.754752,-96.619331 42.754849,-96.619361 42.754918,-96.6194 42.754983,-96.619711 42.755389,-96.619755 42.755453,-96.620005 42.75588,-96.620014 42.755915,-96.620064 42.756235,-96.62007 42.756342,-96.619995 42.756804,-96.619988 42.756946,-96.620004 42.757089,-96.62002 42.75716,-96.620025 42.757173,-96.62009 42.757331,-96.620212 42.757526,-96.620267 42.757585,-96.620702 42.757875,-96.621022 42.75804,-96.621399 42.758207,-96.621487 42.75824,-96.621812 42.758321,-96.622342 42.758397,-96.622391 42.758401,-96.622833 42.758398,-96.62293 42.758388,-96.623023 42.758365,-96.623396 42.758194,-96.623473 42.758149,-96.62369 42.758003,-96.624298 42.757397,-96.624367 42.757303,-96.624471 42.757102,-96.624598 42.75672,-96.624705 42.756298,-96.624878 42.755925,-96.624969 42.755611,-96.624983 42.755577,-96.625107 42.755423,-96.625176 42.755328,-96.625293 42.755095,-96.625369 42.754965,-96.625381 42.75493,-96.625389 42.75486,-96.625423 42.754757,-96.625436 42.754728,-96.625455 42.754691,-96.625503 42.754553,-96.62552 42.75452,-96.625566 42.754457,-96.625601 42.754433,-96.626086 42.754193,-96.626132 42.754179,-96.626421 42.754148,-96.62647 42.754151,-96.626661 42.75418,-96.626944 42.754232,-96.626989 42.754247,-96.627068 42.75429,-96.627243 42.754413,-96.627445 42.754738,-96.627515 42.754892,-96.627558 42.75503,-96.627594 42.755243,-96.627587 42.755314,-96.627567 42.755384,-96.627566 42.755491,-96.627525 42.755847,-96.62755 42.756132,-96.627628 42.756375,-96.627756 42.756662,-96.627811 42.756783,-96.627893 42.756913,-96.628129 42.757185,-96.628368 42.757412,-96.628672 42.757645,-96.628784 42.757714,-96.629563 42.758147,-96.629984 42.758495,-96.630012 42.758525,-96.630796 42.759759,-96.630834 42.759825,-96.630967 42.760094,-96.631022 42.760152,-96.631199 42.760276,-96.631465 42.760541,-96.631518 42.760594,-96.631905 42.760868,-96.632056 42.761009,-96.632157 42.761087,-96.632397 42.761313,-96.632523 42.761507,-96.632784 42.761786,-96.632882 42.761891,-96.633302 42.762215,-96.633557 42.762383,-96.634018 42.76265,-96.635139 42.763227,-96.635409 42.763381,-96.635607 42.76354,-96.6361 42.763986,-96.636353 42.764411,-96.636384 42.764478,-96.636489 42.764753,-96.636498 42.764824,-96.636493 42.76486,-96.636352 42.765126,-96.636275 42.765217,-96.636039 42.765399,-96.636 42.765421,-96.635792 42.765515,-96.635701 42.765542,-96.635512 42.765581,-96.635122 42.765611,-96.634877 42.765601,-96.634828 42.765595,-96.634725 42.765568,-96.634365 42.765476,-96.633799 42.765262,-96.632892 42.764989,-96.632796 42.764975,-96.632551 42.764977,-96.632307 42.764999,-96.632215 42.765023,-96.632046 42.765095,-96.632008 42.765118,-96.631975 42.765144,-96.631756 42.765382,-96.631625 42.765533,-96.631605 42.765565,-96.631551 42.765703,-96.631527 42.765845,-96.631522 42.766095,-96.63161 42.766446,-96.631655 42.766549,-96.632166 42.767631,-96.63223 42.767803,-96.632335 42.768041,-96.632641 42.768528,-96.632686 42.768592,-96.632715 42.76862,-96.63275 42.768645,-96.632904 42.768733,-96.632993 42.768765,-96.633088 42.768782,-96.633137 42.768783,-96.633323 42.768736,-96.63354 42.768653,-96.633622 42.768614,-96.634214 42.768138,-96.634291 42.768093,-96.634415 42.768036,-96.63474 42.767955,-96.634935 42.767938,-96.635081 42.767949,-96.635508 42.768034,-96.635553 42.768048,-96.635924 42.768223,-96.636036 42.768292,-96.636135 42.768371,-96.636344 42.768569,-96.636393 42.768631,-96.636551 42.769006,-96.636549 42.769077,-96.636526 42.769254,-96.636516 42.769396,-96.63647 42.769535,-96.636382 42.76974,-96.636338 42.769803,-96.636055 42.770096,-96.63567 42.770419,-96.635417 42.770589,-96.635176 42.770713,-96.635091 42.770748,-96.634036 42.771129,-96.633582 42.771262,-96.633487 42.771279,-96.633199 42.771319,-96.633054 42.771332,-96.633004 42.771329,-96.632812 42.7713,-96.63277 42.771283,-96.632733 42.77126,-96.632577 42.771122,-96.632511 42.771026,-96.632469 42.770924,-96.632365 42.770467,-96.632373 42.770397,-96.6324 42.770256,-96.632385 42.770185,-96.632312 42.770015,-96.632196 42.769858,-96.632133 42.769803,-96.631959 42.769678,-96.631918 42.769658,-96.631827 42.769631,-96.631682 42.769615,-96.631633 42.769613,-96.631486 42.769616,-96.631309 42.76965,-96.631183 42.769705,-96.631074 42.769778,-96.630961 42.769937,-96.630874 42.770023,-96.630776 42.770146,-96.630707 42.770317,-96.630648 42.770599,-96.630638 42.770669,-96.630583 42.770768,-96.630536 42.770831,-96.630306 42.771105,-96.629937 42.771482,-96.629929 42.77149,-96.629652 42.771815,-96.629587 42.771868,-96.629473 42.771934,-96.629431 42.771953,-96.629339 42.771977,-96.629245 42.771994,-96.629147 42.772001,-96.62905 42.771997,-96.628865 42.77195,-96.62865 42.771865,-96.62809 42.771576,-96.627705 42.77142,-96.627573 42.771372,-96.627126 42.771225,-96.626881 42.771215,-96.626832 42.771216,-96.626785 42.771225,-96.626398 42.77138,-96.626361 42.771403,-96.626223 42.771538,-96.626197 42.771568,-96.626073 42.771801,-96.626052 42.772194,-96.626054 42.77223,-96.626096 42.772442,-96.626264 42.772928,-96.626526 42.773312,-96.626813 42.773844,-96.626839 42.773874,-96.626905 42.773927,-96.626965 42.773983,-96.627055 42.77411,-96.627081 42.774178,-96.627138 42.774532,-96.627143 42.774711,-96.627107 42.774995,-96.627069 42.775135,-96.626985 42.775302,-96.626859 42.775456,-96.626627 42.775686,-96.626595 42.775713,-96.626523 42.775761,-96.626481 42.77578,-96.626219 42.775877,-96.626084 42.775921,-96.625614 42.776023,-96.625565 42.776026,-96.625517 42.776034,-96.625379 42.776071,-96.625216 42.77615,-96.625171 42.776163,-96.624733 42.776206,-96.624537 42.776211,-96.623608 42.776166,-96.623071 42.776202,-96.622975 42.776218,-96.622929 42.77623,-96.622621 42.77634,-96.622422 42.776445,-96.622283 42.776546,-96.622041 42.776771,-96.621985 42.77683,-96.62184 42.777134,-96.621815 42.777203,-96.621777 42.777343,-96.62177 42.777414,-96.621791 42.777628,-96.621949 42.778152,-96.621966 42.778667,-96.621968 42.778724,-96.621958 42.778795,-96.621921 42.778829,-96.621896 42.77886,-96.621767 42.779053,-96.621751 42.779086,-96.621594 42.779609,-96.621512 42.779777,-96.6215 42.779848,-96.621469 42.780132,-96.621469 42.780168,-96.621476 42.780203,-96.621503 42.780272,-96.621544 42.780337,-96.621509 42.780404,-96.621437 42.780575,-96.621191 42.781042,-96.620996 42.78137,-96.620756 42.781839,-96.620711 42.781941,-96.620502 42.782566,-96.620432 42.782737,-96.620331 42.78305,-96.620122 42.783413,-96.619849 42.783792,-96.619791 42.78385,-96.619503 42.784043,-96.619462 42.784064,-96.619285 42.784124,-96.619049 42.784174,-96.618471 42.784257,-96.617806 42.784381,-96.617306 42.784529,-96.617008 42.784653,-96.616487 42.784921,-96.616148 42.785066,-96.616101 42.785074,-96.616052 42.785075,-96.615905 42.785068,-96.615616 42.785026,-96.615569 42.785016,-96.615528 42.784997,-96.61542 42.784924,-96.615358 42.784868,-96.615284 42.784776,-96.61522 42.784603,-96.615201 42.784497,-96.615246 42.784249,-96.615367 42.783939,-96.615489 42.783557,-96.615518 42.783452,-96.615547 42.783238,-96.615549 42.783167,-96.615467 42.782815,-96.615432 42.782749,-96.615264 42.78253,-96.615204 42.782474,-96.615133 42.782425,-96.615051 42.782386,-96.614882 42.782314,-96.6148 42.782275,-96.61471 42.782247,-96.614612 42.782246,-96.614515 42.782254,-96.614326 42.782293,-96.61428 42.782306,-96.614148 42.782354,-96.614111 42.782377,-96.613945 42.782509,-96.61384 42.782629,-96.613716 42.782975,-96.613695 42.783045,-96.613624 42.783363,-96.613462 42.783812,-96.613264 42.784216,-96.613191 42.784309,-96.613073 42.784426,-96.61297 42.784503,-96.61293 42.784524,-96.612887 42.784541,-96.612707 42.784597,-96.612563 42.78462,-96.612465 42.784622,-96.612272 42.784595,-96.612226 42.784582,-96.611972 42.784475,-96.611932 42.784454,-96.61172 42.784306,-96.61169 42.784278,-96.611548 42.784012,-96.61132 42.783316,-96.611276 42.783214,-96.611046 42.782858,-96.610954 42.782775,-96.610918 42.782751,-96.610536 42.782589,-96.610489 42.782578,-96.61015 42.782538,-96.610052 42.782534,-96.610003 42.782536,-96.609907 42.78255,-96.609837 42.782526,-96.609745 42.782502,-96.609697 42.782494,-96.609599 42.78249,-96.609406 42.782518,-96.609363 42.782534,-96.609216 42.782629,-96.609152 42.782683,-96.609071 42.782772,-96.609049 42.782804,-96.609022 42.782873,-96.609014 42.782944,-96.609019 42.783016,-96.609028 42.78305,-96.609092 42.783104,-96.609102 42.783241,-96.609089 42.783384,-96.609109 42.783705,-96.609104 42.783741,-96.609052 42.783879,-96.609001 42.783979,-96.608979 42.784011,-96.608895 42.784099,-96.608791 42.784175,-96.608752 42.784197,-96.608417 42.784346,-96.608279 42.784384,-96.607993 42.784434,-96.607895 42.784441,-96.607846 42.784438,-96.607559 42.784392,-96.607384 42.784328,-96.607345 42.784306,-96.607312 42.784279,-96.60677 42.783726,-96.606719 42.783686,-96.606571 42.783569,-96.606228 42.783366,-96.606067 42.783284,-96.605982 42.783249,-96.605389 42.783078,-96.605008 42.783009,-96.604959 42.783005,-96.604862 42.783015,-96.60444 42.78311,-96.604179 42.783208,-96.60414 42.78323,-96.603964 42.783355,-96.603934 42.783382,-96.603909 42.783414,-96.603831 42.783544,-96.603695 42.783693,-96.603673 42.783725,-96.603619 42.783824,-96.603567 42.783962,-96.603565 42.783997,-96.603582 42.78414,-96.603684 42.784453,-96.603703 42.78456,-96.603859 42.785157,-96.603864 42.785192,-96.603859 42.785514,-96.603852 42.785549,-96.603723 42.785894,-96.603678 42.785996,-96.603275 42.786487,-96.602978 42.786815,-96.602686 42.787188,-96.602404 42.787759,-96.602355 42.788006,-96.602345 42.788113,-96.602358 42.788184,-96.602404 42.788323,-96.602557 42.78874,-96.60302 42.789014,-96.60331 42.789108,-96.603337 42.789138,-96.603704 42.789426,-96.604038 42.789635,-96.604234 42.789795,-96.604311 42.789839,-96.604521 42.789931,-96.604633 42.790049,-96.604682 42.790111,-96.604742 42.790167,-96.604848 42.790242,-96.604943 42.790286,-96.604981 42.790399,-96.605053 42.790532,-96.605066 42.790567,-96.605229 42.791163,-96.605231 42.79127,-96.605196 42.791447,-96.605007 42.791696,-96.60491 42.791776,-96.60484 42.791827,-96.604403 42.792112,-96.604245 42.792195,-96.604155 42.792224,-96.603732 42.792315,-96.603637 42.792332,-96.60354 42.792344,-96.603442 42.792347,-96.60305 42.792344,-96.602759 42.792315,-96.602712 42.792305,-96.602156 42.792077,-96.601761 42.791935,-96.601473 42.791871,-96.601244 42.791821,-96.600909 42.791766,-96.600765 42.791746,-96.600666 42.791749,-96.599882 42.791793,-96.599538 42.791782,-96.599293 42.791768,-96.598116 42.79181,-96.597628 42.791852,-96.597198 42.791924,-96.597108 42.791952,-96.596849 42.792055,-96.596646 42.792155,-96.596495 42.792247,-96.596059 42.792478,-96.595625 42.792645,-96.595343 42.792788,-96.595272 42.792838,-96.595214 42.792896,-96.595052 42.793115,-96.595035 42.793149,-96.595006 42.793254,-96.595003 42.793468,-96.595009 42.79354,-96.595017 42.793575,-96.59511 42.793778,-96.595173 42.793875,-96.595199 42.793906,-96.595378 42.794076,-96.595479 42.794154,-96.595552 42.794202,-96.595636 42.794238,-96.596228 42.794412,-96.596484 42.794517,-96.596596 42.794586,-96.596775 42.794757,-96.5968 42.794788,-96.596855 42.794887,-96.596968 42.795198,-96.596988 42.795268,-96.597001 42.79541,-96.596933 42.795872,-96.596937 42.795944,-96.596964 42.796049,-96.596991 42.796118,-96.597134 42.796422,-96.597175 42.796487,-96.59729 42.796603,-96.597375 42.79666,-96.597702 42.796819,-96.598145 42.796972,-96.599132 42.797372,-96.599298 42.797447,-96.599378 42.797489,-96.59941 42.797516,-96.599522 42.797634,-96.599589 42.797729,-96.599617 42.797798,-96.599637 42.797867,-96.599704 42.798186,-96.599707 42.798257,-96.599683 42.798435,-96.59946 42.798983,-96.599442 42.799016,-96.59921 42.799331,-96.598976 42.799603,-96.598945 42.799631,-96.598627 42.799854,-96.598506 42.799916,-96.598463 42.799932,-96.59827 42.799961,-96.598172 42.799966,-96.598041 42.799918,-96.597963 42.799875,-96.597832 42.799768,-96.597811 42.799736,-96.597802 42.799701,-96.597747 42.79931,-96.597607 42.79882,-96.597481 42.798512,-96.597317 42.798213,-96.597264 42.798153,-96.59688 42.797828,-96.596574 42.797648,-96.59645 42.79759,-96.596045 42.797461,-96.595857 42.79742,-96.595808 42.797415,-96.595465 42.797431,-96.595276 42.797471,-96.59496 42.79757,-96.594919 42.797588,-96.594588 42.797802,-96.594285 42.798037,-96.594076 42.798235,-96.593605 42.798779,-96.593296 42.799187,-96.592812 42.799969,-96.592594 42.800368,-96.592461 42.800637,-96.592432 42.800705,-96.592422 42.800761,-96.592345 42.801201,-96.592353 42.801272,-96.592425 42.801321,-96.592544 42.801434,-96.592598 42.801493,-96.592806 42.801776,-96.592887 42.801944,-96.592906 42.802014,-96.592911 42.802082,-96.593047 42.802178,-96.593105 42.802235,-96.593131 42.802304,-96.59318 42.802516,-96.593179 42.802587,-96.593172 42.802623,-96.593102 42.802794,-96.593005 42.802958,-96.592169 42.803968,-96.591892 42.804347,-96.591749 42.804575,-96.59161 42.804842,-96.591196 42.805451,-96.591057 42.805867,-96.591003 42.806078,-96.590981 42.806399,-96.590997 42.806578,-96.590997 42.806971,-96.590958 42.807074,-96.590884 42.807244,-96.59081 42.807377,-96.590539 42.807988,-96.590469 42.808233,-96.590465 42.808297,-96.590465 42.808304,-96.590485 42.808447,-96.590525 42.80855,-96.590673 42.808775,-96.590776 42.808897,-96.5909 42.809008,-96.591651 42.809622,-96.591968 42.809846,-96.592049 42.809887,-96.592088 42.809908,-96.592441 42.810035,-96.592912 42.810137,-96.593056 42.810159,-96.593154 42.810166,-96.593694 42.810142,-96.593936 42.810112,-96.594078 42.810085,-96.594466 42.810039,-96.594564 42.810036,-96.594613 42.810041,-96.595284 42.810146,-96.59533 42.810158,-96.595493 42.810239,-96.595566 42.810286,-96.595626 42.810343,-96.595697 42.810437,-96.595723 42.810607,-96.595712 42.810929,-96.59567 42.811177,-96.595639 42.811245,-96.595496 42.811433,-96.595263 42.811865,-96.595239 42.811934,-96.595144 42.812358,-96.595118 42.812643,-96.595121 42.812786,-96.595126 42.812822,-96.595214 42.8131,-96.595306 42.813266,-96.595374 42.813353,-96.59562 42.813671,-96.595798 42.813965,-96.595879 42.814171,-96.595962 42.81474,-96.595945 42.814954,-96.595934 42.814989,-96.595902 42.815057,-96.595677 42.815333,-96.595617 42.81539,-96.595409 42.815542,-96.595143 42.8157,-96.594896 42.815817,-96.594807 42.815846,-96.59457 42.815893,-96.594521 42.815898,-96.594375 42.815903,-96.593886 42.815873,-96.593647 42.815833,-96.592423 42.815463,-96.591632 42.81527,-96.591584 42.815262,-96.591437 42.815259,-96.591096 42.815293,-96.590724 42.815383,-96.590641 42.815421,-96.590605 42.815445,-96.590392 42.815642,-96.590165 42.815999,-96.590089 42.816131,-96.589986 42.816372,-96.589829 42.816746,-96.589782 42.816884,-96.589587 42.817913,-96.589495 42.818039,-96.589367 42.818148,-96.589239 42.8183,-96.589209 42.818328,-96.589174 42.818353,-96.588943 42.818487,-96.588824 42.818473,-96.588731 42.818449,-96.588646 42.818414,-96.588281 42.818232,-96.587665 42.817876,-96.587581 42.817839,-96.58749 42.817861,-96.587442 42.817869,-96.587345 42.817877,-96.586856 42.817848,-96.58671 42.817836,-96.58661 42.817833,-96.586415 42.817828,-96.586268 42.817835,-96.586219 42.817834,-96.586122 42.817822,-96.586029 42.8178,-96.585902 42.817847,-96.585819 42.817886,-96.585781 42.817908,-96.585455 42.818126,-96.585385 42.818177,-96.585158 42.818313,-96.585123 42.818338,-96.584813 42.818615,-96.584705 42.818689,-96.584109 42.819005,-96.584075 42.819031,-96.584051 42.819062,-96.583958 42.819339,-96.583955 42.81941,-96.583978 42.819624,-96.583997 42.819693,-96.584104 42.820004,-96.584168 42.8201,-96.584305 42.82029,-96.584446 42.820388,-96.584527 42.820429,-96.584564 42.820452,-96.584632 42.820504,-96.58488 42.820621,-96.585031 42.820712,-96.585097 42.820764,-96.585463 42.821101,-96.585793 42.821456,-96.585957 42.821715,-96.586037 42.821884,-96.586098 42.822057,-96.586131 42.822233,-96.586119 42.822805,-96.586094 42.822946,-96.585971 42.823402,-96.585808 42.823776,-96.585709 42.823899,-96.585589 42.824013,-96.585413 42.824138,-96.585197 42.824222,-96.584514 42.824423,-96.58434 42.824489,-96.583787 42.82472,-96.583652 42.824763,-96.583514 42.8248,-96.583225 42.824841,-96.583128 42.824851,-96.582833 42.824862,-96.582539 42.824859,-96.581515 42.824756,-96.581319 42.824755,-96.581026 42.824784,-96.580598 42.824865,-96.580554 42.82488,-96.580549 42.824882,-96.580231 42.825043,-96.580193 42.825066,-96.579928 42.825276,-96.579865 42.825331,-96.579808 42.825389,-96.579566 42.825699,-96.579514 42.825759,-96.57945 42.825856,-96.57912 42.826537,-96.579041 42.826668,-96.578809 42.826852,-96.578287 42.827119,-96.57825 42.827143,-96.578152 42.827222,-96.577852 42.827505,-96.577654 42.827791,-96.577635 42.827825,-96.577563 42.827995,-96.577531 42.828136,-96.57753 42.828315,-96.577556 42.828492,-96.57783 42.829067,-96.577891 42.829164,-96.578148 42.829469,-96.578355 42.829669,-96.578707 42.829967,-96.57921 42.830253,-96.579246 42.830277,-96.579398 42.830418,-96.579574 42.830542,-96.57961 42.830573,-96.579796 42.830733,-96.579958 42.830912,-96.580033 42.831004,-96.580192 42.831266,-96.580266 42.831436,-96.580396 42.832036,-96.580434 42.832321,-96.580448 42.832392,-96.580532 42.832671,-96.580561 42.83274,-96.580581 42.832772,-96.580643 42.832828,-96.580719 42.832874,-96.5808 42.832913,-96.580846 42.832927,-96.581224 42.833005,-96.581728 42.833146,-96.581815 42.833179,-96.58215 42.833488,-96.582217 42.833583,-96.582305 42.83375,-96.582326 42.833861,-96.582381 42.834139,-96.582391 42.834282,-96.582362 42.834604,-96.582324 42.83478,-96.582304 42.83485,-96.582164 42.835193,-96.582155 42.835228,-96.582135 42.835371,-96.58208 42.83543,-96.581968 42.835589,-96.581512 42.836381,-96.581498 42.836415,-96.581492 42.836446,-96.581481 42.836521,-96.581474 42.836736,-96.581553 42.837412,-96.581544 42.837519,-96.581489 42.837693,-96.58147 42.837726,-96.581443 42.837756,-96.581378 42.83781,-96.581075 42.837992,-96.580993 42.838031,-96.580907 42.838065,-96.580678 42.838131,-96.580583 42.838149,-96.580193 42.838182,-96.580046 42.838189,-96.579406 42.838186,-96.579112 42.83813,-96.579073 42.838123,-96.578793 42.838056,-96.578704 42.838026,-96.578618 42.837991,-96.578459 42.837907,-96.57833 42.837799,-96.578149 42.837586,-96.578079 42.837494,-96.578036 42.837311,-96.57804 42.837132,-96.578049 42.837097,-96.578172 42.836826,-96.578198 42.836795,-96.57829 42.836712,-96.578438 42.836618,-96.578524 42.836583,-96.57931 42.83629,-96.579389 42.836247,-96.579458 42.836197,-96.579485 42.836167,-96.579577 42.83604,-96.579692 42.835767,-96.579717 42.835626,-96.579705 42.835447,-96.579689 42.835377,-96.579676 42.835342,-96.579574 42.835141,-96.579545 42.835112,-96.579447 42.835032,-96.579377 42.834983,-96.579292 42.834947,-96.578887 42.834818,-96.578605 42.834755,-96.578164 42.834727,-96.578115 42.834729,-96.577907 42.834752,-96.577872 42.834756,-96.577682 42.834792,-96.577276 42.83492,-96.576755 42.83512,-96.576309 42.835343,-96.575848 42.835611,-96.575599 42.835783,-96.575409 42.835947,-96.575336 42.83604,-96.575193 42.836306,-96.575163 42.836411,-96.575101 42.837016,-96.575044 42.837335,-96.574937 42.837611,-96.574919 42.837644,-96.574808 42.837762,-96.574747 42.837818,-96.574675 42.837866,-96.574513 42.837948,-96.574424 42.837978,-96.574303 42.837963,-96.574258 42.837949,-96.57413 42.837896,-96.573966 42.837817,-96.573894 42.837768,-96.573444 42.837389,-96.573265 42.837267,-96.573189 42.837222,-96.572942 42.837104,-96.57285 42.837078,-96.572471 42.837002,-96.572375 42.836989,-96.572276 42.836988,-96.571932 42.836996,-96.57145 42.837065,-96.571172 42.837137,-96.570993 42.837196,-96.569579 42.837775,-96.569402 42.837838,-96.569079 42.837923,-96.569031 42.837928,-96.568932 42.837926,-96.568884 42.837919,-96.5686 42.837861,-96.568465 42.837819,-96.568382 42.837781,-96.568343 42.837759,-96.568046 42.837521,-96.567966 42.837431,-96.567948 42.837397,-96.567896 42.837186,-96.567893 42.837008,-96.567915 42.836902,-96.567939 42.836833,-96.567997 42.836734,-96.568117 42.836577,-96.568303 42.836411,-96.568614 42.836182,-96.56915 42.835868,-96.569184 42.835843,-96.569407 42.835652,-96.569535 42.835499,-96.569638 42.835316,-96.569723 42.835169,-96.569737 42.835135,-96.569772 42.83485,-96.569769 42.834814,-96.569714 42.834568,-96.569683 42.8345,-96.569547 42.834309,-96.569311 42.834038,-96.56928 42.83401,-96.56899 42.833817,-96.567876 42.833114,-96.567529 42.832844,-96.567255 42.832592,-96.567033 42.832355,-96.566858 42.83214,-96.56657 42.831749,-96.566185 42.831227,-96.565765 42.830743,-96.565259 42.830216,-96.564937 42.829814,-96.564844 42.829649,-96.564762 42.829481,-96.564715 42.829342,-96.564699 42.829236,-96.56468 42.829051,-96.564671 42.828951,-96.564668 42.82888,-96.564638 42.828775,-96.564609 42.828708,-96.564545 42.828611,-96.564358 42.828401,-96.564324 42.828375,-96.564032 42.828244,-96.563942 42.828215,-96.563895 42.828204,-96.563751 42.828183,-96.563604 42.828174,-96.563555 42.828177,-96.563177 42.828256,-96.563042 42.8283,-96.5624 42.828629,-96.561972 42.828924,-96.56194 42.828951,-96.561604 42.829302,-96.561554 42.829363,-96.561537 42.829397,-96.561518 42.829467,-96.561485 42.829644,-96.561487 42.82968,-96.561507 42.829712,-96.561535 42.829742,-96.561747 42.82989,-96.562147 42.830099,-96.562181 42.830125,-96.562428 42.830347,-96.562513 42.830434,-96.562749 42.830706,-96.562854 42.830907,-96.563012 42.831356,-96.563016 42.831392,-96.563019 42.831785,-96.563012 42.831821,-96.562973 42.831924,-96.562927 42.832026,-96.562645 42.832597,-96.562441 42.833187,-96.562387 42.833398,-96.562381 42.833745,-96.562395 42.833995,-96.562564 42.834609,-96.562646 42.834906,-96.562689 42.83519,-96.562714 42.835259,-96.562823 42.835496,-96.562834 42.835531,-96.562855 42.835673,-96.562862 42.835887,-96.562809 42.836422,-96.562671 42.836839,-96.562537 42.83703,-96.562511 42.83706,-96.562086 42.837455,-96.562029 42.837513,-96.561938 42.837585,-96.561529 42.837907,-96.561359 42.838082,-96.561316 42.838146,-96.56124 42.838427,-96.561219 42.83864,-96.561172 42.838779,-96.561125 42.838881,-96.560976 42.839106,-96.560944 42.839134,-96.56087 42.83918,-96.560405 42.839444,-96.560279 42.839501,-96.560235 42.839515,-96.560179 42.839528,-96.559721 42.839638,-96.559333 42.839681,-96.559284 42.83968,-96.558942 42.83965,-96.558896 42.839639,-96.558543 42.839512,-96.558459 42.839475,-96.558312 42.839381,-96.558205 42.839307,-96.557847 42.839012,-96.557818 42.838984,-96.557622 42.838736,-96.557296 42.838176,-96.557134 42.837839,-96.556877 42.837453,-96.556762 42.837294,-96.55668 42.837259,-96.55652 42.837176,-96.556484 42.837152,-96.556376 42.837038,-96.556289 42.836946,-96.556167 42.836834,-96.556116 42.836773,-96.556072 42.836709,-96.556 42.836538,-96.555787 42.836461,-96.554944 42.836267,-96.553986 42.836106,-96.553503 42.836041,-96.553389 42.836028,-96.553068 42.835992,-96.552826 42.835969,-96.552778 42.835961,-96.552239 42.83598,-96.552191 42.835988,-96.551568 42.836202,-96.551528 42.836222,-96.551381 42.836317,-96.551127 42.836535,-96.551037 42.83662,-96.550875 42.836799,-96.550592 42.837149,-96.550562 42.837178,-96.550322 42.837531,-96.550308 42.837555,-96.549652 42.8388,-96.54945 42.839277,-96.549417 42.839345,-96.549305 42.839543,-96.548963 42.84005,-96.548701 42.84044,-96.54864 42.840537,-96.548627 42.840572,-96.548586 42.840748,-96.548586 42.84082,-96.548598 42.840891,-96.548919 42.841057,-96.548964 42.841073,-96.549243 42.841142,-96.549337 42.841162,-96.549724 42.841214,-96.550631 42.841376,-96.550907 42.841452,-96.551128 42.84153,-96.552045 42.841876,-96.552258 42.841965,-96.552634 42.842133,-96.552714 42.842175,-96.553164 42.842506,-96.553224 42.842562,-96.553537 42.842896,-96.553805 42.843182,-96.553904 42.843306,-96.55425 42.843858,-96.554287 42.843925,-96.55459 42.844642,-96.55463 42.844782,-96.554771 42.845235,-96.554796 42.845377,-96.554815 42.845555,-96.554818 42.845877,-96.554838 42.846378,-96.55494 42.847196,-96.55497 42.847301,-96.555125 42.84764,-96.555301 42.847935,-96.55552 42.848215,-96.555839 42.848487,-96.555938 42.848606,-96.556036 42.84877,-96.556075 42.84891,-96.556081 42.848946,-96.556088 42.849196,-96.556083 42.849231,-96.556071 42.849266,-96.556036 42.849333,-96.555891 42.84952,-96.555828 42.849575,-96.555714 42.849642,-96.555629 42.849678,-96.555497 42.849726,-96.555266 42.849787,-96.555119 42.849791,-96.55507 42.849787,-96.555022 42.849778,-96.554884 42.849741,-96.55475 42.849695,-96.554554 42.849588,-96.554222 42.849325,-96.553577 42.848738,-96.553413 42.848605,-96.553153 42.848441,-96.552809 42.848238,-96.552722 42.848206,-96.551597 42.847848,-96.55077 42.847626,-96.55068 42.847599,-96.550586 42.84758,-96.550537 42.847574,-96.550195 42.847584,-96.549951 42.847605,-96.549764 42.847647,-96.54972 42.847663,-96.549556 42.847742,-96.549519 42.847765,-96.549452 42.847817,-96.549425 42.847847,-96.549321 42.848085,-96.549316 42.848121,-96.549338 42.848335,-96.549348 42.84837,-96.549438 42.848536,-96.549482 42.8486,-96.549541 42.848655,-96.549825 42.848854,-96.550132 42.849032,-96.550162 42.84906,-96.550206 42.84911,-96.550426 42.849362,-96.55047 42.849426,-96.550503 42.849493,-96.550538 42.849634,-96.550564 42.849848,-96.550558 42.850098,-96.550465 42.850302,-96.550423 42.850366,-96.550161 42.850626,-96.55011 42.850687,-96.549997 42.850804,-96.549945 42.850864,-96.549692 42.851083,-96.549657 42.851108,-96.549454 42.851208,-96.549407 42.851218,-96.549165 42.851251,-96.549116 42.851253,-96.548777 42.851211,-96.548733 42.851195,-96.548418 42.851023,-96.548351 42.850971,-96.548083 42.850715,-96.548001 42.850626,-96.547575 42.850063,-96.547548 42.850033,-96.547393 42.849895,-96.547289 42.849824,-96.547177 42.849748,-96.547138 42.849727,-96.547091 42.849715,-96.546615 42.849625,-96.546531 42.849624,-96.546076 42.849621,-96.545978 42.849628,-96.545694 42.849685,-96.545512 42.849739,-96.545262 42.849854,-96.545108 42.849943,-96.544947 42.850078,-96.544857 42.850162,-96.544831 42.850193,-96.544577 42.850657,-96.544469 42.850856,-96.544385 42.851062,-96.544367 42.851095,-96.544193 42.851351,-96.544051 42.851565,-96.543931 42.851837,-96.543759 42.852359,-96.543728 42.852427,-96.543428 42.852916,-96.543273 42.853083,-96.543209 42.853153,-96.543003 42.853477,-96.542912 42.853603,-96.542688 42.854038,-96.542219 42.855131,-96.542136 42.855337,-96.541717 42.856329,-96.541455 42.856868,-96.541357 42.857145,-96.541342 42.857215,-96.541323 42.857358,-96.541168 42.857882,-96.541152 42.857989,-96.541142 42.858167,-96.541152 42.858238,-96.541244 42.858516,-96.541253 42.858535,-96.541464 42.858952,-96.541509 42.859016,-96.541825 42.859378,-96.542108 42.859576,-96.54219 42.859616,-96.542234 42.859631,-96.54262 42.859688,-96.542701 42.859681,-96.542718 42.85968,-96.542763 42.859666,-96.54302 42.859561,-96.543112 42.859504,-96.543177 42.85945,-96.543204 42.85942,-96.543282 42.859289,-96.543315 42.858789,-96.543322 42.858754,-96.543346 42.858685,-96.543559 42.858247,-96.543581 42.858215,-96.543609 42.858185,-96.543768 42.858049,-96.544198 42.857754,-96.544547 42.857556,-96.544831 42.857358,-96.544933 42.85728,-96.54506 42.857171,-96.545212 42.857081,-96.545359 42.857068,-96.545798 42.857103,-96.545941 42.857129,-96.546176 42.857179,-96.546662 42.857352,-96.546784 42.857411,-96.546819 42.857436,-96.546937 42.85755,-96.546984 42.857613,-96.547062 42.85782,-96.547117 42.858139,-96.547117 42.85821,-96.547065 42.858746,-96.547014 42.858957,-96.546948 42.859129,-96.546864 42.859258,-96.546574 42.859632,-96.546534 42.859732,-96.546417 42.859967,-96.546254 42.860187,-96.546214 42.860252,-96.546147 42.860424,-96.546067 42.860667,-96.546035 42.860916,-96.546047 42.860987,-96.546074 42.861092,-96.5461 42.861161,-96.546122 42.861193,-96.546201 42.861283,-96.546409 42.861436,-96.546531 42.861496,-96.546575 42.861512,-96.547026 42.861652,-96.547074 42.861661,-96.54717 42.861675,-96.547318 42.861676,-96.547607 42.861635,-96.547745 42.861598,-96.548033 42.861556,-96.548132 42.861551,-96.548229 42.861561,-96.54847 42.861596,-96.548806 42.861651,-96.548944 42.861689,-96.548986 42.861708,-96.549121 42.861812,-96.549332 42.862053,-96.549989 42.862586,-96.550183 42.862793,-96.550206 42.862824,-96.550346 42.863091,-96.550392 42.863193,-96.550402 42.863228,-96.550451 42.863548,-96.550449 42.863576,-96.550445 42.863655,-96.550438 42.86369,-96.550414 42.863759,-96.550358 42.863859,-96.550289 42.863953,-96.550227 42.864008,-96.550116 42.864079,-96.550031 42.864114,-96.549898 42.864159,-96.54985 42.864168,-96.549801 42.864172,-96.549408 42.864168,-96.549311 42.864163,-96.549027 42.864106,-96.548764 42.864009,-96.548433 42.863854,-96.547998 42.863687,-96.547628 42.863592,-96.547533 42.863572,-96.547389 42.86355,-96.547243 42.863534,-96.547194 42.863533,-96.547097 42.86354,-96.546905 42.863575,-96.546861 42.86359,-96.546786 42.863637,-96.546692 42.863719,-96.546616 42.863811,-96.546573 42.863914,-96.546524 42.864125,-96.546396 42.864942,-96.546237 42.865502,-96.546217 42.86563,-96.546005 42.866291,-96.545984 42.866433,-96.545947 42.866861,-96.545956 42.866968,-96.546024 42.867249,-96.546174 42.867552,-96.546288 42.867711,-96.546405 42.867826,-96.54655 42.867921,-96.546672 42.867982,-96.547794 42.868347,-96.548217 42.86853,-96.548334 42.868595,-96.549422 42.869319,-96.549623 42.869565,-96.54964 42.869599,-96.549682 42.869738,-96.549701 42.86988,-96.549701 42.869916,-96.549674 42.870166,-96.549642 42.870307,-96.549626 42.870341,-96.549486 42.870569,-96.549436 42.87063,-96.549376 42.870687,-96.548849 42.871062,-96.548693 42.871201,-96.548636 42.871259,-96.548395 42.87161,-96.548267 42.871763,-96.547957 42.872249,-96.547733 42.872646,-96.547564 42.873057,-96.547509 42.873157,-96.547366 42.873596,-96.547146 42.873955,-96.547022 42.874065,-96.546964 42.874122,-96.54676 42.874366,-96.546729 42.874394,-96.546561 42.874524,-96.546468 42.874547,-96.546324 42.874573,-96.546226 42.874571,-96.546129 42.874559,-96.545702 42.874474,-96.545606 42.87446,-96.545164 42.874452,-96.544918 42.874468,-96.544588 42.874539,-96.543946 42.874719,-96.543857 42.874749,-96.543219 42.875083,-96.541829 42.876096,-96.541454 42.876428,-96.541426 42.876457,-96.541381 42.87652,-96.541345 42.876587,-96.541263 42.876716,-96.541167 42.87688,-96.540914 42.877143,-96.540852 42.877198,-96.540484 42.877485,-96.540445 42.877507,-96.540189 42.877614,-96.539788 42.87775,-96.539603 42.877798,-96.538938 42.877927,-96.538438 42.878078,-96.537855 42.878344,-96.53767 42.878462,-96.537652 42.878565,-96.537635 42.878743,-96.537636 42.878779,-96.537649 42.878813,-96.537837 42.879104,-96.537961 42.879215,-96.538416 42.879577,-96.538557 42.879689,-96.53881 42.879953,-96.539284 42.880363,-96.53942 42.880466,-96.539474 42.880526,-96.539532 42.880625,-96.539595 42.880658,-96.539627 42.880685,-96.539856 42.880917,-96.540352 42.881534,-96.540465 42.881651,-96.540534 42.881702,-96.540613 42.881745,-96.542392 42.882355,-96.542931 42.882605,-96.543174 42.882782,-96.543206 42.882809,-96.543258 42.88287,-96.543464 42.883233,-96.543485 42.883303,-96.543511 42.883552,-96.543498 42.88373,-96.543485 42.883765,-96.543379 42.883965,-96.543312 42.884061,-96.543284 42.88409,-96.54322 42.884144,-96.543138 42.884184,-96.543095 42.8842,-96.54228 42.884452,-96.540627 42.885007,-96.54024 42.885163,-96.540028 42.885255,-96.539102 42.885726,-96.538815 42.885864,-96.538245 42.886205,-96.537977 42.886414,-96.537885 42.886497,-96.537858 42.886527,-96.537695 42.886748,-96.53768 42.886782,-96.537662 42.886852,-96.537657 42.887066,-96.537663 42.887102,-96.53774 42.887271,-96.537793 42.887372,-96.53803 42.8876,-96.538144 42.887668,-96.538714 42.887856,-96.538826 42.887888,-96.53931 42.888026,-96.539396 42.88806,-96.539678 42.888205,-96.539715 42.888228,-96.540008 42.88847,-96.540353 42.888818,-96.540371 42.888851,-96.540439 42.889096,-96.540443 42.889131,-96.540376 42.889449,-96.540237 42.889596,-96.540204 42.889623,-96.540165 42.889645,-96.539838 42.889803,-96.539748 42.889832,-96.539467 42.889897,-96.539223 42.889921,-96.539075 42.889924,-96.538584 42.889916,-96.538536 42.889911,-96.538154 42.889844,-96.537751 42.889712,-96.537252 42.889484,-96.537074 42.889423,-96.536887 42.889381,-96.536741 42.889367,-96.536593 42.88937,-96.536401 42.8894,-96.536308 42.889423,-96.536221 42.889456,-96.536011 42.889549,-96.535778 42.88968,-96.534955 42.890393,-96.534804 42.890485,-96.534682 42.890546,-96.534598 42.890582,-96.534454 42.890607,-96.534357 42.890616,-96.534014 42.890629,-96.533528 42.890581,-96.533137 42.890554,-96.531661 42.890532,-96.530878 42.89056,-96.529057 42.890568,-96.528883 42.89056,-96.528812 42.890557,-96.528326 42.890502,-96.528265 42.890535,-96.528088 42.890599,-96.528041 42.890609,-96.527992 42.890614,-96.52765 42.890598,-96.527306 42.890604,-96.52721 42.890617,-96.527163 42.890628,-96.526714 42.890773,-96.526627 42.890807,-96.526134 42.8911,-96.52609 42.891117,-96.525907 42.891169,-96.525858 42.891175,-96.52576 42.891179,-96.525662 42.891174,-96.52559 42.891241,-96.525479 42.89136,-96.525435 42.891424,-96.525328 42.891661,-96.525287 42.89191,-96.525309 42.892267,-96.525329 42.892337,-96.525381 42.892437,-96.525478 42.892562,-96.525506 42.892591,-96.525664 42.892728,-96.525739 42.892774,-96.526039 42.892897,-96.526174 42.892939,-96.52627 42.892956,-96.526766 42.893012,-96.527532 42.8931,-96.527628 42.893116,-96.528358 42.893328,-96.529011 42.893578,-96.529168 42.893664,-96.529239 42.893714,-96.529434 42.893875,-96.529518 42.893963,-96.529568 42.894024,-96.529692 42.894218,-96.529781 42.894385,-96.529928 42.894837,-96.529946 42.895015,-96.529951 42.895194,-96.529938 42.895337,-96.530027 42.895419,-96.530076 42.895481,-96.530107 42.895549,-96.530113 42.895585,-96.530112 42.895764,-96.530104 42.895835,-96.530023 42.896004,-96.530003 42.896037,-96.529928 42.896128,-96.529834 42.896211,-96.529759 42.896257,-96.529716 42.896274,-96.529488 42.896342,-96.529149 42.89638,-96.528828 42.89647,-96.528786 42.896489,-96.528675 42.896559,-96.528552 42.896671,-96.528499 42.896731,-96.528375 42.896925,-96.528349 42.896995,-96.528346 42.897173,-96.528376 42.897387,-96.528412 42.897472,-96.528509 42.897636,-96.528536 42.897666,-96.528734 42.897825,-96.528873 42.897926,-96.528987 42.897994,-96.529355 42.898174,-96.529484 42.898226,-96.530627 42.898554,-96.530985 42.898674,-96.531304 42.898842,-96.532246 42.899416,-96.53293 42.899699,-96.533334 42.899902,-96.533458 42.89996,-96.533685 42.900029,-96.534054 42.900129,-96.534197 42.900156,-96.534534 42.900208,-96.534767 42.900266,-96.534854 42.900299,-96.535022 42.900372,-96.535625 42.900736,-96.535666 42.900756,-96.535934 42.900843,-96.536124 42.900879,-96.53637 42.90088,-96.536613 42.900854,-96.536752 42.900817,-96.537081 42.900657,-96.537161 42.900619,-96.537278 42.900554,-96.537685 42.900295,-96.537846 42.90016,-96.538164 42.899937,-96.538202 42.899916,-96.538248 42.899902,-96.538625 42.89982,-96.538771 42.899806,-96.539017 42.899803,-96.539113 42.899816,-96.539347 42.899871,-96.539531 42.899939,-96.539573 42.899958,-96.539761 42.900073,-96.539863 42.900151,-96.539923 42.900207,-96.540054 42.900359,-96.540547 42.901139,-96.540835 42.90171,-96.54091 42.901842,-96.541296 42.902381,-96.541478 42.902594,-96.542048 42.903085,-96.542506 42.90341,-96.542872 42.903699,-96.54293 42.903756,-96.543071 42.904061,-96.543081 42.904096,-96.543088 42.904202,-96.543087 42.904417,-96.543081 42.904438,-96.543069 42.904487,-96.543033 42.904553,-96.542877 42.904736,-96.542686 42.904899,-96.542651 42.904924,-96.542416 42.905054,-96.542325 42.905079,-96.542276 42.905085,-96.54208 42.905097,-96.541883 42.905096,-96.541786 42.905084,-96.541505 42.905019,-96.540642 42.904758,-96.539987 42.904602,-96.539748 42.90456,-96.539553 42.904541,-96.539406 42.904537,-96.538965 42.904571,-96.538675 42.90461,-96.537727 42.904802,-96.537547 42.904858,-96.53746 42.904893,-96.536964 42.905124,-96.536815 42.905218,-96.536601 42.905414,-96.536478 42.905609,-96.536467 42.905643,-96.536491 42.905928,-96.53651 42.905998,-96.536545 42.906065,-96.536588 42.906129,-96.536942 42.906557,-96.536976 42.906584,-96.537138 42.906678,-96.538089 42.907232,-96.538157 42.907283,-96.538421 42.907541,-96.538573 42.907805,-96.538586 42.90784,-96.538624 42.908052,-96.538632 42.908159,-96.53863 42.908195,-96.5386 42.908373,-96.53853 42.908581,-96.538458 42.908771,-96.538308 42.909166,-96.538063 42.909756,-96.537727 42.91057,-96.537733 42.910785,-96.537743 42.91082,-96.537809 42.910954,-96.537832 42.910986,-96.53786 42.911015,-96.53797 42.911098,-96.538207 42.911147,-96.538592 42.911209,-96.538835 42.911232,-96.539174 42.911277,-96.539363 42.911317,-96.539584 42.911395,-96.539625 42.911415,-96.53973 42.911491,-96.539829 42.91157,-96.539885 42.911628,-96.539909 42.91166,-96.540009 42.91201,-96.540014 42.912081,-96.540023 42.912117,-96.5401 42.912318,-96.540063 42.912401,-96.53996 42.912677,-96.539383 42.913626,-96.53926 42.913898,-96.539134 42.914317,-96.53909 42.914709,-96.538943 42.915306,-96.538901 42.915409,-96.538745 42.91571,-96.538688 42.915809,-96.538542 42.915994,-96.538335 42.916206,-96.538257 42.916286,-96.538055 42.916532,-96.537918 42.916761,-96.537847 42.916894,-96.537834 42.916929,-96.537772 42.917175,-96.537759 42.917318,-96.53777 42.917425,-96.537835 42.917634,-96.537874 42.9177,-96.538087 42.917982,-96.538122 42.918004,-96.538215 42.918028,-96.538302 42.918062,-96.538343 42.918082,-96.538571 42.918219,-96.538948 42.918388,-96.539939 42.918603,-96.539984 42.918617,-96.540156 42.918686,-96.540565 42.918886,-96.540862 42.919073,-96.540988 42.919183,-96.541164 42.919406,-96.541205 42.919484,-96.541269 42.919606,-96.541525 42.920261,-96.541675 42.920749,-96.541721 42.920997,-96.541739 42.921391,-96.541737 42.921927,-96.541705 42.922498,-96.541619 42.922922,-96.541451 42.923517,-96.541283 42.923927,-96.541034 42.924356,-96.540963 42.924448,-96.540974 42.924483,-96.540977 42.924519,-96.540966 42.924626,-96.540954 42.924661,-96.540903 42.924761,-96.54088 42.924792,-96.540812 42.924843,-96.540665 42.924938,-96.540595 42.924988,-96.540555 42.925009,-96.540511 42.925025,-96.540463 42.925033,-96.54022 42.925058,-96.540171 42.92506,-96.540073 42.925057,-96.539926 42.925066,-96.539758 42.924973,-96.539674 42.924935,-96.539629 42.92492,-96.539349 42.924852,-96.539258 42.924825,-96.538791 42.924626,-96.538547 42.924505,-96.538282 42.924345,-96.537965 42.924121,-96.537598 42.923831,-96.537298 42.923548,-96.53684 42.923277,-96.5365 42.923132,-96.536409 42.923106,-96.536065 42.923091,-96.535967 42.923092,-96.535679 42.923139,-96.535538 42.923172,-96.534765 42.923401,-96.534543 42.923478,-96.534255 42.923616,-96.534106 42.92371,-96.533294 42.924331,-96.533133 42.924466,-96.532981 42.92465,-96.532953 42.924719,-96.532952 42.924754,-96.532964 42.924861,-96.532975 42.924896,-96.533018 42.92496,-96.533187 42.925136,-96.533254 42.925188,-96.533327 42.925234,-96.533423 42.925251,-96.533469 42.925264,-96.533555 42.925299,-96.533588 42.925325,-96.533828 42.925595,-96.534236 42.925999,-96.534438 42.926244,-96.534475 42.926311,-96.534562 42.926553,-96.534584 42.926659,-96.534604 42.926837,-96.534592 42.92698,-96.534575 42.92705,-96.534468 42.927399,-96.534223 42.927905,-96.534105 42.928102,-96.534061 42.928166,-96.533986 42.928258,-96.533761 42.928492,-96.532509 42.929687,-96.532156 42.930016,-96.531862 42.930303,-96.52967 42.932636,-96.528843 42.933391,-96.527595 42.934253,-96.527457 42.934355,-96.527264 42.934517,-96.526437 42.935078,-96.52597 42.935337,-96.525889 42.935382,-96.525606 42.935525,-96.525312 42.935627,-96.525078 42.935684,-96.524458 42.935798,-96.524164 42.935816,-96.523771 42.935819,-96.523137 42.935756,-96.522854 42.935694,-96.522767 42.93566,-96.522177 42.935402,-96.52178 42.93519,-96.521704 42.935145,-96.521373 42.93488,-96.52132 42.93482,-96.521178 42.934592,-96.520722 42.933958,-96.52058 42.933691,-96.520543 42.933587,-96.52052 42.933445,-96.52053 42.932765,-96.520484 42.932517,-96.52047 42.932482,-96.52045 42.93245,-96.520324 42.932296,-96.520295 42.932267,-96.519884 42.932011,-96.519799 42.931976,-96.51929 42.931841,-96.518607 42.931776,-96.51846 42.931766,-96.518312 42.931762,-96.518245 42.931784,-96.518055 42.931822,-96.517604 42.931965,-96.517176 42.932142,-96.516868 42.932321,-96.516835 42.932347,-96.516685 42.932489,-96.516505 42.932743,-96.51647 42.93281,-96.516415 42.933058,-96.516342 42.933735,-96.516337 42.934343,-96.516347 42.934521,-96.51645 42.9352,-96.51658 42.935507,-96.516745 42.935767,-96.516819 42.93586,-96.517474 42.936293,-96.517725 42.936483,-96.517815 42.936551,-96.518193 42.93678,-96.518234 42.9368,-96.518784 42.936957,-96.519045 42.937057,-96.519123 42.937101,-96.519179 42.937159,-96.519858 42.937989,-96.520073 42.938464,-96.520162 42.938888,-96.520164 42.938924,-96.520089 42.939422,-96.519996 42.939736,-96.51987 42.939969,-96.519824 42.940033,-96.519587 42.940305,-96.519345 42.94053,-96.518928 42.940834,-96.518522 42.941093,-96.517844 42.941518,-96.517285 42.94181,-96.517049 42.941939,-96.516755 42.942129,-96.516503 42.942299,-96.515596 42.942955,-96.514857 42.943531,-96.514775 42.94362,-96.514675 42.943743,-96.514627 42.943845,-96.514575 42.943983,-96.514566 42.944018,-96.514567 42.944054,-96.514608 42.944338,-96.514604 42.944374,-96.514586 42.944444,-96.514529 42.944543,-96.514506 42.944575,-96.51431 42.944781,-96.514276 42.944807,-96.514198 42.944851,-96.513924 42.94493,-96.513875 42.944934,-96.513631 42.944913,-96.513535 42.944896,-96.513442 42.944874,-96.512798 42.94461,-96.512708 42.944582,-96.512431 42.944506,-96.512286 42.944485,-96.511606 42.944404,-96.511312 42.944391,-96.510683 42.944479,-96.510258 42.94457,-96.510079 42.94463,-96.509869 42.944723,-96.50949 42.944951,-96.509426 42.945005,-96.509288 42.945153,-96.509246 42.945217,-96.509138 42.945417,-96.509127 42.945452,-96.509117 42.945523,-96.509126 42.945774,-96.509136 42.945845,-96.509224 42.946012,-96.509247 42.946081,-96.50926 42.946188,-96.509242 42.94651,-96.509222 42.946616,-96.509187 42.94672,-96.50918 42.946729,-96.509081 42.946882,-96.508864 42.947121,-96.50845 42.947475,-96.508224 42.947709,-96.508047 42.947924,-96.508023 42.947971,-96.507931 42.948249,-96.507907 42.948391,-96.507907 42.948427,-96.507962 42.948962,-96.50797 42.948997,-96.508041 42.949168,-96.508082 42.949234,-96.508135 42.949294,-96.5082 42.949348,-96.508216 42.94938,-96.508234 42.949487,-96.508254 42.949556,-96.508343 42.949723,-96.508354 42.949758,-96.508431 42.950183,-96.508558 42.950566,-96.50863 42.950737,-96.509148 42.951818,-96.50921 42.951991,-96.509317 42.952413,-96.509325 42.952514,-96.509323 42.952729,-96.50929 42.952942,-96.509192 42.953256,-96.509031 42.953556,-96.508945 42.953685,-96.508919 42.953715,-96.508886 42.953742,-96.508709 42.953866,-96.508626 42.953901,-96.508449 42.953963,-96.508352 42.953976,-96.508303 42.953978,-96.507752 42.953969,-96.507466 42.953965,-96.506777 42.953987,-96.506729 42.953992,-96.506392 42.954046,-96.506061 42.954114,-96.505647 42.95423,-96.505288 42.954347,-96.504853 42.954514,-96.504731 42.954576,-96.504555 42.954701,-96.504203 42.955045,-96.50415 42.955105,-96.504011 42.955334,-96.50394 42.955467,-96.503759 42.95606,-96.503721 42.956237,-96.503684 42.956341,-96.503646 42.956407,-96.5035 42.956551,-96.503196 42.956785,-96.502744 42.957061,-96.502661 42.957099,-96.502357 42.957216,-96.502261 42.957232,-96.502068 42.957257,-96.501924 42.95728,-96.501317 42.957291,-96.50109 42.957296,-96.500975 42.957295,-96.500337 42.957334,-96.500091 42.957334,-96.499606 42.957393,-96.499559 42.957402,-96.499375 42.957454,-96.499293 42.957494,-96.49922 42.957541,-96.499186 42.957568,-96.498982 42.957769,-96.498963 42.957802,-96.498923 42.957924,-96.498894 42.958011,-96.498878 42.958153,-96.498888 42.95826,-96.498909 42.95833,-96.499012 42.958471,-96.499117 42.958615,-96.499175 42.958672,-96.499283 42.958745,-96.500287 42.959378,-96.500445 42.959492,-96.500531 42.959555,-96.500942 42.959811,-96.501324 42.96009,-96.501552 42.960323,-96.501655 42.960445,-96.501719 42.960542,-96.501839 42.960777,-96.501968 42.961269,-96.502176 42.962547,-96.502234 42.963007,-96.502266 42.963259,-96.50231 42.963974,-96.502314 42.965297,-96.502367 42.966084,-96.502512 42.966787,-96.502682 42.967605,-96.502719 42.967709,-96.502966 42.968214,-96.503005 42.968279,-96.504143 42.969707,-96.504419 42.970045,-96.504755 42.970562,-96.50516 42.971095,-96.50534 42.971265,-96.505375 42.97129,-96.505664 42.971427,-96.505846 42.971482,-96.506136 42.971523,-96.506283 42.971527,-96.506628 42.971522,-96.506726 42.971515,-96.506891 42.971491,-96.506918 42.971464,-96.506951 42.971434,-96.507126 42.971309,-96.507166 42.971287,-96.507246 42.971258,-96.507531 42.971202,-96.507776 42.971192,-96.507825 42.971197,-96.50792 42.971216,-96.507964 42.971233,-96.508044 42.971274,-96.508111 42.971319,-96.508436 42.971289,-96.508535 42.971284,-96.509027 42.971287,-96.509224 42.971292,-96.510422 42.971389,-96.510497 42.971395,-96.510643 42.971412,-96.511368 42.971514,-96.511654 42.971569,-96.512503 42.971753,-96.513242 42.971951,-96.513921 42.972163,-96.51405 42.972215,-96.514386 42.972381,-96.514863 42.972618,-96.515119 42.972706,-96.515351 42.972765,-96.515643 42.972794,-96.515689 42.972806,-96.515773 42.972844,-96.515958 42.972962,-96.515992 42.972988,-96.516174 42.973157,-96.516223 42.973219,-96.516241 42.973253,-96.516353 42.973526,-96.516474 42.974309,-96.516618 42.974834,-96.516657 42.974938,-96.516788 42.975245,-96.516925 42.975435,-96.517021 42.975516,-96.517301 42.975717,-96.517383 42.975757,-96.51785 42.975955,-96.518244 42.976102,-96.518627 42.976264,-96.518746 42.976327,-96.518861 42.976394,-96.519176 42.97662,-96.519307 42.976727,-96.519525 42.976921,-96.51958 42.97698,-96.520053 42.977607,-96.520118 42.977703,-96.520414 42.978271,-96.520564 42.978832,-96.520647 42.979257,-96.520755 42.979642,-96.52082 42.979923,-96.52084 42.980278,-96.520838 42.980314,-96.520828 42.980349,-96.520771 42.980448,-96.520741 42.980476,-96.520703 42.980499,-96.520539 42.980578,-96.5205 42.980601,-96.520431 42.980652,-96.520338 42.980651,-96.52029 42.980646,-96.520052 42.980598,-96.519829 42.980536,-96.519269 42.980383,-96.518881 42.980226,-96.518706 42.980161,-96.518326 42.980085,-96.518277 42.980082,-96.518032 42.980094,-96.517935 42.980106,-96.517795 42.98014,-96.517707 42.980172,-96.517666 42.980192,-96.517409 42.980358,-96.517283 42.980468,-96.517199 42.980556,-96.517041 42.980779,-96.516903 42.980927,-96.516831 42.98102,-96.516702 42.981328,-96.516688 42.981399,-96.516685 42.98166,-96.516683 42.981791,-96.5167 42.981898,-96.516823 42.982131,-96.517 42.982303,-96.517247 42.982477,-96.517282 42.982495,-96.517805 42.982769,-96.517922 42.982834,-96.518379 42.98321,-96.518496 42.983325,-96.518776 42.983661,-96.518798 42.983693,-96.518897 42.983895,-96.518914 42.984038,-96.518906 42.984323,-96.518847 42.984497,-96.518767 42.984665,-96.51861 42.984914,-96.518502 42.985086,-96.518472 42.985114,-96.518364 42.985187,-96.518323 42.985206,-96.518206 42.985272,-96.518113 42.985294,-96.518015 42.9853,-96.517769 42.985296,-96.517672 42.985282,-96.517518 42.985105,-96.517221 42.984866,-96.516622 42.984442,-96.516429 42.984331,-96.516299 42.98428,-96.51598 42.984185,-96.515932 42.984178,-96.515441 42.984143,-96.515342 42.984141,-96.51505 42.984174,-96.514909 42.984205,-96.514819 42.984234,-96.514192 42.984515,-96.513569 42.984865,-96.512657 42.98541,-96.51258 42.985445,-96.512574 42.985449,-96.51243 42.985596,-96.512382 42.985658,-96.512249 42.985849,-96.51198 42.986349,-96.511841 42.986765,-96.51182 42.986871,-96.511832 42.987121,-96.51185 42.987191,-96.512258 42.987958,-96.512366 42.988234,-96.512385 42.98834,-96.512392 42.988626,-96.512364 42.988839,-96.512355 42.988874,-96.512253 42.989076,-96.512159 42.989201,-96.512098 42.989257,-96.51147 42.989759,-96.511406 42.989814,-96.511324 42.989903,-96.51119 42.990133,-96.511176 42.990167,-96.511169 42.990203,-96.511163 42.99031,-96.511182 42.990416,-96.511244 42.990551,-96.511319 42.990644,-96.51135 42.990672,-96.511604 42.990841,-96.51168 42.990886,-96.51176 42.990927,-96.511969 42.991021,-96.512233 42.991117,-96.512322 42.991145,-96.512408 42.99118,-96.512521 42.991248,-96.512562 42.991268,-96.51267 42.99134,-96.512701 42.991368,-96.5128 42.991491,-96.51285 42.991592,-96.512857 42.991627,-96.512834 42.991912,-96.512732 42.992189,-96.512545 42.992409,-96.51249 42.992468,-96.511591 42.993363,-96.511325 42.993665,-96.510564 42.994585,-96.51021 42.994928,-96.50986 42.995228,-96.50951 42.995479,-96.509013 42.995826,-96.50823 42.996259,-96.507866 42.996443,-96.507824 42.996461,-96.507511 42.996565,-96.507373 42.996604,-96.506796 42.996696,-96.50592 42.996793,-96.505662 42.996797,-96.505034 42.996808,-96.504246 42.996804,-96.503856 42.996843,-96.503139 42.996973,-96.502491 42.997144,-96.502215 42.997221,-96.50208 42.997265,-96.501908 42.997333,-96.501161 42.997679,-96.501069 42.997705,-96.50036 42.997857,-96.500239 42.997867,-96.500064 42.997907,-96.500007 42.99792,-96.499863 42.997954,-96.499838 42.997957,-96.499781 42.997964,-96.499523 42.997996,-96.499474 42.997995,-96.499387 42.997989,-96.498818 42.998003,-96.498436 42.998081,-96.498427 42.998079,-96.49831 42.998051,-96.498184 42.998029,-96.498152 42.998033,-96.497866 42.998086,-96.497774 42.998112,-96.497359 42.998276,-96.497342 42.998283,-96.497061 42.998428,-96.496823 42.998609,-96.496757 42.998705,-96.496709 42.998807,-96.496639 42.998901,-96.496619 42.998934,-96.496606 42.998968,-96.496604 42.999039,-96.496638 42.999144,-96.496873 42.999537,-96.49693 42.999756,-96.496947 42.999818,-96.496966 42.999996,-96.496961 43.000068,-96.496907 43.000242,-96.496814 43.000408,-96.49679 43.000439,-96.496643 43.000583,-96.496571 43.000632,-96.495737 43.000941,-96.49561 43.000997,-96.495566 43.001012,-96.495243 43.0011,-96.495072 43.001171,-96.494876 43.001279,-96.494777 43.001359,-96.494588 43.001568,-96.494488 43.001731,-96.494443 43.00187,-96.494416 43.002084,-96.494423 43.002156,-96.494445 43.002225,-96.494534 43.002392,-96.494582 43.00253,-96.494665 43.002883,-96.494675 43.00299,-96.494655 43.003598,-96.494644 43.003633,-96.494468 43.003956,-96.494446 43.003998,-96.494422 43.00403,-96.494393 43.004058,-96.49426 43.004164,-96.494109 43.004256,-96.494074 43.004281,-96.493655 43.004679,-96.493444 43.00492,-96.493056 43.005244,-96.493 43.00532,-96.492811 43.00565,-96.492713 43.006,-96.492685 43.006393,-96.492589 43.006853,-96.492487 43.007166,-96.492206 43.007814,-96.492189 43.007885,-96.492174 43.008171,-96.4921 43.008669,-96.492049 43.008868,-96.492029 43.00895,-96.491991 43.009557,-96.491968 43.009699,-96.491961 43.009771,-96.491987 43.009876,-96.492002 43.009983,-96.491981 43.010197,-96.492116 43.010541,-96.492159 43.010605,-96.492239 43.010696,-96.492564 43.010916,-96.493072 43.011197,-96.493185 43.011266,-96.493421 43.011448,-96.493497 43.01154,-96.493711 43.011901,-96.493764 43.012002,-96.493791 43.01207,-96.493821 43.012248,-96.493874 43.012386,-96.493879 43.012421,-96.493902 43.012994,-96.493929 43.013136,-96.494113 43.013729,-96.494166 43.013829,-96.494762 43.01485,-96.495014 43.015115,-96.495281 43.015456,-96.495639 43.015841,-96.495672 43.015869,-96.495744 43.015917,-96.495935 43.01603,-96.496482 43.016272,-96.496526 43.016288,-96.497019 43.016181,-96.497308 43.016136,-96.497894 43.016082,-96.498535 43.016075,-96.498569 43.016077,-96.498583 43.016079,-96.498678 43.0161,-96.499087 43.016224,-96.499292 43.016323,-96.499358 43.016376,-96.49948 43.016488,-96.499532 43.016548,-96.499638 43.016787,-96.499646 43.016822,-96.499649 43.016893,-96.499594 43.017104,-96.499575 43.017138,-96.499551 43.017169,-96.499441 43.017287,-96.499153 43.017532,-96.49884 43.017896,-96.498775 43.017993,-96.498759 43.018027,-96.498709 43.018201,-96.498688 43.018415,-96.49869 43.018451,-96.498709 43.018557,-96.498799 43.018762,-96.498818 43.018795,-96.498861 43.018851,-96.49901 43.019045,-96.49904 43.019073,-96.499256 43.019219,-96.499452 43.019327,-96.499574 43.019388,-96.499619 43.019403,-96.500093 43.019499,-96.500289 43.019515,-96.500782 43.019528,-96.501125 43.019556,-96.501899 43.019664,-96.501995 43.019681,-96.502644 43.01985,-96.50318 43.02003,-96.503937 43.020366,-96.50399 43.0204,-96.50451 43.020781,-96.505049 43.021272,-96.505493 43.021676,-96.505637 43.021821,-96.505899 43.022034,-96.506122 43.02227,-96.506188 43.022323,-96.506713 43.022648,-96.506793 43.022689,-96.507349 43.022922,-96.508032 43.023332,-96.50811 43.023375,-96.508435 43.023536,-96.508522 43.02357,-96.509247 43.023797,-96.509594 43.023933,-96.510209 43.024229,-96.510318 43.024301,-96.510523 43.024456,-96.510553 43.024484,-96.51076 43.024728,-96.510805 43.024792,-96.511528 43.025516,-96.511698 43.025734,-96.512032 43.026212,-96.512435 43.026865,-96.512467 43.026933,-96.512579 43.027207,-96.51269 43.027444,-96.513173 43.028267,-96.513208 43.028334,-96.513534 43.029047,-96.51359 43.029185,-96.513754 43.029522,-96.513952 43.030075,-96.513958 43.030111,-96.513971 43.030324,-96.513968 43.03036,-96.513927 43.030536,-96.513846 43.030679,-96.513822 43.03071,-96.513732 43.030796,-96.513507 43.030935,-96.513467 43.030955,-96.512894 43.031165,-96.512534 43.031281,-96.511741 43.031569,-96.511694 43.031581,-96.511071 43.031685,-96.511026 43.0317,-96.510984 43.031719,-96.510948 43.031743,-96.510824 43.031855,-96.510666 43.032036,-96.510623 43.032101,-96.510581 43.032203,-96.510416 43.032763,-96.51006 43.034207,-96.509942 43.034516,-96.509731 43.034956,-96.509626 43.035194,-96.509624 43.035199,-96.509498 43.035686,-96.509378 43.036033,-96.509267 43.036455,-96.509138 43.036763,-96.509134 43.036798,-96.509169 43.037011,-96.509191 43.037547,-96.509252 43.037794,-96.509291 43.037898,-96.509308 43.037931,-96.509333 43.037962,-96.509525 43.038125,-96.509596 43.038175,-96.509918 43.03834,-96.510181 43.038438,-96.5103 43.038501,-96.510336 43.038526,-96.510495 43.038663,-96.5106 43.038784,-96.510746 43.03905,-96.510772 43.039119,-96.510831 43.039329,-96.510886 43.039466,-96.510998 43.039665,-96.511048 43.039727,-96.51108 43.039754,-96.511487 43.040013,-96.51165 43.040094,-96.511881 43.040228,-96.512146 43.04044,-96.512222 43.040486,-96.512317 43.040465,-96.512454 43.040426,-96.512502 43.040416,-96.512599 43.040407,-96.51309 43.040377,-96.513233 43.04035,-96.513785 43.040197,-96.513921 43.040155,-96.514052 43.040105,-96.514257 43.039992,-96.514643 43.039782,-96.514904 43.039681,-96.515878 43.039197,-96.516188 43.03902,-96.516307 43.038956,-96.516945 43.038684,-96.517209 43.038587,-96.517849 43.038399,-96.518203 43.038274,\
-96.518522 43.038179,-96.519511 43.037856,-96.5197 43.037816,-96.519941 43.03778,-96.520086 43.037762,-96.520153 43.037765,-96.520874 43.0378,-96.520922 43.037808,-96.521087 43.037846,-96.521335 43.038089,-96.521519 43.038781,-96.521492 43.038889,-96.521302 43.03966,-96.520887 43.040138,-96.520254 43.04024,-96.520201 43.040249,-96.519185 43.040178,-96.518393 43.040105,-96.51799 43.040182,-96.517634 43.040422,-96.517086 43.041064,-96.51655 43.041271,-96.516237 43.041359,-96.515759 43.041383,-96.51531 43.041233,-96.514935 43.041039,-96.514636 43.040943,-96.514573 43.040936,-96.514125 43.040892,-96.513745 43.040912,-96.513393 43.040967,-96.513272 43.040982,-96.51308 43.040999,-96.512735 43.041049,-96.512628 43.041065,-96.512521 43.04108,-96.512553 43.041167,-96.512595 43.041379,-96.512636 43.041481,-96.512705 43.04169,-96.512775 43.041824,-96.5129 43.041978,-96.513015 43.042094,-96.513357 43.042351,-96.513444 43.042438,-96.513663 43.042676,-96.513807 43.04279,-96.513996 43.04294,-96.514325 43.043338,-96.514523 43.043666,-96.514688 43.04404,-96.514818 43.044495,-96.514833 43.044638,-96.514819 43.045103,-96.514812 43.045174,-96.51476 43.045385,-96.514747 43.04542,-96.514588 43.04572,-96.514093 43.0465,-96.513681 43.04703,-96.513604 43.047122,-96.513521 43.047211,-96.513197 43.047526,-96.512844 43.047825,-96.512486 43.04821,-96.51244 43.048245,-96.512283 43.048366,-96.512256 43.048396,-96.512092 43.048617,-96.511572 43.049093,-96.511302 43.049392,-96.510851 43.04977,-96.510523 43.049913,-96.510393 43.049964,-96.510069 43.050049,-96.509882 43.050094,-96.509643 43.050137,-96.509547 43.050151,-96.509154 43.050181,-96.508859 43.050187,-96.50881 43.050183,-96.508347 43.05006,-96.508165 43.050006,-96.507608 43.049773,-96.507566 43.049756,-96.506355 43.049138,-96.506267 43.049105,-96.506035 43.049045,-96.505317 43.048915,-96.504459 43.048749,-96.504363 43.048735,-96.503824 43.048687,-96.503677 43.048677,-96.503332 43.048667,-96.501804 43.048658,-96.501509 43.04868,-96.500978 43.048756,-96.500882 43.048774,-96.500837 43.048788,-96.500493 43.048927,-96.500484 43.048966,-96.500458 43.049035,-96.500439 43.049068,-96.500368 43.049162,-96.50029 43.049332,-96.500115 43.049547,-96.499993 43.049659,-96.499928 43.049713,-96.499791 43.049815,-96.499557 43.049946,-96.499514 43.049965,-96.499288 43.050034,-96.499241 43.050045,-96.498804 43.0501,-96.498226 43.050147,-96.498216 43.050148,-96.496737 43.050184,-96.496048 43.050219,-96.495607 43.050256,-96.495126 43.050334,-96.494868 43.050395,-96.494564 43.050466,-96.493995 43.050584,-96.493752 43.050614,-96.493703 43.050621,-96.493556 43.050621,-96.493164 43.050583,-96.492277 43.050603,-96.492032 43.050621,-96.491595 43.05068,-96.491306 43.050726,-96.49093 43.050812,-96.490522 43.05094,-96.490389 43.05099,-96.489912 43.051172,-96.489581 43.051329,-96.489341 43.05143,-96.48924 43.051472,-96.489201 43.051494,-96.489031 43.051754,-96.488861 43.052014,-96.488825 43.052363,-96.488832 43.052434,-96.48894 43.052734,-96.488957 43.05278,-96.489009 43.05288,-96.489022 43.052914,-96.489035 43.053021,-96.48903 43.053093,-96.489006 43.053162,-96.489001 43.053197,-96.489009 43.05334,-96.488995 43.053482,-96.488967 43.05366,-96.488949 43.05373,-96.488815 43.053961,-96.488727 43.054165,-96.488641 43.054253,-96.488511 43.05436,-96.488362 43.054392,-96.488274 43.054424,-96.488234 43.054445,-96.488092 43.054544,-96.487994 43.054624,-96.487966 43.054654,-96.487877 43.054781,-96.487845 43.054849,-96.487836 43.054884,-96.487686 43.05501,-96.48753 43.055192,-96.487466 43.055247,-96.487408 43.055304,-96.487136 43.055602,-96.486967 43.055779,-96.486833 43.055882,-96.486686 43.055894,-96.486591 43.055913,-96.486546 43.055929,-96.486418 43.055984,-96.486165 43.056093,-96.485825 43.056298,-96.485604 43.056491,-96.485232 43.056725,-96.485198 43.056751,-96.485148 43.056799,-96.485109 43.056836,-96.485038 43.056931,-96.484905 43.0572,-96.484688 43.05748,-96.484659 43.057508,-96.484557 43.057586,-96.484478 43.057629,-96.484391 43.057662,-96.4843 43.057789,-96.484049 43.05801,-96.483872 43.058134,-96.483829 43.058147,-96.483682 43.058143,-96.483632 43.058146,-96.483584 43.058154,-96.483227 43.058275,-96.48321 43.058283,-96.482788 43.058505,-96.482526 43.058719,-96.482313 43.058916,-96.481804 43.059444,-96.481529 43.059697,-96.481463 43.05975,-96.481392 43.0598,-96.480787 43.060167,-96.480472 43.060339,-96.480255 43.060424,-96.479984 43.060509,-96.479795 43.060551,-96.47975 43.060565,-96.479365 43.060725,-96.478548 43.061124,-96.47808 43.061493,-96.477913 43.06167,-96.477815 43.061834,-96.477766 43.061896,-96.477611 43.062035,-96.477474 43.062225,-96.477417 43.062283,-96.477317 43.062362,-96.476966 43.062559,-96.476953 43.062567,-96.476822 43.062657,-96.47674 43.062697,-96.476429 43.062805,-96.475717 43.06301,-96.475405 43.063117,-96.475268 43.063157,-96.475173 43.063179,-96.474503 43.063298,-96.474339 43.063355,-96.473872 43.063518,-96.473846 43.06352,-96.473673 43.063534,-96.473377 43.063645,-96.473191 43.063692,-96.473048 43.063717,-96.472949 43.063721,-96.472753 43.063711,-96.472657 43.063694,-96.47261 43.063681,-96.472435 43.063615,-96.472316 43.063552,-96.472186 43.063463,-96.471455 43.062963,-96.471322 43.062857,-96.470832 43.062504,-96.470641 43.062391,-96.470465 43.062327,-96.4701 43.062219,-96.469298 43.06204,-96.469011 43.06199,-96.468768 43.061959,-96.468326 43.061933,-96.467934 43.061966,-96.46786 43.061962,-96.467491 43.061946,-96.467442 43.061947,-96.467345 43.06196,-96.466704 43.062145,-96.466515 43.062186,-96.466325 43.062231,-96.465859 43.062343,-96.465518 43.062377,-96.465421 43.06239,-96.46501 43.062511,-96.46483 43.06257,-96.464777 43.062556,-96.46468 43.062541,-96.464581 43.062541,-96.464533 43.062548,-96.464167 43.062652,-96.464124 43.062669,-96.463973 43.062761,-96.463939 43.062787,-96.463881 43.062845,-96.463836 43.062909,-96.463184 43.063141,-96.463099 43.063177,-96.462895 43.063277,-96.462592 43.06346,-96.462472 43.063523,-96.461401 43.063963,-96.460958 43.064214,-96.460742 43.064337,-96.460723 43.064392,-96.460689 43.064459,-96.460509 43.064713,-96.46037 43.065018,-96.460353 43.065124,-96.460341 43.065159,-96.460303 43.065225,-96.460394 43.065419,-96.460546 43.065602,-96.460667 43.065836,-96.460675 43.065871,-96.460674 43.065907,-96.460644 43.066084,-96.460572 43.066292,-96.46055 43.066324,-96.460522 43.066354,-96.460323 43.066459,-96.459851 43.066653,-96.459645 43.066751,-96.459559 43.066787,-96.459248 43.066962,-96.459167 43.067003,-96.458882 43.067061,-96.458618 43.067157,-96.458577 43.067177,-96.458405 43.067305,-96.458305 43.067428,-96.458233 43.067561,-96.458185 43.067773,-96.458185 43.067809,-96.458202 43.067951,-96.458234 43.068056,-96.458253 43.068089,-96.458324 43.068183,-96.458406 43.068272,-96.459016 43.068786,-96.459282 43.069044,-96.459307 43.069075,-96.459392 43.069242,-96.459447 43.069489,-96.459445 43.069561,-96.459403 43.069809,-96.459387 43.069843,-96.459337 43.069904,-96.459298 43.069926,-96.458921 43.070096,-96.458842 43.070139,-96.458699 43.070238,-96.458573 43.070264,-96.458483 43.070293,-96.458095 43.07045,-96.457627 43.070766,-96.457566 43.070822,-96.457448 43.070979,-96.457429 43.071012,-96.457375 43.071186,-96.457367 43.071257,-96.457349 43.071757,-96.457358 43.071828,-96.457356 43.072043,-96.457294 43.072252,-96.457213 43.072421,-96.457107 43.072583,-96.457079 43.072612,-96.456942 43.072715,-96.456859 43.072754,-96.456771 43.072838,-96.456669 43.072916,-96.456639 43.072945,-96.456429 43.073187,-96.456398 43.073215,-96.455903 43.073614,-96.455722 43.073908,-96.455677 43.07401,-96.455555 43.074319,-96.45547 43.074743,-96.455455 43.074922,-96.455444 43.074955,-96.45541 43.074982,-96.45536 43.075043,-96.455343 43.075077,-96.455332 43.075112,-96.455328 43.075148,-96.455324 43.075469,-96.455437 43.075963,-96.455454 43.076321,-96.455543 43.076636,-96.455648 43.077203,-96.455671 43.077367,-96.455718 43.077702,-96.455725 43.078167,-96.455719 43.078524,-96.455761 43.079526,-96.455843 43.080059,-96.455798 43.080845,-96.455786 43.080916,-96.455726 43.081127,-96.455654 43.081298,-96.455519 43.081528,-96.455494 43.081558,-96.455408 43.081593,-96.455329 43.081636,-96.455294 43.081662,-96.455206 43.081748,-96.454969 43.081929,-96.454478 43.082421,-96.454407 43.082471,-96.454376 43.082498,-96.454336 43.082555,-96.454259 43.082709,-96.454224 43.08278,-96.454228 43.082851,-96.454223 43.082887,-96.454204 43.082957,-96.454187 43.083063,-96.454155 43.083209,-96.454142 43.083274,-96.45413 43.08338,-96.454118 43.08348,-96.454083 43.083782,-96.45408 43.08381,-96.45408 43.083845,-96.454084 43.083883,-96.454105 43.084059,-96.454126 43.084165,-96.454229 43.084515,-96.454253 43.08462,-96.454266 43.084763,-96.45431 43.085549,-96.454359 43.085976,-96.454401 43.086152,-96.454603 43.086777,-96.454705 43.08709,-96.454779 43.087261,-96.455139 43.087886,-96.455155 43.08792,-96.455432 43.088258,-96.455467 43.088283,-96.455634 43.088359,-96.455948 43.088463,-96.456187 43.088507,-96.456529 43.088539,-96.456575 43.088551,-96.456972 43.088696,-96.457156 43.088746,-96.457381 43.088819,-96.457893 43.088933,-96.458622 43.089016,-96.45872 43.089021,-96.459065 43.089028,-96.459552 43.089082,-96.460753 43.089281,-96.461588 43.089493,-96.461682 43.089512,-96.462274 43.089526,-96.462428 43.089565,-96.462506 43.089586,-96.462672 43.089662,-96.463028 43.089908,-96.463083 43.089967,-96.463168 43.090096,-96.463184 43.090152,-96.463189 43.090331,-96.46316 43.090544,-96.463134 43.09065,-96.463121 43.090684,-96.462777 43.091275,-96.462644 43.091465,-96.462539 43.091703,-96.462535 43.091739,-96.462569 43.091952,-96.462521 43.092116,-96.462484 43.092183,-96.462434 43.092393,-96.462422 43.092464,-96.462407 43.092643,-96.46232 43.092885,-96.462268 43.092985,-96.462243 43.093016,-96.462035 43.093215,-96.461941 43.093297,-96.461752 43.093411,-96.461466 43.093551,-96.461326 43.093652,-96.461264 43.093707,-96.461218 43.09377,-96.461189 43.093838,-96.461095 43.094226,-96.461072 43.094295,-96.461042 43.094363,-96.460935 43.094563,-96.460797 43.094792,-96.460729 43.094887,-96.460498 43.095118,-96.460242 43.095284,-96.460158 43.095321,-96.45987 43.095413,-96.459706 43.095466,-96.459659 43.095477,-96.459562 43.095486,-96.459219 43.095505,-96.458977 43.09554,-96.458782 43.095552,-96.458586 43.095539,-96.458537 43.095541,-96.458244 43.095573,-96.458195 43.095575,-96.458146 43.095572,-96.457907 43.095529,-96.45781 43.095518,-96.457762 43.095523,-96.457483 43.095592,-96.457391 43.095618,-96.45726 43.095667,-96.457053 43.095763,-96.456911 43.095861,-96.456846 43.095915,-96.456798 43.095978,-96.456777 43.096048,-96.456802 43.096369,-96.456819 43.096439,-96.456851 43.096507,-96.457071 43.096827,-96.457115 43.096929,-96.457149 43.096995,-96.457173 43.097064,-96.457166 43.097314,-96.457168 43.097386,-96.457132 43.097489,-96.45705 43.097619,-96.457023 43.097647,-96.456741 43.097789,-96.456697 43.097805,-96.456508 43.097843,-96.456264 43.097864,-96.456215 43.097859,-96.455976 43.097813,-96.455714 43.097714,-96.455381 43.09756,-96.455249 43.097513,-96.455101 43.097501,-96.454855 43.097502,-96.454806 43.097499,-96.454661 43.097476,-96.454492 43.097404,-96.454448 43.097388,-96.454401 43.097377,-96.45416 43.097339,-96.454063 43.097331,-96.453868 43.097355,-96.453591 43.097431,-96.453372 43.097512,-96.453212 43.097596,-96.452696 43.097926,-96.452564 43.098077,-96.452446 43.098139,-96.45241 43.098164,-96.45238 43.098193,-96.45236 43.098225,-96.452314 43.098364,-96.452314 43.0984,-96.452303 43.098471,-96.452311 43.098542,-96.452357 43.098569,-96.452706 43.0987,-96.452946 43.098825,-96.452974 43.098855,-96.453017 43.098919,-96.453115 43.099195,-96.453117 43.099266,-96.45309 43.099515,-96.453021 43.099796,-96.452901 43.100143,-96.452673 43.100575,-96.452567 43.100696,-96.452462 43.100771,-96.45242 43.10079,-96.452371 43.100789,-96.452177 43.100763,-96.45213 43.100753,-96.452086 43.100736,-96.45201 43.100691,-96.451941 43.10064,-96.451832 43.100568,-96.451801 43.100554,-96.451706 43.100512,-96.451617 43.100483,-96.451523 43.100464,-96.451328 43.100484,-96.45123 43.10049,-96.451134 43.100502,-96.450863 43.100586,-96.450576 43.100723,-96.450403 43.10085,-96.450346 43.100908,-96.450254 43.101074,-96.450143 43.101385,-96.450115 43.10149,-96.450079 43.101775,-96.450072 43.101882,-96.450093 43.10206,-96.450104 43.102095,-96.450158 43.102195,-96.450483 43.102595,-96.450576 43.10276,-96.450623 43.102972,-96.450672 43.103399,-96.450601 43.103679,-96.45055 43.103754,-96.450536 43.103775,-96.450408 43.103883,-96.450396 43.103889,-96.45037 43.103906,-96.450161 43.104001,-96.449928 43.104058,-96.449813 43.104074,-96.44961 43.104105,-96.449445 43.10413,-96.449113 43.104196,-96.448803 43.104306,-96.448506 43.104433,-96.448296 43.104584,-96.447994 43.104866,-96.447809 43.105077,-96.447694 43.105145,-96.447652 43.105164,-96.447294 43.105283,-96.447214 43.105324,-96.447046 43.105455,-96.446992 43.105514,-96.44697 43.105546,-96.446944 43.105615,-96.446924 43.105685,-96.446911 43.105828,-96.446928 43.105861,-96.446997 43.105956,-96.447011 43.105991,-96.44707 43.106047,-96.447217 43.106142,-96.447248 43.10617,-96.447355 43.10629,-96.447404 43.106352,-96.447452 43.106454,-96.447358 43.106584,-96.447327 43.106652,-96.447306 43.10683,-96.447231 43.107291,-96.447178 43.107502,-96.447104 43.107709,-96.447085 43.107742,-96.446848 43.108014,-96.446788 43.108112,-96.446774 43.108146,-96.44654 43.108987,-96.446518 43.109093,-96.446495 43.10927,-96.446457 43.109374,-96.446374 43.109542,-96.446367 43.109551,-96.446268 43.109703,-96.446195 43.109796,-96.44604 43.109979,-96.445943 43.110059,-96.445764 43.110182,-96.445725 43.110204,-96.445596 43.110257,-96.44546 43.110299,-96.445413 43.11031,-96.444489 43.110457,-96.44445 43.110464,-96.444125 43.110547,-96.444035 43.110575,-96.443882 43.110666,-96.443784 43.110745,-96.443514 43.111043,-96.443368 43.11123,-96.443037 43.111495,-96.442962 43.111541,-96.442844 43.111605,-96.442453 43.111759,-96.442165 43.111897,-96.441006 43.112505,-96.440932 43.112552,-96.440863 43.112603,-96.439832 43.113423,-96.439668 43.113601,-96.439644 43.113632,-96.438959 43.1147,-96.438916 43.114803,-96.438905 43.114905,-96.43894 43.116047,-96.438936 43.116083,-96.438795 43.116573,-96.438683 43.116772,-96.438492 43.117215,-96.438395 43.117339,-96.438292 43.11746,-96.438245 43.117523,-96.438143 43.117645,-96.437956 43.117896,-96.43727 43.118762,-96.436988 43.119137,-96.43684 43.119361,-96.436567 43.119818,-96.436515 43.119956,-96.436472 43.120166,-96.436473 43.120202,-96.436486 43.120272,-96.436499 43.120414,-96.436555 43.120661,-96.436634 43.120867,-96.436814 43.121161,-96.436951 43.121264,-96.436989 43.121287,-96.437031 43.121305,-96.43767 43.121493,-96.438083 43.12161,-96.438407 43.121697,-96.438689 43.12176,-96.439059 43.121857,-96.439239 43.121916,-96.43932 43.121956,-96.439864 43.122194,-96.440158 43.122434,-96.440268 43.122553,-96.440311 43.122617,-96.440454 43.122996,-96.440598 43.123262,-96.440659 43.123359,-96.441005 43.123834,-96.441429 43.124271,-96.441529 43.12442,-96.441581 43.124496,-96.44165 43.124702,-96.441685 43.124879,-96.441699 43.124986,-96.441658 43.125305,-96.441646 43.12534,-96.441451 43.125668,-96.441405 43.12577,-96.44136 43.125834,-96.441353 43.125866,-96.44136 43.125938,-96.44134 43.126044,-96.441326 43.126078,-96.441059 43.126459,-96.440956 43.126581,-96.440926 43.126609,-96.440743 43.126728,-96.440586 43.126814,-96.440419 43.126945,-96.440233 43.127155,-96.440163 43.127288,-96.440122 43.127391,-96.44013 43.127426,-96.440124 43.12782,-96.440136 43.12807,-96.440191 43.128317,-96.440352 43.128615,-96.44043 43.128706,-96.440581 43.128848,-96.440622 43.128868,-96.440798 43.128933,-96.440845 43.128941,-96.440894 43.128932,-96.440939 43.128918,-96.441215 43.128768,-96.441247 43.128741,-96.441299 43.12868,-96.441329 43.128652,-96.441366 43.128628,-96.441407 43.128608,-96.441709 43.128487,-96.441754 43.128473,-96.441946 43.12844,-96.441995 43.128436,-96.442241 43.128435,-96.442291 43.128439,-96.442484 43.12847,-96.44253 43.128482,-96.442615 43.128519,-96.44269 43.128565,-96.44276 43.128615,-96.44278 43.128648,-96.442906 43.128957,-96.442978 43.129201,-96.442994 43.129271,-96.443022 43.129449,-96.443034 43.129622,-96.443051 43.129841,-96.443046 43.129948,-96.443057 43.130447,-96.443242 43.131364,-96.443236 43.131471,-96.443229 43.131507,-96.443186 43.131968,-96.443096 43.1325,-96.443088 43.132751,-96.443084 43.132928,-96.443098 43.133106,-96.443152 43.133425,-96.443159 43.133496,-96.443128 43.133601,-96.443134 43.133636,-96.443154 43.133669,-96.443185 43.133697,-96.443236 43.133756,-96.443289 43.133817,-96.443324 43.133842,-96.443448 43.1339,-96.443608 43.134115,-96.443646 43.134181,-96.443725 43.13435,-96.443747 43.134382,-96.444009 43.134685,-96.444077 43.134742,-96.444524 43.13512,-96.444858 43.135429,-96.445018 43.13565,-96.44522 43.136015,-96.445409 43.136305,-96.445458 43.136367,-96.445599 43.136513,-96.445678 43.136556,-96.445787 43.136629,-96.445828 43.136649,-96.445875 43.136658,-96.445923 43.136653,-96.446111 43.13661,-96.446198 43.136576,-96.446239 43.136556,-96.446638 43.136191,-96.446785 43.136095,-96.446939 43.136006,-96.446952 43.135999,-96.446981 43.135987,-96.447114 43.13594,-96.447256 43.135908,-96.447304 43.135902,-96.44755 43.135886,-96.447648 43.13589,-96.44798 43.135959,-96.44807 43.135989,-96.448243 43.136022,-96.448356 43.136044,-96.448394 43.136066,-96.448501 43.136141,-96.448562 43.136197,-96.448587 43.136228,-96.448624 43.136294,-96.448706 43.136462,-96.448704 43.136496,-96.44867 43.136601,-96.44849 43.136896,-96.448462 43.136925,-96.448389 43.136973,-96.448011 43.13714,-96.447873 43.137178,-96.447701 43.137246,-96.447386 43.137377,-96.447362 43.137388,-96.447287 43.137434,-96.447157 43.137542,-96.447131 43.137573,-96.447091 43.137637,-96.447056 43.137704,-96.447008 43.137879,-96.447009 43.138093,-96.44708 43.138338,-96.447095 43.138371,-96.447398 43.13874,-96.447533 43.13889,-96.447667 43.138995,-96.448511 43.139543,-96.448577 43.139596,-96.448606 43.139625,-96.448823 43.139864,-96.448991 43.140083,-96.449252 43.140508,-96.44976 43.141242,-96.450057 43.141811,-96.450237 43.142143,-96.450352 43.1423,-96.450381 43.142329,-96.45043 43.14239,-96.450598 43.142521,-96.450956 43.14264,-96.451003 43.142652,-96.451021 43.142655,-96.451099 43.142669,-96.451246 43.14268,-96.451295 43.142677,-96.451917 43.142562,-96.452553 43.142502,-96.453145 43.142491,-96.453381 43.142508,-96.453783 43.142538,-96.453879 43.142553,-96.453964 43.142588,-96.454046 43.142628,-96.45408 43.142654,-96.454138 43.142711,-96.454212 43.142803,-96.454272 43.1429,-96.454535 43.143511,-96.454568 43.143577,-96.45465 43.143707,-96.454753 43.143828,-96.454951 43.143988,-96.455147 43.144096,-96.455231 43.144133,-96.455512 43.144199,-96.455754 43.144235,-96.455852 43.144239,-96.45595 43.144231,-96.456147 43.144224,-96.456245 43.144217,-96.45639 43.144196,-96.456898 43.144062,-96.457533 43.143865,-96.457963 43.143692,-96.458009 43.143668,-96.458328 43.14351,-96.458678 43.143379,-96.458776 43.143369,-96.459318 43.14337,-96.459466 43.143375,-96.459756 43.143419,-96.460039 43.143481,-96.460176 43.143522,-96.460349 43.14359,-96.46043 43.14363,-96.460468 43.143653,-96.460677 43.143804,-96.460708 43.143832,-96.460856 43.144018,-96.460868 43.144075,-96.460858 43.14411,-96.460824 43.144177,-96.460564 43.144522,-96.460544 43.144555,-96.460414 43.144863,-96.460392 43.144933,-96.460382 43.14504,-96.460414 43.145397,-96.460425 43.145431,-96.460451 43.145572,-96.460471 43.145605,-96.4605 43.145634,-96.460575 43.14568,-96.460596 43.14575,-96.460601 43.145821,-96.4606 43.146035,-96.460573 43.146103,-96.460551 43.146135,-96.460405 43.146279,-96.46037 43.146305,-96.46033 43.146326,-96.460192 43.146364,-96.459557 43.14643,-96.459325 43.146491,-96.459208 43.146557,-96.45918 43.146586,-96.459046 43.146778,-96.45902 43.146846,-96.459003 43.146953,-96.459012 43.147024,-96.459036 43.14713,-96.459093 43.147266,-96.459141 43.147328,-96.459248 43.147488,-96.459432 43.147656,-96.459468 43.14768,-96.459511 43.147698,-96.459649 43.147737,-96.459795 43.147753,-96.46019 43.147766,-96.460479 43.147812,-96.460526 43.147823,-96.460658 43.147871,-96.460787 43.147923,-96.460858 43.147973,-96.460887 43.148002,-96.460935 43.148064,-96.460992 43.148163,-96.461069 43.148444,-96.461093 43.148513,-96.461126 43.148579,-96.46118 43.148715,-96.461221 43.14878,-96.461268 43.148842,-96.461286 43.148874,-96.461312 43.148905,-96.461435 43.149015,-96.461514 43.149058,-96.461781 43.149151,-96.461878 43.14916,-96.462075 43.149171,-96.462172 43.14918,-96.462271 43.149177,-96.462547 43.1491,-96.462675 43.149047,-96.462715 43.149025,-96.462785 43.148975,-96.462876 43.148891,-96.46305 43.148634,-96.463052 43.148599,-96.463046 43.148527,-96.463027 43.148473,-96.462939 43.148346,-96.462753 43.148179,-96.46274 43.148144,-96.462737 43.148109,-96.462761 43.147967,-96.462793 43.1479,-96.462814 43.147867,-96.463 43.147701,-96.463074 43.147653,-96.463281 43.147557,-96.463813 43.147368,-96.463859 43.147356,-96.463908 43.14735,-96.464252 43.147329,-96.464645 43.147333,-96.464741 43.147347,-96.465102 43.147458,-96.465144 43.147475,-96.465182 43.147499,-96.465296 43.147614,-96.465357 43.147712,-96.465369 43.147746,-96.465388 43.147853,-96.465387 43.14788,-96.465385 43.148067,-96.465294 43.148599,-96.465298 43.14867,-96.465316 43.148813,-96.465336 43.148919,-96.465459 43.149153,-96.46554 43.149242,-96.466422 43.150013,-96.466482 43.15007,-96.467187 43.150801,-96.467452 43.151014,-96.467867 43.151251,-96.46829 43.151552,-96.468459 43.151823,-96.468482 43.151854,-96.468499 43.151887,-96.468533 43.151984,-96.468559 43.152061,-96.468569 43.152167,-96.468557 43.152237,-96.468545 43.152272,-96.468411 43.152422,-96.46825 43.152505,-96.468203 43.152515,-96.468154 43.15252,-96.467809 43.152517,-96.46776 43.152513,-96.467616 43.152487,-96.46697 43.152311,-96.466876 43.15229,-96.466684 43.152255,-96.46634 43.152239,-96.465946 43.152249,-96.465896 43.152253,-96.465628 43.152342,-96.4655 43.152396,-96.465085 43.152649,-96.464981 43.152726,-96.464963 43.152742,-96.464592 43.153094,-96.464443 43.153279,-96.464422 43.153311,-96.464406 43.153418,-96.464428 43.153882,-96.464421 43.153953,-96.464412 43.153988,-96.464404 43.154059,-96.464285 43.154588,-96.464072 43.155137,-96.463981 43.155489,-96.463957 43.156058,-96.46395 43.156129,-96.463954 43.156165,-96.463968 43.156199,-96.464009 43.156264,-96.464056 43.156326,-96.46412 43.156381,-96.464161 43.156401,-96.464251 43.156429,-96.464544 43.156424,-96.464636 43.15645,-96.464685 43.156456,-96.464734 43.156457,-96.465006 43.156422,-96.465074 43.156413,-96.465639 43.15629,-96.465685 43.156277,-96.465728 43.156259,-96.465793 43.156223,-96.466089 43.156231,-96.466333 43.156205,-96.466383 43.156204,-96.466579 43.156213,-96.466723 43.156236,-96.467044 43.156328,-96.467085 43.156348,-96.467261 43.156473,-96.467326 43.156526,-96.467346 43.156559,-96.467737 43.15737,-96.467758 43.157402,-96.467812 43.157462,-96.46794 43.157571,-96.467994 43.15763,-96.468054 43.157687,-96.468088 43.157713,-96.468127 43.157736,-96.468259 43.157784,-96.468454 43.157893,-96.468498 43.15791,-96.468544 43.157922,-96.468642 43.157934,-96.468685 43.157918,-96.468724 43.157898,-96.468773 43.157901,-96.468872 43.157895,-96.468921 43.157898,-96.468969 43.157906,-96.469108 43.157942,-96.469187 43.157984,-96.469435 43.158159,-96.469545 43.158318,-96.469556 43.158353,-96.46954 43.158384,-96.46951 43.158413,-96.469468 43.158478,-96.469233 43.158661,-96.469151 43.1587,-96.468612 43.158875,-96.468525 43.158909,-96.468446 43.158952,-96.467985 43.159274,-96.467919 43.159305,-96.467452 43.159532,-96.467019 43.159769,-96.466744 43.159975,-96.466465 43.16027,-96.466441 43.160301,-96.466235 43.160626,-96.465955 43.161422,-96.465942 43.161492,-96.465944 43.161635,-96.465989 43.161811,-96.466004 43.161845,-96.466025 43.161877,-96.466365 43.162312,-96.466413 43.162366,-96.466633 43.162613,-96.466993 43.163081,-96.467012 43.163114,-96.467034 43.163184,-96.467054 43.163214,-96.467139 43.163251,-96.467213 43.163298,-96.467242 43.163327,-96.467264 43.163359,-96.467468 43.163603,-96.467514 43.163666,-96.467532 43.163699,-96.467544 43.163734,-96.467557 43.163841,-96.467557 43.163948,-96.46755 43.163983,-96.467478 43.164191,-96.467466 43.164369,-96.467333 43.164515,-96.467304 43.164548,-96.467172 43.164654,-96.467142 43.164683,-96.467053 43.164795,-96.467045 43.164902,-96.467067 43.165008,-96.467163 43.165285,-96.467168 43.165569,-96.467157 43.165819,-96.467158 43.16589,-96.467152 43.165961,-96.467108 43.166063,-96.467085 43.166095,-96.467027 43.166152,-96.466896 43.1674,-96.466881 43.167649,-96.466903 43.168112,-96.466987 43.168354,-96.467011 43.168386,-96.46704 43.168414,-96.467138 43.168494,-96.467226 43.168527,-96.467369 43.168554,-96.467616 43.168564,-96.468157 43.168532,-96.468352 43.168551,-96.468446 43.168574,-96.468663 43.168658,-96.468743 43.1687,-96.468798 43.168759,-96.468931 43.16891,-96.468996 43.169006,-96.469121 43.169314,-96.46913 43.169421,-96.469097 43.16967,-96.469062 43.169774,-96.468841 43.170133,-96.468827 43.170167,-96.46881 43.170274,-96.468781 43.170342,-96.468757 43.170373,-96.468615 43.170468,-96.468577 43.170495,-96.468536 43.170514,-96.468313 43.170591,-96.468173 43.170626,-96.46769 43.170695,-96.467347 43.170726,-96.467002 43.17074,-96.466904 43.170729,-96.466811 43.170704,-96.466689 43.17073,-96.466672 43.170734,-96.466573 43.170742,-96.466329 43.170716,-96.466231 43.170709,-96.466132 43.17071,-96.466083 43.170715,-96.466036 43.170725,-96.466018 43.170734,-96.465997 43.170745,-96.465903 43.170828,-96.465866 43.170852,-96.465738 43.170907,-96.465723 43.17094,-96.465693 43.171081,-96.46568 43.171116,-96.46557 43.171315,-96.465536 43.171454,-96.465351 43.172231,-96.465332 43.172444,-96.465337 43.172837,-96.465343 43.172873,-96.4654 43.17301,-96.465423 43.173041,-96.465479 43.1731,-96.46562 43.1732,-96.466154 43.173458,-96.466422 43.173556,-96.46655 43.173604,-96.466589 43.173626,-96.466691 43.173704,-96.46676 43.173799,-96.466779 43.173832,-96.466857 43.174112,-96.466871 43.174219,-96.466867 43.174276,-96.466859 43.174311,-96.46683 43.17438,-96.466695 43.17457,-96.466567 43.174723,-96.466509 43.174781,-96.466108 43.175145,-96.465933 43.175361,-96.465888 43.175424,-96.465666 43.175782,-96.465541 43.176053,-96.465518 43.176195,-96.46552 43.176445,-96.465526 43.176481,-96.465538 43.176515,-96.46562 43.176645,-96.465672 43.176706,-96.465703 43.176732,-96.46618 43.177143,-96.466287 43.177263,-96.466309 43.177295,-96.466375 43.177429,-96.466386 43.177464,-96.466393 43.177571,-96.46639 43.177678,-96.466375 43.177748,-96.466242 43.178055,-96.466062 43.178348,-96.466034 43.178378,-96.465965 43.178429,-96.465846 43.178491,-96.465413 43.179366,-96.465403 43.179401,-96.465353 43.17972,-96.465344 43.179755,-96.465312 43.179823,-96.465263 43.179885,-96.465135 43.179994,-96.465097 43.180018,-96.465073 43.180046,-96.464883 43.180711,-96.464825 43.181532,-96.464856 43.18196,-96.464893 43.182137,-96.465026 43.182481,-96.465247 43.182916,-96.465285 43.182982,-96.46531 43.183013,-96.465343 43.18304,-96.465427 43.183077,-96.465471 43.183092,-96.465943 43.183194,-96.465987 43.183211,-96.466187 43.183314,-96.466367 43.183436,-96.466487 43.18355,-96.46657 43.18368,-96.466714 43.184014,-96.466895 43.184431,-96.466913 43.184464,-96.466937 43.184495,-96.467196 43.184709,-96.467266 43.18476,-96.467307 43.18478,-96.467352 43.184794,-96.4676 43.184841,-96.467649 43.184834,-96.467696 43.184822,-96.467921 43.18475,-96.468565 43.184484,-96.468657 43.184458,-96.468765 43.184443,-96.468816 43.184504,-96.46888 43.184558,-96.468919 43.184581,-96.469005 43.184616,-96.469125 43.184704,-96.469212 43.184768,-96.469284 43.184816,-96.469386 43.184893,-96.469582 43.185138,-96.469609 43.185207,-96.469629 43.18524,-96.469656 43.185269,-96.469689 43.185296,-96.469744 43.18533,-96.46972 43.185476,-96.46973 43.185583,-96.469769 43.185723,-96.469835 43.185857,-96.469886 43.185918,-96.470159 43.186124,-96.470237 43.186167,-96.470373 43.18621,-96.470617 43.186197,-96.470757 43.186161,-96.470845 43.186129,-96.470882 43.186105,-96.47101 43.185996,-96.471091 43.185956,-96.471149 43.185898,-96.471398 43.18555,-96.471467 43.185498,-96.471546 43.185457,-96.471582 43.185432,-96.471668 43.185397,-96.471716 43.185392,-96.471864 43.185389,-96.471912 43.185395,-96.472011 43.185396,-96.472106 43.185414,-96.472148 43.185432,-96.472487 43.185578,-96.472525 43.185601,-96.4726 43.185693,-96.472861 43.186037,-96.472879 43.18607,-96.472923 43.186246,-96.472924 43.186389,-96.472779 43.186615,-96.472752 43.186645,-96.472604 43.186738,-96.472536 43.18679,-96.472494 43.186854,-96.472385 43.187053,-96.472372 43.187087,-96.472363 43.187158,-96.472372 43.187229,-96.472397 43.187585,-96.47273 43.188102,-96.472758 43.188132,-96.473588 43.188883,-96.47372 43.189034,-96.473789 43.189129,-96.473929 43.189396,-96.474009 43.189639,-96.474109 43.19017,-96.474085 43.190275,-96.47407 43.190309,-96.473588 43.191093,-96.473575 43.191128,-96.473569 43.191163,-96.473565 43.191413,-96.473578 43.191519,-96.473709 43.191863,-96.473766 43.192182,-96.473731 43.192611,-96.473724 43.192646,-96.473606 43.192956,-96.473331 43.193376,-96.473276 43.193475,-96.472899 43.19425,-96.47288 43.19432,-96.472859 43.194534,-96.472906 43.194693,-96.47291 43.194729,-96.472906 43.194943,-96.472911 43.194979,-96.472954 43.195118,-96.47296 43.19519,-96.472939 43.195222,-96.472826 43.195339,-96.472779 43.195402,-96.472742 43.195424,-96.472657 43.195461,-96.472619 43.195484,-96.472454 43.195617,-96.472217 43.195889,-96.472148 43.196023,-96.472136 43.196073,-96.472108 43.196199,-96.472103 43.19627,-96.472106 43.196342,-96.472151 43.196553,-96.472179 43.196622,-96.472396 43.197021,-96.472673 43.197401,-96.4729 43.197678,-96.473015 43.197794,-96.473512 43.198141,-96.473581 43.198193,-96.473731 43.198335,-96.47381 43.198426,-96.473918 43.198586,-96.473977 43.198685,-96.474092 43.198958,-96.474124 43.199063,-96.474189 43.19951,-96.474232 43.199809,-96.474239 43.199963,-96.474264 43.200487,-96.474248 43.200736,-96.474277 43.200913,-96.474328 43.201013,-96.474351 43.201045,-96.47438 43.201074,-96.474564 43.201199,-96.474596 43.201221,-96.47462 43.201251,-96.474785 43.20155,-96.474799 43.201585,-96.474919 43.201932,-96.475007 43.202319,-96.475016 43.202498,-96.475007 43.202569,-96.474976 43.202674,-96.474958 43.202707,-96.474934 43.202738,-96.474896 43.202774,-96.474792 43.202764,-96.474645 43.202778,-96.474596 43.202779,-96.474353 43.202799,-96.474261 43.202825,-96.474218 43.202842,-96.474155 43.202879,-96.474103 43.202909,-96.47402 43.202948,-96.473987 43.202974,-96.473959 43.203004,-96.473913 43.203067,-96.473897 43.203101,-96.473881 43.203172,-96.473881 43.203208,-96.473825 43.203263,-96.473576 43.203572,-96.473547 43.203601,-96.473301 43.203786,-96.472933 43.204065,-96.472896 43.204089,-96.472856 43.204109,-96.471426 43.20468,-96.471304 43.204741,-96.470964 43.204948,-96.470772 43.205112,-96.47075 43.205143,-96.470744 43.205179,-96.470791 43.205463,-96.470803 43.205497,-96.470826 43.205529,-96.470893 43.205581,-96.47097 43.205625,-96.471002 43.205653,-96.471109 43.205773,-96.471147 43.205838,-96.471161 43.205873,-96.471201 43.205938,-96.471233 43.206042,-96.471245 43.206113,-96.471234 43.206255,-96.471222 43.20629,-96.471188 43.206357,-96.471093 43.206482,-96.471073 43.206515,-96.470998 43.206607,-96.470774 43.206842,-96.470681 43.207007,-96.470692 43.207038,-96.470742 43.2071,-96.470757 43.207134,-96.470758 43.207204,-96.470746 43.207239,-96.470721 43.20727,-96.47066 43.207326,-96.470665 43.207359,-96.470779 43.207517,-96.470811 43.207543,-96.471387 43.20775,-96.471634 43.207867,-96.471673 43.207889,-96.471777 43.207965,-96.471859 43.208062,-96.47188 43.208094,-96.47198 43.208333,-96.472 43.208476,-96.472003 43.208868,-96.472065 43.20915,-96.472096 43.209218,-96.472117 43.20925,-96.472315 43.209454,-96.473063 43.210024,-96.473127 43.210078,-96.473182 43.210138,-96.473341 43.210373,-96.473378 43.210426,-96.473487 43.210545,-96.473518 43.210573,-96.473759 43.210752,-96.474493 43.211282,-96.475085 43.211763,-96.475701 43.212275,-96.475906 43.212435,-96.47624 43.212695,-96.47627 43.212723,-96.476404 43.212873,-96.476469 43.212969,-96.476504 43.213073,-96.476548 43.213357,-96.476546 43.213429,-96.476525 43.213535,-96.476408 43.213808,-96.476372 43.213875,-96.476291 43.214005,-96.476088 43.21429,-96.476062 43.214321,-96.47603 43.214348,-96.475851 43.214471,-96.4758 43.214532,-96.475756 43.214596,-96.475655 43.214835,-96.475549 43.215256,-96.475536 43.215327,-96.475493 43.215681,-96.475467 43.215786,-96.475462 43.215793,-96.475315 43.216011,-96.47517 43.216156,-96.47516 43.216191,-96.475104 43.21651,-96.475085 43.216688,-96.475066 43.216758,-96.475018 43.216897,-96.47496 43.217396,-96.474962 43.217431,-96.47525 43.218775,-96.475201 43.218827,-96.475158 43.218891,-96.475146 43.218926,-96.475122 43.219103,-96.475145 43.219354,-96.475157 43.219493,-96.475178 43.219811,-96.475241 43.220123,-96.475292 43.220259,-96.475388 43.220458,-96.475426 43.22052,-96.475644 43.220606,-96.475735 43.220635,-96.475776 43.2207,-96.476217 43.221301,-96.476509 43.221754,-96.476654 43.221941,-96.476729 43.221987,-96.476991 43.222087,-96.47725 43.222192,-96.477296 43.222203,-96.477394 43.222212,-96.477493 43.222204,-96.477584 43.222178,-96.477897 43.222072,-96.478041 43.222047,-96.478337 43.222043,-96.478436 43.222047,-96.478583 43.22206,-96.478965 43.222134,-96.479236 43.222221,-96.479366 43.222273,-96.479491 43.222331,-96.47963 43.222432,-96.480019 43.222801,-96.480339 43.223024,-96.480456 43.22309,-96.480499 43.223108,-96.48112 43.223316,-96.481305 43.223379,-96.481584 43.223451,-96.481632 43.223457,-96.482274 43.223451,-96.482815 43.223409,-96.482963 43.223409,-96.483552 43.22345,-96.483699 43.223464,-96.483937 43.223513,-96.484254 43.223612,-96.484297 43.22363,-96.484333 43.223654,-96.484545 43.223851,-96.484656 43.223922,-96.484884 43.224004,-96.484915 43.224015,-96.485008 43.224049,-96.48504 43.224061,-96.485274 43.224146,-96.485459 43.224197,-96.485575 43.224212,-96.485653 43.224222,-96.4859 43.224222,-96.486241 43.224185,-96.486497 43.224132,-96.486688 43.224094,-96.487112 43.223998,-96.487223 43.223965,-96.487525 43.223878,-96.487762 43.223819,-96.488086 43.223739,-96.488277 43.223698,-96.488749 43.223598,-96.488845 43.223581,-96.489772 43.22348,-96.489849 43.223468,-96.489916 43.223458,-96.490037 43.223345,-96.490074 43.223321,-96.490118 43.223304,-96.490165 43.223296,-96.490263 43.223292,-96.490323 43.223293,-96.490409 43.223295,-96.490458 43.2233,-96.490556 43.223302,-96.490562 43.223303,-96.490604 43.223312,-96.490684 43.223353,-96.490718 43.223379,-96.490762 43.223388,-96.491108 43.223395,-96.491261 43.223386,-96.491451 43.223375,-96.491501 43.223374,-96.491603 43.223372,-96.491673 43.223321,-96.491716 43.223303,-96.4919 43.223257,-96.491949 43.223254,-96.491995 43.223259,-96.492088 43.223249,-96.492135 43.22325,-96.492229 43.223244,-96.492323 43.223232,-96.492371 43.223238,-96.492416 43.223254,-96.492452 43.223278,-96.492502 43.223319,-96.492517 43.223332,-96.492565 43.223322,-96.492806 43.223286,-96.494189 43.223266,-96.494337 43.223272,-96.494775 43.223329,-96.495208 43.223404,-96.495643 43.223446,-96.495648 43.223447,-96.495694 43.223461,-96.495734 43.223481,-96.495888 43.223572,-96.49596 43.223621,-96.496044 43.223658,-96.496091 43.22367,-96.496332 43.223707,-96.496579 43.223718,-96.496639 43.223716,-96.496915 43.223638,-96.49705 43.223595,-96.497117 43.223542,-96.497176 43.223485,-96.497826 43.222811,-96.498716 43.221954,-96.498781 43.2219,-96.499146 43.221648,-96.499956 43.221072,-96.500072 43.221005,-96.500434 43.220819,-96.500599 43.22074,-96.500776 43.220677,-96.501198 43.220574,-96.501296 43.220564,-96.501632 43.22062,-96.501771 43.220657,-96.501856 43.220694,-96.502513 43.221012,-96.50264 43.221067,-96.503161 43.221274,-96.50324 43.221316,-96.503315 43.221363,-96.503393 43.221406,-96.503658 43.221504,-96.503841 43.221557,-96.503935 43.221579,-96.504706 43.221705,-96.504852 43.221723,-96.505226 43.221756,-96.505293 43.221763,-96.505787 43.221782,-96.506721 43.221711,-96.506964 43.22168,-96.507248 43.221617,-96.507568 43.221525,-96.508226 43.221277,-96.508268 43.221258,-96.508551 43.221117,-96.508749 43.220958,-96.508775 43.220928,-96.50883 43.22079,-96.508847 43.220576,-96.508841 43.220469,-96.508771 43.220261,-96.508509 43.219647,-96.508166 43.218975,-96.50811 43.218765,-96.508069 43.218301,-96.508069 43.21823,-96.50809 43.218053,-96.508144 43.217806,-96.508224 43.217601,-96.508244 43.217569,-96.508447 43.217368,-96.508644 43.217262,-96.50886 43.217174,-96.508906 43.217162,-96.50906 43.21716,-96.509204 43.217184,-96.509342 43.217224,-96.510186 43.217521,-96.51111 43.217771,-96.511201 43.2178,-96.511243 43.217818,-96.511357 43.217887,-96.511613 43.218105,-96.511682 43.218156,-96.512166 43.218461,-96.512686 43.218668,-96.512731 43.218683,-96.512826 43.218703,-96.513309 43.218773,-96.513801 43.218806,-96.514294 43.218805,-96.514588 43.218782,-96.515117 43.218691,-96.51539 43.218611,-96.515483 43.218587,-96.515619 43.218544,-96.515873 43.218435,-96.516081 43.218339,-96.516674 43.218163,-96.516837 43.218083,-96.51754 43.217825,-96.51768 43.217788,-96.517971 43.217753,-96.518367 43.217749,-96.519649 43.217778,-96.519748 43.217785,-96.52004 43.21782,-96.520182 43.217848,-96.520417 43.217902,-96.520692 43.217983,-96.520853 43.218065,-96.520891 43.218088,-96.521084 43.218251,-96.521168 43.218333,-96.521213 43.218348,-96.52133 43.218414,-96.521366 43.218439,-96.521394 43.218468,-96.521415 43.218501,-96.521444 43.218569,-96.521518 43.218776,-96.521542 43.218917,-96.521543 43.218953,-96.521523 43.21913,-96.521506 43.219164,-96.521481 43.219195,-96.521414 43.219251,-96.521446 43.219355,-96.521451 43.219391,-96.521415 43.219782,-96.521404 43.219818,-96.521387 43.219851,-96.521348 43.219903,-96.521354 43.219999,-96.521363 43.220034,-96.521451 43.220276,-96.521656 43.220561,-96.521718 43.220617,-96.522098 43.220989,-96.522226 43.221098,-96.522295 43.22115,-96.522481 43.221267,-96.522521 43.221288,-96.522968 43.221441,-96.523338 43.221539,-96.523437 43.221539,-96.523582 43.221562,-96.523671 43.221593,-96.523711 43.221614,-96.523747 43.221639,-96.523777 43.221667,-96.523856 43.221758,-96.523954 43.22196,-96.523966 43.221995,-96.523974 43.222065,-96.524027 43.222125,-96.524307 43.222375,-96.524373 43.222428,-96.525335 43.223095,-96.526012 43.223664,-96.526488 43.224025,-96.526524 43.224052,-96.526635 43.224122,-96.52672 43.224159,-96.526808 43.22419,-96.526997 43.224233,-96.527239 43.224267,-96.527338 43.224264,-96.527583 43.224248,-96.527963 43.224173,-96.52806 43.224159,-96.528207 43.22415,-96.528651 43.224149,-96.528797 43.224167,-96.529363 43.224296,-96.529449 43.224331,-96.530235 43.224703,-96.53095 43.225085,-96.531363 43.22534,-96.531539 43.225466,-96.531665 43.225575,-96.531752 43.225662,-96.531997 43.22593,-96.53215 43.22607,-96.532361 43.226221,-96.532401 43.226242,-96.532573 43.226311,-96.53262 43.226322,-96.532818 43.226329,-96.533063 43.226307,-96.533161 43.226302,-96.53321 43.226307,-96.533257 43.226318,-96.533375 43.226383,-96.533637 43.226546,-96.533669 43.226573,-96.533795 43.226767,-96.533854 43.226915,-96.53397 43.226982,-96.534013 43.227,-96.534107 43.227022,-96.534497 43.227063,-96.534639 43.227095,-96.535172 43.227355,-96.535299 43.227404,-96.535823 43.227606,-96.535915 43.227634,-96.536061 43.227647,-96.536308 43.227643,-96.536357 43.227636,-96.536546 43.227594,-96.536672 43.227538,-96.536711 43.227516,-96.536744 43.22749,-96.536762 43.227457,-96.536807 43.227281,-96.536877 43.227187,-96.53693 43.227127,-96.536952 43.227095,-96.536967 43.227061,-96.53699 43.226919,-96.537 43.226884,-96.537108 43.226764,-96.537144 43.22674,-96.5374 43.226632,-96.537628 43.226564,-96.537721 43.22654,-96.538384 43.226395,-96.538791 43.226267,-96.539183 43.226115,-96.539476 43.225985,-96.539907 43.225747,-96.540119 43.225655,-96.540246 43.225632,-96.540295 43.22563,-96.540345 43.225633,-96.540586 43.22567,-96.540678 43.225695,-96.540972 43.225827,-96.541239 43.22592,-96.541379 43.225956,-96.541661 43.226021,-96.5419 43.226065,-96.542195 43.226086,-96.542491 43.226095,-96.54259 43.226091,-96.54296 43.226056,-96.543323 43.226023,-96.543815 43.225989,-96.544301 43.22593,-96.544695 43.225915,-96.545286 43.225945,-96.54548 43.225973,-96.545838 43.226094,-96.546056 43.226178,-96.546537 43.226428,-96.547043 43.226651,-96.547223 43.226711,-96.547541 43.22681,-96.547914 43.226903,-96.548201 43.226955,-96.548349 43.226965,-96.548497 43.226965,-96.549631 43.226943,-96.550268 43.226992,-96.550413 43.227015,-96.550561 43.227027,-96.551597 43.227028,-96.551889 43.227064,-96.552038 43.227065,-96.552628 43.227045,-96.552725 43.227038,-96.552922 43.227034,-96.553602 43.226956,-96.554566 43.226804,-96.555281 43.226666,-96.555555 43.226587,-96.555946 43.226433,-96.556029 43.226394,-96.556065 43.22637,-96.556146 43.22633,-96.556183 43.226307,-96.556242 43.22625,-96.556322 43.226161,-96.556388 43.226065,-96.556445 43.225928,-96.556472 43.225751,-96.556506 43.225108,-96.55654 43.224895,-96.556604 43.224723,-96.556624 43.22469,-96.556848 43.224414,-96.556903 43.224355,-96.557181 43.224104,-96.557321 43.223958,-96.5574 43.223867,-96.557686 43.223491,-96.557738 43.22343,-96.557795 43.223372,-96.557888 43.223288,-96.558178 43.223094,-96.55834 43.223012,-96.558616 43.222935,-96.558664 43.222925,-96.558989 43.222887,-96.559186 43.222901,-96.559326 43.222934,-96.559491 43.223012,-96.559631 43.223113,-96.559659 43.223142,-96.559696 43.223208,-96.560003 43.223961,-96.560396 43.224727,-96.560409 43.224761,-96.560462 43.224861,-96.560659 43.225148,-96.560708 43.22521,-96.560844 43.225313,-96.561002 43.225397,-96.561194 43.225509,-96.561716 43.225831,-96.562123 43.226143,-96.562751 43.226694,-96.563346 43.227263,-96.5634 43.227323,-96.563508 43.227483,-96.563698 43.227879,-96.563703 43.227888,-96.563748 43.22799,-96.563971 43.228576,-96.564114 43.228842,-96.564344 43.229199,-96.565207 43.230281,-96.56529 43.23037,-96.565431 43.23047,-96.565583 43.230561,-96.56583 43.230679,-96.565876 43.230694,-96.566016 43.230728,-96.566556 43.230758,-96.566847 43.230798,-96.567658 43.231062,-96.567788 43.231113,-96.567957 43.231187,-96.568044 43.23122,-96.568261 43.231314,-96.568289 43.231344,-96.568521 43.23166,-96.568697 43.231916,-96.569178 43.2327,-96.56939 43.233356,-96.569483 43.233641,-96.569513 43.233818,-96.56952 43.233853,-96.569528 43.233924,-96.569531 43.234103,-96.569576 43.234387,-96.569591 43.234457,-96.569594 43.234493,-96.569572 43.23467,-96.569423 43.235231,-96.569405 43.235303,-96.569264 43.235684,-96.56915 43.235991,-96.569027 43.236411,-96.569024 43.236424,-96.56896 43.236764,-96.568974 43.237014,-96.569023 43.237189,-96.569059 43.237256,-96.569291 43.23753,-96.56956 43.23774,-96.5696 43.23776,-96.569913 43.237866,-96.570004 43.237893,-96.570307 43.237972,-96.571061 43.23817,-96.571165 43.238197,-96.571275 43.238253,-96.571316 43.238274,-96.571378 43.23833,-96.571403 43.238361,-96.571486 43.238491,-96.571502 43.238561,-96.571509 43.238633,-96.571486 43.238847,-96.571483 43.238857,-96.571438 43.239022,-96.571414 43.239078,-96.571278 43.239179,-96.569864 43.240181,-96.569712 43.240322,-96.569302 43.240811,-96.569068 43.241126,-96.568762 43.241654,-96.568661 43.241777,-96.568524 43.241926,-96.568163 43.242221,-96.567908 43.24239,-96.567679 43.242577,-96.567152 43.242955,-96.566735 43.243309,-96.566494 43.243489,-96.566244 43.243704,-96.56567 43.244201,-96.565633 43.244226,-96.565191 43.244454,-96.565146 43.244469,-96.565052 43.244492,-96.565004 43.244499,-96.564855 43.244498,-96.564661 43.244472,-96.564568 43.244448,-96.563929 43.244256,-96.563763 43.244178,-96.563604 43.244093,-96.563138 43.24389,-96.562812 43.243806,-96.562425 43.243749,-96.562031 43.243725,-96.561784 43.243724,-96.561537 43.243737,-96.561146 43.243779,-96.560713 43.24385,-96.56049 43.243927,-96.56045 43.243947,-96.560395 43.244007,-96.560335 43.244064,-96.560313 43.244096,-96.560251 43.244231,-96.560241 43.244267,-96.560225 43.244409,-96.560192 43.244513,-96.560085 43.244661,-96.559614 43.245027,-96.559301 43.245201,-96.558977 43.245365,-96.55876 43.245451,-96.558669 43.245479,-96.556862 43.24596,-96.555831 43.246307,-96.555329 43.246459,-96.554934 43.246607,-96.554424 43.246826,-96.553702 43.2472,-96.553367 43.247413,-96.553285 43.247453,-96.553241 43.247469,-96.553103 43.247508,-96.553054 43.247513,-96.552511 43.247512,-96.552166 43.247492,-96.551974 43.247458,-96.551104 43.247202,-96.549883 43.246728,-96.549598 43.246669,-96.5495 43.246663,-96.549402 43.246671,-96.549316 43.246707,-96.549279 43.24673,-96.549187 43.246814,-96.549168 43.246848,-96.549125 43.24695,-96.549109 43.247093,-96.549195 43.247626,-96.54934 43.248005,-96.549534 43.248372,-96.549607 43.248465,-96.549826 43.248659,-96.550009 43.248801,-96.551038 43.249603,-96.551102 43.249658,-96.551248 43.249802,-96.55133 43.249932,-96.551429 43.250172,-96.551387 43.250255,-96.551371 43.250326,-96.551373 43.250361,-96.551425 43.250608,-96.551509 43.250851,-96.551531 43.250883,-96.551621 43.250969,-96.551656 43.250993,-96.551698 43.251013,-96.55174 43.251102,-96.551975 43.251266,-96.552346 43.251637,-96.552537 43.251789,-96.552567 43.251817,-96.55266 43.251943,-96.552689 43.252012,-96.552705 43.252082,-96.552677 43.25226,-96.552591 43.252466,-96.55247 43.252528,-96.552433 43.252551,-96.552337 43.252632,-96.552211 43.252689,-96.552174 43.252712,-96.552045 43.25282,-96.55202 43.252851,-96.551988 43.252918,-96.551911 43.253049,-96.551855 43.253222,-96.551879 43.253507,-96.551919 43.25361,-96.552001 43.25374,-96.552026 43.253771,-96.552336 43.254087,-96.552541 43.254296,-96.552601 43.254352,-96.552665 43.254448,-96.552767 43.25476,-96.55272 43.255044,-96.552722 43.255069,-96.552733 43.255187,-96.552733 43.255579,-96.552699 43.255972,-96.552591 43.256247,-96.552512 43.256378,-96.552422 43.256582,-96.552411 43.256689,-96.552418 43.25676,-96.552463 43.256935,-96.552475 43.257006,-96.552484 43.257291,-96.552514 43.257504,-96.552574 43.257601,-96.552599 43.257632,-96.552657 43.257728,-96.552673 43.257761,-96.552675 43.257795,-96.552662 43.2579,-96.552648 43.25797,-96.552644 43.258042,-96.552658 43.258112,-96.55266 43.258148,-96.552683 43.258179,-96.552774 43.258264,-96.552793 43.258287,-96.552799 43.258294,-96.552879 43.258464,-96.552898 43.258496,-96.553052 43.258585,-96.553143 43.258614,-96.553151 43.258685,-96.553194 43.258786,-96.553198 43.258821,-96.553235 43.258883,-96.553275 43.258903,-96.553391 43.25895,-96.553379 43.259042,-96.553354 43.259111,-96.55338 43.259141,-96.553395 43.259175,-96.553408 43.259282,-96.553484 43.259451,-96.553499 43.259472,-96.553507 43.259482,-96.553536 43.25951,-96.553688 43.259601,-96.55373 43.25962,-96.553777 43.259631,-96.553875 43.25964,-96.553987 43.259641,-96.554118 43.25969,-96.554213 43.259712,-96.554319 43.259717,-96.55442 43.259796,-96.554583 43.259882,-96.554619 43.259901,-96.554664 43.259917,-96.554907 43.259949,-96.554969 43.259951,-96.555006 43.259952,-96.555117 43.259956,-96.555154 43.259958,-96.555541 43.259901,-96.555585 43.259886,-96.555617 43.259859,-96.555717 43.259736,-96.555819 43.259658,-96.556198 43.259329,-96.556485 43.259132,-96.556525 43.259111,-96.556656 43.259062,-96.556747 43.259033,-96.556794 43.259023,-96.55694 43.259006,-96.55699 43.259008,-96.557136 43.259024,-96.557184 43.259034,-96.557231 43.259033,-96.557865 43.258956,-96.558556 43.258944,-96.558852 43.258957,-96.559511 43.259036,-96.560847 43.259198,-96.561514 43.25933,-96.561686 43.259399,-96.561731 43.259414,-96.561815 43.259452,-96.562108 43.259642,-96.562306 43.259749,-96.562435 43.259802,-96.562573 43.259839,-96.563696 43.259973,-96.564535 43.260181,-96.56463 43.260199,-96.564823 43.260227,-96.564955 43.260277,-96.565097 43.260376,-96.56516 43.260431,-96.565306 43.260575,-96.565506 43.260821,-96.565899 43.261318,-96.565986 43.261404,-96.566702 43.261898,-96.566784 43.261936,-96.567085 43.262055,-96.567454 43.262158,-96.567501 43.262168,-96.567988 43.262227,-96.56822 43.262289,-96.568579 43.262452,-96.568863 43.262514,-96.569249 43.26257,-96.569345 43.262587,-96.569529 43.262639,-96.569784 43.262748,-96.569859 43.262794,-96.570334 43.263155,-96.570363 43.263184,-96.570523 43.263318,-96.570581 43.263375,-96.570599 43.263408,-96.570608 43.263444,-96.570692 43.263648,-96.570877 43.263816,-96.570903 43.263846,-96.571079 43.264102,-96.571127 43.264164,-96.571355 43.264353,-96.571504 43.264538,-96.571573 43.264589,-96.571707 43.264677,-96.571719 43.264685,-96.57178 43.264741,-96.571991 43.264891,-96.572065 43.264938,-96.572357 43.265071,-96.572394 43.265095,-96.572489 43.265177,-96.572529 43.265197,-96.572787 43.265302,-96.572921 43.265346,-96.573001 43.265387,-96.573075 43.265433,-96.573695 43.265785,-96.57377 43.265831,-96.574333 43.266232,-96.574397 43.266286,-96.574573 43.266458,-96.574755 43.266711,-96.574805 43.266773,-96.575124 43.267046,-96.575297 43.267263,-96.575393 43.267345,-96.575448 43.267376,-96.575947 43.267823,-96.576411 43.267995,-96.576515 43.268071,-96.576991 43.268259,-96.577037 43.268273,-96.577318 43.268339,-96.577708 43.26839,-96.577807 43.268388,-96.578002 43.268369,-96.578145 43.268344,-96.578585 43.268185,-96.57882 43.268129,-96.578868 43.268122,-96.578917 43.268121,-96.579065 43.268127,-96.579114 43.268122,-96.57945 43.268066,-96.579846 43.268067,-96.580043 43.26808,-96.580386 43.268112,-96.580485 43.268117,-96.581078 43.268103,-96.581322 43.268072,-96.581464 43.268041,-96.581553 43.26801,-96.581634 43.267969,-96.581737 43.267892,-96.581775 43.267869,-96.582096 43.267703,-96.582231 43.26766,-96.582328 43.267645,-96.582601 43.267566,-96.582699 43.267563,-96.582945 43.267568,-96.583569 43.267662,-96.583623 43.267676,-96.58407 43.26783,-96.584229 43.267915,-96.584431 43.268118,-96.584463 43.268145,-96.584644 43.268267,-96.584817 43.268395,-96.585313 43.268839,-96.585341 43.268869,-96.58566 43.269352,-96.585699 43.269455,-96.585724 43.269739,-96.585715 43.269775,-96.585647 43.269946,-96.585615 43.270013,-96.585524 43.27014,-96.585423 43.270219,-96.585407 43.270252,-96.585398 43.270287,-96.585378 43.27032,-96.585348 43.270348,-96.585308 43.270369,-96.585179 43.270422,-96.585145 43.270446,-96.585103 43.270511,-96.58505 43.270684,-96.585046 43.27072,-96.585048 43.270897,-96.58508 43.271074,-96.585112 43.271141,-96.585164 43.271278,-96.585196 43.271346,-96.585241 43.271409,-96.585293 43.271469,-96.58539 43.271594,-96.586096 43.272239,-96.586239 43.272385,-96.586291 43.272445,-96.586335 43.272547,-96.586454 43.273003,-96.586521 43.273429,-96.586534 43.273572,-96.586525 43.273715,-96.586504 43.273784,-96.586463 43.273888,-96.586452 43.273958,-96.586423 43.274027,-96.586337 43.274194,-96.586324 43.274228,-96.586196 43.274417,-96.586149 43.27448,-96.58607 43.27457,-96.585825 43.274794,-96.585722 43.274871,-96.58554 43.274991,-96.585264 43.275141,-96.584932 43.275494,-96.584865 43.27559,-96.5846 43.276013,-96.584194 43.276501,-96.584127 43.276553,-96.583957 43.276626,-96.583765 43.27666,-96.583716 43.27666,-96.583667 43.276655,-96.583573 43.276636,-96.583527 43.276623,-96.583353 43.276556,-96.583312 43.276536,-96.583277 43.27651,-96.583142 43.276361,-96.583125 43.276327,-96.58305 43.276084,-96.583038 43.276013,-96.583033 43.275942,-96.583036 43.275907,-96.58303 43.275836,-96.583124 43.275375,-96.583216 43.275098,-96.58323 43.275027,-96.583234 43.274885,-96.583216 43.274707,-96.583191 43.274638,-96.583171 43.274605,-96.583111 43.274549,-96.582937 43.274422,-96.582575 43.274308,-96.58243 43.274287,-96.582184 43.274282,-96.581943 43.274321,-96.581683 43.274423,-96.581196 43.274669,-96.581159 43.274692,-96.5811 43.274749,-96.580881 43.274941,-96.580846 43.275007,-96.580804 43.275326,-96.5808 43.275397,-96.580775 43.275573,-96.580724 43.275711,-96.580693 43.275779,-96.580522 43.276036,-96.580491 43.276063,-96.580096 43.276332,-96.57999 43.276408,-96.579239 43.277027,-96.578575 43.277604,-96.578339 43.277833,-96.578133 43.278077,-96.57795 43.278169,-96.577916 43.278196,-96.577754 43.278373,-96.577729 43.278477,-96.577726 43.278512,-96.57764 43.278862,-96.577608 43.278929,-96.577597 43.278964,-96.577557 43.279177,-96.57756 43.279212,-96.577592 43.279317,-96.577703 43.279591,-96.577819 43.279938,-96.578016 43.280266,-96.578138 43.280539,-96.578315 43.281424,-96.578319 43.281456,-96.578439 43.282492,-96.578499 43.283383,-96.578532 43.283631,-96.578643 43.283942,-96.578685 43.284044,-96.578776 43.284171,-96.578828 43.284232,-96.57893 43.284309,-96.57909 43.284394,-96.579337 43.284617,-96.579624 43.284908,-96.57985 43.285185,-96.579924 43.285316,-96.580293 43.285699,-96.580753 43.286071,-96.580789 43.286125,-96.580913 43.286396,-96.581042 43.286779,-96.581136 43.287202,-96.581398 43.287815,-96.581416 43.287958,-96.58142 43.288029,-96.581383 43.288742,-96.581351 43.288884,-96.581018 43.289706,-96.580817 43.290073,-96.580637 43.290518,-96.580605 43.290586,-96.580261 43.291217,-96.580235 43.291247,-96.580024 43.291398,-96.579995 43.291427,-96.57996 43.291453,-96.579803 43.291539,-96.57976 43.291556,-96.579666 43.291581,-96.579639 43.291609,-96.579541 43.291734,-96.579457 43.291863,-96.579176 43.292473,-96.579115 43.292863,-96.579145 43.293757,-96.579178 43.293898,-96.579277 43.294211,-96.579495 43.294646,-96.579538 43.294748,-96.579541 43.294783,-96.579511 43.295068,-96.579508 43.295139,-96.579472 43.295243,-96.579411 43.295378,-96.579401 43.295413,-96.57941 43.295448,-96.579428 43.295481,-96.579448 43.29555,-96.579448 43.295621,-96.579454 43.295657,-96.579473 43.295689,-96.579503 43.295718,-96.579543 43.295739,-96.579822 43.29581,-96.57987 43.295819,-96.580113 43.295839,-96.580212 43.295842,-96.580309 43.295834,-96.580405 43.29582,-96.580452 43.295809,-96.580491 43.295787,-96.580526 43.295761,-96.580555 43.295733,-96.580867 43.295722,-96.580964 43.295712,-96.58135 43.295657,-96.581397 43.295645,-96.581528 43.295595,-96.582066 43.29523,-96.582345 43.295035,-96.582757 43.294783,-96.58307 43.294464,-96.583246 43.29425,-96.583378 43.2941,-96.583708 43.293703,-96.583822 43.293586,-96.58402 43.293427,-96.584158 43.293325,-96.584345 43.293209,-96.584547 43.293106,-96.584891 43.292968,-96.585574 43.292758,-96.585761 43.292711,-96.585809 43.292704,-96.586006 43.29269,-96.586103 43.292679,-96.586678 43.292572,-96.587163 43.292507,-96.587645 43.292423,-96.587985 43.292377,-96.588033 43.292379,-96.588272 43.292427,-96.588314 43.292444,-96.588435 43.292505,-96.588465 43.292533,-96.588534 43.292584,-96.588636 43.292706,-96.588676 43.292771,-96.588702 43.292801,-96.588738 43.292868,-96.588876 43.293284,-96.588899 43.293425,-96.588916 43.293496,-96.588918 43.293507,-96.588994 43.29392,-96.589065 43.294128,-96.589069 43.294162,-96.589039 43.294266,-96.589041 43.294512,-96.589059 43.29458,-96.589093 43.294826,-96.589113 43.294932,-96.589192 43.295175,-96.589274 43.295265,-96.589239 43.295325,-96.589213 43.295355,-96.58915 43.29541,-96.589056 43.295687,-96.588999 43.295787,-96.588881 43.295901,-96.588492 43.296175,-96.5882 43.296309,-96.588112 43.296341,-96.58751 43.296502,-96.587462 43.296504,-96.587417 43.296487,-96.587322 43.296468,-96.586879 43.29646,-96.586296 43.296535,-96.585965 43.296607,-96.585779 43.296656,-96.585647 43.296705,-96.584869 43.297015,-96.584791 43.297059,-96.584683 43.297132,-96.584421 43.297392,-96.584367 43.297451,-96.584335 43.297478,-96.584281 43.297538,-96.584249 43.297565,-96.583956 43.297756,-96.583619 43.297904,-96.583311 43.298016,-96.583225 43.298051,-96.582947 43.298125,-96.5828 43.298136,-96.582503 43.298135,-96.582307 43.29812,-96.58221 43.298107,-96.581829 43.298031,-96.58156 43.297941,-96.581176 43.297873,-96.581029 43.297858,-96.580634 43.297853,-96.580437 43.297863,-96.58034 43.297872,-96.579966 43.297968,-96.579924 43.297986,-96.579684 43.298112,-96.579501 43.298165,-96.579262 43.298292,-96.579135 43.298348,-96.578447 43.298547,-96.577842 43.298657,-96.57779 43.298666,-96.577634 43.298694,-96.577583 43.298704,-96.576839 43.298838,-96.57655 43.298883,-96.576501 43.298891,-96.575959 43.298921,-96.575279 43.299014,-96.574591 43.299063,-96.574542 43.299064,-96.574209 43.299047,-96.573902 43.299032,-96.573706 43.299026,-96.573467 43.298987,-96.573422 43.298973,-96.573286 43.298931,-96.573201 43.298895,-96.573026 43.298829,-96.572586 43.2986,-96.572479 43.298526,-96.572179 43.298291,-96.57215 43.298262,-96.571733 43.297736,-96.571625 43.297575,-96.571148 43.29675,-96.571034 43.296592,-96.570786 43.296324,-96.570714 43.296275,-96.570483 43.296141,-96.569938 43.295895,-96.569319 43.295539,-96.569009 43.295427,-96.568764 43.295361,-96.568632 43.295313,-96.568498 43.295269,-96.568357 43.295235,-96.568309 43.295227,-96.568063 43.295209,-96.568013 43.295212,-96.567981 43.295238,-96.567906 43.295322,-96.567821 43.295419,-96.567748 43.295512,-96.567707 43.295577,-96.567527 43.295746,-96.567324 43.295901,-96.567284 43.295923,-96.567014 43.29601,-96.566819 43.296032,-96.566525 43.296048,-96.566475 43.296048,-96.566427 43.296039,-96.566295 43.29599,-96.566168 43.295935,-96.566133 43.295911,-96.565717 43.295556,-96.565297 43.29516,-96.564964 43.294896,-96.564606 43.294709,-96.564518 43.294676,-96.564471 43.294666,-96.56438 43.294639,-96.564282 43.294628,-96.564233 43.294629,-96.563988 43.294649,-96.563698 43.294692,-96.563651 43.294703,-96.563224 43.294883,-96.563067 43.294969,-96.56258 43.295325,-96.562426 43.295414,-96.562383 43.295522,-96.562347 43.295588,-96.562317 43.295617,-96.562243 43.295663,-96.562108 43.295765,-96.562038 43.295813,-96.56186 43.295873,-96.561768 43.295895,-96.561718 43.295897,-96.56167 43.295888,-96.561621 43.295885,-96.561532 43.295933,-96.561488 43.295948,-96.561024 43.296066,-96.560879 43.296087,-96.5596 43.296141,-96.557881 43.296275,-96.557733 43.296281,-96.557294 43.296332,-96.557244 43.296335,-96.557096 43.296332,-96.556359 43.296373,-96.555736 43.296483,-96.55495 43.296547,-96.554902 43.296545,-96.554805 43.296532,-96.554712 43.296509,-96.554669 43.296491,-96.554632 43.296467,-96.554605 43.296437,-96.55459 43.29638,-96.554599 43.296237,-96.554626 43.296168,-96.554646 43.296136,-96.554751 43.296015,-96.555025 43.295764,-96.555092 43.295712,-96.555303 43.295563,-96.555396 43.295481,-96.555442 43.295418,-96.555454 43.295383,-96.555473 43.295241,-96.555466 43.29517,-96.555386 43.294891,-96.555351 43.294751,-96.555323 43.294682,-96.55498 43.294089,-96.554938 43.294025,-96.554738 43.293821,-96.554574 43.29369,-96.554243 43.293426,-96.554139 43.29335,-96.5541 43.293329,-96.55403 43.293279,-96.553955 43.293232,-96.553757 43.293126,-96.553589 43.293053,-96.553305 43.292911,-96.553128 43.292846,-96.553082 43.292835,-96.553036 43.292848,-96.55294 43.292864,-96.552693 43.29287,-96.552351 43.292838,-96.552252 43.292833,-96.552203 43.292834,-96.552056 43.29285,-96.551914 43.292877,-96.551639 43.292958,-96.551251 43.293009,-96.551205 43.29302,-96.550935 43.293108,-96.550896 43.293129,-96.550869 43.293159,-96.550799 43.293254,-96.550765 43.29332,-96.550742 43.293352,-96.550611 43.293696,-96.550579 43.293763,-96.550553 43.293794,-96.550494 43.29385,-96.550367 43.293959,-96.550152 43.294107,-96.550072 43.294148,-96.550035 43.294172,-96.54995 43.294209,-96.549548 43.294343,-96.549501 43.294355,-96.549452 43.29436,-96.549206 43.294371,-96.549058 43.29436,-96.548916 43.294332,-96.547882 43.294102,-96.547495 43.294041,-96.547397 43.294035,-96.547068 43.294052,-96.547053 43.294053,-96.546957 43.29407,-96.546401 43.294221,-96.545832 43.294436,-96.545699 43.294483,-96.545604 43.294502,-96.545411 43.294529,-96.545219 43.294562,-96.544775 43.294573,-96.544727 43.294581,-96.544692 43.294607,-96.544533 43.29469,-96.544485 43.294701,-96.544388 43.294709,-96.544146 43.294742,-96.544096 43.294745,-96.544047 43.294742,-96.54395 43.294729,-96.543821 43.294742,-96.543403 43.294852,-96.541856 43.295222,-96.541387 43.295331,-96.541342 43.295345,-96.541247 43.295365,-96.541156 43.295392,-96.540943 43.29548,-96.54086 43.295519,-96.540815 43.295533,-96.540774 43.295553,-96.540667 43.295626,-96.54057 43.295707,-96.540517 43.295767,-96.540498 43.2958,-96.54035 43.296129,-96.540315 43.296208,-96.540156 43.296507,-96.539655 43.297283,-96.53961 43.297346,-96.539473 43.297495,-96.539425 43.297557,-96.539262 43.297857,-96.539091 43.298184,-96.539053 43.298257,-96.539032 43.29829,-96.538839 43.298498,-96.538764 43.298544,-96.538717 43.298551,-96.538618 43.298555,-96.538569 43.298548,-96.538524 43.298535,-96.538138 43.298375,-96.537905 43.298317,-96.537856 43.29831,-96.537758 43.298309,-96.537512 43.298315,-96.537326 43.298361,-96.53634 43.29859,-96.535612 43.298697,-96.534929 43.298762,-96.53488 43.298764,-96.534588 43.298803,-96.533965 43.298916,-96.532976 43.299137,-96.531296 43.299558,-96.531018 43.299632,-96.530691 43.299713,-96.530467 43.299788,-96.530381 43.299823,-96.530195 43.299941,-96.530145 43.3,-96.530099 43.300063,-96.530082 43.300096,-96.53008 43.300274,-96.530087 43.30031,-96.530154 43.300405,-96.530302 43.300547,-96.530517 43.30073,-96.530718 43.300934,-96.531134 43.301287,-96.531603 43.301701,-96.531723 43.301814,-96.531921 43.30202,-96.532018 43.302144,-96.532058 43.302209,-96.532111 43.302309,-96.532222 43.302546,-96.532255 43.302866,-96.532255 43.302938,-96.532243 43.30308,-96.532175 43.303435,-96.532029 43.303924,-96.531905 43.304233,-96.53186 43.304296,-96.53183 43.304325,-96.531694 43.304428,-96.531654 43.30445,-96.531612 43.304467,-96.53114 43.304571,-96.530947 43.304588,-96.53085 43.304591,-96.530704 43.304607,-96.530221 43.304674,-96.529407 43.304933,-96.529359 43.30494,-96.529163 43.304947,-96.529016 43.304932,-96.528872 43.30491,-96.528827 43.304896,-96.528572 43.30479,-96.528491 43.304752,-96.528214 43.304677,-96.528116 43.304678,-96.527674 43.304701,-96.52763 43.304716,-96.527473 43.304802,-96.527431 43.304821,-96.527355 43.304867,-96.527055 43.305104,-96.527026 43.305132,-96.526962 43.305229,-96.526904 43.305365,-96.526869 43.305469,-96.526861 43.305611,-96.526901 43.305895,-96.526883 43.306037,-96.526885 43.306215,-96.526909 43.306284,-96.527091 43.306538,-96.52721 43.306682,-96.527305 43.306764,-96.527343 43.306787,-96.527588 43.306907,-96.527744 43.306995,-96.527825 43.307035,-96.527871 43.30705,-96.527965 43.307071,-96.52801 43.307086,-96.528086 43.307132,-96.528177 43.3072,-96.528325 43.307312,-96.528353 43.307342,-96.528571 43.307701,-96.52859 43.307878,-96.528598 43.307913,-96.528678 43.308043,-96.528887 43.308284,-96.529158 43.308972,-96.529165 43.309007,-96.529163 43.309042,-96.529154 43.309078,-96.529138 43.309111,-96.529105 43.30913,-96.529011 43.309153,-96.528877 43.309198,-96.528805 43.309247,-96.528761 43.309264,-96.528664 43.309277,-96.528617 43.309273,-96.528091 43.309078,-96.527807 43.309025,-96.527758 43.309026,-96.527713 43.30904,-96.527631 43.309078,-96.527572 43.309215,-96.527565 43.309286,-96.527499 43.30942,-96.527495 43.309455,-96.527458 43.309521,-96.527434 43.309552,-96.527417 43.309586,-96.527382 43.309726,-96.527359 43.309758,-96.527295 43.309812,-96.527217 43.309856,-96.52709 43.30991,-96.527044 43.309922,-96.526995 43.309928,-96.526945 43.309929,-96.526601 43.309903,-96.526527 43.309945,-96.526483 43.309961,-96.526435 43.309971,-96.52605 43.310013,-96.525809 43.310022,-96.525678 43.310045,-96.525475 43.310082,-96.525247 43.310146,-96.525153 43.310168,-96.525103 43.310171,-96.525005 43.310163,-96.524921 43.310205,-96.524596 43.310422,-96.524493 43.310499,-96.524433 43.310555,-96.524224 43.310797,-96.524159 43.310892,-96.524104 43.311029,-96.524057 43.311345,-96.524059 43.311381,-96.524095 43.311557,-96.524175 43.311726,-96.524195 43.311758,-96.524321 43.311911,-96.524485 43.312044,-96.524522 43.312067,-96.524614 43.312091,-96.524708 43.31211,-96.524895 43.312156,-96.525231 43.312209,-96.525373 43.31224,-96.525466 43.312265,-96.5261 43.312464,-96.526538 43.312627,-96.527127 43.312888,-96.527166 43.31291,-96.527383 43.313055,-96.52754 43.313192,-96.527606 43.313244,-96.527635 43.313273,-96.527731 43.313354,-96.527873 43.313453,-96.528114 43.313631,-96.528199 43.313719,-96.528314 43.313875,-96.52842 43.313996,-96.528441 43.314028,-96.528506 43.314236,-96.528532 43.314304,-96.528636 43.314504,-96.528662 43.314609,-96.528669 43.31468,-96.528639 43.314964,-96.528641 43.314999,-96.528682 43.315211,-96.528704 43.315281,-96.528853 43.315657,-96.529005 43.316217,-96.529011 43.316395,-96.529001 43.316428,-96.528942 43.316486,-96.528906 43.316509,-96.528865 43.316529,-96.528819 43.316544,-96.528674 43.316566,-96.528629 43.316559,-96.528508 43.316498,-96.528294 43.31641,-96.52822 43.316364,-96.528141 43.316321,-96.528067 43.316274,-96.527755 43.316045,-96.527683 43.315998,-96.527313 43.315824,-96.527177 43.315785,-96.527083 43.315766,-96.527034 43.315761,-96.526692 43.315794,-96.526646 43.315808,-96.526519 43.315863,-96.526503 43.315893,-96.526507 43.315929,-96.5265 43.315965,-96.526483 43.315998,-96.52645 43.316025,-96.526312 43.316214,-96.526061 43.31664,-96.525976 43.316681,-96.525939 43.316705,-96.52591 43.316734,-96.525866 43.316797,-96.525824 43.316899,-96.525737 43.317359,-96.525664 43.317998,-96.525623 43.318137,-96.525608 43.318208,-96.525603 43.318279,-96.525611 43.318492,-96.525622 43.318563,-96.525639 43.318633,-96.525653 43.318667,-96.525777 43.3189,-96.525801 43.318932,-96.52583 43.31896,-96.525899 43.31901,-96.525938 43.319033,-96.525985 43.319041,-96.526134 43.31904,-96.526277 43.319018,-96.526324 43.319006,-96.52642 43.31899,-96.526464 43.318975,-96.526731 43.318817,-96.526829 43.318828,-96.526879 43.318825,-96.526972 43.318805,-96.527062 43.31878,-96.52711 43.318775,-96.527277 43.318702,-96.527364 43.318673,-96.52741 43.318664,-96.527459 43.318661,-96.527551 43.318645,-96.527695 43.318632,-96.527849 43.318642,-96.527936 43.318648,-96.527985 43.318646,-96.528126 43.318667,-96.528171 43.318677,-96.52821 43.318696,-96.528259 43.318698,-96.528416 43.318762,-96.528464 43.318765,-96.528498 43.318788,-96.528585 43.31881,-96.52862 43.318833,-96.528667 43.318838,-96.528705 43.318857,-96.52884 43.318894,-96.528887 43.318901,-96.528927 43.318922,-96.528973 43.318936,-96.529021 43.318944,-96.529104 43.318947,-96.529206 43.31907,-96.529472 43.31928,-96.529531 43.319337,-96.529843 43.319784,-96.530035 43.31999,-96.530107 43.320039,-96.53019 43.320077,-96.530455 43.320237,-96.53051 43.320296,-96.530752 43.320471,-96.530939 43.320638,-96.530962 43.320669,-96.530975 43.320703,-96.530973 43.320775,-96.530935 43.320878,-96.530912 43.32091,-96.530881 43.320938,-96.530686 43.321044,-96.530495 43.321082,-96.52986 43.321147,-96.529789 43.321195,-96.529725 43.321248,-96.529689 43.321272,-96.529663 43.321303,-96.529647 43.321336,-96.529499 43.321559,-96.529332 43.322005,-96.529189 43.322308,-96.529159 43.322337,-96.529056 43.322413,-96.529009 43.322472,-96.52897 43.322649,-96.52895 43.322718,-96.528933 43.322825,-96.528901 43.323251,-96.528906 43.323892,-96.528959 43.32403,-96.528945 43.324061,-96.528926 43.324097,-96.52888 43.324161,-96.528866 43.324195,-96.528848 43.324337,-96.528865 43.324371,-96.52903 43.32455,-96.529552 43.324979,-96.530019 43.325245,-96.530385 43.325535,-96.530699 43.325857,-96.530798 43.325922,-96.531021 43.326001,-96.531468 43.326225,-96.531573 43.326301,-96.531604 43.326329,-96.531705 43.326453,-96.53181 43.326616,-96.531964 43.32688,-96.532071 43.327042,-96.532106 43.32711,-96.53218 43.32728,-96.532199 43.327313,-96.532607 43.327764,-96.532702 43.327891,-96.533189 43.328714,-96.533218 43.328783,-96.533224 43.328818,-96.533207 43.328962,-96.533187 43.328994,-96.532863 43.329311,-96.532819 43.329375,-96.53273 43.329542,-96.532689 43.329608,-96.532423 43.32999,-96.532375 43.330052,-96.531931 43.330692,-96.531477 43.3316,-96.531464 43.331667,-96.531458 43.331883,-96.531498 43.331986,-96.531604 43.332223,-96.531895 43.332756,-96.532078 43.333048,-96.532123 43.333112,-96.53237 43.333418,-96.532415 43.333481,-96.532491 43.333573,-96.532507 43.333606,-96.532501 43.33382,-96.53242 43.334245,-96.532418 43.334388,-96.532432 43.334458,-96.53245 43.334491,-96.53248 43.33452,-96.532516 43.334545,-96.532559 43.334561,-96.532607 43.334569,-96.532755 43.334576,-96.533396 43.334547,-96.533593 43.334549,-96.533642 43.334553,-96.534073 43.334636,-96.534117 43.334652,-96.534235 43.334716,-96.534429 43.334878,-96.534645 43.335159,-96.534914 43.33562,-96.534949 43.335687,-96.535089 43.336467,-96.535087 43.336502,-96.535074 43.336536,-96.535034 43.336639,-96.535022 43.336674,-96.534515 43.336937,-96.534072 43.337259,-96.533625 43.337408,-96.533494 43.337457,-96.533456 43.33748,-96.533329 43.337588,-96.533058 43.337795,-96.532531 43.33822,-96.532337 43.338406,-96.532324 43.33842,-96.532102 43.338657,-96.531665 43.339335,-96.531596 43.339544,-96.531561 43.339969,-96.531601 43.340143,-96.531632 43.340211,-96.53169 43.340309,-96.531719 43.340377,-96.531736 43.340446,-96.531856 43.340827,-96.531895 43.340931,-96.531936 43.340996,-96.532009 43.341128,-96.532087 43.341219,-96.532119 43.341246,-96.532416 43.341434,-96.53251 43.341517,-96.532631 43.341671,-96.532663 43.341699,-96.532828 43.341778,-96.53287 43.341917,-96.532897 43.341986,-96.532914 43.342092,-96.53292 43.342163,-96.532929 43.342198,-96.532931 43.342268,-96.532892 43.342406,-96.53288 43.342476,-96.532843 43.342616,-96.532829 43.34265,-96.532785 43.342714,-96.532759 43.342744,-96.532362 43.343107,-96.532283 43.34315,-96.532239 43.343166,-96.532146 43.343189,-96.532096 43.343193,-96.531851 43.3432,-96.531731 43.343137,-96.531699 43.343111,-96.531682 43.343077,-96.531658 43.343008,-96.531625 43.342511,-96.531607 43.342405,-96.531596 43.34237,-96.531546 43.342308,-96.531359 43.342143,-96.531058 43.34202,-96.531011 43.342009,-96.530383 43.34191,-96.530339 43.341916,-96.530213 43.341973,-96.530167 43.341986,-96.530118 43.341988,-96.529677 43.342036,-96.529282 43.34205,-96.529177 43.342068,-96.528661 43.342162,-96.528527 43.342207,-96.528444 43.342246,-96.528063 43.342472,-96.527919 43.34257,-96.527798 43.342683,-96.527719 43.342773,-96.527672 43.342835,-96.527643 43.342864,-96.527621 43.342897,-96.527505 43.343243,-96.527478 43.343311,-96.527459 43.343381,-96.527383 43.34377,-96.527372 43.343805,-96.52726 43.344004,-96.52711 43.344187,-96.527008 43.344311,-96.526682 43.3448,-96.526558 43.344987,-96.526276 43.345323,-96.526186 43.345408,-96.52609 43.345489,-96.525461 43.345944,-96.525092 43.34636,-96.524877 43.346605,-96.524567 43.346892,-96.524542 43.346915,-96.524376 43.347134,-96.524354 43.347203,-96.524339 43.347345,-96.524293 43.347388,-96.524279 43.347422,-96.524268 43.347492,-96.52427 43.347527,-96.52426 43.347597,-96.52429 43.347702,-96.52431 43.347735,-96.524337 43.347764,-96.524442 43.347841,-96.524452 43.34793,-96.524516 43.348176,-96.524531 43.34821,-96.524672 43.348356,-96.524706 43.348382,-96.524841 43.348427,-96.524984 43.348454,-96.525033 43.348454,-96.52523 43.348438,-96.525368 43.348399,-96.525411 43.348381,-96.525531 43.348319,-96.52563 43.348239,-96.525843 43.347999,-96.525976 43.347895,-96.526214 43.347767,-96.526259 43.347751,-96.526308 43.347745,-96.526652 43.34775,-96.526847 43.347769,-96.526896 43.347771,-96.527036 43.347807,-96.527126 43.347836,-96.527253 43.347891,-96.527372 43.347955,-96.527442 43.348005,-96.527643 43.348162,-96.527667 43.348194,-96.527704 43.34826,-96.527716 43.348295,-96.527766 43.348543,-96.527766 43.348578,-96.527758 43.348614,-96.527733 43.348682,-96.527593 43.348902,-96.527528 43.349007,-96.527459 43.349046,-96.527427 43.349073,-96.527403 43.349105,-96.527368 43.349171,-96.527288 43.3493,-96.527269 43.349369,-96.527268 43.349405,-96.527277 43.34944,-96.527294 43.349474,-96.527319 43.349505,-96.527337 43.349538,-96.527184 43.350042,-96.527146 43.350253,-96.527105 43.350274,-96.527069 43.350298,-96.527038 43.350326,-96.527015 43.350358,-96.52696 43.350531,-96.526958 43.350567,-96.526966 43.350637,-96.526965 43.350779,-96.52697 43.35085,-96.52698 43.350885,-96.527022 43.35095,-96.527037 43.350981,-96.527017 43.351088,-96.527022 43.351267,-96.527036 43.351299,-96.527064 43.351329,-96.527086 43.351361,-96.527044 43.351463,-96.527004 43.351528,-96.52692 43.351614,-96.52686 43.351668,-96.526718 43.351766,-96.526668 43.351827,-96.526638 43.351856,-96.526581 43.351992,-96.526555 43.352022,-96.526523 43.35205,-96.526486 43.352074,-96.526443 43.352092,-96.526386 43.352226,-96.526365 43.352259,-96.526218 43.3524,-96.526185 43.352426,-96.526035 43.352519,-96.525604 43.352759,-96.525542 43.352814,-96.525313 43.353089,-96.525142 43.353347,-96.525108 43.353472,-96.525105 43.353508,-96.525114 43.353579,-96.525176 43.353752,-96.525195 43.353785,-96.525262 43.353836,-96.525514 43.354006,-96.525582 43.354057,-96.5261 43.354388,-96.526165 43.354442,-96.526256 43.354527,-96.526653 43.354793,-96.527084 43.355138,-96.527145 43.355194,-96.52722 43.355286,-96.527386 43.355623,-96.527415 43.355691,-96.527684 43.35619,-96.527748 43.356325,-96.527826 43.356604,-96.527829 43.356675,-96.527825 43.356711,-96.527825 43.356996,-96.52781 43.357066,-96.527348 43.357974,-96.527304 43.358076,-96.527243 43.358321,-96.5272 43.358642,-96.527464 43.359655,-96.527487 43.359761,-96.527489 43.359796,-96.527475 43.360118,-96.527436 43.360329,-96.527411 43.360434,-96.52735 43.36057,-96.527291 43.360743,-96.52724 43.36099,-96.527233 43.361061,-96.527233 43.361133,-96.527222 43.361275,-96.527228 43.361382,-96.527261 43.361559,-96.527292 43.361664,-96.527557 43.362164,-96.527564 43.362199,-96.527569 43.362556,-96.527575 43.362591,-96.527589 43.362625,-96.527614 43.362657,-96.527644 43.362685,-96.527738 43.362708,-96.527787 43.362714,-96.527836 43.362713,-96.528023 43.362666,-96.528255 43.362532,-96.528428 43.362463,-96.528613 43.362414,-96.528692 43.362401,-96.528804 43.362384,-96.528853 43.362382,-96.529098 43.3624,-96.529143 43.362413,-96.529373 43.36255,-96.52946 43.362636,-96.529522 43.362772,-96.529539 43.36295,-96.529528 43.363057,-96.529507 43.363126,-96.529419 43.363366,-96.529391 43.36347,-96.52936 43.363681,-96.529388 43.364037,-96.529426 43.364248,-96.529439 43.364283,-96.529622 43.364493,-96.529644 43.364525,-96.529676 43.364553,-96.529784 43.364625,-96.52985 43.364677,-96.530344 43.365025,-96.530403 43.365083,-96.530537 43.365232,-96.530676 43.36542,-96.530821 43.365648,-96.530838 43.365681,-96.530867 43.365785,-96.530907 43.365997,-96.530873 43.366887,-96.53088 43.366975,-96.530852 43.36726,-96.530921 43.367685,-96.530936 43.367755,-96.530942 43.367817,-96.530944 43.367826,-96.530968 43.36822,-96.530958 43.368397,-96.530961 43.368433,-96.530874 43.36871,-96.530724 43.368891,-96.530422 43.369072,-96.530217 43.369172,-96.529992 43.369245,-96.529944 43.369253,-96.529401 43.3693,-96.529306 43.369309,-96.528911 43.369317,-96.528715 43.369298,-96.528557 43.369257,-96.528417 43.369197,-96.528271 43.3691,-96.528144 43.368991,-96.528123 43.368959,-96.528108 43.368925,-96.528035 43.368718,-96.52801 43.368612,-96.527996 43.368399,-96.527982 43.368365,-96.527903 43.368274,-96.527872 43.368246,-96.527823 43.368185,-96.52779 43.368159,-96.527747 43.368141,-96.52765 43.368127,-96.527109 43.368107,-96.52692 43.368114,-96.526911 43.368115,-96.526766 43.368136,-96.526718 43.368147,-96.526552 43.368223,-96.526433 43.368286,-96.526365 43.368335,-96.526006 43.368571,-96.52598 43.368601,-96.525963 43.368635,-96.525944 43.368741,-96.525946 43.368776,-96.525937 43.368808,-96.525852 43.368896,-96.52583 43.368928,-96.525802 43.368958,-96.525768 43.368984,-96.525711 43.369042,-96.525559 43.369182,-96.525314 43.369358,-96.525247 43.369411,-96.524841 43.369769,-96.524762 43.369859,-96.524751 43.369929,-96.524751 43.370071,-96.524763 43.370106,-96.524828 43.37024,-96.524887 43.370376,-96.525147 43.370637,-96.525267 43.37075,-96.525323 43.370809,-96.525468 43.370996,-96.525484 43.37103,-96.525493 43.371065,-96.525491 43.371101,-96.525499 43.371208,-96.52549 43.371242,-96.525381 43.371442,-96.525361 43.371548,-96.525343 43.371619,-96.525138 43.372281,-96.52505 43.372485,-96.52501 43.372551,-96.524982 43.37258,-96.524911 43.372629,-96.524796 43.372697,-96.524751 43.372712,-96.524658 43.372735,-96.524509 43.372736,-96.524461 43.372731,-96.524373 43.372698,-96.524333 43.372676,-96.524298 43.372651,-96.524136 43.372509,-96.523697 43.372127,-96.523568 43.372019,-96.523531 43.371996,-96.523464 43.371944,-96.52339 43.371896,-96.5232 43.371784,-96.523165 43.371759,-96.523125 43.371738,-96.523076 43.371733,-96.522829 43.371726,-96.522733 43.371741,-96.522686 43.371752,-96.522463 43.371829,-96.522194 43.371985,-96.522163 43.372013,-96.522059 43.37219,-96.522046 43.372224,-96.52202 43.372403,-96.52204 43.372432,-96.522076 43.372458,-96.522106 43.372486,-96.522124 43.37252,-96.522146 43.372589,-96.52216 43.37273,-96.522175 43.372801,-96.522195 43.372978,-96.522182 43.373192,-96.522155 43.373333,-96.522041 43.373568,-96.521889 43.373946,-96.521834 43.37397,-96.521796 43.373992,-96.521765 43.374021,-96.521725 43.374085,-96.521677 43.374185,-96.52166 43.374254,-96.521644 43.374288,-96.521625 43.374358,-96.521652 43.374499,-96.521686 43.374566,-96.521662 43.374653,-96.521531 43.374922,-96.521519 43.374957,-96.521435 43.375381,-96.521422 43.375415,-96.521349 43.375696,-96.521352 43.375839,-96.521358 43.375874,-96.521383 43.375905,-96.521867 43.376402,-96.521968 43.376481,-96.522006 43.376503,-96.522052 43.376516,-96.522139 43.376549,-96.522178 43.376572,-96.522212 43.376598,-96.522475 43.376758,-96.522701 43.376991,-96.522863 43.377127,-96.523005 43.377273,-96.522999 43.377312,-96.523005 43.377383,-96.523087 43.377551,-96.523112 43.377582,-96.523147 43.377607,-96.523275 43.377661,-96.523367 43.377687,-96.523611 43.377994,-96.523979 43.3785,-96.524027 43.378601,-96.524047 43.378671,-96.524073 43.378739,-96.524133 43.378837,-96.524351 43.379076,-96.524373 43.379108,-96.524405 43.379175,-96.524509 43.379705,-96.524517 43.379776,-96.524512 43.379812,-96.524448 43.379984,-96.524334 43.380182,-96.524309 43.380213,-96.524008 43.380449,-96.523936 43.380497,-96.523813 43.380556,-96.523235 43.380758,-96.522334 43.380951,-96.522289 43.380965,-96.522249 43.380987,-96.522144 43.381062,-96.521999 43.381207,-96.521978 43.381239,-96.521974 43.381274,-96.521983 43.38138,-96.522008 43.381448,-96.522077 43.381544,-96.522104 43.381572,-96.522141 43.381595,-96.522185 43.38161,-96.522233 43.381613,-96.522282 43.381606,-96.522469 43.381565,-96.522818 43.381437,-96.522906 43.381411,-96.522948 43.381391,-96.523038 43.381366,-96.523229 43.381346,-96.523323 43.381331,-96.523421 43.381327,-96.52347 43.381331,-96.523659 43.381367,-96.523751 43.381394,-96.523879 43.381446,-96.524077 43.38155,-96.524152 43.381595,-96.524459 43.381825,-96.524484 43.381856,-96.5245 43.381889,-96.524606 43.382271,-96.524589 43.382377,-96.524504 43.382617,-96.52448 43.382647,-96.524368 43.382717,-96.523968 43.382922,-96.52346 43.383256,-96.52322 43.383378,-96.522992 43.383513,-96.522581 43.383815,-96.522517 43.383867,-96.522441 43.383958,-96.522335 43.384077,-96.522241 43.384201,-96.521938 43.384525,-96.521917 43.384557,-96.521795 43.384711,-96.521747 43.384811,-96.521739 43.384846,-96.521756 43.385022,-96.521757 43.385093,-96.521704 43.385266,-96.521697 43.385301,-96.521671 43.385762,-96.521662 43.385905,-96.521686 43.386151,-96.521698 43.386229,-96.521792 43.386509,-96.521742 43.386612,-96.521722 43.386683,-96.52172 43.386755,-96.521734 43.386862,-96.52175 43.386932,-96.52181 43.38699,-96.521882 43.387085,-96.521912 43.387153,-96.521982 43.387362,-96.522038 43.387462,-96.522162 43.387659,-96.522191 43.387688,-96.522259 43.38774,-96.522251 43.387818,-96.522261 43.388107,-96.522288 43.388357,-96.52233 43.388499,-96.52237 43.388602,-96.522417 43.388704,-96.522459 43.38877,-96.522583 43.388926,-96.522613 43.388955,-96.522683 43.389007,-96.523124 43.389295,-96.523311 43.389416,-96.523377 43.38947,-96.523578 43.389716,-96.523622 43.389732,-96.523746 43.389792,-96.523782 43.389817,-96.523813 43.389845,-96.523861 43.389908,-96.524058 43.390197,-96.524098 43.390262,-96.524113 43.390296,-96.524307 43.391032,-96.524363 43.391132,-96.524434 43.391231,-96.524379 43.391551,-96.524074 43.392858,-96.524005 43.393212,-96.523993 43.393319,-96.523987 43.393499,-96.524 43.393606,-96.524001 43.393677,-96.523996 43.393713,-96.523976 43.393783,-96.524 43.393853,-96.524218 43.394698,-96.524275 43.394835,-96.524447 43.395171,-96.524677 43.395529,-96.524702 43.39556,-96.525149 43.395988,-96.525242 43.396072,-96.525445 43.396176,-96.525576 43.396227,-96.525974 43.396371,-96.526114 43.396406,-96.52706 43.396618,-96.527291 43.396684,-96.527872 43.396885,-96.528236 43.397072,-96.528852 43.397432,-96.529063 43.397526,-96.52924 43.397589,-96.529336 43.397607,-96.529583 43.397624,-96.529828 43.39761,-96.530007 43.397548,-96.530046 43.397527,-96.530138 43.397443,-96.530184 43.39738,-96.530195 43.397345,-96.530199 43.397309,-96.530195 43.397238,-96.530059 43.39669,-96.530016 43.396514,-96.53 43.396408,-96.530015 43.396157,-96.530082 43.395985,-96.530123 43.39592,-96.530174 43.395859,-96.530324 43.395716,-96.530396 43.395667,-96.53064 43.395544,-96.530948 43.395429,-96.531314 43.395321,-96.531362 43.395311,-96.531996 43.395229,-96.533204 43.395094,-96.533269 43.395087,-96.533704 43.395018,-96.534691 43.394942,-96.535519 43.394836,-96.535742 43.394815,-96.536157 43.394777,-96.536552 43.394766,-96.536849 43.394773,-96.537045 43.394794,-96.537235 43.394833,-96.537373 43.394873,-96.537459 43.394909,-96.53771 43.395083,-96.537742 43.39511,-96.53788 43.395258,-96.538608 43.396354,-96.538663 43.396414,-96.53914 43.396825,-96.539527 43.397049,-96.540057 43.397243,-96.540194 43.397285,-96.540334 43.39732,-96.54091 43.397426,-96.540959 43.397432,-96.541205 43.397446,-96.54155 43.397424,-96.54169 43.397391,-96.54173 43.39737,-96.541764 43.397344,-96.541895 43.397193,-96.541972 43.397023,-96.54199 43.396953,-96.542083 43.396567,-96.542096 43.396533,-96.542119 43.396501,-96.542199 43.396411,-96.542449 43.396189,-96.542559 43.396117,-96.542639 43.396074,-96.542765 43.396019,-96.543004 43.395974,-96.543053 43.395968,-96.543399 43.395958,-96.543547 43.395966,-96.543887 43.396015,-96.543935 43.396025,-96.544211 43.396104,-96.544429 43.396189,-96.544716 43.396329,-96.5448 43.396366,-96.544921 43.396428,-96.545372 43.396757,-96.54543 43.396815,-96.545517 43.396943,-96.545588 43.397151,-96.5456 43.397222,-96.545605 43.397293,-96.545595 43.397436,-96.545525 43.39757,-96.545363 43.397831,-96.54515 43.398232,-96.544838 43.398948,-96.544774 43.399302,-96.544783 43.399694,-96.544881 43.400007,-96.54492 43.400073,-96.544948 43.400103,-96.544981 43.400129,-96.545039 43.400187,-96.545219 43.400309,-96.545303 43.400348,-96.545852 43.400509,-96.545896 43.400526,-96.546088 43.400639,-96.546417 43.400855,-96.546588 43.400984,-96.546644 43.401043,-96.546748 43.401165,-96.547117 43.401629,-96.547169 43.40173,-96.547246 43.401937,-96.547295 43.402038,-96.547669 43.402737,-96.547817 43.402963,-96.548043 43.40325,-96.548159 43.403397,-96.548349 43.403605,-96.548408 43.403662,-96.548476 43.403713,-96.548629 43.403802,-96.548702 43.403849,-96.548781 43.403892,-96.548825 43.403908,-96.548917 43.403933,-96.548961 43.403949,-96.549251 43.403993,-96.549336 43.403997,-96.549622 43.40394,-96.550458 43.403715,-96.550506 43.403706,-96.550653 43.40369,-96.550998 43.403692,-96.551691 43.403726,-96.551985 43.403756,-96.552702 43.403897,-96.55298 43.403971,-96.55351 43.404165,-96.553742 43.404226,-96.554241 43.404455,-96.554302 43.404511,-96.554329 43.404556,-96.554362 43.404609,-96.554376 43.404643,-96.554375 43.404786,-96.554353 43.404891,-96.554327 43.404943,-96.554267 43.405065,-96.554221 43.40524,-96.554218 43.405491,-96.554267 43.405738,-96.554432 43.406056,-96.554458 43.406106,-96.554485 43.406136,-96.55452 43.406161,-96.55469 43.406234,-96.554782 43.406258,-96.554924 43.406288,-96.55517 43.406295,-96.555318 43.406292,-96.555462 43.406266,-96.555497 43.40624,-96.555537 43.406219,-96.555582 43.406203,-96.555767 43.406155,-96.556343 43.406052,-96.55649 43.406037,-96.556539 43.406037,-96.556637 43.406027,-96.556686 43.406027,-96.556978 43.406062,-96.557023 43.406076,-96.557234 43.406166,-96.557305 43.406215,-96.557334 43.406244,-96.557385 43.406286,-96.557561 43.406431,-96.557653 43.406557,-96.557678 43.406626,-96.557737 43.406762,-96.557777 43.406902,-96.557847 43.407185,-96.557894 43.407468,-96.55799 43.40778,-96.558061 43.407913,-96.558127 43.408009,-96.558181 43.408069,-96.558335 43.408208,-96.558445 43.40828,-96.558675 43.40841,-96.558677 43.408412,-96.558718 43.408432,-96.559046 43.408648,-96.559246 43.408806,-96.559385 43.408954,-96.559474 43.409081,-96.559627 43.409421,-96.55965 43.40967,-96.55963 43.410741,-96.559689 43.411168,-96.559711 43.411274,-96.559876 43.411795,-96.55989 43.411829,-96.559987 43.411994,-96.560313 43.412352,-96.560425 43.41245,-96.560439 43.412462,-96.560514 43.412508,-96.560682 43.412584,-96.560911 43.412651,-96.560959 43.412659,-96.561301 43.412692,-96.561543 43.412721,-96.561592 43.412723,-96.561943 43.41271,-96.562725 43.412637,-96.56282 43.412618,-96.562918 43.412631,-96.563057 43.412666,-96.563106 43.412673,-96.563205 43.41267,-96.563303 43.412661,-96.563401 43.412658,-96.563779 43.412742,-96.563874 43.412772,-96.564051 43.412828,-96.564138 43.412861,-96.564391 43.412972,-96.564637 43.413094,-96.564793 43.413181,-96.564866 43.413228,-96.565046 43.413398,-96.565678 43.414367,-96.565704 43.414397,-96.566438 43.415116,-96.566691 43.41567,-96.566856 43.415867,-96.567046 43.416046,-96.568012 43.416721,-96.568087 43.416774,-96.568258 43.416903,-96.568584 43.417064,-96.56889 43.417181,-96.568936 43.417194,-96.569129 43.417227,-96.569372 43.417256,-96.569823 43.417397,-96.569873 43.417412,-96.570199 43.41748,-96.570255 43.417539,-96.57029 43.417564,-96.570331 43.417585,-96.571034 43.417843,-96.571158 43.417901,-96.571341 43.417953,-96.57139 43.417959,-96.571494 43.417956,-96.571947 43.418232,-96.572249 43.418354,-96.57273 43.418661,-96.572819 43.418691,-96.572866 43.418702,-96.573364 43.418857,-96.573483 43.41892,-96.573555 43.418969,-96.573585 43.418997,-96.573663 43.419088,-96.573726 43.419185,-96.573746 43.419255,-96.573749 43.419291,-96.573767 43.419361,-96.573764 43.419396,-96.573729 43.419536,-96.573693 43.419603,-96.573645 43.419664,-96.573573 43.419713,-96.573132 43.419942,-96.57305 43.419981,-96.572922 43.420035,-96.572803 43.420099,-96.572771 43.420126,-96.572656 43.420242,-96.572541 43.420589,-96.572522 43.420659,-96.572486 43.421195,-96.572469 43.421301,-96.572446 43.42137,-96.572427 43.421403,-96.572413 43.421439,-96.572403 43.421471,-96.57237 43.421538,-96.572178 43.421787,-96.572037 43.421934,-96.571749 43.422188,-96.5716 43.422414,-96.571545 43.422514,-96.57126 43.42293,-96.571179 43.42306,-96.570891 43.423551,-96.570479 43.424583,-96.570339 43.42485,-96.570136 43.425253,-96.57 43.425633,-96.569839 43.426265,-96.569806 43.426478,-96.569766 43.426799,-96.569794 43.427228,-96.569859 43.427509,-96.56988 43.427578,-96.569894 43.427649,-96.569922 43.428005,-96.569935 43.42804,-96.569986 43.42814,-96.570232 43.42849,-96.570289 43.428547,-96.570512 43.42869,-96.570638 43.428745,-96.570991 43.428874,-96.571085 43.428896,-96.571277 43.428931,-96.571323 43.428944,-96.571662 43.429093,-96.571862 43.429198,-96.57205 43.429313,-96.572128 43.429356,-96.572355 43.429426,-96.57259 43.429481,-96.57281 43.429563,-96.573257 43.429784,-96.573454 43.429891,-96.57352 43.429944,-96.573558 43.429968,-96.573624 43.43002,-96.573828 43.430265,-96.573982 43.430489,-96.574023 43.43054,-96.574009 43.430599,-96.573993 43.430705,-96.574059 43.430798,-96.57411 43.430855,-96.574179 43.430945,-96.574207 43.430972,-96.574252 43.431033,-96.57433 43.43112,-96.574401 43.431165,-96.574477 43.431205,-96.574508 43.43123,-96.57455 43.43125,-96.574645 43.431263,-96.574695 43.431266,-96.574744 43.431264,-96.574956 43.431413,-96.57535 43.431624,-96.575426 43.431669,-96.575593 43.431745,-96.575774 43.431799,-96.576103 43.431874,-96.57615 43.431882,-96.576349 43.431878,-96.576445 43.431863,-96.577348 43.431678,-96.577594 43.431672,-96.577741 43.431689,-96.577827 43.431724,-96.577969 43.431756,-96.578164 43.431777,-96.578312 43.431785,-96.579205 43.431778,-96.579497 43.431814,-96.579594 43.43183,-96.580021 43.431921,-96.580166 43.431945,-96.581091 43.432061,-96.581449 43.432086,-96.581745 43.4321,-96.581844 43.4321,-96.582625 43.432014,-96.582918 43.432039,-96.583216 43.432065,-96.583265 43.432061,-96.583409 43.432036,-96.583456 43.432024,-96.583681 43.43195,-96.58403 43.43175,-96.584321 43.431615,-96.584367 43.431603,-96.58461 43.431575,-96.584659 43.431574,-96.584903 43.431595,-96.585107 43.431696,-96.58515 43.431713,-96.585308 43.431798,-96.585808 43.432086,-96.585886 43.432128,-96.585982 43.432146,-96.586031 43.43215,-96.586223 43.432178,-96.586272 43.432175,-96.586316 43.432158,-96.586407 43.432133,-96.586449 43.432113,-96.586486 43.432089,-96.586884 43.431726,-96.586992 43.431653,-96.587072 43.431611,-96.587256 43.43156,-96.587345 43.43153,-96.587392 43.431518,-96.587703 43.431464,-96.588047 43.431465,-96.588379 43.431531,-96.588424 43.431547,-96.588607 43.431598,-96.588691 43.431636,-96.588921 43.43177,-96.589544 43.432202,-96.589706 43.432314,-96.589827 43.432375,-96.589913 43.43241,-96.590052 43.432445,-96.590171 43.432469,-96.590194 43.432474,-96.590341 43.432487,-96.591325 43.432539,-96.591519 43.432567,-96.592217 43.432741,-96.592501 43.432813,-96.592765 43.43291,-96.592807 43.432929,-96.592874 43.432951,-96.593141 43.433045,-96.593247 43.433101,-96.593339 43.433151,-96.593444 43.433227,-96.593661 43.433422,-96.59391 43.433594,-96.594038 43.433702,-96.594141 43.433824,-96.594168 43.433872,-96.594208 43.433944,-96.594312 43.434249,-96.59438 43.434675,-96.594381 43.434852,-96.594375 43.434887,-96.594299 43.435056,-96.59426 43.435121,-96.594207 43.435195,-96.594224 43.435228,-96.59423 43.435264,-96.594213 43.43537,-96.594115 43.435532,-96.594068 43.435595,-96.594016 43.435655,-96.593948 43.435705,-96.593921 43.435734,-96.593823 43.435814,-96.593781 43.435833,-96.593706 43.435854,-96.593674 43.435915,-96.593596 43.436157,-96.593563 43.436405,-96.593574 43.436654,-96.59363 43.4369,-96.593661 43.436967,-96.593824 43.437187,-96.593999 43.437359,-96.594092 43.437421,-96.594359 43.437602,-96.594439 43.437643,-96.594482 43.43766,-96.594562 43.437702,-96.594687 43.437758,-96.594736 43.437765,-96.595378 43.43778,-96.595428 43.437784,-96.595566 43.437824,-96.596046 43.43801,-96.596086 43.438032,-96.596255 43.438162,-96.596284 43.438191,-96.596324 43.438256,-96.59634 43.438386,-96.596332 43.438457,-96.596306 43.438598,-96.596297 43.438704,-96.596299 43.43874,-96.596291 43.438811,-96.596292 43.438882,-96.596321 43.439131,-96.596367 43.439269,-96.596396 43.439337,-96.596404 43.439372,-96.596456 43.439473,-96.59653 43.439565,-96.596571 43.439586,-96.597303 43.439882,-96.597417 43.439951,-96.597477 43.440008,-96.597499 43.44004,-96.597545 43.440179,-96.597541 43.440214,-96.597522 43.440284,-96.597506 43.440318,-96.597489 43.440387,-96.59747 43.44042,-96.597414 43.440479,-96.597344 43.440528,-96.597085 43.440694,-96.596755 43.44096,-96.596716 43.440982,-96.596508 43.441079,-96.596475 43.441106,-96.596433 43.44117,-96.596363 43.441304,-96.596354 43.441339,-96.596331 43.44148,-96.596344 43.441874,-96.596367 43.442087,-96.596392 43.442156,-96.596416 43.442188,-96.596502 43.442275,-96.59654 43.442298,-96.596584 43.442313,-96.596632 43.442323,-96.59683 43.442326,-96.597027 43.44231,-96.597074 43.442301,-96.597119 43.442286,-96.597201 43.442246,-96.597329 43.442191,-96.597446 43.442127,-96.597713 43.44197,-96.597796 43.441932,-96.597841 43.441917,-96.597981 43.441883,-96.59803 43.441877,-96.598324 43.441879,-96.598422 43.44189,-96.598729 43.442002,-96.59881 43.442041,-96.598888 43.442084,-96.59893 43.442102,-96.598969 43.442124,-96.59904 43.442173,-96.599391 43.442471,-96.599443 43.442527,-96.599446 43.44253,-96.599571 43.442722,-96.599659 43.442888,-96.599671 43.442923,-96.599691 43.443029,-96.5997 43.443279,-96.599671 43.44349,-96.59966 43.443525,-96.599619 43.44359,-96.59957 43.443651,-96.59954 43.443718,-96.599518 43.443787,-96.599397 43.444094,-96.59935 43.444157,-96.599311 43.444179,-96.599089 43.444258,-96.599052 43.444281,-96.598943 43.444441,-96.598921 43.444582,-96.598905 43.444652,-96.598902 43.444794,-96.598906 43.44483,-96.598925 43.444899,-96.598995 43.445069,-96.599043 43.445205,-96.599072 43.445273,-96.599091 43.445306,-96.599166 43.445398,-96.599198 43.445425,-96.599235 43.445449,-96.599276 43.445469,-96.599494 43.44555,-96.599729 43.445633,-96.599809 43.445675,-96.599893 43.445712,-96.600011 43.445776,-96.600076 43.445828,-96.600355 43.446027,-96.600404 43.446088,-96.600422 43.446121,-96.600503 43.446322,-96.600521 43.44639,-96.600605 43.446591,-96.600629 43.446622,-96.600838 43.446814,-96.600888 43.446875,-96.600919 43.446902,-96.600959 43.446954,-96.601159 43.447189,-96.601246 43.447349,-96.601302 43.447443,-96.601328 43.447544,-96.601346 43.447645,-96.601344 43.447679,-96.601355 43.44778,-96.601367 43.447848,-96.601372 43.44795,-96.601366 43.447978,-96.601354 43.448054,-96.601352 43.448125,-96.60145 43.448206,-96.601493 43.44827,-96.601587 43.448353,-96.601623 43.448377,-96.602029 43.448578,-96.602105 43.448624,-96.602138 43.44865,-96.602194 43.448707,-96.602299 43.448826,-96.602342 43.448889,-96.602374 43.448955,-96.602547 43.449249,-96.602679 43.449663,-96.602717 43.449766,-96.60289 43.450168,-96.602942 43.450304,-96.603031 43.450581,-96.603056 43.450793,-96.603051 43.450828,-96.603034 43.450862,-96.602953 43.450951,-96.60291 43.450966,-96.60286 43.450967,-96.602664 43.450944,-96.602578 43.45091,-96.60254 43.450887,-96.602479 43.450833,-96.602452 43.450802,-96.602389 43.450748,-96.602152 43.450477,-96.601998 43.45034,-96.601718 43.450141,-96.601678 43.45012,-96.601635 43.450103,-96.601218 43.44999,-96.601073 43.449972,-96.600975 43.449976,-96.60083 43.449988,-96.600734 43.450002,-96.600651 43.45004,-96.600463 43.450154,-96.600422 43.450174,-96.600259 43.450309,-96.600017 43.450577,-96.599995 43.450609,-96.599889 43.450808,-96.599878 43.450843,-96.599847 43.45091,-96.599776 43.451116,-96.59967 43.451536,-96.599603 43.451706,-96.599587 43.451776,-96.599586 43.451811,-96.599644 43.452058,-96.599644 43.452094,-96.599619 43.452163,-96.599606 43.452233,-96.59973 43.452317,-96.59976 43.452346,-96.599781 43.452377,-96.599813 43.452445,-96.599833 43.452478,-96.599943 43.452547,-96.600062 43.452662,-96.600148 43.452788,-96.600186 43.452854,-96.600318 43.452959,-96.600343 43.45299,-96.600706 43.453372,-96.600719 43.453405,-96.600719 43.453476,-96.600728 43.453512,-96.600806 43.453642,-96.60087 43.453777,-96.600968 43.454125,-96.600983 43.454159,-96.601168 43.454448,-96.60123 43.454584,-96.601238 43.454619,-96.601267 43.454904,-96.601261 43.455046,-96.601246 43.455117,-96.601153 43.455467,-96.601139 43.455537,-96.601038 43.455777,-96.600949 43.455943,-96.600829 43.456099,-96.600718 43.456217,-96.600695 43.456248,-96.600592 43.45645,-96.60057 43.456482,-96.600407 43.456659,-96.600358 43.456719,-96.600148 43.45692,-96.600111 43.456943,-96.60007 43.456963,-96.599931 43.457002,-96.599896 43.457046,-96.599866 43.457075,-96.599832 43.457102,-96.599793 43.457122,-96.599697 43.457137,-96.599648 43.45714,-96.599602 43.457132,-96.599506 43.457131,-96.599409 43.457121,-96.599271 43.457084,-96.599093 43.457028,-96.598775 43.456938,-96.598688 43.456909,-96.59855 43.456872,-96.598403 43.456861,-96.598355 43.456862,-96.598223 43.456912,-96.59814 43.45695,-96.59811 43.456979,-96.59807 43.457045,-96.598044 43.457162,-96.598051 43.457196,-96.598076 43.457226,-96.598092 43.45726,-96.598099 43.457295,-96.598069 43.457472,-96.59805 43.457542,-96.598037 43.457576,-96.597897 43.457765,-96.597743 43.457903,-96.597589 43.458085,-96.597493 43.458207,-96.597433 43.458263,-96.597355 43.458352,-96.597268 43.458438,-96.597139 43.458545,-96.597015 43.458604,-96.596923 43.458629,-96.596742 43.458687,-96.596694 43.458695,-96.5964 43.458716,-96.596353 43.458705,-96.596172 43.45865,-96.596016 43.458564,-96.595974 43.458545,-96.595902 43.458548,-96.595805 43.458545,-96.595757 43.458533,-96.595721 43.458513,-96.595673 43.458506,-96.595596 43.458467,-96.595502 43.458457,-96.595406 43.45844,-96.595165 43.458429,-96.59507 43.458435,-96.594973 43.458434,-96.594924 43.458437,-96.594876 43.458429,-96.594831 43.458415,-96.594747 43.458377,-96.59463 43.458393,-96.594599 43.458427,-96.594555 43.458492,-96.594522 43.458517,-96.594314 43.458611,-96.594238 43.458656,-96.594129 43.458728,-96.594037 43.45881,-96.593999 43.458832,-96.593952 43.458844,-96.593903 43.458851,-96.593853 43.458852,-96.593669 43.459036,-96.59358 43.459163,-96.593601 43.459232,-96.593602 43.459268,-96.593476 43.45965,-96.593428 43.459969,-96.593429 43.459975,-96.59344 43.460183,-96.59348 43.46043,-96.59349 43.460465,-96.5936 43.460702,-96.593625 43.460732,-96.593691 43.460786,-96.593727 43.46081,-96.594069 43.460953,-96.594145 43.460999,-96.594317 43.461127,-96.594342 43.461158,-96.594402 43.461214,-96.594455 43.461274,-96.594687 43.461591,-96.594735 43.461692,-96.594743 43.461805,-96.594653 43.46223,-96.594572 43.46231,-96.594506 43.462363,-96.594351 43.462502,-96.594174 43.462626,-96.594133 43.462646,-96.593675 43.462783,-96.593333 43.462825,-96.59329 43.46284,-96.593251 43.462862,-96.593206 43.462878,-96.593158 43.462888,-96.59306 43.462892,-96.59262 43.462846,-96.592318 43.462802,-96.591501 43.462686,-96.591205 43.46267,-96.591106 43.462675,-96.59079 43.462778,-96.590551 43.462903,-96.590259 43.463235,-96.590203 43.463335,-96.590149 43.463472,-96.590136 43.463543,-96.590134 43.463614,-96.59007 43.463668,-96.590047 43.4637,-96.590035 43.463735,-96.590014 43.463876,-96.590009 43.464267,-96.590031 43.464408,-96.59003 43.464444,-96.590075 43.464545,-96.590095 43.464578,-96.590121 43.464608,-96.590186 43.464663,-96.590201 43.464693,-96.590205 43.464836,-96.590202 43.464907,-96.59006 43.465322,-96.590012 43.465534,-96.589989 43.465603,-96.589919 43.465773,-96.589872 43.465911,-96.589819 43.46601,-96.589705 43.466204,-96.589623 43.466293,-96.589503 43.466404,-96.589436 43.466456,-96.589362 43.466503,-96.589235 43.466557,-96.588836 43.466694,-96.588787 43.466699,-96.58859 43.466689,-96.588542 43.466682,-96.588463 43.466639,-96.588394 43.466587,-96.58837 43.466556,-96.588336 43.466489,-96.588309 43.466383,-96.588313 43.466312,-96.588366 43.466138,-96.588416 43.466038,-96.588745 43.465597,-96.588763 43.465564,-96.588768 43.465528,-96.588767 43.465458,-96.58878 43.465317,-96.588777 43.465246,-96.588769 43.465211,-96.58875 43.465179,-96.588702 43.465116,-96.588526 43.464946,-96.588423 43.464871,-96.588293 43.464821,-96.588194 43.46478,-96.587867 43.464646,-96.587778 43.464616,-96.587684 43.464594,-96.58764 43.464579,-96.587545 43.464559,-96.587205 43.464513,-96.587155 43.464513,-96.587058 43.464503,-96.587008 43.464502,-96.58691 43.464509,-96.586716 43.464538,-96.586577 43.464574,-96.586532 43.464589,-96.586256 43.46474,-96.586175 43.46478,-96.585954 43.464858,-96.585813 43.464891,-96.585765 43.464899,-96.585568 43.464895,-96.585387 43.464949,-96.585259 43.465002,-96.585215 43.465029,-96.585147 43.465081,-96.584969 43.465205,-96.584694 43.465356,-96.584592 43.465434,-96.584564 43.465463,-96.584368 43.465711,-96.584335 43.465737,-96.583858 43.46605,-96.583515 43.466254,-96.583308 43.466352,-96.583265 43.466368,-96.582976 43.466421,-96.582882 43.466442,-96.58267 43.466533,-96.58245 43.466677,-96.582419 43.466706,-96.582402 43.466739,-96.582401 43.466846,-96.582417 43.466953,-96.582427 43.466988,-96.582475 43.467051,-96.582624 43.467193,-96.583118 43.467566,-96.583377 43.467761,-96.583477 43.467841,-96.583879 43.468373,-96.583908 43.468402,-96.58398 43.468495,-96.584186 43.468818,-96.584265 43.468909,-96.584385 43.469022,-96.584373 43.469078,-96.584382 43.46915,-96.58456 43.469482,-96.584656 43.469718,-96.584691 43.46982,-96.58474 43.469882,-96.584852 43.469989,-96.584918 43.470052,-96.584996 43.470097,-96.585083 43.47013,-96.585247 43.470691,-96.585292 43.470974,-96.585302 43.47108,-96.5853 43.471115,-96.585306 43.471186,-96.585319 43.471257,-96.585312 43.4714,-96.585302 43.471435,-96.585285 43.471469,-96.585249 43.471512,-96.585011 43.471624,-96.584917 43.471698,-96.584804 43.471881,-96.584795 43.47191,-96.584794 43.471955,-96.584801 43.472122,-96.58473 43.472221,-96.584348 43.472794,-96.584161 43.473516,-96.583702 43.474302,-96.583685 43.474336,-96.583639 43.474399,-96.583626 43.474434,-96.583622 43.474469,-96.583634 43.474576,-96.583741 43.475106,-96.583783 43.475171,-96.583831 43.475233,-96.58385 43.475266,-96.583875 43.475297,-96.584126 43.475563,-96.584157 43.475591,-96.584409 43.475762,-96.584494 43.475799,-96.584779 43.475939,-96.585076 43.476068,-96.585394 43.476168,-96.585625 43.476302,-96.585771 43.476399,-96.585804 43.476426,-96.586535 43.477145,-96.58672 43.477357,-96.586743 43.477389,-96.586812 43.477523,-96.586864 43.477661,-96.586893 43.477802,-96.586892 43.477873,-96.586865 43.477978,-96.58684 43.478047,-96.58672 43.478258,-96.586709 43.478278,-96.586622 43.478406,-96.58657 43.478466,-96.586549 43.478499,-96.58652 43.478528,-96.586417 43.478604,-96.586306 43.478675,-96.586219 43.478709,-96.58566 43.478856,-96.585464 43.478965,-96.584948 43.479179,-96.58471 43.479307,-96.584492 43.479452,-96.584423 43.479503,-96.584118 43.479782,-96.584004 43.479851,-96.583613 43.480005,-96.58271 43.480197,-96.582647 43.480333,-96.582564 43.480422,-96.582504 43.480477,-96.582469 43.480503,-96.58243 43.480524,-96.582325 43.480598,-96.582198 43.480652,-96.582103 43.480673,-96.581807 43.480673,-96.581711 43.48069,-96.581661 43.480689,-96.581467 43.480817,-96.581246 43.481054,-96.581206 43.481118,-96.58118 43.481149,-96.581084 43.481462,-96.581082 43.481498,-96.581088 43.481569,-96.581198 43.481769,-96.581374 43.481942,-96.581399 43.481972,-96.581808 43.482624,-96.581919 43.482832,-96.582058 43.48309,-96.5822 43.483278,-96.58223 43.483306,-96.58238 43.483399,-96.582422 43.483418,-96.582667 43.483444,-96.582714 43.483431,-96.582889 43.483364,-96.58293 43.483343,-96.583113 43.483224,-96.583153 43.483203,-96.583296 43.483172,-96.583392 43.483157,-96.583689 43.483154,-96.583837 43.483163,-96.584076 43.483208,-96.584727 43.483373,-96.584822 43.483392,-96.585017 43.483414,-96.585311 43.483432,-96.585361 43.48343,-96.585903 43.483435,-96.586002 43.483433,-96.586144 43.483463,-96.586275 43.483514,-96.586358 43.483551,-96.586404 43.483564,-96.586446 43.483584,-96.586599 43.483675,-96.586721 43.483781,-96.586787 43.483833,-96.58683 43.483898,-96.586931 43.484137,-96.587002 43.48427,-96.587166 43.484448,-96.587225 43.484506,-96.587262 43.484572,-96.587293 43.484677,-96.587288 43.484748,-96.587261 43.484853,-96.587213 43.484915,-96.587124 43.485001,-96.587055 43.485052,-96.586977 43.485096,-96.586941 43.485121,-96.586862 43.485164,-96.586409 43.485383,-96.586371 43.485406,-96.58631 43.485462,-96.58625 43.48556,-96.586191 43.485807,-96.586203 43.486021,-96.586242 43.486161,-96.586258 43.486195,-96.586341 43.486325,-96.58651 43.486544,-96.586576 43.486657,-96.586838 43.487041,-96.586995 43.487262,-96.587013 43.487296,-96.587025 43.487367,-96.587002 43.487579,-96.586957 43.487643,-96.586924 43.48767,-96.586814 43.487742,-96.586728 43.487776,-96.586536 43.487811,-96.586438 43.487815,-96.5859 43.487856,-96.585803 43.48787,-96.585565 43.487915,-96.585526 43.487927,-96.58552 43.48793,-96.585436 43.487967,-96.585125 43.488141,-96.58505 43.488187,-96.584958 43.488271,-96.584644 43.488715,-96.584615 43.488783,-96.584593 43.488852,-96.58455 43.489028,-96.584551 43.489099,-96.584589 43.489202,-96.584691 43.489364,-96.58474 43.489426,-96.584858 43.489689,-96.585443 43.490299,-96.585831 43.490503,-96.585954 43.4906,-96.586077 43.490697,-96.586232 43.490819,-96.586435 43.491022,-96.586741 43.491388,-96.586771 43.491417,-96.586915 43.491514,-96.587078 43.491595,-96.587169 43.491622,-96.587601 43.491699,-96.587699 43.491706,-96.587749 43.491705,-96.587995 43.491686,-96.588044 43.491678,-96.588326 43.491611,-96.588573 43.491618,-96.588816 43.491653,-96.589149 43.491723,-96.58959 43.491786,-96.589684 43.4918,-96.589965 43.491864,-96.590008 43.491881,-96.590043 43.491906,-96.590121 43.491949,-96.590156 43.491975,-96.590184 43.492005,-96.590204 43.492037,-96.590235 43.492105,-96.590242 43.492141,-96.59024 43.492176,-96.590208 43.492244,-96.590184 43.492275,-96.590027 43.492413,-96.589991 43.492438,-96.589911 43.492479,-96.589839 43.492529,-96.589815 43.492559,-96.589827 43.492666,-96.589825 43.492702,-96.589751 43.492946,-96.58977 43.49316,-96.589832 43.493403,-96.58983 43.493439,-96.589816 43.493473,-96.5898 43.493543,-96.589798 43.493579,-96.589784 43.493649,-96.5899 43.493806,-96.589954 43.493866,-96.590211 43.494123,-96.590459 43.494296,-96.590621 43.494375,-96.590699 43.494418,-96.590783 43.494453,-96.590877 43.494477,-96.59102 43.494503,-96.591118 43.494505,-96.59126 43.494477,-96.591536 43.494399,-96.592044 43.494264,-96.592378 43.494209,-96.592405 43.494179,-96.592438 43.494152,-96.592478 43.494131,-96.592608 43.494079,-96.592648 43.494059,-96.592734 43.494026,-96.592782 43.494016,-96.592852 43.494009,-96.592919 43.493956,-96.593225 43.493776,-96.593425 43.493671,-96.593711 43.49353,-96.59379 43.493486,-96.593982 43.493278,-96.594049 43.493225,-96.594086 43.493202,-96.594169 43.493162,-96.594213 43.493147,-96.594502 43.493096,-96.594551 43.493095,-96.594797 43.493114,-96.595034 43.493164,-96.595126 43.49319,-96.595521 43.493337,-96.596274 43.493683,-96.596507 43.493816,-96.59663 43.493895,-96.596727 43.49391,-96.596775 43.493921,-96.596819 43.493936,-96.597112 43.494069,-96.597284 43.494139,-96.59733 43.49417,-96.597375 43.494223,-96.597678 43.494344,-96.597723 43.494359,-96.597764 43.49438,-96.597987 43.494515,-96.59803 43.494541,-96.599013 43.495348,-96.59909 43.495439,-96.599206 43.495597,-96.599304 43.495721,-96.599348 43.495785,-96.599375 43.495815,-96.599454 43.495985,-96.599457 43.496068,-96.599452 43.496104,-96.599327 43.496486,-96.599133 43.496775,-96.599121 43.49681,-96.599088 43.497023,-96.599088 43.497273,-96.599011 43.4977,-96.598995 43.497937,-96.59899 43.498019,-96.59899 43.49809,-96.598962 43.498195,-96.598881 43.498436,-96.598874 43.498508,-96.598904 43.498632,-96.598961 43.498864,-96.599012 43.499073,-96.59902 43.499106,-96.59903 43.499356,-96.599036 43.499391,-96.599099 43.499564,-96.599105 43.499707,-96.599116 43.499923,-96.599117 43.499955,-96.599122 43.500054,-96.599124 43.500087,-96.599125 43.500118,-96.599128 43.500171,-96.599137 43.500213,-96.599145 43.500245,-96.59915 43.500266,-96.599165 43.500331,-96.599171 43.500353,-96.599175 43.500373,-96.599186 43.500418,-96.599188 43.500435,-96.599191 43.500456,-96.599137 43.500456,-96.599059 43.500456,-96.598978 43.500456,-96.598926 43.500457,-96.598716 43.500457,-96.598089 43.500459,-96.59788 43.50046,-96.597455 43.500461,-96.596183 43.500464,-96.595759 43.500466,-96.595484 43.500468,-96.59466 43.500476,-96.594386 43.50048,-96.594136 43.500501,-96.593978 43.500515,-96.593723 43.50051,-96.593385 43.500485,-96.593136 43.500467,-96.592765 43.500464,-96.591652 43.500456,-96.591282 43.500454,-96.586367 43.500446,-96.581159 43.50044,-96.577873 43.500444,-96.573946 43.500447,-96.569957 43.500441,-96.566325 43.500437,-96.565917 43.500436,-96.560373 43.500423,-96.555266 43.500422,-96.554527 43.500422,-96.55231 43.500422,-96.551572 43.500422,-96.550547 43.50042,-96.547472 43.500414,-96.546448 43.500413,-96.546432 43.500413,-96.546384 43.500413,-96.546368 43.500413,-96.544262 43.500408,-96.542993 43.500406,-96.539026 43.500423,-96.537948 43.500421,-96.535843 43.50042,-96.535008 43.500419,-96.532701 43.500418,-96.532504 43.500418,-96.53167 43.500421,-96.52648 43.500434,-96.525311 43.500436,-96.522852 43.500412,-96.521272 43.500397,-96.518097 43.500407,-96.513824 43.500395,-96.513087 43.500393,-96.511725 43.500395,-96.509441 43.500397,-96.508257 43.500407,-96.50727 43.500396,-96.504239 43.500403,-96.504007 43.500403,-96.497753 43.500389,-96.496219 43.500385,-96.491748 43.500389,-96.490724 43.500389,-96.487652 43.500391,-96.486629 43.500392,-96.486383 43.500392,-96.485648 43.500392,-96.485403 43.500392,-96.484077 43.500392,-96.480102 43.500394,-96.478777 43.500395,-96.478358 43.500395,-96.473865 43.500393,-96.47187 43.500393,-96.471391 43.500393,-96.471223 43.500393,-96.470722 43.500393,-96.470555 43.500393,-96.466737 43.500393,-96.46541 43.500393,-96.462449 43.500393,-96.454174 43.500427,-96.454074 43.500427,-96.453975 43.500426,-96.45326 43.50039,-96.453255 43.50039,-96.446758 43.500411,-96.445288 43.500403,-96.440878 43.500379,-96.439408 43.500372,-96.437929 43.50036,-96.437617 43.500359,-96.433493 43.500352,-96.43203 43.50035,-96.432015 43.500351,-96.431584 43.500352,-96.43029 43.500356,-96.42986 43.500359,-96.427876 43.500357,-96.427351 43.500357,-96.423819 43.500372,-96.421925 43.500369,-96.419943 43.500367,-96.418366 43.50036,-96.415121 43.500349,-96.413643 43.500349,-96.41207 43.50035,-96.41207 43.500339,-96.411597 43.500338,-96.410176 43.500338,-96.409704 43.500338,-96.407555 43.500337,-96.407354 43.500336,-96.400304 43.500318,-96.400218 43.500318,-96.39799 43.50032,-96.397953 43.50032,-96.396786 43.500321,-96.393285 43.500325,-96.39212 43.50033,-96.39212 43.500323,-96.391716 43.500322,-96.390507 43.500324,-96.390105 43.500325,-96.388165 43.50033,-96.387917 43.500332,-96.384336 43.500329,-96.382347 43.500333,-96.380409 43.500336,-96.378768 43.500331,-96.373849 43.500322,-96.372211 43.500319,-96.37221 43.50033,-96.371848 43.500329,-96.370765 43.500329,-96.370407 43.500331,-96.37035 43.500327,-96.370182 43.500318,-96.370127 43.500316,-96.368888 43.500309,-96.368738 43.500307,-96.364574 43.500299,-96.363187 43.500297,-96.362881 43.500298,-96.361969 43.500304,-96.361901 43.500305,-96.361665 43.500305,-96.361399 43.500303,-96.360603 43.500298,-96.360338 43.500297,-96.35973 43.500293,-96.35791 43.500284,-96.357304 43.500282,-96.35708 43.500283,-96.356415 43.50029,-96.356196 43.500295,-96.355123 43.500256,-96.352764 43.500178,-96.351905 43.500166,-96.351126 43.500158,-96.350845 43.500238,-96.348675 43.500256,-96.346331 43.500277,-96.342168 43.500334,-96.340001 43.500364,-96.33974 43.500364,-96.338958 43.500367,-96.338698 43.500369,-96.33737 43.500378,-96.333389 43.500405,-96.332062 43.500415,-96.332021 43.500414,-96.331898 43.500411,-96.331858 43.500411,-96.331418 43.500388,-96.330099 43.500322,-96.32966 43.5003,-96.326202 43.500285,-96.325227 43.500282,-96.315831 43.500297,-96.314966 43.500298,-96.312373 43.5003,-96.31234 43.5003,-96.310215 43.500307,-96.308656 43.500313,-96.303742 43.50031,-96.301586 43.50031,-96.300798 43.500308,-96.300236 43.500307,-96.298444 43.500303,-96.29766 43.500303,-96.296865 43.500298,-96.2965 43.500296,-96.295477 43.500296,-96.294483 43.500296,-96.293689 43.500297,-96.29343 43.500297,-96.293032 43.500299,-96.292653 43.5003,-96.292395 43.5003,-96.29239 43.5003,-96.290669 43.500295,-96.285497 43.50028,-96.283774 43.500277,-96.282206 43.500274,-96.277896 43.500269,-96.277505 43.500269,-96.275939 43.500271,-96.275379 43.500271,-96.273702 43.500272,-96.273566 43.500273,-96.273143 43.500273,-96.273105 43.500273,-96.272991 43.500273,-96.272954 43.500273,-96.272817 43.500273,-96.272408 43.500273,-96.272272 43.500273,-96.271295 43.500273,-96.270896 43.500274,-96.268366 43.500268,-96.26739 43.500267,-96.264678 43.500261,-96.264301 43.500261,-96.256598 43.500271,-96.256543 43.50027,-96.253832 43.500268,-96.253573 43.500265,-96.252799 43.500261,-96.25255 43.50026,-96.25254 43.500259,-96.250556 43.500252,-96.247406 43.500244,-96.246905 43.500251,-96.24518 43.50025,-96.244608 43.500252,-96.243655 43.500258,-96.242939 43.500241,-96.242627 43.500243,-96.24252 43.500245,-96.242204 43.500251,-96.242099 43.500255,-96.241792 43.500255,-96.24026 43.500252,-96.239154 43.500251,-96.2377 43.500256,-96.236759 43.500245,-96.236326 43.500253,-96.235921 43.500265,-96.234744 43.500259,-96.232906 43.50025,-96.232835 43.500249,-96.232783 43.50025,-96.232629 43.50025,-96.23256 43.50025,-96.23254 43.50025,-96.23208 43.500247,-96.230991 43.500256,-96.230326 43.500257,-96.229199 43.500258,-96.228044 43.500265,-96.226331 43.500258,-96.225576 43.500266,-96.224387 43.500273,-96.223632 43.500265,-96.223028 43.500258,-96.222076 43.500257,-96.221402 43.500261,-96.221396 43.500261,-96.220765 43.500264,-96.219924 43.500264,-96.219313 43.500266,-96.21806 43.500273,-96.216118 43.500275,-96.215491 43.500284,-96.215354 43.500287,-96.214014 43.50029,-96.213688 43.500284,-96.21272 43.50027,-96.212714 43.50027,-96.212389 43.500274,-96.211691 43.500283,-96.211217 43.500289,-96.210484 43.500303,-96.210253 43.500311,-96.2096 43.500341,-96.2094 43.50035,-96.208903 43.500365,-96.208558 43.500349,-96.207208 43.500333,-96.207175 43.500333,-96.202572 43.500315,-96.202121 43.500309,-96.200426 43.500289,-96.200162 43.500287,-96.199851 43.500285,-96.199563 43.500277,-96.199374 43.500275,-96.199275 43.500274,-96.199112 43.500256,-96.199043 43.500263,-96.198983 43.500267,-96.19875 43.500287,-96.198597 43.500289,-96.198469 43.500292,-96.198008 43.500299,-96.197913 43.500298,-96.196245 43.500289,-96.195689 43.500287,-96.195083 43.500279,-96.193324 43.500263,-96.193265 43.500262,-96.19269 43.50026,-96.192659 43.500261,-96.191021 43.500255,-96.190745 43.500254,-96.186111 43.500227,-96.184703 43.500219,-96.18459 43.500218,-96.184479 43.50022,-96.184365 43.500219,-96.18425 43.500219,-96.183695 43.50022,-96.182762 43.50022,-96.177617 43.500224,-96.177511 43.500224,-96.175903 43.500233,-96.175537 43.500228,-96.174439 43.500216,-96.174366 43.500215,-96.17422 43.500213,-96.174074 43.500211,-96.174003 43.50021,-96.17393 43.500209,-96.173785 43.500209,-96.173753 43.500209,-96.172872 43.500209,-96.17279 43.500209,-96.172469 43.500209,-96.17241 43.50021,-96.172344 43.500208,-96.171975 43.500201,-96.171853 43.5002,-96.171205 43.500202,-96.16868 43.5002,-96.164214 43.500199,-96.159165 43.500213,-96.155994 43.500222,-96.155684 43.500214,-96.154757 43.500195,-96.15445 43.50019,-96.154181 43.500189,-96.153377 43.500191,-96.15311 43.500194,-96.15293 43.50019,-96.152758 43.500189,-96.151706 43.50019,-96.151355 43.500191,-96.151342 43.50019,-96.151146 43.50019,-96.15052 43.500189,-96.150312 43.50019,-96.150287 43.50019,-96.148762 43.500187,-96.146913 43.500188,-96.142801 43.500191,-96.139072 43.500202,-96.136719 43.500191,-96.133323 43.50018,-96.133215 43.500179,-96.13317 43.500178,-96.132715 43.500179,-96.132564 43.50018,-96.13253 43.50018,-96.131825 43.500174,-96.13083 43.500171,-96.125628 43.500153,-96.123895 43.50015,-96.123159 43.500148,-96.120957 43.500145,-96.120224 43.500146,-96.120053 43.500153,-96.119541 43.500176,-96.119372 43.500184,-96.11878 43.500183,-96.118125 43.500183,-96.117004 43.500188,-96.116413 43.500191,-96.114193 43.500195,-96.112014 43.5002,-96.109246 43.500172,-96.107538 43.500166,-96.10532 43.50016,-96.10375 43.500163,-96.103495 43.500164,-96.09802 43.500184,-96.096197 43.500191,-96.095883 43.500186,-96.094944 43.500174,-96.094631 43.500171,-96.09462 43.50017,-96.094519 43.500168,-96.094183 43.500165,-96.094071 43.500165,-96.09335 43.50016,-96.092369 43.500155,-96.090864 43.500158,-96.085279 43.500169,-96.082795 43.500185,-96.081246 43.500185,-96.07804 43.500189,-96.077058 43.500183,-96.074115 43.500166,-96.073134 43.500161,-96.07312 43.50016,-96.070084 43.500155,-96.060936 43.500143,-96.057888 43.50014,-96.057436 43.500144,-96.056082 43.500158,-96.055632 43.500164,-96.055593 43.500163,-96.055476 43.500163,-96.055437 43.500163,-96.055027 43.500163,-96.053162 43.500155,-96.053162 43.500121,-96.050687 43.500125,-96.047966 43.500121,-96.046766 43.500118,-96.043445 43.500121,-96.041065 43.500114,-96.038215 43.500115,-96.038215 43.500116,-96.038181 43.500117,-96.036566 43.500106,-96.035696 43.5001,-96.033215 43.500102,-96.032078 43.500104,-96.028702 43.500108,-96.025692 43.500102,-96.02282 43.500108,-96.022223 43.500105,-96.020357 43.500097,-96.018242 43.500098,-96.016207 43.500101,-96.000333 43.500124,-96.000002 43.500126,-95.999002 43.500114,-95.998239 43.500113,-95.997146 43.500111,-95.99603 43.50011,-95.993351 43.500123,-95.993077 43.500124,-95.990095 43.500093,-95.981109 43.500068,-95.979671 43.500068,-95.97954 43.500067,-95.978286 43.500067,-95.978103 43.500067,-95.974901 43.500069,-95.973402 43.500065,-95.97247 43.500063,-95.968367 43.500069,-95.966619 43.500073,-95.964372 43.500077,-95.961302 43.500069,-95.960608 43.500069,-95.960608 43.50007,-95.960604 43.50007,-95.960599 43.500071,-95.958364 43.500077,-95.955872 43.500067,-95.953809 43.500074,-95.95344 43.500102,-95.952329 43.500096,-95.950935 43.500088,-95.950625 43.500086,-95.948335 43.500094,-95.947238 43.50009,-95.945792 43.500085,-95.943752 43.500086,-95.943301 43.500086,-95.94085 43.500106,-95.940504 43.500104,-95.940478 43.500104,-95.938236 43.500091,-95.937497 43.500093,-95.935959 43.50008,-95.935869 43.500079,-95.933729 43.500074,-95.933494 43.500074,-95.93225 43.500055,-95.925605 43.500036,-95.922595 43.500037,-95.920478 43.500042,-95.920478 43.500043,-95.920476 43.500043,-95.920458 43.500044,-95.918301 43.500051,-95.915353 43.500051,-95.912189 43.500039,-95.911659 43.50004,-95.909097 43.500042,-95.9073 43.50004,-95.903591 43.500035,-95.901052 43.500033,-95.90063 43.500033,-95.900622 43.500032,-95.900618 43.500032,-95.898728 43.500032,-95.896558 43.500043,-95.8936 43.500057,-95.88966 43.500049,-95.88855 43.500053,-95.885771 43.500048,-95.882707 43.500056,-95.880867 43.500071,-95.880867 43.500072,-95.880806 43.500073,-95.880136 43.500079,-95.87945 43.50008,-95.878544 43.50008,-95.878544 43.500081,-95.878493 43.500082,-95.878327 43.500082,-95.876243 43.500117,-95.873482 43.500092,-95.869043 43.50009,-95.866462 43.500059,-95.864835 43.500065,-95.863244 43.500043,-95.860947 43.500036,-95.859793 43.50003,-95.858315 43.500027,-95.858266 43.500027,-95.857028 43.500025,-95.855494 43.500017,-95.850959 43.500045,-95.849494 43.500048,-95.849366 43.500048,-95.849318 43.500048,-95.849006 43.500049,-95.844009 43.500024,-95.843998 43.500024,-95.843859 43.500023,-95.843799 43.500023,-95.843636 43.500022,-95.843562 43.500021,-95.843529 43.500021,-95.843495 43.500021,-95.843459 43.500021,-95.842941 43.500017,-95.841098 43.500018,-95.841089 43.500018,-95.839039 43.500023,-95.837089 43.500014,-95.833847 43.500009,-95.833813 43.500009,-95.831704 43.499997,-95.831694 43.499997,-95.831425 43.499996,-95.82977 43.500007,-95.827653 43.499996,-95.824663 43.499975,-95.821146 43.499992,-95.821129 43.499992,-95.820329 43.499994,-95.820294 43.499994,-95.817867 43.500001,-95.816114 43.499997,-95.815911 43.499996,-95.815613 43.499995,-95.815602 43.499995,-95.81543 43.499995,-95.812489 43.500002,-95.802763 43.499975,-95.802742 43.499975,-95.802415 43.499974,-95.802226 43.499963,-95.802199 43.499961,-95.801972 43.499947,-95.80172 43.499904,-95.801228 43.499807,-95.801174 43.499796,-95.801072 43.499747,-95.800982 43.499703,-95.79751 43.499965,-95.797176 43.500012,-95.796847 43.500001,-95.794541 43.49999,-95.793181 43.499983,-95.793051 43.499971,-95.792742 43.499968,-95.790672 43.499946,-95.788061 43.499942,-95.78772 43.499941,-95.784525 43.499939,-95.781374 43.499945,-95.781358 43.499945,-95.779861 43.499941,-95.779718 43.499941,-95.777205 43.499935,-95.77399 43.499938,-95.773976 43.499938,-95.772934 43.499932,-95.772511 43.499931,-95.772352 43.499931,-95.768962 43.499924,-95.768544 43.499925,-95.766446 43.49993,-95.766278 43.49993,-95.76574 43.499931,-95.765499 43.499932,-95.764548 43.499929,-95.764271 43.499928,-95.761325 43.499918,-95.75807 43.499909,-95.756845 43.499902,-95.756658 43.499901,-95.756649 43.499901,-95.756622 43.499901,-95.754738 43.499891,-95.754034 43.499917,-95.754007 43.499918,-95.752708 43.499923,-95.752699 43.499923,-95.752683 43.499923,-95.752638 43.499923,-95.7519 43.499925,-95.750421 43.499925,-95.750373 43.499925,-95.749751 43.499925,-95.749696 43.499925,-95.746444 43.499924,-95.745993 43.49992,-95.745985 43.49992,-95.745977 43.49992,-95.74597 43.49992,-95.74596 43.49992,-95.745946 43.49992,-95.745925 43.49992,-95.745894 43.49992,-95.745845 43.49992,-95.7432 43.499905,-95.74241 43.499907,-95.742386 43.499907,-95.741448 43.49991,-95.741413 43.49991,-95.740838 43.499912,-95.740809 43.499912,-95.739986 43.499915,-95.736292 43.499912,-95.73404 43.49991,-95.732111 43.499918,-95.730162 43.499905,-95.726704 43.499923,-95.726697 43.499923,-95.726683 43.499923,-95.726668 43.499923,-95.726643 43.499923,-95.726402 43.499924,-95.724742 43.499923,-95.724128 43.499922,-95.724116 43.499922,-95.724095 43.499922,-95.724032 43.499922,-95.722669 43.499917,-95.722655 43.499917,-95.718691 43.4999,-95.716281 43.4999,-95.715947 43.4999,-95.714257 43.4999,-95.711143 43.4999,-95.707677 43.49991,-95.707642 43.49991,-95.70458 43.499908,-95.701286 43.499901,-95.698005 43.499899,-95.695787 43.499901,-95.695544 43.499901,-95.695154 43.499892,-95.694249 43.499881,-95.693884 43.499887,-95.693864 43.499888,-95.692673 43.499891,-95.692613 43.499891,-95.689365 43.499881,-95.689309 43.499881,-95.6875 43.499898,-95.684432 43.499892,-95.684344 43.499892,-95.684078 43.499894,-95.684051 43.499894,-95.683605 43.499896,-95.682959 43.499899,-95.682937 43.499899,-95.682505 43.499901,-95.682135 43.499903,-95.682106 43.499903,-95.68167 43.499905,-95.681261 43.499907,-95.677127 43.499896,-95.67323 43.499901,-95.672293 43.499896,-95.672272 43.499896,-95.671346 43.499891,-95.671086 43.49989,-95.669613 43.499883,-95.668164 43.499885,-95.666191 43.499888,-95.663105 43.499884,-95.663098 43.499884,-95.660867 43.499884,-95.660848 43.499884,-95.658205 43.499886,-95.652297 43.499904,-95.649093 43.499891,-95.649038 43.499891,-95.648266 43.499887,-95.643177 43.499885,-95.643156 43.499885,-95.640352 43.499885,-95.636566 43.499884,-95.631728 43.499891,-95.631714 43.499891,-95.631159 43.499892,-95.630566 43.49989,-95.630406 43.499889,-95.628489 43.499883,-95.628482 43.499883,-95.626879 43.499888,-95.626572 43.499889,-95.626552 43.499889,-95.625003 43.499893,-95.623272 43.499905,-95.623257 43.499905,-95.621022 43.499907,-95.6206 43.499903,-95.620584 43.499903,-95.619454 43.499894,-95.618856 43.499889,-95.616768 43.499886,-95.61606 43.499888,-95.614241 43.499895,-95.614226 43.499895,-95.609861 43.499903,-95.609624 43.499903,-95.608619 43.499905,-95.606638 43.499902,-95.604395 43.499914,-95.604366 43.499914,-95.602512 43.499915,-95.60002 43.499901,-95.597618 43.49991,-95.594277 43.499902,-95.594244 43.499902,-95.592499 43.499905,-95.590278 43.499899,-95.588487 43.49991,-95.584545 43.499906,-95.58453 43.499906,-95.57987 43.499908,-95.577327 43.499904,-95.574428 43.499911,-95.574285 43.499911,-95.574273 43.499911,-95.574135 43.499912,-95.570443 43.499927,-95.569395 43.499922,-95.56915 43.499921,-95.569004 43.49992,-95.567655 43.499914,-95.565163 43.499934,-95.565127 43.499934,-95.565013 43.499935,-95.564872 43.499927,-95.564786 43.499926,-95.564744 43.499926,-95.564473 43.499923,-95.562494 43.499941,-95.559951 43.499926,-95.552454 43.499951,-95.549808 43.499925,-95.547574 43.499937,-95.544538 43.499927,-95.544504 43.499927,-95.5354 43.499947,-95.535187 43.499947,-95.524921 43.49997,-95.524788 43.499965,-95.52478 43.499965,-95.524764 43.499961,-95.524755 43.499959,-95.524676 43.499936,-95.524608 43.499917,-95.524576 43.499908,-95.5245 43.499856,-95.521726 43.499992,-95.52067 43.499986,-95.518115 43.499993,-95.517329 43.499986,-95.516169 43.499931,-95.515856 43.499916,-95.514664 43.499867,-95.514656 43.499867,-95.504899 43.499964,-95.502536 43.499967,-95.500283 43.499964,-95.500145 43.499967,-95.499985 43.499971,-95.499306 43.499986,-95.498536 43.500005,-95.498425 43.500008,-95.49835 43.50001,-95.493053 43.500157,-95.492723 43.500164,-95.492711 43.500164,-95.489028 43.500049,-95.488837 43.500043,-95.488773 43.500041,-95.488749 43.50004,-95.488731 43.50004,-95.487389 43.499998,-95.487376 43.499998,-95.486793 43.499995,-95.486552 43.499994,-95.486318 43.499995,-95.484345 43.500001,-95.484295 43.500001,-95.482895 43.5,-95.480367 43.500026,-95.478276 43.500024,-95.477448 43.500301,-95.476738 43.500304,-95.476218 43.500307,-95.475596 43.50031,-95.475421 43.500314,-95.475062 43.500338,-95.474805 43.500331,-95.474776 43.500331,-95.460478 43.500468,-95.460448 43.500469,-95.457975 43.500509,-95.457491 43.500517,-95.456563 43.500532,-95.454706 43.500563,-95.454704 43.500563,-95.454656 43.500564,-95.454608 43.500565,-95.454614 43.500647,-95.454433 43.500646,-95.453048 43.500626,-95.448895 43.500566,-95.447511 43.500546,-95.444858 43.500519,-95.436902 43.500441,-95.43425 43.500415,-95.434244 43.50037,-95.434238 43.500315,-95.434204 43.500257,-95.434193 43.500248,-95.434159 43.50022,-95.434108 43.500177,-95.434025 43.500135,-95.433945 43.500121,-95.433839 43.500113,-95.4338 43.500113,-95.432644 43.500118,-95.432421 43.50012,-95.432259 43.500119,-95.431305 43.500115,-95.428446 43.500103,-95.427494 43.500099,-95.426956 43.500101,-95.425345 43.500111,-95.424809 43.500114,-95.423165 43.500123,-95.418233 43.50015,-95.416589 43.500159,-95.416178 43.50016,-95.414945 43.500167,-95.414535 43.50017,-95.413701 43.50018,-95.41343 43.50018,-95.410115 43.500188,-95.409011 43.500191,-95.406691 43.500195,-95.399734 43.500211,-95.397415 43.500217,-95.397325 43.500217,-95.397059 43.500217,-95.39697 43.500218,-95.396493 43.500218,-95.395064 43.500221,-95.394588 43.500223,-95.393405 43.500224,-95.389859 43.500229,-95.388771 43.500231,-95.388677 43.500231,-95.387787 43.500226,-95.382621 43.500249,-95.376466 43.500248,-95.37539 43.500246,-95.375248 43.500246,-95.374823 43.50025,-95.374682 43.500251,-95.374651 43.500252,-95.374488 43.500251,-95.373911 43.500254,-95.373719 43.500255,-95.373713 43.500255,-95.373326 43.500253,-95.372814 43.500252,-95.370099 43.500246,-95.369195 43.500246,-95.369116 43.500246,-95.368881 43.500246,-95.368803 43.500246,-95.367578 43.500248,-95.364808 43.500264,-95.360275 43.500292,-95.352823 43.500317,-95.351873 43.500321,-95.348829 43.500326,-95.348068 43.500331,-95.345788 43.500349,-95.345028 43.500355,-95.345 43.500356,-95.344347 43.500355,-95.343069 43.500359,-95.337194 43.50038,-95.335315 43.500387,-95.335236 43.500387,-95.33399 43.500384,-95.333456 43.500383,-95.330252 43.500391,-95.329007 43.500395,-95.328426 43.500405,-95.328179 43.500406,-95.325695 43.500422,-95.324868 43.500428,-95.324792 43.500428,-95.323859 43.500421,-95.323218 43.500417,-95.320832 43.500418,-95.319824 43.500419,-95.319672 43.500419,-95.319216 43.500423,-95.319065 43.500424,-95.317741 43.500431,-95.317076 43.500431,-95.311111 43.500438,-95.310972 43.500439,-95.309123 43.500446,-95.308451 43.500456,-95.306442 43.500489,-95.306202 43.500493,-95.305772 43.500465,-95.30559 43.500462,-95.305053 43.500456,-95.304874 43.500455,-95.304868 43.500412,-95.299811 43.500437,-95.284638 43.500511,-95.279583 43.500538,-95.278623 43.500539,-95.275751 43.500548,-95.274794 43.500551,-95.274749 43.500551,-95.273629 43.500549,-95.270133 43.500544,-95.270077 43.500544,-95.268968 43.500548,-95.266128 43.50056,-95.263343 43.500573,-95.25761 43.500579,-95.254771 43.500582,-95.254371 43.500582,-95.254022 43.500584,-95.251776 43.500598,-95.251028 43.500603,-95.251011 43.500597,-95.250963 43.500579,-95.250947 43.500573,-95.250927 43.500565,-95.250899 43.500555,-95.250875 43.500533,-95.25086 43.50052,-95.250365 43.500661,-95.24967 43.500728,-95.24605 43.501079,-95.244844 43.501196,-95.242824 43.50116,-95.238847 43.501092,-95.236769 43.501073,-95.234861 43.501057,-95.234751 43.501056,-95.232277 43.501034,-95.224856 43.50097,-95.222383 43.500949,-95.220752 43.500963,-95.215861 43.501007,-95.21493 43.501016,-95.214233 43.500965,-95.213641 43.500934,-95.21187 43.500844,-95.21128 43.500815,-95.209996 43.500818,-95.208155 43.500826,-95.206147 43.500826,-95.205022 43.500828,-95.204943 43.500828,-95.204865 43.500828,-95.204783 43.500829,-95.204702 43.500829,-95.204343 43.500829,-95.203859 43.500831,-95.200845 43.500849,-95.199841 43.500857,-95.198827 43.500859,-95.196561 43.500865,-95.195791 43.500865,-95.194779 43.500867,-95.194738 43.500867,-95.192461 43.500876,-95.185509 43.500905,-95.183193 43.500916,-95.182537 43.500914,-95.180572 43.50091,-95.179917 43.500909,-95.179306 43.50092,-95.179164 43.50092,-95.177231 43.500931,-95.176996 43.500931,-95.176908 43.500931,-95.176157 43.500933,-95.175833 43.500937,-95.175165 43.500944,-95.174863 43.500949,-95.17454 43.500955,-95.174229 43.500961,-95.173214 43.500964,-95.171657 43.500971,-95.169233 43.501005,-95.168429 43.501017,-95.167907 43.501019,-95.167806 43.501019,-95.167595 43.501021,-95.167506 43.501014,-95.167417 43.501,-95.167408 43.500998,-95.167085 43.500951,-95.166119 43.500813,-95.165798 43.500768,-95.163445 43.500698,-95.161364 43.500637,-95.15693 43.500507,-95.156391 43.500491,-95.154936 43.500448,-95.15404 43.500458,-95.153488 43.500463,-95.151834 43.50048,-95.151283 43.500486,-95.150328 43.500495,-95.147465 43.500524,-95.146511 43.500535,-95.146492 43.500535,-95.144569 43.500554,-95.141331 43.500588,-95.138746 43.500597,-95.136805 43.500604,-95.136799 43.500604,-95.136225 43.500605,-95.134484 43.500611,-95.133906 43.500614,-95.132485 43.500619,-95.128225 43.500636,-95.126806 43.500643,-95.126288 43.500638,-95.125271 43.500631,-95.124751 43.500748,-95.124249 43.500863,-95.12393 43.500886,-95.122981 43.500962,-95.122666 43.500989,-95.122478 43.500989,-95.122377 43.500989,-95.121917 43.500983,-95.12173 43.500981,-95.121689 43.50098,-95.120644 43.500967,-95.120596 43.500966,-95.117194 43.500946,-95.117178 43.500946,-95.11606 43.500945,-95.116001 43.500945,-95.115826 43.500945,-95.115768 43.500945,-95.115561 43.500919,-95.114945 43.500851,-95.114741 43.500829,-95.114606 43.500824,-95.114371 43.500832,-95.113465 43.500834,-95.11313 43.50084,-95.112156 43.500854,-95.106934 43.500851,-95.105686 43.500859,-95.104951 43.500864,-95.104192 43.500902,-95.104178 43.500903,-95.103697 43.500931,-95.102789 43.500952,-95.10266 43.500954,-95.102471 43.500959,-95.102273 43.500957,-95.102145 43.500957,-95.101314 43.500952,-95.099147 43.50094,-95.098823 43.50094,-95.097993 43.500943,-95.097579 43.500943,-95.09714 43.500945,-95.09634 43.500974,-95.095928 43.500989,-95.095541 43.501002,-95.095532 43.501004,-95.094383 43.501008,-95.093997 43.501011,-95.093987 43.501012,-95.093226 43.501012,-95.091859 43.501013,-95.090917 43.501009,-95.090154 43.501009,-95.090149 43.501009,-95.088583 43.501007,-95.086882 43.501007,-95.086071 43.501007,-95.083889 43.501008,-95.082326 43.50101,-95.081235 43.50101,-95.077963 43.50101,-95.077754 43.501011,-95.076873 43.50101,-95.076315 43.501007,-95.074641 43.500998,-95.074104 43.500996,-95.074083 43.500996,-95.072232 43.500987,-95.0701 43.500985,-95.062582 43.500983,-95.058154 43.500975,-95.056368 43.500973,-95.05433 43.500945,-95.054172 43.500955,-95.054056 43.500962,-95.053709 43.500985,-95.053594 43.500993,-95.049635 43.500984,-95.03776 43.500963,-95.033802 43.500955,-95.033563 43.500956,-95.033553 43.500956,-95.032808 43.500949,-95.03256 43.500948,-95.030943 43.500957,-95.02892 43.500972,-95.026095 43.500969,-95.02448 43.500968,-95.024161 43.500968,-95.023808 43.500968,-95.021793 43.500969,-95.021123 43.500971,-95.019721 43.500968,-95.015518 43.500963,-95.014223 43.500962,-95.014117 43.500962,-95.010188 43.500958,-95.008717 43.500957,-95.001886 43.500947,-94.998406 43.500937,-94.997477 43.500935,-94.99448 43.500923,-94.994439 43.500924,-94.991921 43.500936,-94.990525 43.50093,-94.989961 43.500929,-94.988673 43.500933,-94.98588 43.500932,-94.984521 43.500937,-94.979915 43.500934,-94.978661 43.500928,-94.978363 43.500927,-94.974793 43.500923,-94.974707 43.500925,-94.974618 43.500932,-94.974373 43.500953,-94.974353 43.500955,-94.974349 43.500956,-94.974265 43.50096,-94.974198 43.500964,-94.973644 43.500979,-94.972704 43.500981,-94.971334 43.500968,-94.97029 43.500977,-94.968699 43.500992,-94.967597 43.500992,-94.966081 43.500998,-94.965025 43.501007,-94.964417 43.500996,-94.963695 43.500991,-94.96274 43.500975,-94.961549 43.500968,-94.959657 43.500968,-94.958866 43.500956,-94.958364 43.500964,-94.958191 43.500966,-94.956295 43.500953,-94.955018 43.500931,-94.95471 43.500922,-94.95439 43.500926,-94.954333 43.500945,-94.954262 43.500945,-94.953906 43.50095,-94.95388 43.500949,-94.953753 43.500947,-94.952183 43.500915,-94.951411 43.500917,-94.951194 43.500916,-94.949767 43.50091,-94.948856 43.500897,-94.947981 43.500902,-94.945647 43.500903,-94.943517 43.500897,-94.942989 43.500896,-94.941753 43.500895,-94.940959 43.500901,-94.940816 43.500902,-94.939975 43.500897,-94.939691 43.500898,-94.937882 43.500906,-94.936675 43.500917,-94.935892 43.500921,-94.935243 43.500924,-94.934626 43.500931,-94.934528 43.500932,-94.934236 43.500939,-94.934139 43.500941,-94.93403 43.500943,-94.932942 43.500951,-94.932784 43.500953,-94.931714 43.500969,-94.930316 43.501007,-94.929698 43.501013,-94.929353 43.501007,-94.929298 43.501007,-94.928563 43.500974,-94.928159 43.500949,-94.92799 43.500937,-94.927434 43.500917,-94.927067 43.500923,-94.926833 43.500926,-94.926238 43.500945,-94.92564 43.500956,-94.925059 43.500952,-94.924485 43.500927,-94.923792 43.500909,-94.923682 43.500907,-94.922701 43.500897,-94.922304 43.500893,-94.92196 43.50089,-94.921116 43.500887,-94.92072 43.500886,-94.919581 43.500882,-94.917793 43.500865,-94.916341 43.500881,-94.915303 43.500884,-94.914921 43.500868,-94.914582 43.500853,-94.914574 43.500872,-94.904034 43.500478,-94.903818 43.50047,-94.889122 43.500499,-94.884418 43.500933,-94.883617 43.500946,-94.882895 43.500929,-94.882116 43.500925,-94.881207 43.500906,-94.880286 43.500921,-94.879146 43.500927,-94.878343 43.500936,-94.876719 43.500934,-94.875339 43.500923,-94.874795 43.500907,-94.874561 43.500924,-94.874418 43.500955,-94.873625 43.500967,-94.872751 43.500988,-94.872682 43.50097,-94.872456 43.500937,-94.872246 43.500917,-94.871695 43.500927,-94.870826 43.500926,-94.869582 43.500944,-94.868771 43.500939,-94.865694 43.500927,-94.86283 43.500926,-94.86178 43.500942,-94.861145 43.500935,-94.86076 43.500898,-94.860491 43.500842,-94.860138 43.500757,-94.859783 43.500617,-94.859696 43.500574,-94.85882 43.500591,-94.858521 43.500799,-94.858354 43.50087,-94.858195 43.500899,-94.857932 43.500924,-94.854566 43.500925,-94.854555 43.500925,-94.850814 43.500937,-94.847566 43.500912,-94.846326 43.500908,-94.844158 43.500918,-94.8424 43.500899,-94.838842 43.500888,-94.837944 43.500881,-94.83749 43.500874,-94.836469 43.500876,-94.834778 43.500868,-94.834413 43.500868,-94.834413 43.500869,-94.834413 43.50087,-94.834413 43.500871,-94.834413 43.500872,-94.834413 43.500873,-94.834413 43.500874,-94.834413 43.500875,-94.834413 43.500876,-94.834413 43.500877,-94.834413 43.500878,-94.834402 43.500879,-94.833922 43.50088,-94.833089 43.500882,-94.826577 43.500882,-94.82561 43.500897,-94.824375 43.500877,-94.821298 43.500922,-94.819236 43.500939,-94.818023 43.500942,-94.816625 43.500949,-94.814036 43.500971,-94.810194 43.500978,-94.808979 43.500975,-94.807898 43.500989,-94.805546 43.501004,-94.804189 43.500993,-94.804084 43.500993,-94.803946 43.500994,-94.801856 43.501002,-94.801022 43.500999,-94.799408 43.500985,-94.798194 43.501001,-94.797932 43.501005,-94.797227 43.501004,-94.796226 43.50102,-94.794387 43.501012,-94.794218 43.501011,-94.792206 43.501039,-94.790385 43.501024,-94.788172 43.501031,-94.785826 43.501025,-94.785071 43.501027,-94.781969 43.501034,-94.77755 43.501032,-94.774407 43.501042,-94.774283 43.501042,-94.773256 43.501046,-94.770068 43.50104,-94.765747 43.501052,-94.761873 43.501049,-94.761265 43.501046,-94.76081 43.501043,-94.758323 43.501033,-94.754238 43.501014,-94.754187 43.501014,-94.752623 43.50103,-94.74944 43.50102,-94.74746 43.501035,-94.74454 43.501023,-94.744535 43.501022,-94.744142 43.501021,-94.739661 43.500985,-94.73837 43.50096,-94.73812 43.500959,-94.734204 43.500936,-94.734179 43.500934,-94.734017 43.500926,-94.732268 43.500927,-94.731463 43.500917,-94.729451 43.500918,-94.729074 43.500923,-94.726893 43.500924,-94.726099 43.500919,-94.725419 43.500928,-94.723779 43.500919,-94.723237 43.500908,-94.722452 43.500901,-94.721784 43.500904,-94.721322 43.500903,-94.720951 43.500902,-94.720731 43.500902,-94.719997 43.500889,-94.718466 43.500885,-94.71821 43.500883,-94.71684 43.500872,-94.7162 43.500873,-94.71458 43.500867,-94.714277 43.500866,-94.714245 43.500865,-94.713386 43.500861,-94.712614 43.500845,-94.711961 43.500846,-94.711056 43.500858,-94.710361 43.500851,-94.706346 43.50085,-94.705118 43.500853,-94.703187 43.500844,-94.701328 43.500849,-94.700303 43.500839,-94.698423 43.500837,-94.698129 43.500839,-94.697713 43.500842,-94.695265 43.500838,-94.694223 43.500831,-94.694182 43.50083,-94.693288 43.500826,-94.68989 43.500819,-94.687758 43.500821,-94.686671 43.500827,-94.685546 43.500825,-94.683567 43.500808,-94.682289 43.500811,-94.681201 43.500797,-94.680159 43.500799,-94.679197 43.500809,-94.678474 43.500808,-94.678041 43.500808,-94.677431 43.5008,-94.67421 43.500797,-94.674191 43.500796,-94.673504 43.500784,-94.671593 43.500793,-94.670274 43.500795,-94.669115 43.500792,-94.668024 43.500784,-94.667615 43.500786,-94.666614 43.500789,-94.664876 43.500777,-94.661583 43.500784,-94.660428 43.50077,-94.658776 43.500762,-94.658045 43.500759,-94.656835 43.500748,-94.654285 43.500746,-94.654278 43.500745,-94.653373 43.500739,-94.652584 43.500733,-94.649709 43.500737,-94.647182 43.500729,-94.645294 43.500732,-94.642594 43.500727,-94.640508 43.500742,-94.640125 43.500734,-94.639491 43.500721,-94.638047 43.500716,-94.636966 43.500721,-94.63427 43.500713,-94.630435 43.500703,-94.630389 43.500702,-94.630195 43.500701,-94.628239 43.500682,-94.625 43.500687,-94.624394 43.500687,-94.624296 43.500687,-94.620603 43.500686,-94.620463 43.500677,-94.620303 43.500653,-94.6202 43.500613,-94.619886 43.500414,-94.61972 43.500506,-94.619514 43.500591,-94.619402 43.500625,-94.619125 43.500684,-94.619071 43.500688,-94.618929 43.500699,-94.616937 43.500698,-94.616723 43.500701,-94.61645 43.500704,-94.616179 43.500726,-94.615697 43.500864,-94.615454 43.500961,-94.615289 43.501036,-94.615158 43.501108,-94.615129 43.501128,-94.61502 43.50111,-94.611635 43.500532,-94.611128 43.500528,-94.609804 43.500521,-94.609697 43.500521,-94.608223 43.500516,-94.607205 43.500513,-94.567272 43.500373,-94.56687 43.500372,-94.566525 43.500354,-94.566087 43.500584,-94.565973 43.500598,-94.565841 43.500599,-94.565102 43.500583,-94.564831 43.500577,-94.564396 43.500567,-94.563081 43.500557,-94.560835 43.500549,-94.557445 43.500525,-94.552345 43.500525,-94.552345 43.500526,-94.552345 43.500527,-94.552345 43.500528,-94.552345 43.500529,-94.552343 43.50053,-94.549149 43.500524,-94.546867 43.50051,-94.544824 43.500514,-94.542522 43.500519,-94.535985 43.500527,-94.532385 43.500534,-94.53238 43.500535,-94.526832 43.5005,-94.52259 43.500494,-94.520215 43.500495,-94.514995 43.500473,-94.514078 43.500472,-94.512393 43.50049,-94.512391 43.500489,-94.508342 43.500465,-94.505798 43.500459,-94.502525 43.500462,-94.501657 43.500456,-94.497644 43.500469,-94.492413 43.500463,-94.49239 43.500462,-94.492241 43.500462,-94.491599 43.50046,-94.490615 43.500456,-94.488232 43.500446,-94.485675 43.500452,-94.482607 43.500443,-94.481887 43.500458,-94.480987 43.500445,-94.479855 43.500443,-94.478373 43.50046,-94.476289 43.500441,-94.475275 43.50045,-94.472935 43.50045,-94.472135 43.500436,-94.471858 43.500431,-94.470957 43.500431,-94.470946 43.500432,-94.470912 43.500432,-94.470807 43.500424,-94.470708 43.500406,-94.470653 43.500384,-94.470585 43.50035,-94.470566 43.500336,-94.470547 43.500321,-94.470413 43.500333,-94.470332 43.50033,-94.463842 43.500358,-94.457341 43.500385,-94.452754 43.500407,-94.448156 43.500429,-94.447424 43.500405,-94.447094 43.500396,-94.445377 43.500404,-94.44285 43.500422,-94.442602 43.500424,-94.439781 43.500387,-94.43893 43.500402,-94.437474 43.500389,-94.437471 43.500389,-94.437325 43.500388,-94.434488 43.500397,-94.432757 43.500371,-94.431547 43.500381,-94.429936 43.500374,-94.427727 43.500341,-94.427146 43.500338,-94.424434 43.500336,-94.423343 43.500333,-94.420397 43.500347,-94.419062 43.500354,-94.415452 43.500345,-94.41444 43.500357,-94.412804 43.500341,-94.411753 43.500317,-94.41033 43.500332,-94.410303 43.500331,-94.408529 43.500312,-94.406276 43.500287,-94.404584 43.500324,-94.403424 43.500322,-94.40339 43.500322,-94.403038 43.500322,-94.400229 43.50032,-94.399727 43.500319,-94.398409 43.500322,-94.393772 43.500299,-94.390776 43.500284,-94.390662 43.500292,-94.390599 43.500317,-94.390555 43.50035,-94.390511 43.500405,-94.390486 43.500468,-94.389248 43.500458,-94.387739 43.500446,-94.386233 43.500437,-94.385241 43.50043,-94.383169 43.500418,-94.382754 43.500415,-94.380106 43.5004,-94.37927 43.500391,-94.378462 43.500385,-94.377961 43.500381,-94.377795 43.50038,-94.377599 43.500379,-94.377466 43.500379,-94.377367 43.500236,-94.377157 43.500235,-94.377049 43.500235,-94.376927 43.500234,-94.376756 43.500233,-94.376537 43.500232,-94.376215 43.50023,-94.376177 43.500229,-94.374965 43.500221,-94.369234 43.500255,-94.36807 43.500243,-94.368066 43.500242,-94.366554 43.500228,-94.365403 43.500241,-94.364213 43.500265,-94.363622 43.500264,-94.35839 43.500251,-94.357708 43.50026,-94.357697 43.500261,-94.357027 43.500249,-94.355819 43.500259,-94.354746 43.500279,-94.352119 43.500254,-94.349308 43.500259,-94.348156 43.50025,-94.347213 43.500248,-94.345278 43.500244,-94.344526 43.500251,-94.343287 43.500253,-94.343016 43.500253,-94.341754 43.50023,-94.339184 43.500238,-94.337406 43.500235,-94.336537 43.500243,-94.334894 43.500237,-94.332953 43.500244,-94.332237 43.50023,-94.33048 43.500224,-94.329679 43.500233,-94.329175 43.500237,-94.327724 43.500225,-94.327237 43.500233,-94.32606 43.500251,-94.323977 43.500237,-94.323298 43.500232,-94.322228 43.500233,-94.320863 43.500266,-94.319947 43.500237,-94.318484 43.500221,-94.316213 43.500216,-94.315406 43.500223,-94.31407 43.500205,-94.311093 43.500197,-94.309481 43.500178,-94.307404 43.500175,-94.306895 43.500185,-94.302612 43.500188,-94.300734 43.500196,-94.298466 43.500181,-94.296353 43.500188,-94.289893 43.500181,-94.288864 43.500192,-94.287774 43.500189,-94.287754 43.500188,-94.287267 43.500182,-94.286242 43.500182,-94.285786 43.500174,-94.283782 43.500171,-94.281445 43.500167,-94.279546 43.500179,-94.278682 43.50017,-94.277143 43.500155,-94.274829 43.500141,-94.272814 43.500152,-94.272475 43.500145,-94.267815 43.500135,-94.267796 43.500135,-94.26739 43.500139,-94.266298 43.500149,-94.265648 43.500138,-94.264561 43.500163,-94.264394 43.500158,-94.263182 43.500123,-94.260751 43.500128,-94.258589 43.50012,-94.255427 43.500128,-94.254526 43.50013,-94.251081 43.50012,-94.250505 43.500118,-94.24959 43.500139,-94.248556 43.500128,-94.247968 43.500133,-94.245416 43.500143,-94.245389 43.500143,-94.23972 43.50012,-94.237771 43.500137,-94.236259 43.500131,-94.234093 43.500138,-94.232244 43.500155,-94.230807 43.500145,-94.22931 43.500153,-94.227969 43.500148,-94.22608 43.500125,-94.225056 43.500136,-94.224689 43.50014,-94.223202 43.500126,-94.220625 43.500157,-94.218938 43.500137,-94.217391 43.500145,-94.215848 43.500131,-94.2127 43.500126,-94.212064 43.500154,-94.212041 43.500155,-94.210486 43.500137,-94.20879 43.500135,-94.208036 43.50015,-94.207027 43.500125,-94.206422 43.500133,-94.204752 43.500126,-94.20296 43.500136,-94.201095 43.500132,-94.200991 43.500131,-94.196025 43.500097,-94.19323 43.500101,-94.192743 43.500102,-94.190219 43.500081,-94.188674 43.500088,-94.188089 43.500091,-94.18803 43.500091,-94.186993 43.500082,-94.186135 43.500093,-94.185762 43.500091,-94.183399 43.500076,-94.182191 43.500078,-94.181288 43.500072,-94.179406 43.500084,-94.178022 43.500092,-94.176763 43.500084,-94.175095 43.500094,-94.172468 43.500083,-94.170926 43.500096,-94.16931 43.500093,-94.167991 43.500106,-94.16723 43.500096,-94.167112 43.500094,-94.166857 43.500091,-94.165964 43.50008,-94.165457 43.500082,-94.163387 43.500088,-94.16059 43.500079,-94.159471 43.500083,-94.157449 43.500091,-94.156733 43.500094,-94.156535 43.500093,-94.154701 43.500088,-94.152104 43.500092,-94.151095 43.500111,-94.150897 43.500105,-94.150388 43.500089,-94.149012 43.50008,-94.147128 43.500088,-94.144988 43.500089,-94.143759 43.50009,-94.142246 43.500099,-94.140461 43.50011,-94.133707 43.500077,-94.132768 43.500101,-94.129974 43.50012,-94.128144 43.500103,-94.125016 43.500104,-94.124122 43.500115,-94.122133 43.500101,-94.120069 43.500104,-94.118322 43.500087,-94.117763 43.500087,-94.117706 43.500087,-94.1163 43.500087,-94.114622 43.500101,-94.113645 43.500102,-94.112881 43.500118,-94.109752 43.500106,-94.108313 43.50011,-94.108152 43.500111,-94.108051 43.500112,-94.107942 43.500114,-94.10779 43.500116,-94.106864 43.500128,-94.106392 43.500105,-94.105009 43.500097,-94.101929 43.500098,-94.098251 43.500082,-94.098084 43.500082,-94.096052 43.500082,-94.094675 43.500074,-94.094656 43.500074,-94.094311 43.500073,-94.094148 43.500073,-94.093594 43.500071,-94.093439 43.500075,-94.09335 43.50009,-94.088586 43.500092,-94.086482 43.500063,-94.085023 43.500051,-94.082891 43.500049,-94.082853 43.500049,-94.079887 43.500042,-94.078227 43.500031,-94.07523 43.500016,-94.07261 43.500021,-94.069231 43.500015,-94.06862 43.500014,-94.068409 43.500013,-94.068271 43.500013,-94.068162 43.500013,-94.067989 43.500013,-94.066204 43.500019,-94.065217 43.500015,-94.064781 43.500013,-94.060935 43.499995,-94.058345 43.500013,-94.053641 43.499992,-94.050801 43.499997,-94.043846 43.499974,-94.043833 43.499974,-94.042451 43.499962,-94.040133 43.499961,-94.034051 43.499957,-94.030804 43.499955,-94.030751 43.499955,-94.029526 43.499951,-94.028194 43.499947,-94.025898 43.499941,-94.023329 43.499944,-94.020781 43.499934,-94.018063 43.499923,-94.016289 43.499925,-94.010752 43.499916,-94.008389 43.49991,-94.008241 43.49991,-94.007876 43.49991,-94.00607 43.499911,-94.002028 43.499913,-94.000441 43.499907,-94.000215 43.499907,-93.999208 43.499903,-93.995154 43.499917,-93.991554 43.499912,-93.990844 43.49992,-93.988231 43.499915,-93.982302 43.499902,-93.981692 43.499901,-93.979328 43.499906,-93.977081 43.49989,-93.973497 43.499885,-93.970762 43.499886,-93.970608 43.499866,-93.968285 43.499873,-93.962102 43.499867,-93.961593 43.499845,-93.952288 43.499874,-93.952286 43.499873,-93.94833 43.499852,-93.94266 43.499855,-93.938465 43.499803,-93.930401 43.499814,-93.930406 43.499825,-93.928585 43.499797,-93.919858 43.499766,-93.919733 43.499766,-93.914717 43.499822,-93.912203 43.499812,-93.912196 43.499811,-93.908599 43.499784,-93.908328 43.499787,-93.905323 43.499781,-93.897069 43.499779,-93.893269 43.499769,-93.893073 43.499769,-93.892288 43.499774,-93.892285 43.499773,-93.88843 43.499769,-93.887961 43.499768,-93.876574 43.499757,-93.875224 43.499728,-93.872447 43.499743,-93.872352 43.499737,-93.872002 43.499722,-93.868404 43.499749,-93.863355 43.499715,-93.852263 43.499742,-93.852262 43.499743,-93.84849 43.499739,-93.835852 43.499749,-93.828496 43.499727,-93.817563 43.499711,-93.813272 43.499699,-93.813269 43.499698,-93.812981 43.49971,-93.808507 43.499697,-93.806438 43.499724,-93.805588 43.499702,-93.801789 43.499677,-93.799286 43.4997,-93.797851 43.499711,-93.797016 43.499697,-93.796428 43.499704,-93.79638 43.499704,-93.796353 43.4997,-93.793979 43.499681,-93.793974 43.49968,-93.793238 43.499686,-93.791251 43.499685,-93.788429 43.499703,-93.785878 43.499689,-93.785875 43.499688,-93.78188 43.499676,-93.780568 43.49967,-93.773734 43.499682,-93.77371 43.49968,-93.769112 43.499695,-93.768498 43.499709,-93.767265 43.499688,-93.767264 43.499687,-93.764461 43.499681,-93.7563 43.499682,-93.753668 43.499678,-93.753655 43.499677,-93.748443 43.499697,-93.743573 43.499689,-93.743568 43.49969,-93.738623 43.499674,-93.738374 43.499673,-93.738007 43.499671,-93.73395 43.499686,-93.733906 43.499685,-93.72846 43.499696,-93.726049 43.499683,-93.722532 43.499676,-93.716122 43.499688,-93.716091 43.499687,-93.708835 43.49967,-93.708489 43.499648,-93.708267 43.499648,-93.704634 43.499661,-93.704623 43.49966,-93.703848 43.499654,-93.700707 43.499683,-93.700306 43.499673,-93.70008 43.499675,-93.697206 43.499675,-93.697206 43.499676,-93.696593 43.49968,-93.694644 43.499672,-93.691067 43.499656,-93.683226 43.49967,-93.677303 43.499687,-93.676303 43.49968,-93.676227 43.499677,-93.668495 43.499675,-93.66785 43.499673,-93.66164 43.499674,-93.656597 43.499664,-93.65656 43.499663,-93.653036 43.499669,-93.651282 43.499667,-93.651281 43.499667,-93.648533 43.49968,-93.648043 43.499677,-93.647542 43.499677,-93.645295 43.49968,-93.644571 43.499682,-93.643581 43.499687,-93.64267 43.499691,-93.64224 43.499689,-93.64132 43.499685,-93.640643 43.499689,-93.638218 43.499682,-93.636878 43.499679,-93.634401 43.499675,-93.633224 43.499679,-93.632771 43.499681,-93.631706 43.499675,-93.629955 43.499684,-93.628325 43.499671,-93.626701 43.499687,-93.624988 43.499668,-93.623015 43.499673,-93.622261 43.499677,-93.621214 43.499683,-93.618609 43.49967,-93.618269 43.499669,-93.617249 43.499666,-93.61691 43.499666,-93.616528 43.499666,-93.615837 43.499659,-93.613431 43.499637,-93.61262 43.49964,-93.611548 43.499646,-93.610148 43.499652,-93.609883 43.499654,-93.605951 43.499641,-93.604833 43.499638,-93.604552 43.499637,-93.602504 43.499627,-93.600839 43.49962,-93.59636 43.499618,-93.594312 43.499618,-93.594096 43.499618,-93.593321 43.499622,-93.5928 43.499626,-93.59035 43.499633,-93.589571 43.499636,-93.58936 43.499635,-93.589185 43.499634,-93.58866 43.499632,-93.588485 43.499632,-93.587638 43.49963,-93.586486 43.499629,-93.584099 43.499633,-93.580836 43.499631,-93.580489 43.499632,-93.578491 43.499639,-93.578097 43.499638,-93.576915 43.499643,-93.576522 43.499644,-93.575796 43.499646,-93.574592 43.49964,-93.572066 43.49963,-93.569053 43.499632,-93.568801 43.499632,-93.566872 43.499638,-93.565206 43.499642,-93.560755 43.499654,-93.560209 43.499651,-93.558544 43.499644,-93.558457 43.499643,-93.558198 43.499643,-93.558112 43.499643,-93.557891 43.499641,-93.557231 43.499638,-93.557011 43.499639,-93.555557 43.499643,-93.554758 43.499646,-93.551197 43.499632,-93.550459 43.499631,-93.549744 43.499633,-93.549506 43.499632,-93.548791 43.499634,-93.548555 43.499635,-93.548126 43.499635,-93.546847 43.499639,-93.546842 43.499638,-93.546414 43.499637,-93.546296 43.499637,-93.54484 43.499632,-93.544045 43.49963,-93.540122 43.499637,-93.538608 43.499641,-93.538549 43.499641,-93.537493 43.499643,-93.535801 43.499647,-93.534326 43.499657,-93.533646 43.499662,-93.533272 43.49966,-93.53305 43.499658,-93.532384 43.499654,-93.532163 43.499653,-93.532107 43.499652,-93.531942 43.499651,-93.531887 43.499651,-93.531408 43.499648,-93.531206 43.499646,-93.529163 43.499642,-93.528483 43.499641,-93.528433 43.49964,-93.528286 43.49964,-93.528237 43.49964,-93.527904 43.499639,-93.526907 43.499636,-93.526575 43.499636,-93.526118 43.499635,-93.525533 43.499637,-93.523831 43.499643,-93.52241 43.499637,-93.52137 43.499633,-93.521255 43.499632,-93.520912 43.499631,-93.520798 43.499631,-93.520246 43.499628,-93.519277 43.499625,-93.51859 43.499625,-93.518039 43.499626,-93.517873 43.499626,-93.517375 43.499626,-93.517209 43.499626,-93.516993 43.499626,-93.516801 43.499626,-93.516382 43.499626,-93.51558 43.49962,-93.515173 43.499618,-93.514654 43.499614,-93.513103 43.499603,-93.512586 43.4996,-93.512304 43.499598,-93.511811 43.499596,-93.509487 43.499587,-93.508713 43.499585,-93.508067 43.499586,-93.507449 43.499588,-93.50613 43.499593,-93.505485 43.499596,-93.505378 43.499596,-93.505057 43.499597,-93.504951 43.499598,-93.504439 43.499599,-93.503775 43.499602,-93.502906 43.499588,-93.502396 43.499581,-93.502165 43.499577,-93.502104 43.499576,-93.501229 43.499586,-93.500939 43.49959,-93.500436 43.499595,-93.500227 43.499598,-93.498927 43.499607,-93.498425 43.499613,-93.49821 43.499614,-93.497567 43.49962,-93.497353 43.499622,-93.492638 43.499612,-93.492146 43.499603,-93.492138 43.499603,-93.491757 43.499597,-93.491391 43.499596,-93.489844 43.49959,-93.489836 43.49959,-93.489327 43.499588,-93.489302 43.499588,-93.488802 43.499583,-93.488765 43.499583,-93.488209 43.499591,-93.487799 43.499578,-93.483151 43.499475,-93.483137 43.499475,-93.483123 43.499475,-93.483087 43.499474,-93.481438 43.499491,-93.478554 43.499489,-93.47854 43.499489,-93.472767 43.499484,-93.472301 43.499466,-93.468321 43.499565,-93.46829 43.499572,-93.467961 43.499574,-93.466793 43.499562,-93.461403 43.499574,-93.458595 43.499579,-93.458583 43.499579,-93.453642 43.499567,-93.453435 43.499567,-93.448679 43.499551,-93.448667 43.499551,-93.445822 43.499546,-93.441911 43.499561,-93.438797 43.499562,-93.43879 43.499562,-93.438119 43.499562,-93.437503 43.499548,-93.434755 43.499535,-93.431223 43.499559,-93.428574 43.499556,-93.428507 43.499556,-93.428138 43.499555,-93.427864 43.499555,-93.427645 43.499555,-93.422931 43.499563,-93.420353 43.499562,-93.418627 43.499562,-93.414451 43.499544,-93.413585 43.499544,-93.413506 43.499544,-93.410613 43.499542,-93.408616 43.499545,-93.403334 43.499554,-93.399042 43.499534,-93.398993 43.499534,-93.398613 43.499532,-93.398583 43.499532,-93.393519 43.499536,-93.39348 43.499536,-93.39109 43.499534,-93.391025 43.499534,-93.390121 43.499534,-93.386356 43.499516,-93.382139 43.499534,-93.381849 43.499533,-93.381688 43.499533,-93.379932 43.499528,-93.379924 43.499528,-93.379545 43.499527,-93.379536 43.499527,-93.378607 43.499525,-93.378579 43.499525,-93.375826 43.499515,-93.375813 43.499515,-93.375212 43.499513,-93.375175 43.499513,-93.374998 43.499512,-93.372084 43.499515,-93.370052 43.499513,-93.370007 43.499513,-93.369066 43.499512,-93.369012 43.499512,-93.367003 43.499509,-93.36261 43.499487,-93.358793 43.499487,-93.358698 43.499487,-93.354921 43.499508,-93.353709 43.499504,-93.353307 43.499502,-93.35297 43.499501,-93.350161 43.499491,-93.350151 43.499491,-93.346711 43.499479,-93.346014 43.499476,-93.345461 43.499478,-93.345298 43.499479,-93.34516 43.499479,-93.344207 43.499481,-93.344041 43.499482,-93.343972 43.499482,-93.34312 43.499485,-93.343096 43.499485,-93.341819 43.499489,-93.340151 43.499484,-93.340139 43.499484,-93.338793 43.49948,-93.337354 43.499476,-93.33713 43.499477,-93.336927 43.499478,-93.333982 43.499492,-93.330244 43.499485,-93.330232 43.499485,-93.328744 43.499485,-93.325799 43.499486,-93.321954 43.499471,-93.321442 43.499477,-93.321411 43.499477,-93.320556 43.499488,-93.317759 43.49948,-93.316846 43.499474,-93.316835 43.499474,-93.31449 43.499459,-93.313897 43.49946,-93.313881 43.49946,-93.312498 43.499461,-93.307152 43.499482,-93.306628 43.49948,-93.306586 43.49948,-93.30387 43.499468,-93.303218 43.499465,-93.302999 43.499464,-93.302813 43.499464,-93.301057 43.499462,-93.300617 43.499461,-93.300584 43.499461,-93.298923 43.499459,-93.298874 43.499459,-93.296303 43.499467,-93.295089 43.499472,-93.290601 43.499467,-93.289043 43.49947,-93.286249 43.499474,-93.281792 43.499492,-93.281766 43.499492,-93.280413 43.499493,-93.276308 43.499493,-93.273899 43.49949,-93.273879 43.49949,-93.272112 43.499496,-93.271831 43.499488,-93.267809 43.499369,-93.267571 43.499362,-93.267531 43.499361,-93.26744 43.499361,-93.267349 43.499361,-93.266987 43.499361,-93.260984 43.499369,-93.250204 43.499386,-93.247786 43.499485,-93.247216 43.499511,-93.247207 43.499511,-93.24608 43.499501,-93.245997 43.4995,-93.244747 43.499505,-93.243588 43.499504,-93.233845 43.499506,-93.228738 43.499508,-93.228659 43.499508,-93.228396 43.49951,-93.228378 43.49951,-93.227905 43.499513,-93.226058 43.499524,-93.220569 43.499531,-93.220555 43.499531,-93.217806 43.499535,-93.21557 43.499535,-93.215542 43.499535,-93.213102 43.499535,-93.210671 43.49953,-93.209696 43.499528,-93.209116 43.499531,-93.20909 43.499531,-93.201098 43.49956,-93.197936 43.499565,-93.193443 43.499566,-93.189138 43.499558,-93.189114 43.499558,-93.187505 43.49957,-93.183794 43.499567,-93.183772 43.499567,-93.176845 43.499559,-93.171999 43.499563,-93.171406 43.499564,-93.169173 43.499571,-93.16914 43.499571,-93.162294 43.499593,-93.161068 43.499588,-93.161056 43.499588,-93.156954 43.499572,-93.155423 43.499576,-93.149191 43.499596,-93.149175 43.499596,-93.144363 43.499611,-93.14122 43.499608,-93.141195 43.499608,-93.137393 43.499605,-93.137375 43.499605,-93.13643 43.499605,-93.132918 43.499618,-93.131713 43.499623,-93.128996 43.499622,-93.127744 43.499621,-93.124281 43.49962,-93.124274 43.49962,-93.12404 43.49962,-93.123593 43.499621,-93.117792 43.499624,-93.116697 43.499629,-93.114068 43.49964,-93.111522 43.49963,-93.110124 43.499644,-93.109339 43.499645,-93.109311 43.499645,-93.107728 43.499646,-93.107366 43.499646,-93.102842 43.499641,-93.100456 43.499642,-93.095208 43.499645,-93.093961 43.499644,-93.093949 43.499644,-93.092362 43.499643,-93.092015 43.499642,-93.091692 43.499642,-93.089294 43.499637,-93.089287 43.499637,-93.086651 43.49963,-93.084283 43.499641,-93.082469 43.499649,-93.082183 43.499649,-93.081882 43.499649,-93.081858 43.499649,-93.078494 43.499651,-93.075636 43.49965,-93.072425 43.499643,-93.071156 43.499641,-93.069321 43.499639,-93.069274 43.499639,-93.06536 43.499643,-93.062479 43.499646,-93.062258 43.499648,-93.062034 43.49965,-93.060461 43.499665,-93.06044 43.499665,-93.059957 43.49967,-93.057505 43.499679,-93.05587 43.499694,-93.055393 43.499694,-93.052766 43.499693,-93.050191 43.499703,-93.050167 43.499703,-93.049192 43.499705,-93.045953 43.499705,-93.044382 43.499717,-93.042809 43.499725,-93.041064 43.499711,-93.039356 43.499703,-93.038827 43.499701,-93.036193 43.499708,-93.03361 43.499724,-93.029556 43.499725,-93.028096 43.49972,-93.024345 43.499733,-93.019507 43.499715,-93.014151 43.499744,-93.009604 43.499746,-93.009545 43.499747,-93.009544 43.499736,-93.008754 43.49974,-93.007706 43.499755,-93.006525 43.499758,-93.002984 43.499768,-93.00199 43.499771,-93.001897 43.499772,-93.001804 43.499772,-93.001722 43.499772,-93.001641 43.499772,-93.001015 43.499774,-92.99982 43.499774,-92.99811 43.499776,-92.993869 43.499767,-92.991956 43.499763,-92.991886 43.499763,-92.991261 43.499763,-92.989388 43.499763,-92.988764 43.499763,-92.988536 43.499763,-92.987852 43.499763,-92.987625 43.499763,-92.987445 43.499763,-92.986907 43.499763,-92.986728 43.499763,-92.985943 43.499763,-92.983591 43.499763,-92.983054 43.499764,-92.982807 43.499764,-92.9826 43.499764,-92.981982 43.499765,-92.981776 43.499766,-92.981625 43.499766,-92.981174 43.499766,-92.981024 43.499767,-92.980928 43.499767,-92.980642 43.499767,-92.980547 43.499768,-92.980338 43.499768,-92.979712 43.499768,-92.979504 43.499769,-92.978397 43.49974,-92.975076 43.499656,-92.973969 43.499628,-92.972338 43.499608,-92.967447 43.499548,-92.965817 43.499529,-92.964046 43.499585,-92.958733 43.499757,-92.956964 43.499815,-92.956413 43.499759,-92.954766 43.499596,-92.954217 43.499542,-92.953292 43.499596,-92.950523 43.499759,-92.9496 43.499814,-92.949549 43.499813,-92.949407 43.499816,-92.949364 43.499815,-92.94946 43.499595,-92.949446 43.499584,-92.949403 43.499552,-92.94939 43.499542,-92.949253 43.499542,-92.948842 43.499542,-92.948706 43.499543,-92.948302 43.499597,-92.947092 43.499761,-92.947017 43.499771,-92.94669 43.499816,-92.946587 43.49976,-92.946282 43.499596,-92.946183 43.499543,-92.945853 43.49959,-92.944866 43.499736,-92.944539 43.499786,-92.94449 43.499784,-92.944345 43.499778,-92.944298 43.499777,-92.943906 43.499739,-92.943806 43.499731,-92.94233 43.499606,-92.941839 43.499566,-92.941726 43.499561,-92.941391 43.499547,-92.941279 43.499544,-92.941227 43.499775,-92.941027 43.499729,-92.940433 43.499597,-92.940236 43.499555,-92.940107 43.499548,-92.939727 43.499529,-92.9396 43.499523,-92.939577 43.499786,-92.937961 43.499786,-92.933125 43.499791,-92.931513 43.499794,-92.931151 43.499751,-92.930067 43.499627,-92.929708 43.499586,-92.929627 43.499805,-92.928733 43.499754,-92.926058 43.499603,-92.925167 43.499554,-92.923811 43.499604,-92.919747 43.499759,-92.918394 43.499812,-92.918355 43.499592,-92.917842 43.499585,-92.916305 43.499564,-92.915793 43.499558,-92.913739 43.499559,-92.907581 43.499562,-92.905528 43.499564,-92.90512 43.499561,-92.9039 43.499554,-92.903494 43.499553,-92.90344 43.499847,-92.902641 43.499845,-92.900249 43.499845,-92.899456 43.499848,-92.899427 43.49958,-92.897621 43.499622,-92.892203 43.499751,-92.890397 43.499796,-92.890283 43.499806,-92.889948 43.49984,-92.889838 43.499853,-92.88965 43.499537,-92.888312 43.499601,-92.884304 43.499797,-92.882969 43.499863,-92.882899 43.499551,-92.882042 43.499554,-92.87947 43.499568,-92.878614 43.499573,-92.878525 43.49987,-92.876869 43.499836,-92.875069 43.499802,-92.871911 43.499635,-92.87026 43.49955,-92.867925 43.499547,-92.860921 43.499541,-92.858588 43.499539,-92.858586 43.499912,-92.858212 43.499908,-92.857096 43.499907,-92.856726 43.499907,-92.856656 43.499535,-92.855236 43.499533,-92.850979 43.499532,-92.849561 43.499534,-92.849466 43.499904,-92.846739 43.499831,-92.838565 43.499623,-92.835841 43.499553,-92.83583 43.499917,-92.834714 43.499843,-92.831371 43.499626,-92.830258 43.499555,-92.829931 43.499549,-92.828954 43.499534,-92.828629 43.499529,-92.828605 43.49992,-92.827231 43.49993,-92.823113 43.499969,-92.821742 43.499982,-92.819447 43.499974,-92.812568 43.499956,-92.810276 43.499951,-92.809946 43.499951,-92.808956 43.499952,-92.808627 43.499953,-92.808608 43.499953,-92.806177 43.499958,-92.804958 43.499962,-92.802246 43.499974,-92.793952 43.499982,-92.790284 43.499986,-92.789954 43.499985,-92.788967 43.499985,-92.788644 43.499985,-92.788638 43.499985,-92.78741 43.499984,-92.783726 43.499984,-92.78367 43.499984,-92.782499 43.499991,-92.781346 43.499998,-92.780775 43.500002,-92.777888 43.499996,-92.776736 43.499995,-92.775343 43.499992,-92.774267 43.49999,-92.771165 43.499998,-92.769773 43.500002,-92.769592 43.500002,-92.769051 43.500004,-92.768871 43.500005,-92.767524 43.500004,-92.763483 43.500003,-92.762137 43.500003,-92.761375 43.500003,-92.760109 43.500006,-92.754027 43.500023,-92.752 43.500029,-92.751634 43.500029,-92.750538 43.500032,-92.750173 43.500034,-92.749988 43.500034,-92.749433 43.500035,-92.749249 43.500036,-92.748941 43.500036,-92.748019 43.500039,-92.747712 43.50004,-92.747599 43.50004,-92.747485 43.500041,-92.747474 43.50004,-92.747261 43.50004,-92.747149 43.50004,-92.744232 43.500034,-92.740278 43.500027,-92.739571 43.500056,-92.737097 43.500045,-92.735484 43.500044,-92.732568 43.500043,-92.732501 43.500043,-92.732302 43.500043,-92.732236 43.500043,-92.732003 43.500043,-92.731556 43.500043,-92.729519 43.500044,-92.72884 43.500045,-92.728652 43.500045,-92.728634 43.500045,-92.72817 43.500045,-92.726487 43.500047,-92.726163 43.500048,-92.725495 43.500051,-92.724954 43.500052,-92.723334 43.500059,-92.722794 43.500062,-92.720721 43.500069,-92.71781 43.500081,-92.714505 43.500079,-92.712433 43.500079,-92.712023 43.500078,-92.710796 43.500078,-92.710387 43.500078,-92.710158 43.500078,-92.709474 43.500078,-92.709246 43.500078,-92.708885 43.500078,-92.708573 43.500078,-92.706556 43.500078,-92.705999 43.500079,-92.705998 43.500079,-92.705884 43.50008,-92.704662 43.500065,-92.703238 43.500073,-92.698329 43.500101,-92.695302 43.500095,-92.693961 43.500093,-92.692657 43.500096,-92.691931 43.500097,-92.689757 43.5001,-92.689032 43.500102,-92.688735 43.500102,-92.688718 43.500102,-92.688717 43.500102,-92.685742 43.500109,-92.676236 43.500132,-92.675872 43.500132,-92.672582 43.500134,-92.672236 43.500134,-92.671202 43.500134,-92.670857 43.500135,-92.670483 43.500135,-92.669362 43.500135,-92.668989 43.500136,-92.668723 43.500136,-92.668717 43.500136,-92.666963 43.500143,-92.660888 43.500171,-92.659117 43.50018,-92.659048 43.50018,-92.658863 43.500182,-92.657727 43.50019,-92.655662 43.500206,-92.65432 43.50021,-92.653185 43.500215,-92.652698 43.500216,-92.652386 43.500213,-92.649991 43.500192,-92.649193 43.500185,-92.648819 43.500182,-92.648798 43.500182,-92.6482 43.500177,-92.64806 43.500176,-92.645221 43.500183,-92.644228 43.500186,-92.64392 43.500186,-92.643751 43.500187,-92.642997 43.500186,-92.64269 43.500186,-92.641358 43.500185,-92.637363 43.500183,-92.636351 43.500183,-92.636032 43.500184,-92.635406 43.500186,-92.633532 43.500193,-92.632907 43.500196,-92.632616 43.500196,-92.631743 43.5002,-92.631453 43.500202,-92.631017 43.500203,-92.629709 43.500208,-92.629274 43.50021,-92.62892 43.500211,-92.628825 43.500211,-92.628789 43.500212,-92.627859 43.500215,-92.627506 43.500217,-92.627502 43.500217,-92.627403 43.500217,-92.627076 43.500213,-92.625786 43.500201,-92.625357 43.500197,-92.624351 43.500187,-92.622932 43.500191,-92.615657 43.500212,-92.614265 43.500217,-92.613233 43.500213,-92.612372 43.500209,-92.609789 43.500198,-92.608928 43.500195,-92.608822 43.500195,-92.60882 43.500195,-92.608311 43.500192,-92.60712 43.500188,-92.606463 43.500191,-92.605847 43.500194,-92.60478 43.500198,-92.60158 43.500212,-92.601476 43.500213,-92.600514 43.500214,-92.599029 43.500215,-92.594574 43.500221,-92.59309 43.500224,-92.592672 43.500224,-92.591421 43.500225,-92.591004 43.500226,-92.590612 43.500226,-92.589437 43.500228,-92.589046 43.500229,-92.588846 43.500229,-92.58883 43.500229,-92.585861 43.500237,-92.582232 43.500247,-92.576309 43.500258,-92.57487 43.500261,-92.573125 43.500261,-92.572282 43.500261,-92.569755 43.500262,-92.568913 43.500263,-92.568899 43.500263,-92.566923 43.500263,-92.56156 43.500266,-92.560956 43.500269,-92.558968 43.500279,-92.558872 43.500279,-92.558031 43.500284,-92.557421 43.500276,-92.553128 43.500218,-92.553128 43.500231,-92.552189 43.500207,-92.549786 43.50019,-92.547619 43.500201,-92.545338 43.500194,-92.543362 43.5002,-92.543274 43.5002,-92.540806 43.500223,-92.538879 43.500223,-92.538844 43.500223,-92.53622 43.50023,-92.53407 43.500228,-92.532116 43.500241,-92.531897 43.500243,-92.528958 43.500234,-92.528934 43.500234,-92.527893 43.500231,-92.525578 43.500242,-92.51471 43.500244,-92.514389 43.500244,-92.508949 43.500245,-92.508018 43.500242,-92.505649 43.500237,-92.505064 43.500243,-92.505036 43.500244,-92.504148 43.500257,-92.504039 43.500257,-92.503833 43.500257,-92.501937 43.500263,-92.500003 43.500262,-92.499169 43.500267,-92.499073 43.500273,-92.498984 43.500295,-92.498977 43.500298,-92.498902 43.500335,-92.498818 43.500382,-92.498817 43.500388,-92.498816 43.500388,-92.498815 43.500388,-92.498802 43.500392,-92.498621 43.500388,-92.497683 43.500383,-92.497544 43.500376,-92.497529 43.500376,-92.497101 43.500364,-92.496897 43.500349,-92.496829 43.500333,-92.496192 43.500285,-92.495537 43.500254,-92.495509 43.500258,-92.495393 43.500276,-92.494918 43.500284,-92.49466 43.500284,-92.489556 43.500287,-92.489339 43.500288,-92.487972 43.500293,-92.487613 43.500295,-92.487469 43.500295,-92.487254 43.500296,-92.484047 43.500309,-92.475706 43.500281,-92.47521 43.50028,-92.473717 43.500282,-92.471011 43.500293,-92.4689 43.500286,-92.467738 43.500288,-92.464712 43.50029,-92.464473 43.50029,-92.464436 43.500286,-92.464386 43.500281,-92.46305 43.500305,-92.462726 43.500311,-92.46174 43.500356,-92.458974 43.500413,-92.457664 43.50041,-92.455542 43.500404,-92.455483 43.500403,-92.454727 43.500416,-92.454599 43.500417,-92.452943 43.500429,-92.452761 43.500431,-92.448948 43.500459,-92.446609 43.500455,-92.445532 43.500478,-92.444491 43.5005,-92.441276 43.500483,-92.439035 43.500534,-92.437649 43.500551,-92.435833 43.500513,-92.435606 43.5005,-92.43553 43.500508,-92.4351 43.500551,-92.432482 43.500551,-92.432202 43.500538,-92.431679 43.500513,-92.431629 43.500514,-92.430806 43.500538,-92.428789 43.500536,-92.426605 43.500581,-92.423699 43.500542,-92.420718 43.500551,-92.418921 43.500606,-92.418841 43.500615,-92.418822 43.500615,-92.416393 43.500568,-92.414187 43.500548,-92.413617 43.500546,-92.41345 43.500546,-92.412302 43.500586,-92.410517 43.500535,-92.409641 43.500587,-92.409227 43.500605,-92.40894 43.500599,-92.40893 43.500599,-92.40892 43.500591,-92.408853 43.500554,-92.408759 43.50053,-92.408616 43.500524,-92.406555 43.50054,-92.406228 43.500543,-92.405959 43.500512,-92.40466 43.500518,-92.402362 43.500539,-92.400735 43.500538,-92.396296 43.500558,-92.395014 43.500565,-92.391775 43.500564,-92.388307 43.500486,-92.38781 43.500486,-92.387773 43.500486,-92.386601 43.500481,-92.386078 43.500504,-92.386019 43.500506,-92.384228 43.500589,-92.384065 43.500593,-92.384008 43.500595,-92.382653 43.500628,-92.381652 43.500643,-92.381278 43.500648,-92.381127 43.500645,-92.38042 43.500629,-92.380036 43.500622,-92.379948 43.500623,-92.379582 43.500623,-92.379289 43.500634,-92.378222 43.50067,-92.37796 43.500684,-92.377876 43.50069,-92.377828 43.500661,-92.377476 43.500633,-92.376803 43.500609,-92.376589 43.500603,-92.376194 43.500603,-92.37518 43.500623,-92.369057 43.500491,-92.368858 43.500519,-92.368032 43.500548,-92.366616 43.500546,-92.36631 43.500545,-92.36176 43.500541,-92.361281 43.50054,-92.35871 43.500537,-92.355731 43.500559,-92.352429 43.500584,-92.351275 43.500582,-92.349768 43.500606,-92.349383 43.500607,-92.34938 43.500607,-92.347494 43.500612,-92.34683 43.500604,-92.346811 43.500604,-92.346192 43.500596,-92.345492 43.500588,-92.343149 43.5006,-92.329381 43.500554,-92.329374 43.500553,-92.328613 43.500551,-92.327558 43.500542,-92.326344 43.500549,-92.325508 43.500553,-92.323193 43.500549,-92.320967 43.500538,-92.320451 43.500539,-92.318606 43.500543,-92.316282 43.500538,-92.316214 43.500538,-92.314296 43.500545,-92.312499 43.500541,-92.310125 43.500551,-92.309347 43.500549,-92.301706 43.500567,-92.301323 43.500564,-92.301187 43.500562,-92.29472 43.500555,-92.28939 43.500555,-92.28855 43.50058,-92.288185 43.500576,-92.288119 43.500576,-92.287322 43.50057,-92.286244 43.500573,-92.285067 43.500591,-92.282894 43.500597,-92.282099 43.500587,-92.279708 43.500599,-92.279473 43.5006,-92.27922 43.500594,-92.27907 43.50059,-92.27892 43.500582,-92.278896 43.500577,-92.278842 43.500565,-92.278778 43.500551,-92.278471 43.500443,-92.278464 43.50044,-92.277505 43.500466,-92.277498 43.500468,-92.277403 43.5005,-92.277212 43.500544,-92.277178 43.500548,-92.277023 43.500565,-92.276898 43.500579,-92.276858 43.500579,-92.275192 43.500593,-92.275019 43.500592,-92.27205 43.500585,-92.271699 43.500596,-92.271669 43.5006,-92.27162 43.500598,-92.271119 43.500582,-92.27024 43.500588,-92.269424 43.500593,-92.266586 43.50058,-92.264362 43.500588,-92.262145 43.500586,-92.261385 43.500588,-92.260896 43.50059,-92.25702 43.500593,-92.257018 43.500594,-92.255848 43.500598,-92.254146 43.500587,-92.252375 43.50061,-92.250977 43.500606,-92.250004 43.500617,-92.249945 43.500617,-92.249369 43.500615,-92.249353 43.500615,-92.247813 43.500611,-92.243719 43.500595,-92.241129 43.500599,-92.239329 43.500592,-92.239307 43.500592,-92.238203 43.500587,-92.237466 43.500582,-92.237314 43.50058,-92.23671 43.500577,-92.234549 43.500591,-92.232801 43.50058,-92.23119 43.500589,-92.231136 43.50059,-92.2307 43.500594,-92.22927 43.500592,-92.227861 43.500596,-92.227197 43.500604,-92.22678 43.500604,-92.226305 43.500603,-92.225956 43.500617,-92.225663 43.500633,-92.225306 43.500633,-92.224874 43.500613,-92.224693 43.500605,-92.224379 43.500601,-92.224169 43.50061,-92.224037 43.500627,-92.22389 43.500657,-92.223696 43.500723,-92.222514 43.500614,-92.2128 43.500525,-92.212735 43.500525,-92.208954 43.500518,-92.201511 43.500539,-92.20144 43.500559,-92.200699 43.500564,-92.200386 43.500572,-92.200242 43.500571,-92.199971 43.500559,-92.199609 43.500551,-92.199207 43.500547,-92.199023 43.500545,-92.198952 43.500544,-92.198875 43.500556,-92.182557 43.500677,-92.182517 43.500677,-92.178863 43.500713,-92.178723 43.500714,-92.1719 43.50078,-92.171899 43.500781,-92.171888 43.500778,-92.171807 43.500763,-92.171616 43.500735,-92.171355 43.500722,-92.171267 43.500718,-92.170091 43.500704,-92.169264 43.500713,-92.168706 43.500728,-92.16789 43.500731,-92.166118 43.500729,-92.16471 43.500743,-92.164145 43.500732,-92.163238 43.50073,-92.16313 43.500733,-92.162965 43.500738,-92.16235 43.500741,-92.159514 43.500725,-92.158845 43.500715,-92.158146 43.500722,-92.157158 43.500724,-92.15689 43.500718,-92.156538 43.500709,-92.156315 43.500704,-92.155701 43.50071,-92.15446 43.500719,-92.151798 43.500714,-92.150666 43.50072,-92.150135 43.500719,-92.149913 43.500727,-92.1499 43.500727,-92.147595 43.50079,-92.147548 43.500791,-92.140197 43.500776,-92.139994 43.500778,-92.139258 43.500782,-92.137138 43.500749,-92.136868 43.500733,-92.136736 43.500715,-92.136463 43.500699,-92.136155 43.5007,-92.134966 43.500701,-92.134439 43.500699,-92.132813 43.500694,-92.132077 43.500692,-92.130374 43.500667,-92.12985 43.500656,-92.129169 43.500665,-92.127838 43.500681,-92.127034 43.500677,-92.124906 43.500707,-92.124265 43.500715,-92.12262 43.500736,-92.11937 43.500779,-92.119243 43.500783,-92.118916 43.500792,-92.118674 43.500798,-92.118499 43.500821,-92.118489 43.50082,-92.117583 43.500806,-92.117376 43.500802,-92.103886 43.500735,-92.10124 43.500722,-92.101065 43.500721,-92.092871 43.500683,-92.092823 43.500683,-92.092391 43.500671,-92.09206 43.500674,-92.090828 43.500684,-92.089973 43.500683,-92.089478 43.500683,-92.087042 43.500697,-92.082925 43.50071,-92.082748 43.500728,-92.082684 43.500769,-92.081222 43.500674,-92.079802 43.500621,-92.079777 43.500636,-92.079469 43.500675,-92.07852 43.500693,-92.077428 43.500684,-92.076851 43.50068,-92.076255 43.50068,-92.074754 43.500731,-92.073968 43.500737,-92.072667 43.500758,-92.071646 43.500745,-92.067914 43.500758,-92.065552 43.500754,-92.062646 43.500771,-92.060569 43.500722,-92.060462 43.500719,-92.060107 43.500718,-92.060001 43.500717,-92.059314 43.500716,-92.058988 43.500711,-92.05886 43.500709,-92.058849 43.500708,-92.057973 43.500695,-92.056941 43.5007,-92.056517 43.500703,-92.055722 43.500718,-92.05415 43.50071,-92.053883 43.500708,-92.053508 43.500706,-92.053501 43.500705,-92.052295 43.5007,-92.051354 43.500718,-92.048969 43.5007,-92.048341 43.500712,-92.04829 43.500713,-92.048253 43.500714,-92.047247 43.500736,-92.042822 43.500711,-92.041213 43.500719,-92.037644 43.500668,-92.037016 43.500662,-92.035947 43.500687,-92.034642 43.500676,-92.032444 43.500637,-92.030688 43.500624,-92.030586 43.500624,-92.029845 43.500621,-92.029679 43.500622,-92.0296 43.500622,-92.02577 43.500638,-92.025008 43.500656,-92.024616 43.500656,-92.024576 43.500656,-92.024213 43.500657,-92.023262 43.500637,-92.021677 43.500642,-92.020136 43.500642,-92.018899 43.500673,-92.017114 43.500681,-92.017095 43.500681,-92.01684 43.500682,-92.015969 43.500656,-92.014479 43.500683,-92.013342 43.500674,-92.013171 43.500676,-92.012506 43.500686,-92.012368 43.500688,-92.012275 43.50069,-92.011151 43.500681,-92.011101 43.50068,-92.011093 43.500679,-92.0102 43.500668,-92.009689 43.500683,-92.00968 43.500683,-92.00934 43.500694,-92.006445 43.500723,-92.005055 43.500749,-92.003959 43.500748,-92.002046 43.500765,-92.000624 43.500758,-92.000083 43.500762,-91.99997 43.500763,-91.998647 43.50074,-91.996169 43.500722,-91.995624 43.500718,-91.991285 43.500687,-91.990863 43.500685,-91.990589 43.500683,-91.989923 43.500687,-91.98985 43.500687,-91.989841 43.500687,-91.989599 43.500688,-91.989577 43.500689,-91.988524 43.500691,-91.987773 43.500675,-91.985337 43.500678,-91.983872 43.500683,-91.98259 43.500672,-91.979335 43.50067,-91.978914 43.500668,-91.978092 43.500666,-91.976486 43.500681,-91.975676 43.500682,-91.974797 43.500682,-91.97322 43.500672,-91.971462 43.500645,-91.970713 43.500645,-91.970359 43.500645,-91.969928 43.500652,-91.969679 43.500655,-91.969639 43.500656,-91.969387 43.500654,-91.968418 43.500675,-91.967015 43.500669,-91.966086 43.500665,-91.962082 43.50067,-91.961928 43.50068,-91.961681 43.500689,-91.96132 43.500711,-91.960671 43.500719,-91.959574 43.500693,-91.958887 43.5007,-91.958567 43.500718,-91.957824 43.500732,-91.957376 43.500723,-91.957009 43.500715,-91.957008 43.500714,-91.956355 43.500693,-91.955574 43.500691,-91.954954 43.500678,-91.954383 43.500659,-91.953803 43.500658,-91.953245 43.500676,-91.952609 43.500679,-91.951935 43.500694,-91.951302 43.500686,-91.9505 43.500673,-91.950264 43.500667,-91.95005 43.500672,-91.95001 43.500674,-91.947548 43.500504,-91.947543 43.500504,-91.941701 43.500705,-91.9417 43.500705,-91.94171 43.500716,-91.941595 43.500703,-91.941265 43.500692,-91.940642 43.500705,-91.940393 43.500702,-91.940385 43.500701,-91.939155 43.50069,-91.938072 43.500699,-91.936704 43.500705,-91.934309 43.500694,-91.930994 43.500716,-91.930795 43.500717,-91.93074 43.500713,-91.930695 43.500711,-91.930499 43.500699,-91.930194 43.500639,-91.930043 43.500895,-91.929845 43.500825,-91.929644 43.500762,-91.92939 43.500734,-91.929186 43.500733,-91.928715 43.500728,-91.922328 43.500765,-91.921429 43.500783,-91.921279 43.500783,-91.920746 43.500782,-91.919506 43.500794,-91.918487 43.500791,-91.917557 43.500793,-91.917396 43.500794,-91.915063 43.500801,-91.914287 43.500799,-91.91331 43.500818,-91.911801 43.500807,-91.911035 43.500815,-91.91071 43.500817,-91.909918 43.500819,-91.90972 43.500819,-91.909708 43.500819,-91.908596 43.500803,-91.908144 43.500797,-91.906802 43.500796,-91.905887 43.500803,-91.905587 43.500799,-91.90328 43.500772,-91.901058 43.500768,-91.899426 43.50075,-91.897334 43.500749,-91.895946 43.500742,-91.894177 43.500727,-91.892278 43.50073,-91.890218 43.500744,-91.889963 43.500743,-91.88982 43.500743,-91.889816 43.500743,-91.88801 43.500742,-91.887626 43.500741,-91.883156 43.500741,-91.881628 43.50076,-91.878468 43.500752,-91.87826 43.500751,-91.87487 43.500742,-91.873325 43.500731,-91.871121 43.500724,-91.87088 43.500713,-91.870643 43.500728,-91.87045 43.500776,-91.870278 43.50084,-91.870238 43.500861,-91.8702 43.500848,-91.870011 43.500787,-91.86978 43.500752,-91.869558 43.500731,-91.869305 43.500719,-91.868244 43.500709,-91.866153 43.500721,-91.863916 43.500715,-91.862172 43.500735,-91.851188 43.500733,-91.850941 43.500719,-91.84986 43.50074,-91.8497 43.50074,-91.8497 43.500741,-91.8497 43.500742,-91.848686 43.500758,-91.846408 43.500753,-91.846386 43.500752,-91.844793 43.500749,-91.842748 43.500782,-91.837725 43.500774,-91.836378 43.50079,-91.836117 43.500789,-91.83595 43.500788,-91.834974 43.500782,-91.830666 43.500731,-91.830608 43.500729,-91.83022 43.500751,-91.830089 43.500758,-91.829682 43.500732,-91.828112 43.50074,-91.828025 43.50074,-91.825303 43.500755,-91.825054 43.50074,-91.824969 43.500729,-91.824949 43.500684,-91.820262 43.500688,-91.820092 43.500688,-91.815625 43.500673,-91.811008 43.500659,-91.807175 43.500647,-91.807093 43.500678,-91.807002 43.500703,-91.806924 43.500716,-91.806827 43.500726,-91.806809 43.500728,-91.80651 43.500735,-91.806312 43.500733,-91.806015 43.500722,-91.805718 43.500699,-91.80562 43.500699,-91.805577 43.500704,-91.798876 43.500688,-91.798844 43.500688,-91.790616 43.5007,-91.782494 43.500712,-91.782124 43.500723,-91.778969 43.500809,-91.77892 43.500809,-91.778914 43.500809,-91.778802 43.500811,-91.778518 43.500827,-91.778221 43.500844,-91.777526 43.500842,-91.777161 43.50083,-91.777002 43.500794,-91.776876 43.500707,-91.761252 43.500829,-91.760797 43.500802,-91.760017 43.500801,-91.759261 43.500782,-91.758876 43.500777,-91.758608 43.500774,-91.758606 43.500774,-91.756934 43.500753,-91.756812 43.500751,-91.754728 43.500725,-91.753756 43.500733,-91.752901 43.500717,-91.749998 43.500696,-91.749302 43.500702,-91.748348 43.5007,-91.746319 43.500716,-91.745681 43.500722,-91.741754 43.500735,-91.741323 43.500743,-91.740479 43.500746,-91.739618 43.500743,-91.738637 43.500751,-91.737529 43.500761,-91.737398 43.500756,-91.737321 43.500739,-91.73726 43.500699,-91.737226 43.500655,-91.737217 43.500548,-91.736558 43.500561,-91.73333 43.500623,-91.7314 43.50066,-91.730879 43.500711,-91.730487 43.50075,-91.73033 43.500769,-91.730217 43.500806,-91.730196 43.500795,-91.730095 43.500753,-91.730068 43.500745,-91.730041 43.500737,-91.729967 43.500736,-91.72568 43.500746,-91.725461 43.500744,-91.720531 43.500695,-91.716017 43.500721,-91.715533 43.500719,-91.715288 43.500722,-91.711846 43.500761,-91.700717 43.500704,-91.680517 43.500631,-91.675275 43.50058,-91.670808 43.500598,-91.663398 43.500628,-91.663364 43.500628,-91.662242 43.500611,-91.662234 43.500611,-91.661723 43.500603,-91.660844 43.50056,-91.658394 43.500532,-91.656019 43.500506,-91.655847 43.500504,-91.651397 43.500454,-91.65074 43.500462,-91.65052 43.500501,-91.650032 43.500538,-91.649537 43.500532,-91.648948 43.500534,-91.648519 43.500544,-91.648452 43.500542,-91.647692 43.500559,-91.646744 43.500562,-91.645711 43.500555,-91.645106 43.500551,-91.645022 43.500564,-91.644942 43.500577,-91.644853 43.50062,-91.644788 43.500652,-91.644603 43.500643,-91.644456 43.500636,-91.643804 43.500638,-91.643263 43.500612,-91.642966 43.500588,-91.642821 43.500539,-91.642704 43.500539,-91.640866 43.500547,-91.640758 43.500563,-91.640678 43.500548,-91.640419 43.500552,-91.640334 43.500554,-91.639681 43.500573,-91.635626 43.500463,-91.634495 43.50044,-91.634369 43.500437,-91.634367 43.500459,-91.634366 43.500481,-91.634244 43.500479,-91.632178 43.500441,-91.631363 43.500481,-91.628625 43.500617,-91.625611 43.500727,-91.625478 43.500704,-91.625145 43.500707,-91.621114 43.500679,-91.620899 43.500678,-91.620225 43.500679,-91.617551 43.500688,-91.617394 43.500628,-91.617276 43.500615,-91.617199 43.500632,-91.617114 43.500663,-91.61578 43.500672,-91.615646 43.500651,-91.61559 43.500642,-91.615519 43.500636,-91.615145 43.500628,-91.614202 43.500621,-91.613181 43.500632,-91.610835 43.500657,-91.610429 43.500679,-91.608269 43.500669,-91.60562 43.500663,-91.603088 43.500671,-91.59446 43.500668,-91.591682 43.50067,-91.591428 43.500671,-91.59098 43.50068,-91.5897 43.500656,-91.573642 43.500554,-91.571002 43.500538,-91.570817 43.500537,-91.570263 43.500537,-91.570079 43.500537,-91.569047 43.500537,-91.565954 43.500537,-91.564923 43.500537,-91.563753 43.500537,-91.560245 43.500537,-91.559076 43.500538,-91.551043 43.500668,-91.550693 43.500675,-91.549274 43.50069,-91.546324 43.500684,-91.545258 43.500686,-91.542352 43.500692,-91.541558 43.500684,-91.533806 43.50056,-91.532847 43.500568,-91.529973 43.500594,-91.529015 43.500604,-91.527462 43.500605,-91.522803 43.500611,-91.521788 43.500613,-91.52125 43.500613,-91.521218 43.500613,-91.521122 43.500613,-91.521091 43.500614,-91.520394 43.500614,-91.518306 43.500616,-91.51761 43.500618,-91.51487 43.500621,-91.506649 43.500631,-91.50391 43.500635,-91.50014 43.50064,-91.499092 43.500659,-91.493896 43.500754,-91.493832 43.500755,-91.493522 43.500777,-91.49104 43.500714,-91.490612 43.500703,-91.48537 43.500704,-91.484196 43.500704,-91.482559 43.500697,-91.480499 43.500689,-91.480106 43.500687,-91.47948 43.500684,-91.479462 43.500684,-91.479452 43.500684,-91.475036 43.500624,-91.471954 43.500685,-91.471895 43.500686,-91.469097 43.500726,-91.465349 43.500686,-91.465287 43.500686,-91.465268 43.500684,-91.464667 43.500612,-91.464014 43.500617,-91.462055 43.500635,-91.461403 43.500642,-91.460591 43.500639,-91.458157 43.50063,-91.457346 43.500628,-91.455647 43.500621,-91.450552 43.500603,-91.448854 43.500598,-91.448219 43.500605,-91.446318 43.500626,-91.445684 43.500633,-91.445642 43.500633,-91.445516 43.500633,-91.445475 43.500633,-91.444766 43.500632,-91.442641 43.500629,-91.442385 43.500629,-91.442164 43.500633,-91.441934 43.500618,-91.441872 43.500629,-91.441162 43.50063,-91.438843 43.500635,-91.438071 43.500637,-91.438035 43.500638,-91.437984 43.500641,-91.43793 43.500643,-91.437895 43.500645,-91.436624 43.500701,-91.436545 43.500705,-91.432808 43.500719,-91.431536 43.500724,-91.429618 43.500732,-91.423866 43.500759,-91.421949 43.500768,-91.419972 43.500776,-91.416064 43.500793,-91.414041 43.5008,-91.412064 43.500808,-91.411155 43.500811,-91.408429 43.500821,-91.407521 43.500825,-91.406908 43.500827,-91.405071 43.500834,-91.404625 43.500836,-91.404459 43.500837,-91.403368 43.500844,-91.400096 43.500869,-91.399006 43.500877,-91.398456 43.500881,-91.397581 43.500885,-91.397319 43.500887,-91.393308 43.500805,-91.391884 43.500777,-91.390655 43.500752,-91.386968 43.500678,-91.38589 43.500657,-91.385739 43.500656,-91.383917 43.500624,-91.378451 43.500531,-91.376629 43.500501,-91.375136 43.500596,-91.372672 43.500577,-91.372029 43.500773,-91.371786 43.500837,-91.371716 43.500856,-91.371542 43.500925,-91.371256 43.500837,-91.369325 43.500827,-91.367422 43.500819,-91.361713 43.500796,-91.35981 43.500789,-91.359742 43.500788,-91.359538 43.500788,-91.359471 43.500788,-91.35915 43.500786,-91.352583 43.500754,-91.352329 43.500753,-91.342974 43.500704,-91.336052 43.500721,-91.331679 43.500731,-91.331163 43.500732,-91.329618 43.500735,-91.329103 43.500737,-91.32907 43.500737,-91.328974 43.500737,-91.328942 43.500737,-91.328908 43.500737,-91.328858 43.500738,-91.328808 43.500738,-91.328775 43.500738,-91.327711 43.50074,-91.324519 43.500747,-91.323456 43.50075,-91.323287 43.50075,-91.322781 43.500752,-91.322613 43.500753,-91.317025 43.500771,-91.300262 43.500825,-91.295077 43.500842,-91.294675 43.500837,-91.294156 43.50083,-91.29356 43.500822,-91.292599 43.500827,-91.29208 43.500831,-91.290606 43.50084,-91.286187 43.50087,-91.284714 43.500881,-91.284651 43.50088,-91.284463 43.500879,-91.284401 43.500879,-91.284271 43.500878,-91.283883 43.500876,-91.283754 43.500876,-91.282878 43.500873,-91.282695 43.500872,-91.282652 43.500871,-91.282523 43.500871,-91.282481 43.500871,-91.280282 43.500877,-91.273688 43.500896,-91.27149 43.500903,-91.271481 43.500903,-91.271465 43.500903,-91.271454 43.500903,-91.271446 43.500903,-91.271339 43.500903,-91.271223 43.500904,-91.271018 43.500905,-91.270912 43.500906,-91.270378 43.500908,-91.268777 43.500916,-91.268244 43.50092,-91.268199 43.50092,-91.268189 43.50092,-91.268025 43.500921,-91.267971 43.500922,-91.267916 43.500922,-91.267834 43.500923,-91.267751 43.500923,-91.267696 43.500923,-91.266534 43.500937,-91.263048 43.500978,-91.261887 43.500993,-91.261852 43.500993,-91.261781 43.500993,-91.261749 43.500994,-91.261715 43.500996,-91.261499 43.501004,-91.261283 43.501013,-91.261184 43.501015,-91.25748 43.500984,-91.253803 43.500901,-91.253729 43.500899,-91.253623 43.500897,-91.25351 43.500894,-91.253437 43.500893,-91.253418 43.50089,-91.253246 43.500865,-91.252673 43.500785,-91.252482 43.500759,-91.252101 43.50074,-91.251812 43.500747,-91.250132 43.50079,-91.249814 43.500697,-91.249353 43.500562,-91.249166 43.500532,-91.248933 43.500527,-91.248586 43.500522,-91.248237 43.500515,-91.248005 43.500511,-91.247728 43.500505,-91.246899 43.50049,-91.246623 43.500485,-91.246522 43.500486,-91.246218 43.500489,-91.246118 43.500491,-91.246016 43.500491,-91.245892 43.500491,-91.245712 43.500491,-91.245611 43.500492,-91.245381 43.500492,-91.24469 43.500494,-91.244461 43.500495,-91.244349 43.500494,-91.244182 43.500494,-91.244015 43.500494,-91.243904 43.500494,-91.243862 43.500493,-91.243799 43.500492,-91.243736 43.500491,-91.243694 43.500491,-91.24351 43.500488,-91.242958 43.500479,-91.242774 43.500476,-91.242615 43.500473,-91.242382 43.50047,-91.242138 43.50047,-91.241979 43.50047,-91.24168 43.500471,-91.241629 43.500471,-91.240582 43.500476,-91.240234 43.500479,-91.239778 43.50048,-91.238412 43.500485,-91.237957 43.500487,-91.236414 43.500491,-91.231786 43.500504,-91.230244 43.500509,-91.229982 43.50051,-91.229197 43.500513,-91.228936 43.500515,-91.228832 43.500516,-91.228519 43.50052,-91.228416 43.500522,-91.228187 43.500515,-91.227679 43.500559,-91.227589 43.500564,-91.227045 43.500562,-91.227026 43.500563,-91.226188 43.500558,-91.225967 43.500556,-91.225479 43.500553,-91.225094 43.50055,-91.224503 43.500543,-91.224473 43.500543,-91.223507 43.50054,-91.22273 43.50055,-91.222371 43.500555,-91.22214 43.500555,-91.22197 43.500555,-91.221716 43.500556,-91.221462 43.500556,-91.221293 43.500557,-91.220995 43.500557,-91.220102 43.500557,-91.219805 43.500557,-91.21945 43.500556,-91.218921 43.500555,-91.218388 43.500552,-91.218035 43.500551,-91.217969 43.50055,-91.21787 43.50055,-91.217771 43.50055,-91.217706 43.50055,-91.21774 43.500401,-91.217839 43.499973,-91.217841 43.499954,-91.217858 43.499803,-91.218008 43.498863,-91.218026 43.498752,-91.218194 43.497701,-91.21827 43.497228,-91.218247 43.497012,-91.218146 43.49605,-91.218144 43.496035,-91.218044 43.495089,-91.218022 43.494879,-91.217956 43.494252,-91.217934 43.494043,-91.217777 43.49255,-91.217615 43.491008,-91.216474 43.488287,-91.216314 43.487905,-91.215925 43.486979,-91.215902 43.486901,-91.215282 43.484798,-91.215508 43.4837,-91.216035 43.481142,-91.216202 43.480764,-91.216676 43.479697,-91.220399 43.471306,-91.223054 43.467641,-91.224586 43.465525,-91.22582 43.464626,-91.226464 43.464158,-91.229503 43.462607,-91.231051 43.461144,-91.232241 43.460018,-91.233187 43.457784,-91.233367 43.455168,-91.233255 43.454735,-91.23323 43.45464,-91.233205 43.454544,-91.232966 43.453618,-91.232802 43.452983,-91.232727 43.452693,-91.232682 43.452522,-91.232638 43.45235,-91.232571 43.452091,-91.232504 43.451832,-91.232276 43.450952,-91.231813 43.45024,-91.23083 43.448732,-91.229848 43.447223,-91.22875 43.445537,-91.223314 43.440179,-91.222734 43.439607,-91.222154 43.439035,-91.22135 43.438242,-91.220546 43.43745,-91.220425 43.437331,-91.218401 43.434946,-91.218182 43.434688,-91.21571 43.432795,-91.213575 43.431159,-91.209049 43.426845,-91.209017 43.426814,-91.208288 43.42612,-91.207145 43.425031,-91.206188 43.423782,-91.20555 43.422949,-91.203144 43.419805,-91.202828 43.419163,-91.202182 43.417852,-91.201537 43.41654,-91.201224 43.415903,-91.200841 43.414486,-91.200359 43.412701,-91.200527 43.408486,-91.199568 43.403812,-91.199561 43.403779,-91.199408 43.403032,-91.198986 43.401851,-91.198962 43.401785,-91.198939 43.401718,-91.198579 43.40071,-91.198219 43.399702,-91.198048 43.399223,-91.197804 43.396708,-91.19767 43.395334,-91.197934 43.394204,-91.198238 43.3929,-91.198542 43.391595,-91.198953 43.389835,-91.199222 43.389235,-91.199283 43.389098,-91.199344 43.388962,-91.19942 43.388792,-91.199497 43.388621,-91.199605 43.388378,-91.199714 43.388134,-91.199741 43.388074,-91.200701 43.38593,-91.201843 43.383983,-91.204831 43.378887,-91.205053 43.378186,-91.205346 43.377262,-91.205679 43.376059,-91.205878 43.375338,-91.206072 43.374976,-91.206165 43.374888,-91.206797 43.374289,-91.207352 43.373676,-91.207367 43.373659,-91.207417 43.373632,-91.208641 43.372971,-91.210233 43.372064,-91.212044 43.371035,-91.212777 43.370512,-91.21336 43.370097,-91.214172 43.369378,-91.214499 43.369033,-91.21473 43.368788,-91.21499 43.368006,-91.215056 43.367185,-91.215062 43.367105,-91.214971 43.366389,-91.21477 43.365874,-91.214453 43.365398,-91.214451 43.365394,-91.213274 43.363628,-91.210497 43.359457,-91.210256 43.359002,-91.209108 43.356838,-91.208646 43.355998,-91.208517 43.355763,-91.208388 43.355529,-91.207574 43.35405,-91.206682 43.352623,-91.20662 43.352524,-91.206601 43.352505,-91.205325 43.351184,-91.20465 43.350478,-91.203964 43.349852,-91.202795 43.349437,-91.20234 43.349277,-91.201847 43.349103,-91.198128 43.348699,-91.194408 43.348296,-91.194274 43.348282,-91.194139 43.348267,-91.188014 43.347602,-91.187595 43.347522,-91.187392 43.347483,-91.187189 43.347445,-91.18666 43.347344,-91.186132 43.347243,-91.185524 43.347127,-91.185474 43.347113,-91.182603 43.346308,-91.181115 43.345926,-91.17935 43.34507,-91.176773 43.34377,-91.175114 43.342934,-91.171493 43.341179,-91.171055 43.340967,-91.169782 43.340512,-91.168288 43.339977,-91.163328 43.338277,-91.154806 43.334826,-91.143678 43.331639,-91.140366 43.330655,-91.140222 43.330612,-91.140077 43.330569,-91.139914 43.33052,-91.13975 43.330472,-91.139546 43.330412,-91.139342 43.330351,-91.137343 43.329757,-91.132813 43.32803,-91.129121 43.32635,-91.127025 43.325076,-91.125129 43.323898,-91.124398 43.323438,-91.122684 43.32236,-91.12097 43.321282,-91.120496 43.321002,-91.120021 43.320723,-91.119959 43.320686,-91.118964 43.3201,-91.11797 43.319514,-91.117661 43.319332,-91.109936 43.315148,-91.109846 43.315099,-91.109755 43.31505,-91.108384 43.314308,-91.107237 43.313645,-91.106579 43.312959,-91.105201 43.311522,-91.102668 43.308934,-91.100283 43.30677,-91.09995 43.306467,-91.098037 43.304182,-91.097769 43.303862,-91.096485 43.302371,-91.095303 43.301264,-91.089124 43.295476,-91.086371 43.292617,-91.085652 43.29187,-91.084309 43.289495,-91.083811 43.288597,-91.083302 43.287678,-91.082792 43.286758,-91.082099 43.285507,-91.081434 43.28469,-91.079875 43.282773,-91.078259 43.280776,-91.077111 43.279177,-91.075679 43.277183,-91.07461 43.27586,-91.07371 43.274746,-91.071724 43.271392,-91.071693 43.26976,-91.071574 43.268193,-91.07193 43.267051,-91.07234 43.265747,-91.072782 43.264363,-91.072863 43.263149,-91.072649 43.262129,-91.071698 43.261014,-91.069937 43.260272,-91.068474 43.259979,-91.067077 43.26011,-91.065456 43.260262,-91.061798 43.259952,-91.05975 43.259074,-91.058644 43.257679,-91.057918 43.255366,-91.057917 43.25524,-91.057914 43.254604,-91.05791 43.253968,-91.059118 43.249979,-91.059684 43.248566,-91.061696 43.244791,-91.061723 43.24474,-91.062132 43.243972,-91.062541 43.243204,-91.062562 43.243165,-91.064438 43.241271,-91.066398 43.239293,-91.067389 43.238543,-91.071857 43.235164,-91.074216 43.232969,-91.079278 43.228259,-91.079573 43.22803,-91.079792 43.227859,-91.080012 43.227688,-91.087456 43.221891,-91.095445 43.216049,-91.096004 43.21564,-91.096562 43.215232,-91.097536 43.21452,-91.097903 43.214252,-91.100436 43.212314,-91.10608 43.207994,-91.10646 43.207704,-91.106839 43.207414,-91.107931 43.206578,-91.109425 43.205635,-91.111198 43.204516,-91.112971 43.203398,-91.113749 43.202908,-91.114281 43.202656,-91.114662 43.202476,-91.115043 43.202295,-91.117057 43.201341,-91.119071 43.200387,-91.119115 43.200366,-91.120391 43.199066,-91.120874 43.198574,-91.121356 43.198083,-91.12217 43.197255,-91.123896 43.193536,-91.124015 43.192277,-91.124217 43.190141,-91.124428 43.187886,-91.124453 43.18786,-91.125129 43.187181,-91.127698 43.183702,-91.134173 43.174405,-91.134364 43.174297,-91.135917 43.173422,-91.138649 43.169993,-91.139002 43.169316,-91.139212 43.168914,-91.139421 43.168513,-91.139692 43.167994,-91.139964 43.167475,-91.139991 43.167422,-91.14116 43.164094,-91.141356 43.163537,-91.141491 43.163037,-91.141662 43.162402,-91.141834 43.161768,-91.142082 43.160853,-91.142329 43.159938,-91.142381 43.159747,-91.142433 43.159557,-91.142504 43.159296,-91.142574 43.159035,-91.142645 43.158772,-91.142716 43.158509,-91.143283 43.156413,-91.144647 43.154539,-91.144972 43.154093,-91.145297 43.153646,-91.145601 43.153228,-91.145905 43.152811,-91.146018 43.152654,-91.1462 43.152405,-91.155859 43.143268,-91.1562 43.142945,-91.160449 43.140575,-91.163576 43.139444,-91.165016 43.138924,-91.169557 43.137618,-91.170372 43.137384,-91.173873 43.135434,-91.175253 43.134665,-91.175394 43.134438,-91.177003 43.131846,-91.177932 43.128875,-91.178251 43.124982,-91.178081 43.124043,-91.178034 43.122379,-91.178018 43.122185,-91.177873 43.120459,-91.177728 43.118733,-91.17772 43.118627,-91.177477 43.117301,-91.177363 43.116498,-91.177243 43.115654,-91.176688 43.111926,-91.176067 43.108326,-91.17567 43.106776,-91.175382 43.10535,-91.175305 43.104968,-91.175193 43.103771,-91.175311 43.102333,-91.175331 43.101248,-91.175471 43.099745,-91.175634 43.09882,-91.175751 43.097181,-91.176021 43.094938,-91.176269 43.092447,-91.17631 43.090743,-91.176307 43.089377,-91.176449 43.088201,-91.176523 43.087584,-91.176889 43.08559,-91.176914 43.085455,-91.177117 43.082026,-91.177169 43.081136,-91.177222 43.080247,-91.177242 43.07893,-91.177236 43.075956,-91.177264 43.072983,-91.177427 43.07242,-91.177832 43.071961,-91.178761 43.070578,-91.179132 43.069637,-91.179382 43.068624,-91.179457 43.067427,-91.17929 43.06643,-91.178982 43.065925,-91.178202 43.064841,-91.177894 43.064206,-91.178087 43.062044,-91.177177 43.055705,-91.176744 43.052523,-91.176608 43.051502,-91.176388 43.04984,-91.176124 43.048107,-91.175658 43.045027,-91.175525 43.044008,-91.175525 43.044004,-91.175395 43.043028,-91.175167 43.041267,-91.174943 43.040063,-91.174692 43.038713,-91.174408 43.038001,-91.174255 43.037619,-91.174208 43.0375,-91.173504 43.035966,-91.172656 43.033468,-91.171873 43.03076,-91.171365 43.028366,-91.170923 43.026052,-91.170718 43.025414,-91.170182 43.023768,-91.169572 43.022153,-91.168722 43.02023,-91.168171 43.019206,-91.167886 43.018679,-91.166997 43.0168,-91.166796 43.016289,-91.166781 43.016251,-91.166726 43.01611,-91.16667 43.01597,-91.166007 43.014286,-91.165202 43.012156,-91.165039 43.011723,-91.164456 43.009988,-91.163246 43.006478,-91.163192 43.006334,-91.162155 43.003561,-91.161118 43.000788,-91.159364 42.996674,-91.158283 42.993675,-91.15749 42.991475,-91.156812 42.98817,-91.156743 42.98783,-91.1568 42.985939,-91.156803 42.985843,-91.156805 42.985775,-91.156806 42.985755,-91.156807 42.985712,-91.156818 42.985346,-91.156829 42.984975,-91.156869 42.983657,-91.156875 42.98282,-91.156892 42.980896,-91.156893 42.980815,-91.156562 42.978226,-91.155519 42.975774,-91.155248 42.975456,-91.153416 42.973303,-91.150906 42.970514,-91.149885 42.969036,-91.149303 42.968192,-91.149122 42.967909,-91.148001 42.966155,-91.147122 42.964454,-91.14655 42.963345,-91.146395 42.962696,-91.146198 42.961871,-91.146003 42.961053,-91.145935 42.96077,-91.14543 42.958211,-91.145488 42.957299,-91.145534 42.956601,-91.14554 42.95651,-91.146528 42.953519,-91.147822 42.949961,-91.14909 42.946554,-91.149555 42.944499,-91.149701 42.943855,-91.14988 42.941955,-91.149784 42.940244,-91.148448 42.937162,-91.147955 42.936134,-91.146939 42.934015,-91.145743 42.930957,-91.145517 42.930378,-91.145165 42.929271,-91.144315 42.926592,-91.144305 42.926517,-91.14425 42.926126,-91.144196 42.925736,-91.144136 42.925301,-91.144075 42.924863,-91.1438 42.922877,-91.143878 42.920646,-91.144287 42.919265,-91.144627 42.918117,-91.144656 42.918043,-91.144755 42.917792,-91.144855 42.917538,-91.145308 42.916388,-91.145761 42.915239,-91.145868 42.914967,-91.145933 42.914421,-91.146182 42.912338,-91.146181 42.911935,-91.146203 42.909868,-91.145615 42.908006,-91.144794 42.905997,-91.143491 42.904698,-91.142221 42.904484,-91.140951 42.904271,-91.140524 42.904199,-91.139427 42.904015,-91.138308 42.903827,-91.138011 42.903777,-91.137699 42.90365,-91.137386 42.903523,-91.132928 42.901713,-91.132802 42.901662,-91.132682 42.901613,-91.132563 42.901565,-91.132281 42.90145,-91.131436 42.901107,-91.131155 42.900993,-91.130937 42.9009,-91.130368 42.900658,-91.130281 42.900631,-91.130055 42.900562,-91.129069 42.900259,-91.126114 42.899352,-91.125129 42.89905,-91.123156 42.898277,-91.120369 42.897187,-91.1184 42.896288,-91.118218 42.896205,-91.118035 42.896122,-91.117741 42.895988,-91.117628 42.895936,-91.117521 42.895887,-91.117411 42.895837,-91.117317 42.895779,-91.117305 42.895772,-91.117186 42.895699,-91.11707 42.895628,-91.116816 42.895472,-91.116164 42.895072,-91.115512 42.894672,-91.114871 42.893939,-91.11462 42.893652,-91.114531 42.893562,-91.114206 42.893231,-91.113182 42.89219,-91.11284 42.891842,-91.112158 42.891149,-91.11115 42.890435,-91.108129 42.888294,-91.107123 42.887581,-91.107111 42.887575,-91.107078 42.887557,-91.107067 42.887551,-91.105659 42.886813,-91.104051 42.885971,-91.101825 42.884033,-91.101038 42.883348,-91.100565 42.883078,-91.100471 42.882833,-91.100374 42.882581,-91.099472 42.88023,-91.09882 42.878528,-91.098238 42.875798,-91.098554 42.872588,-91.098676 42.871345,-91.098681 42.871286,-91.098796 42.870129,-91.09882 42.869881,-91.09882 42.868244,-91.09882 42.866868,-91.09882 42.865627,-91.09882 42.865492,-91.09882 42.864421,-91.097656 42.859871,-91.096768 42.858136,-91.096057 42.856746,-91.095817 42.856276,-91.095577 42.855807,-91.095329 42.85532,-91.094571 42.854431,-91.094162 42.853951,-91.09388 42.853621,-91.093591 42.853282,-91.093493 42.853167,-91.093389 42.853045,-91.092848 42.852411,-91.092307 42.851777,-91.091837 42.851225,-91.091613 42.85052,-91.091555 42.85034,-91.091402 42.84986,-91.091586 42.848664,-91.091885 42.847566,-91.091887 42.847558,-91.092183 42.846475,-91.092628 42.844844,-91.092792 42.844242,-91.092985 42.843536,-91.093094 42.843137,-91.093939 42.840042,-91.093939 42.840039,-91.094511 42.837571,-91.094942 42.835708,-91.095114 42.834966,-91.094855 42.833944,-91.094718 42.833404,-91.09463 42.833059,-91.094542 42.832711,-91.094383 42.832086,-91.094224 42.83146,-91.094085 42.830911,-91.09406 42.830813,-91.093934 42.830754,-91.091064 42.829411,-91.091023 42.829403,-91.090807 42.829362,-91.090159 42.829241,-91.090136 42.829237,-91.089942 42.829263,\
-91.08958 42.829314,-91.089219 42.829362,-91.088818 42.829417,-91.088752 42.829425,-91.087377 42.829614,-91.085718 42.829908,-91.085189 42.829928,-91.084158 42.829969,-91.08399 42.82997,-91.083466 42.829973,-91.08316 42.829975,-91.082947 42.829976,-91.082827 42.829977,-91.08277 42.829977,-91.082525 42.829888,-91.082205 42.829772,-91.082032 42.829602,-91.082009 42.82958,-91.081706 42.829283,-91.081619 42.829236,-91.081357 42.829093,-91.081352 42.829091,-91.081056 42.828931,-91.08077 42.828776,-91.08057 42.828668,-91.080549 42.828657,-91.080309 42.828527,-91.07998 42.828357,-91.078993 42.827847,-91.078665 42.827678,-91.078678 42.826563,-91.078757 42.826184,-91.078959 42.825222,-91.078969 42.825156,-91.07932 42.822977,-91.079314 42.820309,-91.079155 42.817534,-91.079153 42.817497,-91.078894 42.814996,-91.0787 42.813115,-91.078605 42.811441,-91.078587 42.811132,-91.078586 42.811109,-91.078569 42.809626,-91.078377 42.808668,-91.078233 42.807976,-91.078097 42.806526,-91.077643 42.803798,-91.076742 42.800525,-91.07656 42.799723,-91.076171 42.798007,-91.075616 42.795965,-91.075481 42.795466,-91.075443 42.795391,-91.074636 42.793784,-91.074367 42.793248,-91.074337 42.793187,-91.074219 42.792698,-91.073947 42.791562,-91.073867 42.791024,-91.073785 42.79046,-91.07327 42.789191,-91.072447 42.787732,-91.072159 42.786849,-91.072008 42.786382,-91.071938 42.785568,-91.071948 42.784899,-91.071972 42.784455,-91.071911 42.784085,-91.071553 42.783588,-91.071138 42.783004,-91.07083 42.782225,-91.070864 42.781168,-91.07091 42.780096,-91.070724 42.778283,-91.070614 42.777083,-91.070716 42.775502,-91.070725 42.775288,-91.070747 42.774817,-91.070303 42.773829,-91.070202 42.773341,-91.07016 42.773137,-91.069913 42.771575,-91.069879 42.77145,-91.06955 42.770224,-91.069549 42.769628,-91.069369 42.769283,-91.069282 42.769199,-91.068359 42.768309,-91.066477 42.766872,-91.065938 42.766461,-91.064571 42.765063,-91.063254 42.763947,-91.062305 42.763335,-91.061361 42.762973,-91.060676 42.762447,-91.060261 42.761847,-91.060129 42.759986,-91.060471 42.759174,-91.06062 42.75882,-91.061432 42.757974,-91.062271 42.757509,-91.062306 42.75749,-91.06312 42.757273,-91.063894 42.757282,-91.064493 42.757276,-91.064896 42.757272,-91.065265 42.757212,-91.065492 42.757081,-91.065606 42.756766,-91.065577 42.755677,-91.065574 42.755564,-91.06557 42.755396,-91.065789 42.754297,-91.065814 42.753895,-91.065783 42.753387,-91.065422 42.752133,-91.065059 42.751338,-91.064711 42.750949,-91.06468 42.750914,-91.063781 42.750568,-91.06286 42.750541,-91.062309 42.750526,-91.061324 42.750566,-91.061013 42.750578,-91.060172 42.750481,-91.060113 42.750447,-91.059314 42.749991,-91.059402 42.749991,-91.059487 42.749991,-91.059491 42.749991,-91.059835 42.749991,-91.060006 42.749991,-91.060179 42.749991,-91.059509 42.749751,-91.059333 42.749689,-91.058486 42.749387,-91.058091 42.749246,-91.057787 42.748924,-91.05766 42.748789,-91.05748 42.748598,-91.057173 42.748272,-91.056297 42.747341,-91.055867 42.746777,-91.05577 42.74665,-91.055674 42.746523,-91.055127 42.745806,-91.054967 42.745241,-91.05481 42.744686,-91.054834 42.743494,-91.054812 42.742335,-91.054798 42.741628,-91.054797 42.74152,-91.054801 42.740641,-91.054801 42.740529,-91.054467 42.739288,-91.053733 42.738238,-91.052226 42.737396,-91.051275 42.737001,-91.050203 42.736922,-91.049972 42.736905,-91.048 42.736912,-91.046953 42.737099,-91.046571 42.737167,-91.046279 42.737402,-91.046028 42.737604,-91.045625 42.737866,-91.044881 42.738349,-91.044455 42.738496,-91.044139 42.738605,-91.042199 42.738605,-91.040529 42.73853,-91.039383 42.738478,-91.037464 42.738068,-91.036556 42.737745,-91.035986 42.737542,-91.035418 42.73734,-91.03539 42.737322,-91.033389 42.736025,-91.032013 42.734484,-91.030984 42.73255,-91.030956 42.7324,-91.030724 42.731158,-91.030718 42.729684,-91.030638 42.729476,-91.030225 42.72839,-91.029692 42.726774,-91.028713 42.725614,-91.026786 42.724228,-91.024852 42.723439,-91.024821 42.723421,-91.022243 42.721968,-91.021755 42.721693,-91.021394 42.721523,-91.018793 42.720297,-91.017926 42.719889,-91.017393 42.719638,-91.017239 42.719566,-91.016949 42.719503,-91.015687 42.719229,-91.015682 42.719229,-91.015101 42.71932,-91.014085 42.719479,-91.011829 42.71997,-91.010668 42.720246,-91.010572 42.720269,-91.009577 42.720123,-91.007663 42.71939,-91.004267 42.717983,-91.001898 42.716956,-91.000128 42.716189,-90.995536 42.713704,-90.994158 42.712788,-90.992233 42.711508,-90.992096 42.711398,-90.990865 42.710407,-90.989634 42.709415,-90.988776 42.708724,-90.987497 42.7073,-90.985241 42.704787,-90.983478 42.702225,-90.98254 42.701159,-90.980578 42.698932,-90.977735 42.696816,-90.977153 42.69648,-90.976314 42.695996,-90.974237 42.695249,-90.971779 42.694834,-90.968927 42.694331,-90.967659 42.693972,-90.965048 42.693233,-90.96147 42.691587,-90.959824 42.690831,-90.956273 42.688985,-90.955617 42.688644,-90.954448 42.687963,-90.954338 42.687899,-90.952415 42.686778,-90.95034 42.685997,-90.949303 42.685607,-90.94921 42.685569,-90.949083 42.685541,-90.948999 42.685521,-90.94882 42.685481,-90.947268 42.685088,-90.945919 42.684751,-90.945521 42.684652,-90.941567 42.683844,-90.938364 42.683529,-90.937045 42.683399,-90.936927 42.683407,-90.932858 42.683709,-90.932614 42.683727,-90.932371 42.683745,-90.929881 42.684128,-90.92797 42.684534,-90.926307 42.684969,-90.925895 42.685077,-90.923634 42.6855,-90.921155 42.685406,-90.91719 42.684355,-90.916847 42.684228,-90.9134 42.682949,-90.909774 42.681179,-90.908745 42.680587,-90.906147 42.679094,-90.906019 42.679023,-90.904685 42.678286,-90.903351 42.677549,-90.903011 42.677406,-90.901991 42.676979,-90.901652 42.676837,-90.900726 42.676448,-90.900261 42.676254,-90.899073 42.67583,-90.897899 42.675411,-90.897127 42.675137,-90.896951 42.675082,-90.896548 42.674958,-90.896145 42.674833,-90.893847 42.674123,-90.892682 42.673763,-90.88743 42.67247,-90.884379 42.671835,-90.883106 42.671571,-90.881197 42.671184,-90.878237 42.670584,-90.875127 42.66994,-90.873968 42.669803,-90.872863 42.669638,-90.871255 42.669397,-90.870547 42.669282,-90.869962 42.669188,-90.867125 42.668728,-90.864527 42.668146,-90.862493 42.66769,-90.857392 42.666304,-90.852497 42.664822,-90.848727 42.664111,-90.845806 42.66348,-90.84391 42.663071,-90.840163 42.662562,-90.838867 42.662358,-90.837723 42.662179,-90.832702 42.661662,-90.828921 42.660975,-90.828174 42.660771,-90.825957 42.660166,-90.823655 42.659926,-90.821742 42.659728,-90.817679 42.65892,-90.813398 42.658177,-90.810015 42.657634,-90.808561 42.657401,-90.807193 42.65721,-90.806322 42.657088,-90.805452 42.656967,-90.803301 42.656667,-90.80054 42.656273,-90.797017 42.655772,-90.79291 42.655003,-90.788226 42.653888,-90.785914 42.653604,-90.785214 42.653518,-90.781996 42.653123,-90.780985 42.653073,-90.780662 42.653057,-90.779695 42.65301,-90.779373 42.652995,-90.778752 42.652965,-90.775977 42.652483,-90.773818 42.652108,-90.769495 42.651443,-90.765848 42.65058,-90.765018 42.650384,-90.762523 42.649709,-90.760389 42.649131,-90.759365 42.648722,-90.758268 42.648284,-90.757171 42.647846,-90.756946 42.647756,-90.750126 42.647057,-90.748941 42.646782,-90.743677 42.64556,-90.738126 42.644659,-90.73454 42.644103,-90.731132 42.643437,-90.730598 42.64331,-90.72607 42.642237,-90.720209 42.640758,-90.717821 42.639914,-90.715133 42.638904,-90.711749 42.637472,-90.709204 42.636078,-90.708692 42.635741,-90.706303 42.634169,-90.704059 42.63219,-90.702671 42.630756,-90.70183 42.629131,-90.701649 42.62878,-90.700856 42.626445,-90.700757 42.624997,-90.700095 42.622461,-90.699242 42.621336,-90.698978 42.620988,-90.697439 42.618957,-90.693999 42.614509,-90.692568 42.611496,-90.692501 42.611356,-90.692031 42.610366,-90.691061 42.607595,-90.689215 42.602318,-90.688687 42.600964,-90.687999 42.599198,-90.687743 42.59611,-90.687775 42.594606,-90.686975 42.591774,-90.686735 42.591426,-90.685487 42.589614,-90.681967 42.584955,-90.680447 42.582943,-90.680025 42.582376,-90.679375 42.581503,-90.677935 42.580031,-90.677055 42.579215,-90.675752 42.578329,-90.675289 42.578014,-90.674827 42.577699,-90.674319 42.577433,-90.673811 42.577167,-90.672727 42.576599,-90.671991 42.576033,-90.671287 42.575493,-90.666407 42.571746,-90.664143 42.570007,-90.661527 42.567999,-90.661506 42.567912,-90.661444 42.567652,-90.661424 42.567566,-90.660964 42.565632,-90.66041 42.563296,-90.659586 42.559833,-90.659395 42.559027,-90.659261 42.558464,-90.659127 42.5579,-90.657036 42.554554,-90.654127 42.5499,-90.648885 42.546323,-90.645627 42.5441,-90.645287 42.54336,-90.644267 42.54114,-90.643927 42.540401,-90.643822 42.539862,-90.64367 42.539074,-90.64351 42.538248,-90.643413 42.537746,-90.643406 42.53771,-90.64339 42.537628,-90.643342 42.537382,-90.643327 42.537301,-90.643109 42.536528,-90.642457 42.534209,-90.64224 42.533436,-90.641797 42.531862,-90.640627 42.527701,-90.640395 42.527167,-90.639746 42.525668,-90.639014 42.52398,-90.63682 42.518917,-90.636727 42.518702,-90.636785 42.517099,-90.636792 42.516891,-90.636815 42.516267,-90.636823 42.51606,-90.636825 42.515992,-90.636832 42.515791,-90.636835 42.515724,-90.636836 42.515692,-90.636839 42.515595,-90.636841 42.515564,-90.636842 42.515539,-90.636845 42.515468,-90.636845 42.51546,-90.636852 42.515258,-90.636856 42.515151,-90.63686 42.515048,-90.63686 42.515029,-90.636862 42.514975,-90.636863 42.514958,-90.636864 42.514913,-90.636869 42.514777,-90.636871 42.514733,-90.636872 42.514706,-90.636874 42.514627,-90.636876 42.514601,-90.636877 42.514571,-90.636879 42.514483,-90.636881 42.514454,-90.636882 42.514423,-90.636885 42.514329,-90.636887 42.514299,-90.636889 42.51424,-90.636895 42.514063,-90.636898 42.514005,-90.636927 42.513202,-90.63732 42.512719,-90.640025 42.509406,-90.640927 42.508302,-90.641273 42.507843,-90.642312 42.506465,-90.642659 42.506007,-90.643854 42.504422,-90.647439 42.499668,-90.648635 42.498084,-90.650092 42.496808,-90.654466 42.492982,-90.655924 42.491708,-90.656044 42.491207,-90.656406 42.489703,-90.656527 42.489203,-90.656376 42.484997,-90.656327 42.483603,-90.654027 42.478503,-90.649848 42.474725,-90.646727 42.471904,-90.645586 42.471184,-90.642166 42.469024,-90.641027 42.468304,-90.630376 42.462308,-90.624328 42.458904,-90.606328 42.451505,-90.604016 42.450805,-90.597488 42.449477,-90.596344 42.449156,-90.590416 42.447493,-90.584736 42.445365,-90.582128 42.444437,-90.580444 42.444064,-90.575104 42.442885,-90.570736 42.441701,-90.5696 42.441205,-90.567968 42.440389,-90.56761 42.440172,-90.565248 42.438742,-90.564036 42.437506,-90.564059 42.437404,-90.563821 42.43715,-90.562896 42.436161,-90.562588 42.435832,-90.561841 42.435034,-90.561048 42.433881,-90.560439 42.432897,-90.56017 42.43224,-90.560027 42.431889,-90.559451 42.430695,-90.558985 42.429445,-90.558801 42.428517,-90.558542 42.426912,-90.558326 42.425404,-90.558252 42.423718,-90.558298 42.422024,-90.558168 42.420984,-90.557876 42.420097,-90.557667 42.41956,-90.55755 42.419258,-90.55667 42.418114,-90.556149 42.417283,-90.555464 42.416614,-90.555018 42.416138,-90.554974 42.416115,-90.554845 42.416047,-90.554802 42.416025,-90.55281 42.414985,-90.549465 42.413665,-90.548068 42.413115,-90.541954 42.411374,-90.535863 42.409205,-90.532824 42.408191,-90.527282 42.406342,-90.525401 42.40568,-90.522725 42.404801,-90.522232 42.404621,-90.520094 42.403842,-90.517516 42.403019,-90.513504 42.401293,-90.510264 42.400155,-90.507269 42.398966,-90.506829 42.398792,-90.505057 42.397904,-90.502894 42.396984,-90.502419 42.396751,-90.50196 42.396508,-90.500586 42.395781,-90.500128 42.395539,-90.49912 42.394785,-90.497785 42.393822,-90.496809 42.392949,-90.496157 42.392689,-90.495766 42.392406,-90.4952 42.391824,-90.495191 42.391815,-90.494498 42.391015,-90.493642 42.389996,-90.492514 42.388985,-90.491332 42.387894,-90.490334 42.387093,-90.489064 42.386388,-90.488217 42.385814,-90.487154 42.385141,-90.486404 42.384906,-90.485698 42.384662,-90.484621 42.38453,-90.482934 42.384623,-90.481475 42.384684,-90.480148 42.384616,-90.479174 42.384416,-90.479072 42.384396,-90.477941 42.384151,-90.477279 42.383794,-90.475814 42.382839,-90.474891 42.38228,-90.474121 42.381729,-90.473798 42.381458,-90.472446 42.380325,-90.472007 42.379957,-90.471085 42.379116,-90.470273 42.378355,-90.469007 42.376666,-90.468869 42.376464,-90.467875 42.375009,-90.46785 42.374983,-90.467775 42.374906,-90.46775 42.374881,-90.46753 42.374438,-90.466465 42.372475,-90.465879 42.371147,-90.465476 42.370546,-90.464788 42.369452,-90.464053 42.36859,-90.462619 42.367253,-90.461818 42.366688,-90.46103 42.366133,-90.458808 42.364507,-90.456298 42.362548,-90.454646 42.360652,-90.452724 42.359303,-90.450836 42.358527,-90.448685 42.357886,-90.44632 42.357041,-90.445167 42.356441,-90.443874 42.355218,-90.44248 42.353511,-90.441401 42.351774,-90.440264 42.349683,-90.438951 42.34771,-90.438841 42.347585,-90.437726 42.346319,-90.435649 42.343887,-90.433949 42.341701,-90.432562 42.339622,-90.432494 42.33953,-90.432475 42.339504,-90.43242 42.339429,-90.432402 42.339404,-90.431832 42.338623,-90.430546 42.33686,-90.430004 42.336395,-90.429272 42.335766,-90.427989 42.334665,-90.427164 42.334021,-90.425363 42.332615,-90.422758 42.331292,-90.42135 42.330472,-90.420303 42.329586,-90.419027 42.328505,-90.418398 42.327648,-90.416535 42.325109,-90.41616 42.3236,-90.415937 42.322699,-90.4162 42.321314,-90.416626 42.320576,-90.417125 42.319943,-90.417974 42.319234,-90.419017 42.318574,-90.420075 42.317681,-90.420753 42.3168,-90.421047 42.316109,-90.421182 42.315255,-90.420861 42.313759,-90.420303 42.311703,-90.4203 42.31169,-90.419425 42.310189,-90.419008 42.309217,-90.418915 42.308328,-90.419354 42.307429,-90.419878 42.306603,-90.420454 42.305374,-90.420608 42.304976,-90.420954 42.304088,-90.421676 42.302506,-90.42216 42.300937,-90.422675 42.298804,-90.423224 42.297156,-90.423231 42.297138,-90.423744 42.295975,-90.424257 42.294576,-90.42427 42.294326,-90.424312 42.293575,-90.424326 42.293326,-90.425482 42.292298,-90.42556 42.292211,-90.426909 42.290719,-90.42826 42.288064,-90.428426 42.28774,-90.429069 42.286611,-90.429332 42.286147,-90.430124 42.284757,-90.430218 42.284593,-90.430494 42.284388,-90.430735 42.284211,-90.431039 42.282452,-90.431027 42.281399,-90.431012 42.279965,-90.430884 42.27823,-90.429313 42.275588,-90.428204 42.273405,-90.427825 42.272798,-90.426846 42.271228,-90.426156 42.270143,-90.426056 42.269968,-90.425757 42.269443,-90.425658 42.269269,-90.425648 42.269253,-90.425621 42.269205,-90.425612 42.269189,-90.424884 42.267912,-90.424708 42.267566,-90.424098 42.266364,-90.423242 42.264411,-90.422889 42.262883,-90.422836 42.26236,-90.422732 42.261316,-90.422439 42.260563,-90.422181 42.259899,-90.421842 42.259175,-90.421659 42.258781,-90.42098 42.257282,-90.420191 42.255846,-90.419757 42.255155,-90.419326 42.254467,-90.418877 42.253932,-90.418274 42.253215,-90.418257 42.253202,-90.416315 42.251679,-90.415974 42.25146,-90.415169 42.250942,-90.414868 42.250748,-90.414481 42.2505,-90.413951 42.250194,-90.413642 42.250016,-90.412441 42.249098,-90.411397 42.248383,-90.410471 42.247749,-90.408038 42.245681,-90.405023 42.24303,-90.403648 42.241821,-90.402926 42.241211,-90.401872 42.240321,-90.400653 42.239293,-90.399097 42.237283,-90.398253 42.236193,-90.397314 42.23498,-90.395883 42.233133,-90.395276 42.230953,-90.394865 42.229476,-90.394749 42.229059,-90.394654 42.228947,-90.393526 42.227626,-90.393151 42.227186,-90.391177 42.225531,-90.391108 42.225473,-90.386781 42.222967,-90.384655 42.221408,-90.382579 42.219886,-90.382251 42.219646,-90.381094 42.218863,-90.377656 42.216535,-90.376618 42.215827,-90.375129 42.214811,-90.374714 42.214587,-90.372097 42.21354,-90.370925 42.213072,-90.365138 42.210526,-90.363212 42.209299,-90.360626 42.207653,-90.360435 42.207538,-90.356964 42.205445,-90.35177 42.204667,-90.349162 42.204277,-90.338169 42.203321,-90.332177 42.202232,-90.328273 42.201047,-90.324927 42.198727,-90.319838 42.195199,-90.317774 42.193789,-90.317202 42.193572,-90.315141 42.192792,-90.314465 42.192537,-90.308776 42.191032,-90.306647 42.19047,-90.306531 42.190439,-90.304516 42.189725,-90.298442 42.187576,-90.298151 42.187424,-90.296151 42.18638,-90.293905 42.185208,-90.285429 42.180612,-90.282173 42.178846,-90.276623 42.176996,-90.26908 42.1745,-90.262345 42.173451,-90.255456 42.171821,-90.250338 42.171482,-90.250129 42.171469,-90.249216 42.171056,-90.248007 42.170672,-90.244913 42.169362,-90.242132 42.168279,-90.239017 42.167048,-90.234919 42.165431,-90.231127 42.163425,-90.22881 42.162281,-90.224244 42.160028,-90.216107 42.15673,-90.213136 42.15505,-90.211328 42.15401,-90.209479 42.15268,-90.20826 42.15099,-90.207421 42.149109,-90.206369 42.1455,-90.205703 42.141267,-90.20536 42.139079,-90.204614 42.137722,-90.204145 42.136995,-90.203071 42.134733,-90.201404 42.130937,-90.200128 42.130066,-90.197342 42.128163,-90.196171 42.127702,-90.195704 42.127519,-90.194717 42.127185,-90.193865 42.126896,-90.192472 42.126425,-90.191302 42.126058,-90.190467 42.125796,-90.190452 42.125779,-90.187474 42.125423,-90.186456 42.12534,-90.18471 42.125198,-90.174402 42.125198,-90.17097 42.125198,-90.17041 42.125021,-90.169784 42.124518,-90.169641 42.124397,-90.168853 42.123733,-90.167533 42.122475,-90.167459 42.122387,-90.166821 42.121631,-90.166632 42.121406,-90.166104 42.12078,-90.166067 42.120731,-90.165893 42.120496,-90.165444 42.119893,-90.164327 42.11867,-90.163992 42.118303,-90.162895 42.116718,-90.162225 42.11488,-90.161884 42.11378,-90.161622 42.112109,-90.161602 42.111979,-90.161352 42.11017,-90.161326 42.109721,-90.161268 42.10867,-90.161266 42.108647,-90.16116 42.106372,-90.16114 42.105424,-90.16112 42.104404,-90.161125 42.10435,-90.16113 42.104298,-90.161311 42.102674,-90.161325 42.102375,-90.161412 42.100628,-90.161504 42.098912,-90.161779 42.096836,-90.161874 42.096456,-90.162088 42.095607,-90.162326 42.094524,-90.162401 42.094185,-90.162404 42.094126,-90.162487 42.092913,-90.162515 42.092509,-90.162516 42.09248,-90.162521 42.092394,-90.162524 42.092366,-90.162559 42.091838,-90.162615 42.090995,-90.162782 42.090273,-90.162902 42.089758,-90.163034 42.089222,-90.163188 42.088601,-90.163405 42.087613,-90.163406 42.087609,-90.163581 42.087086,-90.163718 42.086674,-90.16414 42.085664,-90.164482 42.08487,-90.164499 42.084826,-90.164814 42.084036,-90.16532 42.082689,-90.16573 42.081751,-90.166512 42.080568,-90.166925 42.079477,-90.167556 42.078316,-90.16759 42.078221,-90.168074 42.076888,-90.168327 42.075898,-90.168358 42.075779,-90.168212 42.074657,-90.168098 42.073524,-90.168054 42.073083,-90.167734 42.071484,-90.16729 42.069705,-90.166874 42.068579,-90.166482 42.067333,-90.166345 42.066583,-90.166204 42.065806,-90.165897 42.064234,-90.165857 42.064028,-90.165668 42.063158,-90.165555 42.062638,-90.165526 42.061518,-90.165765 42.060047,-90.165808 42.059897,-90.166116 42.058842,-90.166251 42.058005,-90.166367 42.057298,-90.166808 42.055933,-90.166825 42.055544,-90.166853 42.05491,-90.166705 42.054758,-90.166495 42.054543,-90.165889 42.05277,-90.165756 42.052368,-90.165294 42.050973,-90.164884 42.048171,-90.164537 42.045007,-90.164528 42.044701,-90.164483 42.043145,-90.164485 42.042105,-90.164337 42.041515,-90.163983 42.040954,-90.163446 42.040407,-90.162807 42.040002,-90.162681 42.039922,-90.161629 42.039248,-90.160073 42.03851,-90.158829 42.037769,-90.156663 42.035412,-90.156169 42.035051,-90.155529 42.034584,-90.154384 42.033305,-90.154221 42.033073,-90.153956 42.032695,-90.153334 42.032066,-90.152488 42.031394,-90.152288 42.031227,-90.151579 42.030633,-90.151279 42.030073,-90.150916 42.02944,-90.150291 42.028046,-90.149733 42.026564,-90.149389 42.025141,-90.149188 42.024058,-90.149182 42.023965,-90.149112 42.022679,-90.148644 42.021488,-90.148603 42.021377,-90.148096 42.020014,-90.147194 42.018479,-90.146639 42.017905,-90.146026 42.017271,-90.145414 42.016747,-90.144683 42.016198,-90.143776 42.014881,-90.143017 42.013227,-90.142306 42.011839,-90.141666 42.010187,-90.141167 42.008931,-90.140966 42.007856,-90.14092 42.007559,-90.140639 42.005733,-90.14027 42.004431,-90.140125 42.003613,-90.140061 42.003252,-90.14012 42.002898,-90.140286 42.001916,-90.140404 42.001015,-90.14044 42.000745,-90.140536 42.000026,-90.140613 41.995999,-90.141249 41.995127,-90.144241 41.991031,-90.146033 41.988139,-90.146399 41.985375,-90.146225 41.981329,-90.146231 41.98132,-90.148599 41.978269,-90.149599 41.977528,-90.150691 41.976718,-90.152107 41.97567,-90.153828 41.974121,-90.153834 41.974116,-90.154381 41.97288,-90.155064 41.971337,-90.156315 41.969113,-90.157597 41.967988,-90.158592 41.967117,-90.160458 41.964016,-90.162141 41.961293,-90.164135 41.956178,-90.164593 41.952001,-90.164939 41.948861,-90.164193 41.946178,-90.163847 41.944934,-90.162905 41.94373,-90.160648 41.940845,-90.156902 41.938181,-90.156785 41.938024,-90.155104 41.935762,-90.154947 41.935551,-90.15431 41.934527,-90.154195 41.934425,-90.152659 41.933058,-90.1516 41.931002,-90.151689 41.930512,-90.15198 41.928917,-90.151988 41.928868,-90.152014 41.928723,-90.152024 41.928675,-90.152138 41.928052,-90.152452 41.924847,-90.153362 41.915593,-90.153374 41.913334,-90.153382 41.912087,-90.153478 41.909483,-90.153507 41.908692,-90.153584 41.906614,-90.153692 41.906342,-90.153986 41.905608,-90.154328 41.90475,-90.155355 41.902179,-90.155698 41.901322,-90.156273 41.899884,-90.156843 41.898459,-90.156871 41.89839,-90.157019 41.898019,-90.157459 41.897239,-90.158321 41.895714,-90.160977 41.891013,-90.163633 41.886312,-90.164029 41.885609,-90.165065 41.883777,-90.166329 41.881799,-90.166629 41.881329,-90.166778 41.881094,-90.166929 41.880859,-90.167865 41.879395,-90.168152 41.879,-90.168645 41.878325,-90.169096 41.877706,-90.169287 41.877446,-90.170041 41.876439,-90.170258 41.875757,-90.170491 41.875028,-90.170566 41.874266,-90.170569 41.874227,-90.17064 41.873505,-90.170763 41.872265,-90.170806 41.871826,-90.170885 41.871025,-90.170903 41.870846,-90.170909 41.870784,-90.170962 41.87031,-90.170984 41.870133,-90.171165 41.869598,-90.17119 41.869527,-90.171577 41.868677,-90.17186 41.868053,-90.171901 41.867964,-90.172101 41.867543,-90.172133 41.867476,-90.172229 41.867275,-90.172261 41.867208,-90.17248 41.866747,-90.172765 41.866149,-90.173019 41.865321,-90.17317 41.864834,-90.173213 41.864693,-90.173237 41.86461,-90.173257 41.864438,-90.173284 41.864024,-90.173329 41.863671,-90.17331 41.863445,-90.173301 41.863341,-90.173225 41.862465,-90.173073 41.861122,-90.173048 41.8609,-90.173046 41.860884,-90.17287 41.858409,-90.173009 41.857393,-90.173918 41.855575,-90.174701 41.854225,-90.174702 41.854225,-90.175057 41.853615,-90.17684 41.85099,-90.178942 41.847898,-90.179184 41.847542,-90.179911 41.846476,-90.180049 41.846276,-90.180169 41.846133,-90.180565 41.845654,-90.181401 41.844647,-90.181583 41.844124,-90.181788 41.843538,-90.181873 41.843293,-90.181901 41.843216,-90.181984 41.842526,-90.182016 41.842269,-90.182028 41.842171,-90.182188 41.841355,-90.182272 41.840932,-90.182593 41.839308,-90.182608 41.839235,-90.18288 41.83867,-90.182955 41.838517,-90.183251 41.837906,-90.183275 41.83783,-90.183283 41.837801,-90.183367 41.83753,-90.183643 41.836631,-90.183736 41.836332,-90.183765 41.83624,-90.18387 41.83517,-90.183883 41.834907,-90.183884 41.834901,-90.183973 41.83307,-90.183693 41.83161,-90.183649 41.831381,-90.183405 41.830679,-90.183187 41.830047,-90.18281 41.829381,-90.182672 41.829138,-90.182535 41.828895,-90.182375 41.828613,-90.182215 41.82833,-90.181889 41.827755,-90.18188 41.827566,-90.181813 41.826077,-90.181904 41.824605,-90.18172 41.822599,-90.181619 41.821603,-90.181599 41.821414,-90.181505 41.82048,-90.181392 41.819368,-90.18122 41.81768,-90.180707 41.812617,-90.180643 41.811979,-90.180772 41.810932,-90.180855 41.810256,-90.180881 41.810019,-90.180954 41.809354,-90.181141 41.808935,-90.181973 41.80707,-90.182866 41.806487,-90.185046 41.805068,-90.187969 41.803163,-90.190437 41.802408,-90.191316 41.802139,-90.192194 41.801871,-90.196165 41.800656,-90.196955 41.800491,-90.202003 41.799439,-90.203131 41.799204,-90.203588 41.799109,-90.206465 41.798294,-90.207573 41.79798,-90.207574 41.79798,-90.207962 41.79787,-90.208115 41.797827,-90.208474 41.797726,-90.208656 41.797673,-90.209087 41.79755,-90.209128 41.797538,-90.209517 41.797426,-90.209659 41.797385,-90.210087 41.797264,-90.21023 41.797224,-90.216889 41.795335,-90.217011 41.795284,-90.219662 41.794199,-90.220354 41.793916,-90.221046 41.793632,-90.221203 41.793568,-90.22136 41.793503,-90.22176 41.793339,-90.222161 41.793175,-90.222263 41.793133,-90.231239 41.788596,-90.236084 41.786146,-90.23681 41.78578,-90.24238 41.782964,-90.243235 41.782531,-90.2458 41.781234,-90.246656 41.780802,-90.246926 41.780666,-90.247197 41.780529,-90.247242 41.780506,-90.248631 41.779805,-90.249014 41.77965,-90.249623 41.779404,-90.249739 41.779357,-90.250087 41.779216,-90.250128 41.7792,-90.25016 41.779185,-90.250202 41.779166,-90.251885 41.778391,-90.256938 41.776069,-90.258622 41.775295,-90.258862 41.775053,-90.259503 41.77464,-90.259846 41.774419,-90.260614 41.773848,-90.260966 41.773588,-90.261623 41.773101,-90.263286 41.772112,-90.264696 41.771475,-90.265838 41.771186,-90.265854 41.771182,-90.267295 41.770867,-90.268279 41.770653,-90.268471 41.770611,-90.268659 41.770569,-90.269694 41.770286,-90.269758 41.770258,-90.271888 41.769561,-90.278478 41.767408,-90.278633 41.767358,-90.280418 41.766162,-90.280451 41.766139,-90.280551 41.766073,-90.280585 41.766051,-90.280596 41.766043,-90.280631 41.766019,-90.280643 41.766012,-90.280893 41.765844,-90.281643 41.765341,-90.281894 41.765174,-90.28191 41.765167,-90.282098 41.765077,-90.282287 41.764987,-90.282329 41.764966,-90.283552 41.764386,-90.283597 41.764302,-90.28383 41.763879,-90.283941 41.76368,-90.284551 41.763082,-90.284845 41.76281,-90.285356 41.762341,-90.286353 41.761562,-90.287697 41.760545,-90.288402 41.760157,-90.289206 41.759715,-90.289732 41.759507,-90.292321 41.757584,-90.294383 41.756054,-90.30016 41.75191,-90.302415 41.750294,-90.302598 41.750162,-90.302782 41.750031,-90.303686 41.749243,-90.304525 41.74861,-90.305275 41.747879,-90.30608 41.747131,-90.30668 41.746595,-90.307244 41.746092,-90.308015 41.745304,-90.308946 41.744403,-90.309074 41.744281,-90.309973 41.74342,-90.310651 41.7426,-90.310878 41.742325,-90.31157 41.741359,-90.312252 41.740402,-90.312609 41.739939,-90.313658 41.737905,-90.31447 41.736485,-90.314647 41.736177,-90.315002 41.735626,-90.315281 41.734994,-90.315549 41.734426,-90.315653 41.734039,-90.315771 41.7336,-90.315907 41.732281,-90.316403 41.729511,-90.316562 41.728928,-90.31613 41.728769,-90.316262 41.728235,-90.316396 41.727701,-90.316581 41.726961,-90.316625 41.726809,-90.317048 41.725355,-90.317243 41.724536,-90.317426 41.723694,-90.317668 41.722689,-90.317538 41.722063,-90.317552 41.721279,-90.317555 41.721079,-90.317566 41.72089,-90.317609 41.720223,-90.317542 41.719563,-90.317474 41.718878,-90.317421 41.718333,-90.316997 41.717294,-90.316543 41.716038,-90.316455 41.715819,-90.316106 41.71495,-90.315491 41.713697,-90.315187 41.713032,-90.314896 41.712396,-90.314278 41.711353,-90.313769 41.710339,-90.31332 41.709494,-90.313166 41.708804,-90.313013 41.708087,-90.312893 41.707528,-90.312817 41.706887,-90.312722 41.70608,-90.312667 41.704581,-90.312783 41.70366,-90.312774 41.702851,-90.31277 41.702426,-90.312861 41.701417,-90.312924 41.700496,-90.312933 41.700431,-90.313052 41.699631,-90.31327 41.698836,-90.313435 41.698082,-90.313824 41.69701,-90.313986 41.696525,-90.314191 41.695913,-90.314687 41.69483,-90.315351 41.693921,-90.315981 41.692989,-90.31639 41.69257,-90.316632 41.692322,-90.317315 41.69167,-90.318346 41.690835,-90.319309 41.690218,-90.319924 41.689721,-90.32037 41.689461,-90.321005 41.689093,-90.322258 41.688486,-90.323234 41.687933,-90.323369 41.687852,-90.323776 41.687611,-90.323912 41.687532,-90.324973 41.686861,-90.325896 41.686292,-90.326957 41.68564,-90.328071 41.685129,-90.328971 41.684717,-90.330222 41.683954,-90.330688 41.68361,-90.331443 41.683054,-90.331875 41.682675,-90.332481 41.682146,-90.333274 41.681322,-90.33353 41.681026,-90.333621 41.68092,-90.333625 41.680917,-90.333857 41.680573,-90.333936 41.680458,-90.333991 41.680376,-90.334525 41.679559,-90.334721 41.678595,-90.334831 41.678056,-90.33509 41.676279,-90.335349 41.674577,-90.335475 41.67325,-90.335502 41.672967,-90.335545 41.672481,-90.335729 41.670432,-90.335915 41.669285,-90.336429 41.666132,-90.336482 41.665847,-90.336696 41.664706,-90.336729 41.664532,-90.337074 41.663492,-90.337185 41.663031,-90.337287 41.662614,-90.337631 41.661494,-90.337653 41.661424,-90.33802 41.660539,-90.338283 41.659963,-90.338508 41.659471,-90.338844 41.658632,-90.339085 41.658163,-90.339332 41.657686,-90.339759 41.656862,-90.339859 41.656599,-90.339933 41.656405,-90.340154 41.655825,-90.340229 41.655632,-90.340404 41.655184,-90.34058 41.654736,-90.341193 41.653169,-90.341743 41.652101,-90.342231 41.650964,-90.342506 41.650056,-90.342872 41.649225,-90.343162 41.648141,-90.343246 41.647797,-90.343452 41.646959,-90.343458 41.646828,-90.343513 41.645692,-90.343498 41.644533,-90.343329 41.643232,-90.34333 41.641075,-90.34333 41.640855,-90.342811 41.638071,-90.342506 41.634317,-90.342277 41.630907,-90.342128 41.629247,-90.342059 41.628472,-90.34199 41.627698,-90.341971 41.627489,-90.342016 41.625124,-90.341999 41.624757,-90.34194 41.623476,-90.341823 41.622677,-90.34165 41.621484,-90.341342 41.619771,-90.341284 41.619447,-90.341131 41.617883,-90.340918 41.616472,-90.340989 41.615096,-90.341008 41.614714,-90.341028 41.614332,-90.341007 41.614115,-90.340986 41.613898,-90.34098 41.61384,-90.340975 41.613782,-90.340971 41.613745,-90.340942 41.613438,-90.340908 41.613095,-90.340826 41.612247,-90.3408 41.611985,-90.340744 41.611399,-90.340728 41.611232,-90.340564 41.609526,-90.340316 41.606936,-90.340078 41.604487,-90.340023 41.60391,-90.339845 41.602038,-90.339827 41.601842,-90.339809 41.601641,-90.339753 41.601058,-90.339723 41.600739,-90.339642 41.599835,-90.339528 41.598633,-90.339652 41.598134,-90.339891 41.597181,-90.340127 41.596236,-90.340835 41.593402,-90.341072 41.592458,-90.341228 41.591835,-90.341383 41.591212,-90.341528 41.590633,-90.342392 41.589208,-90.343228 41.587833,-90.347056 41.586337,-90.351642 41.584544,-90.351928 41.584433,-90.352184 41.584334,-90.354952 41.583267,-90.355189 41.583172,-90.3559 41.58289,-90.356138 41.582797,-90.357647 41.582198,-90.358548 41.581842,-90.360958 41.580888,-90.361966 41.58049,-90.362176 41.580406,-90.362973 41.580091,-90.363329 41.57995,-90.363686 41.579808,-90.364128 41.579633,-90.364566 41.579557,-90.36467 41.579539,-90.365298 41.579428,-90.370998 41.578435,-90.37238 41.578194,-90.372554 41.578163,-90.373762 41.577953,-90.376271 41.577516,-90.377223 41.577349,-90.37878 41.577078,-90.37942 41.576966,-90.380059 41.576855,-90.381329 41.576633,-90.382244 41.57639,-90.382648 41.576283,-90.38367 41.576013,-90.385096 41.575635,-90.387411 41.575021,-90.389726 41.574407,-90.393828 41.57332,-90.394109 41.573245,-90.39793 41.572233,-90.39949 41.571453,-90.399829 41.571283,-90.40417 41.569113,-90.40573 41.568333,-90.407186 41.567716,-90.411554 41.565866,-90.412825 41.565329,-90.412984 41.565206,-90.413546 41.564742,-90.41453 41.563933,-90.415252 41.563377,-90.41583 41.562933,-90.415871 41.562881,-90.415997 41.562727,-90.416039 41.562676,-90.416401 41.56223,-90.416763 41.561783,-90.416871 41.561649,-90.41694 41.561565,-90.417116 41.561347,-90.41883 41.559233,-90.419309 41.558527,-90.420053 41.557435,-90.420641 41.556568,-90.421075 41.555932,-90.422097 41.554429,-90.42223 41.554233,-90.422506 41.554076,-90.423418 41.553561,-90.42364 41.553435,-90.424307 41.553058,-90.42453 41.552933,-90.42457 41.552912,-90.42469 41.552849,-90.424731 41.552829,-90.424814 41.552785,-90.425063 41.552656,-90.425147 41.552613,-90.426023 41.552158,-90.426094 41.552122,-90.42704 41.551632,-90.427231 41.551533,-90.428738 41.550984,-90.429667 41.550647,-90.430582 41.550314,-90.432731 41.549533,-90.433192 41.549095,-90.4339 41.548426,-90.43425 41.548093,-90.435301 41.547097,-90.435652 41.546765,-90.436679 41.545791,-90.436814 41.545664,-90.437975 41.544564,-90.438431 41.544133,-90.439464 41.542898,-90.439608 41.542724,-90.43999 41.542268,-90.440517 41.541638,-90.441119 41.540917,-90.442928 41.538753,-90.443531 41.538033,-90.443871 41.537653,-90.444891 41.536513,-90.445231 41.536133,-90.445438 41.535968,-90.445645 41.535802,-90.446003 41.535514,-90.447731 41.534133,-90.44833 41.533669,-90.449113 41.533064,-90.449474 41.532784,-90.450559 41.531944,-90.450921 41.531665,-90.451132 41.531501,-90.451765 41.531011,-90.451766 41.531011,-90.451978 41.530848,-90.453868 41.529385,-90.456546 41.527314,-90.459541 41.524996,-90.461113 41.52378,-90.461272 41.523656,-90.461432 41.523533,-90.464012 41.522773,-90.471752 41.520492,-90.474332 41.519733,-90.474876 41.51968,-90.475007 41.519667,-90.475421 41.519628,-90.476565 41.519518,-90.477034 41.519472,-90.47771 41.519408,-90.478068 41.519374,-90.478174 41.519363,-90.478425 41.519339,-90.47923 41.519262,-90.479569 41.519229,-90.480034 41.519185,-90.48837 41.518383,-90.489487 41.518277,-90.489933 41.518233,-90.490014 41.518231,-90.491482 41.518203,-90.495283 41.518133,-90.496043 41.518119,-90.496803 41.518105,-90.497476 41.518092,-90.498139 41.51808,-90.499475 41.518055,-90.49955 41.518053,-90.499776 41.518049,-90.499852 41.518048,-90.500307 41.518039,-90.500633 41.518033,-90.50167 41.518101,-90.502125 41.518132,-90.502426 41.518152,-90.503331 41.518212,-90.503633 41.518233,-90.505333 41.518533,-90.505478 41.518551,-90.507634 41.518833,-90.511051 41.519268,-90.512887 41.519502,-90.512909 41.519505,-90.512965 41.519512,-90.513134 41.519533,-90.513189 41.519548,-90.513971 41.519761,-90.516434 41.520433,-90.517157 41.520629,-90.525308 41.52284,-90.528234 41.523633,-90.529065 41.523858,-90.532682 41.524837,-90.532858 41.524885,-90.533035 41.524933,-90.533875 41.525073,-90.536394 41.525493,-90.537235 41.525633,-90.537974 41.525732,-90.540195 41.526032,-90.540935 41.526133,-90.541038 41.526124,-90.541141 41.526115,-90.541855 41.526052,-90.543338 41.525924,-90.544615 41.525812,-90.545535 41.525732,-90.547415 41.525471,-90.553054 41.524691,-90.554935 41.524432,-90.55521 41.52439,-90.555484 41.524348,-90.555592 41.524331,-90.556235 41.524232,-90.55659 41.524019,-90.557387 41.52354,-90.557735 41.523332,-90.557957 41.523197,-90.559574 41.522216,-90.563836 41.519632,-90.564407 41.519243,-90.565972 41.51818,-90.565981 41.518173,-90.566007 41.518155,-90.566017 41.518149,-90.566158 41.518053,-90.566223 41.518008,-90.566238 41.517998,-90.566256 41.517985,-90.566309 41.517949,-90.566328 41.517937,-90.566336 41.517932,-90.566509 41.517855,-90.567054 41.517612,-90.567236 41.517532,-90.568035 41.517285,-90.570434 41.516547,-90.571136 41.516332,-90.571238 41.516321,-90.571505 41.516291,-90.572036 41.516232,-90.572307 41.516204,-90.572575 41.516177,-90.57333 41.516096,-90.573492 41.516079,-90.575596 41.515866,-90.575936 41.515832,-90.576352 41.515787,-90.577591 41.515652,-90.57883 41.515518,-90.579683 41.515425,-90.580536 41.515332,-90.581615 41.515188,-90.582029 41.515133,-90.582767 41.514888,-90.582851 41.51486,-90.582936 41.514832,-90.583632 41.514706,-90.584327 41.514579,-90.584874 41.51448,-90.58542 41.51438,-90.586236 41.514232,-90.586599 41.514125,-90.58848 41.513578,-90.588605 41.513542,-90.58873 41.513505,-90.590079 41.513111,-90.591037 41.512832,-90.591226 41.512738,-90.591448 41.512627,-90.591669 41.512516,-90.591837 41.512432,-90.591868 41.512419,-90.593872 41.511632,-90.594426 41.511415,-90.594541 41.51137,-90.594637 41.511332,-90.595237 41.511032,-90.596115 41.510395,-90.600631 41.507122,-90.601678 41.506365,-90.601908 41.506198,-90.602137 41.506032,-90.602397 41.504892,-90.602681 41.503648,-90.603177 41.501472,-90.603225 41.501263,-90.603331 41.500798,-90.603437 41.500332,-90.603645 41.499471,-90.604237 41.497032,-90.604307 41.496905,-90.604737 41.496132,-90.604935 41.495818,-90.605529 41.494876,-90.605728 41.494563,-90.605936 41.494232,-90.605937 41.494232,-90.606217 41.494026,-90.606533 41.493797,-90.60757 41.49304,-90.608009 41.492719,-90.608606 41.492283,-90.610592 41.490832,-90.61276 41.48925,-90.61655 41.486482,-90.616913 41.486218,-90.617725 41.485625,-90.618537 41.485032,-90.618862 41.484899,-90.619186 41.484766,-90.620737 41.484132,-90.620996 41.484017,-90.621512 41.483791,-90.625968 41.481831,-90.628302 41.480803,-90.630423 41.479871,-90.63058 41.479802,-90.630738 41.479732,-90.630991 41.47959,-90.631373 41.479378,-90.631753 41.479166,-90.632008 41.479025,-90.632032 41.47901,-90.63207 41.47899,-90.632107 41.478968,-90.632133 41.478955,-90.632538 41.478732,-90.638986 41.47421,-90.640238 41.473332,-90.641991 41.471877,-90.643678 41.470477,-90.645364 41.469077,-90.650238 41.465032,-90.655839 41.462132,-90.657919 41.461832,-90.660526 41.461456,-90.664159 41.460932,-90.665213 41.46078,-90.665726 41.460706,-90.666239 41.460632,-90.666779 41.460632,-90.667048 41.460632,-90.668399 41.460632,-90.668939 41.460632,-90.670414 41.460672,-90.67148 41.4607,-90.67189 41.460711,-90.673806 41.460762,-90.675721 41.460813,-90.676439 41.460832,-90.677208 41.460604,-90.678818 41.460126,-90.678997 41.460073,-90.679321 41.459978,-90.681435 41.459352,-90.68211 41.459152,-90.682596 41.459008,-90.682786 41.458952,-90.685013 41.458292,-90.686079 41.457976,-90.68724 41.457632,-90.687826 41.457476,-90.688412 41.45732,-90.690951 41.456643,-90.698254 41.455284,-90.699667 41.45502,-90.701159 41.454743,-90.705475 41.454099,-90.706241 41.453985,-90.707007 41.45387,-90.707858 41.453743,-90.710315 41.453494,-90.711245 41.4534,-90.714802 41.453049,-90.718311 41.452767,-90.720951 41.452416,-90.723275 41.452265,-90.723325 41.452261,-90.723545 41.452248,-90.726093 41.451836,-90.727 41.451733,-90.728382 41.451577,-90.728687 41.451536,-90.730656 41.451272,-90.732639 41.450997,-90.733441 41.450931,-90.735645 41.450448,-90.737302 41.450167,-90.737446 41.450142,-90.737537 41.450127,-90.745946 41.44973,-90.749592 41.449645,-90.749867 41.449638,-90.750142 41.449632,-90.750593 41.449644,-90.75084 41.449652,-90.751538 41.449673,-90.751706 41.449678,-90.751948 41.449692,-90.7524 41.44972,-90.75435 41.44984,-90.758255 41.450098,-90.758375 41.450106,-90.76042 41.450317,-90.762079 41.450405,-90.762252 41.450424,-90.763471 41.450559,-90.76451 41.450583,-90.765484 41.450672,-90.766223 41.450704,-90.767122 41.450737,-90.768021 41.450769,-90.76922 41.450728,-90.770719 41.450745,-90.771672 41.450761,-90.772486 41.450809,-90.773417 41.450882,-90.775591 41.451067,-90.775815 41.451088,-90.777583 41.451261,-90.7783 41.451398,-90.779317 41.451608,-90.780686 41.451839,-90.781147 41.451917,-90.781608 41.451995,-90.78255 41.452132,-90.783107 41.452213,-90.784841 41.452576,-90.78535 41.452692,-90.785819 41.4528,-90.78603 41.452849,-90.786282 41.452888,-90.788203 41.453147,-90.789006 41.453244,-90.789801 41.453341,-90.790516 41.453429,-90.791447 41.453502,-90.793128 41.453631,-90.794497 41.453756,-90.795066 41.453808,-90.795283 41.45382,-90.79725 41.453928,-90.798931 41.454025,-90.800419 41.454096,-90.803319 41.454235,-90.803642 41.45425,-90.803964 41.454266,-90.805634 41.454362,-90.806769 41.454434,-90.807283 41.454466,-90.80845 41.45449,-90.8094 41.454531,-90.809574 41.454538,-90.810035 41.45457,-90.810795 41.45457,-90.810852 41.454569,-90.811319 41.454562,-90.811973 41.454594,-90.813151 41.454505,-90.814211 41.454448,-90.815087 41.454397,-90.815336 41.454383,-90.815416 41.454379,-90.81677 41.454326,-90.817682 41.454342,-90.818055 41.454349,-90.818701 41.454362,-90.819222 41.454373,-90.820689 41.454396,-90.822552 41.454396,-90.823098 41.454411,-90.823751 41.454427,-90.824678 41.454465,-90.824736 41.454467,-90.825636 41.45458,-90.827253 41.454805,-90.82744 41.454843,-90.828516 41.455063,-90.82903 41.455127,-90.830069 41.455183,-90.831215 41.455271,-90.832275 41.455375,-90.832544 41.455398,-90.833817 41.455512,-90.835359 41.455575,-90.836265 41.455596,-90.837414 41.455623,-90.839513 41.455621,-90.840755 41.455621,-90.841547 41.455564,-90.842311 41.455518,-90.843303 41.455458,-90.844749 41.455295,-90.846558 41.455141,-90.846625 41.455132,-90.847458 41.455019,-90.849427 41.454549,-90.849663 41.454515,-90.850157 41.454444,-90.851634 41.454233,-90.85226 41.454132,-90.852886 41.45403,-90.853604 41.453909,-90.853914 41.453804,-90.854942 41.45344,-90.856398 41.453108,-90.857554 41.452751,-90.858485 41.452291,-90.859502 41.451886,-90.860626 41.451393,-90.861079 41.451152,-90.861533 41.450911,-90.862712 41.450285,-90.862754 41.450266,-90.864082 41.449679,-90.865238 41.449073,-90.866501 41.448587,-90.867282 41.448215,-90.86786 41.447884,-90.868352 41.447617,-90.86924 41.447204,-90.869276 41.447176,-90.869818 41.44676,-90.870578 41.446445,-90.871352 41.445981,-90.872129 41.445582,-90.872183 41.445555,-90.87275 41.445256,-90.87352 41.444747,-90.874098 41.444448,-90.874395 41.444269,-90.875145 41.443819,-90.875902 41.443452,-90.876117 41.443349,-90.876958 41.442871,-90.877583 41.442479,-90.877812 41.442336,-90.87808 41.442178,-90.878806 41.441753,-90.878902 41.441697,-90.879778 41.441065,-90.880996 41.440468,-90.881076 41.440421,-90.881395 41.440237,-90.88284 41.439544,-90.883972 41.438946,-90.884759 41.438532,-90.88587 41.437942,-90.887617 41.437115,-90.888138 41.436831,-90.889612 41.43603,-90.890471 41.435593,-90.890676 41.435488,-90.890787 41.435432,-90.89132 41.435242,-90.891537 41.435165,-90.89179 41.435075,-90.892042 41.434985,-90.892143 41.434949,-90.893169 41.434494,-90.893974 41.434138,-90.895623 41.433366,-90.896583 41.432823,-90.897002 41.432645,-90.897959 41.432237,-90.898338 41.432076,-90.899588 41.431552,-90.899764 41.431472,-90.900294 41.431233,-90.900471 41.431154,-90.90116 41.430901,-90.90201 41.4306,-90.902667 41.430313,-90.90315 41.430212,-90.90401 41.430048,-90.905279 41.429685,-90.906804 41.429332,-90.907911 41.429082,-90.908225 41.42902,-90.90935 41.428801,-90.910185 41.428532,-90.91021 41.428524,-90.911263 41.428216,-90.912178 41.427891,-90.91321 41.4276,-90.914662 41.427108,-90.91649 41.426531,-90.917824 41.426047,-90.91829 41.425907,-90.918716 41.425778,-90.919351 41.425589,-90.919803 41.42535,-90.920321 41.425103,-90.920968 41.424679,-90.92181 41.424184,-90.922672 41.423705,-90.923415 41.423411,-90.924343 41.42286,-90.924967 41.42263,-90.925795 41.422337,-90.927041 41.422071,-90.928276 41.421772,-90.929254 41.421544,-90.930016 41.421404,-90.930691 41.421368,-90.930978 41.421396,-90.931386 41.421438,-90.932124 41.421556,-90.932817 41.421827,-90.933802 41.421882,-90.934817 41.422091,-90.936078 41.422423,-90.937061 41.422583,-90.938045 41.422767,-90.938867 41.422927,-90.939668 41.423142,-90.940706 41.42323,-90.941659 41.423341,-90.942482 41.423436,-90.943756 41.423509,-90.944922 41.423638,-90.945452 41.423715,-90.94596 41.42379,-90.946794 41.423933,-90.947682 41.424044,-90.948464 41.424057,-90.949032 41.424053,-90.949791 41.424163,-90.950282 41.42436,-90.951179 41.42456,-90.95214 41.424841,-90.953198 41.425075,-90.95402 41.425339,-90.954735 41.42561,-90.955128 41.425879,-90.955543 41.426124,-90.95629 41.426428,-90.956736 41.426746,-90.957247 41.427016,-90.957833 41.427327,-90.958353 41.42771,-90.958864 41.428029,-90.959461 41.428275,-90.96008 41.428489,-90.960678 41.428695,-90.96131 41.428989,-90.961349 41.429007,-90.962095 41.429327,-90.962533 41.429451,-90.963025 41.42951,-90.963645 41.429652,-90.964167 41.429724,-90.964319 41.429745,-90.965014 41.429847,-90.965838 41.429925,-90.966662 41.430051,-90.967356 41.430225,-90.967879 41.430407,-90.968317 41.430539,-90.968892 41.430809,-90.969554 41.431031,-90.970173 41.431238,-90.970557 41.431394,-90.970995 41.431703,-90.97111 41.431785,-90.971875 41.432404,-90.972255 41.432705,-90.972512 41.432909,-90.972689 41.433022,-90.972701 41.43303,-90.972739 41.433054,-90.972752 41.433062,-90.972834 41.433114,-90.97308 41.433272,-90.973086 41.433276,-90.97317 41.43331,-90.973609 41.43349,-90.974185 41.433712,-90.974858 41.433902,-90.975168 41.433985,-90.975767 41.434029,-90.97673 41.434124,-90.97794 41.434229,-90.978669 41.434264,-90.979815 41.434321,-90.980329 41.434292,-90.981766 41.434221,-90.982913 41.434171,-90.983932 41.434024,-90.984898 41.433869,-90.985886 41.433689,-90.986789 41.433404,-90.987585 41.433054,-90.988436 41.432712,-90.989319 41.432273,-90.989976 41.431962,-90.99088 41.431555,-90.991859 41.431174,-90.992892 41.430752,-90.993969 41.430282,-90.994759 41.430007,-90.995022 41.429917,-90.996205 41.429496,-90.997162 41.429179,-90.998248 41.428854,-90.999257 41.428618,-91.000148 41.428414,-91.000251 41.42838,-91.000354 41.428345,-91.001177 41.428069,-91.003368 41.427337,-91.00422 41.426923,-91.005197 41.426449,-91.005846 41.426135,-91.006024 41.426105,-91.008691 41.425656,-91.009079 41.425591,-91.009445 41.425519,-91.009578 41.425493,-91.01188 41.425043,-91.01198 41.425024,-91.014619 41.424806,-91.018896 41.424514,-91.019426 41.424478,-91.021234 41.424318,-91.023708 41.424099,-91.024136 41.424062,-91.027787 41.423603,-91.030618 41.422464,-91.030886 41.422353,-91.033107 41.421439,-91.033184 41.421409,-91.033492 41.421293,-91.034416 41.420947,-91.034725 41.420832,-91.034991 41.420733,-91.035053 41.420712,-91.036046 41.420379,-91.036378 41.420269,-91.037131 41.420017,-91.03777 41.419669,-91.03824 41.419412,-91.039872 41.418523,-91.041441 41.417471,-91.04158 41.417378,-91.041719 41.417284,-91.042109 41.417023,-91.043497 41.41619,-91.043988 41.415897,-91.045063 41.414872,-91.045464 41.414489,-91.04589 41.414085,-91.046478 41.413183,-91.046581 41.413026,-91.046782 41.412719,-91.047011 41.412368,-91.047034 41.412334,-91.047642 41.41131,-91.047652 41.411286,-91.047818 41.410902,-91.048259 41.409748,-91.048261 41.409736,-91.048628 41.407972,-91.049023 41.406073,-91.049103 41.405692,-91.04931 41.40486,-91.049735 41.403153,-91.049849 41.402579,-91.050067 41.401496,-91.050328 41.400049,-91.050637 41.397327,-91.050749 41.39597,-91.050766 41.395616,-91.050843 41.394104,-91.05087 41.393275,-91.05087 41.392841,-91.050874 41.391539,-91.050875 41.391106,-91.050876 41.390872,-91.050876 41.390639,-91.050876 41.3906,-91.05092 41.389798,-91.050955 41.389187,-91.05101 41.387556,-91.051106 41.386651,-91.051358 41.385921,-91.05158 41.385283,-91.051835 41.384704,-91.051933 41.384482,-91.052512 41.383743,-91.053081 41.383101,-91.053535 41.38259,-91.054651 41.381178,-91.055598 41.380026,-91.056813 41.378928,-91.057129 41.378532,-91.057676 41.377849,-91.05851 41.377036,-91.059607 41.375867,-91.059714 41.375618,-91.059971 41.375028,-91.06109 41.373823,-91.062285 41.372535,-91.063276 41.371309,-91.063714 41.370769,-91.063746 41.370729,-91.064453 41.369851,-91.065058 41.369101,-91.065656 41.367996,-91.066232 41.366367,-91.06652 41.365246,-91.066913 41.363417,-91.066985 41.362941,-91.067105 41.362151,-91.067586 41.359319,-91.068376 41.355852,-91.068962 41.353876,-91.069763 41.350302,-91.070498 41.34627,-91.070642 41.345353,-91.070682 41.345096,-91.070723 41.344838,-91.070766 41.344565,-91.070809 41.344291,-91.070894 41.343749,-91.070979 41.343206,-91.071139 41.34219,-91.071331 41.341016,-91.071555 41.339648,-91.071682 41.338576,-91.071757 41.337615,-91.071853 41.336374,-91.07197 41.334995,-91.072002 41.334116,-91.072045 41.333599,-91.072049 41.333551,-91.072065 41.333408,-91.07207 41.333361,-91.07206 41.33282,-91.072051 41.332279,-91.072038 41.331546,-91.072113 41.32957,-91.07218 41.328537,-91.072316 41.326465,-91.072667 41.322997,-91.072784 41.321417,-91.072871 41.319941,-91.072876 41.319829,-91.073009 41.317094,-91.073147 41.314924,-91.073194 41.314092,-91.073232 41.31344,-91.073553 41.310481,-91.073795 41.309308,-91.073952 41.308543,-91.074149 41.307594,-91.074841 41.305578,-91.075545 41.304433,-91.075992 41.303715,-91.077505 41.301828,-91.079689 41.300079,-91.081553 41.2987,-91.082991 41.29755,-91.084036 41.296717,-91.086379 41.294854,-91.08688 41.294371,-91.087753 41.293129,-91.089212 41.291209,-91.090703 41.289097,-91.092034 41.286911,-91.093503 41.284,-91.094162 41.282605,-91.094652 41.281411,-91.095365 41.279661,-91.096426 41.277251,-91.098035 41.273597,-91.09894 41.271524,-91.100099 41.26904,-91.101142 41.267169,-91.103153 41.264008,-91.104462 41.262104,-91.107325 41.258943,-91.107448 41.258828,-91.109368 41.257056,-91.110304 41.256088,-91.112783 41.252531,-91.113832 41.25066,-91.114186 41.250029,-91.114182 41.249474,-91.114177 41.248814,-91.114172 41.248155,-91.114162 41.24695,-91.114153 41.245744,-91.114137 41.24504,-91.114074 41.244439,-91.114008 41.243808,-91.113934 41.243099,-91.113657 41.241401,-91.113331 41.240617,-91.113062 41.239968,-91.112348 41.239002,-91.111871 41.238573,-91.111836 41.238541,-91.110743 41.237555,-91.110422 41.237281,-91.109582 41.236566,-91.108782 41.235964,-91.107813 41.235434,-91.106215 41.234558,-91.105832 41.234269,-91.104426 41.233272,-91.102997 41.232147,-91.100856 41.230539,-91.100845 41.230531,-91.099993 41.229831,-91.098937 41.228964,-91.097477 41.2275,-91.095675 41.225513,-91.094718 41.224491,-91.09399 41.223712,-91.09303 41.222634,-91.090186 41.220431,-91.087076 41.218222,-91.083497 41.215851,-91.081452 41.214429,-91.079529 41.212776,-91.077767 41.211268,-91.076005 41.209759,-91.075725 41.209518,-91.075445 41.209276,-91.073979 41.20801,-91.072984 41.207151,-91.067832 41.2016,-91.066866 41.200558,-91.065899 41.199517,-91.064819 41.198056,-91.063758 41.19662,-91.061475 41.193756,-91.060343 41.192336,-91.060306 41.19229,-91.060268 41.192243,-91.059847 41.19172,-91.059841 41.191712,-91.059414 41.191181,-91.058362 41.189873,-91.057981 41.1894,-91.057866 41.189259,-91.055068 41.185789,-91.054349 41.184731,-91.05151 41.180553,-91.049815 41.178057,-91.047991 41.175337,-91.046392 41.172954,-91.044756 41.170446,-91.043894 41.169123,-91.041875 41.166484,-91.041557 41.166162,-91.041196 41.166041,-91.038592 41.165551,-91.038408 41.165506,-91.036923 41.165139,-91.036464 41.165009,-91.03588 41.164843,-91.034424 41.164431,-91.032192 41.164004,-91.030045 41.163553,-91.027231 41.163383,-91.025446 41.163464,-91.024086 41.163625,-91.022365 41.164036,-91.020196 41.164646,-91.020021 41.164687,-91.019825 41.164732,-91.01905 41.164912,-91.017839 41.165163,-91.016554 41.165315,-91.015076 41.165516,-91.01445 41.165616,-91.013451 41.165779,-91.01257 41.165924,-91.011463 41.166044,-91.010441 41.166154,-91.009607 41.166245,-91.009435 41.16624,-91.008112 41.166201,-91.007594 41.166187,-91.006486 41.165913,-91.005505 41.165624,-91.004326 41.165108,-91.003475 41.164736,-91.003105 41.164602,-91.001718 41.164084,-91.000813 41.163687,-91.000149 41.163396,-90.997905 41.162562,-90.997054 41.162003,-90.994963 41.16063,-90.994391 41.160119,-90.992551 41.158475,-90.992193 41.158156,-90.990867 41.156872,-90.990612 41.156625,-90.989662 41.155707,-90.987878 41.15327,-90.986069 41.150608,-90.986057 41.15058,-90.985863 41.150174,-90.985526 41.149466,-90.984996 41.148353,-90.984958 41.148274,-90.984657 41.147785,-90.983268 41.145529,-90.983064 41.145229,-90.981597 41.143073,-90.981327 41.142675,-90.979077 41.139775,-90.977542 41.138242,-90.977275 41.137976,-90.977009 41.137711,-90.976429 41.137131,-90.97493 41.13527,-90.97333 41.133285,-90.970856 41.130109,-90.970851 41.130103,-90.970721 41.12988,-90.970384 41.129306,-90.969347 41.127388,-90.968999 41.126382,-90.968851 41.125653,-90.968662 41.125254,-90.968607 41.125138,-90.968552 41.125022,-90.967949 41.123778,-90.967412 41.12267,-90.967346 41.122533,-90.966627 41.121046,-90.965908 41.119559,-90.965218 41.118912,-90.964528 41.118266,-90.963526 41.117327,-90.962708 41.116561,-90.962523 41.116387,-90.961662 41.11558,-90.960802 41.114774,-90.959502 41.11341,-90.958643 41.11251,-90.958201 41.112047,-90.957265 41.111067,-90.954444 41.107426,-90.952739 41.105227,-90.952324 41.104691,-90.950844 41.10274,-90.950453 41.102214,-90.949752 41.101271,-90.949316 41.100611,-90.949178 41.100403,-90.949066 41.100234,-90.948955 41.100065,-90.948815 41.09986,-90.948395 41.099245,-90.948256 41.099041,-90.947722 41.098246,-90.946625 41.096628,-90.946623 41.09662,-90.946444 41.095687,-90.94626 41.09473,-90.946328 41.094448,-90.946731 41.092768,-90.947476 41.090507,-90.9479 41.088106,-90.948027 41.087392,-90.948161 41.085574,-90.948162 41.085563,-90.948178 41.085203,-90.948217 41.084411,-90.948309 41.082693,-90.948397 41.081075,-90.948715 41.078364,-90.948871 41.07737,-90.949064 41.07614,-90.949208 41.075212,-90.949256 41.074909,-90.949322 41.074484,-90.949328 41.074346,-90.94939 41.072783,-90.949381 41.07271,-90.949322 41.072212,-90.949147 41.070721,-90.949135 41.07061,-90.948989 41.07025,-90.947139 41.065713,-90.946024 41.063644,-90.945549 41.06173,-90.945613 41.060336,-90.945933 41.057594,-90.945999 41.056336,-90.944577 41.052255,-90.943652 41.048637,-90.94395 41.045154,-90.943739 41.043101,-90.94297 41.040747,-90.94232 41.038472,-90.942253 41.034702,-90.943232 41.029581,-90.943826 41.026473,-90.943947 41.025842,-90.945324 41.019279,-90.945427 41.015548,-90.945054 41.011917,-90.945949 41.006495,-90.947859 41.001499,-90.948453 41.000036,-90.948763 40.998779,-90.949634 40.995248,-90.951811 40.991407,-90.955201 40.986805,-90.95546 40.986185,-90.958142 40.979767,-90.958089 40.976643,-90.956827 40.973562,-90.955111 40.969858,-90.952715 40.962087,-90.951967 40.958238,-90.952233 40.954047,-90.953542 40.95062,-90.953587 40.950502,-90.953891 40.94991,-90.957215 40.943431,-90.957249 40.94336,-90.959947 40.937736,-90.960462 40.936356,-90.961112 40.933537,-90.961892 40.928473,-90.96256 40.925831,-90.962916 40.924957,-90.965344 40.921633,-90.968995 40.919127,-90.973985 40.917392,-90.97919 40.915522,-90.985462 40.912141,-90.992922 40.909681,-90.995569 40.909136,-90.9985 40.90812,-91.000142 40.90733,-91.001684 40.906385,-91.003536 40.905146,-91.005022 40.904119,-91.007519 40.902092,-91.009536 40.900565,-91.011798 40.898437,-91.011941 40.898302,-91.012135 40.898121,-91.01324 40.896622,-91.013899 40.895619,-91.015008 40.893933,-91.01613 40.892161,-91.0174 40.890224,-91.01758 40.88995,-91.018075 40.889128,-91.019541 40.886675,-91.020013 40.885965,-91.02035 40.885567,-91.02095 40.884834,-91.021562 40.884021,-91.022337 40.883468,-91.023192 40.882775,-91.024518 40.881699,-91.026321 40.880237,-91.026853 40.87964,-91.027489 40.879173,-91.027899 40.87895,-91.028154 40.878812,-91.029075 40.878373,-91.030371 40.877771,-91.031066 40.877466,-91.032459 40.876808,-91.034552 40.876039,-91.036789 40.875038,-91.039097 40.873565,-91.041998 40.871097,-91.044653 40.868356,-91.047344 40.864654,-91.050241 40.858514,-91.051656 40.856038,-91.052778 40.854015,-91.054269 40.851747,-91.05643 40.848387,-91.058749 40.846309,-91.062226 40.844645,-91.067159 40.841997,-91.071451 40.838682,-91.077521 40.833405,-91.078285 40.832838,-91.081307 40.8306,-91.08501 40.828135,-91.090072 40.824638,-91.091569 40.822813,-91.092993 40.821079,-91.093559 40.819862,-91.095367 40.815974,-91.096683 40.812189,-91.096703 40.81213,-91.096713 40.812102,-91.096742 40.812014,-91.096946 40.811403,-91.097456 40.808865,-91.097553 40.808433,-91.097649 40.805575,-91.097319 40.804127,-91.097031 40.802471,-91.095524 40.799348,-91.094728 40.797833,-91.094331 40.797078,-91.093128 40.794841,-91.092256 40.792909,-91.091917 40.791397,-91.091664 40.790265,-91.091607 40.789789,-91.091246 40.786724,-91.091262 40.78306,-91.091332 40.782529,-91.091628 40.780275,-91.091703 40.779708,-91.092476 40.776838,-91.093426 40.774306,-91.093536 40.774016,-91.094773 40.770926,-91.096133 40.767134,-91.098105 40.763233,-91.100485 40.760017,-91.102486 40.757076,-91.105227 40.754107,-91.105473 40.753838,-91.10613 40.753117,-91.107318 40.751981,-91.1082 40.750935,-91.108566 40.750376,-91.108765 40.75004,-91.110424 40.745528,-91.114249 40.730864,-91.115735 40.725168,-91.11569 40.723938,-91.115158 40.721895,-91.114473 40.720624,-91.113885 40.719532,-91.111095 40.708282,-91.110927 40.703262,-91.11194 40.697018,-91.112467 40.696301,-91.113321 40.695142,-91.115407 40.691825,-91.117831 40.683431,-91.119632 40.675892,-91.12082 40.672777,-91.122421 40.670675,-91.123928 40.669152,-91.125144 40.668738,-91.128415 40.666762,-91.133478 40.663678,-91.138055 40.660893,-91.144963 40.657632,-91.154293 40.653596,-91.15912 40.651139,-91.163471 40.648925,-91.1751 40.643027,-91.185295 40.637803,-91.18698 40.637297,-91.192558 40.636508,-91.195505 40.636287,-91.197906 40.636107,-91.202384 40.636594,-91.211352 40.637882,-91.218437 40.638437,-91.2246 40.638473,-91.228188 40.638309,-91.23244 40.638115,-91.247851 40.63839,-91.250148 40.638175,-91.251001 40.63816,-91.251868 40.638113,-91.253074 40.637962,-91.255402 40.63745,-91.256128 40.637273,-91.256788 40.637113,-91.258249 40.636672,-91.259932 40.635981,-91.262528 40.634752,-91.26368 40.634305,-91.263831 40.634246,-91.264326 40.63409,-91.264953 40.633893,-91.26636 40.633588,-91.268116 40.633325,-91.269787 40.633142,-91.271479 40.632951,-91.273139 40.632752,-91.276175 40.63224,-91.279444 40.631503,-91.282205 40.630894,-91.284142 40.63042,-91.28667 40.6299,-91.290351 40.629275,-91.293291 40.628731,-91.295523 40.628347,-91.296037 40.628252,-91.297152 40.628052,-91.297252 40.628034,-91.297394 40.627995,-91.298134 40.627883,-91.300936 40.627372,-91.303486 40.626923,-91.305043 40.626615,-91.306568 40.626219,-91.307937 40.625814,-91.309077 40.625433,-91.310048 40.625041,-91.339719 40.613488,-91.34127 40.612835,-91.348733 40.609695,-91.353989 40.606553,-91.354874 40.605892,-91.357058 40.604263,-91.359873 40.601805,-91.364667 40.595505,-91.364752 40.595395,-91.369661 40.588822,-91.37114 40.586841,-91.374252 40.58259,-91.375152 40.581279,-91.379752 40.57445,-91.381192 40.573234,-91.381964 40.572738,-91.385219 40.570646,-91.388179 40.568608,-91.401482 40.559458,-91.405241 40.554641,-91.406331 40.551934,-91.406373 40.551831,-91.406851 40.547557,-91.406202 40.542698,-91.404125 40.539127,-91.403077 40.538406,-91.400725 40.536789,-91.394475 40.534543,-91.388067 40.533069,-91.384531 40.530948,-91.381857 40.528247,-91.377689 40.523032,-91.375152 40.519858,-91.369059 40.512532,-91.368517 40.511591,-91.367876 40.510479,-91.366846 40.507743,-91.366489 40.506795,-91.364211 40.500043,-91.363879 40.498062,-91.363683 40.494211,-91.363744 40.493124,-91.363748 40.493052,-91.36391 40.490122,-91.364915 40.484168,-91.366463 40.478869,-91.36747 40.476227,-91.368074 40.474642,-91.369572 40.47138,-91.371649 40.468185,-91.373267 40.465495,-91.373855 40.464557,-91.374208 40.463993,-91.375152 40.461983,-91.376695 40.459234,-91.378144 40.456394,-91.379907 40.45211,-91.380037 40.451697,-91.381045 40.44849,-91.381468 40.44604,-91.381769 40.442555,-91.38155 40.438885,-91.381503 40.438092,-91.381457 40.437308,-91.380965 40.435395,-91.380177 40.432904,-91.379635 40.431497,-91.378844 40.429441,-91.377738 40.426622,-91.377625 40.426335,-91.376515 40.424321,-91.375151 40.421656,-91.373721 40.417891,-91.37328 40.416496,-91.372826 40.414279,-91.37245 40.411475,-91.372402 40.408729,-91.372392 40.40726,-91.372379 40.405379,-91.372399 40.4044,-91.372435 40.40277,-91.372554 40.4012,-91.372921 40.399108,-91.372937 40.399065,-91.375151 40.393172,-91.375429 40.392719,-91.375712 40.391925,-91.376397 40.391256,-91.37647 40.391188,-91.376652 40.391018,-91.376736 40.390939,-91.376911 40.390776,-91.377672 40.390213,-91.378422 40.38967,-91.379943 40.388944,-91.381958 40.387632,-91.384201 40.38643,-91.38836 40.384929,-91.390073 40.38446,-91.391613 40.384038,-91.392179 40.383942,-91.396996 40.383127,-91.402392 40.382692,-91.411037 40.382413,-91.413011 40.382277,-91.414338 40.38195,-91.415051 40.381747,-91.415695 40.381381,-91.417066 40.380402,-91.418957 40.3787,-91.419422 40.378264,-91.419979 40.378765,-91.421028 40.37971,-91.421635 40.380286,-91.42218 40.380802,-91.422324 40.380939,-91.422408 40.380991,-91.422419 40.380998,-91.422733 40.381206,-91.423053 40.381414,-91.423282 40.381563,-91.424294 40.381961,-91.424384 40.381997,-91.424582 40.382073,-91.425662 40.382491,-91.42668 40.382601,-91.427819 40.38285,-91.428069 40.382901,-91.428708 40.38303,-91.429762 40.383318,-91.430678 40.383619,-91.43249 40.384212,-91.432699 40.384281,-91.434553 40.384876,-91.435117 40.384973,-91.435124 40.384974,-91.435145 40.384978,-91.435153 40.38498,-91.435507 40.385041,-91.435924 40.385114,-91.436565 40.385263,-91.436792 40.385317,-91.436916 40.385346,-91.437956 40.385588,-91.437979 40.385594,-91.439552 40.38607,-91.439761 40.386133,-91.441076 40.386241,-91.441243 40.386255,-91.441266 40.386237,-91.441843 40.385788,-91.441957 40.385705,-91.442306 40.385449,-91.442748 40.385128,-91.443275 40.384591,-91.443579 40.384283,-91.445168 40.382461,-91.445099 40.380837,-91.445371 40.379388,-91.446627 40.377918,-91.448742 40.376804,-91.451627 40.376019,-91.454535 40.37544,-91.458089 40.375457,-91.460395 40.375472,-91.463322 40.375628,-91.463895 40.375659,-91.465009 40.376223,-91.465619 40.377069,-91.465702 40.377464,-91.465858 40.378201,-91.465891 40.378365,-91.465809 40.378651,-91.46561 40.379314,-91.464681 40.380949,-91.463912 40.381999,-91.463656 40.382348,-91.463514 40.382543,-91.463008 40.384041,-91.463137 40.385052,-91.463146 40.385119,-91.463161 40.385136,-91.463386 40.385394,-91.463494 40.385492,-91.46355 40.385543,-91.463554 40.385547,-91.464017 40.385636,-91.464606 40.385491,-91.464885 40.385362,-91.465116 40.385257,-91.465334 40.385168,-91.467115 40.38444,-91.467855 40.384139,-91.471967 40.382884,-91.472635 40.382788,-91.474378 40.382538,-91.474538 40.382503,-91.474703 40.382468,-91.474789 40.382449,-91.474868 40.382432,-91.475333 40.382333,-91.475545 40.382287,-91.475797 40.382234,-91.476551 40.382072,-91.477735 40.381989,-91.478401 40.381943,-91.480251 40.381783,-91.482322 40.382057,-91.483153 40.382492,-91.483352 40.382745,-91.483804 40.383321,-91.484507 40.3839,-91.484627 40.383991,-91.484738 40.384114,-91.484775 40.384145,-91.484887 40.384241,-91.484925 40.384273,-91.485047 40.384471,-91.485255 40.384657,-91.48537 40.384806,-91.48555 40.385162,-91.48573 40.385574,-91.485866 40.385777,-91.485955 40.385864,-91.485996 40.385904,-91.486118 40.386134,-91.486226 40.386392,-91.486477 40.386689,-91.486542 40.386804,-91.486794 40.387095,-91.486937 40.387238,-91.487167 40.387402,-91.487275 40.387523,-91.487491 40.387852,-91.487634 40.38805,-91.487836 40.388253,-91.487929 40.388379,-91.488001 40.38844,-91.488253 40.388785,-91.488864 40.389521,-91.488971 40.389686,-91.489208 40.389944,-91.489494 40.390351,-91.48964 40.390558,-91.489755 40.390756,-91.489827 40.390943,-91.489999 40.391256,-91.490115 40.391503,-91.490273 40.391711,-91.490416 40.391964,-91.49044 40.392013,-91.49051 40.392157,-91.490721 40.392589,-91.490792 40.392733,-91.490816 40.392782,-91.490888 40.39293,-91.490912 40.39298,-91.491007 40.393706,-91.491037 40.393929,-91.490816 40.395225,-91.490502 40.395804,-91.490153 40.396449,-91.490041 40.396655,-91.490014 40.396706,-91.489875 40.396964,-91.489705 40.397277,-91.489604 40.397465,-91.489596 40.397485,-91.489099 40.398738,-91.488597 40.400009,-91.488334 40.401265,-91.487955 40.402465,-91.487935 40.402598,-91.487818 40.403415,-91.487829 40.403866,-91.487889 40.403906,-91.488166 40.404098,-91.488481 40.404317,-91.4885 40.404318,-91.489108 40.40436,-91.48928 40.404373,-91.48937 40.404375,-91.489445 40.404384,-91.489521 40.404393,-91.489553 40.404398,-91.489742 40.404339,-91.489816 40.404317,-91.490272 40.404061,-91.491641 40.403292,-91.492098 40.403037,-91.492202 40.402982,-91.492498 40.402828,-91.492517 40.402821,-91.492629 40.402782,-91.493644 40.402433,-91.494525 40.402268,-91.494592 40.402256,-91.49619 40.402192,-91.498093 40.401926,-91.498788 40.402111,-91.500156 40.402555,-91.500317 40.402578,-91.502267 40.402862,-91.502757 40.402933,-91.503461 40.403095,-91.504764 40.403395,-91.505272 40.403512,-91.506745 40.404335,-91.506792 40.404431,-91.507202 40.405266,-91.507391 40.405483,-91.507398 40.405491,-91.507419 40.405515,-91.507427 40.405524,-91.50823 40.406138,-91.509063 40.406775,-91.510288 40.407258,-91.510926 40.407458,-91.511891 40.407762,-91.512181 40.407853,-91.512664 40.408005,-91.513042 40.408156,-91.513325 40.40827,-91.513993 40.408537,-91.514297 40.40855,-91.514822 40.408573,-91.516534 40.408567,-91.517369 40.408618,-91.518392 40.408682,-91.518769 40.408753,-91.519755 40.40894,-91.519901 40.40898,-91.520272 40.409082,-91.522333 40.409648,-91.523496 40.410218,-91.524612 40.410765,-91.525309 40.411779,-91.526425 40.413404,-91.527057 40.416689,-91.527043 40.418214,-91.526839 40.418908,-91.526706 40.41936,-91.526573 40.419813,-91.526555 40.419872,-91.525268 40.421599,-91.523164 40.424176,-91.521388 40.426488,-91.521027 40.42715,-91.520884 40.427413,-91.520344 40.428403,-91.519804 40.429392,-91.51966 40.429654,-91.519517 40.429917,-91.519492 40.429951,-91.519366 40.430318,-91.519268 40.430588,-91.51917 40.430859,-91.519012 40.431298,-91.51904 40.431805,-91.519082 40.432558,-91.519086 40.432578,-91.519134 40.432822,-91.519157 40.432847,-91.51974 40.433466,-91.519935 40.433673,-91.521016 40.433719,-91.522551 40.433695,-91.522638 40.433687,-91.525 40.433483,-91.527645 40.433772,-91.529132 40.434272,-91.530355 40.434964,-91.530438 40.435033,-91.531523 40.435938,-91.532603 40.436647,-91.532807 40.436784,-91.532898 40.436911,-91.533471 40.437715,-91.533524 40.437929,-91.533623 40.43832,-91.533589 40.439454,-91.533555 40.440589,-91.533548 40.440804,-91.532837 40.44164,-91.532816 40.441666,-91.531912 40.44273,-91.529613 40.444451,-91.529098 40.444836,-91.527733 40.445657,-91.526108 40.446634,-91.524368 40.44816,-91.524053 40.448437,-91.523271 40.450061,-91.523147 40.451416,-91.523143 40.451459,-91.523131 40.451588,-91.523127 40.451631,-91.523072 40.452254,-91.5231 40.452441,-91.523379 40.454255,-91.523517 40.454847,-91.523703 40.455641,-91.523864 40.456331,-91.524518 40.457139,-91.524956 40.457679,-91.52509 40.457845,-91.526155 40.458625,-91.526783 40.458767,-91.527581 40.458948,-91.5286 40.459002,-91.530534 40.45902,-91.531915 40.458985,-91.533704 40.458942,-91.533761 40.458941,-91.534356 40.458879,-91.53452 40.458862,-91.534615 40.458851,-91.534684 40.458844,-91.535169 40.458793,-91.535394 40.458769,-91.535654 40.458742,-91.538348 40.458402,-91.541324 40.458265,-91.542566 40.458208,-91.543785 40.458149,-91.54694 40.458205,-91.548366 40.45823,-91.550598 40.458508,-91.551625 40.458636,-91.552652 40.458764,-91.552691 40.458769,-91.553752 40.458958,-91.554376 40.459068,-91.556805 40.4595,-91.558266 40.459845,-91.56057 40.460391,-91.563844 40.460988,-91.564485 40.461214,-91.566411 40.461893,-91.566638 40.461973,-91.566998 40.4621,-91.567055 40.462115,-91.567178 40.462146,-91.5673 40.462177,-91.567362 40.462192,-91.567743 40.46229,-91.568088 40.462443,-91.568254 40.462516,-91.568317 40.462544,-91.568545 40.462645,-91.570114 40.463338,-91.570916 40.463693,-91.574594 40.465586,-91.574713 40.465647,-91.574746 40.465664,-91.575598 40.466406,-91.575806 40.466586,-91.576013 40.466767,-91.577875 40.468454,-91.578189 40.468778,-91.580233 40.470889,-91.580355 40.471015,-91.581011 40.472059,-91.581528 40.472876,-91.582437 40.474703,-91.582697 40.476219,-91.582828 40.476979,-91.583315 40.479118,-91.585169 40.483611,-91.585259 40.483802,-91.585733 40.484801,-91.586884 40.487233,-91.589377 40.490898,-91.590817 40.492292,-91.592551 40.493696,-91.594644 40.494997,-91.594913 40.495103,-91.599634 40.49696,-91.599748 40.497005,-91.600155 40.497142,-91.601724 40.497672,-91.602248 40.497849,-91.602267 40.497855,-91.602324 40.497874,-91.602343 40.497881,-91.602634 40.49798,-91.602926 40.498078,-91.603136 40.49815,-91.603346 40.498221,-91.605097 40.498813,-91.608268 40.50001,-91.608347 40.50004,-91.611977 40.501938,-91.612821 40.502377,-91.616357 40.504448,-91.616948 40.504794,-91.619486 40.507134,-91.621181 40.509801,-91.621353 40.510072,-91.621554 40.510928,-91.621576 40.511018,-91.621821 40.512064,-91.622362 40.514362,-91.622192 40.517039,-91.622053 40.517404,-91.621866 40.517921,-91.621762 40.518218,-91.621532 40.518842,-91.621302 40.519467,-91.620414 40.52188,-91.61989 40.523303,-91.619526 40.524294,-91.618793 40.526286,-91.618772 40.526487,-91.618693 40.527294,-91.618608 40.528154,-91.618523 40.529015,-91.618028 40.53403,-91.61818 40.535283,-91.618367 40.536818,-91.618999 40.539084,-91.61907 40.539199,-91.620071 40.540817,-91.620412 40.541092,-91.621902 40.542292,-91.622986 40.54272,-91.623545 40.54294,-91.623906 40.543082,-91.624886 40.543408,-91.625161 40.5435,-91.625252 40.543515,-91.625845 40.543616,-91.626939 40.543807,-91.630293 40.54437,-91.630791 40.544454,-91.631167 40.544563,-91.632783 40.545029,-91.634911 40.545162,-91.635404 40.545221,-91.638082 40.545541,-91.638499 40.545626,-91.639066 40.545742,-91.639633 40.545857,-91.640018 40.545936,-91.640404 40.546014,-91.640557 40.546045,-91.64071 40.546076,-91.641498 40.546236,-91.642285 40.546397,-91.6436 40.546664,-91.64371 40.546687,-91.644995 40.546973,-91.646674 40.547371,-91.647334 40.547528,-91.647995 40.547684,-91.654345 40.549189,-91.656548 40.54942,-91.660063 40.549789,-91.662197 40.550014,-91.664213 40.55023,-91.664265 40.550236,-91.664455 40.550255,-91.664582 40.550263,-91.664886 40.550296,-91.665189 40.550328,-91.666028 40.550416,-91.666867 40.550504,-91.668448 40.55067,-91.67003 40.550836,-91.670993 40.550937,-91.678315 40.55237,-91.681714 40.553035,-91.681742 40.553052,-91.682382 40.55343,-91.683254 40.553944,-91.683943 40.554351,-91.684765 40.554837,-91.685196 40.555092,-91.687328 40.55649,-91.6887 40.55739,-91.689526 40.558373,-91.689948 40.558874,-91.690369 40.559376,-91.690547 40.559588,-91.690804 40.559893,-91.691065 40.560666,-91.691581 40.562223,-91.691563 40.564133,-91.691557 40.564839,-91.691561 40.564867,-91.691538 40.564911,-91.691382 40.565282,-91.691225 40.565652,-91.690761 40.566751,-91.690297 40.567851,-91.689967 40.568632,-91.686638 40.575026,-91.685723 40.576785,-91.685657 40.577193,-91.685381 40.578892,-91.68565 40.579439,-91.686357 40.580875,-91.686754 40.581283,-91.68882 40.583409,-91.696339 40.588135,-91.696359 40.588148,-91.697102 40.588459,-91.701242 40.59019,-91.705382 40.591921,-91.707251 40.592703,-91.707786 40.592968,-91.707932 40.593039,-91.708214 40.593176,-91.708641 40.593385,-91.709902 40.594004,-91.711163 40.594623,-91.712025 40.595046,-91.712199 40.595174,-91.712284 40.595237,-91.712369 40.595301,-91.714569 40.596915,-91.716769 40.59853,-91.720058 40.601527,-91.729115 40.61364,-91.730422 40.613581,-91.730482 40.613578,-91.737047 40.613287,-91.740622 40.613129,-91.740866 40.613119,-91.750164 40.612724,-91.762441 40.612297,-91.763056 40.612276,-91.766085 40.612173,-91.766674 40.612152,-91.769718 40.612046,-91.769735 40.612045,-91.778604 40.611815,-91.779227 40.611801,-91.785899 40.611593,-91.786395 40.611567,-91.786827 40.611545,-91.792952 40.611317,-91.794195 40.611264,-91.794992 40.611241,-91.795 40.611241,-91.795 40.611249,-91.795051 40.611249,-91.79908 40.610989,-91.799241 40.610979,-91.799746 40.610961,-91.800133 40.610949,-91.813828 40.61053,-91.813963 40.610521,-91.824194 40.610298,-91.824199 40.610304,-91.824202 40.6103,-91.824247 40.610265,-91.824309 40.610247,-91.824732 40.61022,-91.825314 40.610198,-91.826155 40.610165,-91.827063 40.610118,-91.829575 40.610021,-91.831016 40.609969,-91.831415 40.609948,-91.831431 40.609948,-91.832162 40.609912,-91.832277 40.609884,-91.832317 40.609866,-91.832343 40.609854,-91.832392 40.609805,-91.83325 40.609759,-91.833369 40.609753,-91.840663 40.6094,-91.840824 40.609392,-91.852849 40.608811,-91.8684 40.608056,-91.868731 40.608048,-91.869553 40.608032,-91.87517 40.607901,-91.883338 40.607636,-91.889747 40.607465,-91.902038 40.607138,-91.905608 40.607043,-91.907348 40.606998,-91.915831 40.606773,-91.915832 40.606772,-91.915957 40.606768,-91.916083 40.606765,-91.916201 40.606762,-91.916319 40.606759,-91.921313 40.606626,-91.922356 40.606599,-91.925396 40.606518,-91.925398 40.606518,-91.925866 40.606505,-91.936804 40.606211,-91.939305 40.606144,-91.939451 40.606146,-91.939676 40.606135,-91.943112 40.605827,-91.944167 40.605731,-91.945621 40.605599,-91.947337 40.605493,-91.947709 40.605471,-91.948153 40.605462,-91.948396 40.605457,-91.948448 40.605455,-91.948605 40.605451,-91.948658 40.605451,-91.949348 40.605437,-91.951418 40.605395,-91.952109 40.605382,-91.961695 40.605191,-91.966754 40.605151,-91.969984 40.605125,-91.970177 40.60516,-91.970755 40.605109,-91.970988 40.605112,-91.9715 40.605106,-91.982346 40.604804,-91.998645 40.604434,-91.998941 40.604436,-91.999832 40.604442,-92.000129 40.604444,-92.000303 40.604445,-92.000828 40.604451,-92.001003 40.604453,-92.006918 40.604419,-92.007824 40.604398,-92.008406 40.604378,-92.009498 40.604365,-92.012646 40.604299,-92.015248 40.604223,-92.017132 40.604157,-92.017757 40.604129,-92.018095 40.604122,-92.020963 40.604058,-92.021131 40.604053,-92.021309 40.604047,-92.022041 40.604023,-92.02345 40.603969,-92.024349 40.603928,-92.025075 40.603901,-92.026131 40.603871,-92.027849 40.603848,-92.029624 40.603819,-92.030235 40.603769,-92.030674 40.603754,-92.03081 40.603747,-92.031235 40.603739,-92.031513 40.603734,-92.031866 40.603727,-92.032276 40.60372,-92.033448 40.603684,-92.034397 40.603657,-92.034629 40.603652,-92.036467 40.603615,-92.036938 40.603595,-92.037385 40.603587,-92.037787 40.603567,-92.038382 40.603543,-92.038868 40.603541,-92.040157 40.603516,-92.04049 40.603507,-92.041501 40.60348,-92.042304 40.603452,-92.043331 40.603407,-92.043787 40.603399,-92.04418 40.603379,-92.04452 40.603376,-92.044837 40.603367,-92.045122 40.603369,-92.04584 40.603358,-92.046002 40.603341,-92.047014 40.603303,-92.049176 40.60325,-92.049817 40.603226,-92.050774 40.603198,-92.05238 40.603176,-92.052735 40.603183,-92.052736 40.603183,-92.052897 40.603186,-92.053067 40.603193,-92.053117 40.603203,-92.053236 40.603229,-92.053398 40.603226,-92.053615 40.603222,-92.053751 40.603187,-92.053773 40.603182,-92.053924 40.603151,-92.054111 40.603104,-92.054386 40.603101,-92.05481 40.603085,-92.05524 40.603089,-92.055478 40.603078,-92.055973 40.603076,-92.056461 40.603063,-92.056978 40.603057,-92.057697 40.603041,-92.058343 40.603041,-92.058702 40.603022,-92.058875 40.602979,-92.059098 40.602932,-92.059315 40.602862,-92.06022 40.60282,-92.061656 40.602794,-92.062092 40.602772,-92.062123 40.60277,-92.062605 40.602774,-92.063316 40.602747,-92.063811 40.602735,-92.063932 40.60273,-92.065464 40.602671,-92.066297 40.602645,-92.067662 40.602618,-92.067884 40.60262,-92.06791 40.602622,-92.067928 40.602623,-92.068601 40.60268,-92.068845 40.602688,-92.069233 40.602691,-92.069779 40.602684,-92.069863 40.602756,-92.069871 40.602755,-92.069872 40.602755,-92.071274 40.60269,-92.082318 40.602177,-92.082345 40.602198,-92.082453 40.602257,-92.08265 40.602268,-92.083172 40.602263,-92.083212 40.602265,-92.083279 40.602267,-92.083289 40.602271,-92.083292 40.602273,-92.08398 40.602228,-92.084961 40.602207,-92.085306 40.602203,-92.086341 40.602195,-92.086687 40.602193,-92.087255 40.602182,-92.088963 40.602152,-92.089532 40.602142,-92.090121 40.602131,-92.09189 40.602097,-92.09248 40.602087,-92.093036 40.602077,-92.093138 40.602064,-92.093155 40.602062,-92.09373 40.602025,-92.09533 40.602032,-92.095968 40.602013,-92.096239 40.602015,-92.09641 40.602005,-92.09652 40.601976,-92.096583 40.601905,-92.096611 40.601831,-92.112642 40.60187,-92.113216 40.601851,-92.114016 40.601826,-92.118141 40.601698,-92.119517 40.601656,-92.119939 40.601642,-92.121205 40.601603,-92.121628 40.60159,-92.122225 40.601571,-92.124019 40.601515,-92.124617 40.601497,-92.12463 40.601496,-92.124669 40.601495,-92.124683 40.601495,-92.125187 40.601481,-92.126458 40.601457,-92.131783 40.601358,-92.133559 40.601326,-92.144198 40.601133,-92.149659 40.601033,-92.149682 40.601033,-92.149745 40.601031,-92.159939 40.600861,-92.160255 40.600856,-92.17535 40.600603,-92.176236 40.600588,-92.178893 40.600543,-92.17978 40.600529,-92.181537 40.600489,-92.181726 40.600485,-92.195084 40.600207,-92.19532 40.600203,-92.195327 40.600203,-92.196162 40.600069,-92.196793 40.600134,-92.198165 40.600125,-92.19876 40.600129,-92.198783 40.600114,-92.198827 40.600086,-92.198951 40.600061,-92.199224 40.600057,-92.200306 40.600052,-92.200943 40.600025,-92.20162 40.600023,-92.201673 40.600018,-92.201744 40.600011,-92.201819 40.59998,-92.204903 40.599974,-92.204926 40.599974,-92.204972 40.599974,-92.205042 40.599974,-92.205114 40.599974,-92.205138 40.599974,-92.205151 40.599974,-92.205158 40.599973,-92.205165 40.599973,-92.205212 40.599973,-92.207443 40.599969,-92.20913 40.599966,-92.209175 40.599966,-92.217414 40.599834,-92.217497 40.599833,-92.217547 40.599832,-92.217555 40.599832,-92.22155 40.599769,-92.222717 40.59975,-92.226877 40.599684,-92.226884 40.599684,-92.226892 40.599684,-92.227199 40.599627,-92.228258 40.599602,-92.228814 40.599583,-92.229544 40.59958,-92.230264 40.599561,-92.231518 40.599569,-92.233368 40.599535,-92.234345 40.599502,-92.23599 40.599489,-92.236474 40.599481,-92.245792 40.59916,-92.246035 40.59915,-92.247669 40.599195,-92.250183 40.599264,-92.255586 40.59916,-92.256219 40.599148,-92.261396 40.599057,-92.265487 40.598985,-92.265861 40.598978,-92.265929 40.598977,-92.265973 40.598976,-92.265988 40.598976,-92.265996 40.598975,-92.266008 40.598975,-92.266113 40.598973,-92.266138 40.598973,-92.266357 40.598969,-92.267142 40.598955,-92.267513 40.598949,-92.267554 40.598948,-92.267581 40.598948,-92.267591 40.598948,-92.26778 40.598945,-92.267815 40.598944,-92.267985 40.598941,-92.269747 40.598909,-92.269758 40.598909,-92.26977 40.598909,-92.269781 40.598908,-92.269791 40.598908,-92.269897 40.598905,-92.270063 40.598904,-92.270076 40.598904,-92.270104 40.598904,-92.270187 40.598903,-92.293333 40.598551,-92.293392 40.59855,-92.293399 40.59855,-92.293411 40.598549,-92.293426 40.598549,-92.29344 40.598549,-92.293593 40.598546,-92.296394 40.598504,-92.29657 40.598502,-92.296747 40.598499,-92.298732 40.598469,-92.298774 40.598468,-92.299454 40.598454,-92.300291 40.598429,-92.300963 40.598415,-92.301448 40.598409,-92.301939 40.598402,-92.302096 40.5984,-92.302386 40.598394,-92.302715 40.598378,-92.302808 40.598379,-92.302973 40.59838,-92.303199 40.598369,-92.304341 40.598352,-92.305772 40.598319,-92.309517 40.598246,-92.311371 40.598204,-92.313685 40.598158,-92.31467 40.598128,-92.317537 40.598058,-92.317546 40.598057,-92.317553 40.598057,-92.317561 40.598057,-92.317816 40.598051,-92.317939 40.598049,-92.317949 40.598049,-92.317957 40.598049,-92.319362 40.59803,-92.32048 40.598007,-92.321051 40.597993,-92.321622 40.597972,-92.32471 40.597919,-92.325852 40.597896,-92.327885 40.59783,-92.328792 40.597812,-92.329699 40.597787,-92.330849 40.59777,-92.331185 40.59776,-92.331354 40.597754,-92.331443 40.597732,-92.331451 40.597729,-92.331492 40.597712,-92.336941 40.597526,-92.341658 40.597365,-92.341668 40.597365,-92.349484 40.597227,-92.350807 40.597275,-92.35089 40.59726,-92.351044 40.597245,-92.351949 40.597224,-92.355999 40.597187,-92.356355 40.597175,-92.358163 40.597117,-92.359074 40.597081,-92.359708 40.597061,-92.360384 40.597032,-92.362206 40.596987,-92.363051 40.596971,-92.368119 40.596844,-92.37539 40.596594,-92.378417 40.596485,-92.379576 40.596469,-92.386009 40.596415,-92.394114 40.596251,-92.399095 40.596151,-92.399715 40.596138,-92.400045 40.596131,-92.405632 40.59602,-92.408879 40.595954,-92.409047 40.59595,-92.415709 40.595819,-92.415802 40.595817,-92.417334 40.595786,-92.421971 40.595693,-92.423827 40.595656,-92.427773 40.595567,-92.433019 40.595451,-92.433046 40.59545,-92.433139 40.595448,-92.433159 40.595448,-92.434602 40.595416,-92.436705 40.59537,-92.438154 40.595338,-92.442055 40.595356,-92.442158 40.595355,-92.44508 40.595331,-92.447871 40.595308,-92.448097 40.595306,-92.448105 40.595306,-92.4482 40.595306,-92.453405 40.595296,-92.453438 40.5953,-92.453667 40.595326,-92.455796 40.595325,-92.456662 40.595331,-92.45824 40.595342,-92.461102 40.59531,-92.461304 40.595316,-92.461408 40.595334,-92.461461 40.595377,-92.462804 40.595275,-92.462826 40.595273,-92.469984 40.59517,-92.470221 40.595173,-92.470311 40.595174,-92.471481 40.595187,-92.473042 40.595153,-92.479345 40.595011,-92.47956 40.595006,-92.480416 40.594988,-92.481114 40.594973,-92.481148 40.594971,-92.481208 40.594968,-92.481223 40.594967,-92.481509 40.59495,-92.481517 40.59495,-92.481525 40.594949,-92.481571 40.594947,-92.481643 40.594963,-92.48183 40.595003,-92.482194 40.595038,-92.482988 40.595059,-92.483981 40.595063,-92.484513 40.595077,-92.484741 40.595083,-92.484947 40.595084,-92.485216 40.595085,-92.486396 40.595032,-92.488658 40.594949,-92.491449 40.594861,-92.492883 40.594842,-92.494075 40.594805,-92.495652 40.59477,-92.4967 40.594766,-92.497105 40.594743,-92.497163 40.59474,-92.499514 40.59461,-92.50107 40.594524,-92.502361 40.594437,-92.502624 40.594429,-92.505935 40.594328,-92.506465 40.594312,-92.508771 40.594229,-92.511275 40.594156,-92.51334 40.594089,-92.51357 40.594082,-92.51913 40.593953,-92.522245 40.593868,-92.523631 40.593829,-92.523643 40.593829,-92.523738 40.593827,-92.526499 40.593765,-92.529224 40.593684,-92.532975 40.593565,-92.535054 40.593511,-92.535141 40.593509,-92.539319 40.593399,-92.540251 40.593376,-92.540356 40.593374,-92.541889 40.59334,-92.542327 40.593342,-92.542422 40.593342,-92.542617 40.593343,-92.54394 40.593323,-92.545639 40.593279,-92.549931 40.593144,-92.552964 40.593064,-92.556693 40.592977,-92.557482 40.592973,-92.557642 40.592972,-92.557664 40.592972,-92.558568 40.592934,-92.559328 40.592909,-92.55937 40.592908,-92.560057 40.592889,-92.560742 40.592833,-92.5613 40.592814,-92.561889 40.592778,-92.562992 40.59274,-92.563776 40.592727,-92.564305 40.592712,-92.564813 40.592688,-92.565276 40.592673,-92.566589 40.592645,-92.568034 40.592608,-92.570306 40.592516,-92.572943 40.592441,-92.575204 40.592366,-92.577058 40.592322,-92.579549 40.592249,-92.579617 40.592247,-92.580025 40.592249,-92.580266 40.592258,-92.580747 40.592237,-92.580883 40.592232,-92.581019 40.592226,-92.587073 40.591966,-92.601171 40.591651,-92.60891 40.591479,-92.610664 40.59144,-92.610685 40.59144,-92.612931 40.59139,-92.615439 40.591334,-92.615565 40.591331,-92.618372 40.591268,-92.625191 40.591044,-92.631441 40.590997,-92.631711 40.590995,-92.631946 40.590994,-92.632282 40.590992,-92.634164 40.590944,-92.634175 40.590944,-92.635043 40.590922,-92.637898 40.590853,-92.639225 40.590829,-92.647773 40.59065,-92.650407 40.590597,-92.657248 40.590429,-92.658187 40.590407,-92.658372 40.590397,-92.659409 40.590341,-92.668484 40.590205,-92.685885 40.589869,-92.686282 40.589861,-92.686693 40.589809,-92.686851 40.589839,-92.688412 40.589922,-92.689074 40.589882,-92.689546 40.5899,-92.690437 40.589852,-92.696639 40.589704,-92.696787 40.589701,-92.696828 40.589701,-92.713177 40.589423,-92.713462 40.589425,-92.714371 40.589431,-92.714596 40.589427,-92.714677 40.589426,-92.714758 40.589424,-92.722891 40.589286,-92.72521 40.589277,-92.729024 40.589261,-92.742316 40.589205,-92.742316 40.589204,-92.742458 40.58917,-92.746547 40.589054,-92.748276 40.589031,-92.748277 40.58903,-92.748755 40.589023,-92.748809 40.589023,-92.752892 40.588968,-92.752893 40.588968,-92.753682 40.588957,-92.757123 40.588909,-92.757123 40.588908,-92.757123 40.588907,-92.757123 40.588906,-92.757123 40.588905,-92.757123 40.588904,-92.757123 40.588903,-92.757123 40.588902,-92.775087 40.588713,-92.775414 40.588708,-92.781167 40.588592,-92.781269 40.58859,-92.781317 40.58859,-92.785411 40.588619,-92.795734 40.588688,-92.795772 40.588688,-92.802642 40.588622,-92.802713 40.588622,-92.816228 40.588542,-92.816429 40.588543,-92.823192 40.588578,-92.823269 40.588578,-92.823346 40.588578,-92.824756 40.588585,-92.827853 40.588602,-92.827845 40.588593,-92.827785 40.58845,-92.828016 40.588468,-92.828719 40.588469,-92.830805 40.588456,-92.831273 40.588465,-92.834058 40.588451,-92.834785 40.588452,-92.834977 40.588451,-92.846811 40.588418,-92.848765 40.588406,-92.854627 40.588374,-92.856445 40.588365,-92.856582 40.588363,-92.857044 40.588358,-92.857045 40.588358,-92.857053 40.588269,-92.857117 40.58822,-92.857219 40.588199,-92.857568 40.588199,-92.857571 40.588199,-92.859457 40.588201,-92.861478 40.588212,-92.86148 40.588213,-92.862452 40.588219,-92.862896 40.588227,-92.863072 40.588213,-92.863192 40.588178,-92.867308 40.588178,-92.8752 40.588392,-92.879178 40.588341,-92.879462 40.588337,-92.886341 40.588248,-92.889746 40.588042,-92.889806 40.588004,-92.889963 40.587978,-92.890181 40.587958,-92.890661 40.587958,-92.891533 40.587966,-92.893618 40.587968,-92.896191 40.587984,-92.899514 40.587973,-92.903081 40.587956,-92.903587 40.587943,-92.903744 40.587924,-92.903899 40.587864,-92.9074 40.587978,-92.916344 40.587863,-92.918038 40.587842,-92.932269 40.587657,-92.932555 40.587654,-92.941592 40.587614,-92.94174 40.587606,-92.94198 40.587611,-92.942651 40.587611,-92.943061 40.587604,-92.943241 40.587649,-92.943361 40.587695,-92.943472 40.587762,-92.943541 40.587695,-92.943701 40.587619,-92.943911 40.587574,-92.944282 40.587558,-92.945632 40.587544,-92.947243 40.587514,-92.948924 40.587492,-92.950395 40.587462,-92.951405 40.587432,-92.952616 40.587425,-92.954437 40.587372,-92.954937 40.587369,-92.955628 40.587365,-92.956595 40.587365,-92.957268 40.587366,-92.957646 40.587361,-92.957827 40.587359,-92.959029 40.587343,-92.96099 40.587336,-92.961591 40.587337,-92.962591 40.587322,-92.963782 40.587292,-92.965283 40.587262,-92.966422 40.587223,-92.966623 40.587216,-92.968604 40.587179,-92.970165 40.587141,-92.971856 40.587108,-92.97192 40.587106,-92.972436 40.587096,-92.973889 40.587074,-92.973891 40.587074,-92.976038 40.587042,-92.97634 40.587037,-92.978169 40.587005,-92.97963 40.586975,-92.980721 40.586957,-92.980869 40.586955,-92.981151 40.586953,-92.982372 40.586931,-92.982872 40.586922,-92.984102 40.586892,-92.985008 40.586887,-92.985385 40.586875,-92.985613 40.586867,-92.985613 40.586866,-92.985773 40.586862,-92.987203 40.586841,-92.990425 40.586786,-92.991896 40.586771,-92.992186 40.586764,-92.997109 40.586649,-92.998349 40.586626,-92.99894 40.586603,-92.99958 40.586588,-93.00034 40.586557,-93.0012 40.586546,-93.00121 40.586546,-93.006463 40.586443,-93.010305 40.586359,-93.011786 40.586336,-93.012156 40.586326,-93.012915 40.586301,-93.0135 40.586297,-93.01722 40.586201,-93.019166 40.586147,-93.023544 40.586045,-93.024413 40.586013,-93.024849 40.585997,-93.028037 40.585908,-93.028741 40.585889,-93.030805 40.585817,-93.031082 40.585809,-93.031175 40.585807,-93.034017 40.585726,-93.034416 40.585722,-93.034488 40.585721,-93.034488 40.58572,-93.0363 40.585702,-93.039012 40.585643,-93.040348 40.585617,-93.040418 40.585614,-93.040542 40.58561,-93.043889 40.585484,-93.044499 40.585461,-93.048712 40.585328,-93.051306 40.585279,-93.053229 40.585248,-93.054941 40.585206,-93.055465 40.585182,-93.056559 40.585116,-93.057098 40.58508,-93.057395 40.585066,-93.057739 40.58505,-93.05883 40.58504,-93.058906 40.585039,-93.059201 40.585037,-93.060562 40.584999,-93.061374 40.584976,-93.064113 40.584862,-93.065435 40.584826,-93.066599 40.5848,-93.067114 40.584789,-93.067921 40.58476,-93.069703 40.584687,-93.070116 40.58466,-93.070993 40.584639,-93.071243 40.584633,-93.07262 40.584607,-93.074186 40.584584,-93.077319 40.584518,-93.07775 40.584513,-93.077788 40.584512,-93.079138 40.584495,-93.083922 40.58437,-93.085272 40.584341,-93.085852 40.584326,-93.089784 40.584262,-93.092044 40.584188,-93.092086 40.584186,-93.092213 40.584182,-93.092256 40.584181,-93.092286 40.58418,-93.092377 40.584176,-93.092408 40.584176,-93.092604 40.584169,-93.09276 40.584163,-93.09285 40.584161,-93.093817 40.584129,-93.09417 40.584118,-93.094795 40.584097,-93.09667 40.584034,-93.097296 40.584014,-93.098529 40.583956,-93.098593 40.583953,-93.101499 40.583874,-93.101566 40.583872,-93.1016 40.583871,-93.101603 40.583871,-93.101615 40.583871,-93.103065 40.583832,-93.103067 40.583832,-93.117909 40.583339,-93.117949 40.583338,-93.117972 40.583337,-93.117977 40.583337,-93.117984 40.583337,-93.117985 40.583336,-93.117988 40.583336,-93.117991 40.583336,-93.117998 40.583336,-93.119806 40.583276,-93.119894 40.583274,-93.119901 40.583274,-93.119905 40.583274,-93.11991 40.583274,-93.119993 40.583272,-93.120004 40.583272,-93.125208 40.583164,-93.127294 40.583103,-93.127315 40.583102,-93.129571 40.583036,-93.129595 40.583036,-93.12981 40.583029,-93.130557 40.583007,-93.130604 40.583006,-93.13253 40.582949,-93.132541 40.582949,-93.132778 40.582942,-93.13278 40.582942,-93.135802 40.582854,-93.141078 40.582793,-93.1444 40.582732,-93.147701 40.58267,-93.147723 40.58267,-93.147776 40.58267,-93.147983 40.582665,-93.14799 40.582665,-93.147997 40.582665,-93.148038 40.582665,-93.157224 40.582497,-93.157602 40.58249,-93.157762 40.582487,-93.157807 40.582486,-93.157833 40.582486,-93.157851 40.582486,-93.157857 40.582486,-93.15792 40.582485,-93.157962 40.582484,-93.159127 40.582463,-93.159222 40.582461,-93.166399 40.58233,-93.166404 40.58233,-93.177659 40.582115,-93.177721 40.582114,-93.177773 40.582113,-93.177778 40.582113,-93.177779 40.582112,-93.177781 40.582112,-93.177788 40.582112,-93.177795 40.582112,-93.1778 40.582112,-93.177833 40.582111,-93.178154 40.582105,-93.183697 40.581999,-93.18371 40.581999,-93.184755 40.581986,-93.185734 40.581973,-93.1858 40.581972,-93.189123 40.58193,-93.189199 40.581929,-93.189208 40.581929,-93.189232 40.581929,-93.189298 40.581928,-93.191332 40.581902,-93.196448 40.581837,-93.196785 40.581833,-93.196877 40.581832,-93.197212 40.58183,-93.197294 40.581829,-93.201236 40.581806,-93.20179 40.581804,-93.204098 40.581765,-93.210739 40.581653,-93.211568 40.581639,-93.212396 40.581625,-93.221626 40.581449,-93.225861 40.581407,-93.230117 40.581363,-93.230848 40.581358,-93.231188 40.581354,-93.231559 40.58135,-93.2316 40.58135,-93.232178 40.581343,-93.232247 40.581342,-93.232261 40.581342,-93.232269 40.581342,-93.232275 40.581342,-93.23228 40.581342,-93.232283 40.581342,-93.232285 40.581341,-93.232307 40.581341,-93.232396 40.58134,-93.232816 40.581335,-93.233744 40.581324,-93.233942 40.581322,-93.233994 40.581321,-93.234372 40.581317,-93.241467 40.58124,-93.241476 40.58124,-93.250552 40.580939,-93.251695 40.580924,-93.258559 40.580838,-93.258566 40.580838,-93.258571 40.580838,-93.258574 40.580838,-93.258577 40.580838,-93.258578 40.580837,-93.258597 40.580837,-93.258613 40.580837,-93.258615 40.580837,-93.258621 40.580837,-93.258627 40.580837,-93.258635 40.580837,-93.258643 40.580837,-93.25865 40.580837,-93.258654 40.580837,-93.258656 40.580836,-93.258658 40.580836,-93.258689 40.580836,-93.260429 40.580814,-93.260444 40.580814,-93.260492 40.580818,-93.260494 40.580818,-93.260496 40.580818,-93.260498 40.580818,-93.2605 40.580818,-93.260502 40.580818,-93.260504 40.580818,-93.260506 40.580818,-93.260508 40.580818,-93.26051 40.580818,-93.260512 40.580818,-93.260514 40.580818,-93.260516 40.580818,-93.260518 40.580818,-93.26052 40.580818,-93.260522 40.580818,-93.260524 40.580818,-93.260526 40.580818,-93.260528 40.580818,-93.26053 40.580818,-93.260532 40.580818,-93.260534 40.580818,-93.260536 40.580818,-93.260538 40.580818,-93.26054 40.580818,-93.260542 40.580818,-93.260544 40.580818,-93.260546 40.580818,-93.260548 40.580818,-93.26055 40.580818,-93.260552 40.580818,-93.260554 40.580818,-93.260556 40.580818,-93.260558 40.580818,-93.260561 40.580818,-93.260564 40.580818,-93.260567 40.580818,-93.26057 40.580818,-93.260573 40.580818,-93.260576 40.580818,-93.260579 40.580818,-93.260582 40.580818,-93.260586 40.580818,-93.26059 40.580818,-93.260594 40.580818,-93.260598 40.580818,-93.260602 40.580818,-93.260607 40.580818,-93.260612 40.580818,-93.260617 40.580818,-93.260623 40.580818,-93.260629 40.580818,-93.260635 40.580818,-93.260642 40.580818,-93.260649 40.580818,-93.260657 40.580818,-93.260665 40.580818,-93.260674 40.580818,-93.260684 40.580818,-93.260695 40.580818,-93.260707 40.580818,-93.26072 40.580818,-93.260734 40.580818,-93.26075 40.580818,-93.260767 40.580818,-93.260786 40.580818,-93.260808 40.580818,-93.260833 40.580818,-93.260861 40.580818,-93.261794 40.580826,-93.262615 40.580817,-93.262637 40.580817,-93.262649 40.580817,-93.262655 40.580817,-93.262656 40.580816,-93.262658 40.580816,-93.262661 40.580816,-93.262706 40.580816,-93.262751 40.580816,-93.262795 40.580816,-93.262837 40.580816,-93.262878 40.580816,-93.262917 40.580816,-93.262955 40.580816,-93.262991 40.580816,-93.263025 40.580816,-93.263057 40.580816,-93.263087 40.580816,-93.263115 40.580816,-93.263141 40.580816,-93.263165 40.580816,-93.263187 40.580816,-93.263207 40.580816,-93.266231 40.580795,-93.266863 40.580794,-93.26687 40.580794,-93.268949 40.580789,-93.268952 40.580789,-93.268963 40.580789,-93.270147 40.580786,-93.271492 40.580781,-93.271494 40.580781,-93.271497 40.580781,-93.271502 40.580781,-93.271512 40.580781,-93.271529 40.580781,-93.271561 40.580781,-93.271622 40.580781,-93.273024 40.580777,-93.273199 40.580778,-93.273211 40.580778,-93.273215 40.580778,-93.273217 40.580778,-93.273541 40.580781,-93.274237 40.580765,-93.275488 40.580748,-93.27782 40.580759,-93.278109 40.580758,-93.278111 40.580758,-93.278118 40.580758,-93.279429 40.580754,-93.279454 40.580754,-93.280406 40.580759,-93.281879 40.58075,-93.281883 40.58075,-93.281901 40.58075,-93.282014 40.580749,-93.282016 40.580749,-93.282018 40.580749,-93.28202 40.580749,-93.282023 40.580749,-93.282027 40.580749,-93.282035 40.580749,-93.282048 40.580749,-93.2829 40.580744,-93.284247 40.580754,-93.284409 40.580755,-93.284542 40.580756,-93.28739 40.580761,-93.287846 40.580762,-93.288331 40.580763,-93.288858 40.580764,-93.288893 40.580774,-93.288897 40.580775,-93.288912 40.580779,-93.288918 40.580781,-93.288971 40.580772,-93.288972 40.580771,-93.288974 40.580771,-93.289082 40.580753,-93.289123 40.580752,-93.28955 40.580746,-93.289678 40.580739,-93.289695 40.580738,-93.289697 40.580738,-93.289702 40.580738,-93.290313 40.580706,-93.290315 40.580706,-93.290317 40.580706,-93.290319 40.580706,-93.29034 40.580705,-93.291041 40.580704,-93.291931 40.580708,-93.291949 40.580715,-93.291951 40.580715,-93.291953 40.580715,-93.291955 40.580715,-93.291957 40.580715,-93.291959 40.580715,-93.291961 40.580715,-93.291963 40.580715,-93.291965 40.580715,-93.291967 40.580715,-93.291969 40.580715,-93.291971 40.580715,-93.291973 40.580715,-93.291975 40.580715,-93.291977 40.580715,-93.291979 40.580715,-93.291981 40.580715,-93.291983 40.580715,-93.291985 40.580715,-93.291987 40.580715,-93.291989 40.580715,-93.291991 40.580715,-93.291993 40.580715,-93.291995 40.580715,-93.291997 40.580715,-93.291999 40.580715,-93.292001 40.580715,-93.292003 40.580715,-93.292006 40.580715,-93.292009 40.580715,-93.292012 40.580715,-93.292015 40.580715,-93.292018 40.580715,-93.292021 40.580715,-93.292024 40.580715,-93.292028 40.580715,-93.292032 40.580715,-93.292036 40.580715,-93.29204 40.580715,-93.292044 40.580715,-93.292049 40.580715,-93.292054 40.580715,-93.292059 40.580715,-93.292064 40.580715,-93.29207 40.580715,-93.292076 40.580715,-93.292082 40.580715,-93.292089 40.580715,-93.292096 40.580715,-93.292103 40.580715,-93.292111 40.580715,-93.292119 40.580715,-93.292128 40.580715,-93.292138 40.580715,-93.292148 40.580715,-93.292159 40.580715,-93.292171 40.580715,-93.292184 40.580715,-93.292198 40.580715,-93.292213 40.580715,-93.29223 40.580715,-93.292248 40.580715,-93.292268 40.580715,-93.293364 40.580736,-93.294442 40.58074,-93.295242 40.580738,-93.295255 40.580738,-93.295296 40.580738,-93.295691 40.580705,-93.296319 40.580712,-93.296325 40.580712,-93.296336 40.580712,-93.2967 40.580716,-93.296734 40.580716,-93.296761 40.580716,-93.296783 40.580716,-93.296801 40.580716,-93.296816 40.580716,-93.296828 40.580716,-93.296838 40.580716,-93.296847 40.580716,-93.296854 40.580716,-93.29686 40.580716,-93.296866 40.580716,-93.296871 40.580716,-93.296875 40.580716,-93.296879 40.580716,-93.296882 40.580716,-93.296885 40.580716,-93.296887 40.580716,-93.296889 40.580716,-93.296891 40.580716,-93.296894 40.580716,-93.296896 40.580716,-93.296898 40.580716,-93.2969 40.580716,-93.296902 40.580716,-93.297272 40.580723,-93.297664 40.580722,-93.297935 40.580731,-93.299702 40.580726,-93.299835 40.580709,-93.300007 40.580687,-93.301175 40.580703,-93.30152 40.580712,-93.30153 40.580712,-93.301535 40.580712,-93.301537 40.580712,-93.301539 40.580712,-93.30154 40.580713,-93.301559 40.580713,-93.302101 40.580726,-93.302934 40.580731,-93.303249 40.580728,-93.303251 40.580728,-93.303254 40.580728,-93.30326 40.580728,-93.303274 40.580728,-93.303807 40.580724,-93.303811 40.580724,-93.305251 40.580713,-93.305439 40.580711,-93.306095 40.58069,-93.307033 40.580715,-93.307037 40.580715,-93.30704 40.580715,-93.307043 40.580715,-93.307045 40.580715,-93.307047 40.580715,-93.307049 40.580715,-93.307051 40.580715,-93.307053 40.580715,-93.307627 40.580731,-93.309059 40.580714,-93.309424 40.580695,-93.309427 40.580695,-93.309431 40.580695,-93.309436 40.580695,-93.309442 40.580695,-93.309449 40.580695,-93.309457 40.580695,-93.30946 40.580695,-93.309462 40.580694,-93.309466 40.580694,-93.309688 40.580681,-93.310441 40.580685,-93.310444 40.580685,-93.310452 40.580685,-93.310475 40.580685,-93.312266 40.580693,-93.312398 40.580688,-93.312456 40.580686,-93.316478 40.58065,-93.317108 40.580653,-93.317278 40.580663,-93.317377 40.58066,-93.317401 40.580659,-93.317404 40.580659,-93.317448 40.580658,-93.317468 40.580657,-93.317486 40.580657,-93.317486 40.580661,-93.317486 40.580674,-93.327761 40.580527,-93.33395 40.580441,-93.334534 40.580442,-93.334628 40.580443,-93.334682 40.580443,-93.334791 40.580443,-93.33837 40.580452,-93.341955 40.580461,-93.345489 40.580514,-93.345496 40.580514,-93.345501 40.580514,-93.345503 40.580514,-93.345529 40.580515,-93.345947 40.580486,-93.345949 40.580486,-93.345952 40.580486,-93.345954 40.580485,-93.345957 40.580485,-93.346392 40.580455,-93.346439 40.580452,-93.346449 40.580458,-93.346451 40.580458,-93.346453 40.580458,-93.346455 40.580458,-93.346457 40.580458,-93.346459 40.580458,-93.346461 40.580458,-93.346463 40.580458,-93.346465 40.580458,-93.346467 40.580458,-93.346469 40.580458,-93.34652 40.580468,-93.346944 40.580464,-93.346946 40.580464,-93.346948 40.580464,-93.34695 40.580464,-93.346952 40.580464,-93.346954 40.580464,-93.346956 40.580464,-93.346958 40.580464,-93.34696 40.580464,-93.346962 40.580464,-93.346964 40.580464,-93.346966 40.580464,-93.346968 40.580464,-93.34697 40.580464,-93.346972 40.580464,-93.346974 40.580464,-93.346976 40.580464,-93.346978 40.580464,-93.346981 40.580464,-93.346984 40.580464,-93.346987 40.580464,-93.34699 40.580464,-93.346993 40.580464,-93.346996 40.580464,-93.347 40.580464,-93.347004 40.580464,-93.347008 40.580464,-93.347012 40.580464,-93.347017 40.580464,-93.347022 40.580464,-93.347027 40.580464,-93.347033 40.580464,-93.347039 40.580464,-93.347046 40.580464,-93.347053 40.580464,-93.347061 40.580464,-93.34707 40.580464,-93.347079 40.580464,-93.347089 40.580464,-93.3471 40.580464,-93.347112 40.580464,-93.347125 40.580464,-93.34714 40.580464,-93.347156 40.580464,-93.347174 40.580464,-93.347194 40.580464,-93.347216 40.580464,-93.347241 40.580464,-93.347269 40.580464,-93.347301 40.580464,-93.347746 40.580462,-93.347929 40.580464,-93.347948 40.580464,-93.347953 40.580464,-93.347954 40.580465,-93.347956 40.580465,-93.347958 40.580465,-93.347967 40.580465,-93.34801 40.580465,-93.348059 40.580465,-93.348114 40.580465,-93.348174 40.580465,-93.348238 40.580465,-93.348305 40.580465,-93.348374 40.580465,-93.348442 40.580465,-93.348476 40.580465,-93.348506 40.580465,-93.348534 40.580465,-93.34856 40.580465,-93.348583 40.580465,-93.348605 40.580465,-93.348625 40.580465,-93.348644 40.580465,-93.348661 40.580465,-93.348677 40.580465,-93.348692 40.580465,-93.348706 40.580465,-93.348719 40.580465,-93.348731 40.580465,-93.348742 40.580465,-93.348753 40.580465,-93.348763 40.580465,-93.348773 40.580465,-93.348782 40.580465,-93.348791 40.580465,-93.348799 40.580465,-93.348807 40.580465,-93.348814 40.580465,-93.348821 40.580465,-93.348827 40.580465,-93.348833 40.580465,-93.348839 40.580465,-93.348845 40.580465,-93.34885 40.580465,-93.348855 40.580465,-93.34886 40.580465,-93.348865 40.580465,-93.348869 40.580465,-93.348873 40.580465,-93.348877 40.580465,-93.348881 40.580465,-93.348885 40.580465,-93.348888 40.580465,-93.348891 40.580465,-93.348894 40.580465,-93.348897 40.580465,-93.3489 40.580465,-93.348903 40.580465,-93.348906 40.580465,-93.348909 40.580465,-93.348911 40.580465,-93.348913 40.580465,-93.348915 40.580465,-93.348917 40.580465,-93.348919 40.580465,-93.348921 40.580465,-93.348923 40.580465,-93.348925 40.580465,-93.348927 40.580465,-93.348929 40.580465,-93.348931 40.580465,-93.348934 40.580465,-93.348936 40.580465,-93.348938 40.580465,-93.34894 40.580465,-93.348942 40.580465,-93.348944 40.580465,-93.348946 40.580465,-93.348948 40.580465,-93.34895 40.580465,-93.348952 40.580465,-93.348954 40.580465,-93.348956 40.580465,-93.348958 40.580465,-93.34896 40.580465,-93.34954 40.580457,-93.350133 40.580444,-93.350884 40.580439,-93.350962 40.58044,-93.351442 40.580446,-93.354122 40.580409,-93.354147 40.580409,-93.354148 40.580408,-93.35415 40.580408,-93.354154 40.580408,-93.354161 40.580408,-93.354171 40.580408,-93.354919 40.580398,-93.355606 40.580398,-93.356633 40.580398,-93.357339 40.580386,-93.357342 40.580386,-93.357344 40.580385,-93.357348 40.580385,-93.357356 40.580385,-93.357369 40.580385,-93.357382 40.580385,-93.358105 40.580372,-93.360776 40.58036,-93.36079 40.58036,-93.360807 40.58036,-93.361701 40.580348,-93.362626 40.580337,-93.363247 40.580329,-93.363268 40.580329,-93.363284 40.580329,-93.363288 40.580329,-93.36329 40.580329,-93.363291 40.580328,-93.363293 40.580328,-93.363302 40.580328,-93.363337 40.580328,-93.363358 40.580328,-93.363453 40.580327,-93.363731 40.580326,-93.363767 40.580326,-93.363795 40.580326,-93.364048 40.580325,-93.364173 40.580324,-93.365978 40.580316,-93.367935 40.580323,-93.36826 40.58032,-93.369436 40.58031,-93.369446 40.58031,-93.369448 40.580311,-93.36945 40.580311,-93.369453 40.580311,-93.369665 40.580331,-93.369667 40.580331,-93.369687 40.580333,-93.369697 40.580335,-93.369699 40.580336,-93.369707 40.580338,-93.36972 40.580341,-93.369736 40.580345,-93.36974 40.580346,-93.369742 40.580347,-93.369746 40.580348,-93.369761 40.580352,-93.369817 40.580366,-93.369917 40.580391,-93.369919 40.580392,-93.369924 40.580393,-93.369958 40.580401,-93.370069 40.580443,-93.370173 40.580501,-93.370181 40.580505,-93.370187 40.580508,-93.370202 40.580527,-93.370336 40.580437,-93.370519 40.580357,-93.370653 40.580327,-93.370858 40.580319,-93.371613 40.580303,-93.372707 40.5803,-93.372956 40.580304,-93.372991 40.580305,-93.373044 40.580306,-93.373066 40.580306,-93.373084 40.580306,-93.373677 40.580315,-93.37419 40.580328,-93.374194 40.580328,-93.37421 40.580328,-93.374257 40.580329,-93.374263 40.580329,-93.374265 40.580329,-93.374268 40.58033,-93.374271 40.58033,-93.37428 40.58033,-93.374286 40.58033,-93.374386 40.580333,-93.375499 40.58036,-93.376185 40.580369,-93.376542 40.580369,-93.376994 40.580333,-93.378484 40.580215,-93.378954 40.580199,-93.379774 40.580214,-93.380262 40.580237,-93.380422 40.580238,-93.381041 40.58023,-93.381312 40.580227,-93.385535 40.580194,-93.385601 40.580193,-93.385893 40.580194,-93.3861 40.580195,-93.386299 40.580223,-93.38657 40.580273,-93.38683 40.580331,-93.387026 40.580346,-93.387346 40.580321,-93.387798 40.580295,-93.388225 40.580289,-93.389032 40.580269,-93.389888 40.580262,-93.390791 40.58027,-93.392543 40.580255,-93.392935 40.580238,-93.393318 40.580204,-93.393716 40.580158,-93.39851 40.580105,-93.398817 40.580106,-93.401005 40.580115,-93.402822 40.580102,-93.404136 40.580104,-93.406476 40.580096,-93.408386 40.580111,-93.409229 40.580097,-93.41003 40.580091,-93.41022 40.58009,-93.410954 40.580084,-93.412247 40.580086,-93.412793 40.580096,-93.412847 40.580113,-93.413102 40.58011,-93.41457 40.580095,-93.416373 40.580092,-93.417482 40.580081,-93.419111 40.580075,-93.420341 40.580066,-93.42199 40.580029,-93.422546 40.580018,-93.424809 40.580017,-93.425074 40.580016,-93.42995 40.580001,-93.432014 40.579979,-93.435348 40.579967,-93.435786 40.579962,-93.4375 40.57994,-93.441647 40.579951,-93.455089 40.580013,-93.465297 40.580164,-93.466887 40.580072,-93.485195 40.580386,-93.488329 40.580384,-93.489046 40.580384,-93.496899 40.580381,-93.4978 40.580351,-93.497877 40.580348,-93.497915 40.580347,-93.500218 40.58027,-93.504584 40.580294,-93.509487 40.580322,-93.509685 40.580346,-93.509896 40.580351,-93.510053 40.580355,-93.510157 40.580358,-93.513635 40.580393,-93.515441 40.580411,-93.5155 40.580412,-93.516593 40.58042,-93.518876 40.58044,-93.520244 40.580439,-93.520549 40.580439,-93.520934 40.580439,-93.521154 40.58044,-93.521651 40.580442,-93.521919 40.580443,-93.5224 40.580445,-93.52274 40.580446,-93.522902 40.580447,-93.523242 40.580455,-93.523307 40.580457,-93.52332 40.580457,-93.523397 40.580459,-93.523939 40.580473,-93.524597 40.580489,-93.525227 40.580505,-93.525695 40.580503,-93.525792 40.580503,-93.526315 40.580502,-93.526709 40.580501,-93.526918 40.580499,-93.526969 40.580499,-93.527057 40.580498,-93.527116 40.580497,-93.527274 40.580496,-93.527331 40.580487,-93.527609 40.580448,-93.528177 40.580367,-93.532717 40.580335,-93.532803 40.580335,-93.53293 40.580335,-93.542464 40.580333,-93.547578 40.580407,-93.54762 40.580394,-93.54765 40.580391,-93.547848 40.580371,-93.547975 40.580368,-93.548615 40.58037,-93.552386 40.580315,-93.55339 40.5803,-93.553417 40.5803,-93.553557 40.580287,-93.553988 40.58028,-93.556899 40.580235,-93.558951 40.580112,-93.55917 40.580148,-93.560029 40.580158,-93.560796 40.580147,-93.565176 40.580087,-93.565657 40.580093,-93.56575 40.580094,-93.565809 40.580095,-93.565951 40.580097,-93.566181 40.580106,-93.566184 40.580106,-93.566186 40.580106,-93.566196 40.580106,-93.566406 40.580115,-93.566414 40.580115,-93.566423 40.580115,-93.566428 40.580115,-93.56643 40.580115,-93.566431 40.580116,-93.566433 40.580116,-93.566519 40.58012,-93.566524 40.58012,-93.566528 40.58012,-93.566975 40.580138,-93.567659 40.580111,-93.567662 40.580111,-93.567666 40.580111,-93.567814 40.580105,-93.567816 40.580105,-93.568517 40.580077,-93.568705 40.580072,-93.573431 40.579957,-93.57344 40.579957,-93.573452 40.579957,-93.573454 40.579957,-93.573456 40.579957,-93.573457 40.579956,-93.573461 40.579956,-93.573468 40.579956,-93.573522 40.579955,-93.573541 40.579955,-93.578183 40.579843,-93.580762 40.579793,-93.58339 40.579734,-93.583392 40.579734,-93.58596 40.579677,-93.586994 40.579662,-93.588063 40.579634,-93.589545 40.579618,-93.591164 40.579568,-93.596292 40.579455,-93.596295 40.579455,-93.596693 40.579446,-93.59713 40.579444,-93.597133 40.579443,-93.597135 40.579443,-93.597137 40.579443,-93.597139 40.579443,-93.597141 40.579443,-93.597144 40.579443,-93.597377 40.579431,-93.597381 40.579431,-93.610511 40.57918,-93.613997 40.579132,-93.616406 40.579099,-93.62316 40.579005,-93.623317 40.579001,-93.625221 40.578812,-93.631012 40.578724,-93.637169 40.578631,-93.64662 40.578493,-93.646992 40.578488,-93.647003 40.578488,-93.656211 40.578352,-93.659272 40.57833,-93.660353 40.578376,-93.661913 40.578354,-93.662538 40.57834,-93.66254 40.57834,-93.662542 40.57834,-93.662546 40.57834,-93.662551 40.57834,-93.662556 40.57834,-93.66256 40.57834,-93.662561 40.578339,-93.662563 40.578339,-93.662786 40.578334,-93.663027 40.578329,-93.666912 40.578242,-93.666985 40.57824,-93.668825 40.578241,-93.668845 40.578241,-93.669106 40.578232,-93.670629 40.578177,-93.671249 40.578173,-93.675748 40.57815,-93.677155 40.578088,-93.677407 40.578095,-93.677567 40.578099,-93.682522 40.578037,-93.682542 40.578037,-93.682567 40.578037,-93.682629 40.578036,-93.682673 40.578035,-93.682897 40.578032,-93.684023 40.578014,-93.684029 40.578014,-93.684031 40.578014,-93.684033 40.578013,-93.684036 40.578013,-93.684047 40.578013,-93.684059 40.578013,-93.684133 40.578012,-93.68422 40.578011,-93.686819 40.577971,-93.690051 40.577899,-93.690216 40.577902,-93.69035 40.5779,-93.694367 40.577841,-93.694461 40.57784,-93.699638 40.577798,-93.699862 40.577796,-93.720223 40.577629,-93.722386 40.577641,-93.72239 40.577641,-93.7224 40.577641,-93.722443 40.577641,-93.725671 40.577589,-93.725884 40.577586,-93.725893 40.577586,-93.725908 40.577586,-93.725923 40.577586,-93.725928 40.577586,-93.725929 40.577585,-93.725931 40.577585,-93.725933 40.577585,-93.725942 40.577585,-93.727214 40.577565,-93.728144 40.57755,-93.728355 40.577547,-93.737259 40.577542,-93.738236 40.577537,-93.741156 40.577525,-93.74182 40.577522,-93.742929 40.577516,-93.742978 40.577489,-93.742996 40.577477,-93.74306 40.577456,-93.74316 40.577448,-93.74324 40.577453,-93.743242 40.577453,-93.743244 40.577453,-93.743247 40.577453,-93.743811 40.577483,-93.743817 40.577483,-93.744285 40.577483,-93.745101 40.577507,-93.745215 40.57751,-93.745669 40.577524,-93.745674 40.577524,-93.74568 40.577524,-93.746218 40.57754,-93.747848 40.577567,-93.747866 40.577567,-93.749506 40.577593,-93.749515 40.577593,-93.750219 40.577605,-93.750225 40.577605,-93.750671 40.577612,-93.751901 40.577606,-93.751924 40.577606,-93.753676 40.577598,-93.757507 40.57758,-93.761462 40.577536,-93.76348 40.577519,-93.763485 40.577519,-93.765968 40.577498,-93.766777 40.577481,-93.76698 40.577489,-93.769341 40.577497,-93.770336 40.577507,-93.770348 40.577507,-93.770358 40.577507,-93.770366 40.577507,-93.770373 40.577507,-93.770378 40.577507,-93.770382 40.577507,-93.770386 40.577507,-93.770389 40.577507,-93.770391 40.577507,-93.770393 40.577507,-93.770395 40.577507,-93.770397 40.577507,-93.770399 40.577507,-93.770401 40.577507,-93.770403 40.577507,-93.774344 40.577548,-93.779954 40.577459,-93.780952 40.577437,-93.781204 40.577432,-93.781219 40.577432,-93.781242 40.577432,-93.781287 40.577431,-93.781391 40.577429,-93.781539 40.577426,-93.783462 40.57739,-93.783652 40.577367,-93.783817 40.577348,-93.783853 40.577344,-93.784062 40.577346,-93.784422 40.577349,-93.784451 40.577349,-93.784503 40.577349,-93.784606 40.57735,-93.784845 40.577352,-93.785302 40.577356,-93.786869 40.577369,-93.789408 40.577391,-93.801249 40.577338,-93.801374 40.577338,-93.802679 40.577334,-93.807953 40.577319,-93.815485 40.577277,-93.815718 40.577263,-93.815749 40.577237,-93.815805 40.577164,-93.816054 40.577124,-93.816667 40.57711,-93.817605 40.577104,-93.818666 40.577081,-93.818857 40.577096,-93.818861 40.577096,-93.819416 40.57714,-93.824774 40.577046,-93.831056 40.576936,-93.84093 40.576791,-93.843248 40.576758,-93.849243 40.576672,-93.853906 40.576605,-93.854319 40.576589,-93.855644 40.576589,-93.856105 40.576577,-93.856121 40.576577,-93.858219 40.576522,-93.859169 40.576505,-93.859461 40.576501,-93.860557 40.576486,-93.860919 40.576476,-93.860924 40.576476,-93.861316 40.576465,-93.861329 40.576465,-93.863007 40.57642,-93.863037 40.57642,-93.866407 40.576375,-93.868983 40.576356,-93.870646 40.576334,-93.871226 40.576332,-93.873322 40.576323,-93.875434 40.576298,-93.877604 40.576279,-93.877648 40.576279,-93.877923 40.576274,-93.880198 40.576233,-93.881885 40.57622,-93.88316 40.576191,-93.883985 40.576156,-93.885285 40.576137,-93.886648 40.576126,-93.887848 40.576088,-93.88851 40.576055,-93.889023 40.576022,-93.889048 40.576021,-93.889054 40.576021,-93.890535 40.575991,-93.89166 40.575983,-93.892448 40.575967,-93.893148 40.575933,-93.894155 40.575919,-93.894189 40.575919,-93.894856 40.57591,-93.895587 40.575905,-93.897491 40.575876,-93.897768 40.575865,-93.898175 40.575849,-93.898361 40.575827,-93.898437 40.575818,-93.899348 40.575799,-93.899542 40.575838,-93.899905 40.575845,-93.900855 40.575815,-93.900857 40.575815,-93.90128 40.575806,-93.902905 40.575793,-93.904643 40.57576,-93.905956 40.57574,-93.907992 40.575717,-93.908025 40.575717,-93.910894 40.575682,-93.911299 40.575671,-93.911336 40.57567,-93.913719 40.575603,-93.914179 40.575596,-93.914227 40.575595,-93.915319 40.575581,-93.915644 40.575597,-93.916132 40.575584,-93.916656 40.575551,-93.917069 40.575538,-93.919456 40.575481,-93.919891 40.575482,-93.919919 40.575482,-93.920482 40.575483,-93.921844 40.575472,-93.924232 40.575424,-93.925288 40.575395,-93.926232 40.57537,-93.926982 40.575354,-93.927521 40.57535,-93.927835 40.575347,-93.928382 40.575343,-93.929095 40.575347,-93.929695 40.575313,-93.930407 40.575298,-93.930826 40.575295,-93.931195 40.575292,-93.93392 40.57526,-93.934476 40.57525,-93.934489 40.57525,-93.934845 40.575243,-93.935445 40.575238,-93.935758 40.575227,-93.935769 40.575227,-93.936028 40.575219,-93.936111 40.575216,-93.936545 40.575201,-93.937106 40.575209,-93.937383 40.575213,-93.937644 40.575207,-93.93765 40.575207,-93.937675 40.575207,-93.93778 40.575205,-93.937989 40.575201,-93.938622 40.57519,-93.938631 40.57519,-93.938838 40.575186,-93.938954 40.575184,-93.938997 40.575183,-93.939024 40.575183,-93.939036 40.575183,-93.939207 40.57518,-93.939235 40.57518,-93.9395 40.575175,-93.939846 40.575186,-93.939856 40.575186,-93.939967 40.57519,-93.9404 40.575168,-93.940987 40.575164,-93.941425 40.57515,-93.942512 40.575142,-93.943 40.575138,-93.943562 40.575114,-93.9452 40.575081,-93.946087 40.575074,-93.946112 40.575074,-93.948088 40.575048,-93.949613 40.575017,-93.949643 40.575017,-93.950438 40.575019,-93.951688 40.57499,-93.954425 40.574949,-93.954551 40.574947,-93.955901 40.574936,-93.957689 40.574912,-93.958789 40.574893,-93.960989 40.574865,-93.962314 40.574835,-93.963743 40.574823,-93.963777 40.574823,-93.964827 40.574795,-93.966002 40.574785,-93.967965 40.574759,-93.970478 40.574718,-93.970515 40.574717,-93.972052 40.574687,-93.97279 40.574681,-93.973815 40.574663,-93.974516 40.57464,-93.974528 40.57464,-93.974621 40.574637,-93.974653 40.574637,-93.97519 40.574632,-93.97533 40.574628,-93.975338 40.574628,-93.975505 40.574623,-93.976115 40.574605,-93.976502 40.574602,-93.976667 40.574633,-93.97677 40.574635,-93.983283 40.574461,-93.987095 40.574364,-93.98743 40.57436,-94.000197 40.574335,-94.001512 40.574229,-94.001546 40.574226,-94.003323 40.574096,-94.011799 40.573961,-94.013902 40.573927,-94.014513 40.573924,-94.014629 40.573923,-94.014743 40.573922,-94.014847 40.573921,-94.015082 40.573918,-94.015492 40.573914))";



