/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.meshGeneration.util;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.minimizing.ConjugateGradient;
import java.io.Serializable;

public class AngleOptimization2D
implements RealFunctionOfSeveralVariablesWithGradient,
Serializable {
    double[] length;
    double[] cosAngle;
    double[] edge;
    boolean[] pointIsFix;
    int[] index;
    int numOfElements;
    int numOfPoints;
    double cosMinAngle = 0.5;
    int numOfEvaluations = 0;

    public AngleOptimization2D(int[] index, boolean[] pointIsFix) {
        this.index = index;
        this.pointIsFix = pointIsFix;
        this.numOfPoints = pointIsFix.length / 2;
        this.numOfElements = index.length / 3;
    }

    public static boolean[] pointIsFix(int[] index, int[] neighbour, int numOfPoints) {
        boolean[] pointIsFix = new boolean[numOfPoints];
        int numOfElements = index.length / 3;
        int i = 0;
        int k = 0;
        while (i < numOfElements) {
            int j = 0;
            while (j < 3) {
                if (neighbour[k + j] == -1) {
                    pointIsFix[index[k + (j + 1) % 3]] = true;
                    pointIsFix[index[k + (j + 2) % 3]] = true;
                }
                ++j;
            }
            ++i;
            k += 3;
        }
        return pointIsFix;
    }

    public AngleOptimization2D(int[] index, int[] neighbour, int numOfPoints) {
        this(index, AngleOptimization2D.pointIsFix(index, neighbour, numOfPoints));
    }

    public final double edge(int element, int local, int coord) {
        return this.edge[(element * 3 + local) * 2 + coord];
    }

    public void updateEdge(double[] point) {
        if (this.edge == null || this.edge.length != 6 * this.numOfElements) {
            this.edge = new double[6 * this.numOfElements];
        }
        int i = 0;
        int n = 0;
        while (i < this.numOfElements) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 2) {
                    this.edge[n++] = point[this.index[i * 3 + (j + 2) % 3] * 2 + k] - point[this.index[i * 3 + (j + 1) % 3] * 2 + k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public final double length(int element, int local) {
        return this.length[element * 3 + local];
    }

    public void updateLength() {
        if (this.length == null || this.length.length != 3 * this.numOfElements) {
            this.length = new double[3 * this.numOfElements];
        }
        int i = 0;
        int n = 0;
        while (i < this.numOfElements) {
            int j = 0;
            while (j < 3) {
                this.length[n++] = Math.sqrt(this.edge(i, j, 0) * this.edge(i, j, 0) + this.edge(i, j, 1) * this.edge(i, j, 1));
                ++j;
            }
            ++i;
        }
    }

    public double cosAngle(int element, int local) {
        return this.cosAngle[element * 3 + local];
    }

    public void updateCosAngle() {
        if (this.cosAngle == null || this.cosAngle.length != 3 * this.numOfElements) {
            this.cosAngle = new double[3 * this.numOfElements];
        }
        int i = 0;
        boolean n = false;
        while (i < this.numOfElements) {
            int j = 0;
            while (j < 3) {
                double a = this.length(i, (j + 2) % 3);
                double b = this.length(i, (j + 1) % 3);
                double c = this.length(i, j);
                this.cosAngle[i * 3 + j] = (a * a + b * b - c * c) / (2.0 * a * b);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public int getNumberOfVariables() {
        return this.numOfPoints * 2;
    }

    @Override
    public double eval(double[] p, double[] grad) {
        this.setDoubleArrayParameter(p, 0);
        this.getDoubleArrayValue(grad, 0);
        return this.getDoubleValue();
    }

    @Override
    public double eval(double[] p) {
        this.setDoubleArrayParameter(p, 0);
        return this.getDoubleValue();
    }

    public double getDoubleValue() {
        ++this.numOfEvaluations;
        double energie = 0.0;
        int i = 0;
        while (i < this.numOfElements) {
            int j = 0;
            while (j < 3) {
                double localForce = this.cosAngle(i, j) - this.cosMinAngle;
                if (localForce > 0.0) {
                    energie += localForce * localForce;
                }
                ++j;
            }
            ++i;
        }
        return energie / 2.0;
    }

    public int getDoubleArrayParameterLength() {
        return this.numOfPoints * 2;
    }

    public void setDoubleArrayParameter(double[] p, int offset) {
        if (offset != 0) {
            throw new RuntimeException("offset is not supported");
        }
        this.updateEdge(p);
        this.updateLength();
        this.updateCosAngle();
    }

    public int getDoubleArrayValueLength() {
        return this.numOfPoints * 2;
    }

    public void getDoubleArrayValue(double[] grad, int offset) {
        int maxIndex = offset + this.numOfPoints * 2;
        int i = offset;
        while (i < maxIndex) {
            grad[i] = 0.0;
            ++i;
        }
        int numOfElements = this.index.length / 3;
        int i2 = 0;
        while (i2 < numOfElements) {
            int j = 0;
            while (j < 3) {
                double localForce = this.cosAngle(i2, j) - this.cosMinAngle;
                if (localForce > 0.0) {
                    int thisVertex = this.index[3 * i2 + j];
                    int nextVertex = this.index[3 * i2 + (j + 1) % 3];
                    int prevVertex = this.index[3 * i2 + (j + 2) % 3];
                    double a = this.length(i2, (j + 2) % 3);
                    double b = this.length(i2, (j + 1) % 3);
                    double cFactor = localForce / (a * b);
                    double aFactor = (1.0 - this.cosAngle(i2, j) * b / a) * cFactor;
                    double bFactor = (1.0 - this.cosAngle(i2, j) * a / b) * cFactor;
                    int k = 0;
                    while (k < 2) {
                        int n = offset + nextVertex * 2 + k;
                        grad[n] = grad[n] + this.edge(i2, (j + 2) % 3, k) * aFactor;
                        int n2 = offset + thisVertex * 2 + k;
                        grad[n2] = grad[n2] - this.edge(i2, (j + 2) % 3, k) * aFactor;
                        int n3 = offset + thisVertex * 2 + k;
                        grad[n3] = grad[n3] + this.edge(i2, (j + 1) % 3, k) * bFactor;
                        int n4 = offset + prevVertex * 2 + k;
                        grad[n4] = grad[n4] - this.edge(i2, (j + 1) % 3, k) * bFactor;
                        int n5 = offset + prevVertex * 2 + k;
                        grad[n5] = grad[n5] - this.edge(i2, j, k) * cFactor;
                        int n6 = offset + nextVertex * 2 + k;
                        grad[n6] = grad[n6] + this.edge(i2, j, k) * cFactor;
                        ++k;
                    }
                }
                ++j;
            }
            ++i2;
        }
        this.nilFixedPoints(grad);
    }

    void nilFixedPoints(double[] grad) {
        int i = 0;
        int k = 0;
        while (i < this.numOfPoints) {
            if (this.pointIsFix[i]) {
                grad[k + 1] = 0.0;
                grad[k] = 0.0;
            }
            ++i;
            k += 2;
        }
    }

    public double getMinAngle(double[] p) {
        this.setDoubleArrayParameter(p, 0);
        double maxCosAngle = -1.0;
        int i = 0;
        int k = 0;
        while (i < this.numOfElements) {
            int j = 0;
            while (j < 3) {
                if (this.cosAngle[k] > maxCosAngle) {
                    maxCosAngle = this.cosAngle[k];
                }
                ++j;
                ++k;
            }
            ++i;
        }
        return Math.acos(maxCosAngle);
    }

    public static void minimize(double[] p, int[] index, int[] neighbour, double minAngle, int n, double ftol) {
        AngleOptimization2D f = new AngleOptimization2D(index, neighbour, p.length);
        f.cosMinAngle = Math.cos(minAngle / 180.0 * Math.PI);
        System.out.println("minimal angle before minimizing: " + f.getMinAngle(p) / Math.PI * 180.0);
        ConjugateGradient.search(p, ftol, f, n, false, null);
        System.out.println("number of evaluations : " + f.numOfEvaluations);
        System.out.println("minimal angle after minimizing:  " + f.getMinAngle(p) / Math.PI * 180.0);
    }

    public static boolean minimize(double[] p, int[] index, int[] neighbour, int n, double ftol) {
        AngleOptimization2D f = new AngleOptimization2D(index, neighbour, p.length);
        f.cosMinAngle = Math.cos(f.getMinAngle(p) + Math.PI / 180);
        double initMinAngle = f.getMinAngle(p) / Math.PI * 180.0;
        System.out.println("minimal angle before minimizing: " + initMinAngle);
        ConjugateGradient.search(p, ftol, f, n, false, null);
        double finalMinAngle = f.getMinAngle(p) / Math.PI * 180.0;
        System.out.println("minimal angle after minimizing:  " + finalMinAngle);
        return finalMinAngle - 0.1 > initMinAngle;
    }

    public static void minimize(double[] p, int[] index, int[] neighbour, int n, int m, double ftol) {
        int i = 0;
        while (i < m) {
            if (!AngleOptimization2D.minimize(p, index, neighbour, n, ftol)) break;
            ++i;
        }
    }
}

