/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

import de.jtem.numericalMethods.algebra.linear.decompose.Unmerge;

public class LR {
    public static double decompose(double[][] A) {
        int n = A.length;
        double det = 1.0;
        int i = 0;
        while (i < n) {
            int k;
            int k2 = i;
            while (k2 < n) {
                int j = 0;
                while (j < i) {
                    double[] dArray = A[i];
                    int n2 = k2;
                    dArray[n2] = dArray[n2] - A[i][j] * A[j][k2];
                    ++j;
                }
                ++k2;
            }
            double d = A[i][i];
            det *= d;
            if (d != 0.0) {
                k = i + 1;
                while (k < n) {
                    double s = 0.0;
                    int j = 0;
                    while (j < i) {
                        s += A[k][j] * A[j][i];
                        ++j;
                    }
                    A[k][i] = (A[k][i] - s) / d;
                    ++k;
                }
            } else {
                k = i + 1;
                while (k < n) {
                    A[k][i] = 0.0;
                    ++k;
                }
            }
            ++i;
        }
        return det;
    }

    public static double decompose(double[][] A, double[][] L, double[][] R) {
        int n = A.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                L[i][j] = A[i][j];
                ++j;
            }
            ++i;
        }
        double det = LR.decompose(L);
        Unmerge.triangular(L, R);
        return det;
    }

    public static double[] decompose(double[][] A_re, double[][] A_im) {
        int n = A_re.length;
        double[] det = new double[]{1.0, 0.0};
        int i = 0;
        while (i < n) {
            int k;
            int k2 = i;
            while (k2 < n) {
                double s_re = 0.0;
                double s_im = 0.0;
                int j = 0;
                while (j < i) {
                    double a_re = A_re[i][j];
                    double a_im = A_im[i][j];
                    double b_re = A_re[j][k2];
                    double b_im = A_im[j][k2];
                    s_re += a_re * b_re - a_im * b_im;
                    s_im += a_im * b_re + a_re * b_im;
                    ++j;
                }
                double[] dArray = A_re[i];
                int n2 = k2;
                dArray[n2] = dArray[n2] - s_re;
                double[] dArray2 = A_im[i];
                int n3 = k2++;
                dArray2[n3] = dArray2[n3] - s_im;
            }
            double d_re = A_re[i][i];
            double d_im = A_im[i][i];
            double d = det[0] * d_re - det[1] * d_im;
            det[1] = det[0] * d_im + det[1] * d_re;
            det[0] = d;
            d = d_re * d_re + d_im * d_im;
            if (d != 0.0) {
                k = i + 1;
                while (k < n) {
                    double s_re = 0.0;
                    double s_im = 0.0;
                    int j = 0;
                    while (j < i) {
                        double a_re = A_re[k][j];
                        double a_im = A_im[k][j];
                        double b_re = A_re[j][i];
                        double b_im = A_im[j][i];
                        s_re += a_re * b_re - a_im * b_im;
                        s_im += a_im * b_re + a_re * b_im;
                        ++j;
                    }
                    s_re = A_re[k][i] - s_re;
                    s_im = A_im[k][i] - s_im;
                    A_re[k][i] = (s_re * d_re + s_im * d_im) / d;
                    A_im[k][i] = (s_im * d_re - s_re * d_im) / d;
                    ++k;
                }
            } else {
                k = i + 1;
                while (k < n) {
                    A_re[k][i] = 0.0;
                    A_im[k][i] = 0.0;
                    ++k;
                }
            }
            ++i;
        }
        return det;
    }

    public static double[] decompose(double[][] A_re, double[][] A_im, double[][] L_re, double[][] L_im, double[][] R_re, double[][] R_im) {
        int n = A_re.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                L_re[i][j] = A_re[i][j];
                L_im[i][j] = A_im[i][j];
                ++j;
            }
            ++i;
        }
        double[] det = LR.decompose(L_re, L_im);
        Unmerge.triangular(L_re, L_im, R_re, R_im);
        return det;
    }
}

