/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear;

import de.jtem.numericalMethods.algebra.linear.VectorOperations;

public final class MatrixOperations {
    private MatrixOperations() {
    }

    public static final void times(double[][] ARe, double[][] AIm, double[][] BRe, double[][] BIm, double[][] CRe, double[][] CIm) {
        double[][] tmpARe = ARe == CRe || ARe == CIm ? MatrixOperations.copy(ARe) : ARe;
        double[][] tmpAIm = AIm == CRe || AIm == CIm ? MatrixOperations.copy(AIm) : AIm;
        double[][] tmpBRe = BRe == CRe || BRe == CIm ? MatrixOperations.copy(BRe) : BRe;
        double[][] tmpBIm = BIm == CRe || BIm == CIm ? MatrixOperations.copy(BIm) : BIm;
        int n = tmpBRe.length;
        int numRows = CRe.length;
        int numCols = CRe[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowARe = tmpARe[i];
            double[] rowAIm = tmpAIm[i];
            double[] rowRe = CRe[i];
            double[] rowIm = CIm[i];
            int j = 0;
            while (j < numCols) {
                double wRe = 0.0;
                double wIm = 0.0;
                int k = 0;
                while (k < n) {
                    wRe += rowARe[k] * tmpBRe[k][j] - rowAIm[k] * tmpBIm[k][j];
                    wIm += rowARe[k] * tmpBIm[k][j] + rowAIm[k] * tmpBRe[k][j];
                    ++k;
                }
                rowRe[j] = wRe;
                rowIm[j] = wIm;
                ++j;
            }
            ++i;
        }
    }

    public static final void times(int[][] A, int[][] B, int[][] C) {
        int[][] tmpB;
        int[][] tmpA;
        if (A == C) {
            tmpA = MatrixOperations.copy(C);
            tmpB = B != C ? B : tmpA;
        } else {
            tmpA = A;
            tmpB = B != C ? B : MatrixOperations.copy(C);
        }
        int n = tmpB.length;
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = tmpA[i];
            int[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                int sum = 0;
                int k = 0;
                while (k < n) {
                    sum += rowA[k] * tmpB[k][j];
                    ++k;
                }
                rowC[j] = sum;
                ++j;
            }
            ++i;
        }
    }

    public static final void times(double[][] A, double[][] B, double[][] C) {
        double[][] tmpB;
        double[][] tmpA;
        if (A == C) {
            tmpA = MatrixOperations.copy(C);
            tmpB = B != C ? B : tmpA;
        } else {
            tmpA = A;
            tmpB = B != C ? B : MatrixOperations.copy(C);
        }
        int n = tmpB.length;
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = tmpA[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                double sum = 0.0;
                int k = 0;
                while (k < n) {
                    sum += rowA[k] * tmpB[k][j];
                    ++k;
                }
                rowC[j] = sum;
                ++j;
            }
            ++i;
        }
    }

    public static final void times(int[][] A, double[][] B, double[][] C) {
        double[][] tmpB = B != C ? B : MatrixOperations.copy(C);
        int n = tmpB.length;
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                double sum = 0.0;
                int k = 0;
                while (k < n) {
                    sum += (double)rowA[k] * tmpB[k][j];
                    ++k;
                }
                rowC[j] = sum;
                ++j;
            }
            ++i;
        }
    }

    public static final void times(double[][] A, int[][] B, double[][] C) {
        double[][] tmpA = A != C ? A : MatrixOperations.copy(C);
        int n = B.length;
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = tmpA[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                double sum = 0.0;
                int k = 0;
                while (k < n) {
                    sum += rowA[k] * (double)B[k][j];
                    ++k;
                }
                rowC[j] = sum;
                ++j;
            }
            ++i;
        }
    }

    public static final void times(int[][] A, int[][] B, double[][] C) {
        int n = B.length;
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                double sum = 0.0;
                int k = 0;
                while (k < n) {
                    sum += (double)(rowA[k] * B[k][j]);
                    ++k;
                }
                rowC[j] = sum;
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(double[][] ARe, double[][] AIm, double bRe, double bIm, double[][] CRe, double[][] CIm) {
        double nn = bRe * bRe + bIm * bIm;
        int numRows = CRe.length;
        int numCols = CRe[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowMRe = ARe[i];
            double[] rowRe = CRe[i];
            double[] rowMIm = AIm[i];
            double[] rowIm = CIm[i];
            int j = 0;
            while (j < numCols) {
                double rr = rowMRe[j];
                double ii = rowMIm[j];
                rowRe[j] = (rr * bRe + ii * bIm) / nn;
                rowIm[j] = (ii * bRe - rr * bIm) / nn;
                ++j;
            }
            ++i;
        }
    }

    public static final void times(double[][] ARe, double[][] AIm, double bRe, double bIm, double[][] CRe, double[][] CIm) {
        int numRows = ARe.length;
        int numCols = ARe[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowRe = CRe[i];
            double[] rowIm = CIm[i];
            double[] rowReA = ARe[i];
            double[] rowImA = AIm[i];
            int j = 0;
            while (j < numCols) {
                double rr = rowReA[j];
                double ii = rowImA[j];
                rowRe[j] = rr * bRe - ii * bIm;
                rowIm[j] = rr * bIm + ii * bRe;
                ++j;
            }
            ++i;
        }
    }

    public static final void times(int[][] A, int b, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] * b;
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(int[][] A, int b, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] / b;
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(int[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = (double)rowA[j] / b;
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(int b, int[][] A, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = b / rowA[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(double b, double[][] A, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = b / rowA[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(double b, double[][] Are, double[][] Aim, double[][] Cre, double[][] Cim) {
        int numRows = Cre.length;
        int numCols = Cre[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowAre = Are[i];
            double[] rowCre = Cre[i];
            double[] rowAim = Aim[i];
            double[] rowCim = Cim[i];
            int j = 0;
            while (j < numCols) {
                double Re = rowAre[j];
                double Im = rowAim[j];
                double nn = Re * Re + Im * Im;
                if (nn == 0.0) {
                    rowCre[j] = b / nn;
                    rowCim[j] = 0.0;
                } else {
                    rowCre[j] = b * Re / nn;
                    rowCim[j] = -b * Im / nn;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(double b, int[][] A, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = b / (double)rowA[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void divide(double[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] / b;
                ++j;
            }
            ++i;
        }
    }

    public static final void times(double[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] * b;
                ++j;
            }
            ++i;
        }
    }

    public static final void times(int[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = (double)rowA[j] * b;
                ++j;
            }
            ++i;
        }
    }

    public static final void times(double[][] MRe, double[][] MIm, double[] VRe, double[] VIm, double[] WRe, double[] WIm) {
        double[] tmpVRe = VRe == WRe || VRe == WIm ? (double[])VRe.clone() : VRe;
        double[] tmpVIm = VIm == WRe || VIm == WIm ? (double[])VIm.clone() : VIm;
        int numOfRows = MRe.length;
        int numOfCols = MRe[0].length;
        int i = 0;
        while (i < numOfRows) {
            double re = 0.0;
            double im = 0.0;
            double[] rowRe = MRe[i];
            double[] rowIm = MIm[i];
            int j = 0;
            while (j < numOfCols) {
                re += rowRe[j] * tmpVRe[j] - rowIm[j] * tmpVIm[j];
                im += rowRe[j] * tmpVIm[j] + rowIm[j] * tmpVRe[j];
                ++j;
            }
            WRe[i] = re;
            WIm[i] = im;
            ++i;
        }
    }

    public static final void times(double[] VRe, double[] VIm, double[][] MRe, double[][] MIm, double[] WRe, double[] WIm) {
        int numOfRows = MRe.length;
        int numOfCols = MRe[0].length;
        int i = 0;
        while (i < numOfCols) {
            double thisRe = 0.0;
            double thisIm = 0.0;
            int j = 0;
            while (j < numOfRows) {
                thisRe += MRe[j][i] * VRe[j] - MIm[j][i] * VIm[j];
                thisIm += MRe[j][i] * VIm[j] + MIm[j][i] * VRe[j];
                ++j;
            }
            WRe[i] = thisRe;
            WIm[i] = thisIm;
            ++i;
        }
    }

    public static final void times(int[][] A, int[] b, int[] c) {
        int[] tmpB = b != c ? b : VectorOperations.copy(c);
        int n = b.length;
        int numRows = A.length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            int sum = 0;
            int j = 0;
            while (j < n) {
                sum += rowA[j] * tmpB[j];
                ++j;
            }
            c[i] = sum;
            ++i;
        }
    }

    public static final void times(int[][] A, int[] b, double[] c) {
        int n = b.length;
        int numRows = A.length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            int sum = 0;
            int j = 0;
            while (j < n) {
                sum += rowA[j] * b[j];
                ++j;
            }
            c[i] = sum;
            ++i;
        }
    }

    public static final void times(double[][] A, double[] b, double[] c) {
        double[] tmpB = b != c ? b : VectorOperations.copy(c);
        int n = b.length;
        int numRows = A.length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double sum = 0.0;
            int j = 0;
            while (j < n) {
                sum += rowA[j] * tmpB[j];
                ++j;
            }
            c[i] = sum;
            ++i;
        }
    }

    public static final void times(int[][] A, double[] b, double[] c) {
        double[] tmpB = b != c ? b : VectorOperations.copy(c);
        int n = b.length;
        int numRows = A.length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            double sum = 0.0;
            int j = 0;
            while (j < n) {
                sum += (double)rowA[j] * tmpB[j];
                ++j;
            }
            c[i] = sum;
            ++i;
        }
    }

    public static final void times(double[][] A, int[] b, double[] c) {
        int n = b.length;
        int numRows = A.length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double sum = 0.0;
            int j = 0;
            while (j < n) {
                sum += rowA[j] * (double)b[j];
                ++j;
            }
            c[i] = sum;
            ++i;
        }
    }

    public static final void times(int[] a, int[][] B, int[] c) {
        int[] tmpA = a != c ? a : VectorOperations.copy(c);
        int n = a.length;
        int numCols = c.length;
        int i = 0;
        while (i < numCols) {
            int sum = 0;
            int j = 0;
            while (j < n) {
                sum += tmpA[j] * B[j][i];
                ++j;
            }
            c[i] = sum;
            ++i;
        }
    }

    public static final void times(int[] a, int[][] B, double[] c) {
        int n = a.length;
        int numCols = c.length;
        int i = 0;
        while (i < numCols) {
            int sum = 0;
            int j = 0;
            while (j < n) {
                sum += a[j] * B[j][i];
                ++j;
            }
            c[i] = sum;
            ++i;
        }
    }

    public static final void times(double[] a, double[][] B, double[] c) {
        double[] tmpA = a != c ? a : VectorOperations.copy(c);
        int n = a.length;
        int numCols = c.length;
        int i = 0;
        while (i < numCols) {
            double sum = 0.0;
            int j = 0;
            while (j < n) {
                sum += tmpA[j] * B[j][i];
                ++j;
            }
            c[i] = sum;
            ++i;
        }
    }

    public static final void times(int[] a, double[][] B, double[] c) {
        int n = a.length;
        int numCols = c.length;
        int i = 0;
        while (i < numCols) {
            double sum = 0.0;
            int j = 0;
            while (j < n) {
                sum += (double)a[j] * B[j][i];
                ++j;
            }
            c[i] = sum;
            ++i;
        }
    }

    public static final void times(double[] a, int[][] B, double[] c) {
        double[] tmpA = a != c ? a : VectorOperations.copy(c);
        int n = a.length;
        int numCols = c.length;
        int i = 0;
        while (i < numCols) {
            double sum = 0.0;
            int j = 0;
            while (j < n) {
                sum += tmpA[j] * (double)B[j][i];
                ++j;
            }
            c[i] = sum;
            ++i;
        }
    }

    public static final void times(int[] a, int[] b, int[][] C) {
        int n = a.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                C[i][j] = a[i] * b[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void times(double[] a, double[] b, double[][] C) {
        int n = a.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                C[i][j] = a[i] * b[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void times(int[] a, double[] b, double[][] C) {
        int n = a.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                C[i][j] = (double)a[i] * b[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void times(double[] a, int[] b, double[][] C) {
        int n = a.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                C[i][j] = a[i] * (double)b[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void plus(int[][] A, int[][] B, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            int[] rowB = B[i];
            int[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] + rowB[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void plus(double[][] A, double[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double[] rowB = B[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] + rowB[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void plus(double[][] A, int[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            int[] rowB = B[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] + (double)rowB[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void plus(int[][] A, double[][] B, double[][] C) {
        MatrixOperations.plus(B, A, C);
    }

    public static final void plus(int[][] A, int b, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] + b;
                ++j;
            }
            ++i;
        }
    }

    public static final void plus(double[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] + b;
                ++j;
            }
            ++i;
        }
    }

    public static final void plus(int[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = (double)rowA[j] + b;
                ++j;
            }
            ++i;
        }
    }

    public static final void minus(int[][] A, int[][] B, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            int[] rowB = B[i];
            int[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] - rowB[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void minus(double[][] A, double[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double[] rowB = B[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] - rowB[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void minus(double[][] A, int[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            int[] rowB = B[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] - (double)rowB[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void minus(int[][] A, double[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            double[] rowB = B[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = (double)rowA[j] - rowB[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void minus(int[][] A, int b, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] - b;
                ++j;
            }
            ++i;
        }
    }

    public static final void minus(int a, int[][] B, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowB = B[i];
            int[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = a - rowB[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void minus(double[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] - b;
                ++j;
            }
            ++i;
        }
    }

    public static final void minus(double a, double[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowB = B[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = a - rowB[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void minus(int[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = (double)rowA[j] - b;
                ++j;
            }
            ++i;
        }
    }

    public static final void minus(int a, double[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowB = B[i];
            double[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = (double)a - rowB[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void assign(double[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        int i = 0;
        while (i < numRows) {
            System.arraycopy(A[i], 0, B[i], 0, numCols);
            ++i;
        }
    }

    public static final void assign(int[][] A, int[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        int i = 0;
        while (i < numRows) {
            System.arraycopy(A[i], 0, B[i], 0, numCols);
            ++i;
        }
    }

    public static final void assign(int[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            double[] rowB = B[i];
            int j = 0;
            while (j < numCols) {
                rowB[j] = rowA[j];
                ++j;
            }
            ++i;
        }
    }

    public static final int[][] copy(int[][] A) {
        int[][] cloneOfA = new int[A.length][A[0].length];
        MatrixOperations.assign(A, cloneOfA);
        return cloneOfA;
    }

    public static final double[][] copy(double[][] A) {
        double[][] cloneOfA = new double[A.length][A[0].length];
        MatrixOperations.assign(A, cloneOfA);
        return cloneOfA;
    }

    public static final void assign(double[][] A, double value) {
        int numRows = A.length;
        int numCols = A[0].length;
        double[] tmp = A[0];
        int j = 0;
        while (j < numCols) {
            tmp[j] = value;
            ++j;
        }
        int i = 1;
        while (i < numRows) {
            System.arraycopy(tmp, 0, A[i], 0, numCols);
            ++i;
        }
    }

    public static final void assign(int[][] A, int value) {
        int numRows = A.length;
        int numCols = A[0].length;
        int[] tmp = A[0];
        int j = 0;
        while (j < numCols) {
            tmp[j] = value;
            ++j;
        }
        int i = 1;
        while (i < numRows) {
            System.arraycopy(tmp, 0, A[i], 0, numCols);
            ++i;
        }
    }

    public static final void assignId(int[][] A) {
        int length = A.length;
        int[] tmp = new int[length];
        int i = 0;
        while (i < length) {
            int j = 0;
            while (j < length) {
                tmp = A[i];
                tmp[j] = i == j ? 1 : 0;
                ++j;
            }
            ++i;
        }
    }

    public static final void assignId(double[][] A) {
        int length = A.length;
        double[] tmp = new double[length];
        int i = 0;
        while (i < length) {
            int j = 0;
            while (j < length) {
                tmp = A[i];
                tmp[j] = i == j ? 1.0 : 0.0;
                ++j;
            }
            ++i;
        }
    }

    public static final void assignZero(int[][] A) {
        int numRows = A.length;
        int numCols = A[0].length;
        int[] tmp = A[0];
        int j = 0;
        while (j < numCols) {
            tmp[j] = 0;
            ++j;
        }
        int i = 1;
        while (i < numRows) {
            System.arraycopy(tmp, 0, A[i], 0, numCols);
            ++i;
        }
    }

    public static final void assignZero(double[][] A) {
        int numRows = A.length;
        int numCols = A[0].length;
        double[] tmp = A[0];
        int j = 0;
        while (j < numCols) {
            tmp[j] = 0.0;
            ++j;
        }
        int i = 1;
        while (i < numRows) {
            System.arraycopy(tmp, 0, A[i], 0, numCols);
            ++i;
        }
    }

    public static final void getDiagonal(int[][] A, int[] v) {
        int length = v.length;
        int i = 0;
        while (i < length) {
            v[i] = A[i][i];
            ++i;
        }
    }

    public static final void assignDiagonal(int[][] A, int[] v) {
        int length = v.length;
        int i = 0;
        while (i < length) {
            A[i][i] = v[i];
            ++i;
        }
    }

    public static final void assignDiagonal(int[][] A, int v) {
        int length = Math.min(A.length, A[0].length);
        int i = 0;
        while (i < length) {
            A[i][i] = v;
            ++i;
        }
    }

    public static final void assignDiagonal(double[][] A, double v) {
        int length = Math.min(A.length, A[0].length);
        int i = 0;
        while (i < length) {
            A[i][i] = v;
            ++i;
        }
    }

    public static final void assignDiagonal(double[][] A, double[] v) {
        int length = v.length;
        int i = 0;
        while (i < length) {
            A[i][i] = v[i];
            ++i;
        }
    }

    public static final void getDiagonal(double[][] A, double[] v) {
        int length = v.length;
        int i = 0;
        while (i < length) {
            v[i] = A[i][i];
            ++i;
        }
    }

    public static final void assignDiagonal(double[][] A, int[] v) {
        int length = v.length;
        int i = 0;
        while (i < length) {
            A[i][i] = v[i];
            ++i;
        }
    }

    public static final void assignRow(int[][] A, int[] v, int rowNum) {
        System.arraycopy(v, 0, A[rowNum], 0, v.length);
    }

    public static final void getRow(int[][] A, int[] v, int rowNum) {
        System.arraycopy(A[rowNum], 0, v, 0, v.length);
    }

    public static final void getRow(double[][] A, double[] v, int rowNum) {
        System.arraycopy(A[rowNum], 0, v, 0, v.length);
    }

    public static final void assignRow(double[][] A, double[] v, int rowNum) {
        System.arraycopy(v, 0, A[rowNum], 0, v.length);
    }

    public static final void assignRow(double[][] A, int[] v, int rowNum) {
        int l = v.length;
        double[] row = A[rowNum];
        int i = 0;
        while (i < l) {
            row[i] = v[i];
            ++i;
        }
    }

    public static final void assignCol(int[][] A, int[] v, int colNum) {
        int l = v.length;
        int i = 0;
        while (i < l) {
            A[i][colNum] = v[i];
            ++i;
        }
    }

    public static final void getCol(int[][] A, int[] v, int colNum) {
        int l = v.length;
        int i = 0;
        while (i < l) {
            v[i] = A[i][colNum];
            ++i;
        }
    }

    public static final void getCol(double[][] A, double[] v, int colNum) {
        int l = v.length;
        int i = 0;
        while (i < l) {
            v[i] = A[i][colNum];
            ++i;
        }
    }

    public static final void assignCol(double[][] A, double[] v, int colNum) {
        int l = v.length;
        int i = 0;
        while (i < l) {
            A[i][colNum] = v[i];
            ++i;
        }
    }

    public static final void assignCol(double[][] A, int[] v, int colNum) {
        int l = v.length;
        int i = 0;
        while (i < l) {
            A[i][colNum] = v[i];
            ++i;
        }
    }

    public static final void round(double[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double[] rowB = B[i];
            int j = 0;
            while (j < numCols) {
                rowB[j] = Math.floor(rowA[j] + 0.5);
                ++j;
            }
            ++i;
        }
    }

    public static final void round(double[][] A, int[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            int[] rowB = B[i];
            int j = 0;
            while (j < numCols) {
                rowB[j] = (int)Math.floor(rowA[j] + 0.5);
                ++j;
            }
            ++i;
        }
    }

    public static final void floor(double[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double[] rowB = B[i];
            int j = 0;
            while (j < numCols) {
                rowB[j] = Math.floor(rowA[j]);
                ++j;
            }
            ++i;
        }
    }

    public static final void floor(double[][] A, int[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            int[] rowB = B[i];
            int j = 0;
            while (j < numCols) {
                rowB[j] = (int)Math.floor(rowA[j]);
                ++j;
            }
            ++i;
        }
    }

    public static final void neg(int[][] A, int[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            int[] rowB = B[i];
            int j = 0;
            while (j < numCols) {
                rowB[j] = -rowA[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void neg(double[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowA = A[i];
            double[] rowB = B[i];
            int j = 0;
            while (j < numCols) {
                rowB[j] = -rowA[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void neg(int[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            double[] rowB = B[i];
            int j = 0;
            while (j < numCols) {
                rowB[j] = -rowA[j];
                ++j;
            }
            ++i;
        }
    }

    public static final void mod(int[][] A, int b, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            int j = 0;
            while (j < numCols) {
                rowC[j] = rowA[j] % b;
                ++j;
            }
            ++i;
        }
    }

    public static final double normSqr(int[][] re) {
        int res = 0;
        int numRows = re.length;
        int numCols = re[0].length;
        int i = 0;
        while (i < numRows) {
            int[] rowRe = re[i];
            int j = 0;
            while (j < numCols) {
                res += rowRe[j] * rowRe[j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static final double normSqr(double[][] re) {
        double res = 0.0;
        int numRows = re.length;
        int numCols = re[0].length;
        int i = 0;
        while (i < numRows) {
            double[] rowRe = re[i];
            int j = 0;
            while (j < numCols) {
                res += rowRe[j] * rowRe[j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static final int[] maxAbs(double[][] re) {
        int r = re.length;
        int c = re[0].length;
        int[] pos = new int[2];
        double max = 0.0;
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                double abs = re[i][j] * re[i][j];
                if (abs > max) {
                    max = abs;
                    pos[0] = i;
                    pos[1] = j;
                }
                ++j;
            }
            ++i;
        }
        return pos;
    }

    public static final int[] maxAbs(double[][] re, double[][] im) {
        int r = re.length;
        int c = re[0].length;
        int[] pos = new int[2];
        double max = 0.0;
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                double abs = re[i][j] * re[i][j] + im[i][j] * im[i][j];
                if (abs > max) {
                    max = abs;
                    pos[0] = i;
                    pos[1] = j;
                }
                ++j;
            }
            ++i;
        }
        return pos;
    }

    public static final void transpose(int[][] m, int[][] trans) {
        int numRows = trans.length;
        if (m == trans) {
            int i = 0;
            while (i < numRows) {
                int j = 0;
                while (j < i) {
                    int tmp = m[i][j];
                    m[i][j] = m[j][i];
                    m[j][i] = tmp;
                    ++j;
                }
                ++i;
            }
        } else {
            int numCols = trans[0].length;
            int i = 0;
            while (i < numRows) {
                int[] rowRe = trans[i];
                int j = 0;
                while (j < numCols) {
                    rowRe[j] = m[j][i];
                    ++j;
                }
                ++i;
            }
        }
    }

    public static final void transpose(double[][] m, double[][] trans) {
        int numRows = trans.length;
        if (m == trans) {
            int i = 0;
            while (i < numRows) {
                int j = 0;
                while (j < i) {
                    double tmp = m[i][j];
                    m[i][j] = m[j][i];
                    m[j][i] = tmp;
                    ++j;
                }
                ++i;
            }
        } else {
            int numCols = trans[0].length;
            int i = 0;
            while (i < numRows) {
                double[] rowRe = trans[i];
                int j = 0;
                while (j < numCols) {
                    rowRe[j] = m[j][i];
                    ++j;
                }
                ++i;
            }
        }
    }

    public static final void random(double[][] m) {
        int numRows = m.length;
        int numCols = m[0].length;
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                m[i][j] = 2.0 * Math.random() - 1.0;
                ++j;
            }
            ++i;
        }
    }

    public static final void random(int[][] m, int range) {
        int numRows = m.length;
        int numCols = m[0].length;
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                m[i][j] = (int)Math.random() * range;
                ++j;
            }
            ++i;
        }
    }

    public static boolean isRectangular(int[][] m) {
        if (m.length == 0) {
            return true;
        }
        int numCols = m[0].length;
        int numRows = m.length;
        int i = 1;
        while (i < numRows) {
            if (m[i] == null || m[i].length != numCols) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isRectangular(double[][] m) {
        if (m.length == 0) {
            return true;
        }
        int numCols = m[0].length;
        int numRows = m.length;
        int i = 1;
        while (i < numRows) {
            if (m[i] == null || m[i].length != numCols) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

