/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve;

import com.jogamp.graph.curve.tess.Triangulation;
import com.jogamp.graph.curve.tess.Triangulator;
import com.jogamp.graph.geom.Outline;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;
import java.util.Collections;

public class OutlineShape
implements Comparable<OutlineShape> {
    public static final int DIRTY_BOUNDS = 1;
    private final Vertex.Factory<? extends Vertex> vertexFactory;
    private VerticesState outlineState;
    private ArrayList<Outline> outlines;
    private AABBox bbox;
    private int dirtyBits;

    public OutlineShape(Vertex.Factory<? extends Vertex> factory) {
        this.vertexFactory = factory;
        this.outlines = new ArrayList(3);
        this.outlines.add(new Outline());
        this.outlineState = VerticesState.UNDEFINED;
        this.bbox = new AABBox();
        this.dirtyBits = 0;
    }

    public void clear() {
        this.outlines.clear();
        this.outlines.add(new Outline());
        this.outlineState = VerticesState.UNDEFINED;
        this.bbox.reset();
        this.dirtyBits = 0;
    }

    public final Vertex.Factory<? extends Vertex> vertexFactory() {
        return this.vertexFactory;
    }

    public int getOutlineNumber() {
        return this.outlines.size();
    }

    public void addEmptyOutline() {
        if (!this.getLastOutline().isEmpty()) {
            this.outlines.add(new Outline());
        }
    }

    public void addOutline(Outline outline) throws NullPointerException {
        this.addOutline(this.outlines.size(), outline);
    }

    public void addOutline(int n, Outline outline) throws NullPointerException, IndexOutOfBoundsException {
        if (null == outline) {
            throw new NullPointerException("outline is null");
        }
        if (this.outlines.size() == n) {
            Outline outline2 = this.getLastOutline();
            if (outline.isEmpty() && outline2.isEmpty()) {
                return;
            }
            if (outline2.isEmpty()) {
                this.outlines.set(n - 1, outline);
                if (0 == (this.dirtyBits & 1)) {
                    this.bbox.resize(outline.getBounds());
                }
                return;
            }
        }
        this.outlines.add(n, outline);
        if (0 == (this.dirtyBits & 1)) {
            this.bbox.resize(outline.getBounds());
        }
    }

    public void addOutlineShape(OutlineShape outlineShape) throws NullPointerException {
        if (null == outlineShape) {
            throw new NullPointerException("OutlineShape is null");
        }
        this.closeLastOutline();
        for (int i = 0; i < outlineShape.getOutlineNumber(); ++i) {
            this.addOutline(outlineShape.getOutline(i));
        }
    }

    public void setOutline(int n, Outline outline) throws NullPointerException, IndexOutOfBoundsException {
        if (null == outline) {
            throw new NullPointerException("outline is null");
        }
        this.outlines.set(n, outline);
        this.dirtyBits |= 1;
    }

    public final Outline removeOutline(int n) throws IndexOutOfBoundsException {
        this.dirtyBits |= 1;
        return this.outlines.remove(n);
    }

    public final Outline getLastOutline() {
        return this.outlines.get(this.outlines.size() - 1);
    }

    public Outline getOutline(int n) throws IndexOutOfBoundsException {
        return this.outlines.get(n);
    }

    public final void addVertex(Vertex vertex) {
        Outline outline = this.getLastOutline();
        outline.addVertex(vertex);
        if (0 == (this.dirtyBits & 1)) {
            this.bbox.resize(outline.getBounds());
        }
    }

    public final void addVertex(int n, Vertex vertex) {
        Outline outline = this.getLastOutline();
        outline.addVertex(n, vertex);
        if (0 == (this.dirtyBits & 1)) {
            this.bbox.resize(outline.getBounds());
        }
    }

    public final void addVertex(float f, float f2, boolean bl) {
        this.addVertex(this.vertexFactory.create(f, f2, 0.0f, bl));
    }

    public final void addVertex(float f, float f2, float f3, boolean bl) {
        this.addVertex(this.vertexFactory.create(f, f2, f3, bl));
    }

    public final void addVertex(float[] fArray, int n, int n2, boolean bl) {
        this.addVertex(this.vertexFactory.create(fArray, n, n2, bl));
    }

    public void closeLastOutline() {
        this.getLastOutline().setClosed(true);
    }

    public final VerticesState getOutlineState() {
        return this.outlineState;
    }

    public void transformOutlines(VerticesState verticesState) {
        if (this.outlineState != verticesState) {
            if (verticesState == VerticesState.QUADRATIC_NURBS) {
                this.transformOutlines2Quadratic();
                this.checkOverlaps();
            } else {
                throw new IllegalStateException("destinationType " + verticesState.name() + " not supported (currently " + this.outlineState.name() + ")");
            }
        }
    }

    private void subdivideTriangle(Outline outline, Vertex vertex, Vertex vertex2, Vertex vertex3, int n) {
        float[] fArray = VectorUtil.mid(vertex.getCoord(), vertex2.getCoord());
        float[] fArray2 = VectorUtil.mid(vertex2.getCoord(), vertex3.getCoord());
        float[] fArray3 = VectorUtil.mid(fArray, fArray2);
        vertex2.setCoord(fArray3, 0, 3);
        vertex2.setOnCurve(true);
        outline.addVertex(n, this.vertexFactory.create(fArray, 0, 3, false));
        outline.addVertex(n + 2, this.vertexFactory.create(fArray2, 0, 3, false));
    }

    private void checkOverlaps() {
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>(3);
        int n = this.getOutlineNumber();
        boolean bl = true;
        do {
            for (int i = 0; i < n; ++i) {
                Outline outline = this.getOutline(i);
                int n2 = outline.getVertexCount();
                for (int j = 0; j < outline.getVertexCount(); ++j) {
                    Vertex vertex = outline.getVertex(j);
                    if (vertex.isOnCurve()) continue;
                    Vertex vertex2 = outline.getVertex((j + 1) % n2);
                    Vertex vertex3 = outline.getVertex((j + n2 - 1) % n2);
                    Vertex vertex4 = null;
                    if (bl) {
                        vertex4 = this.checkTriOverlaps(vertex3, vertex, vertex2);
                    }
                    if (!arrayList.contains(vertex) && vertex4 == null) continue;
                    arrayList.remove(vertex);
                    this.subdivideTriangle(outline, vertex3, vertex, vertex2, j);
                    j += 3;
                    n2 += 2;
                    if (vertex4 == null || vertex4.isOnCurve() || arrayList.contains(vertex4)) continue;
                    arrayList.add(vertex4);
                }
            }
            bl = false;
        } while (!arrayList.isEmpty());
    }

    private Vertex checkTriOverlaps(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        int n = this.getOutlineNumber();
        for (int i = 0; i < n; ++i) {
            Outline outline = this.getOutline(i);
            int n2 = outline.getVertexCount();
            for (int j = 0; j < n2; ++j) {
                Vertex vertex4 = outline.getVertex(j);
                if (vertex4.isOnCurve() || vertex4 == vertex || vertex4 == vertex2 || vertex4 == vertex3) continue;
                Vertex vertex5 = outline.getVertex((j + 1) % n2);
                Vertex vertex6 = outline.getVertex((j + n2 - 1) % n2);
                if (vertex6 == vertex3 || vertex5 == vertex) continue;
                if (VectorUtil.vertexInTriangle(vertex.getCoord(), vertex2.getCoord(), vertex3.getCoord(), vertex4.getCoord()) || VectorUtil.vertexInTriangle(vertex.getCoord(), vertex2.getCoord(), vertex3.getCoord(), vertex5.getCoord()) || VectorUtil.vertexInTriangle(vertex.getCoord(), vertex2.getCoord(), vertex3.getCoord(), vertex6.getCoord())) {
                    return vertex4;
                }
                if (!VectorUtil.tri2SegIntersection(vertex, vertex2, vertex3, vertex6, vertex4) && !VectorUtil.tri2SegIntersection(vertex, vertex2, vertex3, vertex4, vertex5) && !VectorUtil.tri2SegIntersection(vertex, vertex2, vertex3, vertex6, vertex5)) continue;
                return vertex4;
            }
        }
        return null;
    }

    private void transformOutlines2Quadratic() {
        int n = this.getOutlineNumber();
        for (int i = 0; i < n; ++i) {
            Outline outline = this.getOutline(i);
            int n2 = outline.getVertexCount();
            for (int j = 0; j < n2; ++j) {
                Vertex vertex = outline.getVertex(j);
                Vertex vertex2 = outline.getVertex((j + 1) % n2);
                if (vertex.isOnCurve() || vertex2.isOnCurve()) continue;
                float[] fArray = VectorUtil.mid(vertex.getCoord(), vertex2.getCoord());
                Vertex vertex3 = this.vertexFactory.create(fArray, 0, 3, true);
                ++n2;
                outline.addVertex(++j, vertex3);
            }
            if (n2 <= 0) {
                this.outlines.remove(outline);
                --i;
                --n;
                continue;
            }
            if (n2 <= 0 || !VectorUtil.checkEquality(outline.getVertex(0).getCoord(), outline.getLastVertex().getCoord())) continue;
            outline.removeVertex(n2 - 1);
        }
        this.outlineState = VerticesState.QUADRATIC_NURBS;
    }

    private void generateVertexIds() {
        int n = 0;
        for (int i = 0; i < this.outlines.size(); ++i) {
            ArrayList<Vertex> arrayList = this.outlines.get(i).getVertices();
            for (int j = 0; j < arrayList.size(); ++j) {
                Vertex vertex = arrayList.get(j);
                vertex.setId(n);
                ++n;
            }
        }
    }

    public ArrayList<Vertex> getVertices() {
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        for (int i = 0; i < this.outlines.size(); ++i) {
            arrayList.addAll(this.outlines.get(i).getVertices());
        }
        return arrayList;
    }

    public ArrayList<Triangle> triangulate() {
        if (this.outlines.size() == 0) {
            return null;
        }
        this.sortOutlines();
        this.generateVertexIds();
        Triangulator triangulator = Triangulation.create();
        for (int i = 0; i < this.outlines.size(); ++i) {
            triangulator.addCurve(this.outlines.get(i));
        }
        ArrayList<Triangle> arrayList = triangulator.generate();
        triangulator.reset();
        return arrayList;
    }

    private void sortOutlines() {
        Collections.sort(this.outlines);
        Collections.reverse(this.outlines);
    }

    @Override
    public final int compareTo(OutlineShape outlineShape) {
        float f;
        float f2 = this.getBounds().getSize();
        if (f2 < (f = outlineShape.getBounds().getSize())) {
            return -1;
        }
        if (f2 > f) {
            return 1;
        }
        return 0;
    }

    private final void validateBoundingBox() {
        this.dirtyBits &= 0xFFFFFFFE;
        this.bbox.reset();
        for (int i = 0; i < this.outlines.size(); ++i) {
            this.bbox.resize(this.outlines.get(i).getBounds());
        }
    }

    public final AABBox getBounds() {
        if (0 == (this.dirtyBits & 1)) {
            this.validateBoundingBox();
        }
        return this.bbox;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof OutlineShape)) {
            return false;
        }
        OutlineShape outlineShape = (OutlineShape)object;
        if (this.getOutlineState() != outlineShape.getOutlineState()) {
            return false;
        }
        if (this.getOutlineNumber() != outlineShape.getOutlineNumber()) {
            return false;
        }
        if (!this.getBounds().equals(outlineShape.getBounds())) {
            return false;
        }
        for (int i = this.getOutlineNumber() - 1; i >= 0; --i) {
            if (this.getOutline(i).equals(outlineShape.getOutline(i))) continue;
            return false;
        }
        return true;
    }

    public static enum VerticesState {
        UNDEFINED(0),
        QUADRATIC_NURBS(1);

        public final int state;

        private VerticesState(int n2) {
            this.state = n2;
        }
    }
}

